/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementBase;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.name.JvmNames;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/SynchronizedAnnotationOnLambdaChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "()V", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend.java"})
public final class SynchronizedAnnotationOnLambdaChecker
implements AdditionalAnnotationChecker {
    @NotNull
    public static final SynchronizedAnnotationOnLambdaChecker INSTANCE = new SynchronizedAnnotationOnLambdaChecker();

    private SynchronizedAnnotationOnLambdaChecker() {
    }

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace, @Nullable KtAnnotated annotated, @NotNull LanguageVersionSettings languageVersionSettings) {
        Object v1;
        block5: {
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            Intrinsics.checkNotNullParameter(actualTargets, (String)"actualTargets");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            if (entries.isEmpty()) {
                return;
            }
            Iterable iterable = entries;
            for (Object t : iterable) {
                KtAnnotationEntry it = (KtAnnotationEntry)t;
                boolean bl = false;
                AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, it);
                if (!Intrinsics.areEqual((Object)(annotationDescriptor != null ? annotationDescriptor.getFqName() : null), (Object)JvmNames.SYNCHRONIZED_ANNOTATION_FQ_NAME)) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        KtAnnotationEntry ktAnnotationEntry = v1;
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotation2 = ktAnnotationEntry;
        KtAnnotated ktAnnotated = annotated;
        PsiElement psiElement = ktAnnotated != null ? PsiUtilsKt.unwrapParenthesesLabelsAndAnnotations(ktAnnotated) : null;
        ElementBase elementBase = psiElement instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement : null;
        if (elementBase == null || (elementBase = elementBase.getFunctionLiteral()) == null) {
            return;
        }
        ElementBase literal = elementBase;
        DeclarationDescriptor descriptor2 = trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, literal);
        if (descriptor2 instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor2).isSuspend()) {
            trace.report(ErrorsJvm.SYNCHRONIZED_ON_SUSPEND.on(languageVersionSettings, annotation2));
        }
    }
}

