#pragma once
#include <QObject>
#include <memory>

#include "minecraft/auth/AuthStep.h"
#include "net/Upload.h"

class LauncherLoginStep : public AuthStep {
    Q_OBJECT

   public:
    explicit LauncherLoginStep(AccountData* data);
    virtual ~LauncherLoginStep() noexcept = default;

    void perform() override;

    QString describe() override;

   private slots:
    void onRequestDone();

   private:
    std::shared_ptr<QByteArray> m_response;
    Net::Upload::Ptr m_task;
};
