// This code was autogenerated by ./tools/ppc-table-gen. Do not modify!
// clang-format off
#include <cstdint>
#include <cstdlib>

#include "xenia/base/assert.h"
#include "xenia/cpu/ppc/ppc_decode_data.h"
#include "xenia/cpu/ppc/ppc_opcode.h"
#include "xenia/cpu/ppc/ppc_opcode_disasm.h"
#include "xenia/cpu/ppc/ppc_opcode_info.h"

namespace xe {
namespace cpu {
namespace ppc {

void PrintDisasm_addcx(const PPCDecodeData& d, StringBuffer* str) {
  // addc[OE][Rc] [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("addc");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RB());
}
void PrintDisasm_addex(const PPCDecodeData& d, StringBuffer* str) {
  // adde[OE][Rc] [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("adde");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RB());
}
void PrintDisasm_addi(const PPCDecodeData& d, StringBuffer* str) {
  // addi [RD], [RA0], [SIMM]
  size_t str_start = str->length();
  str->Append("addi");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.D.RA0());
  str->Append(", ");
  str->AppendFormat(d.D.SIMM() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.SIMM()));
}
void PrintDisasm_addic(const PPCDecodeData& d, StringBuffer* str) {
  // addic [RD], [RA], [SIMM]
  size_t str_start = str->length();
  str->Append("addic");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(", ");
  str->AppendFormat(d.D.SIMM() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.SIMM()));
}
void PrintDisasm_addicx(const PPCDecodeData& d, StringBuffer* str) {
  // addic. [RD], [RA], [SIMM]
  size_t str_start = str->length();
  str->Append("addic.");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(", ");
  str->AppendFormat(d.D.SIMM() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.SIMM()));
}
void PrintDisasm_addis(const PPCDecodeData& d, StringBuffer* str) {
  // addis [RD], [RA0], [SIMM]
  size_t str_start = str->length();
  str->Append("addis");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.D.RA0());
  str->Append(", ");
  str->AppendFormat(d.D.SIMM() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.SIMM()));
}
void PrintDisasm_addmex(const PPCDecodeData& d, StringBuffer* str) {
  // addme[OE][Rc] [RD], [RA]
  size_t str_start = str->length();
  str->Append("addme");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
}
void PrintDisasm_addx(const PPCDecodeData& d, StringBuffer* str) {
  // add[OE][Rc] [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("add");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RB());
}
void PrintDisasm_addzex(const PPCDecodeData& d, StringBuffer* str) {
  // addze[OE][Rc] [RD], [RA]
  size_t str_start = str->length();
  str->Append("addze");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
}
void PrintDisasm_andcx(const PPCDecodeData& d, StringBuffer* str) {
  // andc[Rc] [RA], [RS], [RB]
  size_t str_start = str->length();
  str->Append("andc");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_andisx(const PPCDecodeData& d, StringBuffer* str) {
  // andis. [RA], [RS], [UIMM]
  size_t str_start = str->length();
  str->Append("andis.");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.D.RS());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.D.UIMM());
}
void PrintDisasm_andix(const PPCDecodeData& d, StringBuffer* str) {
  // andi. [RA], [RS], [UIMM]
  size_t str_start = str->length();
  str->Append("andi.");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.D.RS());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.D.UIMM());
}
void PrintDisasm_andx(const PPCDecodeData& d, StringBuffer* str) {
  // and[Rc] [RA], [RS], [RB]
  size_t str_start = str->length();
  str->Append("and");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_bcctrx(const PPCDecodeData& d, StringBuffer* str) {
  // bcctr[LK] [BO], [BI]
  size_t str_start = str->length();
  str->Append("bcctr");
  if (d.XL.LK()) str->Append('l');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("{}", d.XL.BO());
  str->Append(", ");
  str->AppendFormat("{}", d.XL.BI());
}
void PrintDisasm_bclrx(const PPCDecodeData& d, StringBuffer* str) {
  // bclr[LK] [BO], [BI]
  size_t str_start = str->length();
  str->Append("bclr");
  if (d.XL.LK()) str->Append('l');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("{}", d.XL.BO());
  str->Append(", ");
  str->AppendFormat("{}", d.XL.BI());
}
void PrintDisasm_bx(const PPCDecodeData& d, StringBuffer* str) {
  // b[LK][AA] [ADDR]
  size_t str_start = str->length();
  str->Append("b");
  if (d.I.LK()) str->Append('l');
  if (d.I.AA()) str->Append('a');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("0x{:X}", d.I.ADDR());
}
void PrintDisasm_cmp(const PPCDecodeData& d, StringBuffer* str) {
  // cmp [CRFD], [L], [RA], [RB]
  size_t str_start = str->length();
  str->Append("cmp");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crf{}", d.X.CRFD());
  str->Append(", ");
  str->AppendFormat("{}", d.X.L());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_cmpi(const PPCDecodeData& d, StringBuffer* str) {
  // cmpi [CRFD], [L], [RA], [SIMM]
  size_t str_start = str->length();
  str->Append("cmpi");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crf{}", d.D.CRFD());
  str->Append(", ");
  str->AppendFormat("{}", d.D.L());
  str->Append(", ");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(", ");
  str->AppendFormat(d.D.SIMM() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.SIMM()));
}
void PrintDisasm_cmpl(const PPCDecodeData& d, StringBuffer* str) {
  // cmpl [CRFD], [L], [RA], [RB]
  size_t str_start = str->length();
  str->Append("cmpl");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crf{}", d.X.CRFD());
  str->Append(", ");
  str->AppendFormat("{}", d.X.L());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_cmpli(const PPCDecodeData& d, StringBuffer* str) {
  // cmpli [CRFD], [L], [RA], [UIMM]
  size_t str_start = str->length();
  str->Append("cmpli");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crf{}", d.D.CRFD());
  str->Append(", ");
  str->AppendFormat("{}", d.D.L());
  str->Append(", ");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.D.UIMM());
}
void PrintDisasm_cntlzdx(const PPCDecodeData& d, StringBuffer* str) {
  // cntlzd [RA], [RS]
  size_t str_start = str->length();
  str->Append("cntlzd");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
}
void PrintDisasm_cntlzwx(const PPCDecodeData& d, StringBuffer* str) {
  // cntlzw[Rc] [RA], [RS]
  size_t str_start = str->length();
  str->Append("cntlzw");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
}
void PrintDisasm_crand(const PPCDecodeData& d, StringBuffer* str) {
  // crand [CRBD], [CRBA], [CRBB]
  size_t str_start = str->length();
  str->Append("crand");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crb{}", d.XL.CRBD());
  str->Append(", ");
  str->AppendFormat("crb{}", d.XL.CRBA());
  str->Append(", ");
  str->AppendFormat("crb{}", d.XL.CRBB());
}
void PrintDisasm_crandc(const PPCDecodeData& d, StringBuffer* str) {
  // crandc [CRBD], [CRBA], [CRBB]
  size_t str_start = str->length();
  str->Append("crandc");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crb{}", d.XL.CRBD());
  str->Append(", ");
  str->AppendFormat("crb{}", d.XL.CRBA());
  str->Append(", ");
  str->AppendFormat("crb{}", d.XL.CRBB());
}
void PrintDisasm_creqv(const PPCDecodeData& d, StringBuffer* str) {
  // creqv [CRBD], [CRBA], [CRBB]
  size_t str_start = str->length();
  str->Append("creqv");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crb{}", d.XL.CRBD());
  str->Append(", ");
  str->AppendFormat("crb{}", d.XL.CRBA());
  str->Append(", ");
  str->AppendFormat("crb{}", d.XL.CRBB());
}
void PrintDisasm_crnand(const PPCDecodeData& d, StringBuffer* str) {
  // crnand [CRBD], [CRBA], [CRBB]
  size_t str_start = str->length();
  str->Append("crnand");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crb{}", d.XL.CRBD());
  str->Append(", ");
  str->AppendFormat("crb{}", d.XL.CRBA());
  str->Append(", ");
  str->AppendFormat("crb{}", d.XL.CRBB());
}
void PrintDisasm_crnor(const PPCDecodeData& d, StringBuffer* str) {
  // crnor [CRBD], [CRBA], [CRBB]
  size_t str_start = str->length();
  str->Append("crnor");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crb{}", d.XL.CRBD());
  str->Append(", ");
  str->AppendFormat("crb{}", d.XL.CRBA());
  str->Append(", ");
  str->AppendFormat("crb{}", d.XL.CRBB());
}
void PrintDisasm_cror(const PPCDecodeData& d, StringBuffer* str) {
  // cror [CRBD], [CRBA], [CRBB]
  size_t str_start = str->length();
  str->Append("cror");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crb{}", d.XL.CRBD());
  str->Append(", ");
  str->AppendFormat("crb{}", d.XL.CRBA());
  str->Append(", ");
  str->AppendFormat("crb{}", d.XL.CRBB());
}
void PrintDisasm_crorc(const PPCDecodeData& d, StringBuffer* str) {
  // crorc [CRBD], [CRBA], [CRBB]
  size_t str_start = str->length();
  str->Append("crorc");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crb{}", d.XL.CRBD());
  str->Append(", ");
  str->AppendFormat("crb{}", d.XL.CRBA());
  str->Append(", ");
  str->AppendFormat("crb{}", d.XL.CRBB());
}
void PrintDisasm_crxor(const PPCDecodeData& d, StringBuffer* str) {
  // crxor [CRBD], [CRBA], [CRBB]
  size_t str_start = str->length();
  str->Append("crxor");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crb{}", d.XL.CRBD());
  str->Append(", ");
  str->AppendFormat("crb{}", d.XL.CRBA());
  str->Append(", ");
  str->AppendFormat("crb{}", d.XL.CRBB());
}
void PrintDisasm_dcbf(const PPCDecodeData& d, StringBuffer* str) {
  // dcbf [RA0], [RB]
  size_t str_start = str->length();
  str->Append("dcbf");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_dcbi(const PPCDecodeData& d, StringBuffer* str) {
  // dcbi [RA0], [RB]
  size_t str_start = str->length();
  str->Append("dcbi");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_dcbst(const PPCDecodeData& d, StringBuffer* str) {
  // dcbst [RA0], [RB]
  size_t str_start = str->length();
  str->Append("dcbst");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_dcbt(const PPCDecodeData& d, StringBuffer* str) {
  // dcbt [RA0], [RB]
  size_t str_start = str->length();
  str->Append("dcbt");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_dcbtst(const PPCDecodeData& d, StringBuffer* str) {
  // dcbtst [RA0], [RB]
  size_t str_start = str->length();
  str->Append("dcbtst");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_dcbz(const PPCDecodeData& d, StringBuffer* str) {
  // dcbz [RA0], [RB]
  size_t str_start = str->length();
  str->Append("dcbz");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.DCBZ.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.DCBZ.RB());
}
void PrintDisasm_dcbz128(const PPCDecodeData& d, StringBuffer* str) {
  // dcbz128 [RA0], [RB]
  size_t str_start = str->length();
  str->Append("dcbz128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.DCBZ.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.DCBZ.RB());
}
void PrintDisasm_divdux(const PPCDecodeData& d, StringBuffer* str) {
  // divdu[OE][Rc] [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("divdu");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RB());
}
void PrintDisasm_divdx(const PPCDecodeData& d, StringBuffer* str) {
  // divd[OE][Rc] [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("divd");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RB());
}
void PrintDisasm_divwux(const PPCDecodeData& d, StringBuffer* str) {
  // divwu[OE][Rc] [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("divwu");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RB());
}
void PrintDisasm_divwx(const PPCDecodeData& d, StringBuffer* str) {
  // divw[OE][Rc] [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("divw");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RB());
}
void PrintDisasm_eieio(const PPCDecodeData& d, StringBuffer* str) {
  // eieio
  size_t str_start = str->length();
  str->Append("eieio");
  PadStringBuffer(str, str_start, kNamePad);
}
void PrintDisasm_eqvx(const PPCDecodeData& d, StringBuffer* str) {
  // eqv[Rc] [RA], [RS], [RB]
  size_t str_start = str->length();
  str->Append("eqv");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_extsbx(const PPCDecodeData& d, StringBuffer* str) {
  // extsb[Rc] [RA], [RS]
  size_t str_start = str->length();
  str->Append("extsb");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
}
void PrintDisasm_extshx(const PPCDecodeData& d, StringBuffer* str) {
  // extsh[Rc] [RA], [RS]
  size_t str_start = str->length();
  str->Append("extsh");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
}
void PrintDisasm_extswx(const PPCDecodeData& d, StringBuffer* str) {
  // extsw[Rc] [RA], [RS]
  size_t str_start = str->length();
  str->Append("extsw");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
}
void PrintDisasm_fabsx(const PPCDecodeData& d, StringBuffer* str) {
  // fabs[Rc] [FD], [FB]
  size_t str_start = str->length();
  str->Append("fabs");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.X.FB());
}
void PrintDisasm_faddsx(const PPCDecodeData& d, StringBuffer* str) {
  // fadds[Rc] [FD], [FA], [FB]
  size_t str_start = str->length();
  str->Append("fadds");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_faddx(const PPCDecodeData& d, StringBuffer* str) {
  // fadd[Rc] [FD], [FA], [FB]
  size_t str_start = str->length();
  str->Append("fadd");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_fcfidx(const PPCDecodeData& d, StringBuffer* str) {
  // fcfid[Rc] [FD], [FB]
  size_t str_start = str->length();
  str->Append("fcfid");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.X.FB());
}
void PrintDisasm_fcmpo(const PPCDecodeData& d, StringBuffer* str) {
  // fcmpo [CRFD], [FA], [FB]
  size_t str_start = str->length();
  str->Append("fcmpo");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crf{}", d.X.CRFD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.X.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.X.FB());
}
void PrintDisasm_fcmpu(const PPCDecodeData& d, StringBuffer* str) {
  // fcmpu [CRFD], [FA], [FB]
  size_t str_start = str->length();
  str->Append("fcmpu");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crf{}", d.X.CRFD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.X.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.X.FB());
}
void PrintDisasm_fctidx(const PPCDecodeData& d, StringBuffer* str) {
  // fctid[Rc] [FD], [FB]
  size_t str_start = str->length();
  str->Append("fctid");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.X.FB());
}
void PrintDisasm_fctidzx(const PPCDecodeData& d, StringBuffer* str) {
  // fctidz[Rc] [FD], [FB]
  size_t str_start = str->length();
  str->Append("fctidz");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.X.FB());
}
void PrintDisasm_fctiwx(const PPCDecodeData& d, StringBuffer* str) {
  // fctiw[Rc] [FD], [FB]
  size_t str_start = str->length();
  str->Append("fctiw");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.X.FB());
}
void PrintDisasm_fctiwzx(const PPCDecodeData& d, StringBuffer* str) {
  // fctiwz[Rc] [FD], [FB]
  size_t str_start = str->length();
  str->Append("fctiwz");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.X.FB());
}
void PrintDisasm_fdivsx(const PPCDecodeData& d, StringBuffer* str) {
  // fdivs[Rc] [FD], [FA], [FB]
  size_t str_start = str->length();
  str->Append("fdivs");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_fdivx(const PPCDecodeData& d, StringBuffer* str) {
  // fdiv[Rc] [FD], [FA], [FB]
  size_t str_start = str->length();
  str->Append("fdiv");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_fmaddsx(const PPCDecodeData& d, StringBuffer* str) {
  // fmadds[Rc] [FD], [FA], [FC], [FB]
  size_t str_start = str->length();
  str->Append("fmadds");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FC());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_fmaddx(const PPCDecodeData& d, StringBuffer* str) {
  // fmadd[Rc] [FD], [FA], [FC], [FB]
  size_t str_start = str->length();
  str->Append("fmadd");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FC());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_fmrx(const PPCDecodeData& d, StringBuffer* str) {
  // fmr[Rc] [FD], [FB]
  size_t str_start = str->length();
  str->Append("fmr");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.X.FB());
}
void PrintDisasm_fmsubsx(const PPCDecodeData& d, StringBuffer* str) {
  // fmsubs[Rc] [FD], [FA], [FC], [FB]
  size_t str_start = str->length();
  str->Append("fmsubs");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FC());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_fmsubx(const PPCDecodeData& d, StringBuffer* str) {
  // fmsub[Rc] [FD], [FA], [FC], [FB]
  size_t str_start = str->length();
  str->Append("fmsub");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FC());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_fmulsx(const PPCDecodeData& d, StringBuffer* str) {
  // fmuls[Rc] [FD], [FA], [FC]
  size_t str_start = str->length();
  str->Append("fmuls");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FC());
}
void PrintDisasm_fmulx(const PPCDecodeData& d, StringBuffer* str) {
  // fmul[Rc] [FD], [FA], [FC]
  size_t str_start = str->length();
  str->Append("fmul");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FC());
}
void PrintDisasm_fnabsx(const PPCDecodeData& d, StringBuffer* str) {
  // fnabs[Rc] [FD], [FB]
  size_t str_start = str->length();
  str->Append("fnabs");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.X.FB());
}
void PrintDisasm_fnegx(const PPCDecodeData& d, StringBuffer* str) {
  // fneg[Rc] [FD], [FB]
  size_t str_start = str->length();
  str->Append("fneg");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.X.FB());
}
void PrintDisasm_fnmaddsx(const PPCDecodeData& d, StringBuffer* str) {
  // fnmadds[Rc] [FD], [FA], [FC], [FB]
  size_t str_start = str->length();
  str->Append("fnmadds");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FC());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_fnmaddx(const PPCDecodeData& d, StringBuffer* str) {
  // fnmadd[Rc] [FD], [FA], [FC], [FB]
  size_t str_start = str->length();
  str->Append("fnmadd");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FC());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_fnmsubsx(const PPCDecodeData& d, StringBuffer* str) {
  // fnmsubs[Rc] [FD], [FA], [FC], [FB]
  size_t str_start = str->length();
  str->Append("fnmsubs");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FC());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_fnmsubx(const PPCDecodeData& d, StringBuffer* str) {
  // fnmsub[Rc] [FD], [FA], [FC], [FB]
  size_t str_start = str->length();
  str->Append("fnmsub");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FC());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_fresx(const PPCDecodeData& d, StringBuffer* str) {
  // fres[Rc] [FD], [FB]
  size_t str_start = str->length();
  str->Append("fres");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_frspx(const PPCDecodeData& d, StringBuffer* str) {
  // frsp[Rc] [FD], [FB]
  size_t str_start = str->length();
  str->Append("frsp");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.X.FB());
}
void PrintDisasm_frsqrtex(const PPCDecodeData& d, StringBuffer* str) {
  // frsqrte[Rc] [FD], [FB]
  size_t str_start = str->length();
  str->Append("frsqrte");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_fselx(const PPCDecodeData& d, StringBuffer* str) {
  // fsel[Rc] [FD], [FA], [FC], [FB]
  size_t str_start = str->length();
  str->Append("fsel");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FC());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_fsqrtsx(const PPCDecodeData& d, StringBuffer* str) {
  // fsqrts[Rc] [FD], [FB]
  size_t str_start = str->length();
  str->Append("fsqrts");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_fsqrtx(const PPCDecodeData& d, StringBuffer* str) {
  // fsqrt[Rc] [FD], [FB]
  size_t str_start = str->length();
  str->Append("fsqrt");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_fsubsx(const PPCDecodeData& d, StringBuffer* str) {
  // fsubs[Rc] [FD], [FA], [FB]
  size_t str_start = str->length();
  str->Append("fsubs");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_fsubx(const PPCDecodeData& d, StringBuffer* str) {
  // fsub[Rc] [FD], [FA], [FB]
  size_t str_start = str->length();
  str->Append("fsub");
  if (d.A.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.A.FD());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FA());
  str->Append(", ");
  str->AppendFormat("fr{}", d.A.FB());
}
void PrintDisasm_icbi(const PPCDecodeData& d, StringBuffer* str) {
  // icbi [RA], [RB]
  size_t str_start = str->length();
  str->Append("icbi");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_isync(const PPCDecodeData& d, StringBuffer* str) {
  // isync
  size_t str_start = str->length();
  str->Append("isync");
  PadStringBuffer(str, str_start, kNamePad);
}
void PrintDisasm_lbz(const PPCDecodeData& d, StringBuffer* str) {
  // lbz [RD], [d]([RA0])
  size_t str_start = str->length();
  str->Append("lbz");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RD());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA0());
  str->Append(")");
}
void PrintDisasm_lbzu(const PPCDecodeData& d, StringBuffer* str) {
  // lbzu [RD], [d]([RA])
  size_t str_start = str->length();
  str->Append("lbzu");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RD());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(")");
}
void PrintDisasm_lbzux(const PPCDecodeData& d, StringBuffer* str) {
  // lbzux [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("lbzux");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lbzx(const PPCDecodeData& d, StringBuffer* str) {
  // lbzx [RD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lbzx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_ld(const PPCDecodeData& d, StringBuffer* str) {
  // ld [RD], [ds]([RA0])
  size_t str_start = str->length();
  str->Append("ld");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.DS.RD());
  str->Append(", ");
  str->AppendFormat(d.DS.ds() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.DS.ds()));
  str->Append("(");
  str->AppendFormat("r{}", d.DS.RA0());
  str->Append(")");
}
void PrintDisasm_ldarx(const PPCDecodeData& d, StringBuffer* str) {
  // ldarx [RD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("ldarx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_ldbrx(const PPCDecodeData& d, StringBuffer* str) {
  // ldbrx [RD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("ldbrx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_ldu(const PPCDecodeData& d, StringBuffer* str) {
  // ldu [RD], [ds]([RA])
  size_t str_start = str->length();
  str->Append("ldu");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.DS.RD());
  str->Append(", ");
  str->AppendFormat(d.DS.ds() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.DS.ds()));
  str->Append("(");
  str->AppendFormat("r{}", d.DS.RA());
  str->Append(")");
}
void PrintDisasm_ldux(const PPCDecodeData& d, StringBuffer* str) {
  // ldux [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("ldux");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_ldx(const PPCDecodeData& d, StringBuffer* str) {
  // ldx [RD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("ldx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lfd(const PPCDecodeData& d, StringBuffer* str) {
  // lfd [FD], [d]([RA0])
  size_t str_start = str->length();
  str->Append("lfd");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.D.FD());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA0());
  str->Append(")");
}
void PrintDisasm_lfdu(const PPCDecodeData& d, StringBuffer* str) {
  // lfdu [FD], [d]([RA])
  size_t str_start = str->length();
  str->Append("lfdu");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.D.FD());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(")");
}
void PrintDisasm_lfdux(const PPCDecodeData& d, StringBuffer* str) {
  // lfdux [FD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("lfdux");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lfdx(const PPCDecodeData& d, StringBuffer* str) {
  // lfdx [FD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lfdx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lfs(const PPCDecodeData& d, StringBuffer* str) {
  // lfs [FD], [d]([RA0])
  size_t str_start = str->length();
  str->Append("lfs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.D.FD());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA0());
  str->Append(")");
}
void PrintDisasm_lfsu(const PPCDecodeData& d, StringBuffer* str) {
  // lfsu [FD], [d]([RA])
  size_t str_start = str->length();
  str->Append("lfsu");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.D.FD());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(")");
}
void PrintDisasm_lfsux(const PPCDecodeData& d, StringBuffer* str) {
  // lfsux [FD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("lfsux");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lfsx(const PPCDecodeData& d, StringBuffer* str) {
  // lfsx [FD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lfsx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lha(const PPCDecodeData& d, StringBuffer* str) {
  // lha [RD], [d]([RA0])
  size_t str_start = str->length();
  str->Append("lha");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RD());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA0());
  str->Append(")");
}
void PrintDisasm_lhau(const PPCDecodeData& d, StringBuffer* str) {
  // lhau [RD], [d]([RA])
  size_t str_start = str->length();
  str->Append("lhau");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RD());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(")");
}
void PrintDisasm_lhaux(const PPCDecodeData& d, StringBuffer* str) {
  // lhaux [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("lhaux");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lhax(const PPCDecodeData& d, StringBuffer* str) {
  // lhax [RD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lhax");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lhbrx(const PPCDecodeData& d, StringBuffer* str) {
  // lhbrx [RD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lhbrx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lhz(const PPCDecodeData& d, StringBuffer* str) {
  // lhz [RD], [d]([RA0])
  size_t str_start = str->length();
  str->Append("lhz");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RD());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA0());
  str->Append(")");
}
void PrintDisasm_lhzu(const PPCDecodeData& d, StringBuffer* str) {
  // lhzu [RD], [d]([RA])
  size_t str_start = str->length();
  str->Append("lhzu");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RD());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(")");
}
void PrintDisasm_lhzux(const PPCDecodeData& d, StringBuffer* str) {
  // lhzux [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("lhzux");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lhzx(const PPCDecodeData& d, StringBuffer* str) {
  // lhzx [RD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lhzx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lvebx(const PPCDecodeData& d, StringBuffer* str) {
  // lvebx [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvebx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lvehx(const PPCDecodeData& d, StringBuffer* str) {
  // lvehx [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvehx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lvewx(const PPCDecodeData& d, StringBuffer* str) {
  // lvewx [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvewx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lvewx128(const PPCDecodeData& d, StringBuffer* str) {
  // lvewx128 [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvewx128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_1.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RB());
}
void PrintDisasm_lvlx(const PPCDecodeData& d, StringBuffer* str) {
  // lvlx [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvlx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lvlx128(const PPCDecodeData& d, StringBuffer* str) {
  // lvlx128 [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvlx128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_1.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RB());
}
void PrintDisasm_lvlxl(const PPCDecodeData& d, StringBuffer* str) {
  // lvlxl [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvlxl");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lvlxl128(const PPCDecodeData& d, StringBuffer* str) {
  // lvlxl128 [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvlxl128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_1.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RB());
}
void PrintDisasm_lvrx(const PPCDecodeData& d, StringBuffer* str) {
  // lvrx [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvrx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lvrx128(const PPCDecodeData& d, StringBuffer* str) {
  // lvrx128 [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvrx128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_1.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RB());
}
void PrintDisasm_lvrxl(const PPCDecodeData& d, StringBuffer* str) {
  // lvrxl [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvrxl");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lvrxl128(const PPCDecodeData& d, StringBuffer* str) {
  // lvrxl128 [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvrxl128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_1.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RB());
}
void PrintDisasm_lvsl(const PPCDecodeData& d, StringBuffer* str) {
  // lvsl [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvsl");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lvsl128(const PPCDecodeData& d, StringBuffer* str) {
  // lvsl128 [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvsl128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_1.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RB());
}
void PrintDisasm_lvsr(const PPCDecodeData& d, StringBuffer* str) {
  // lvsr [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvsr");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lvsr128(const PPCDecodeData& d, StringBuffer* str) {
  // lvsr128 [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvsr128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_1.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RB());
}
void PrintDisasm_lvx(const PPCDecodeData& d, StringBuffer* str) {
  // lvx [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lvx128(const PPCDecodeData& d, StringBuffer* str) {
  // lvx128 [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvx128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_1.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RB());
}
void PrintDisasm_lvxl(const PPCDecodeData& d, StringBuffer* str) {
  // lvslx [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvslx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lvxl128(const PPCDecodeData& d, StringBuffer* str) {
  // lvxl128 [VD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lvxl128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_1.VD());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RB());
}
void PrintDisasm_lwa(const PPCDecodeData& d, StringBuffer* str) {
  // lwa [RD], [ds]([RA0])
  size_t str_start = str->length();
  str->Append("lwa");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.DS.RD());
  str->Append(", ");
  str->AppendFormat(d.DS.ds() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.DS.ds()));
  str->Append("(");
  str->AppendFormat("r{}", d.DS.RA0());
  str->Append(")");
}
void PrintDisasm_lwarx(const PPCDecodeData& d, StringBuffer* str) {
  // lwarx [RD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lwarx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lwaux(const PPCDecodeData& d, StringBuffer* str) {
  // lwaux [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("lwaux");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lwax(const PPCDecodeData& d, StringBuffer* str) {
  // lwax [RD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lwax");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lwbrx(const PPCDecodeData& d, StringBuffer* str) {
  // lwbrx [RD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lwbrx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lwz(const PPCDecodeData& d, StringBuffer* str) {
  // lwz [RD], [d]([RA0])
  size_t str_start = str->length();
  str->Append("lwz");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RD());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA0());
  str->Append(")");
}
void PrintDisasm_lwzu(const PPCDecodeData& d, StringBuffer* str) {
  // lwzu [RD], [d]([RA])
  size_t str_start = str->length();
  str->Append("lwzu");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RD());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(")");
}
void PrintDisasm_lwzux(const PPCDecodeData& d, StringBuffer* str) {
  // lwzux [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("lwzux");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_lwzx(const PPCDecodeData& d, StringBuffer* str) {
  // lwzx [RD], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("lwzx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_mcrf(const PPCDecodeData& d, StringBuffer* str) {
  // mcrf [CRFD], [CRFS]
  size_t str_start = str->length();
  str->Append("mcrf");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crf{}", d.XL.CRFD());
  str->Append(", ");
  str->AppendFormat("crf{}", d.XL.CRFS());
}
void PrintDisasm_mcrfs(const PPCDecodeData& d, StringBuffer* str) {
  // mcrfs [CRFD], [CRFS]
  size_t str_start = str->length();
  str->Append("mcrfs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crf{}", d.X.CRFD());
  str->Append(", ");
  str->AppendFormat("crf{}", d.X.CRFS());
}
void PrintDisasm_mcrxr(const PPCDecodeData& d, StringBuffer* str) {
  // mcrxr [CRFD]
  size_t str_start = str->length();
  str->Append("mcrxr");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crf{}", d.X.CRFD());
}
void PrintDisasm_mfcr(const PPCDecodeData& d, StringBuffer* str) {
  // mfcr [RD]
  size_t str_start = str->length();
  str->Append("mfcr");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
}
void PrintDisasm_mffsx(const PPCDecodeData& d, StringBuffer* str) {
  // mffs[Rc] [RD]
  size_t str_start = str->length();
  str->Append("mffs");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
}
void PrintDisasm_mfmsr(const PPCDecodeData& d, StringBuffer* str) {
  // mfmsr [RD]
  size_t str_start = str->length();
  str->Append("mfmsr");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RD());
}
void PrintDisasm_mfspr(const PPCDecodeData& d, StringBuffer* str) {
  // mfspr [RD], [SPR]
  size_t str_start = str->length();
  str->Append("mfspr");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XFX.RD());
  str->Append(", ");
  str->AppendFormat("{}", d.XFX.SPR());
}
void PrintDisasm_mftb(const PPCDecodeData& d, StringBuffer* str) {
  // mftb [RD], [TBR]
  size_t str_start = str->length();
  str->Append("mftb");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XFX.RD());
  str->Append(", ");
  str->AppendFormat("{}", d.XFX.TBR());
}
void PrintDisasm_mtcrf(const PPCDecodeData& d, StringBuffer* str) {
  // mtcrf [CRM], [RS]
  size_t str_start = str->length();
  str->Append("mtcrf");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("(UNHANDLED CRM)");
  str->Append(", ");
  str->AppendFormat("r{}", d.XFX.RS());
}
void PrintDisasm_mtfsb0x(const PPCDecodeData& d, StringBuffer* str) {
  // mtfsb0[Rc] [FPSCRD]
  size_t str_start = str->length();
  str->Append("mtfsb0");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("(UNHANDLED FPSCRD)");
}
void PrintDisasm_mtfsb1x(const PPCDecodeData& d, StringBuffer* str) {
  // mtfsb1[Rc] [FPSCRD]
  size_t str_start = str->length();
  str->Append("mtfsb1");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("(UNHANDLED FPSCRD)");
}
void PrintDisasm_mtfsfix(const PPCDecodeData& d, StringBuffer* str) {
  // mtfsfi[Rc] [CRFD], [IMM]
  size_t str_start = str->length();
  str->Append("mtfsfi");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("crf{}", d.X.CRFD());
  str->Append(", ");
  str->AppendFormat("{}", d.X.IMM());
}
void PrintDisasm_mtfsfx(const PPCDecodeData& d, StringBuffer* str) {
  // mtfsf[Rc] [FM], [FB]
  size_t str_start = str->length();
  str->Append("mtfsf");
  if (d.XFL.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("{}", d.XFL.FM());
  str->Append(", ");
  str->AppendFormat("fr{}", d.XFL.FB());
}
void PrintDisasm_mtmsr(const PPCDecodeData& d, StringBuffer* str) {
  // mtmsr [RS]
  size_t str_start = str->length();
  str->Append("mtmsr");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RS());
}
void PrintDisasm_mtmsrd(const PPCDecodeData& d, StringBuffer* str) {
  // mtmsrd [RS]
  size_t str_start = str->length();
  str->Append("mtmsrd");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RS());
}
void PrintDisasm_mtspr(const PPCDecodeData& d, StringBuffer* str) {
  // mtspr [SPR], [RS]
  size_t str_start = str->length();
  str->Append("mtspr");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("{}", d.XFX.SPR());
  str->Append(", ");
  str->AppendFormat("r{}", d.XFX.RS());
}
void PrintDisasm_mulhdux(const PPCDecodeData& d, StringBuffer* str) {
  // mulhdu[Rc] [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("mulhdu");
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RB());
}
void PrintDisasm_mulhdx(const PPCDecodeData& d, StringBuffer* str) {
  // mulhd[Rc] [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("mulhd");
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RB());
}
void PrintDisasm_mulhwux(const PPCDecodeData& d, StringBuffer* str) {
  // mulhwu[Rc] [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("mulhwu");
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RB());
}
void PrintDisasm_mulhwx(const PPCDecodeData& d, StringBuffer* str) {
  // mulhw[Rc] [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("mulhw");
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RB());
}
void PrintDisasm_mulldx(const PPCDecodeData& d, StringBuffer* str) {
  // mulld[OE][Rc] [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("mulld");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RB());
}
void PrintDisasm_mulli(const PPCDecodeData& d, StringBuffer* str) {
  // mulli [RD], [RA], [SIMM]
  size_t str_start = str->length();
  str->Append("mulli");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(", ");
  str->AppendFormat(d.D.SIMM() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.SIMM()));
}
void PrintDisasm_mullwx(const PPCDecodeData& d, StringBuffer* str) {
  // mullw[OE][Rc] [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("mullw");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RB());
}
void PrintDisasm_nandx(const PPCDecodeData& d, StringBuffer* str) {
  // nand[Rc] [RA], [RS], [RB]
  size_t str_start = str->length();
  str->Append("nand");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_negx(const PPCDecodeData& d, StringBuffer* str) {
  // neg[OE][Rc] [RD], [RA]
  size_t str_start = str->length();
  str->Append("neg");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
}
void PrintDisasm_norx(const PPCDecodeData& d, StringBuffer* str) {
  // nor[Rc] [RA], [RS], [RB]
  size_t str_start = str->length();
  str->Append("nor");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_orcx(const PPCDecodeData& d, StringBuffer* str) {
  // orc[Rc] [RA], [RS], [RB]
  size_t str_start = str->length();
  str->Append("orc");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_ori(const PPCDecodeData& d, StringBuffer* str) {
  // ori [RA], [RS], [UIMM]
  size_t str_start = str->length();
  str->Append("ori");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.D.RS());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.D.UIMM());
}
void PrintDisasm_oris(const PPCDecodeData& d, StringBuffer* str) {
  // oris [RA], [RS], [UIMM]
  size_t str_start = str->length();
  str->Append("oris");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.D.RS());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.D.UIMM());
}
void PrintDisasm_orx(const PPCDecodeData& d, StringBuffer* str) {
  // or[Rc] [RA], [RS], [RB]
  size_t str_start = str->length();
  str->Append("or");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_rldclx(const PPCDecodeData& d, StringBuffer* str) {
  // rldcl[Rc] [RA], [RS], [RB], [MB]
  size_t str_start = str->length();
  str->Append("rldcl");
  if (d.MDS.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.MDS.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.MDS.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.MDS.RB());
  str->Append(", ");
  str->AppendFormat("{}", d.MDS.MB());
}
void PrintDisasm_rldcrx(const PPCDecodeData& d, StringBuffer* str) {
  // rldcr[Rc] [RA], [RS], [RB], [ME]
  size_t str_start = str->length();
  str->Append("rldcr");
  if (d.MDS.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.MDS.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.MDS.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.MDS.RB());
  str->Append(", ");
  str->AppendFormat("{}", d.MDS.ME());
}
void PrintDisasm_rldiclx(const PPCDecodeData& d, StringBuffer* str) {
  // rldicl[Rc] [RA], [RS], [SH], [MB]
  size_t str_start = str->length();
  str->Append("rldicl");
  if (d.MD.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.MD.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.MD.RS());
  str->Append(", ");
  str->AppendFormat("{}", d.MD.SH());
  str->Append(", ");
  str->AppendFormat("{}", d.MD.MB());
}
void PrintDisasm_rldicrx(const PPCDecodeData& d, StringBuffer* str) {
  // rldicr[Rc] [RA], [RS], [SH], [ME]
  size_t str_start = str->length();
  str->Append("rldicr");
  if (d.MD.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.MD.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.MD.RS());
  str->Append(", ");
  str->AppendFormat("{}", d.MD.SH());
  str->Append(", ");
  str->AppendFormat("{}", d.MD.ME());
}
void PrintDisasm_rldicx(const PPCDecodeData& d, StringBuffer* str) {
  // rldic[Rc] [RA], [RS], [SH], [MB]
  size_t str_start = str->length();
  str->Append("rldic");
  if (d.MD.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.MD.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.MD.RS());
  str->Append(", ");
  str->AppendFormat("{}", d.MD.SH());
  str->Append(", ");
  str->AppendFormat("{}", d.MD.MB());
}
void PrintDisasm_rldimix(const PPCDecodeData& d, StringBuffer* str) {
  // rldimi[Rc] [RA], [RS], [SH], [MB]
  size_t str_start = str->length();
  str->Append("rldimi");
  if (d.MD.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.MD.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.MD.RS());
  str->Append(", ");
  str->AppendFormat("{}", d.MD.SH());
  str->Append(", ");
  str->AppendFormat("{}", d.MD.MB());
}
void PrintDisasm_rlwimix(const PPCDecodeData& d, StringBuffer* str) {
  // rlwimi[Rc] [RA], [RS], [SH], [MB], [ME]
  size_t str_start = str->length();
  str->Append("rlwimi");
  if (d.M.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.M.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.M.RS());
  str->Append(", ");
  str->AppendFormat("{}", d.M.SH());
  str->Append(", ");
  str->AppendFormat("{}", d.M.MB());
  str->Append(", ");
  str->AppendFormat("{}", d.M.ME());
}
void PrintDisasm_rlwinmx(const PPCDecodeData& d, StringBuffer* str) {
  // rlwinm[Rc] [RA], [RS], [SH], [MB], [ME]
  size_t str_start = str->length();
  str->Append("rlwinm");
  if (d.M.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.M.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.M.RS());
  str->Append(", ");
  str->AppendFormat("{}", d.M.SH());
  str->Append(", ");
  str->AppendFormat("{}", d.M.MB());
  str->Append(", ");
  str->AppendFormat("{}", d.M.ME());
}
void PrintDisasm_rlwnmx(const PPCDecodeData& d, StringBuffer* str) {
  // rlwnm[Rc] [RA], [RS], [RB], [MB], [ME]
  size_t str_start = str->length();
  str->Append("rlwnm");
  if (d.M.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.M.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.M.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.M.RB());
  str->Append(", ");
  str->AppendFormat("{}", d.M.MB());
  str->Append(", ");
  str->AppendFormat("{}", d.M.ME());
}
void PrintDisasm_sc(const PPCDecodeData& d, StringBuffer* str) {
  // sc [LEV]
  size_t str_start = str->length();
  str->Append("sc");
  PadStringBuffer(str, str_start, kNamePad);
  if (d.SC.LEV()) str->AppendFormat("{}", d.SC.LEV());
}
void PrintDisasm_sldx(const PPCDecodeData& d, StringBuffer* str) {
  // sld[Rc] [RA], [RS], [RB]
  size_t str_start = str->length();
  str->Append("sld");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_slwx(const PPCDecodeData& d, StringBuffer* str) {
  // slw[Rc] [RA], [RS], [RB]
  size_t str_start = str->length();
  str->Append("slw");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_sradix(const PPCDecodeData& d, StringBuffer* str) {
  // sradi[Rc] [RA], [RS], [SH]
  size_t str_start = str->length();
  str->Append("sradi");
  if (d.XS.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XS.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XS.RS());
  str->Append(", ");
  str->AppendFormat("{}", d.XS.SH());
}
void PrintDisasm_sradx(const PPCDecodeData& d, StringBuffer* str) {
  // srad[Rc] [RA], [RS], [RB]
  size_t str_start = str->length();
  str->Append("srad");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_srawix(const PPCDecodeData& d, StringBuffer* str) {
  // srawi[Rc] [RA], [RS], [SH]
  size_t str_start = str->length();
  str->Append("srawi");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("{}", d.X.SH());
}
void PrintDisasm_srawx(const PPCDecodeData& d, StringBuffer* str) {
  // sraw[Rc] [RA], [RS], [RB]
  size_t str_start = str->length();
  str->Append("sraw");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_srdx(const PPCDecodeData& d, StringBuffer* str) {
  // srd[Rc] [RA], [RS], [RB]
  size_t str_start = str->length();
  str->Append("srd");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_srwx(const PPCDecodeData& d, StringBuffer* str) {
  // srw[Rc] [RA], [RS], [RB]
  size_t str_start = str->length();
  str->Append("srw");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stb(const PPCDecodeData& d, StringBuffer* str) {
  // stb [RS], [d]([RA0])
  size_t str_start = str->length();
  str->Append("stb");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RS());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA0());
  str->Append(")");
}
void PrintDisasm_stbu(const PPCDecodeData& d, StringBuffer* str) {
  // stbu [RS], [d]([RA])
  size_t str_start = str->length();
  str->Append("stbu");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RS());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(")");
}
void PrintDisasm_stbux(const PPCDecodeData& d, StringBuffer* str) {
  // stbux [RS], [RA], [RB]
  size_t str_start = str->length();
  str->Append("stbux");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stbx(const PPCDecodeData& d, StringBuffer* str) {
  // stbx [RS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stbx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_std(const PPCDecodeData& d, StringBuffer* str) {
  // std [RS], [ds]([RA0])
  size_t str_start = str->length();
  str->Append("std");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.DS.RS());
  str->Append(", ");
  str->AppendFormat(d.DS.ds() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.DS.ds()));
  str->Append("(");
  str->AppendFormat("r{}", d.DS.RA0());
  str->Append(")");
}
void PrintDisasm_stdbrx(const PPCDecodeData& d, StringBuffer* str) {
  // stdbrx [RS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stdbrx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stdcx(const PPCDecodeData& d, StringBuffer* str) {
  // stdcx. [RS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stdcx.");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stdu(const PPCDecodeData& d, StringBuffer* str) {
  // stdu [RS], [ds]([RA])
  size_t str_start = str->length();
  str->Append("stdu");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.DS.RS());
  str->Append(", ");
  str->AppendFormat(d.DS.ds() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.DS.ds()));
  str->Append("(");
  str->AppendFormat("r{}", d.DS.RA());
  str->Append(")");
}
void PrintDisasm_stdux(const PPCDecodeData& d, StringBuffer* str) {
  // stdux [RS], [RA], [RB]
  size_t str_start = str->length();
  str->Append("stdux");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stdx(const PPCDecodeData& d, StringBuffer* str) {
  // stdx [RS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stdx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stfd(const PPCDecodeData& d, StringBuffer* str) {
  // stfd [FS], [d]([RA0])
  size_t str_start = str->length();
  str->Append("stfd");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.D.FS());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA0());
  str->Append(")");
}
void PrintDisasm_stfdu(const PPCDecodeData& d, StringBuffer* str) {
  // stfdu [FS], [d]([RA])
  size_t str_start = str->length();
  str->Append("stfdu");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.D.FS());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(")");
}
void PrintDisasm_stfdux(const PPCDecodeData& d, StringBuffer* str) {
  // stfdux [FS], [RA], [RB]
  size_t str_start = str->length();
  str->Append("stfdux");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stfdx(const PPCDecodeData& d, StringBuffer* str) {
  // stfdx [FS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stfdx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stfiwx(const PPCDecodeData& d, StringBuffer* str) {
  // stfiwx [FS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stfiwx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stfs(const PPCDecodeData& d, StringBuffer* str) {
  // stfs [FS], [d]([RA0])
  size_t str_start = str->length();
  str->Append("stfs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.D.FS());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA0());
  str->Append(")");
}
void PrintDisasm_stfsu(const PPCDecodeData& d, StringBuffer* str) {
  // stfsu [FS], [d]([RA])
  size_t str_start = str->length();
  str->Append("stfsu");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.D.FS());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(")");
}
void PrintDisasm_stfsux(const PPCDecodeData& d, StringBuffer* str) {
  // stfsux [FS], [RA], [RB]
  size_t str_start = str->length();
  str->Append("stfsux");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stfsx(const PPCDecodeData& d, StringBuffer* str) {
  // stfsx [FS], [RA], [RB]
  size_t str_start = str->length();
  str->Append("stfsx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("fr{}", d.X.FS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_sth(const PPCDecodeData& d, StringBuffer* str) {
  // sth [RS], [d]([RA0])
  size_t str_start = str->length();
  str->Append("sth");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RS());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA0());
  str->Append(")");
}
void PrintDisasm_sthbrx(const PPCDecodeData& d, StringBuffer* str) {
  // sthbrx [RS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("sthbrx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_sthu(const PPCDecodeData& d, StringBuffer* str) {
  // sthu [RS], [d]([RA])
  size_t str_start = str->length();
  str->Append("sthu");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RS());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(")");
}
void PrintDisasm_sthux(const PPCDecodeData& d, StringBuffer* str) {
  // sthux [RS], [RA], [RB]
  size_t str_start = str->length();
  str->Append("sthux");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_sthx(const PPCDecodeData& d, StringBuffer* str) {
  // sthx [RS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("sthx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stvebx(const PPCDecodeData& d, StringBuffer* str) {
  // stvebx [VS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stvebx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stvehx(const PPCDecodeData& d, StringBuffer* str) {
  // stvehx [VS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stvehx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stvewx(const PPCDecodeData& d, StringBuffer* str) {
  // stvewx [VS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stvewx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stvewx128(const PPCDecodeData& d, StringBuffer* str) {
  // stvewx128 [VS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stvewx128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_1.VS());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RB());
}
void PrintDisasm_stvlx(const PPCDecodeData& d, StringBuffer* str) {
  // stvlx [VS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stvlx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stvlx128(const PPCDecodeData& d, StringBuffer* str) {
  // stvlx128 [VS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stvlx128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_1.VS());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RB());
}
void PrintDisasm_stvlxl(const PPCDecodeData& d, StringBuffer* str) {
  // stvlxl [VS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stvlxl");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stvlxl128(const PPCDecodeData& d, StringBuffer* str) {
  // stvlxl128 [VS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stvlxl128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_1.VS());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RB());
}
void PrintDisasm_stvrx(const PPCDecodeData& d, StringBuffer* str) {
  // stvrx [VS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stvrx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stvrx128(const PPCDecodeData& d, StringBuffer* str) {
  // stvrx128 [VS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stvrx128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_1.VS());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RB());
}
void PrintDisasm_stvrxl(const PPCDecodeData& d, StringBuffer* str) {
  // stvrxl [VS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stvrxl");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stvrxl128(const PPCDecodeData& d, StringBuffer* str) {
  // stvrxl128 [VS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stvrxl128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_1.VS());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RB());
}
void PrintDisasm_stvx(const PPCDecodeData& d, StringBuffer* str) {
  // stvx [VS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stvx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stvx128(const PPCDecodeData& d, StringBuffer* str) {
  // stvx128 [VS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stvx128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_1.VS());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RB());
}
void PrintDisasm_stvxl(const PPCDecodeData& d, StringBuffer* str) {
  // stvxl [VS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stvxl");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.X.VS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stvxl128(const PPCDecodeData& d, StringBuffer* str) {
  // stvxl128 [VS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stvxl128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_1.VS());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.VX128_1.RB());
}
void PrintDisasm_stw(const PPCDecodeData& d, StringBuffer* str) {
  // stw [RS], [d]([RA0])
  size_t str_start = str->length();
  str->Append("stw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RS());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA0());
  str->Append(")");
}
void PrintDisasm_stwbrx(const PPCDecodeData& d, StringBuffer* str) {
  // stwbrx [RS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stwbrx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stwcx(const PPCDecodeData& d, StringBuffer* str) {
  // stwcx. [RS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stwcx.");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stwu(const PPCDecodeData& d, StringBuffer* str) {
  // stwu [RS], [d]([RA])
  size_t str_start = str->length();
  str->Append("stwu");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RS());
  str->Append(", ");
  str->AppendFormat(d.D.d() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.d()));
  str->Append("(");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(")");
}
void PrintDisasm_stwux(const PPCDecodeData& d, StringBuffer* str) {
  // stwux [RS], [RA], [RB]
  size_t str_start = str->length();
  str->Append("stwux");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_stwx(const PPCDecodeData& d, StringBuffer* str) {
  // stwx [RS], [RA0], [RB]
  size_t str_start = str->length();
  str->Append("stwx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA0());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_subfcx(const PPCDecodeData& d, StringBuffer* str) {
  // subfc[OE][Rc] [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("subfc");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RB());
}
void PrintDisasm_subfex(const PPCDecodeData& d, StringBuffer* str) {
  // subfe[OE][Rc] [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("subfe");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RB());
}
void PrintDisasm_subficx(const PPCDecodeData& d, StringBuffer* str) {
  // subfic [RD], [RA], [SIMM]
  size_t str_start = str->length();
  str->Append("subfic");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(", ");
  str->AppendFormat(d.D.SIMM() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.SIMM()));
}
void PrintDisasm_subfmex(const PPCDecodeData& d, StringBuffer* str) {
  // subfme[OE][Rc] [RD], [RA]
  size_t str_start = str->length();
  str->Append("subfme");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
}
void PrintDisasm_subfx(const PPCDecodeData& d, StringBuffer* str) {
  // subf[OE][Rc] [RD], [RA], [RB]
  size_t str_start = str->length();
  str->Append("subf");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RB());
}
void PrintDisasm_subfzex(const PPCDecodeData& d, StringBuffer* str) {
  // subfze[OE][Rc] [RD], [RA]
  size_t str_start = str->length();
  str->Append("subfze");
  if (d.XO.OE()) str->Append('o');
  if (d.XO.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.XO.RD());
  str->Append(", ");
  str->AppendFormat("r{}", d.XO.RA());
}
void PrintDisasm_sync(const PPCDecodeData& d, StringBuffer* str) {
  // sync
  size_t str_start = str->length();
  str->Append("sync");
  PadStringBuffer(str, str_start, kNamePad);
}
void PrintDisasm_td(const PPCDecodeData& d, StringBuffer* str) {
  // td [TO], [RA], [RB]
  size_t str_start = str->length();
  str->Append("td");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("{}", d.X.TO());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_tdi(const PPCDecodeData& d, StringBuffer* str) {
  // tdi [TO], [RA], [SIMM]
  size_t str_start = str->length();
  str->Append("tdi");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("{}", d.D.TO());
  str->Append(", ");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(", ");
  str->AppendFormat(d.D.SIMM() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.SIMM()));
}
void PrintDisasm_tw(const PPCDecodeData& d, StringBuffer* str) {
  // tw [TO], [RA], [RB]
  size_t str_start = str->length();
  str->Append("tw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("{}", d.X.TO());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
void PrintDisasm_twi(const PPCDecodeData& d, StringBuffer* str) {
  // tw [TO], [RA], [SIMM]
  size_t str_start = str->length();
  str->Append("tw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("{}", d.D.TO());
  str->Append(", ");
  str->AppendFormat("r{}", d.D.RA());
  str->Append(", ");
  str->AppendFormat(d.D.SIMM() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.D.SIMM()));
}
void PrintDisasm_vaddcuw(const PPCDecodeData& d, StringBuffer* str) {
  // vaddcuw [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vaddcuw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vaddfp(const PPCDecodeData& d, StringBuffer* str) {
  // vaddfp [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vaddfp");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vaddfp128(const PPCDecodeData& d, StringBuffer* str) {
  // vaddfp128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vaddfp128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vaddsbs(const PPCDecodeData& d, StringBuffer* str) {
  // vaddsbs [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vaddsbs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vaddshs(const PPCDecodeData& d, StringBuffer* str) {
  // vaddshs [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vaddshs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vaddsws(const PPCDecodeData& d, StringBuffer* str) {
  // vaddsws [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vaddsws");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vaddubm(const PPCDecodeData& d, StringBuffer* str) {
  // vaddubm [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vaddubm");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vaddubs(const PPCDecodeData& d, StringBuffer* str) {
  // vaddubs [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vaddubs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vadduhm(const PPCDecodeData& d, StringBuffer* str) {
  // vadduhm [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vadduhm");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vadduhs(const PPCDecodeData& d, StringBuffer* str) {
  // vadduhs [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vadduhs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vadduwm(const PPCDecodeData& d, StringBuffer* str) {
  // vadduwm [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vadduwm");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vadduws(const PPCDecodeData& d, StringBuffer* str) {
  // vadduws [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vadduws");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vand(const PPCDecodeData& d, StringBuffer* str) {
  // vand [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vand");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vand128(const PPCDecodeData& d, StringBuffer* str) {
  // vand128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vand128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vandc(const PPCDecodeData& d, StringBuffer* str) {
  // vandc [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vandc");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vandc128(const PPCDecodeData& d, StringBuffer* str) {
  // vandc128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vandc128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vavgsb(const PPCDecodeData& d, StringBuffer* str) {
  // vavgsb [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vavgsb");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vavgsh(const PPCDecodeData& d, StringBuffer* str) {
  // vavgsh [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vavgsh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vavgsw(const PPCDecodeData& d, StringBuffer* str) {
  // vavgsw [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vavgsw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vavgub(const PPCDecodeData& d, StringBuffer* str) {
  // vavgub [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vavgub");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vavguh(const PPCDecodeData& d, StringBuffer* str) {
  // vavguh [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vavguh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vavguw(const PPCDecodeData& d, StringBuffer* str) {
  // vavguw [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vavguw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vcfpsxws128(const PPCDecodeData& d, StringBuffer* str) {
  // vcfpsxws128 [VD], [VB], [UIMM]
  size_t str_start = str->length();
  str->Append("vcfpsxws128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_3.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_3.VB());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.VX128_3.UIMM());
}
void PrintDisasm_vcfpuxws128(const PPCDecodeData& d, StringBuffer* str) {
  // vcfpuxws128 [VD], [VB], [UIMM]
  size_t str_start = str->length();
  str->Append("vcfpuxws128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_3.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_3.VB());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.VX128_3.UIMM());
}
void PrintDisasm_vcfsx(const PPCDecodeData& d, StringBuffer* str) {
  // vcfsx [VD], [VB], [UIMM]
  size_t str_start = str->length();
  str->Append("vcfsx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.VX.UIMM());
}
void PrintDisasm_vcfux(const PPCDecodeData& d, StringBuffer* str) {
  // vcfux [VD], [VB], [UIMM]
  size_t str_start = str->length();
  str->Append("vcfux");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.VX.UIMM());
}
void PrintDisasm_vcmpbfp(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpbfp[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpbfp");
  if (d.VC.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VC.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VB());
}
void PrintDisasm_vcmpbfp128(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpbfp128[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpbfp128");
  if (d.VX128_R.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_R.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_R.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_R.VB());
}
void PrintDisasm_vcmpeqfp(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpeqfp[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpeqfp");
  if (d.VC.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VC.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VB());
}
void PrintDisasm_vcmpeqfp128(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpeqfp128[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpeqfp128");
  if (d.VX128_R.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_R.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_R.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_R.VB());
}
void PrintDisasm_vcmpequb(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpequb[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpequb");
  if (d.VC.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VC.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VB());
}
void PrintDisasm_vcmpequh(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpequh[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpequh");
  if (d.VC.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VC.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VB());
}
void PrintDisasm_vcmpequw(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpequw[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpequw");
  if (d.VC.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VC.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VB());
}
void PrintDisasm_vcmpequw128(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpequw128[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpequw128");
  if (d.VX128_R.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_R.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_R.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_R.VB());
}
void PrintDisasm_vcmpgefp(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpgefp[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpgefp");
  if (d.VC.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VC.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VB());
}
void PrintDisasm_vcmpgefp128(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpgefp128[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpgefp128");
  if (d.VX128_R.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_R.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_R.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_R.VB());
}
void PrintDisasm_vcmpgtfp(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpgtfp[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpgtfp");
  if (d.VC.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VC.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VB());
}
void PrintDisasm_vcmpgtfp128(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpgtfp128[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpgtfp128");
  if (d.VX128_R.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_R.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_R.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_R.VB());
}
void PrintDisasm_vcmpgtsb(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpgtsb[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpgtsb");
  if (d.VC.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VC.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VB());
}
void PrintDisasm_vcmpgtsh(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpgtsh[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpgtsh");
  if (d.VC.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VC.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VB());
}
void PrintDisasm_vcmpgtsw(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpgtsw[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpgtsw");
  if (d.VC.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VC.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VB());
}
void PrintDisasm_vcmpgtub(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpgtub[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpgtub");
  if (d.VC.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VC.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VB());
}
void PrintDisasm_vcmpgtuh(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpgtuh[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpgtuh");
  if (d.VC.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VC.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VB());
}
void PrintDisasm_vcmpgtuw(const PPCDecodeData& d, StringBuffer* str) {
  // vcmpgtuw[Rc] [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vcmpgtuw");
  if (d.VC.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VC.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VC.VB());
}
void PrintDisasm_vcsxwfp128(const PPCDecodeData& d, StringBuffer* str) {
  // vcsxwfp128 [VD], [VB], [UIMM]
  size_t str_start = str->length();
  str->Append("vcsxwfp128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_3.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_3.VB());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.VX128_3.UIMM());
}
void PrintDisasm_vctsxs(const PPCDecodeData& d, StringBuffer* str) {
  // vctsxs [VD], [VB], [UIMM]
  size_t str_start = str->length();
  str->Append("vctsxs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.VX.UIMM());
}
void PrintDisasm_vctuxs(const PPCDecodeData& d, StringBuffer* str) {
  // vctuxs [VD], [VB], [UIMM]
  size_t str_start = str->length();
  str->Append("vctuxs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.VX.UIMM());
}
void PrintDisasm_vcuxwfp128(const PPCDecodeData& d, StringBuffer* str) {
  // vcuxwfp128 [VD], [VB], [UIMM]
  size_t str_start = str->length();
  str->Append("vcuxwfp128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_3.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_3.VB());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.VX128_3.UIMM());
}
void PrintDisasm_vexptefp(const PPCDecodeData& d, StringBuffer* str) {
  // vexptefp [VD], [VB]
  size_t str_start = str->length();
  str->Append("vexptefp");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vexptefp128(const PPCDecodeData& d, StringBuffer* str) {
  // vexptefp128 [VD], [VB]
  size_t str_start = str->length();
  str->Append("vexptefp128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_3.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_3.VB());
}
void PrintDisasm_vlogefp(const PPCDecodeData& d, StringBuffer* str) {
  // vlogefp [VD], [VB]
  size_t str_start = str->length();
  str->Append("vlogefp");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vlogefp128(const PPCDecodeData& d, StringBuffer* str) {
  // vlogefp128 [VD], [VB]
  size_t str_start = str->length();
  str->Append("vlogefp128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_3.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_3.VB());
}
void PrintDisasm_vmaddcfp128(const PPCDecodeData& d, StringBuffer* str) {
  // vmaddcfp128 [VD], [VA], [VD], [VB]
  size_t str_start = str->length();
  str->Append("vmaddcfp128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vmaddfp(const PPCDecodeData& d, StringBuffer* str) {
  // vmaddfp [VD], [VA], [VC], [VB]
  size_t str_start = str->length();
  str->Append("vmaddfp");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VA.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VC());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VB());
}
void PrintDisasm_vmaddfp128(const PPCDecodeData& d, StringBuffer* str) {
  // vmaddfp128 [VD], [VA], [VB], [VD]
  size_t str_start = str->length();
  str->Append("vmaddfp128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VD());
}
void PrintDisasm_vmaxfp(const PPCDecodeData& d, StringBuffer* str) {
  // vmaxfp [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmaxfp");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmaxfp128(const PPCDecodeData& d, StringBuffer* str) {
  // vmaxfp128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmaxfp128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vmaxsb(const PPCDecodeData& d, StringBuffer* str) {
  // vmaxsb [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmaxsb");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmaxsh(const PPCDecodeData& d, StringBuffer* str) {
  // vmaxsh [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmaxsh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmaxsw(const PPCDecodeData& d, StringBuffer* str) {
  // vmaxsw [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmaxsw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmaxub(const PPCDecodeData& d, StringBuffer* str) {
  // vmaxub [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmaxub");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmaxuh(const PPCDecodeData& d, StringBuffer* str) {
  // vmaxuh [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmaxuh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmaxuw(const PPCDecodeData& d, StringBuffer* str) {
  // vmaxuw [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmaxuw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmhaddshs(const PPCDecodeData& d, StringBuffer* str) {
  // vmhaddshs [VD], [VA], [VB], [VC]
  size_t str_start = str->length();
  str->Append("vmhaddshs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VA.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VB());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VC());
}
void PrintDisasm_vmhraddshs(const PPCDecodeData& d, StringBuffer* str) {
  // vmhraddshs [VD], [VA], [VB], [VC]
  size_t str_start = str->length();
  str->Append("vmhraddshs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VA.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VB());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VC());
}
void PrintDisasm_vminfp(const PPCDecodeData& d, StringBuffer* str) {
  // vminfp [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vminfp");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vminfp128(const PPCDecodeData& d, StringBuffer* str) {
  // vminfp128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vminfp128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vminsb(const PPCDecodeData& d, StringBuffer* str) {
  // vminsb [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vminsb");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vminsh(const PPCDecodeData& d, StringBuffer* str) {
  // vminsh [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vminsh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vminsw(const PPCDecodeData& d, StringBuffer* str) {
  // vminsw [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vminsw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vminub(const PPCDecodeData& d, StringBuffer* str) {
  // vminub [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vminub");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vminuh(const PPCDecodeData& d, StringBuffer* str) {
  // vminuh [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vminuh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vminuw(const PPCDecodeData& d, StringBuffer* str) {
  // vminuw [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vminuw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmladduhm(const PPCDecodeData& d, StringBuffer* str) {
  // vmladduhm [VD], [VA], [VB], [VC]
  size_t str_start = str->length();
  str->Append("vmladduhm");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VA.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VB());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VC());
}
void PrintDisasm_vmrghb(const PPCDecodeData& d, StringBuffer* str) {
  // vmrghb [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmrghb");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmrghh(const PPCDecodeData& d, StringBuffer* str) {
  // vmrghh [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmrghh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmrghw(const PPCDecodeData& d, StringBuffer* str) {
  // vmrghw [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmrghw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmrghw128(const PPCDecodeData& d, StringBuffer* str) {
  // vmrghw128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmrghw128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vmrglb(const PPCDecodeData& d, StringBuffer* str) {
  // vmrglb [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmrglb");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmrglh(const PPCDecodeData& d, StringBuffer* str) {
  // vmrglh [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmrglh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmrglw(const PPCDecodeData& d, StringBuffer* str) {
  // vmrglw [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmrglw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmrglw128(const PPCDecodeData& d, StringBuffer* str) {
  // vmrglw128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmrglw128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vmsum3fp128(const PPCDecodeData& d, StringBuffer* str) {
  // vmsum3fp128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmsum3fp128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vmsum4fp128(const PPCDecodeData& d, StringBuffer* str) {
  // vmsum4fp128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmsum4fp128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vmsummbm(const PPCDecodeData& d, StringBuffer* str) {
  // vmsummbm [VD], [VA], [VB], [VC]
  size_t str_start = str->length();
  str->Append("vmsummbm");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VA.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VB());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VC());
}
void PrintDisasm_vmsumshm(const PPCDecodeData& d, StringBuffer* str) {
  // vmsumshm [VD], [VA], [VB], [VC]
  size_t str_start = str->length();
  str->Append("vmsumshm");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VA.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VB());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VC());
}
void PrintDisasm_vmsumshs(const PPCDecodeData& d, StringBuffer* str) {
  // vmsumshs [VD], [VA], [VB], [VC]
  size_t str_start = str->length();
  str->Append("vmsumshs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VA.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VB());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VC());
}
void PrintDisasm_vmsumubm(const PPCDecodeData& d, StringBuffer* str) {
  // vmsumubm [VD], [VA], [VB], [VC]
  size_t str_start = str->length();
  str->Append("vmsumubm");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VA.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VB());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VC());
}
void PrintDisasm_vmsumuhm(const PPCDecodeData& d, StringBuffer* str) {
  // vmsumuhm [VD], [VA], [VB], [VC]
  size_t str_start = str->length();
  str->Append("vmsumuhm");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VA.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VB());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VC());
}
void PrintDisasm_vmsumuhs(const PPCDecodeData& d, StringBuffer* str) {
  // vmsumuhs [VD], [VA], [VB], [VC]
  size_t str_start = str->length();
  str->Append("vmsumuhs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VA.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VB());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VC());
}
void PrintDisasm_vmulesb(const PPCDecodeData& d, StringBuffer* str) {
  // vmulesb [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmulesb");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmulesh(const PPCDecodeData& d, StringBuffer* str) {
  // vmulesh [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmulesh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmuleub(const PPCDecodeData& d, StringBuffer* str) {
  // vmuleub [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmuleub");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmuleuh(const PPCDecodeData& d, StringBuffer* str) {
  // vmuleuh [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmuleuh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmulfp128(const PPCDecodeData& d, StringBuffer* str) {
  // vmulfp128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmulfp128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vmulosb(const PPCDecodeData& d, StringBuffer* str) {
  // vmulosb [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmulosb");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmulosh(const PPCDecodeData& d, StringBuffer* str) {
  // vmulosh [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmulosh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmuloub(const PPCDecodeData& d, StringBuffer* str) {
  // vmuloub [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmuloub");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vmulouh(const PPCDecodeData& d, StringBuffer* str) {
  // vmulouh [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vmulouh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vnmsubfp(const PPCDecodeData& d, StringBuffer* str) {
  // vnmsubfp [VD], [VA], [VC], [VB]
  size_t str_start = str->length();
  str->Append("vnmsubfp");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VA.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VC());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VB());
}
void PrintDisasm_vnmsubfp128(const PPCDecodeData& d, StringBuffer* str) {
  // vnmsubfp128 [VD], [VA], [VD], [VB]
  size_t str_start = str->length();
  str->Append("vnmsubfp128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vnor(const PPCDecodeData& d, StringBuffer* str) {
  // vnor [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vnor");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vnor128(const PPCDecodeData& d, StringBuffer* str) {
  // vnor128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vnor128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vor(const PPCDecodeData& d, StringBuffer* str) {
  // vor [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vor");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vor128(const PPCDecodeData& d, StringBuffer* str) {
  // vor128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vor128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vperm(const PPCDecodeData& d, StringBuffer* str) {
  // vperm [VD], [VA], [VB], [VC]
  size_t str_start = str->length();
  str->Append("vperm");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VA.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VB());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VC());
}
void PrintDisasm_vperm128(const PPCDecodeData& d, StringBuffer* str) {
  // vperm128 [VD], [VA], [VB], [VC]
  size_t str_start = str->length();
  str->Append("vperm128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_2.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_2.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_2.VB());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_2.VC());
}
void PrintDisasm_vpermwi128(const PPCDecodeData& d, StringBuffer* str) {
  // vpermwi128 [VD], [VB], [UIMM]
  size_t str_start = str->length();
  str->Append("vpermwi128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_P.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_P.VB());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.VX128_P.UIMM());
}
void PrintDisasm_vpkpx(const PPCDecodeData& d, StringBuffer* str) {
  // vpkpx [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkpx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vpkshss(const PPCDecodeData& d, StringBuffer* str) {
  // vpkshss [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkshss");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vpkshss128(const PPCDecodeData& d, StringBuffer* str) {
  // vpkshss128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkshss128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vpkshus(const PPCDecodeData& d, StringBuffer* str) {
  // vpkshus [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkshus");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vpkshus128(const PPCDecodeData& d, StringBuffer* str) {
  // vpkshus128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkshus128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vpkswss(const PPCDecodeData& d, StringBuffer* str) {
  // vpkswss [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkswss");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vpkswss128(const PPCDecodeData& d, StringBuffer* str) {
  // vpkswss128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkswss128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vpkswus(const PPCDecodeData& d, StringBuffer* str) {
  // vpkswus [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkswus");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vpkswus128(const PPCDecodeData& d, StringBuffer* str) {
  // vpkswus128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkswus128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vpkuhum(const PPCDecodeData& d, StringBuffer* str) {
  // vpkuhum [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkuhum");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vpkuhum128(const PPCDecodeData& d, StringBuffer* str) {
  // vpkuhum128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkuhum128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vpkuhus(const PPCDecodeData& d, StringBuffer* str) {
  // vpkuhus [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkuhus");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vpkuhus128(const PPCDecodeData& d, StringBuffer* str) {
  // vpkuhus128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkuhus128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vpkuwum(const PPCDecodeData& d, StringBuffer* str) {
  // vpkuwum [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkuwum");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vpkuwum128(const PPCDecodeData& d, StringBuffer* str) {
  // vpkuwum128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkuwum128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vpkuwus(const PPCDecodeData& d, StringBuffer* str) {
  // vpkuwus [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkuwus");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vpkuwus128(const PPCDecodeData& d, StringBuffer* str) {
  // vpkuwus128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vpkuwus128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vrefp(const PPCDecodeData& d, StringBuffer* str) {
  // vrefp [VD], [VB]
  size_t str_start = str->length();
  str->Append("vrefp");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vrefp128(const PPCDecodeData& d, StringBuffer* str) {
  // vrefp128 [VD], [VB]
  size_t str_start = str->length();
  str->Append("vrefp128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_3.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_3.VB());
}
void PrintDisasm_vrfim(const PPCDecodeData& d, StringBuffer* str) {
  // vrfim [VD], [VB]
  size_t str_start = str->length();
  str->Append("vrfim");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vrfim128(const PPCDecodeData& d, StringBuffer* str) {
  // vrfim128 [VD], [VB]
  size_t str_start = str->length();
  str->Append("vrfim128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_3.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_3.VB());
}
void PrintDisasm_vrfin(const PPCDecodeData& d, StringBuffer* str) {
  // vrfin [VD], [VB]
  size_t str_start = str->length();
  str->Append("vrfin");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vrfin128(const PPCDecodeData& d, StringBuffer* str) {
  // vrfin128 [VD], [VB]
  size_t str_start = str->length();
  str->Append("vrfin128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_3.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_3.VB());
}
void PrintDisasm_vrfip(const PPCDecodeData& d, StringBuffer* str) {
  // vrfip [VD], [VB]
  size_t str_start = str->length();
  str->Append("vrfip");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vrfip128(const PPCDecodeData& d, StringBuffer* str) {
  // vrfip128 [VD], [VB]
  size_t str_start = str->length();
  str->Append("vrfip128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_3.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_3.VB());
}
void PrintDisasm_vrfiz(const PPCDecodeData& d, StringBuffer* str) {
  // vrfiz [VD], [VB]
  size_t str_start = str->length();
  str->Append("vrfiz");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vrfiz128(const PPCDecodeData& d, StringBuffer* str) {
  // vrfiz128 [VD], [VB]
  size_t str_start = str->length();
  str->Append("vrfiz128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_3.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_3.VB());
}
void PrintDisasm_vrlb(const PPCDecodeData& d, StringBuffer* str) {
  // vrlb [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vrlb");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vrlh(const PPCDecodeData& d, StringBuffer* str) {
  // vrlh [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vrlh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vrlimi128(const PPCDecodeData& d, StringBuffer* str) {
  // vrlimi128 [VD], [VB], [IMM], [z]
  size_t str_start = str->length();
  str->Append("vrlimi128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_4.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_4.VB());
  str->Append(", ");
  str->AppendFormat("{}", d.VX128_4.IMM());
  str->Append(", ");
  str->AppendFormat("{}", d.VX128_4.z());
}
void PrintDisasm_vrlw(const PPCDecodeData& d, StringBuffer* str) {
  // vrlw [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vrlw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vrlw128(const PPCDecodeData& d, StringBuffer* str) {
  // vrlw128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vrlw128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vrsqrtefp(const PPCDecodeData& d, StringBuffer* str) {
  // vrsqrtefp [VD], [VB]
  size_t str_start = str->length();
  str->Append("vrsqrtefp");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vrsqrtefp128(const PPCDecodeData& d, StringBuffer* str) {
  // vrsqrtefp128 [VD], [VB]
  size_t str_start = str->length();
  str->Append("vrsqrtefp128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_3.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_3.VB());
}
void PrintDisasm_vsel(const PPCDecodeData& d, StringBuffer* str) {
  // vsel [VD], [VA], [VB], [VC]
  size_t str_start = str->length();
  str->Append("vsel");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VA.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VB());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VC());
}
void PrintDisasm_vsel128(const PPCDecodeData& d, StringBuffer* str) {
  // vsel128 [VD], [VA], [VB], [VD]
  size_t str_start = str->length();
  str->Append("vsel128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VD());
}
void PrintDisasm_vsl(const PPCDecodeData& d, StringBuffer* str) {
  // vsl [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsl");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vslb(const PPCDecodeData& d, StringBuffer* str) {
  // vslb [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vslb");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsldoi(const PPCDecodeData& d, StringBuffer* str) {
  // vsldoi [VD], [VA], [VB], [SHB]
  size_t str_start = str->length();
  str->Append("vsldoi");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VA.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VA.VB());
  str->Append(", ");
  str->AppendFormat("(UNHANDLED SHB)");
}
void PrintDisasm_vsldoi128(const PPCDecodeData& d, StringBuffer* str) {
  // vsldoi128 [VD], [VA], [VB], [SHB]
  size_t str_start = str->length();
  str->Append("vsldoi128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_5.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_5.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_5.VB());
  str->Append(", ");
  str->AppendFormat("(UNHANDLED SHB)");
}
void PrintDisasm_vslh(const PPCDecodeData& d, StringBuffer* str) {
  // vslh [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vslh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vslo(const PPCDecodeData& d, StringBuffer* str) {
  // vslo [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vslo");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vslo128(const PPCDecodeData& d, StringBuffer* str) {
  // vslo128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vslo128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vslw(const PPCDecodeData& d, StringBuffer* str) {
  // vslw [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vslw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vslw128(const PPCDecodeData& d, StringBuffer* str) {
  // vslw128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vslw128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vspltb(const PPCDecodeData& d, StringBuffer* str) {
  // vspltb [VD], [VB], [UIMM]
  size_t str_start = str->length();
  str->Append("vspltb");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.VX.UIMM());
}
void PrintDisasm_vsplth(const PPCDecodeData& d, StringBuffer* str) {
  // vsplth [VD], [VB], [UIMM]
  size_t str_start = str->length();
  str->Append("vsplth");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.VX.UIMM());
}
void PrintDisasm_vspltisb(const PPCDecodeData& d, StringBuffer* str) {
  // vspltisb [VD], [SIMM]
  size_t str_start = str->length();
  str->Append("vspltisb");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat(d.VX.SIMM() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.VX.SIMM()));
}
void PrintDisasm_vspltish(const PPCDecodeData& d, StringBuffer* str) {
  // vspltish [VD], [SIMM]
  size_t str_start = str->length();
  str->Append("vspltish");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat(d.VX.SIMM() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.VX.SIMM()));
}
void PrintDisasm_vspltisw(const PPCDecodeData& d, StringBuffer* str) {
  // vspltisw [VD], [SIMM]
  size_t str_start = str->length();
  str->Append("vspltisw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat(d.VX.SIMM() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.VX.SIMM()));
}
void PrintDisasm_vspltisw128(const PPCDecodeData& d, StringBuffer* str) {
  // vspltisw128 [VD], [SIMM]
  size_t str_start = str->length();
  str->Append("vspltisw128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_3.VD());
  str->Append(", ");
  str->AppendFormat(d.VX128_3.SIMM() < 0 ? "-0x{:X}" : "0x{:X}", std::abs(d.VX128_3.SIMM()));
}
void PrintDisasm_vspltw(const PPCDecodeData& d, StringBuffer* str) {
  // vspltw [VD], [VB], [UIMM]
  size_t str_start = str->length();
  str->Append("vspltw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.VX.UIMM());
}
void PrintDisasm_vspltw128(const PPCDecodeData& d, StringBuffer* str) {
  // vspltw128 [VD], [VB], [UIMM]
  size_t str_start = str->length();
  str->Append("vspltw128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128_3.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128_3.VB());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.VX128_3.UIMM());
}
void PrintDisasm_vsr(const PPCDecodeData& d, StringBuffer* str) {
  // vsr [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsr");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsrab(const PPCDecodeData& d, StringBuffer* str) {
  // vsrab [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsrab");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsrah(const PPCDecodeData& d, StringBuffer* str) {
  // vsrah [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsrah");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsraw(const PPCDecodeData& d, StringBuffer* str) {
  // vsraw [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsraw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsraw128(const PPCDecodeData& d, StringBuffer* str) {
  // vsraw128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsraw128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vsrb(const PPCDecodeData& d, StringBuffer* str) {
  // vsrb [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsrb");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsrh(const PPCDecodeData& d, StringBuffer* str) {
  // vsrh [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsrh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsro(const PPCDecodeData& d, StringBuffer* str) {
  // vsro [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsro");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsro128(const PPCDecodeData& d, StringBuffer* str) {
  // vsro128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsro128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vsrw(const PPCDecodeData& d, StringBuffer* str) {
  // vsrw [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsrw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsrw128(const PPCDecodeData& d, StringBuffer* str) {
  // vsrw128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsrw128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vsubcuw(const PPCDecodeData& d, StringBuffer* str) {
  // vsubcuw [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsubcuw");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsubfp(const PPCDecodeData& d, StringBuffer* str) {
  // vsubfp [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsubfp");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsubfp128(const PPCDecodeData& d, StringBuffer* str) {
  // vsubfp128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsubfp128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vsubsbs(const PPCDecodeData& d, StringBuffer* str) {
  // vsubsbs [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsubsbs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsubshs(const PPCDecodeData& d, StringBuffer* str) {
  // vsubshs [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsubshs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsubsws(const PPCDecodeData& d, StringBuffer* str) {
  // vsubsws [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsubsws");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsububm(const PPCDecodeData& d, StringBuffer* str) {
  // vsububm [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsububm");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsububs(const PPCDecodeData& d, StringBuffer* str) {
  // vsububs [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsububs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsubuhm(const PPCDecodeData& d, StringBuffer* str) {
  // vsubuhm [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsubuhm");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsubuhs(const PPCDecodeData& d, StringBuffer* str) {
  // vsubuhs [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsubuhs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsubuwm(const PPCDecodeData& d, StringBuffer* str) {
  // vsubuwm [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsubuwm");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsubuws(const PPCDecodeData& d, StringBuffer* str) {
  // vsubuws [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsubuws");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsum2sws(const PPCDecodeData& d, StringBuffer* str) {
  // vsum2sws [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsum2sws");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsum4sbs(const PPCDecodeData& d, StringBuffer* str) {
  // vsum4sbs [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsum4sbs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsum4shs(const PPCDecodeData& d, StringBuffer* str) {
  // vsum4shs [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsum4shs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsum4ubs(const PPCDecodeData& d, StringBuffer* str) {
  // vsum4ubs [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsum4ubs");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vsumsws(const PPCDecodeData& d, StringBuffer* str) {
  // vsumsws [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vsumsws");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vupkhpx(const PPCDecodeData& d, StringBuffer* str) {
  // vupkhpx [VD], [VB]
  size_t str_start = str->length();
  str->Append("vupkhpx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vupkhsb(const PPCDecodeData& d, StringBuffer* str) {
  // vupkhsb [VD], [VB]
  size_t str_start = str->length();
  str->Append("vupkhsb");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vupkhsb128(const PPCDecodeData& d, StringBuffer* str) {
  // vupkhsb128 [VD], [VB]
  size_t str_start = str->length();
  str->Append("vupkhsb128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vupkhsh(const PPCDecodeData& d, StringBuffer* str) {
  // vupkhsh [VD], [VB]
  size_t str_start = str->length();
  str->Append("vupkhsh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vupklpx(const PPCDecodeData& d, StringBuffer* str) {
  // vupklpx [VD], [VB]
  size_t str_start = str->length();
  str->Append("vupklpx");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vupklsb(const PPCDecodeData& d, StringBuffer* str) {
  // vupklsb [VD], [VB]
  size_t str_start = str->length();
  str->Append("vupklsb");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vupklsb128(const PPCDecodeData& d, StringBuffer* str) {
  // vupklsb128 [VD], [VB]
  size_t str_start = str->length();
  str->Append("vupklsb128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_vupklsh(const PPCDecodeData& d, StringBuffer* str) {
  // vupklsh [VD], [VB]
  size_t str_start = str->length();
  str->Append("vupklsh");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vxor(const PPCDecodeData& d, StringBuffer* str) {
  // vxor [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vxor");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX.VB());
}
void PrintDisasm_vxor128(const PPCDecodeData& d, StringBuffer* str) {
  // vxor128 [VD], [VA], [VB]
  size_t str_start = str->length();
  str->Append("vxor128");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("vr{}", d.VX128.VD());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VA());
  str->Append(", ");
  str->AppendFormat("vr{}", d.VX128.VB());
}
void PrintDisasm_xori(const PPCDecodeData& d, StringBuffer* str) {
  // xori [RA], [RS], [UIMM]
  size_t str_start = str->length();
  str->Append("xori");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.D.RS());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.D.UIMM());
}
void PrintDisasm_xoris(const PPCDecodeData& d, StringBuffer* str) {
  // xoris [RA], [RS], [UIMM]
  size_t str_start = str->length();
  str->Append("xoris");
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.D.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.D.RS());
  str->Append(", ");
  str->AppendFormat("0x{:X}", d.D.UIMM());
}
void PrintDisasm_xorx(const PPCDecodeData& d, StringBuffer* str) {
  // xor[Rc] [RA], [RS], [RB]
  size_t str_start = str->length();
  str->Append("xor");
  if (d.X.Rc()) str->Append('.');
  PadStringBuffer(str, str_start, kNamePad);
  str->AppendFormat("r{}", d.X.RA());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RS());
  str->Append(", ");
  str->AppendFormat("r{}", d.X.RB());
}
#define INIT_LIST(...) {__VA_ARGS__}
#define INSTRUCTION(opcode, mnem, form, group, type, desc, reads, writes, fn) \
    {PPCOpcodeGroup::group, PPCOpcodeFormat::form, opcode, mnem, desc, INIT_LIST reads, INIT_LIST writes, fn}
PPCOpcodeDisasmInfo ppc_opcode_disasm_table[] = {
  INSTRUCTION(0x7c000014, "addcx"       , kXO     , kI, kGeneral, "Add Carrying"                                                               , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kCA,PPCOpcodeField::kOEcond,PPCOpcodeField::kCRcond), PrintDisasm_addcx),
  INSTRUCTION(0x7c000114, "addex"       , kXO     , kI, kGeneral, "Add Extended"                                                               , (PPCOpcodeField::kRA,PPCOpcodeField::kRB,PPCOpcodeField::kCA), (PPCOpcodeField::kRD,PPCOpcodeField::kOEcond,PPCOpcodeField::kCRcond), PrintDisasm_addex),
  INSTRUCTION(0x38000000, "addi"        , kD      , kI, kGeneral, "Add Immediate"                                                              , (PPCOpcodeField::kRA0,PPCOpcodeField::kSIMM), (PPCOpcodeField::kRD), PrintDisasm_addi),
  INSTRUCTION(0x30000000, "addic"       , kD      , kI, kGeneral, "Add Immediate Carrying"                                                     , (PPCOpcodeField::kRA,PPCOpcodeField::kSIMM), (PPCOpcodeField::kRD,PPCOpcodeField::kCA), PrintDisasm_addic),
  INSTRUCTION(0x34000000, "addicx"      , kD      , kI, kGeneral, "Add Immediate Carrying and Record"                                          , (PPCOpcodeField::kRA,PPCOpcodeField::kSIMM), (PPCOpcodeField::kRD,PPCOpcodeField::kCA,PPCOpcodeField::kCR), PrintDisasm_addicx),
  INSTRUCTION(0x3c000000, "addis"       , kD      , kI, kGeneral, "Add Immediate Shifted"                                                      , (PPCOpcodeField::kRA0,PPCOpcodeField::kSIMM), (PPCOpcodeField::kRD), PrintDisasm_addis),
  INSTRUCTION(0x7c0001d4, "addmex"      , kXO     , kI, kGeneral, "Add to Minus One Extended"                                                  , (PPCOpcodeField::kRA,PPCOpcodeField::kCA), (PPCOpcodeField::kRD,PPCOpcodeField::kCA,PPCOpcodeField::kOEcond,PPCOpcodeField::kCRcond), PrintDisasm_addmex),
  INSTRUCTION(0x7c000214, "addx"        , kXO     , kI, kGeneral, "Add"                                                                        , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kOEcond,PPCOpcodeField::kCRcond), PrintDisasm_addx),
  INSTRUCTION(0x7c000194, "addzex"      , kXO     , kI, kGeneral, "Add to Zero Extended"                                                       , (PPCOpcodeField::kRA,PPCOpcodeField::kCA), (PPCOpcodeField::kRD,PPCOpcodeField::kCA,PPCOpcodeField::kOEcond,PPCOpcodeField::kCRcond), PrintDisasm_addzex),
  INSTRUCTION(0x7c000078, "andcx"       , kX      , kI, kGeneral, "AND with Complement"                                                        , (PPCOpcodeField::kRS,PPCOpcodeField::kRB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_andcx),
  INSTRUCTION(0x74000000, "andisx"      , kD      , kI, kGeneral, "AND Immediate Shifted"                                                      , (PPCOpcodeField::kRS,PPCOpcodeField::kUIMM), (PPCOpcodeField::kRA,PPCOpcodeField::kCR), PrintDisasm_andisx),
  INSTRUCTION(0x70000000, "andix"       , kD      , kI, kGeneral, "AND Immediate"                                                              , (PPCOpcodeField::kRS,PPCOpcodeField::kUIMM), (PPCOpcodeField::kRA,PPCOpcodeField::kCR), PrintDisasm_andix),
  INSTRUCTION(0x7c000038, "andx"        , kX      , kI, kGeneral, "AND"                                                                        , (PPCOpcodeField::kRS,PPCOpcodeField::kRB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_andx),
  INSTRUCTION(0x4c000420, "bcctrx"      , kXL     , kB, kSync   , "Branch Conditional to Count Register"                                       , (PPCOpcodeField::kLK,PPCOpcodeField::kBO,PPCOpcodeField::kBI,PPCOpcodeField::kCR,PPCOpcodeField::kCTR), (PPCOpcodeField::kLRcond), PrintDisasm_bcctrx),
  INSTRUCTION(0x4c000020, "bclrx"       , kXL     , kB, kSync   , "Branch Conditional to Link Register"                                        , (PPCOpcodeField::kLK,PPCOpcodeField::kBO,PPCOpcodeField::kBI,PPCOpcodeField::kCRcond,PPCOpcodeField::kCTRcond), (PPCOpcodeField::kCTRcond,PPCOpcodeField::kLRcond), PrintDisasm_bclrx),
  INSTRUCTION(0x40000000, "bcx"         , kB      , kB, kSync   , "Branch Conditional"                                                         , (PPCOpcodeField::kLK,PPCOpcodeField::kAA,PPCOpcodeField::kBO,PPCOpcodeField::kBI,PPCOpcodeField::kADDR,PPCOpcodeField::kCRcond,PPCOpcodeField::kCTRcond), (PPCOpcodeField::kCTRcond,PPCOpcodeField::kLRcond), PrintDisasm_bcx),
  INSTRUCTION(0x48000000, "bx"          , kI      , kB, kSync   , "Branch"                                                                     , (PPCOpcodeField::kLK,PPCOpcodeField::kAA,PPCOpcodeField::kADDR), (PPCOpcodeField::kLRcond), PrintDisasm_bx),
  INSTRUCTION(0x7c000000, "cmp"         , kX      , kI, kGeneral, "Compare"                                                                    , (PPCOpcodeField::kL,PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kCRFD), PrintDisasm_cmp),
  INSTRUCTION(0x2c000000, "cmpi"        , kD      , kI, kGeneral, "Compare Immediate"                                                          , (PPCOpcodeField::kL,PPCOpcodeField::kRA,PPCOpcodeField::kSIMM), (PPCOpcodeField::kRD,PPCOpcodeField::kCRFD), PrintDisasm_cmpi),
  INSTRUCTION(0x7c000040, "cmpl"        , kX      , kI, kGeneral, "Compare Logical"                                                            , (PPCOpcodeField::kL,PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kCRFD), PrintDisasm_cmpl),
  INSTRUCTION(0x28000000, "cmpli"       , kD      , kI, kGeneral, "Compare Logical Immediate"                                                  , (PPCOpcodeField::kL,PPCOpcodeField::kRA,PPCOpcodeField::kUIMM), (PPCOpcodeField::kCRFD), PrintDisasm_cmpli),
  INSTRUCTION(0x7c000074, "cntlzdx"     , kX      , kI, kGeneral, "Count Leading Zeros Doubleword"                                             , (PPCOpcodeField::kRS), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_cntlzdx),
  INSTRUCTION(0x7c000034, "cntlzwx"     , kX      , kI, kGeneral, "Count Leading Zeros Word"                                                   , (PPCOpcodeField::kRS), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_cntlzwx),
  INSTRUCTION(0x4c000202, "crand"       , kXL     , kC, kGeneral, "Condition Register AND"                                                     , (PPCOpcodeField::kCRBA,PPCOpcodeField::kCRBB), (PPCOpcodeField::kCRBD), PrintDisasm_crand),
  INSTRUCTION(0x4c000102, "crandc"      , kXL     , kC, kGeneral, "Condition Register AND with Complement"                                     , (PPCOpcodeField::kCRBA,PPCOpcodeField::kCRBB), (PPCOpcodeField::kCRBD), PrintDisasm_crandc),
  INSTRUCTION(0x4c000242, "creqv"       , kXL     , kC, kGeneral, "Condition Register Equivalent"                                              , (PPCOpcodeField::kCRBA,PPCOpcodeField::kCRBB), (PPCOpcodeField::kCRBD), PrintDisasm_creqv),
  INSTRUCTION(0x4c0001c2, "crnand"      , kXL     , kC, kGeneral, "Condition Register NAND"                                                    , (PPCOpcodeField::kCRBA,PPCOpcodeField::kCRBB), (PPCOpcodeField::kCRBD), PrintDisasm_crnand),
  INSTRUCTION(0x4c000042, "crnor"       , kXL     , kC, kGeneral, "Condition Register NOR"                                                     , (PPCOpcodeField::kCRBA,PPCOpcodeField::kCRBB), (PPCOpcodeField::kCRBD), PrintDisasm_crnor),
  INSTRUCTION(0x4c000382, "cror"        , kXL     , kC, kGeneral, "Condition Register OR"                                                      , (PPCOpcodeField::kCRBA,PPCOpcodeField::kCRBB), (PPCOpcodeField::kCRBD), PrintDisasm_cror),
  INSTRUCTION(0x4c000342, "crorc"       , kXL     , kC, kGeneral, "Condition Register OR with Complement"                                      , (PPCOpcodeField::kCRBA,PPCOpcodeField::kCRBB), (PPCOpcodeField::kCRBD), PrintDisasm_crorc),
  INSTRUCTION(0x4c000182, "crxor"       , kXL     , kC, kGeneral, "Condition Register XOR"                                                     , (PPCOpcodeField::kCRBA,PPCOpcodeField::kCRBB), (PPCOpcodeField::kCRBD), PrintDisasm_crxor),
  INSTRUCTION(0x7c0000ac, "dcbf"        , kX      , kM, kGeneral, "Data Cache Block Flush"                                                     , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_dcbf),
  INSTRUCTION(0x7c0003ac, "dcbi"        , kX      , kM, kGeneral, "Data Cache Block Invalidate"                                                , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_dcbi),
  INSTRUCTION(0x7c00006c, "dcbst"       , kX      , kM, kGeneral, "Data Cache Block Store"                                                     , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_dcbst),
  INSTRUCTION(0x7c00022c, "dcbt"        , kX      , kM, kGeneral, "Data Cache Block Touch"                                                     , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_dcbt),
  INSTRUCTION(0x7c0001ec, "dcbtst"      , kX      , kM, kGeneral, "Data Cache Block Touch for Store"                                           , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_dcbtst),
  INSTRUCTION(0x7c0007ec, "dcbz"        , kDCBZ   , kM, kGeneral, "Data Cache Block Clear to Zero"                                             , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_dcbz),
  INSTRUCTION(0x7c2007ec, "dcbz128"     , kDCBZ   , kM, kGeneral, "Data Cache Block Clear to Zero 128"                                         , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_dcbz128),
  INSTRUCTION(0x7c000392, "divdux"      , kXO     , kI, kGeneral, "Divide Doubleword Unsigned"                                                 , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kOEcond,PPCOpcodeField::kCRcond), PrintDisasm_divdux),
  INSTRUCTION(0x7c0003d2, "divdx"       , kXO     , kI, kGeneral, "Divide Doubleword"                                                          , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kOEcond,PPCOpcodeField::kCRcond), PrintDisasm_divdx),
  INSTRUCTION(0x7c000396, "divwux"      , kXO     , kI, kGeneral, "Divide Word Unsigned"                                                       , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kOEcond,PPCOpcodeField::kCRcond), PrintDisasm_divwux),
  INSTRUCTION(0x7c0003d6, "divwx"       , kXO     , kI, kGeneral, "Divide Word"                                                                , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kOEcond,PPCOpcodeField::kCRcond), PrintDisasm_divwx),
  INSTRUCTION(0x7c0006ac, "eieio"       , kX      , kI, kGeneral, "Enforce In-Order Execution of I/O"                                          , (), (), PrintDisasm_eieio),
  INSTRUCTION(0x7c000238, "eqvx"        , kX      , kI, kGeneral, "Equivalent"                                                                 , (PPCOpcodeField::kRS,PPCOpcodeField::kRB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_eqvx),
  INSTRUCTION(0x7c000774, "extsbx"      , kX      , kI, kGeneral, "Extend Sign Byte"                                                           , (PPCOpcodeField::kRS), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_extsbx),
  INSTRUCTION(0x7c000734, "extshx"      , kX      , kI, kGeneral, "Extend Sign Half Word"                                                      , (PPCOpcodeField::kRS), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_extshx),
  INSTRUCTION(0x7c0007b4, "extswx"      , kX      , kI, kGeneral, "Extend Sign Word"                                                           , (PPCOpcodeField::kRS), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_extswx),
  INSTRUCTION(0xfc000210, "fabsx"       , kX      , kF, kGeneral, "Floating Absolute Value"                                                    , (PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond), PrintDisasm_fabsx),
  INSTRUCTION(0xec00002a, "faddsx"      , kA      , kF, kGeneral, "Floating Add Single"                                                        , (PPCOpcodeField::kFA,PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_faddsx),
  INSTRUCTION(0xfc00002a, "faddx"       , kA      , kF, kGeneral, "Floating Add"                                                               , (PPCOpcodeField::kFA,PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_faddx),
  INSTRUCTION(0xfc00069c, "fcfidx"      , kX      , kF, kGeneral, "Floating Convert From Integer Doubleword"                                   , (PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fcfidx),
  INSTRUCTION(0xfc000040, "fcmpo"       , kX      , kF, kGeneral, "Floating Compare Ordered"                                                   , (PPCOpcodeField::kFA,PPCOpcodeField::kFB), (PPCOpcodeField::kCRFD,PPCOpcodeField::kFPSCR), PrintDisasm_fcmpo),
  INSTRUCTION(0xfc000000, "fcmpu"       , kX      , kF, kGeneral, "Floating Compare Unordered"                                                 , (PPCOpcodeField::kFA,PPCOpcodeField::kFB), (PPCOpcodeField::kCRFD,PPCOpcodeField::kFPSCR), PrintDisasm_fcmpu),
  INSTRUCTION(0xfc00065c, "fctidx"      , kX      , kF, kGeneral, "Floating Convert to Integer Doubleword"                                     , (PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fctidx),
  INSTRUCTION(0xfc00065e, "fctidzx"     , kX      , kF, kGeneral, "Floating Convert to Integer Doubleword with Round Toward Zero"              , (PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fctidzx),
  INSTRUCTION(0xfc00001c, "fctiwx"      , kX      , kF, kGeneral, "Floating Convert to Integer Word"                                           , (PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fctiwx),
  INSTRUCTION(0xfc00001e, "fctiwzx"     , kX      , kF, kGeneral, "Floating Convert to Integer Word with Round Toward Zero"                    , (PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fctiwzx),
  INSTRUCTION(0xec000024, "fdivsx"      , kA      , kF, kGeneral, "Floating Divide Single"                                                     , (PPCOpcodeField::kFA,PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fdivsx),
  INSTRUCTION(0xfc000024, "fdivx"       , kA      , kF, kGeneral, "Floating Divide"                                                            , (PPCOpcodeField::kFA,PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fdivx),
  INSTRUCTION(0xec00003a, "fmaddsx"     , kA      , kF, kGeneral, "Floating Multiply-Add Single"                                               , (PPCOpcodeField::kFA,PPCOpcodeField::kFC,PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fmaddsx),
  INSTRUCTION(0xfc00003a, "fmaddx"      , kA      , kF, kGeneral, "Floating Multiply-Add"                                                      , (PPCOpcodeField::kFA,PPCOpcodeField::kFC,PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fmaddx),
  INSTRUCTION(0xfc000090, "fmrx"        , kX      , kF, kGeneral, "Floating Move Register"                                                     , (PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond), PrintDisasm_fmrx),
  INSTRUCTION(0xec000038, "fmsubsx"     , kA      , kF, kGeneral, "Floating Multiply-Subtract Single"                                          , (PPCOpcodeField::kFA,PPCOpcodeField::kFC,PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fmsubsx),
  INSTRUCTION(0xfc000038, "fmsubx"      , kA      , kF, kGeneral, "Floating Multiply-Subtract"                                                 , (PPCOpcodeField::kFA,PPCOpcodeField::kFC,PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fmsubx),
  INSTRUCTION(0xec000032, "fmulsx"      , kA      , kF, kGeneral, "Floating Multiply Single"                                                   , (PPCOpcodeField::kFA,PPCOpcodeField::kFC), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fmulsx),
  INSTRUCTION(0xfc000032, "fmulx"       , kA      , kF, kGeneral, "Floating Multiply"                                                          , (PPCOpcodeField::kFA,PPCOpcodeField::kFC), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fmulx),
  INSTRUCTION(0xfc000110, "fnabsx"      , kX      , kF, kGeneral, "Floating Negative Absolute Value"                                           , (PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond), PrintDisasm_fnabsx),
  INSTRUCTION(0xfc000050, "fnegx"       , kX      , kF, kGeneral, "Floating Negate"                                                            , (PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond), PrintDisasm_fnegx),
  INSTRUCTION(0xec00003e, "fnmaddsx"    , kA      , kF, kGeneral, "Floating Negative Multiply-Add Single"                                      , (PPCOpcodeField::kFA,PPCOpcodeField::kFC,PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fnmaddsx),
  INSTRUCTION(0xfc00003e, "fnmaddx"     , kA      , kF, kGeneral, "Floating Negative Multiply-Add"                                             , (PPCOpcodeField::kFA,PPCOpcodeField::kFC,PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fnmaddx),
  INSTRUCTION(0xec00003c, "fnmsubsx"    , kA      , kF, kGeneral, "Floating Negative Multiply-Subtract Single"                                 , (PPCOpcodeField::kFA,PPCOpcodeField::kFC,PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fnmsubsx),
  INSTRUCTION(0xfc00003c, "fnmsubx"     , kA      , kF, kGeneral, "Floating Negative Multiply-Subtract"                                        , (PPCOpcodeField::kFA,PPCOpcodeField::kFC,PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fnmsubx),
  INSTRUCTION(0xec000030, "fresx"       , kA      , kF, kGeneral, "Floating Reciprocal Estimate Single"                                        , (PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fresx),
  INSTRUCTION(0xfc000018, "frspx"       , kX      , kF, kGeneral, "Floating Round to Single"                                                   , (PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_frspx),
  INSTRUCTION(0xfc000034, "frsqrtex"    , kA      , kF, kGeneral, "Floating Reciprocal Square Root Estimate"                                   , (PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_frsqrtex),
  INSTRUCTION(0xfc00002e, "fselx"       , kA      , kF, kGeneral, "Floating Select"                                                            , (PPCOpcodeField::kFA,PPCOpcodeField::kFC,PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond), PrintDisasm_fselx),
  INSTRUCTION(0xec00002c, "fsqrtsx"     , kA      , kF, kGeneral, "Floating Square Root Single"                                                , (PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fsqrtsx),
  INSTRUCTION(0xfc00002c, "fsqrtx"      , kA      , kF, kGeneral, "Floating Square Root"                                                       , (PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fsqrtx),
  INSTRUCTION(0xec000028, "fsubsx"      , kA      , kF, kGeneral, "Floating Subtract Single"                                                   , (PPCOpcodeField::kFA,PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fsubsx),
  INSTRUCTION(0xfc000028, "fsubx"       , kA      , kF, kGeneral, "Floating Subtract"                                                          , (PPCOpcodeField::kFA,PPCOpcodeField::kFB), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond,PPCOpcodeField::kFPSCR), PrintDisasm_fsubx),
  INSTRUCTION(0x7c0007ac, "icbi"        , kX      , kM, kGeneral, "Instruction Cache Block Invalidate"                                         , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_icbi),
  INSTRUCTION(0x4c00012c, "isync"       , kXL     , kI, kGeneral, "Instruction Synchronize"                                                    , (), (), PrintDisasm_isync),
  INSTRUCTION(0x88000000, "lbz"         , kD      , kM, kGeneral, "Load Byte and Zero"                                                         , (PPCOpcodeField::kRA0,PPCOpcodeField::kd), (PPCOpcodeField::kRD), PrintDisasm_lbz),
  INSTRUCTION(0x8c000000, "lbzu"        , kD      , kM, kGeneral, "Load Byte and Zero with Update"                                             , (PPCOpcodeField::kRA,PPCOpcodeField::kd), (PPCOpcodeField::kRD,PPCOpcodeField::kRA), PrintDisasm_lbzu),
  INSTRUCTION(0x7c0000ee, "lbzux"       , kX      , kM, kGeneral, "Load Byte and Zero with Update Indexed"                                     , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kRA), PrintDisasm_lbzux),
  INSTRUCTION(0x7c0000ae, "lbzx"        , kX      , kM, kGeneral, "Load Byte and Zero Indexed"                                                 , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kRD), PrintDisasm_lbzx),
  INSTRUCTION(0xe8000000, "ld"          , kDS     , kM, kGeneral, "Load Doubleword"                                                            , (PPCOpcodeField::kRA0,PPCOpcodeField::kds), (PPCOpcodeField::kRD), PrintDisasm_ld),
  INSTRUCTION(0x7c0000a8, "ldarx"       , kX      , kM, kGeneral, "Load Doubleword and Reserve Indexed"                                        , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kRD), PrintDisasm_ldarx),
  INSTRUCTION(0x7c000428, "ldbrx"       , kX      , kM, kGeneral, "Load Doubleword Byte-Reverse Indexed"                                       , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kRD), PrintDisasm_ldbrx),
  INSTRUCTION(0xe8000001, "ldu"         , kDS     , kM, kGeneral, "Load Doubleword with Update"                                                , (PPCOpcodeField::kRA,PPCOpcodeField::kds), (PPCOpcodeField::kRD,PPCOpcodeField::kRA), PrintDisasm_ldu),
  INSTRUCTION(0x7c00006a, "ldux"        , kX      , kM, kGeneral, "Load Doubleword with Update Indexed"                                        , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kRA), PrintDisasm_ldux),
  INSTRUCTION(0x7c00002a, "ldx"         , kX      , kM, kGeneral, "Load Doubleword Indexed"                                                    , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kRD), PrintDisasm_ldx),
  INSTRUCTION(0xc8000000, "lfd"         , kD      , kM, kGeneral, "Load Floating-Point Double"                                                 , (PPCOpcodeField::kRA0,PPCOpcodeField::kd), (PPCOpcodeField::kFD), PrintDisasm_lfd),
  INSTRUCTION(0xcc000000, "lfdu"        , kD      , kM, kGeneral, "Load Floating-Point Double with Update"                                     , (PPCOpcodeField::kRA,PPCOpcodeField::kd), (PPCOpcodeField::kFD,PPCOpcodeField::kRA), PrintDisasm_lfdu),
  INSTRUCTION(0x7c0004ee, "lfdux"       , kX      , kM, kGeneral, "Load Floating-Point Double with Update Indexed"                             , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kFD,PPCOpcodeField::kRA), PrintDisasm_lfdux),
  INSTRUCTION(0x7c0004ae, "lfdx"        , kX      , kM, kGeneral, "Load Floating-Point Double Indexed"                                         , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kFD), PrintDisasm_lfdx),
  INSTRUCTION(0xc0000000, "lfs"         , kD      , kM, kGeneral, "Load Floating-Point Single"                                                 , (PPCOpcodeField::kRA0,PPCOpcodeField::kd), (PPCOpcodeField::kFD), PrintDisasm_lfs),
  INSTRUCTION(0xc4000000, "lfsu"        , kD      , kM, kGeneral, "Load Floating-Point Single with Update"                                     , (PPCOpcodeField::kRA,PPCOpcodeField::kd), (PPCOpcodeField::kFD,PPCOpcodeField::kRA), PrintDisasm_lfsu),
  INSTRUCTION(0x7c00046e, "lfsux"       , kX      , kM, kGeneral, "Load Floating-Point Single with Update Indexed"                             , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kFD,PPCOpcodeField::kRA), PrintDisasm_lfsux),
  INSTRUCTION(0x7c00042e, "lfsx"        , kX      , kM, kGeneral, "Load Floating-Point Single Indexed"                                         , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kFD), PrintDisasm_lfsx),
  INSTRUCTION(0xa8000000, "lha"         , kD      , kM, kGeneral, "Load Half Word Algebraic"                                                   , (PPCOpcodeField::kRA0,PPCOpcodeField::kd), (PPCOpcodeField::kRD), PrintDisasm_lha),
  INSTRUCTION(0xac000000, "lhau"        , kD      , kM, kGeneral, "Load Half Word Algebraic with Update"                                       , (PPCOpcodeField::kRA,PPCOpcodeField::kd), (PPCOpcodeField::kRD,PPCOpcodeField::kRA), PrintDisasm_lhau),
  INSTRUCTION(0x7c0002ee, "lhaux"       , kX      , kM, kGeneral, "Load Half Word Algebraic with Update Indexed"                               , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kRA), PrintDisasm_lhaux),
  INSTRUCTION(0x7c0002ae, "lhax"        , kX      , kM, kGeneral, "Load Half Word Algebraic Indexed"                                           , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kRD), PrintDisasm_lhax),
  INSTRUCTION(0x7c00062c, "lhbrx"       , kX      , kM, kGeneral, "Load Half Word Byte-Reverse Indexed"                                        , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kRD), PrintDisasm_lhbrx),
  INSTRUCTION(0xa0000000, "lhz"         , kD      , kM, kGeneral, "Load Half Word and Zero"                                                    , (PPCOpcodeField::kRA0,PPCOpcodeField::kd), (PPCOpcodeField::kRD), PrintDisasm_lhz),
  INSTRUCTION(0xa4000000, "lhzu"        , kD      , kM, kGeneral, "Load Half Word and Zero with Update"                                        , (PPCOpcodeField::kRA,PPCOpcodeField::kd), (PPCOpcodeField::kRD,PPCOpcodeField::kRA), PrintDisasm_lhzu),
  INSTRUCTION(0x7c00026e, "lhzux"       , kX      , kM, kGeneral, "Load Half Word and Zero with Update Indexed"                                , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kRA), PrintDisasm_lhzux),
  INSTRUCTION(0x7c00022e, "lhzx"        , kX      , kM, kGeneral, "Load Half Word and Zero Indexed"                                            , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kRD), PrintDisasm_lhzx),
  INSTRUCTION(0xb8000000, "lmw"         , kD      , kM, kGeneral, "Load Multiple Word"                                                         , (), (), nullptr),
  INSTRUCTION(0x7c0004aa, "lswi"        , kX      , kM, kGeneral, "Load String Word Immediate"                                                 , (), (), nullptr),
  INSTRUCTION(0x7c00042a, "lswx"        , kX      , kM, kGeneral, "Load String Word Indexed"                                                   , (), (), nullptr),
  INSTRUCTION(0x7c00000e, "lvebx"       , kX      , kM, kGeneral, "Load Vector Element Byte Indexed"                                           , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvebx),
  INSTRUCTION(0x7c00004e, "lvehx"       , kX      , kM, kGeneral, "Load Vector Element Half Word Indexed"                                      , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvehx),
  INSTRUCTION(0x7c00008e, "lvewx"       , kX      , kM, kGeneral, "Load Vector Element Word Indexed"                                           , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvewx),
  INSTRUCTION(0x10000083, "lvewx128"    , kVX128_1, kM, kGeneral, "Load Vector Element Word Indexed 128"                                       , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvewx128),
  INSTRUCTION(0x7c00040e, "lvlx"        , kX      , kM, kGeneral, "Load Vector Left Indexed"                                                   , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvlx),
  INSTRUCTION(0x10000403, "lvlx128"     , kVX128_1, kM, kGeneral, "Load Vector Left Indexed 128"                                               , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvlx128),
  INSTRUCTION(0x7c00060e, "lvlxl"       , kX      , kM, kGeneral, "Load Vector Left Indexed LRU"                                               , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvlxl),
  INSTRUCTION(0x10000603, "lvlxl128"    , kVX128_1, kM, kGeneral, "Load Vector Left Indexed LRU 128"                                           , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvlxl128),
  INSTRUCTION(0x7c00044e, "lvrx"        , kX      , kM, kGeneral, "Load Vector Right Indexed"                                                  , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvrx),
  INSTRUCTION(0x10000443, "lvrx128"     , kVX128_1, kM, kGeneral, "Load Vector Right Indexed 128"                                              , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvrx128),
  INSTRUCTION(0x7c00064e, "lvrxl"       , kX      , kM, kGeneral, "Load Vector Right Indexed LRU"                                              , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvrxl),
  INSTRUCTION(0x10000643, "lvrxl128"    , kVX128_1, kM, kGeneral, "Load Vector Right Indexed LRU 128"                                          , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvrxl128),
  INSTRUCTION(0x7c00000c, "lvsl"        , kX      , kV, kGeneral, "Load Vector for Shift Left Indexed"                                         , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvsl),
  INSTRUCTION(0x10000003, "lvsl128"     , kVX128_1, kV, kGeneral, "Load Vector for Shift Left Indexed 128"                                     , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvsl128),
  INSTRUCTION(0x7c00004c, "lvsr"        , kX      , kV, kGeneral, "Load Vector for Shift Right Indexed"                                        , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvsr),
  INSTRUCTION(0x10000043, "lvsr128"     , kVX128_1, kV, kGeneral, "Load Vector for Shift Right Indexed 128"                                    , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvsr128),
  INSTRUCTION(0x7c0000ce, "lvx"         , kX      , kM, kGeneral, "Load Vector Indexed"                                                        , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvx),
  INSTRUCTION(0x100000c3, "lvx128"      , kVX128_1, kM, kGeneral, "Load Vector Indexed 128"                                                    , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvx128),
  INSTRUCTION(0x7c0002ce, "lvxl"        , kX      , kM, kGeneral, "Load Vector Indexed LRU"                                                    , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvxl),
  INSTRUCTION(0x100002c3, "lvxl128"     , kVX128_1, kM, kGeneral, "Load Vector Indexed LRU 128"                                                , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kVD), PrintDisasm_lvxl128),
  INSTRUCTION(0xe8000002, "lwa"         , kDS     , kM, kGeneral, "Load Word Algebraic"                                                        , (PPCOpcodeField::kRA0,PPCOpcodeField::kds), (PPCOpcodeField::kRD), PrintDisasm_lwa),
  INSTRUCTION(0x7c000028, "lwarx"       , kX      , kM, kGeneral, "Load Word and Reserve Indexed"                                              , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kRD), PrintDisasm_lwarx),
  INSTRUCTION(0x7c0002ea, "lwaux"       , kX      , kM, kGeneral, "Load Word Algebraic with Update Indexed"                                    , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kRA), PrintDisasm_lwaux),
  INSTRUCTION(0x7c0002aa, "lwax"        , kX      , kM, kGeneral, "Load Word Algebraic Indexed"                                                , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kRD), PrintDisasm_lwax),
  INSTRUCTION(0x7c00042c, "lwbrx"       , kX      , kM, kGeneral, "Load Word Byte-Reverse Indexed"                                             , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kRD), PrintDisasm_lwbrx),
  INSTRUCTION(0x80000000, "lwz"         , kD      , kM, kGeneral, "Load Word and Zero"                                                         , (PPCOpcodeField::kRA0,PPCOpcodeField::kd), (PPCOpcodeField::kRD), PrintDisasm_lwz),
  INSTRUCTION(0x84000000, "lwzu"        , kD      , kM, kGeneral, "Load Word and Zero with Update"                                             , (PPCOpcodeField::kRA,PPCOpcodeField::kd), (PPCOpcodeField::kRD,PPCOpcodeField::kRA), PrintDisasm_lwzu),
  INSTRUCTION(0x7c00006e, "lwzux"       , kX      , kM, kGeneral, "Load Word and Zero with Update Indexed"                                     , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kRA), PrintDisasm_lwzux),
  INSTRUCTION(0x7c00002e, "lwzx"        , kX      , kM, kGeneral, "Load Word and Zero Indexed"                                                 , (PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kRD), PrintDisasm_lwzx),
  INSTRUCTION(0x4c000000, "mcrf"        , kXL     , kC, kGeneral, "Move Condition Register Field"                                              , (PPCOpcodeField::kCRFS), (PPCOpcodeField::kCRFD), PrintDisasm_mcrf),
  INSTRUCTION(0xfc000080, "mcrfs"       , kX      , kC, kGeneral, "Move to Condition Register from FPSCR"                                      , (PPCOpcodeField::kCRFS,PPCOpcodeField::kFPSCR), (PPCOpcodeField::kCRFD,PPCOpcodeField::kFPSCR), PrintDisasm_mcrfs),
  INSTRUCTION(0x7c000400, "mcrxr"       , kX      , kC, kGeneral, "Move to Condition Register from XER"                                        , (PPCOpcodeField::kCR), (PPCOpcodeField::kCRFD), PrintDisasm_mcrxr),
  INSTRUCTION(0x7c000026, "mfcr"        , kX      , kC, kGeneral, "Move from Condition Register"                                               , (PPCOpcodeField::kCR), (PPCOpcodeField::kRD), PrintDisasm_mfcr),
  INSTRUCTION(0xfc00048e, "mffsx"       , kX      , kC, kGeneral, "Move from FPSCR"                                                            , (PPCOpcodeField::kFPSCR), (PPCOpcodeField::kFD,PPCOpcodeField::kCRcond), PrintDisasm_mffsx),
  INSTRUCTION(0x7c0000a6, "mfmsr"       , kX      , kC, kSync   , "Move from Machine State Register"                                           , (PPCOpcodeField::kMSR), (PPCOpcodeField::kRD), PrintDisasm_mfmsr),
  INSTRUCTION(0x7c0002a6, "mfspr"       , kXFX    , kC, kGeneral, "Move from Special-Purpose Register"                                         , (PPCOpcodeField::kSPR), (PPCOpcodeField::kRD), PrintDisasm_mfspr),
  INSTRUCTION(0x7c0002e6, "mftb"        , kXFX    , kC, kGeneral, "Move from Time Base"                                                        , (PPCOpcodeField::kTBR), (PPCOpcodeField::kRD), PrintDisasm_mftb),
  INSTRUCTION(0x10000604, "mfvscr"      , kVX     , kC, kGeneral, "Move from VSCR"                                                             , (PPCOpcodeField::kVSCR), (PPCOpcodeField::kVD), nullptr),
  INSTRUCTION(0x7c000120, "mtcrf"       , kXFX    , kC, kGeneral, "Move to Condition Register Fields"                                          , (PPCOpcodeField::kRS), (PPCOpcodeField::kCRM), PrintDisasm_mtcrf),
  INSTRUCTION(0xfc00008c, "mtfsb0x"     , kX      , kC, kGeneral, "Move to FPSCR Bit 0"                                                        , (), (PPCOpcodeField::kFPSCRD,PPCOpcodeField::kCRcond), PrintDisasm_mtfsb0x),
  INSTRUCTION(0xfc00004c, "mtfsb1x"     , kX      , kC, kGeneral, "Move to FPSCR Bit 1"                                                        , (), (PPCOpcodeField::kFPSCRD,PPCOpcodeField::kCRcond), PrintDisasm_mtfsb1x),
  INSTRUCTION(0xfc00010c, "mtfsfix"     , kX      , kC, kGeneral, "Move to FPSCR Field Immediate"                                              , (PPCOpcodeField::kIMM), (PPCOpcodeField::kCRFD,PPCOpcodeField::kCRcond), PrintDisasm_mtfsfix),
  INSTRUCTION(0xfc00058e, "mtfsfx"      , kXFL    , kC, kGeneral, "Move to FPSCR Fields"                                                       , (PPCOpcodeField::kFM,PPCOpcodeField::kFB), (PPCOpcodeField::kFPSCR,PPCOpcodeField::kCRcond), PrintDisasm_mtfsfx),
  INSTRUCTION(0x7c000124, "mtmsr"       , kX      , kC, kSync   , "Move to Machine State Register"                                             , (PPCOpcodeField::kRS), (PPCOpcodeField::kMSR), PrintDisasm_mtmsr),
  INSTRUCTION(0x7c000164, "mtmsrd"      , kX      , kC, kSync   , "Move to Machine State Register Doubleword"                                  , (PPCOpcodeField::kRS), (PPCOpcodeField::kMSR), PrintDisasm_mtmsrd),
  INSTRUCTION(0x7c0003a6, "mtspr"       , kXFX    , kC, kGeneral, "Move to Special-Purpose Register"                                           , (PPCOpcodeField::kRS), (PPCOpcodeField::kSPR), PrintDisasm_mtspr),
  INSTRUCTION(0x10000644, "mtvscr"      , kVX     , kC, kGeneral, "Move to VSCR"                                                               , (PPCOpcodeField::kVB), (PPCOpcodeField::kVSCR), nullptr),
  INSTRUCTION(0x7c000012, "mulhdux"     , kXO     , kI, kGeneral, "Multiply High Doubleword Unsigned"                                          , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kCRcond), PrintDisasm_mulhdux),
  INSTRUCTION(0x7c000092, "mulhdx"      , kXO     , kI, kGeneral, "Multiply High Doubleword"                                                   , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kCRcond), PrintDisasm_mulhdx),
  INSTRUCTION(0x7c000016, "mulhwux"     , kXO     , kI, kGeneral, "Multiply High Word Unsigned"                                                , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kCRcond), PrintDisasm_mulhwux),
  INSTRUCTION(0x7c000096, "mulhwx"      , kXO     , kI, kGeneral, "Multiply High Word"                                                         , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kCRcond), PrintDisasm_mulhwx),
  INSTRUCTION(0x7c0001d2, "mulldx"      , kXO     , kI, kGeneral, "Multiply Low Doubleword"                                                    , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kCRcond,PPCOpcodeField::kOEcond), PrintDisasm_mulldx),
  INSTRUCTION(0x1c000000, "mulli"       , kD      , kI, kGeneral, "Multiply Low Immediate"                                                     , (PPCOpcodeField::kRA,PPCOpcodeField::kSIMM), (PPCOpcodeField::kRD), PrintDisasm_mulli),
  INSTRUCTION(0x7c0001d6, "mullwx"      , kXO     , kI, kGeneral, "Multiply Low Word"                                                          , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kCRcond,PPCOpcodeField::kOEcond), PrintDisasm_mullwx),
  INSTRUCTION(0x7c0003b8, "nandx"       , kX      , kI, kGeneral, "NAND"                                                                       , (PPCOpcodeField::kRS,PPCOpcodeField::kRB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_nandx),
  INSTRUCTION(0x7c0000d0, "negx"        , kXO     , kI, kGeneral, "Negate"                                                                     , (PPCOpcodeField::kRA), (PPCOpcodeField::kRD,PPCOpcodeField::kCRcond,PPCOpcodeField::kOEcond), PrintDisasm_negx),
  INSTRUCTION(0x7c0000f8, "norx"        , kX      , kI, kGeneral, "NOR"                                                                        , (PPCOpcodeField::kRS,PPCOpcodeField::kRB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_norx),
  INSTRUCTION(0x7c000338, "orcx"        , kX      , kI, kGeneral, "OR with Complement"                                                         , (PPCOpcodeField::kRS,PPCOpcodeField::kRB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_orcx),
  INSTRUCTION(0x60000000, "ori"         , kD      , kI, kGeneral, "OR Immediate"                                                               , (PPCOpcodeField::kRS,PPCOpcodeField::kUIMM), (PPCOpcodeField::kRA), PrintDisasm_ori),
  INSTRUCTION(0x64000000, "oris"        , kD      , kI, kGeneral, "OR Immediate Shifted"                                                       , (PPCOpcodeField::kRS,PPCOpcodeField::kUIMM), (PPCOpcodeField::kRA), PrintDisasm_oris),
  INSTRUCTION(0x7c000378, "orx"         , kX      , kI, kGeneral, "OR"                                                                         , (PPCOpcodeField::kRS,PPCOpcodeField::kRB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_orx),
  INSTRUCTION(0x78000010, "rldclx"      , kMDS    , kI, kGeneral, "Rotate Left Doubleword then Clear Left"                                     , (PPCOpcodeField::kRS,PPCOpcodeField::kRB,PPCOpcodeField::kMB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_rldclx),
  INSTRUCTION(0x78000012, "rldcrx"      , kMDS    , kI, kGeneral, "Rotate Left Doubleword then Clear Right"                                    , (PPCOpcodeField::kRS,PPCOpcodeField::kRB,PPCOpcodeField::kME), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_rldcrx),
  INSTRUCTION(0x78000000, "rldiclx"     , kMD     , kI, kGeneral, "Rotate Left Doubleword Immediate then Clear Left"                           , (PPCOpcodeField::kRS,PPCOpcodeField::kSH,PPCOpcodeField::kMB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_rldiclx),
  INSTRUCTION(0x78000004, "rldicrx"     , kMD     , kI, kGeneral, "Rotate Left Doubleword Immediate then Clear Right"                          , (PPCOpcodeField::kRS,PPCOpcodeField::kSH,PPCOpcodeField::kME), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_rldicrx),
  INSTRUCTION(0x78000008, "rldicx"      , kMD     , kI, kGeneral, "Rotate Left Doubleword Immediate then Clear"                                , (PPCOpcodeField::kRS,PPCOpcodeField::kSH,PPCOpcodeField::kMB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_rldicx),
  INSTRUCTION(0x7800000c, "rldimix"     , kMD     , kI, kGeneral, "Rotate Left Doubleword Immediate then Mask Insert"                          , (PPCOpcodeField::kRS,PPCOpcodeField::kSH,PPCOpcodeField::kMB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_rldimix),
  INSTRUCTION(0x50000000, "rlwimix"     , kM      , kI, kGeneral, "Rotate Left Word Immediate then Mask Insert"                                , (PPCOpcodeField::kRS,PPCOpcodeField::kSH,PPCOpcodeField::kMB,PPCOpcodeField::kME), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_rlwimix),
  INSTRUCTION(0x54000000, "rlwinmx"     , kM      , kI, kGeneral, "Rotate Left Word Immediate then AND with Mask"                              , (PPCOpcodeField::kRS,PPCOpcodeField::kSH,PPCOpcodeField::kMB,PPCOpcodeField::kME), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_rlwinmx),
  INSTRUCTION(0x5c000000, "rlwnmx"      , kM      , kI, kGeneral, "Rotate Left Word then AND with Mask"                                        , (PPCOpcodeField::kRS,PPCOpcodeField::kRB,PPCOpcodeField::kMB,PPCOpcodeField::kME), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_rlwnmx),
  INSTRUCTION(0x44000002, "sc"          , kSC     , kB, kSync   , "System Call"                                                                , (PPCOpcodeField::kLEV), (), PrintDisasm_sc),
  INSTRUCTION(0x7c000036, "sldx"        , kX      , kI, kGeneral, "Shift Left Doubleword"                                                      , (PPCOpcodeField::kRS,PPCOpcodeField::kRB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_sldx),
  INSTRUCTION(0x7c000030, "slwx"        , kX      , kI, kGeneral, "Shift Left Word"                                                            , (PPCOpcodeField::kRS,PPCOpcodeField::kRB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_slwx),
  INSTRUCTION(0x7c000674, "sradix"      , kXS     , kI, kGeneral, "Shift Right Algebraic Doubleword Immediate"                                 , (PPCOpcodeField::kRS,PPCOpcodeField::kSH), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond,PPCOpcodeField::kCA), PrintDisasm_sradix),
  INSTRUCTION(0x7c000634, "sradx"       , kX      , kI, kGeneral, "Shift Right Algebraic Doubleword"                                           , (PPCOpcodeField::kRS,PPCOpcodeField::kRB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond,PPCOpcodeField::kCA), PrintDisasm_sradx),
  INSTRUCTION(0x7c000670, "srawix"      , kX      , kI, kGeneral, "Shift Right Algebraic Word Immediate"                                       , (PPCOpcodeField::kRS,PPCOpcodeField::kSH), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond,PPCOpcodeField::kCA), PrintDisasm_srawix),
  INSTRUCTION(0x7c000630, "srawx"       , kX      , kI, kGeneral, "Shift Right Algebraic Word"                                                 , (PPCOpcodeField::kRS,PPCOpcodeField::kRB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond,PPCOpcodeField::kCA), PrintDisasm_srawx),
  INSTRUCTION(0x7c000436, "srdx"        , kX      , kI, kGeneral, "Shift Right Doubleword"                                                     , (PPCOpcodeField::kRS,PPCOpcodeField::kRB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_srdx),
  INSTRUCTION(0x7c000430, "srwx"        , kX      , kI, kGeneral, "Shift Right Word"                                                           , (PPCOpcodeField::kRS,PPCOpcodeField::kRB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_srwx),
  INSTRUCTION(0x98000000, "stb"         , kD      , kM, kGeneral, "Store Byte"                                                                 , (PPCOpcodeField::kRS,PPCOpcodeField::kRA0,PPCOpcodeField::kd), (), PrintDisasm_stb),
  INSTRUCTION(0x9c000000, "stbu"        , kD      , kM, kGeneral, "Store Byte with Update"                                                     , (PPCOpcodeField::kRS,PPCOpcodeField::kRA,PPCOpcodeField::kd), (PPCOpcodeField::kRA), PrintDisasm_stbu),
  INSTRUCTION(0x7c0001ee, "stbux"       , kX      , kM, kGeneral, "Store Byte with Update Indexed"                                             , (PPCOpcodeField::kRS,PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRA), PrintDisasm_stbux),
  INSTRUCTION(0x7c0001ae, "stbx"        , kX      , kM, kGeneral, "Store Byte Indexed"                                                         , (PPCOpcodeField::kRS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stbx),
  INSTRUCTION(0xf8000000, "std"         , kDS     , kM, kGeneral, "Store Doubleword"                                                           , (PPCOpcodeField::kRS,PPCOpcodeField::kRA,PPCOpcodeField::kds), (), PrintDisasm_std),
  INSTRUCTION(0x7c000528, "stdbrx"      , kX      , kM, kGeneral, "Store Doubleword Byte-Reverse Indexed"                                      , (PPCOpcodeField::kRS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stdbrx),
  INSTRUCTION(0x7c0001ad, "stdcx"       , kX      , kM, kGeneral, "Store Doubleword Conditional Indexed"                                       , (PPCOpcodeField::kRS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kCR), PrintDisasm_stdcx),
  INSTRUCTION(0xf8000001, "stdu"        , kDS     , kM, kGeneral, "Store Doubleword with Update"                                               , (PPCOpcodeField::kRS,PPCOpcodeField::kRA,PPCOpcodeField::kds), (PPCOpcodeField::kRA), PrintDisasm_stdu),
  INSTRUCTION(0x7c00016a, "stdux"       , kX      , kM, kGeneral, "Store Doubleword with Update Indexed"                                       , (PPCOpcodeField::kRS,PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRA), PrintDisasm_stdux),
  INSTRUCTION(0x7c00012a, "stdx"        , kX      , kM, kGeneral, "Store Doubleword Indexed"                                                   , (PPCOpcodeField::kRS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stdx),
  INSTRUCTION(0xd8000000, "stfd"        , kD      , kM, kGeneral, "Store Floating-Point Double"                                                , (PPCOpcodeField::kFS,PPCOpcodeField::kRA0,PPCOpcodeField::kd), (), PrintDisasm_stfd),
  INSTRUCTION(0xdc000000, "stfdu"       , kD      , kM, kGeneral, "Store Floating-Point Double with Update"                                    , (PPCOpcodeField::kFS,PPCOpcodeField::kRA,PPCOpcodeField::kd), (PPCOpcodeField::kRA), PrintDisasm_stfdu),
  INSTRUCTION(0x7c0005ee, "stfdux"      , kX      , kM, kGeneral, "Store Floating-Point Double with Update Indexed"                            , (PPCOpcodeField::kFS,PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRA), PrintDisasm_stfdux),
  INSTRUCTION(0x7c0005ae, "stfdx"       , kX      , kM, kGeneral, "Store Floating-Point Double Indexed"                                        , (PPCOpcodeField::kFS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stfdx),
  INSTRUCTION(0x7c0007ae, "stfiwx"      , kX      , kM, kGeneral, "Store Floating-Point as Integer Word Indexed"                               , (PPCOpcodeField::kFS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stfiwx),
  INSTRUCTION(0xd0000000, "stfs"        , kD      , kM, kGeneral, "Store Floating-Point Single"                                                , (PPCOpcodeField::kFS,PPCOpcodeField::kRA0,PPCOpcodeField::kd), (), PrintDisasm_stfs),
  INSTRUCTION(0xd4000000, "stfsu"       , kD      , kM, kGeneral, "Store Floating-Point Single with Update"                                    , (PPCOpcodeField::kFS,PPCOpcodeField::kRA,PPCOpcodeField::kd), (PPCOpcodeField::kRA), PrintDisasm_stfsu),
  INSTRUCTION(0x7c00056e, "stfsux"      , kX      , kM, kGeneral, "Store Floating-Point Single with Update Indexed"                            , (PPCOpcodeField::kFS,PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRA), PrintDisasm_stfsux),
  INSTRUCTION(0x7c00052e, "stfsx"       , kX      , kM, kGeneral, "Store Floating-Point Single Indexed"                                        , (PPCOpcodeField::kFS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stfsx),
  INSTRUCTION(0xb0000000, "sth"         , kD      , kM, kGeneral, "Store Half Word"                                                            , (PPCOpcodeField::kRS,PPCOpcodeField::kRA0,PPCOpcodeField::kd), (), PrintDisasm_sth),
  INSTRUCTION(0x7c00072c, "sthbrx"      , kX      , kM, kGeneral, "Store Half Word Byte-Reverse Indexed"                                       , (PPCOpcodeField::kRS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_sthbrx),
  INSTRUCTION(0xb4000000, "sthu"        , kD      , kM, kGeneral, "Store Half Word with Update"                                                , (PPCOpcodeField::kRS,PPCOpcodeField::kRA,PPCOpcodeField::kd), (PPCOpcodeField::kRA), PrintDisasm_sthu),
  INSTRUCTION(0x7c00036e, "sthux"       , kX      , kM, kGeneral, "Store Half Word with Update Indexed"                                        , (PPCOpcodeField::kRS,PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRA), PrintDisasm_sthux),
  INSTRUCTION(0x7c00032e, "sthx"        , kX      , kM, kGeneral, "Store Half Word Indexed"                                                    , (PPCOpcodeField::kRS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_sthx),
  INSTRUCTION(0xbc000000, "stmw"        , kD      , kM, kGeneral, "Store Multiple Word"                                                        , (), (), nullptr),
  INSTRUCTION(0x7c0005aa, "stswi"       , kX      , kM, kGeneral, "Store String Word Immediate"                                                , (), (), nullptr),
  INSTRUCTION(0x7c00052a, "stswx"       , kX      , kM, kGeneral, "Store String Word Indexed"                                                  , (), (), nullptr),
  INSTRUCTION(0x7c00010e, "stvebx"      , kX      , kM, kGeneral, "Store Vector Element Byte Indexed"                                          , (PPCOpcodeField::kVS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stvebx),
  INSTRUCTION(0x7c00014e, "stvehx"      , kX      , kM, kGeneral, "Store Vector Element Half Word Indexed"                                     , (PPCOpcodeField::kVS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stvehx),
  INSTRUCTION(0x7c00018e, "stvewx"      , kX      , kM, kGeneral, "Store Vector Element Word Indexed"                                          , (PPCOpcodeField::kVS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stvewx),
  INSTRUCTION(0x10000183, "stvewx128"   , kVX128_1, kM, kGeneral, "Store Vector Element Word Indexed 128"                                      , (PPCOpcodeField::kVS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stvewx128),
  INSTRUCTION(0x7c00050e, "stvlx"       , kX      , kM, kGeneral, "Store Vector Left Indexed"                                                  , (PPCOpcodeField::kVS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stvlx),
  INSTRUCTION(0x10000503, "stvlx128"    , kVX128_1, kM, kGeneral, "Store Vector Left Indexed 128"                                              , (PPCOpcodeField::kVS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stvlx128),
  INSTRUCTION(0x7c00070e, "stvlxl"      , kX      , kM, kGeneral, "Store Vector Left Indexed LRU"                                              , (PPCOpcodeField::kVS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stvlxl),
  INSTRUCTION(0x10000703, "stvlxl128"   , kVX128_1, kM, kGeneral, "Store Vector Left Indexed LRU 128"                                          , (PPCOpcodeField::kVS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stvlxl128),
  INSTRUCTION(0x7c00054e, "stvrx"       , kX      , kM, kGeneral, "Store Vector Right Indexed"                                                 , (PPCOpcodeField::kVS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stvrx),
  INSTRUCTION(0x10000543, "stvrx128"    , kVX128_1, kM, kGeneral, "Store Vector Right Indexed 128"                                             , (PPCOpcodeField::kVS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stvrx128),
  INSTRUCTION(0x7c00074e, "stvrxl"      , kX      , kM, kGeneral, "Store Vector Right Indexed LRU"                                             , (PPCOpcodeField::kVS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stvrxl),
  INSTRUCTION(0x10000743, "stvrxl128"   , kVX128_1, kM, kGeneral, "Store Vector Right Indexed LRU 128"                                         , (PPCOpcodeField::kVS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stvrxl128),
  INSTRUCTION(0x7c0001ce, "stvx"        , kX      , kM, kGeneral, "Store Vector Indexed"                                                       , (PPCOpcodeField::kVS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stvx),
  INSTRUCTION(0x100001c3, "stvx128"     , kVX128_1, kM, kGeneral, "Store Vector Indexed 128"                                                   , (PPCOpcodeField::kVS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stvx128),
  INSTRUCTION(0x7c0003ce, "stvxl"       , kX      , kM, kGeneral, "Store Vector Indexed LRU"                                                   , (PPCOpcodeField::kVS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stvxl),
  INSTRUCTION(0x100003c3, "stvxl128"    , kVX128_1, kM, kGeneral, "Store Vector Indexed LRU 128"                                               , (PPCOpcodeField::kVS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stvxl128),
  INSTRUCTION(0x90000000, "stw"         , kD      , kM, kGeneral, "Store Word"                                                                 , (PPCOpcodeField::kRS,PPCOpcodeField::kRA0,PPCOpcodeField::kd), (), PrintDisasm_stw),
  INSTRUCTION(0x7c00052c, "stwbrx"      , kX      , kM, kGeneral, "Store Word Byte-Reverse Indexed"                                            , (PPCOpcodeField::kRS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stwbrx),
  INSTRUCTION(0x7c00012d, "stwcx"       , kX      , kM, kGeneral, "Store Word Conditional Indexed"                                             , (PPCOpcodeField::kRS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (PPCOpcodeField::kCR), PrintDisasm_stwcx),
  INSTRUCTION(0x94000000, "stwu"        , kD      , kM, kGeneral, "Store Word with Update"                                                     , (PPCOpcodeField::kRS,PPCOpcodeField::kRA,PPCOpcodeField::kd), (PPCOpcodeField::kRA), PrintDisasm_stwu),
  INSTRUCTION(0x7c00016e, "stwux"       , kX      , kM, kGeneral, "Store Word with Update Indexed"                                             , (PPCOpcodeField::kRS,PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRA), PrintDisasm_stwux),
  INSTRUCTION(0x7c00012e, "stwx"        , kX      , kM, kGeneral, "Store Word Indexed"                                                         , (PPCOpcodeField::kRS,PPCOpcodeField::kRA0,PPCOpcodeField::kRB), (), PrintDisasm_stwx),
  INSTRUCTION(0x7c000010, "subfcx"      , kXO     , kI, kGeneral, "Subtract From Carrying"                                                     , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kCRcond,PPCOpcodeField::kOEcond), PrintDisasm_subfcx),
  INSTRUCTION(0x7c000110, "subfex"      , kXO     , kI, kGeneral, "Subtract From Extended"                                                     , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kCRcond,PPCOpcodeField::kOEcond), PrintDisasm_subfex),
  INSTRUCTION(0x20000000, "subficx"     , kD      , kI, kGeneral, "Subtract From Immediate Carrying"                                           , (PPCOpcodeField::kRA,PPCOpcodeField::kSIMM), (PPCOpcodeField::kRD,PPCOpcodeField::kCA), PrintDisasm_subficx),
  INSTRUCTION(0x7c0001d0, "subfmex"     , kXO     , kI, kGeneral, "Subtract From Minus One Extended"                                           , (PPCOpcodeField::kRA,PPCOpcodeField::kCA), (PPCOpcodeField::kRD,PPCOpcodeField::kCRcond,PPCOpcodeField::kOEcond,PPCOpcodeField::kCA), PrintDisasm_subfmex),
  INSTRUCTION(0x7c000050, "subfx"       , kXO     , kI, kGeneral, "Subtract From"                                                              , (PPCOpcodeField::kRA,PPCOpcodeField::kRB), (PPCOpcodeField::kRD,PPCOpcodeField::kCRcond,PPCOpcodeField::kOEcond), PrintDisasm_subfx),
  INSTRUCTION(0x7c000190, "subfzex"     , kXO     , kI, kGeneral, "Subtract From Zero Extended"                                                , (PPCOpcodeField::kRA,PPCOpcodeField::kCA), (PPCOpcodeField::kRD,PPCOpcodeField::kCRcond,PPCOpcodeField::kOEcond,PPCOpcodeField::kCA), PrintDisasm_subfzex),
  INSTRUCTION(0x7c0004ac, "sync"        , kX      , kI, kGeneral, "Synchronize"                                                                , (), (), PrintDisasm_sync),
  INSTRUCTION(0x7c000088, "td"          , kX      , kB, kGeneral, "Trap Doubleword"                                                            , (PPCOpcodeField::kTO,PPCOpcodeField::kRA,PPCOpcodeField::kRB), (), PrintDisasm_td),
  INSTRUCTION(0x08000000, "tdi"         , kD      , kB, kGeneral, "Trap Doubleword Immediate"                                                  , (PPCOpcodeField::kTO,PPCOpcodeField::kRA,PPCOpcodeField::kSIMM), (), PrintDisasm_tdi),
  INSTRUCTION(0x7c000008, "tw"          , kX      , kB, kGeneral, "Trap Word"                                                                  , (PPCOpcodeField::kTO,PPCOpcodeField::kRA,PPCOpcodeField::kRB), (), PrintDisasm_tw),
  INSTRUCTION(0x0c000000, "twi"         , kD      , kB, kGeneral, "Trap Word Immediate"                                                        , (PPCOpcodeField::kTO,PPCOpcodeField::kRA,PPCOpcodeField::kSIMM), (), PrintDisasm_twi),
  INSTRUCTION(0x10000180, "vaddcuw"     , kVX     , kV, kGeneral, "Vector Add Carryout Unsigned Word"                                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vaddcuw),
  INSTRUCTION(0x1000000a, "vaddfp"      , kVX     , kV, kGeneral, "Vector Add Floating Point"                                                  , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vaddfp),
  INSTRUCTION(0x14000010, "vaddfp128"   , kVX128  , kV, kGeneral, "Vector128 Add Floating Point"                                               , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vaddfp128),
  INSTRUCTION(0x10000300, "vaddsbs"     , kVX     , kV, kGeneral, "Vector Add Signed Byte Saturate"                                            , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vaddsbs),
  INSTRUCTION(0x10000340, "vaddshs"     , kVX     , kV, kGeneral, "Vector Add Signed Half Word Saturate"                                       , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vaddshs),
  INSTRUCTION(0x10000380, "vaddsws"     , kVX     , kV, kGeneral, "Vector Add Signed Word Saturate"                                            , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vaddsws),
  INSTRUCTION(0x10000000, "vaddubm"     , kVX     , kV, kGeneral, "Vector Add Unsigned Byte Modulo"                                            , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vaddubm),
  INSTRUCTION(0x10000200, "vaddubs"     , kVX     , kV, kGeneral, "Vector Add Unsigned Byte Saturate"                                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vaddubs),
  INSTRUCTION(0x10000040, "vadduhm"     , kVX     , kV, kGeneral, "Vector Add Unsigned Half Word Modulo"                                       , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vadduhm),
  INSTRUCTION(0x10000240, "vadduhs"     , kVX     , kV, kGeneral, "Vector Add Unsigned Half Word Saturate"                                     , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vadduhs),
  INSTRUCTION(0x10000080, "vadduwm"     , kVX     , kV, kGeneral, "Vector Add Unsigned Word Modulo"                                            , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vadduwm),
  INSTRUCTION(0x10000280, "vadduws"     , kVX     , kV, kGeneral, "Vector Add Unsigned Word Saturate"                                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vadduws),
  INSTRUCTION(0x10000404, "vand"        , kVX     , kV, kGeneral, "Vector Logical AND"                                                         , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vand),
  INSTRUCTION(0x14000210, "vand128"     , kVX128  , kV, kGeneral, "Vector128 Logical AND"                                                      , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vand128),
  INSTRUCTION(0x10000444, "vandc"       , kVX     , kV, kGeneral, "Vector Logical AND with Complement"                                         , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vandc),
  INSTRUCTION(0x14000250, "vandc128"    , kVX128  , kV, kGeneral, "Vector128 Logical AND with Complement"                                      , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vandc128),
  INSTRUCTION(0x10000502, "vavgsb"      , kVX     , kV, kGeneral, "Vector Average Signed Byte"                                                 , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vavgsb),
  INSTRUCTION(0x10000542, "vavgsh"      , kVX     , kV, kGeneral, "Vector Average Signed Half Word"                                            , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vavgsh),
  INSTRUCTION(0x10000582, "vavgsw"      , kVX     , kV, kGeneral, "Vector Average Signed Word"                                                 , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vavgsw),
  INSTRUCTION(0x10000402, "vavgub"      , kVX     , kV, kGeneral, "Vector Average Unsigned Byte"                                               , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vavgub),
  INSTRUCTION(0x10000442, "vavguh"      , kVX     , kV, kGeneral, "Vector Average Unsigned Half Word"                                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vavguh),
  INSTRUCTION(0x10000482, "vavguw"      , kVX     , kV, kGeneral, "Vector Average Unsigned Word"                                               , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vavguw),
  INSTRUCTION(0x18000230, "vcfpsxws128" , kVX128_3, kV, kGeneral, "Vector128 Convert From Floating-Point to Signed Fixed-Point Word Saturate"  , (PPCOpcodeField::kVB,PPCOpcodeField::kUIMM), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vcfpsxws128),
  INSTRUCTION(0x18000270, "vcfpuxws128" , kVX128_3, kV, kGeneral, "Vector128 Convert From Floating-Point to Unsigned Fixed-Point Word Saturate", (PPCOpcodeField::kVB,PPCOpcodeField::kUIMM), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vcfpuxws128),
  INSTRUCTION(0x1000034a, "vcfsx"       , kVX     , kV, kGeneral, "Vector Convert from Signed Fixed-Point Word"                                , (PPCOpcodeField::kVB,PPCOpcodeField::kUIMM), (PPCOpcodeField::kVD), PrintDisasm_vcfsx),
  INSTRUCTION(0x1000030a, "vcfux"       , kVX     , kV, kGeneral, "Vector Convert from Unsigned Fixed-Point Word"                              , (PPCOpcodeField::kVB,PPCOpcodeField::kUIMM), (PPCOpcodeField::kVD), PrintDisasm_vcfux),
  INSTRUCTION(0x100003c6, "vcmpbfp"     , kVC     , kV, kGeneral, "Vector Compare Bounds Floating Point"                                       , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpbfp),
  INSTRUCTION(0x18000180, "vcmpbfp128"  , kVX128_R, kV, kGeneral, "Vector128 Compare Bounds Floating Point"                                    , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpbfp128),
  INSTRUCTION(0x100000c6, "vcmpeqfp"    , kVC     , kV, kGeneral, "Vector Compare Equal-to Floating Point"                                     , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpeqfp),
  INSTRUCTION(0x18000000, "vcmpeqfp128" , kVX128_R, kV, kGeneral, "Vector128 Compare Equal-to Floating Point"                                  , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpeqfp128),
  INSTRUCTION(0x10000006, "vcmpequb"    , kVC     , kV, kGeneral, "Vector Compare Equal-to Unsigned Byte"                                      , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpequb),
  INSTRUCTION(0x10000046, "vcmpequh"    , kVC     , kV, kGeneral, "Vector Compare Equal-to Unsigned Half Word"                                 , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpequh),
  INSTRUCTION(0x10000086, "vcmpequw"    , kVC     , kV, kGeneral, "Vector Compare Equal-to Unsigned Word"                                      , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpequw),
  INSTRUCTION(0x18000200, "vcmpequw128" , kVX128_R, kV, kGeneral, "Vector128 Compare Equal-to Unsigned Word"                                   , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpequw128),
  INSTRUCTION(0x100001c6, "vcmpgefp"    , kVC     , kV, kGeneral, "Vector Compare Greater-Than-or-Equal-to Floating Point"                     , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpgefp),
  INSTRUCTION(0x18000080, "vcmpgefp128" , kVX128_R, kV, kGeneral, "Vector128 Compare Greater-Than-or-Equal-to Floating Point"                  , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpgefp128),
  INSTRUCTION(0x100002c6, "vcmpgtfp"    , kVC     , kV, kGeneral, "Vector Compare Greater-Than Floating Point"                                 , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpgtfp),
  INSTRUCTION(0x18000100, "vcmpgtfp128" , kVX128_R, kV, kGeneral, "Vector128 Compare Greater-Than Floating-Point"                              , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpgtfp128),
  INSTRUCTION(0x10000306, "vcmpgtsb"    , kVC     , kV, kGeneral, "Vector Compare Greater-Than Signed Byte"                                    , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpgtsb),
  INSTRUCTION(0x10000346, "vcmpgtsh"    , kVC     , kV, kGeneral, "Vector Compare Greater-Than Signed Half Word"                               , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpgtsh),
  INSTRUCTION(0x10000386, "vcmpgtsw"    , kVC     , kV, kGeneral, "Vector Compare Greater-Than Signed Word"                                    , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpgtsw),
  INSTRUCTION(0x10000206, "vcmpgtub"    , kVC     , kV, kGeneral, "Vector Compare Greater-Than Unsigned Byte"                                  , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpgtub),
  INSTRUCTION(0x10000246, "vcmpgtuh"    , kVC     , kV, kGeneral, "Vector Compare Greater-Than Unsigned Half Word"                             , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpgtuh),
  INSTRUCTION(0x10000286, "vcmpgtuw"    , kVC     , kV, kGeneral, "Vector Compare Greater-Than Unsigned Word"                                  , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kCRcond), PrintDisasm_vcmpgtuw),
  INSTRUCTION(0x180002b0, "vcsxwfp128"  , kVX128_3, kV, kGeneral, "Vector128 Convert From Signed Fixed-Point Word to Floating-Point"           , (PPCOpcodeField::kVB,PPCOpcodeField::kUIMM), (PPCOpcodeField::kVD), PrintDisasm_vcsxwfp128),
  INSTRUCTION(0x100003ca, "vctsxs"      , kVX     , kV, kGeneral, "Vector Convert to Signed Fixed-Point Word Saturate"                         , (PPCOpcodeField::kVB,PPCOpcodeField::kUIMM), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vctsxs),
  INSTRUCTION(0x1000038a, "vctuxs"      , kVX     , kV, kGeneral, "Vector Convert to Unsigned Fixed-Point Word Saturate"                       , (PPCOpcodeField::kVB,PPCOpcodeField::kUIMM), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vctuxs),
  INSTRUCTION(0x180002f0, "vcuxwfp128"  , kVX128_3, kV, kGeneral, "Vector128 Convert From Unsigned Fixed-Point Word to Floating-Point"         , (PPCOpcodeField::kVB,PPCOpcodeField::kUIMM), (PPCOpcodeField::kVD), PrintDisasm_vcuxwfp128),
  INSTRUCTION(0x1000018a, "vexptefp"    , kVX     , kV, kGeneral, "Vector 2 Raised to the Exponent Estimate Floating Point"                    , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vexptefp),
  INSTRUCTION(0x180006b0, "vexptefp128" , kVX128_3, kV, kGeneral, "Vector128 Log2 Estimate Floating Point"                                     , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vexptefp128),
  INSTRUCTION(0x100001ca, "vlogefp"     , kVX     , kV, kGeneral, "Vector Log2 Estimate Floating Point"                                        , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vlogefp),
  INSTRUCTION(0x180006f0, "vlogefp128"  , kVX128_3, kV, kGeneral, "Vector128 Log2 Estimate Floating Point"                                     , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vlogefp128),
  INSTRUCTION(0x14000110, "vmaddcfp128" , kVX128  , kV, kGeneral, "Vector128 Multiply Add Floating Point"                                      , (PPCOpcodeField::kVA,PPCOpcodeField::kVD,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmaddcfp128),
  INSTRUCTION(0x1000002e, "vmaddfp"     , kVA     , kV, kGeneral, "Vector Multiply-Add Floating Point"                                         , (PPCOpcodeField::kVA,PPCOpcodeField::kVC,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmaddfp),
  INSTRUCTION(0x140000d0, "vmaddfp128"  , kVX128  , kV, kGeneral, "Vector128 Multiply Add Floating Point"                                      , (PPCOpcodeField::kVA,PPCOpcodeField::kVC,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmaddfp128),
  INSTRUCTION(0x1000040a, "vmaxfp"      , kVX     , kV, kGeneral, "Vector Maximum Floating Point"                                              , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmaxfp),
  INSTRUCTION(0x18000280, "vmaxfp128"   , kVX128  , kV, kGeneral, "Vector128 Maximum Floating Point"                                           , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmaxfp128),
  INSTRUCTION(0x10000102, "vmaxsb"      , kVX     , kV, kGeneral, "Vector Maximum Signed Byte"                                                 , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmaxsb),
  INSTRUCTION(0x10000142, "vmaxsh"      , kVX     , kV, kGeneral, "Vector Maximum Signed Half Word"                                            , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmaxsh),
  INSTRUCTION(0x10000182, "vmaxsw"      , kVX     , kV, kGeneral, "Vector Maximum Signed Word"                                                 , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmaxsw),
  INSTRUCTION(0x10000002, "vmaxub"      , kVX     , kV, kGeneral, "Vector Maximum Unsigned Byte"                                               , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmaxub),
  INSTRUCTION(0x10000042, "vmaxuh"      , kVX     , kV, kGeneral, "Vector Maximum Unsigned Half Word"                                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmaxuh),
  INSTRUCTION(0x10000082, "vmaxuw"      , kVX     , kV, kGeneral, "Vector Maximum Unsigned Word"                                               , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmaxuw),
  INSTRUCTION(0x10000020, "vmhaddshs"   , kVA     , kV, kGeneral, "Vector Multiply-High and Add Signed Signed Half Word Saturate"              , (PPCOpcodeField::kVA,PPCOpcodeField::kVB,PPCOpcodeField::kVC), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vmhaddshs),
  INSTRUCTION(0x10000021, "vmhraddshs"  , kVA     , kV, kGeneral, "Vector Multiply-High Round and Add Signed Signed Half Word Saturate"        , (PPCOpcodeField::kVA,PPCOpcodeField::kVB,PPCOpcodeField::kVC), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vmhraddshs),
  INSTRUCTION(0x1000044a, "vminfp"      , kVX     , kV, kGeneral, "Vector Minimum Floating Point"                                              , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vminfp),
  INSTRUCTION(0x180002c0, "vminfp128"   , kVX128  , kV, kGeneral, "Vector128 Minimum Floating Point"                                           , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vminfp128),
  INSTRUCTION(0x10000302, "vminsb"      , kVX     , kV, kGeneral, "Vector Minimum Signed Byte"                                                 , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vminsb),
  INSTRUCTION(0x10000342, "vminsh"      , kVX     , kV, kGeneral, "Vector Minimum Signed Half Word"                                            , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vminsh),
  INSTRUCTION(0x10000382, "vminsw"      , kVX     , kV, kGeneral, "Vector Minimum Signed Word"                                                 , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vminsw),
  INSTRUCTION(0x10000202, "vminub"      , kVX     , kV, kGeneral, "Vector Minimum Unsigned Byte"                                               , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vminub),
  INSTRUCTION(0x10000242, "vminuh"      , kVX     , kV, kGeneral, "Vector Minimum Unsigned Half Word"                                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vminuh),
  INSTRUCTION(0x10000282, "vminuw"      , kVX     , kV, kGeneral, "Vector Minimum Unsigned Word"                                               , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vminuw),
  INSTRUCTION(0x10000022, "vmladduhm"   , kVA     , kV, kGeneral, "Vector Multiply-Low and Add Unsigned Half Word Modulo"                      , (PPCOpcodeField::kVA,PPCOpcodeField::kVB,PPCOpcodeField::kVC), (PPCOpcodeField::kVD), PrintDisasm_vmladduhm),
  INSTRUCTION(0x1000000c, "vmrghb"      , kVX     , kV, kGeneral, "Vector Merge High Byte"                                                     , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmrghb),
  INSTRUCTION(0x1000004c, "vmrghh"      , kVX     , kV, kGeneral, "Vector Merge High Half Word"                                                , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmrghh),
  INSTRUCTION(0x1000008c, "vmrghw"      , kVX     , kV, kGeneral, "Vector Merge High Word"                                                     , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmrghw),
  INSTRUCTION(0x18000300, "vmrghw128"   , kVX128  , kV, kGeneral, "Vector128 Merge High Word"                                                  , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmrghw128),
  INSTRUCTION(0x1000010c, "vmrglb"      , kVX     , kV, kGeneral, "Vector Merge Low Byte"                                                      , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmrglb),
  INSTRUCTION(0x1000014c, "vmrglh"      , kVX     , kV, kGeneral, "Vector Merge Low Half Word"                                                 , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmrglh),
  INSTRUCTION(0x1000018c, "vmrglw"      , kVX     , kV, kGeneral, "Vector Merge Low Word"                                                      , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmrglw),
  INSTRUCTION(0x18000340, "vmrglw128"   , kVX128  , kV, kGeneral, "Vector128 Merge Low Word"                                                   , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmrglw128),
  INSTRUCTION(0x14000190, "vmsum3fp128" , kVX128  , kV, kGeneral, "Vector128 Multiply Sum 3-way Floating Point"                                , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmsum3fp128),
  INSTRUCTION(0x140001d0, "vmsum4fp128" , kVX128  , kV, kGeneral, "Vector128 Multiply Sum 4-way Floating-Point"                                , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmsum4fp128),
  INSTRUCTION(0x10000025, "vmsummbm"    , kVA     , kV, kGeneral, "Vector Multiply-Sum Mixed-Sign Byte Modulo"                                 , (PPCOpcodeField::kVA,PPCOpcodeField::kVB,PPCOpcodeField::kVC), (PPCOpcodeField::kVD), PrintDisasm_vmsummbm),
  INSTRUCTION(0x10000028, "vmsumshm"    , kVA     , kV, kGeneral, "Vector Multiply-Sum Signed Half Word Modulo"                                , (PPCOpcodeField::kVA,PPCOpcodeField::kVB,PPCOpcodeField::kVC), (PPCOpcodeField::kVD), PrintDisasm_vmsumshm),
  INSTRUCTION(0x10000029, "vmsumshs"    , kVA     , kV, kGeneral, "Vector Multiply-Sum Signed Half Word Saturate"                              , (PPCOpcodeField::kVA,PPCOpcodeField::kVB,PPCOpcodeField::kVC), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vmsumshs),
  INSTRUCTION(0x10000024, "vmsumubm"    , kVA     , kV, kGeneral, "Vector Multiply-Sum Unsigned Byte Modulo"                                   , (PPCOpcodeField::kVA,PPCOpcodeField::kVB,PPCOpcodeField::kVC), (PPCOpcodeField::kVD), PrintDisasm_vmsumubm),
  INSTRUCTION(0x10000026, "vmsumuhm"    , kVA     , kV, kGeneral, "Vector Multiply-Sum Unsigned Half Word Modulo"                              , (PPCOpcodeField::kVA,PPCOpcodeField::kVB,PPCOpcodeField::kVC), (PPCOpcodeField::kVD), PrintDisasm_vmsumuhm),
  INSTRUCTION(0x10000027, "vmsumuhs"    , kVA     , kV, kGeneral, "Vector Multiply-Sum Unsigned Half Word Saturate"                            , (PPCOpcodeField::kVA,PPCOpcodeField::kVB,PPCOpcodeField::kVC), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vmsumuhs),
  INSTRUCTION(0x10000308, "vmulesb"     , kVX     , kV, kGeneral, "Vector Multiply Even Signed Byte"                                           , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmulesb),
  INSTRUCTION(0x10000348, "vmulesh"     , kVX     , kV, kGeneral, "Vector Multiply Even Signed Half Word"                                      , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmulesh),
  INSTRUCTION(0x10000208, "vmuleub"     , kVX     , kV, kGeneral, "Vector Multiply Even Unsigned Byte"                                         , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmuleub),
  INSTRUCTION(0x10000248, "vmuleuh"     , kVX     , kV, kGeneral, "Vector Multiply Even Unsigned Half Word"                                    , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmuleuh),
  INSTRUCTION(0x14000090, "vmulfp128"   , kVX128  , kV, kGeneral, "Vector128 Multiply Floating-Point"                                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmulfp128),
  INSTRUCTION(0x10000108, "vmulosb"     , kVX     , kV, kGeneral, "Vector Multiply Odd Signed Byte"                                            , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmulosb),
  INSTRUCTION(0x10000148, "vmulosh"     , kVX     , kV, kGeneral, "Vector Multiply Odd Signed Half Word"                                       , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmulosh),
  INSTRUCTION(0x10000008, "vmuloub"     , kVX     , kV, kGeneral, "Vector Multiply Odd Unsigned Byte"                                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmuloub),
  INSTRUCTION(0x10000048, "vmulouh"     , kVX     , kV, kGeneral, "Vector Multiply Odd Unsigned Half Word"                                     , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vmulouh),
  INSTRUCTION(0x1000002f, "vnmsubfp"    , kVA     , kV, kGeneral, "Vector Negative Multiply-Subtract Floating Point"                           , (PPCOpcodeField::kVA,PPCOpcodeField::kVC,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vnmsubfp),
  INSTRUCTION(0x14000150, "vnmsubfp128" , kVX128  , kV, kGeneral, "Vector128 Negative Multiply-Subtract Floating Point"                        , (PPCOpcodeField::kVA,PPCOpcodeField::kVD,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vnmsubfp128),
  INSTRUCTION(0x10000504, "vnor"        , kVX     , kV, kGeneral, "Vector Logical NOR"                                                         , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vnor),
  INSTRUCTION(0x14000290, "vnor128"     , kVX128  , kV, kGeneral, "Vector128 Logical NOR"                                                      , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vnor128),
  INSTRUCTION(0x10000484, "vor"         , kVX     , kV, kGeneral, "Vector Logical OR"                                                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vor),
  INSTRUCTION(0x140002d0, "vor128"      , kVX128  , kV, kGeneral, "Vector128 Logical OR"                                                       , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vor128),
  INSTRUCTION(0x1000002b, "vperm"       , kVA     , kV, kGeneral, "Vector Permute"                                                             , (PPCOpcodeField::kVA,PPCOpcodeField::kVB,PPCOpcodeField::kVC), (PPCOpcodeField::kVD), PrintDisasm_vperm),
  INSTRUCTION(0x14000000, "vperm128"    , kVX128_2, kV, kGeneral, "Vector128 Permute"                                                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB,PPCOpcodeField::kVC), (PPCOpcodeField::kVD), PrintDisasm_vperm128),
  INSTRUCTION(0x18000210, "vpermwi128"  , kVX128_P, kV, kGeneral, "Vector128 Permutate Word Immediate"                                         , (PPCOpcodeField::kVB,PPCOpcodeField::kUIMM), (PPCOpcodeField::kVD), PrintDisasm_vpermwi128),
  INSTRUCTION(0x18000610, "vpkd3d128"   , kVX128_4, kV, kGeneral, "Vector128 Pack D3Dtype, Rotate Left Immediate and Mask Insert"              , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), nullptr),
  INSTRUCTION(0x1000030e, "vpkpx"       , kVX     , kV, kGeneral, "Vector Pack Pixel"                                                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vpkpx),
  INSTRUCTION(0x1000018e, "vpkshss"     , kVX     , kV, kGeneral, "Vector Pack Signed Half Word Signed Saturate"                               , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vpkshss),
  INSTRUCTION(0x14000200, "vpkshss128"  , kVX128  , kV, kGeneral, "Vector128 Pack Signed Half Word Signed Saturate"                            , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vpkshss128),
  INSTRUCTION(0x1000010e, "vpkshus"     , kVX     , kV, kGeneral, "Vector Pack Signed Half Word Unsigned Saturate"                             , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vpkshus),
  INSTRUCTION(0x14000240, "vpkshus128"  , kVX128  , kV, kGeneral, "Vector128 Pack Signed Half Word Unsigned Saturate"                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vpkshus128),
  INSTRUCTION(0x100001ce, "vpkswss"     , kVX     , kV, kGeneral, "Vector Pack Signed Word Signed Saturate"                                    , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vpkswss),
  INSTRUCTION(0x14000280, "vpkswss128"  , kVX128  , kV, kGeneral, "Vector128 Pack Signed Word Signed Saturate"                                 , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vpkswss128),
  INSTRUCTION(0x1000014e, "vpkswus"     , kVX     , kV, kGeneral, "Vector Pack Signed Word Unsigned Saturate"                                  , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vpkswus),
  INSTRUCTION(0x140002c0, "vpkswus128"  , kVX128  , kV, kGeneral, "Vector128 Pack Signed Word Unsigned Saturate"                               , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vpkswus128),
  INSTRUCTION(0x1000000e, "vpkuhum"     , kVX     , kV, kGeneral, "Vector Pack Unsigned Half Word Unsigned Modulo"                             , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vpkuhum),
  INSTRUCTION(0x14000300, "vpkuhum128"  , kVX128  , kV, kGeneral, "Vector128 Pack Unsigned Half Word Unsigned Modulo"                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vpkuhum128),
  INSTRUCTION(0x1000008e, "vpkuhus"     , kVX     , kV, kGeneral, "Vector Pack Unsigned Half Word Unsigned Saturate"                           , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vpkuhus),
  INSTRUCTION(0x14000340, "vpkuhus128"  , kVX128  , kV, kGeneral, "Vector128 Pack Unsigned Half Word Unsigned Saturate"                        , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vpkuhus128),
  INSTRUCTION(0x1000004e, "vpkuwum"     , kVX     , kV, kGeneral, "Vector Pack Unsigned Word Unsigned Modulo"                                  , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vpkuwum),
  INSTRUCTION(0x14000380, "vpkuwum128"  , kVX128  , kV, kGeneral, "Vector128 Pack Unsigned Word Unsigned Modulo"                               , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vpkuwum128),
  INSTRUCTION(0x100000ce, "vpkuwus"     , kVX     , kV, kGeneral, "Vector Pack Unsigned Word Unsigned Saturate"                                , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vpkuwus),
  INSTRUCTION(0x140003c0, "vpkuwus128"  , kVX128  , kV, kGeneral, "Vector128 Pack Unsigned Word Unsigned Saturate"                             , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vpkuwus128),
  INSTRUCTION(0x1000010a, "vrefp"       , kVX     , kV, kGeneral, "Vector Reciprocal Estimate Floating Point"                                  , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrefp),
  INSTRUCTION(0x18000630, "vrefp128"    , kVX128_3, kV, kGeneral, "Vector128 Reciprocal Estimate Floating Point"                               , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrefp128),
  INSTRUCTION(0x100002ca, "vrfim"       , kVX     , kV, kGeneral, "Vector Round to Floating-Point Integer toward -Infinity"                    , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrfim),
  INSTRUCTION(0x18000330, "vrfim128"    , kVX128_3, kV, kGeneral, "Vector128 Round to Floating-Point Integer toward -Infinity"                 , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrfim128),
  INSTRUCTION(0x1000020a, "vrfin"       , kVX     , kV, kGeneral, "Vector Round to Floating-Point Integer Nearest"                             , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrfin),
  INSTRUCTION(0x18000370, "vrfin128"    , kVX128_3, kV, kGeneral, "Vector128 Round to Floating-Point Integer Nearest"                          , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrfin128),
  INSTRUCTION(0x1000028a, "vrfip"       , kVX     , kV, kGeneral, "Vector Round to Floating-Point Integer toward +Infinity"                    , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrfip),
  INSTRUCTION(0x180003b0, "vrfip128"    , kVX128_3, kV, kGeneral, "Vector128 Round to Floating-Point Integer toward +Infinity"                 , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrfip128),
  INSTRUCTION(0x1000024a, "vrfiz"       , kVX     , kV, kGeneral, "Vector Round to Floating-Point Integer toward Zero"                         , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrfiz),
  INSTRUCTION(0x180003f0, "vrfiz128"    , kVX128_3, kV, kGeneral, "Vector128 Round to Floating-Point Integer toward Zero"                      , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrfiz128),
  INSTRUCTION(0x10000004, "vrlb"        , kVX     , kV, kGeneral, "Vector Rotate Left Integer Byte"                                            , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrlb),
  INSTRUCTION(0x10000044, "vrlh"        , kVX     , kV, kGeneral, "Vector Rotate Left Integer Half Word"                                       , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrlh),
  INSTRUCTION(0x18000710, "vrlimi128"   , kVX128_4, kV, kGeneral, "Vector128 Rotate Left Immediate and Mask Insert"                            , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrlimi128),
  INSTRUCTION(0x10000084, "vrlw"        , kVX     , kV, kGeneral, "Vector Rotate Left Integer Word"                                            , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrlw),
  INSTRUCTION(0x18000050, "vrlw128"     , kVX128  , kV, kGeneral, "Vector128 Rotate Left Word"                                                 , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrlw128),
  INSTRUCTION(0x1000014a, "vrsqrtefp"   , kVX     , kV, kGeneral, "Vector Reciprocal Square Root Estimate Floating Point"                      , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrsqrtefp),
  INSTRUCTION(0x18000670, "vrsqrtefp128", kVX128_3, kV, kGeneral, "Vector128 Reciprocal Square Root Estimate Floating Point"                   , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vrsqrtefp128),
  INSTRUCTION(0x1000002a, "vsel"        , kVA     , kV, kGeneral, "Vector Conditional Select"                                                  , (PPCOpcodeField::kVA,PPCOpcodeField::kVB,PPCOpcodeField::kVC), (PPCOpcodeField::kVD), PrintDisasm_vsel),
  INSTRUCTION(0x14000350, "vsel128"     , kVX128  , kV, kGeneral, "Vector128 Conditional Select"                                               , (PPCOpcodeField::kVA,PPCOpcodeField::kVB,PPCOpcodeField::kVD), (PPCOpcodeField::kVD), PrintDisasm_vsel128),
  INSTRUCTION(0x100001c4, "vsl"         , kVX     , kV, kGeneral, "Vector Shift Left"                                                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsl),
  INSTRUCTION(0x10000104, "vslb"        , kVX     , kV, kGeneral, "Vector Shift Left Integer Byte"                                             , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vslb),
  INSTRUCTION(0x1000002c, "vsldoi"      , kVA     , kV, kGeneral, "Vector Shift Left Double by Octet Immediate"                                , (PPCOpcodeField::kVA,PPCOpcodeField::kVB,PPCOpcodeField::kSHB), (PPCOpcodeField::kVD), PrintDisasm_vsldoi),
  INSTRUCTION(0x10000010, "vsldoi128"   , kVX128_5, kV, kGeneral, "Vector128 Shift Left Double by Octet Immediate"                             , (PPCOpcodeField::kVA,PPCOpcodeField::kVB,PPCOpcodeField::kSHB), (PPCOpcodeField::kVD), PrintDisasm_vsldoi128),
  INSTRUCTION(0x10000144, "vslh"        , kVX     , kV, kGeneral, "Vector Shift Left Integer Half Word"                                        , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vslh),
  INSTRUCTION(0x1000040c, "vslo"        , kVX     , kV, kGeneral, "Vector Shift Left by Octet"                                                 , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vslo),
  INSTRUCTION(0x14000390, "vslo128"     , kVX128  , kV, kGeneral, "Vector128 Shift Left Octet"                                                 , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vslo128),
  INSTRUCTION(0x10000184, "vslw"        , kVX     , kV, kGeneral, "Vector Shift Left Integer Word"                                             , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vslw),
  INSTRUCTION(0x180000d0, "vslw128"     , kVX128  , kV, kGeneral, "Vector128 Shift Left Integer Word"                                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vslw128),
  INSTRUCTION(0x1000020c, "vspltb"      , kVX     , kV, kGeneral, "Vector Splat Byte"                                                          , (PPCOpcodeField::kVB,PPCOpcodeField::kUIMM), (PPCOpcodeField::kVD), PrintDisasm_vspltb),
  INSTRUCTION(0x1000024c, "vsplth"      , kVX     , kV, kGeneral, "Vector Splat Half Word"                                                     , (PPCOpcodeField::kVB,PPCOpcodeField::kUIMM), (PPCOpcodeField::kVD), PrintDisasm_vsplth),
  INSTRUCTION(0x1000030c, "vspltisb"    , kVX     , kV, kGeneral, "Vector Splat Immediate Signed Byte"                                         , (PPCOpcodeField::kSIMM), (PPCOpcodeField::kVD), PrintDisasm_vspltisb),
  INSTRUCTION(0x1000034c, "vspltish"    , kVX     , kV, kGeneral, "Vector Splat Immediate Signed Half Word"                                    , (PPCOpcodeField::kSIMM), (PPCOpcodeField::kVD), PrintDisasm_vspltish),
  INSTRUCTION(0x1000038c, "vspltisw"    , kVX     , kV, kGeneral, "Vector Splat Immediate Signed Word"                                         , (PPCOpcodeField::kSIMM), (PPCOpcodeField::kVD), PrintDisasm_vspltisw),
  INSTRUCTION(0x18000770, "vspltisw128" , kVX128_3, kV, kGeneral, "Vector128 Splat Immediate Signed Word"                                      , (PPCOpcodeField::kSIMM), (PPCOpcodeField::kVD), PrintDisasm_vspltisw128),
  INSTRUCTION(0x1000028c, "vspltw"      , kVX     , kV, kGeneral, "Vector Splat Word"                                                          , (PPCOpcodeField::kVB,PPCOpcodeField::kUIMM), (PPCOpcodeField::kVD), PrintDisasm_vspltw),
  INSTRUCTION(0x18000730, "vspltw128"   , kVX128_3, kV, kGeneral, "Vector128 Splat Word"                                                       , (PPCOpcodeField::kVB,PPCOpcodeField::kUIMM), (PPCOpcodeField::kVD), PrintDisasm_vspltw128),
  INSTRUCTION(0x100002c4, "vsr"         , kVX     , kV, kGeneral, "Vector Shift Right"                                                         , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsr),
  INSTRUCTION(0x10000304, "vsrab"       , kVX     , kV, kGeneral, "Vector Shift Right Algebraic Byte"                                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsrab),
  INSTRUCTION(0x10000344, "vsrah"       , kVX     , kV, kGeneral, "Vector Shift Right Algebraic Half Word"                                     , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsrah),
  INSTRUCTION(0x10000384, "vsraw"       , kVX     , kV, kGeneral, "Vector Shift Right Algebraic Word"                                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsraw),
  INSTRUCTION(0x18000150, "vsraw128"    , kVX128  , kV, kGeneral, "Vector128 Shift Right Arithmetic Word"                                      , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsraw128),
  INSTRUCTION(0x10000204, "vsrb"        , kVX     , kV, kGeneral, "Vector Shift Right Byte"                                                    , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsrb),
  INSTRUCTION(0x10000244, "vsrh"        , kVX     , kV, kGeneral, "Vector Shift Right Half Word"                                               , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsrh),
  INSTRUCTION(0x1000044c, "vsro"        , kVX     , kV, kGeneral, "Vector Shift Right Octet"                                                   , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsro),
  INSTRUCTION(0x140003d0, "vsro128"     , kVX128  , kV, kGeneral, "Vector128 Shift Right Octet"                                                , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsro128),
  INSTRUCTION(0x10000284, "vsrw"        , kVX     , kV, kGeneral, "Vector Shift Right Word"                                                    , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsrw),
  INSTRUCTION(0x180001d0, "vsrw128"     , kVX128  , kV, kGeneral, "Vector128 Shift Right Word"                                                 , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsrw128),
  INSTRUCTION(0x10000580, "vsubcuw"     , kVX     , kV, kGeneral, "Vector Subtract Carryout Unsigned Word"                                     , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsubcuw),
  INSTRUCTION(0x1000004a, "vsubfp"      , kVX     , kV, kGeneral, "Vector Subtract Floating Point"                                             , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsubfp),
  INSTRUCTION(0x14000050, "vsubfp128"   , kVX128  , kV, kGeneral, "Vector128 Subtract Floating Point"                                          , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsubfp128),
  INSTRUCTION(0x10000700, "vsubsbs"     , kVX     , kV, kGeneral, "Vector Subtract Signed Byte Saturate"                                       , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vsubsbs),
  INSTRUCTION(0x10000740, "vsubshs"     , kVX     , kV, kGeneral, "Vector Subtract Signed Half Word Saturate"                                  , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vsubshs),
  INSTRUCTION(0x10000780, "vsubsws"     , kVX     , kV, kGeneral, "Vector Subtract Signed Word Saturate"                                       , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vsubsws),
  INSTRUCTION(0x10000400, "vsububm"     , kVX     , kV, kGeneral, "Vector Subtract Unsigned Byte Modulo"                                       , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsububm),
  INSTRUCTION(0x10000600, "vsububs"     , kVX     , kV, kGeneral, "Vector Subtract Unsigned Byte Saturate"                                     , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vsububs),
  INSTRUCTION(0x10000440, "vsubuhm"     , kVX     , kV, kGeneral, "Vector Subtract Unsigned Half Word Modulo"                                  , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsubuhm),
  INSTRUCTION(0x10000640, "vsubuhs"     , kVX     , kV, kGeneral, "Vector Subtract Unsigned Half Word Saturate"                                , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vsubuhs),
  INSTRUCTION(0x10000480, "vsubuwm"     , kVX     , kV, kGeneral, "Vector Subtract Unsigned Word Modulo"                                       , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vsubuwm),
  INSTRUCTION(0x10000680, "vsubuws"     , kVX     , kV, kGeneral, "Vector Subtract Unsigned Word Saturate"                                     , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vsubuws),
  INSTRUCTION(0x10000688, "vsum2sws"    , kVX     , kV, kGeneral, "Vector Sum Across Partial (1/2) Signed Word Saturate"                       , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vsum2sws),
  INSTRUCTION(0x10000708, "vsum4sbs"    , kVX     , kV, kGeneral, "Vector Sum Across Partial (1/4) Signed Byte Saturate"                       , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vsum4sbs),
  INSTRUCTION(0x10000648, "vsum4shs"    , kVX     , kV, kGeneral, "Vector Sum Across Partial (1/4) Signed Half Word Saturate"                  , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vsum4shs),
  INSTRUCTION(0x10000608, "vsum4ubs"    , kVX     , kV, kGeneral, "Vector Sum Across Partial (1/4) Unsigned Byte Saturate"                     , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vsum4ubs),
  INSTRUCTION(0x10000788, "vsumsws"     , kVX     , kV, kGeneral, "Vector Sum Across Signed Word Saturate"                                     , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD,PPCOpcodeField::kVSCR), PrintDisasm_vsumsws),
  INSTRUCTION(0x180007f0, "vupkd3d128"  , kVX128_3, kV, kGeneral, "Vector128 Unpack D3Dtype"                                                   , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), nullptr),
  INSTRUCTION(0x1000034e, "vupkhpx"     , kVX     , kV, kGeneral, "Vector Unpack High Pixel"                                                   , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vupkhpx),
  INSTRUCTION(0x1000020e, "vupkhsb"     , kVX     , kV, kGeneral, "Vector Unpack High Signed Byte"                                             , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vupkhsb),
  INSTRUCTION(0x18000380, "vupkhsb128"  , kVX128  , kV, kGeneral, "Vector128 Unpack High Signed Byte"                                          , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vupkhsb128),
  INSTRUCTION(0x1000024e, "vupkhsh"     , kVX     , kV, kGeneral, "Vector Unpack High Signed Half Word"                                        , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vupkhsh),
  INSTRUCTION(0x100003ce, "vupklpx"     , kVX     , kV, kGeneral, "Vector Unpack Low Pixel"                                                    , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vupklpx),
  INSTRUCTION(0x1000028e, "vupklsb"     , kVX     , kV, kGeneral, "Vector Unpack Low Signed Byte"                                              , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vupklsb),
  INSTRUCTION(0x180003c0, "vupklsb128"  , kVX128  , kV, kGeneral, "Vector128 Unpack Low Signed Byte"                                           , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vupklsb128),
  INSTRUCTION(0x100002ce, "vupklsh"     , kVX     , kV, kGeneral, "Vector Unpack Low Signed Half Word"                                         , (PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vupklsh),
  INSTRUCTION(0x100004c4, "vxor"        , kVX     , kV, kGeneral, "Vector Logical XOR"                                                         , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vxor),
  INSTRUCTION(0x14000310, "vxor128"     , kVX128  , kV, kGeneral, "Vector128 Logical XOR"                                                      , (PPCOpcodeField::kVA,PPCOpcodeField::kVB), (PPCOpcodeField::kVD), PrintDisasm_vxor128),
  INSTRUCTION(0x68000000, "xori"        , kD      , kI, kGeneral, "XOR Immediate"                                                              , (PPCOpcodeField::kRS,PPCOpcodeField::kUIMM), (PPCOpcodeField::kRA), PrintDisasm_xori),
  INSTRUCTION(0x6c000000, "xoris"       , kD      , kI, kGeneral, "XOR Immediate Shifted"                                                      , (PPCOpcodeField::kRS,PPCOpcodeField::kUIMM), (PPCOpcodeField::kRA), PrintDisasm_xoris),
  INSTRUCTION(0x7c000278, "xorx"        , kX      , kI, kGeneral, "XOR"                                                                        , (PPCOpcodeField::kRS,PPCOpcodeField::kRB), (PPCOpcodeField::kRA,PPCOpcodeField::kCRcond), PrintDisasm_xorx),
};
static_assert(sizeof(ppc_opcode_disasm_table) / sizeof(PPCOpcodeDisasmInfo) == static_cast<int>(PPCOpcode::kInvalid), "PPC table mismatch - rerun ppc-table-gen");

const PPCOpcodeDisasmInfo& GetOpcodeDisasmInfo(PPCOpcode opcode) {
  return ppc_opcode_disasm_table[static_cast<int>(opcode)];
}
void RegisterOpcodeDisasm(PPCOpcode opcode, InstrDisasmFn fn) {
  assert_null(ppc_opcode_disasm_table[static_cast<int>(opcode)].disasm);
  ppc_opcode_disasm_table[static_cast<int>(opcode)].disasm = fn;
}

}  // namespace ppc
}  // namespace cpu
}  // namespace xe
