// This code was autogenerated by ./tools/ppc-table-gen. Do not modify!
// clang-format off
#include <cstdint>
#include <cstdlib>

#include "xenia/base/assert.h"
#include "xenia/cpu/ppc/ppc_opcode.h"
#include "xenia/cpu/ppc/ppc_opcode_info.h"

namespace xe {
namespace cpu {
namespace ppc {

constexpr uint32_t ExtractBits(uint32_t v, uint32_t a, uint32_t b) {
  return (v >> (32 - 1 - b)) & ((1 << (b - a + 1)) - 1);
}

#define PPC_DECODER_MISS assert_always(); return PPCOpcode::kInvalid
#define PPC_DECODER_HIT(name) return PPCOpcode::name;

PPCOpcode LookupOpcode(uint32_t code) {
  switch (ExtractBits(code, 0, 5)) {
  case 2: PPC_DECODER_HIT(tdi);
  case 3: PPC_DECODER_HIT(twi);
  case 4:
    switch ((ExtractBits(code, 21, 27) << 4)|(ExtractBits(code, 30, 31) << 0)) {
      case 0b00000000011: PPC_DECODER_HIT(lvsl128);
      case 0b00001000011: PPC_DECODER_HIT(lvsr128);
      case 0b00010000011: PPC_DECODER_HIT(lvewx128);
      case 0b00011000011: PPC_DECODER_HIT(lvx128);
      case 0b00110000011: PPC_DECODER_HIT(stvewx128);
      case 0b00111000011: PPC_DECODER_HIT(stvx128);
      case 0b01011000011: PPC_DECODER_HIT(lvxl128);
      case 0b01111000011: PPC_DECODER_HIT(stvxl128);
      case 0b10000000011: PPC_DECODER_HIT(lvlx128);
      case 0b10001000011: PPC_DECODER_HIT(lvrx128);
      case 0b10100000011: PPC_DECODER_HIT(stvlx128);
      case 0b10101000011: PPC_DECODER_HIT(stvrx128);
      case 0b11000000011: PPC_DECODER_HIT(lvlxl128);
      case 0b11001000011: PPC_DECODER_HIT(lvrxl128);
      case 0b11100000011: PPC_DECODER_HIT(stvlxl128);
      case 0b11101000011: PPC_DECODER_HIT(stvrxl128);
    }
    switch ((ExtractBits(code, 21, 31) << 0)) {
      case 0b00000000000: PPC_DECODER_HIT(vaddubm);
      case 0b00000000010: PPC_DECODER_HIT(vmaxub);
      case 0b00000000100: PPC_DECODER_HIT(vrlb);
      case 0b00000001000: PPC_DECODER_HIT(vmuloub);
      case 0b00000001010: PPC_DECODER_HIT(vaddfp);
      case 0b00000001100: PPC_DECODER_HIT(vmrghb);
      case 0b00000001110: PPC_DECODER_HIT(vpkuhum);
      case 0b00001000000: PPC_DECODER_HIT(vadduhm);
      case 0b00001000010: PPC_DECODER_HIT(vmaxuh);
      case 0b00001000100: PPC_DECODER_HIT(vrlh);
      case 0b00001001000: PPC_DECODER_HIT(vmulouh);
      case 0b00001001010: PPC_DECODER_HIT(vsubfp);
      case 0b00001001100: PPC_DECODER_HIT(vmrghh);
      case 0b00001001110: PPC_DECODER_HIT(vpkuwum);
      case 0b00010000000: PPC_DECODER_HIT(vadduwm);
      case 0b00010000010: PPC_DECODER_HIT(vmaxuw);
      case 0b00010000100: PPC_DECODER_HIT(vrlw);
      case 0b00010001100: PPC_DECODER_HIT(vmrghw);
      case 0b00010001110: PPC_DECODER_HIT(vpkuhus);
      case 0b00011001110: PPC_DECODER_HIT(vpkuwus);
      case 0b00100000010: PPC_DECODER_HIT(vmaxsb);
      case 0b00100000100: PPC_DECODER_HIT(vslb);
      case 0b00100001000: PPC_DECODER_HIT(vmulosb);
      case 0b00100001010: PPC_DECODER_HIT(vrefp);
      case 0b00100001100: PPC_DECODER_HIT(vmrglb);
      case 0b00100001110: PPC_DECODER_HIT(vpkshus);
      case 0b00101000010: PPC_DECODER_HIT(vmaxsh);
      case 0b00101000100: PPC_DECODER_HIT(vslh);
      case 0b00101001000: PPC_DECODER_HIT(vmulosh);
      case 0b00101001010: PPC_DECODER_HIT(vrsqrtefp);
      case 0b00101001100: PPC_DECODER_HIT(vmrglh);
      case 0b00101001110: PPC_DECODER_HIT(vpkswus);
      case 0b00110000000: PPC_DECODER_HIT(vaddcuw);
      case 0b00110000010: PPC_DECODER_HIT(vmaxsw);
      case 0b00110000100: PPC_DECODER_HIT(vslw);
      case 0b00110001010: PPC_DECODER_HIT(vexptefp);
      case 0b00110001100: PPC_DECODER_HIT(vmrglw);
      case 0b00110001110: PPC_DECODER_HIT(vpkshss);
      case 0b00111000100: PPC_DECODER_HIT(vsl);
      case 0b00111001010: PPC_DECODER_HIT(vlogefp);
      case 0b00111001110: PPC_DECODER_HIT(vpkswss);
      case 0b01000000000: PPC_DECODER_HIT(vaddubs);
      case 0b01000000010: PPC_DECODER_HIT(vminub);
      case 0b01000000100: PPC_DECODER_HIT(vsrb);
      case 0b01000001000: PPC_DECODER_HIT(vmuleub);
      case 0b01000001010: PPC_DECODER_HIT(vrfin);
      case 0b01000001100: PPC_DECODER_HIT(vspltb);
      case 0b01000001110: PPC_DECODER_HIT(vupkhsb);
      case 0b01001000000: PPC_DECODER_HIT(vadduhs);
      case 0b01001000010: PPC_DECODER_HIT(vminuh);
      case 0b01001000100: PPC_DECODER_HIT(vsrh);
      case 0b01001001000: PPC_DECODER_HIT(vmuleuh);
      case 0b01001001010: PPC_DECODER_HIT(vrfiz);
      case 0b01001001100: PPC_DECODER_HIT(vsplth);
      case 0b01001001110: PPC_DECODER_HIT(vupkhsh);
      case 0b01010000000: PPC_DECODER_HIT(vadduws);
      case 0b01010000010: PPC_DECODER_HIT(vminuw);
      case 0b01010000100: PPC_DECODER_HIT(vsrw);
      case 0b01010001010: PPC_DECODER_HIT(vrfip);
      case 0b01010001100: PPC_DECODER_HIT(vspltw);
      case 0b01010001110: PPC_DECODER_HIT(vupklsb);
      case 0b01011000100: PPC_DECODER_HIT(vsr);
      case 0b01011001010: PPC_DECODER_HIT(vrfim);
      case 0b01011001110: PPC_DECODER_HIT(vupklsh);
      case 0b01100000000: PPC_DECODER_HIT(vaddsbs);
      case 0b01100000010: PPC_DECODER_HIT(vminsb);
      case 0b01100000100: PPC_DECODER_HIT(vsrab);
      case 0b01100001000: PPC_DECODER_HIT(vmulesb);
      case 0b01100001010: PPC_DECODER_HIT(vcfux);
      case 0b01100001100: PPC_DECODER_HIT(vspltisb);
      case 0b01100001110: PPC_DECODER_HIT(vpkpx);
      case 0b01101000000: PPC_DECODER_HIT(vaddshs);
      case 0b01101000010: PPC_DECODER_HIT(vminsh);
      case 0b01101000100: PPC_DECODER_HIT(vsrah);
      case 0b01101001000: PPC_DECODER_HIT(vmulesh);
      case 0b01101001010: PPC_DECODER_HIT(vcfsx);
      case 0b01101001100: PPC_DECODER_HIT(vspltish);
      case 0b01101001110: PPC_DECODER_HIT(vupkhpx);
      case 0b01110000000: PPC_DECODER_HIT(vaddsws);
      case 0b01110000010: PPC_DECODER_HIT(vminsw);
      case 0b01110000100: PPC_DECODER_HIT(vsraw);
      case 0b01110001010: PPC_DECODER_HIT(vctuxs);
      case 0b01110001100: PPC_DECODER_HIT(vspltisw);
      case 0b01111001010: PPC_DECODER_HIT(vctsxs);
      case 0b01111001110: PPC_DECODER_HIT(vupklpx);
      case 0b10000000000: PPC_DECODER_HIT(vsububm);
      case 0b10000000010: PPC_DECODER_HIT(vavgub);
      case 0b10000000100: PPC_DECODER_HIT(vand);
      case 0b10000001010: PPC_DECODER_HIT(vmaxfp);
      case 0b10000001100: PPC_DECODER_HIT(vslo);
      case 0b10001000000: PPC_DECODER_HIT(vsubuhm);
      case 0b10001000010: PPC_DECODER_HIT(vavguh);
      case 0b10001000100: PPC_DECODER_HIT(vandc);
      case 0b10001001010: PPC_DECODER_HIT(vminfp);
      case 0b10001001100: PPC_DECODER_HIT(vsro);
      case 0b10010000000: PPC_DECODER_HIT(vsubuwm);
      case 0b10010000010: PPC_DECODER_HIT(vavguw);
      case 0b10010000100: PPC_DECODER_HIT(vor);
      case 0b10011000100: PPC_DECODER_HIT(vxor);
      case 0b10100000010: PPC_DECODER_HIT(vavgsb);
      case 0b10100000100: PPC_DECODER_HIT(vnor);
      case 0b10101000010: PPC_DECODER_HIT(vavgsh);
      case 0b10110000000: PPC_DECODER_HIT(vsubcuw);
      case 0b10110000010: PPC_DECODER_HIT(vavgsw);
      case 0b11000000000: PPC_DECODER_HIT(vsububs);
      case 0b11000000100: PPC_DECODER_HIT(mfvscr);
      case 0b11000001000: PPC_DECODER_HIT(vsum4ubs);
      case 0b11001000000: PPC_DECODER_HIT(vsubuhs);
      case 0b11001000100: PPC_DECODER_HIT(mtvscr);
      case 0b11001001000: PPC_DECODER_HIT(vsum4shs);
      case 0b11010000000: PPC_DECODER_HIT(vsubuws);
      case 0b11010001000: PPC_DECODER_HIT(vsum2sws);
      case 0b11100000000: PPC_DECODER_HIT(vsubsbs);
      case 0b11100001000: PPC_DECODER_HIT(vsum4sbs);
      case 0b11101000000: PPC_DECODER_HIT(vsubshs);
      case 0b11110000000: PPC_DECODER_HIT(vsubsws);
      case 0b11110001000: PPC_DECODER_HIT(vsumsws);
    }
    switch ((ExtractBits(code, 22, 31) << 0)) {
      case 0b0000000110: PPC_DECODER_HIT(vcmpequb);
      case 0b0001000110: PPC_DECODER_HIT(vcmpequh);
      case 0b0010000110: PPC_DECODER_HIT(vcmpequw);
      case 0b0011000110: PPC_DECODER_HIT(vcmpeqfp);
      case 0b0111000110: PPC_DECODER_HIT(vcmpgefp);
      case 0b1000000110: PPC_DECODER_HIT(vcmpgtub);
      case 0b1001000110: PPC_DECODER_HIT(vcmpgtuh);
      case 0b1010000110: PPC_DECODER_HIT(vcmpgtuw);
      case 0b1011000110: PPC_DECODER_HIT(vcmpgtfp);
      case 0b1100000110: PPC_DECODER_HIT(vcmpgtsb);
      case 0b1101000110: PPC_DECODER_HIT(vcmpgtsh);
      case 0b1110000110: PPC_DECODER_HIT(vcmpgtsw);
      case 0b1111000110: PPC_DECODER_HIT(vcmpbfp);
    }
    switch ((ExtractBits(code, 26, 31) << 0)) {
      case 0b100000: PPC_DECODER_HIT(vmhaddshs);
      case 0b100001: PPC_DECODER_HIT(vmhraddshs);
      case 0b100010: PPC_DECODER_HIT(vmladduhm);
      case 0b100100: PPC_DECODER_HIT(vmsumubm);
      case 0b100101: PPC_DECODER_HIT(vmsummbm);
      case 0b100110: PPC_DECODER_HIT(vmsumuhm);
      case 0b100111: PPC_DECODER_HIT(vmsumuhs);
      case 0b101000: PPC_DECODER_HIT(vmsumshm);
      case 0b101001: PPC_DECODER_HIT(vmsumshs);
      case 0b101010: PPC_DECODER_HIT(vsel);
      case 0b101011: PPC_DECODER_HIT(vperm);
      case 0b101100: PPC_DECODER_HIT(vsldoi);
      case 0b101110: PPC_DECODER_HIT(vmaddfp);
      case 0b101111: PPC_DECODER_HIT(vnmsubfp);
    }
    switch ((ExtractBits(code, 27, 27) << 0)) {
      case 0b1: PPC_DECODER_HIT(vsldoi128);
    }
    PPC_DECODER_MISS;
  case 5:
    switch ((ExtractBits(code, 22, 22) << 5)|(ExtractBits(code, 27, 27) << 0)) {
      case 0b000000: PPC_DECODER_HIT(vperm128);
    }
    switch ((ExtractBits(code, 22, 25) << 2)|(ExtractBits(code, 27, 27) << 0)) {
      case 0b000001: PPC_DECODER_HIT(vaddfp128);
      case 0b000101: PPC_DECODER_HIT(vsubfp128);
      case 0b001001: PPC_DECODER_HIT(vmulfp128);
      case 0b001101: PPC_DECODER_HIT(vmaddfp128);
      case 0b010001: PPC_DECODER_HIT(vmaddcfp128);
      case 0b010101: PPC_DECODER_HIT(vnmsubfp128);
      case 0b011001: PPC_DECODER_HIT(vmsum3fp128);
      case 0b011101: PPC_DECODER_HIT(vmsum4fp128);
      case 0b100000: PPC_DECODER_HIT(vpkshss128);
      case 0b100001: PPC_DECODER_HIT(vand128);
      case 0b100100: PPC_DECODER_HIT(vpkshus128);
      case 0b100101: PPC_DECODER_HIT(vandc128);
      case 0b101000: PPC_DECODER_HIT(vpkswss128);
      case 0b101001: PPC_DECODER_HIT(vnor128);
      case 0b101100: PPC_DECODER_HIT(vpkswus128);
      case 0b101101: PPC_DECODER_HIT(vor128);
      case 0b110000: PPC_DECODER_HIT(vpkuhum128);
      case 0b110001: PPC_DECODER_HIT(vxor128);
      case 0b110100: PPC_DECODER_HIT(vpkuhus128);
      case 0b110101: PPC_DECODER_HIT(vsel128);
      case 0b111000: PPC_DECODER_HIT(vpkuwum128);
      case 0b111001: PPC_DECODER_HIT(vslo128);
      case 0b111100: PPC_DECODER_HIT(vpkuwus128);
      case 0b111101: PPC_DECODER_HIT(vsro128);
    }
    PPC_DECODER_MISS;
  case 6:
    switch ((ExtractBits(code, 21, 22) << 5)|(ExtractBits(code, 26, 27) << 0)) {
      case 0b0100001: PPC_DECODER_HIT(vpermwi128);
    }
    switch ((ExtractBits(code, 21, 23) << 4)|(ExtractBits(code, 26, 27) << 0)) {
      case 0b1100001: PPC_DECODER_HIT(vpkd3d128);
      case 0b1110001: PPC_DECODER_HIT(vrlimi128);
    }
    switch ((ExtractBits(code, 21, 27) << 0)) {
      case 0b0100011: PPC_DECODER_HIT(vcfpsxws128);
      case 0b0100111: PPC_DECODER_HIT(vcfpuxws128);
      case 0b0101011: PPC_DECODER_HIT(vcsxwfp128);
      case 0b0101111: PPC_DECODER_HIT(vcuxwfp128);
      case 0b0110011: PPC_DECODER_HIT(vrfim128);
      case 0b0110111: PPC_DECODER_HIT(vrfin128);
      case 0b0111011: PPC_DECODER_HIT(vrfip128);
      case 0b0111111: PPC_DECODER_HIT(vrfiz128);
      case 0b1100011: PPC_DECODER_HIT(vrefp128);
      case 0b1100111: PPC_DECODER_HIT(vrsqrtefp128);
      case 0b1101011: PPC_DECODER_HIT(vexptefp128);
      case 0b1101111: PPC_DECODER_HIT(vlogefp128);
      case 0b1110011: PPC_DECODER_HIT(vspltw128);
      case 0b1110111: PPC_DECODER_HIT(vspltisw128);
      case 0b1111111: PPC_DECODER_HIT(vupkd3d128);
    }
    switch ((ExtractBits(code, 22, 24) << 3)|(ExtractBits(code, 27, 27) << 0)) {
      case 0b000000: PPC_DECODER_HIT(vcmpeqfp128);
      case 0b001000: PPC_DECODER_HIT(vcmpgefp128);
      case 0b010000: PPC_DECODER_HIT(vcmpgtfp128);
      case 0b011000: PPC_DECODER_HIT(vcmpbfp128);
      case 0b100000: PPC_DECODER_HIT(vcmpequw128);
    }
    switch ((ExtractBits(code, 22, 25) << 2)|(ExtractBits(code, 27, 27) << 0)) {
      case 0b000101: PPC_DECODER_HIT(vrlw128);
      case 0b001101: PPC_DECODER_HIT(vslw128);
      case 0b010101: PPC_DECODER_HIT(vsraw128);
      case 0b011101: PPC_DECODER_HIT(vsrw128);
      case 0b101000: PPC_DECODER_HIT(vmaxfp128);
      case 0b101100: PPC_DECODER_HIT(vminfp128);
      case 0b110000: PPC_DECODER_HIT(vmrghw128);
      case 0b110100: PPC_DECODER_HIT(vmrglw128);
      case 0b111000: PPC_DECODER_HIT(vupkhsb128);
      case 0b111100: PPC_DECODER_HIT(vupklsb128);
    }
    PPC_DECODER_MISS;
  case 7: PPC_DECODER_HIT(mulli);
  case 8: PPC_DECODER_HIT(subficx);
  case 10: PPC_DECODER_HIT(cmpli);
  case 11: PPC_DECODER_HIT(cmpi);
  case 12: PPC_DECODER_HIT(addic);
  case 13: PPC_DECODER_HIT(addicx);
  case 14: PPC_DECODER_HIT(addi);
  case 15: PPC_DECODER_HIT(addis);
  case 16: PPC_DECODER_HIT(bcx);
  case 17: PPC_DECODER_HIT(sc);
  case 18: PPC_DECODER_HIT(bx);
  case 19:
    switch ((ExtractBits(code, 21, 30) << 0)) {
      case 0b0000000000: PPC_DECODER_HIT(mcrf);
      case 0b0000010000: PPC_DECODER_HIT(bclrx);
      case 0b0000100001: PPC_DECODER_HIT(crnor);
      case 0b0010000001: PPC_DECODER_HIT(crandc);
      case 0b0010010110: PPC_DECODER_HIT(isync);
      case 0b0011000001: PPC_DECODER_HIT(crxor);
      case 0b0011100001: PPC_DECODER_HIT(crnand);
      case 0b0100000001: PPC_DECODER_HIT(crand);
      case 0b0100100001: PPC_DECODER_HIT(creqv);
      case 0b0110100001: PPC_DECODER_HIT(crorc);
      case 0b0111000001: PPC_DECODER_HIT(cror);
      case 0b1000010000: PPC_DECODER_HIT(bcctrx);
    }
    PPC_DECODER_MISS;
  case 20: PPC_DECODER_HIT(rlwimix);
  case 21: PPC_DECODER_HIT(rlwinmx);
  case 23: PPC_DECODER_HIT(rlwnmx);
  case 24: PPC_DECODER_HIT(ori);
  case 25: PPC_DECODER_HIT(oris);
  case 26: PPC_DECODER_HIT(xori);
  case 27: PPC_DECODER_HIT(xoris);
  case 28: PPC_DECODER_HIT(andix);
  case 29: PPC_DECODER_HIT(andisx);
  case 30:
    switch ((ExtractBits(code, 27, 29) << 0)) {
      case 0b000: PPC_DECODER_HIT(rldiclx);
      case 0b001: PPC_DECODER_HIT(rldicrx);
      case 0b010: PPC_DECODER_HIT(rldicx);
      case 0b011: PPC_DECODER_HIT(rldimix);
    }
    switch ((ExtractBits(code, 27, 30) << 0)) {
      case 0b1000: PPC_DECODER_HIT(rldclx);
      case 0b1001: PPC_DECODER_HIT(rldcrx);
    }
    PPC_DECODER_MISS;
  case 31:
    switch ((ExtractBits(code, 21, 29) << 0)) {
      case 0b110011101: PPC_DECODER_HIT(sradix);
    }
    switch ((ExtractBits(code, 21, 30) << 0)) {
      case 0b0000000000: PPC_DECODER_HIT(cmp);
      case 0b0000000100: PPC_DECODER_HIT(tw);
      case 0b0000000110: PPC_DECODER_HIT(lvsl);
      case 0b0000000111: PPC_DECODER_HIT(lvebx);
      case 0b0000010011: PPC_DECODER_HIT(mfcr);
      case 0b0000010100: PPC_DECODER_HIT(lwarx);
      case 0b0000010101: PPC_DECODER_HIT(ldx);
      case 0b0000010111: PPC_DECODER_HIT(lwzx);
      case 0b0000011000: PPC_DECODER_HIT(slwx);
      case 0b0000011010: PPC_DECODER_HIT(cntlzwx);
      case 0b0000011011: PPC_DECODER_HIT(sldx);
      case 0b0000011100: PPC_DECODER_HIT(andx);
      case 0b0000100000: PPC_DECODER_HIT(cmpl);
      case 0b0000100110: PPC_DECODER_HIT(lvsr);
      case 0b0000100111: PPC_DECODER_HIT(lvehx);
      case 0b0000110101: PPC_DECODER_HIT(ldux);
      case 0b0000110110: PPC_DECODER_HIT(dcbst);
      case 0b0000110111: PPC_DECODER_HIT(lwzux);
      case 0b0000111010: PPC_DECODER_HIT(cntlzdx);
      case 0b0000111100: PPC_DECODER_HIT(andcx);
      case 0b0001000100: PPC_DECODER_HIT(td);
      case 0b0001000111: PPC_DECODER_HIT(lvewx);
      case 0b0001010011: PPC_DECODER_HIT(mfmsr);
      case 0b0001010100: PPC_DECODER_HIT(ldarx);
      case 0b0001010110: PPC_DECODER_HIT(dcbf);
      case 0b0001010111: PPC_DECODER_HIT(lbzx);
      case 0b0001100111: PPC_DECODER_HIT(lvx);
      case 0b0001110111: PPC_DECODER_HIT(lbzux);
      case 0b0001111100: PPC_DECODER_HIT(norx);
      case 0b0010000111: PPC_DECODER_HIT(stvebx);
      case 0b0010010000: PPC_DECODER_HIT(mtcrf);
      case 0b0010010010: PPC_DECODER_HIT(mtmsr);
      case 0b0010010101: PPC_DECODER_HIT(stdx);
      case 0b0010010110: PPC_DECODER_HIT(stwcx);
      case 0b0010010111: PPC_DECODER_HIT(stwx);
      case 0b0010100111: PPC_DECODER_HIT(stvehx);
      case 0b0010110010: PPC_DECODER_HIT(mtmsrd);
      case 0b0010110101: PPC_DECODER_HIT(stdux);
      case 0b0010110111: PPC_DECODER_HIT(stwux);
      case 0b0011000111: PPC_DECODER_HIT(stvewx);
      case 0b0011010110: PPC_DECODER_HIT(stdcx);
      case 0b0011010111: PPC_DECODER_HIT(stbx);
      case 0b0011100111: PPC_DECODER_HIT(stvx);
      case 0b0011110110: PPC_DECODER_HIT(dcbtst);
      case 0b0011110111: PPC_DECODER_HIT(stbux);
      case 0b0100010110: PPC_DECODER_HIT(dcbt);
      case 0b0100010111: PPC_DECODER_HIT(lhzx);
      case 0b0100011100: PPC_DECODER_HIT(eqvx);
      case 0b0100110111: PPC_DECODER_HIT(lhzux);
      case 0b0100111100: PPC_DECODER_HIT(xorx);
      case 0b0101010011: PPC_DECODER_HIT(mfspr);
      case 0b0101010101: PPC_DECODER_HIT(lwax);
      case 0b0101010111: PPC_DECODER_HIT(lhax);
      case 0b0101100111: PPC_DECODER_HIT(lvxl);
      case 0b0101110011: PPC_DECODER_HIT(mftb);
      case 0b0101110101: PPC_DECODER_HIT(lwaux);
      case 0b0101110111: PPC_DECODER_HIT(lhaux);
      case 0b0110010111: PPC_DECODER_HIT(sthx);
      case 0b0110011100: PPC_DECODER_HIT(orcx);
      case 0b0110110111: PPC_DECODER_HIT(sthux);
      case 0b0110111100: PPC_DECODER_HIT(orx);
      case 0b0111010011: PPC_DECODER_HIT(mtspr);
      case 0b0111010110: PPC_DECODER_HIT(dcbi);
      case 0b0111011100: PPC_DECODER_HIT(nandx);
      case 0b0111100111: PPC_DECODER_HIT(stvxl);
      case 0b1000000000: PPC_DECODER_HIT(mcrxr);
      case 0b1000000111: PPC_DECODER_HIT(lvlx);
      case 0b1000010100: PPC_DECODER_HIT(ldbrx);
      case 0b1000010101: PPC_DECODER_HIT(lswx);
      case 0b1000010110: PPC_DECODER_HIT(lwbrx);
      case 0b1000010111: PPC_DECODER_HIT(lfsx);
      case 0b1000011000: PPC_DECODER_HIT(srwx);
      case 0b1000011011: PPC_DECODER_HIT(srdx);
      case 0b1000100111: PPC_DECODER_HIT(lvrx);
      case 0b1000110111: PPC_DECODER_HIT(lfsux);
      case 0b1001010101: PPC_DECODER_HIT(lswi);
      case 0b1001010110: PPC_DECODER_HIT(sync);
      case 0b1001010111: PPC_DECODER_HIT(lfdx);
      case 0b1001110111: PPC_DECODER_HIT(lfdux);
      case 0b1010000111: PPC_DECODER_HIT(stvlx);
      case 0b1010010100: PPC_DECODER_HIT(stdbrx);
      case 0b1010010101: PPC_DECODER_HIT(stswx);
      case 0b1010010110: PPC_DECODER_HIT(stwbrx);
      case 0b1010010111: PPC_DECODER_HIT(stfsx);
      case 0b1010100111: PPC_DECODER_HIT(stvrx);
      case 0b1010110111: PPC_DECODER_HIT(stfsux);
      case 0b1011010101: PPC_DECODER_HIT(stswi);
      case 0b1011010111: PPC_DECODER_HIT(stfdx);
      case 0b1011110111: PPC_DECODER_HIT(stfdux);
      case 0b1100000111: PPC_DECODER_HIT(lvlxl);
      case 0b1100010110: PPC_DECODER_HIT(lhbrx);
      case 0b1100011000: PPC_DECODER_HIT(srawx);
      case 0b1100011010: PPC_DECODER_HIT(sradx);
      case 0b1100100111: PPC_DECODER_HIT(lvrxl);
      case 0b1100111000: PPC_DECODER_HIT(srawix);
      case 0b1101010110: PPC_DECODER_HIT(eieio);
      case 0b1110000111: PPC_DECODER_HIT(stvlxl);
      case 0b1110010110: PPC_DECODER_HIT(sthbrx);
      case 0b1110011010: PPC_DECODER_HIT(extshx);
      case 0b1110100111: PPC_DECODER_HIT(stvrxl);
      case 0b1110111010: PPC_DECODER_HIT(extsbx);
      case 0b1111010110: PPC_DECODER_HIT(icbi);
      case 0b1111010111: PPC_DECODER_HIT(stfiwx);
      case 0b1111011010: PPC_DECODER_HIT(extswx);
    }
    switch ((ExtractBits(code, 22, 30) << 0)) {
      case 0b000001000: PPC_DECODER_HIT(subfcx);
      case 0b000001001: PPC_DECODER_HIT(mulhdux);
      case 0b000001010: PPC_DECODER_HIT(addcx);
      case 0b000001011: PPC_DECODER_HIT(mulhwux);
      case 0b000101000: PPC_DECODER_HIT(subfx);
      case 0b001001001: PPC_DECODER_HIT(mulhdx);
      case 0b001001011: PPC_DECODER_HIT(mulhwx);
      case 0b001101000: PPC_DECODER_HIT(negx);
      case 0b010001000: PPC_DECODER_HIT(subfex);
      case 0b010001010: PPC_DECODER_HIT(addex);
      case 0b011001000: PPC_DECODER_HIT(subfzex);
      case 0b011001010: PPC_DECODER_HIT(addzex);
      case 0b011101000: PPC_DECODER_HIT(subfmex);
      case 0b011101001: PPC_DECODER_HIT(mulldx);
      case 0b011101010: PPC_DECODER_HIT(addmex);
      case 0b011101011: PPC_DECODER_HIT(mullwx);
      case 0b100001010: PPC_DECODER_HIT(addx);
      case 0b111001001: PPC_DECODER_HIT(divdux);
      case 0b111001011: PPC_DECODER_HIT(divwux);
      case 0b111101001: PPC_DECODER_HIT(divdx);
      case 0b111101011: PPC_DECODER_HIT(divwx);
    }
    switch ((ExtractBits(code, 6, 10) << 20)|(ExtractBits(code, 21, 30) << 0)) {
      case 0b0000000000000001111110110: PPC_DECODER_HIT(dcbz);
      case 0b0000100000000001111110110: PPC_DECODER_HIT(dcbz128);
    }
    PPC_DECODER_MISS;
  case 32: PPC_DECODER_HIT(lwz);
  case 33: PPC_DECODER_HIT(lwzu);
  case 34: PPC_DECODER_HIT(lbz);
  case 35: PPC_DECODER_HIT(lbzu);
  case 36: PPC_DECODER_HIT(stw);
  case 37: PPC_DECODER_HIT(stwu);
  case 38: PPC_DECODER_HIT(stb);
  case 39: PPC_DECODER_HIT(stbu);
  case 40: PPC_DECODER_HIT(lhz);
  case 41: PPC_DECODER_HIT(lhzu);
  case 42: PPC_DECODER_HIT(lha);
  case 43: PPC_DECODER_HIT(lhau);
  case 44: PPC_DECODER_HIT(sth);
  case 45: PPC_DECODER_HIT(sthu);
  case 46: PPC_DECODER_HIT(lmw);
  case 47: PPC_DECODER_HIT(stmw);
  case 48: PPC_DECODER_HIT(lfs);
  case 49: PPC_DECODER_HIT(lfsu);
  case 50: PPC_DECODER_HIT(lfd);
  case 51: PPC_DECODER_HIT(lfdu);
  case 52: PPC_DECODER_HIT(stfs);
  case 53: PPC_DECODER_HIT(stfsu);
  case 54: PPC_DECODER_HIT(stfd);
  case 55: PPC_DECODER_HIT(stfdu);
  case 58:
    switch ((ExtractBits(code, 30, 31) << 0)) {
      case 0b00: PPC_DECODER_HIT(ld);
      case 0b01: PPC_DECODER_HIT(ldu);
      case 0b10: PPC_DECODER_HIT(lwa);
    }
    PPC_DECODER_MISS;
  case 59:
    switch ((ExtractBits(code, 26, 30) << 0)) {
      case 0b10010: PPC_DECODER_HIT(fdivsx);
      case 0b10100: PPC_DECODER_HIT(fsubsx);
      case 0b10101: PPC_DECODER_HIT(faddsx);
      case 0b10110: PPC_DECODER_HIT(fsqrtsx);
      case 0b11000: PPC_DECODER_HIT(fresx);
      case 0b11001: PPC_DECODER_HIT(fmulsx);
      case 0b11100: PPC_DECODER_HIT(fmsubsx);
      case 0b11101: PPC_DECODER_HIT(fmaddsx);
      case 0b11110: PPC_DECODER_HIT(fnmsubsx);
      case 0b11111: PPC_DECODER_HIT(fnmaddsx);
    }
    PPC_DECODER_MISS;
  case 62:
    switch ((ExtractBits(code, 30, 31) << 0)) {
      case 0b00: PPC_DECODER_HIT(std);
      case 0b01: PPC_DECODER_HIT(stdu);
    }
    PPC_DECODER_MISS;
  case 63:
    switch ((ExtractBits(code, 21, 30) << 0)) {
      case 0b0000000000: PPC_DECODER_HIT(fcmpu);
      case 0b0000001100: PPC_DECODER_HIT(frspx);
      case 0b0000001110: PPC_DECODER_HIT(fctiwx);
      case 0b0000001111: PPC_DECODER_HIT(fctiwzx);
      case 0b0000100000: PPC_DECODER_HIT(fcmpo);
      case 0b0000100110: PPC_DECODER_HIT(mtfsb1x);
      case 0b0000101000: PPC_DECODER_HIT(fnegx);
      case 0b0001000000: PPC_DECODER_HIT(mcrfs);
      case 0b0001000110: PPC_DECODER_HIT(mtfsb0x);
      case 0b0001001000: PPC_DECODER_HIT(fmrx);
      case 0b0010000110: PPC_DECODER_HIT(mtfsfix);
      case 0b0010001000: PPC_DECODER_HIT(fnabsx);
      case 0b0100001000: PPC_DECODER_HIT(fabsx);
      case 0b1001000111: PPC_DECODER_HIT(mffsx);
      case 0b1011000111: PPC_DECODER_HIT(mtfsfx);
      case 0b1100101110: PPC_DECODER_HIT(fctidx);
      case 0b1100101111: PPC_DECODER_HIT(fctidzx);
      case 0b1101001110: PPC_DECODER_HIT(fcfidx);
    }
    switch ((ExtractBits(code, 26, 30) << 0)) {
      case 0b10010: PPC_DECODER_HIT(fdivx);
      case 0b10100: PPC_DECODER_HIT(fsubx);
      case 0b10101: PPC_DECODER_HIT(faddx);
      case 0b10110: PPC_DECODER_HIT(fsqrtx);
      case 0b10111: PPC_DECODER_HIT(fselx);
      case 0b11001: PPC_DECODER_HIT(fmulx);
      case 0b11010: PPC_DECODER_HIT(frsqrtex);
      case 0b11100: PPC_DECODER_HIT(fmsubx);
      case 0b11101: PPC_DECODER_HIT(fmaddx);
      case 0b11110: PPC_DECODER_HIT(fnmsubx);
      case 0b11111: PPC_DECODER_HIT(fnmaddx);
    }
    PPC_DECODER_MISS;
  default: PPC_DECODER_MISS;
  }
}

}  // namespace ppc
}  // namespace cpu
}  // namespace xe
