/**
 ******************************************************************************
 * Xenia : Xbox 360 Emulator Research Project                                 *
 ******************************************************************************
 * Copyright 2013 Ben Vanik. All rights reserved.                             *
 * Released under the BSD license - see LICENSE in the root for more details. *
 ******************************************************************************
 */

// This is a partial file designed to be included by other files when
// constructing various tables.

// Almost all of these values are taken directly from:
// https://github.com/freedreno/amd-gpu/blob/master/include/reg/yamato/22/yamato_offset.h

//#define XE_GPU_REGISTER(index, type, name)

XE_GPU_REGISTER(0x0048, kDword, BIF_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0049, kDword, BIF_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x004A, kDword, BIF_PERFCOUNTER0_LOW)

XE_GPU_REGISTER(0x01DD, kDword, SCRATCH_ADDR)
XE_GPU_REGISTER(0x01DC, kDword, SCRATCH_UMSK)

XE_GPU_REGISTER(0x01E6, kDword, CP_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x01E7, kDword, CP_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x01E8, kDword, CP_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x01F5, kDword, CP_PERFMON_CNTL)

XE_GPU_REGISTER(0x0395, kDword, RBBM_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0396, kDword, RBBM_PERFCOUNTER1_SELECT)
XE_GPU_REGISTER(0x0397, kDword, RBBM_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0398, kDword, RBBM_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0399, kDword, RBBM_PERFCOUNTER1_LOW)
XE_GPU_REGISTER(0x039A, kDword, RBBM_PERFCOUNTER1_HI)

XE_GPU_REGISTER(0x045E, kDword, CALLBACK_ACK)

XE_GPU_REGISTER(0x0578, kDword, SCRATCH_REG0)  // interrupt sync
XE_GPU_REGISTER(0x0579, kDword, SCRATCH_REG1)  // present interval
XE_GPU_REGISTER(0x057A, kDword, SCRATCH_REG2)
XE_GPU_REGISTER(0x057B, kDword, SCRATCH_REG3)
XE_GPU_REGISTER(0x057C, kDword, CALLBACK_ADDRESS)
XE_GPU_REGISTER(0x057D, kDword, CALLBACK_CONTEXT)
XE_GPU_REGISTER(0x057E, kDword, SCRATCH_REG6)
XE_GPU_REGISTER(0x057F, kDword, SCRATCH_REG7)

XE_GPU_REGISTER(0x05C8, kDword, WAIT_UNTIL)

XE_GPU_REGISTER(0x0815, kDword, MC0_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0816, kDword, MC0_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0817, kDword, MC0_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0855, kDword, MC1_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0856, kDword, MC1_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0857, kDword, MC1_PERFCOUNTER0_LOW)

XE_GPU_REGISTER(0x0A02, kDword, UNKNOWN_0A02)
XE_GPU_REGISTER(0x0A03, kDword, UNKNOWN_0A03)
XE_GPU_REGISTER(0x0A04, kDword, UNKNOWN_0A04)
XE_GPU_REGISTER(0x0A05, kDword, UNKNOWN_0A05)

XE_GPU_REGISTER(0x0A18, kDword, MH_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0A19, kDword, MH_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0A1A, kDword, MH_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0A1B, kDword, MH_PERFCOUNTER1_SELECT)
XE_GPU_REGISTER(0x0A1C, kDword, MH_PERFCOUNTER1_HI)
XE_GPU_REGISTER(0x0A1D, kDword, MH_PERFCOUNTER1_LOW)
XE_GPU_REGISTER(0x0A1E, kDword, MH_PERFCOUNTER2_SELECT)
XE_GPU_REGISTER(0x0A1F, kDword, MH_PERFCOUNTER2_HI)
XE_GPU_REGISTER(0x0A20, kDword, MH_PERFCOUNTER2_LOW)

XE_GPU_REGISTER(0x0A2F, kDword, COHER_SIZE_HOST)
XE_GPU_REGISTER(0x0A30, kDword, COHER_BASE_HOST)
XE_GPU_REGISTER(0x0A31, kDword, COHER_STATUS_HOST)

// Status flags of viz queries, doesn't seem to be read back by d3d
// queries 0x00 to 0x1f (be), bit set when visible
XE_GPU_REGISTER(0x0C44, kDword, PA_SC_VIZ_QUERY_STATUS_0)
// queries 0x20 to 0x3f (be)
XE_GPU_REGISTER(0x0C45, kDword, PA_SC_VIZ_QUERY_STATUS_1)

XE_GPU_REGISTER(0x0C48, kDword, VGT_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0C49, kDword, VGT_PERFCOUNTER1_SELECT)
XE_GPU_REGISTER(0x0C4A, kDword, VGT_PERFCOUNTER2_SELECT)
XE_GPU_REGISTER(0x0C4B, kDword, VGT_PERFCOUNTER3_SELECT)
XE_GPU_REGISTER(0x0C4C, kDword, VGT_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0C4D, kDword, VGT_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0C4E, kDword, VGT_PERFCOUNTER1_LOW)
XE_GPU_REGISTER(0x0C4F, kDword, VGT_PERFCOUNTER1_HI)
XE_GPU_REGISTER(0x0C50, kDword, VGT_PERFCOUNTER2_LOW)
XE_GPU_REGISTER(0x0C51, kDword, VGT_PERFCOUNTER2_HI)
XE_GPU_REGISTER(0x0C52, kDword, VGT_PERFCOUNTER3_LOW)
XE_GPU_REGISTER(0x0C53, kDword, VGT_PERFCOUNTER3_HI)

XE_GPU_REGISTER(0x0C85, kDword, PA_CL_ENHANCE)

XE_GPU_REGISTER(0x0C88, kDword, PA_SU_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0C89, kDword, PA_SU_PERFCOUNTER1_SELECT)
XE_GPU_REGISTER(0x0C8A, kDword, PA_SU_PERFCOUNTER2_SELECT)
XE_GPU_REGISTER(0x0C8B, kDword, PA_SU_PERFCOUNTER3_SELECT)
XE_GPU_REGISTER(0x0C8C, kDword, PA_SU_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0C8D, kDword, PA_SU_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0C8E, kDword, PA_SU_PERFCOUNTER1_LOW)
XE_GPU_REGISTER(0x0C8F, kDword, PA_SU_PERFCOUNTER1_HI)
XE_GPU_REGISTER(0x0C90, kDword, PA_SU_PERFCOUNTER2_LOW)
XE_GPU_REGISTER(0x0C91, kDword, PA_SU_PERFCOUNTER2_HI)
XE_GPU_REGISTER(0x0C92, kDword, PA_SU_PERFCOUNTER3_LOW)
XE_GPU_REGISTER(0x0C93, kDword, PA_SU_PERFCOUNTER3_HI)
XE_GPU_REGISTER(0x0C98, kDword, PA_SC_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0C99, kDword, PA_SC_PERFCOUNTER1_SELECT)
XE_GPU_REGISTER(0x0C9A, kDword, PA_SC_PERFCOUNTER2_SELECT)
XE_GPU_REGISTER(0x0C9B, kDword, PA_SC_PERFCOUNTER3_SELECT)
XE_GPU_REGISTER(0x0C9C, kDword, PA_SC_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0C9D, kDword, PA_SC_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0C9E, kDword, PA_SC_PERFCOUNTER1_LOW)
XE_GPU_REGISTER(0x0C9F, kDword, PA_SC_PERFCOUNTER1_HI)
XE_GPU_REGISTER(0x0CA0, kDword, PA_SC_PERFCOUNTER2_LOW)
XE_GPU_REGISTER(0x0CA1, kDword, PA_SC_PERFCOUNTER2_HI)
XE_GPU_REGISTER(0x0CA2, kDword, PA_SC_PERFCOUNTER3_LOW)
XE_GPU_REGISTER(0x0CA3, kDword, PA_SC_PERFCOUNTER3_HI)

XE_GPU_REGISTER(0x0D00, kDword, SQ_GPR_MANAGEMENT)
XE_GPU_REGISTER(0x0D01, kDword, SQ_FLOW_CONTROL)
XE_GPU_REGISTER(0x0D02, kDword, SQ_INST_STORE_MANAGMENT)

XE_GPU_REGISTER(0x0D04, kDword, SQ_EO_RT)

XE_GPU_REGISTER(0x0DC8, kDword, SQ_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0DC9, kDword, SQ_PERFCOUNTER1_SELECT)
XE_GPU_REGISTER(0x0DCA, kDword, SQ_PERFCOUNTER2_SELECT)
XE_GPU_REGISTER(0x0DCB, kDword, SQ_PERFCOUNTER3_SELECT)
XE_GPU_REGISTER(0x0DCC, kDword, SQ_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0DCD, kDword, SQ_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0DCE, kDword, SQ_PERFCOUNTER1_LOW)
XE_GPU_REGISTER(0x0DCF, kDword, SQ_PERFCOUNTER1_HI)
XE_GPU_REGISTER(0x0DD0, kDword, SQ_PERFCOUNTER2_LOW)
XE_GPU_REGISTER(0x0DD1, kDword, SQ_PERFCOUNTER2_HI)
XE_GPU_REGISTER(0x0DD2, kDword, SQ_PERFCOUNTER3_LOW)
XE_GPU_REGISTER(0x0DD3, kDword, SQ_PERFCOUNTER3_HI)
XE_GPU_REGISTER(0x0DD4, kDword, SX_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0DD8, kDword, SX_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0DD9, kDword, SX_PERFCOUNTER0_HI)

// Set with WAIT_UNTIL = WAIT_3D_IDLECLEAN
XE_GPU_REGISTER(0x0E00, kDword, UNKNOWN_0E00)

XE_GPU_REGISTER(0x0E05, kDword, TCR_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0E06, kDword, TCR_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0E07, kDword, TCR_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0E08, kDword, TCR_PERFCOUNTER1_SELECT)
XE_GPU_REGISTER(0x0E09, kDword, TCR_PERFCOUNTER1_HI)
XE_GPU_REGISTER(0x0E0A, kDword, TCR_PERFCOUNTER1_LOW)

XE_GPU_REGISTER(0x0E1F, kDword, TP0_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0E20, kDword, TP0_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0E21, kDword, TP0_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0E22, kDword, TP0_PERFCOUNTER1_SELECT)
XE_GPU_REGISTER(0x0E23, kDword, TP0_PERFCOUNTER1_HI)
XE_GPU_REGISTER(0x0E24, kDword, TP0_PERFCOUNTER1_LOW)

XE_GPU_REGISTER(0x0E28, kDword, TP1_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0E29, kDword, TP1_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0E2A, kDword, TP1_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0E2B, kDword, TP1_PERFCOUNTER1_SELECT)
XE_GPU_REGISTER(0x0E2C, kDword, TP1_PERFCOUNTER1_HI)
XE_GPU_REGISTER(0x0E2D, kDword, TP1_PERFCOUNTER1_LOW)

XE_GPU_REGISTER(0x0E31, kDword, TP2_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0E32, kDword, TP2_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0E33, kDword, TP2_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0E34, kDword, TP2_PERFCOUNTER1_SELECT)
XE_GPU_REGISTER(0x0E35, kDword, TP2_PERFCOUNTER1_HI)
XE_GPU_REGISTER(0x0E36, kDword, TP2_PERFCOUNTER1_LOW)

XE_GPU_REGISTER(0x0E3A, kDword, TP3_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0E3B, kDword, TP3_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0E3C, kDword, TP3_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0E3D, kDword, TP3_PERFCOUNTER1_SELECT)
XE_GPU_REGISTER(0x0E3E, kDword, TP3_PERFCOUNTER1_HI)
XE_GPU_REGISTER(0x0E3F, kDword, TP3_PERFCOUNTER1_LOW)

// Set with WAIT_UNTIL = WAIT_3D_IDLECLEAN
XE_GPU_REGISTER(0x0E40, kDword, UNKNOWN_0E40)

// Set during GPU initialization by D3D
XE_GPU_REGISTER(0x0E42, kDword, UNKNOWN_0E42)

XE_GPU_REGISTER(0x0E48, kDword, VC_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0E49, kDword, VC_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0E4A, kDword, VC_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0E4B, kDword, VC_PERFCOUNTER1_SELECT)
XE_GPU_REGISTER(0x0E4C, kDword, VC_PERFCOUNTER1_HI)
XE_GPU_REGISTER(0x0E4D, kDword, VC_PERFCOUNTER1_LOW)
XE_GPU_REGISTER(0x0E4E, kDword, VC_PERFCOUNTER2_SELECT)
XE_GPU_REGISTER(0x0E4F, kDword, VC_PERFCOUNTER2_HI)
XE_GPU_REGISTER(0x0E50, kDword, VC_PERFCOUNTER2_LOW)
XE_GPU_REGISTER(0x0E51, kDword, VC_PERFCOUNTER3_SELECT)
XE_GPU_REGISTER(0x0E52, kDword, VC_PERFCOUNTER3_HI)
XE_GPU_REGISTER(0x0E53, kDword, VC_PERFCOUNTER3_LOW)

XE_GPU_REGISTER(0x0E54, kDword, TCM_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0E55, kDword, TCM_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0E56, kDword, TCM_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0E57, kDword, TCM_PERFCOUNTER1_SELECT)
XE_GPU_REGISTER(0x0E58, kDword, TCM_PERFCOUNTER1_HI)
XE_GPU_REGISTER(0x0E59, kDword, TCM_PERFCOUNTER1_LOW)

XE_GPU_REGISTER(0x0E5A, kDword, TCF_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0E5B, kDword, TCF_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0E5C, kDword, TCF_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0E5D, kDword, TCF_PERFCOUNTER1_SELECT)
XE_GPU_REGISTER(0x0E5E, kDword, TCF_PERFCOUNTER1_HI)
XE_GPU_REGISTER(0x0E5F, kDword, TCF_PERFCOUNTER1_LOW)
XE_GPU_REGISTER(0x0E60, kDword, TCF_PERFCOUNTER2_SELECT)
XE_GPU_REGISTER(0x0E61, kDword, TCF_PERFCOUNTER2_HI)
XE_GPU_REGISTER(0x0E62, kDword, TCF_PERFCOUNTER2_LOW)
XE_GPU_REGISTER(0x0E63, kDword, TCF_PERFCOUNTER3_SELECT)
XE_GPU_REGISTER(0x0E64, kDword, TCF_PERFCOUNTER3_HI)
XE_GPU_REGISTER(0x0E65, kDword, TCF_PERFCOUNTER3_LOW)
XE_GPU_REGISTER(0x0E66, kDword, TCF_PERFCOUNTER4_SELECT)
XE_GPU_REGISTER(0x0E67, kDword, TCF_PERFCOUNTER4_HI)
XE_GPU_REGISTER(0x0E68, kDword, TCF_PERFCOUNTER4_LOW)
XE_GPU_REGISTER(0x0E69, kDword, TCF_PERFCOUNTER5_SELECT)
XE_GPU_REGISTER(0x0E6A, kDword, TCF_PERFCOUNTER5_HI)
XE_GPU_REGISTER(0x0E6B, kDword, TCF_PERFCOUNTER5_LOW)
XE_GPU_REGISTER(0x0E6C, kDword, TCF_PERFCOUNTER6_SELECT)
XE_GPU_REGISTER(0x0E6D, kDword, TCF_PERFCOUNTER6_HI)
XE_GPU_REGISTER(0x0E6E, kDword, TCF_PERFCOUNTER6_LOW)
XE_GPU_REGISTER(0x0E6F, kDword, TCF_PERFCOUNTER7_SELECT)
XE_GPU_REGISTER(0x0E70, kDword, TCF_PERFCOUNTER7_HI)
XE_GPU_REGISTER(0x0E71, kDword, TCF_PERFCOUNTER7_LOW)
XE_GPU_REGISTER(0x0E72, kDword, TCF_PERFCOUNTER8_SELECT)
XE_GPU_REGISTER(0x0E73, kDword, TCF_PERFCOUNTER8_HI)
XE_GPU_REGISTER(0x0E74, kDword, TCF_PERFCOUNTER8_LOW)
XE_GPU_REGISTER(0x0E75, kDword, TCF_PERFCOUNTER9_SELECT)
XE_GPU_REGISTER(0x0E76, kDword, TCF_PERFCOUNTER9_HI)
XE_GPU_REGISTER(0x0E77, kDword, TCF_PERFCOUNTER9_LOW)
XE_GPU_REGISTER(0x0E78, kDword, TCF_PERFCOUNTER10_SELECT)
XE_GPU_REGISTER(0x0E79, kDword, TCF_PERFCOUNTER10_HI)
XE_GPU_REGISTER(0x0E7A, kDword, TCF_PERFCOUNTER10_LOW)
XE_GPU_REGISTER(0x0E7B, kDword, TCF_PERFCOUNTER11_SELECT)
XE_GPU_REGISTER(0x0E7C, kDword, TCF_PERFCOUNTER11_HI)
XE_GPU_REGISTER(0x0E7D, kDword, TCF_PERFCOUNTER11_LOW)

XE_GPU_REGISTER(0x0F01, kDword, RB_BC_CONTROL)
XE_GPU_REGISTER(0x0F02, kDword, RB_EDRAM_INFO)

XE_GPU_REGISTER(0x0F04, kDword, BC_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x0F05, kDword, BC_PERFCOUNTER1_SELECT)
XE_GPU_REGISTER(0x0F06, kDword, BC_PERFCOUNTER2_SELECT)
XE_GPU_REGISTER(0x0F07, kDword, BC_PERFCOUNTER3_SELECT)
XE_GPU_REGISTER(0x0F08, kDword, BC_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x0F09, kDword, BC_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x0F0A, kDword, BC_PERFCOUNTER1_LOW)
XE_GPU_REGISTER(0x0F0B, kDword, BC_PERFCOUNTER1_HI)
XE_GPU_REGISTER(0x0F0C, kDword, BC_PERFCOUNTER2_LOW)
XE_GPU_REGISTER(0x0F0D, kDword, BC_PERFCOUNTER2_HI)
XE_GPU_REGISTER(0x0F0E, kDword, BC_PERFCOUNTER3_LOW)
XE_GPU_REGISTER(0x0F0F, kDword, BC_PERFCOUNTER3_HI)

XE_GPU_REGISTER(0x1004, kDword, HZ_PERFCOUNTER0_SELECT)
XE_GPU_REGISTER(0x1005, kDword, HZ_PERFCOUNTER0_HI)
XE_GPU_REGISTER(0x1006, kDword, HZ_PERFCOUNTER0_LOW)
XE_GPU_REGISTER(0x1007, kDword, HZ_PERFCOUNTER1_SELECT)
XE_GPU_REGISTER(0x1008, kDword, HZ_PERFCOUNTER1_HI)
XE_GPU_REGISTER(0x1009, kDword, HZ_PERFCOUNTER1_LOW)

// D1*, LUT, and AVIVO registers taken from libxenon and
// https://www.x.org/docs/AMD/old/RRG-216M56-03oOEM.pdf
XE_GPU_REGISTER(0x1838, kDword, D1MODE_MASTER_UPDATE_LOCK)

XE_GPU_REGISTER(0x1841, kDword, D1GRPH_CONTROL)

XE_GPU_REGISTER(0x1844, kDword, D1GRPH_PRIMARY_SURFACE_ADDRESS)

XE_GPU_REGISTER(0x1852, kDword, D1GRPH_FLIP_CONTROL)

// In 4B4F07FE, the 256-entry gamma ramp for the 8bpc framebuffer is set to
// different values in multiple places in the game. For VdGetCurrentDisplayGamma
// returning 1 (sRGB), it's set up in the beginning as:
// DC_LUTA_CONTROL = 0x00000000 (256-entry unsigned fixed-point)
// DC_LUT_RW_MODE = 0x00000000
// DC_LUT_RW_INDEX = 0x00000000
// DC_LUT_WRITE_EN_MASK = 0x00000007
// DC_LUT_30_COLOR = 0x00000000
// DC_LUT_RW_INDEX = 0x00000001
// DC_LUT_30_COLOR = 0x04812048
// DC_LUT_RW_INDEX = 0x00000002
// DC_LUT_30_COLOR = 0x05916459
// DC_LUT_RW_INDEX = 0x00000003
// DC_LUT_30_COLOR = 0x06519465
// ...
// DC_LUT_RW_INDEX = 0x000000FE
// DC_LUT_30_COLOR = 0x3FBFEFFB
// DC_LUT_RW_INDEX = 0x000000FF
// DC_LUT_30_COLOR = 0x3FFFFFFF
// DC_LUT_RW_INDEX = 0x00000100
//
// One another possible setup in 4B4F07FE is:
// DC_LUTA_CONTROL = 0x00000000 (256-entry unsigned fixed-point)
// DC_LUT_RW_MODE = 0x00000000
// DC_LUT_RW_INDEX = 0x00000000
// DC_LUT_WRITE_EN_MASK = 0x00000007
// DC_LUT_30_COLOR = 0x00000000
// DC_LUT_RW_INDEX = 0x00000001
// DC_LUT_30_COLOR = 0x01A0681A
// DC_LUT_RW_INDEX = 0x00000002
// DC_LUT_30_COLOR = 0x02709C27
// ...
// DC_LUT_RW_INDEX = 0x000000FE
// DC_LUT_30_COLOR = 0x3FBFEFFB
// DC_LUT_RW_INDEX = 0x000000FF
// DC_LUT_30_COLOR = 0x3FFFFFFF
// DC_LUT_RW_INDEX = 0x00000100
//
// In 4D5307E6, the 128-entry PWL gamma ramp for the 10bpc framebuffer, for
// VdGetCurrentDisplayGamma returning 1 (sRGB), is set up right after launching
// the game as:
// DC_LUTA_CONTROL = 0x00000003 (8-increment unsigned fixed-point)
// DC_LUT_RW_MODE = 0x00000001
// DC_LUT_RW_INDEX = 0x00000000
// DC_LUT_WRITE_EN_MASK = 0x00000007
// DC_LUT_PWL_DATA = 0x02000000
// DC_LUT_PWL_DATA = 0x02000000
// DC_LUT_PWL_DATA = 0x02000000
// DC_LUT_RW_INDEX = 0x00000001
// DC_LUT_PWL_DATA = 0x02000200
// DC_LUT_PWL_DATA = 0x02000200
// DC_LUT_PWL_DATA = 0x02000200
// DC_LUT_RW_INDEX = 0x00000001
// DC_LUT_PWL_DATA = 0x02000400
// DC_LUT_PWL_DATA = 0x02000400
// DC_LUT_PWL_DATA = 0x02000400
// ...
// DC_LUT_RW_INDEX = 0x0000007D
// DC_LUT_PWL_DATA = 0x0200FBC0
// DC_LUT_PWL_DATA = 0x0200FBC0
// DC_LUT_PWL_DATA = 0x0200FBC0
// DC_LUT_RW_INDEX = 0x0000007E
// DC_LUT_PWL_DATA = 0x0200FDC0
// DC_LUT_PWL_DATA = 0x0200FDC0
// DC_LUT_PWL_DATA = 0x0200FDC0
// DC_LUT_RW_INDEX = 0x0000007F
// DC_LUT_PWL_DATA = 0x0000FFC0
// DC_LUT_PWL_DATA = 0x0000FFC0
// DC_LUT_PWL_DATA = 0x0000FFC0
// DC_LUT_RW_INDEX = 0x00000080
//
// Later in 4D5307E6, for the game itself (apparently for conversion of the bit
// representation of 7e3 floating-point data in the front buffer to 10-bit fixed
// point, as the game draws the final passes to a 7e3 framebuffer), with
// VdGetCurrentDisplayGamma returning 1 (sRGB) and the normal brightness in the
// game settings, it's:
// DC_LUTA_CONTROL = 0x00000003 (8-increment unsigned fixed-point)
// DC_LUT_RW_MODE = 0x00000001
// DC_LUT_RW_INDEX = 0x00000000
// DC_LUT_WRITE_EN_MASK = 0x00000007
// DC_LUT_PWL_DATA = 0x05000000
// DC_LUT_PWL_DATA = 0x05000000
// DC_LUT_PWL_DATA = 0x05000000
// DC_LUT_RW_INDEX = 0x00000001
// DC_LUT_PWL_DATA = 0x02000500
// DC_LUT_PWL_DATA = 0x02000500
// DC_LUT_PWL_DATA = 0x02000500
// DC_LUT_RW_INDEX = 0x00000001
// DC_LUT_PWL_DATA = 0x01800740
// DC_LUT_PWL_DATA = 0x01800740
// DC_LUT_PWL_DATA = 0x01800740
// ...
// DC_LUT_RW_INDEX = 0x0000007D
// DC_LUT_PWL_DATA = 0x0440F340
// DC_LUT_PWL_DATA = 0x0440F340
// DC_LUT_PWL_DATA = 0x0440F340
// DC_LUT_RW_INDEX = 0x0000007E
// DC_LUT_PWL_DATA = 0x0400F780
// DC_LUT_PWL_DATA = 0x0400F780
// DC_LUT_PWL_DATA = 0x0400F780
// DC_LUT_RW_INDEX = 0x0000007F
// DC_LUT_PWL_DATA = 0x0400FBC0
// DC_LUT_PWL_DATA = 0x0400FBC0
// DC_LUT_PWL_DATA = 0x0400FBC0
// DC_LUT_RW_INDEX = 0x00000080
//
// In 535107D4, the 256-entry gamma ramp for the 8bpc framebuffer is
// configurable from the game's settings menu for each channel independently.
// For VdGetCurrentDisplayGamma returning 1 (sRGB), when in the settings, the
// red gamma is at the maximum of 5.56, green is at 1.00, and blue is at the
// minimum of 0.17, the setup is done as:
// DC_LUT_RW_MODE = 0x00000000
// DC_LUT_RW_INDEX = 0x00000000
// DC_LUT_WRITE_EN_MASK = 0x00000007
// DC_LUT_30_COLOR = 0x00000000
// DC_LUT_RW_INDEX = 0x00000001
// DC_LUT_30_COLOR = 0x17901000
// DC_LUT_RW_INDEX = 0x00000002
// DC_LUT_30_COLOR = 0x1AB02000
// ...
// DC_LUT_RW_INDEX = 0x000000FE
// DC_LUT_30_COLOR = 0x3FEFE3D2
// DC_LUT_RW_INDEX = 0x000000FF
// DC_LUT_30_COLOR = 0x3FFFF3E9
// DC_LUT_RW_INDEX = 0x00000100

// Read / write mode in bit 0: 0 - 256-entry table, 1 - PWL.
// Default: 0x00000000.
XE_GPU_REGISTER(0x1921, kDword, DC_LUT_RW_MODE)
// Read / write index. No lower and upper halves on the Xenos apparently, for
// the 256-entry table, the bits 0:7 are the index directly (unlike on the M56,
// not split into the index in 1:7 and the lower or upper 10 bits selection in
// 0:0, instead, on the Xenos, the index in 0:7 is just increased
// monotonically). For some reason though Direct3D 9 writes an index that
// overflows by one (0x100 for the 256-entry table, 0x80 for the 128-entry PWL
// gamma ramp) after setting up all the values. However, the index is 8-bit, and
// for PWL, according to the M56 documentation, the bit 7 is not used.
// Default: 0x00000000.
XE_GPU_REGISTER(0x1922, kDword, DC_LUT_RW_INDEX)
// Sequential 10-bit R, G, B host read / write for the 256-entry table. After
// reset or writing DC_LUT_RW_INDEX, the first access is for the red component,
// the second is for green, the third is for blue, and after blue is accessed,
// the LUT index is increased by 1 (without having to explicitly change
// DC_LUT_RW_INDEX). Bits 0:5 are hardwired to zero.
// Default: 0x00000000.
XE_GPU_REGISTER(0x1923, kDword, DC_LUT_SEQ_COLOR)
// Read / write, 0:15 - base, 16:31 - delta. Bits 0:5 of both the base and the
// delta are hardwired to zero. The LUT index is increased by 1 when
// DC_LUT_PWL_DATA is accessed, though three DC_LUT_PWL_DATA writes are done for
// one entry (the order is likely R, G, B, similar to DC_LUT_SEQ_COLOR, but this
// hasn't been verified yet as no games using the PWL gamma ramp with separate
// settings for each channel have been found yet).
// Default: 0x00000000.
XE_GPU_REGISTER(0x1924, kDword, DC_LUT_PWL_DATA)
// Read / write, 0:9 - blue, 10:19 - green, 20:29 - red. The LUT index is
// increased by 1 when DC_LUT_30_COLOR is accessed.
// Default: 0x00000000.
XE_GPU_REGISTER(0x1925, kDword, DC_LUT_30_COLOR)

// Only LUT pipe 1 on the Xenos apparently (Direct3D 9 sets DC_LUT_WRITE_EN_MASK
// to 0b111 before writing the gamma ramp), 3 bits set, rather than 6 on the
// M56.
// Bit 0 - blue write enable mask.
// Bit 1 - green write enable mask.
// Bit 2 - red write enable mask.
// Default: 0x00000007 (though 0x0000003F on the M56 where there are two pipes).
XE_GPU_REGISTER(0x1927, kDword, DC_LUT_WRITE_EN_MASK)

// Single set of parameters for all channels apparently unlike on the M56
// (4D5307E6 sets DC_LUTA_CONTROL to 0x00000003 for the data increment of 8 in
// the 128-entry PWL gamma ramp for a 10bpc framebuffer). Also set not only
// during setup, but also apparently during every swap by Direct3D 9, though not
// directly in all games (happens in 4B4F07FE and 4D5307E6 even without proper
// VdSwap emulation, but in 535107D4, with a fake VdSwap packet rather than the
// real ones, the register is not set at all, though the expected behavior is
// that of the value of 0x00000000).
// Default: 0x00000000.
XE_GPU_REGISTER(0x1930, kDword, DC_LUTA_CONTROL)

XE_GPU_REGISTER(0x1961, kDword, AVIVO_D1MODE_VIEWPORT_SIZE)

XE_GPU_REGISTER(0x1964, kDword, AVIVO_D1SCL_SCALER_ENABLE)

XE_GPU_REGISTER(0x1973, kDword, AVIVO_D1SCL_UPDATE)

XE_GPU_REGISTER(0x2000, kDword, RB_SURFACE_INFO)
XE_GPU_REGISTER(0x2001, kDword, RB_COLOR_INFO)
XE_GPU_REGISTER(0x2002, kDword, RB_DEPTH_INFO)
XE_GPU_REGISTER(0x2003, kDword, RB_COLOR1_INFO)
XE_GPU_REGISTER(0x2004, kDword, RB_COLOR2_INFO)
XE_GPU_REGISTER(0x2005, kDword, RB_COLOR3_INFO)
XE_GPU_REGISTER(0x2006, kDword, COHER_DEST_BASE_0)
XE_GPU_REGISTER(0x2007, kDword, COHER_DEST_BASE_1)
XE_GPU_REGISTER(0x2008, kDword, COHER_DEST_BASE_2)
XE_GPU_REGISTER(0x2009, kDword, COHER_DEST_BASE_3)
XE_GPU_REGISTER(0x200A, kDword, COHER_DEST_BASE_4)
XE_GPU_REGISTER(0x200B, kDword, COHER_DEST_BASE_5)
XE_GPU_REGISTER(0x200C, kDword, COHER_DEST_BASE_6)
XE_GPU_REGISTER(0x200D, kDword, COHER_DEST_BASE_7)
XE_GPU_REGISTER(0x200E, kDword, PA_SC_SCREEN_SCISSOR_TL)
XE_GPU_REGISTER(0x200F, kDword, PA_SC_SCREEN_SCISSOR_BR)

XE_GPU_REGISTER(0x2080, kDword, PA_SC_WINDOW_OFFSET)
XE_GPU_REGISTER(0x2081, kDword, PA_SC_WINDOW_SCISSOR_TL)
XE_GPU_REGISTER(0x2082, kDword, PA_SC_WINDOW_SCISSOR_BR)

XE_GPU_REGISTER(0x2100, kDword, VGT_MAX_VTX_INDX)
XE_GPU_REGISTER(0x2101, kDword, VGT_MIN_VTX_INDX)
XE_GPU_REGISTER(0x2102, kDword, VGT_INDX_OFFSET)
XE_GPU_REGISTER(0x2103, kDword, VGT_MULTI_PRIM_IB_RESET_INDX)
XE_GPU_REGISTER(0x2104, kDword, RB_COLOR_MASK)
XE_GPU_REGISTER(0x2105, kFloat, RB_BLEND_RED)
XE_GPU_REGISTER(0x2106, kFloat, RB_BLEND_GREEN)
XE_GPU_REGISTER(0x2107, kFloat, RB_BLEND_BLUE)
XE_GPU_REGISTER(0x2108, kFloat, RB_BLEND_ALPHA)
XE_GPU_REGISTER(0x2109, kFloat, RB_FOG_COLOR_RED)
XE_GPU_REGISTER(0x210A, kFloat, RB_FOG_COLOR_GREEN)
XE_GPU_REGISTER(0x210B, kFloat, RB_FOG_COLOR_BLUE)
XE_GPU_REGISTER(0x210C, kDword, RB_STENCILREFMASK_BF)
XE_GPU_REGISTER(0x210D, kDword, RB_STENCILREFMASK)
XE_GPU_REGISTER(0x210E, kFloat, RB_ALPHA_REF)
XE_GPU_REGISTER(0x210F, kFloat, PA_CL_VPORT_XSCALE)
XE_GPU_REGISTER(0x2110, kFloat, PA_CL_VPORT_XOFFSET)
XE_GPU_REGISTER(0x2111, kFloat, PA_CL_VPORT_YSCALE)
XE_GPU_REGISTER(0x2112, kFloat, PA_CL_VPORT_YOFFSET)
XE_GPU_REGISTER(0x2113, kFloat, PA_CL_VPORT_ZSCALE)
XE_GPU_REGISTER(0x2114, kFloat, PA_CL_VPORT_ZOFFSET)

XE_GPU_REGISTER(0x2180, kDword, SQ_PROGRAM_CNTL)
XE_GPU_REGISTER(0x2181, kDword, SQ_CONTEXT_MISC)
XE_GPU_REGISTER(0x2182, kDword, SQ_INTERPOLATOR_CNTL)
XE_GPU_REGISTER(0x2183, kDword, SQ_WRAPPING_0)
XE_GPU_REGISTER(0x2184, kDword, SQ_WRAPPING_1)

// These three registers are set by the command processor.
XE_GPU_REGISTER(0x21F9, kDword, VGT_EVENT_INITIATOR)
XE_GPU_REGISTER(0x21FA, kDword, VGT_DMA_BASE)
XE_GPU_REGISTER(0x21FB, kDword, VGT_DMA_SIZE)
XE_GPU_REGISTER(0x21FC, kDword, VGT_DRAW_INITIATOR)
XE_GPU_REGISTER(0x21FD, kDword, VGT_IMMED_DATA)

XE_GPU_REGISTER(0x2200, kDword, RB_DEPTHCONTROL)
XE_GPU_REGISTER(0x2201, kDword, RB_BLENDCONTROL0)
XE_GPU_REGISTER(0x2202, kDword, RB_COLORCONTROL)
XE_GPU_REGISTER(0x2203, kDword, RB_HIZCONTROL)
XE_GPU_REGISTER(0x2204, kDword, PA_CL_CLIP_CNTL)
XE_GPU_REGISTER(0x2205, kDword, PA_SU_SC_MODE_CNTL)
XE_GPU_REGISTER(0x2206, kDword, PA_CL_VTE_CNTL)
XE_GPU_REGISTER(0x2207, kDword, VGT_CURRENT_BIN_ID_MIN)
XE_GPU_REGISTER(0x2208, kDword, RB_MODECONTROL)
XE_GPU_REGISTER(0x2209, kDword, RB_BLENDCONTROL1)
XE_GPU_REGISTER(0x220A, kDword, RB_BLENDCONTROL2)
XE_GPU_REGISTER(0x220B, kDword, RB_BLENDCONTROL3)

XE_GPU_REGISTER(0x2280, kDword, PA_SU_POINT_SIZE)
XE_GPU_REGISTER(0x2281, kDword, PA_SU_POINT_MINMAX)
XE_GPU_REGISTER(0x2282, kDword, PA_SU_LINE_CNTL)
XE_GPU_REGISTER(0x2283, kDword, PA_SC_LINE_STIPPLE)
XE_GPU_REGISTER(0x2284, kDword, VGT_OUTPUT_PATH_CNTL)
XE_GPU_REGISTER(0x2285, kDword, VGT_HOS_CNTL)
XE_GPU_REGISTER(0x2286, kFloat, VGT_HOS_MAX_TESS_LEVEL)
XE_GPU_REGISTER(0x2287, kFloat, VGT_HOS_MIN_TESS_LEVEL)
XE_GPU_REGISTER(0x2288, kDword, VGT_HOS_REUSE_DEPTH)
XE_GPU_REGISTER(0x2289, kDword, VGT_GROUP_PRIM_TYPE)
XE_GPU_REGISTER(0x228A, kDword, VGT_GROUP_FIRST_DECR)
XE_GPU_REGISTER(0x228B, kDword, VGT_GROUP_DECR)
XE_GPU_REGISTER(0x228C, kDword, VGT_GROUP_VECT_0_CNTL)
XE_GPU_REGISTER(0x228D, kDword, VGT_GROUP_VECT_1_CNTL)
XE_GPU_REGISTER(0x228E, kDword, VGT_GROUP_VECT_0_FMT_CNTL)
XE_GPU_REGISTER(0x228F, kDword, VGT_GROUP_VECT_1_FMT_CNTL)
XE_GPU_REGISTER(0x2290, kDword, UNKNOWN_2290)
XE_GPU_REGISTER(0x2291, kDword, UNKNOWN_2291)
XE_GPU_REGISTER(0x2292, kDword, PA_SC_MPASS_PS_CNTL)
XE_GPU_REGISTER(0x2293, kDword, PA_SC_VIZ_QUERY)
XE_GPU_REGISTER(0x2294, kDword, VGT_ENHANCE)

XE_GPU_REGISTER(0x2300, kDword, PA_SC_LINE_CNTL)
XE_GPU_REGISTER(0x2301, kDword, PA_SC_AA_CONFIG)
XE_GPU_REGISTER(0x2302, kDword, PA_SU_VTX_CNTL)
XE_GPU_REGISTER(0x2303, kFloat, PA_CL_GB_VERT_CLIP_ADJ)
XE_GPU_REGISTER(0x2304, kFloat, PA_CL_GB_VERT_DISC_ADJ)
XE_GPU_REGISTER(0x2305, kFloat, PA_CL_GB_HORZ_CLIP_ADJ)
XE_GPU_REGISTER(0x2306, kFloat, PA_CL_GB_HORZ_DISC_ADJ)
XE_GPU_REGISTER(0x2307, kDword, SQ_VS_CONST)
XE_GPU_REGISTER(0x2308, kDword, SQ_PS_CONST)
XE_GPU_REGISTER(0x2309, kDword, SQ_DEBUG_MISC_0)
XE_GPU_REGISTER(0x230A, kDword, SQ_DEBUG_MISC_1)
XE_GPU_REGISTER(0x230B, kDword, UNKNOWN_230B)
XE_GPU_REGISTER(0x230C, kDword, UNKNOWN_230C)
XE_GPU_REGISTER(0x230D, kDword, UNKNOWN_230D)
XE_GPU_REGISTER(0x230E, kDword, UNKNOWN_230E)
XE_GPU_REGISTER(0x230F, kDword, UNKNOWN_230F)
XE_GPU_REGISTER(0x2310, kDword, UNKNOWN_2310)
XE_GPU_REGISTER(0x2311, kDword, UNKNOWN_2311)
XE_GPU_REGISTER(0x2312, kDword, PA_SC_AA_MASK)
XE_GPU_REGISTER(0x2313, kDword, UNKNOWN_2313)
XE_GPU_REGISTER(0x2314, kDword, UNKNOWN_2314)
XE_GPU_REGISTER(0x2315, kDword, SQ_CF_PROGRAM_SIZE)
XE_GPU_REGISTER(0x2316, kDword, VGT_VERTEX_REUSE_BLOCK_CNTL)
XE_GPU_REGISTER(0x2317, kDword, VGT_OUT_DEALLOC_CNTL)
XE_GPU_REGISTER(0x2318, kDword, RB_COPY_CONTROL)
XE_GPU_REGISTER(0x2319, kDword, RB_COPY_DEST_BASE)
XE_GPU_REGISTER(0x231A, kDword, RB_COPY_DEST_PITCH)
XE_GPU_REGISTER(0x231B, kDword, RB_COPY_DEST_INFO)
XE_GPU_REGISTER(0x231C, kDword, RB_HIZ_CLEAR)
XE_GPU_REGISTER(0x231D, kDword, RB_DEPTH_CLEAR)
XE_GPU_REGISTER(0x231E, kDword, RB_COLOR_CLEAR)
XE_GPU_REGISTER(0x231F, kDword, RB_COLOR_CLEAR_LO)
XE_GPU_REGISTER(0x2320, kDword, RB_COPY_FUNC)
XE_GPU_REGISTER(0x2321, kDword, RB_COPY_REF)
XE_GPU_REGISTER(0x2322, kDword, RB_COPY_MASK)
XE_GPU_REGISTER(0x2323, kDword, RB_COPY_SURFACE_SLICE)
XE_GPU_REGISTER(0x2324, kDword, RB_SAMPLE_COUNT_CTL)
XE_GPU_REGISTER(0x2325, kDword, RB_SAMPLE_COUNT_ADDR)

// Polygon offset scales and offsets are 32-bit floating-point.
// "slope computed in subpixels (1/12 or 1/16)" - R5xx Acceleration.
// But the correct scale for conversion of the slope scale (FRONT_BACK/SCALE)
// from subpixels to pixels is likely 1/16 according to:
// https://github.com/mesa3d/mesa/blob/54ad9b444c8e73da498211870e785239ad3ff1aa/src/gallium/drivers/radeonsi/si_state.c#L946
XE_GPU_REGISTER(0x2380, kFloat, PA_SU_POLY_OFFSET_FRONT_SCALE)
XE_GPU_REGISTER(0x2381, kFloat, PA_SU_POLY_OFFSET_FRONT_OFFSET)
XE_GPU_REGISTER(0x2382, kFloat, PA_SU_POLY_OFFSET_BACK_SCALE)
XE_GPU_REGISTER(0x2383, kFloat, PA_SU_POLY_OFFSET_BACK_OFFSET)
XE_GPU_REGISTER(0x2384, kFloat, PA_CL_POINT_X_RAD)
XE_GPU_REGISTER(0x2385, kFloat, PA_CL_POINT_Y_RAD)
XE_GPU_REGISTER(0x2386, kFloat, PA_CL_POINT_SIZE)
XE_GPU_REGISTER(0x2387, kFloat, PA_CL_POINT_CULL_RAD)
XE_GPU_REGISTER(0x2388, kFloat, PA_CL_UCP_0_X)
XE_GPU_REGISTER(0x2389, kFloat, PA_CL_UCP_0_Y)
XE_GPU_REGISTER(0x238A, kFloat, PA_CL_UCP_0_Z)
XE_GPU_REGISTER(0x238B, kFloat, PA_CL_UCP_0_W)
XE_GPU_REGISTER(0x238C, kFloat, PA_CL_UCP_1_X)
XE_GPU_REGISTER(0x238D, kFloat, PA_CL_UCP_1_Y)
XE_GPU_REGISTER(0x238E, kFloat, PA_CL_UCP_1_Z)
XE_GPU_REGISTER(0x238F, kFloat, PA_CL_UCP_1_W)
XE_GPU_REGISTER(0x2390, kFloat, PA_CL_UCP_2_X)
XE_GPU_REGISTER(0x2391, kFloat, PA_CL_UCP_2_Y)
XE_GPU_REGISTER(0x2392, kFloat, PA_CL_UCP_2_Z)
XE_GPU_REGISTER(0x2393, kFloat, PA_CL_UCP_2_W)
XE_GPU_REGISTER(0x2394, kFloat, PA_CL_UCP_3_X)
XE_GPU_REGISTER(0x2395, kFloat, PA_CL_UCP_3_Y)
XE_GPU_REGISTER(0x2396, kFloat, PA_CL_UCP_3_Z)
XE_GPU_REGISTER(0x2397, kFloat, PA_CL_UCP_3_W)
XE_GPU_REGISTER(0x2398, kFloat, PA_CL_UCP_4_X)
XE_GPU_REGISTER(0x2399, kFloat, PA_CL_UCP_4_Y)
XE_GPU_REGISTER(0x239A, kFloat, PA_CL_UCP_4_Z)
XE_GPU_REGISTER(0x239B, kFloat, PA_CL_UCP_4_W)
XE_GPU_REGISTER(0x239C, kFloat, PA_CL_UCP_5_X)
XE_GPU_REGISTER(0x239D, kFloat, PA_CL_UCP_5_Y)
XE_GPU_REGISTER(0x239E, kFloat, PA_CL_UCP_5_Z)
XE_GPU_REGISTER(0x239F, kFloat, PA_CL_UCP_5_W)

XE_GPU_REGISTER(0x4000, kFloat, SHADER_CONSTANT_000_X)
XE_GPU_REGISTER(0x4001, kFloat, SHADER_CONSTANT_000_Y)
XE_GPU_REGISTER(0x4002, kFloat, SHADER_CONSTANT_000_Z)
XE_GPU_REGISTER(0x4003, kFloat, SHADER_CONSTANT_000_W)
XE_GPU_REGISTER(0x4004, kFloat, SHADER_CONSTANT_001_X)
XE_GPU_REGISTER(0x4005, kFloat, SHADER_CONSTANT_001_Y)
XE_GPU_REGISTER(0x4006, kFloat, SHADER_CONSTANT_001_Z)
XE_GPU_REGISTER(0x4007, kFloat, SHADER_CONSTANT_001_W)
XE_GPU_REGISTER(0x4008, kFloat, SHADER_CONSTANT_002_X)
XE_GPU_REGISTER(0x4009, kFloat, SHADER_CONSTANT_002_Y)
XE_GPU_REGISTER(0x400A, kFloat, SHADER_CONSTANT_002_Z)
XE_GPU_REGISTER(0x400B, kFloat, SHADER_CONSTANT_002_W)
XE_GPU_REGISTER(0x400C, kFloat, SHADER_CONSTANT_003_X)
XE_GPU_REGISTER(0x400D, kFloat, SHADER_CONSTANT_003_Y)
XE_GPU_REGISTER(0x400E, kFloat, SHADER_CONSTANT_003_Z)
XE_GPU_REGISTER(0x400F, kFloat, SHADER_CONSTANT_003_W)
XE_GPU_REGISTER(0x4010, kFloat, SHADER_CONSTANT_004_X)
XE_GPU_REGISTER(0x4011, kFloat, SHADER_CONSTANT_004_Y)
XE_GPU_REGISTER(0x4012, kFloat, SHADER_CONSTANT_004_Z)
XE_GPU_REGISTER(0x4013, kFloat, SHADER_CONSTANT_004_W)
XE_GPU_REGISTER(0x4014, kFloat, SHADER_CONSTANT_005_X)
XE_GPU_REGISTER(0x4015, kFloat, SHADER_CONSTANT_005_Y)
XE_GPU_REGISTER(0x4016, kFloat, SHADER_CONSTANT_005_Z)
XE_GPU_REGISTER(0x4017, kFloat, SHADER_CONSTANT_005_W)
XE_GPU_REGISTER(0x4018, kFloat, SHADER_CONSTANT_006_X)
XE_GPU_REGISTER(0x4019, kFloat, SHADER_CONSTANT_006_Y)
XE_GPU_REGISTER(0x401A, kFloat, SHADER_CONSTANT_006_Z)
XE_GPU_REGISTER(0x401B, kFloat, SHADER_CONSTANT_006_W)
XE_GPU_REGISTER(0x401C, kFloat, SHADER_CONSTANT_007_X)
XE_GPU_REGISTER(0x401D, kFloat, SHADER_CONSTANT_007_Y)
XE_GPU_REGISTER(0x401E, kFloat, SHADER_CONSTANT_007_Z)
XE_GPU_REGISTER(0x401F, kFloat, SHADER_CONSTANT_007_W)
XE_GPU_REGISTER(0x4020, kFloat, SHADER_CONSTANT_008_X)
XE_GPU_REGISTER(0x4021, kFloat, SHADER_CONSTANT_008_Y)
XE_GPU_REGISTER(0x4022, kFloat, SHADER_CONSTANT_008_Z)
XE_GPU_REGISTER(0x4023, kFloat, SHADER_CONSTANT_008_W)
XE_GPU_REGISTER(0x4024, kFloat, SHADER_CONSTANT_009_X)
XE_GPU_REGISTER(0x4025, kFloat, SHADER_CONSTANT_009_Y)
XE_GPU_REGISTER(0x4026, kFloat, SHADER_CONSTANT_009_Z)
XE_GPU_REGISTER(0x4027, kFloat, SHADER_CONSTANT_009_W)
XE_GPU_REGISTER(0x4028, kFloat, SHADER_CONSTANT_010_X)
XE_GPU_REGISTER(0x4029, kFloat, SHADER_CONSTANT_010_Y)
XE_GPU_REGISTER(0x402A, kFloat, SHADER_CONSTANT_010_Z)
XE_GPU_REGISTER(0x402B, kFloat, SHADER_CONSTANT_010_W)
XE_GPU_REGISTER(0x402C, kFloat, SHADER_CONSTANT_011_X)
XE_GPU_REGISTER(0x402D, kFloat, SHADER_CONSTANT_011_Y)
XE_GPU_REGISTER(0x402E, kFloat, SHADER_CONSTANT_011_Z)
XE_GPU_REGISTER(0x402F, kFloat, SHADER_CONSTANT_011_W)
XE_GPU_REGISTER(0x4030, kFloat, SHADER_CONSTANT_012_X)
XE_GPU_REGISTER(0x4031, kFloat, SHADER_CONSTANT_012_Y)
XE_GPU_REGISTER(0x4032, kFloat, SHADER_CONSTANT_012_Z)
XE_GPU_REGISTER(0x4033, kFloat, SHADER_CONSTANT_012_W)
XE_GPU_REGISTER(0x4034, kFloat, SHADER_CONSTANT_013_X)
XE_GPU_REGISTER(0x4035, kFloat, SHADER_CONSTANT_013_Y)
XE_GPU_REGISTER(0x4036, kFloat, SHADER_CONSTANT_013_Z)
XE_GPU_REGISTER(0x4037, kFloat, SHADER_CONSTANT_013_W)
XE_GPU_REGISTER(0x4038, kFloat, SHADER_CONSTANT_014_X)
XE_GPU_REGISTER(0x4039, kFloat, SHADER_CONSTANT_014_Y)
XE_GPU_REGISTER(0x403A, kFloat, SHADER_CONSTANT_014_Z)
XE_GPU_REGISTER(0x403B, kFloat, SHADER_CONSTANT_014_W)
XE_GPU_REGISTER(0x403C, kFloat, SHADER_CONSTANT_015_X)
XE_GPU_REGISTER(0x403D, kFloat, SHADER_CONSTANT_015_Y)
XE_GPU_REGISTER(0x403E, kFloat, SHADER_CONSTANT_015_Z)
XE_GPU_REGISTER(0x403F, kFloat, SHADER_CONSTANT_015_W)
XE_GPU_REGISTER(0x4040, kFloat, SHADER_CONSTANT_016_X)
XE_GPU_REGISTER(0x4041, kFloat, SHADER_CONSTANT_016_Y)
XE_GPU_REGISTER(0x4042, kFloat, SHADER_CONSTANT_016_Z)
XE_GPU_REGISTER(0x4043, kFloat, SHADER_CONSTANT_016_W)
XE_GPU_REGISTER(0x4044, kFloat, SHADER_CONSTANT_017_X)
XE_GPU_REGISTER(0x4045, kFloat, SHADER_CONSTANT_017_Y)
XE_GPU_REGISTER(0x4046, kFloat, SHADER_CONSTANT_017_Z)
XE_GPU_REGISTER(0x4047, kFloat, SHADER_CONSTANT_017_W)
XE_GPU_REGISTER(0x4048, kFloat, SHADER_CONSTANT_018_X)
XE_GPU_REGISTER(0x4049, kFloat, SHADER_CONSTANT_018_Y)
XE_GPU_REGISTER(0x404A, kFloat, SHADER_CONSTANT_018_Z)
XE_GPU_REGISTER(0x404B, kFloat, SHADER_CONSTANT_018_W)
XE_GPU_REGISTER(0x404C, kFloat, SHADER_CONSTANT_019_X)
XE_GPU_REGISTER(0x404D, kFloat, SHADER_CONSTANT_019_Y)
XE_GPU_REGISTER(0x404E, kFloat, SHADER_CONSTANT_019_Z)
XE_GPU_REGISTER(0x404F, kFloat, SHADER_CONSTANT_019_W)
XE_GPU_REGISTER(0x4050, kFloat, SHADER_CONSTANT_020_X)
XE_GPU_REGISTER(0x4051, kFloat, SHADER_CONSTANT_020_Y)
XE_GPU_REGISTER(0x4052, kFloat, SHADER_CONSTANT_020_Z)
XE_GPU_REGISTER(0x4053, kFloat, SHADER_CONSTANT_020_W)
XE_GPU_REGISTER(0x4054, kFloat, SHADER_CONSTANT_021_X)
XE_GPU_REGISTER(0x4055, kFloat, SHADER_CONSTANT_021_Y)
XE_GPU_REGISTER(0x4056, kFloat, SHADER_CONSTANT_021_Z)
XE_GPU_REGISTER(0x4057, kFloat, SHADER_CONSTANT_021_W)
XE_GPU_REGISTER(0x4058, kFloat, SHADER_CONSTANT_022_X)
XE_GPU_REGISTER(0x4059, kFloat, SHADER_CONSTANT_022_Y)
XE_GPU_REGISTER(0x405A, kFloat, SHADER_CONSTANT_022_Z)
XE_GPU_REGISTER(0x405B, kFloat, SHADER_CONSTANT_022_W)
XE_GPU_REGISTER(0x405C, kFloat, SHADER_CONSTANT_023_X)
XE_GPU_REGISTER(0x405D, kFloat, SHADER_CONSTANT_023_Y)
XE_GPU_REGISTER(0x405E, kFloat, SHADER_CONSTANT_023_Z)
XE_GPU_REGISTER(0x405F, kFloat, SHADER_CONSTANT_023_W)
XE_GPU_REGISTER(0x4060, kFloat, SHADER_CONSTANT_024_X)
XE_GPU_REGISTER(0x4061, kFloat, SHADER_CONSTANT_024_Y)
XE_GPU_REGISTER(0x4062, kFloat, SHADER_CONSTANT_024_Z)
XE_GPU_REGISTER(0x4063, kFloat, SHADER_CONSTANT_024_W)
XE_GPU_REGISTER(0x4064, kFloat, SHADER_CONSTANT_025_X)
XE_GPU_REGISTER(0x4065, kFloat, SHADER_CONSTANT_025_Y)
XE_GPU_REGISTER(0x4066, kFloat, SHADER_CONSTANT_025_Z)
XE_GPU_REGISTER(0x4067, kFloat, SHADER_CONSTANT_025_W)
XE_GPU_REGISTER(0x4068, kFloat, SHADER_CONSTANT_026_X)
XE_GPU_REGISTER(0x4069, kFloat, SHADER_CONSTANT_026_Y)
XE_GPU_REGISTER(0x406A, kFloat, SHADER_CONSTANT_026_Z)
XE_GPU_REGISTER(0x406B, kFloat, SHADER_CONSTANT_026_W)
XE_GPU_REGISTER(0x406C, kFloat, SHADER_CONSTANT_027_X)
XE_GPU_REGISTER(0x406D, kFloat, SHADER_CONSTANT_027_Y)
XE_GPU_REGISTER(0x406E, kFloat, SHADER_CONSTANT_027_Z)
XE_GPU_REGISTER(0x406F, kFloat, SHADER_CONSTANT_027_W)
XE_GPU_REGISTER(0x4070, kFloat, SHADER_CONSTANT_028_X)
XE_GPU_REGISTER(0x4071, kFloat, SHADER_CONSTANT_028_Y)
XE_GPU_REGISTER(0x4072, kFloat, SHADER_CONSTANT_028_Z)
XE_GPU_REGISTER(0x4073, kFloat, SHADER_CONSTANT_028_W)
XE_GPU_REGISTER(0x4074, kFloat, SHADER_CONSTANT_029_X)
XE_GPU_REGISTER(0x4075, kFloat, SHADER_CONSTANT_029_Y)
XE_GPU_REGISTER(0x4076, kFloat, SHADER_CONSTANT_029_Z)
XE_GPU_REGISTER(0x4077, kFloat, SHADER_CONSTANT_029_W)
XE_GPU_REGISTER(0x4078, kFloat, SHADER_CONSTANT_030_X)
XE_GPU_REGISTER(0x4079, kFloat, SHADER_CONSTANT_030_Y)
XE_GPU_REGISTER(0x407A, kFloat, SHADER_CONSTANT_030_Z)
XE_GPU_REGISTER(0x407B, kFloat, SHADER_CONSTANT_030_W)
XE_GPU_REGISTER(0x407C, kFloat, SHADER_CONSTANT_031_X)
XE_GPU_REGISTER(0x407D, kFloat, SHADER_CONSTANT_031_Y)
XE_GPU_REGISTER(0x407E, kFloat, SHADER_CONSTANT_031_Z)
XE_GPU_REGISTER(0x407F, kFloat, SHADER_CONSTANT_031_W)
XE_GPU_REGISTER(0x4080, kFloat, SHADER_CONSTANT_032_X)
XE_GPU_REGISTER(0x4081, kFloat, SHADER_CONSTANT_032_Y)
XE_GPU_REGISTER(0x4082, kFloat, SHADER_CONSTANT_032_Z)
XE_GPU_REGISTER(0x4083, kFloat, SHADER_CONSTANT_032_W)
XE_GPU_REGISTER(0x4084, kFloat, SHADER_CONSTANT_033_X)
XE_GPU_REGISTER(0x4085, kFloat, SHADER_CONSTANT_033_Y)
XE_GPU_REGISTER(0x4086, kFloat, SHADER_CONSTANT_033_Z)
XE_GPU_REGISTER(0x4087, kFloat, SHADER_CONSTANT_033_W)
XE_GPU_REGISTER(0x4088, kFloat, SHADER_CONSTANT_034_X)
XE_GPU_REGISTER(0x4089, kFloat, SHADER_CONSTANT_034_Y)
XE_GPU_REGISTER(0x408A, kFloat, SHADER_CONSTANT_034_Z)
XE_GPU_REGISTER(0x408B, kFloat, SHADER_CONSTANT_034_W)
XE_GPU_REGISTER(0x408C, kFloat, SHADER_CONSTANT_035_X)
XE_GPU_REGISTER(0x408D, kFloat, SHADER_CONSTANT_035_Y)
XE_GPU_REGISTER(0x408E, kFloat, SHADER_CONSTANT_035_Z)
XE_GPU_REGISTER(0x408F, kFloat, SHADER_CONSTANT_035_W)
XE_GPU_REGISTER(0x4090, kFloat, SHADER_CONSTANT_036_X)
XE_GPU_REGISTER(0x4091, kFloat, SHADER_CONSTANT_036_Y)
XE_GPU_REGISTER(0x4092, kFloat, SHADER_CONSTANT_036_Z)
XE_GPU_REGISTER(0x4093, kFloat, SHADER_CONSTANT_036_W)
XE_GPU_REGISTER(0x4094, kFloat, SHADER_CONSTANT_037_X)
XE_GPU_REGISTER(0x4095, kFloat, SHADER_CONSTANT_037_Y)
XE_GPU_REGISTER(0x4096, kFloat, SHADER_CONSTANT_037_Z)
XE_GPU_REGISTER(0x4097, kFloat, SHADER_CONSTANT_037_W)
XE_GPU_REGISTER(0x4098, kFloat, SHADER_CONSTANT_038_X)
XE_GPU_REGISTER(0x4099, kFloat, SHADER_CONSTANT_038_Y)
XE_GPU_REGISTER(0x409A, kFloat, SHADER_CONSTANT_038_Z)
XE_GPU_REGISTER(0x409B, kFloat, SHADER_CONSTANT_038_W)
XE_GPU_REGISTER(0x409C, kFloat, SHADER_CONSTANT_039_X)
XE_GPU_REGISTER(0x409D, kFloat, SHADER_CONSTANT_039_Y)
XE_GPU_REGISTER(0x409E, kFloat, SHADER_CONSTANT_039_Z)
XE_GPU_REGISTER(0x409F, kFloat, SHADER_CONSTANT_039_W)
XE_GPU_REGISTER(0x40A0, kFloat, SHADER_CONSTANT_040_X)
XE_GPU_REGISTER(0x40A1, kFloat, SHADER_CONSTANT_040_Y)
XE_GPU_REGISTER(0x40A2, kFloat, SHADER_CONSTANT_040_Z)
XE_GPU_REGISTER(0x40A3, kFloat, SHADER_CONSTANT_040_W)
XE_GPU_REGISTER(0x40A4, kFloat, SHADER_CONSTANT_041_X)
XE_GPU_REGISTER(0x40A5, kFloat, SHADER_CONSTANT_041_Y)
XE_GPU_REGISTER(0x40A6, kFloat, SHADER_CONSTANT_041_Z)
XE_GPU_REGISTER(0x40A7, kFloat, SHADER_CONSTANT_041_W)
XE_GPU_REGISTER(0x40A8, kFloat, SHADER_CONSTANT_042_X)
XE_GPU_REGISTER(0x40A9, kFloat, SHADER_CONSTANT_042_Y)
XE_GPU_REGISTER(0x40AA, kFloat, SHADER_CONSTANT_042_Z)
XE_GPU_REGISTER(0x40AB, kFloat, SHADER_CONSTANT_042_W)
XE_GPU_REGISTER(0x40AC, kFloat, SHADER_CONSTANT_043_X)
XE_GPU_REGISTER(0x40AD, kFloat, SHADER_CONSTANT_043_Y)
XE_GPU_REGISTER(0x40AE, kFloat, SHADER_CONSTANT_043_Z)
XE_GPU_REGISTER(0x40AF, kFloat, SHADER_CONSTANT_043_W)
XE_GPU_REGISTER(0x40B0, kFloat, SHADER_CONSTANT_044_X)
XE_GPU_REGISTER(0x40B1, kFloat, SHADER_CONSTANT_044_Y)
XE_GPU_REGISTER(0x40B2, kFloat, SHADER_CONSTANT_044_Z)
XE_GPU_REGISTER(0x40B3, kFloat, SHADER_CONSTANT_044_W)
XE_GPU_REGISTER(0x40B4, kFloat, SHADER_CONSTANT_045_X)
XE_GPU_REGISTER(0x40B5, kFloat, SHADER_CONSTANT_045_Y)
XE_GPU_REGISTER(0x40B6, kFloat, SHADER_CONSTANT_045_Z)
XE_GPU_REGISTER(0x40B7, kFloat, SHADER_CONSTANT_045_W)
XE_GPU_REGISTER(0x40B8, kFloat, SHADER_CONSTANT_046_X)
XE_GPU_REGISTER(0x40B9, kFloat, SHADER_CONSTANT_046_Y)
XE_GPU_REGISTER(0x40BA, kFloat, SHADER_CONSTANT_046_Z)
XE_GPU_REGISTER(0x40BB, kFloat, SHADER_CONSTANT_046_W)
XE_GPU_REGISTER(0x40BC, kFloat, SHADER_CONSTANT_047_X)
XE_GPU_REGISTER(0x40BD, kFloat, SHADER_CONSTANT_047_Y)
XE_GPU_REGISTER(0x40BE, kFloat, SHADER_CONSTANT_047_Z)
XE_GPU_REGISTER(0x40BF, kFloat, SHADER_CONSTANT_047_W)
XE_GPU_REGISTER(0x40C0, kFloat, SHADER_CONSTANT_048_X)
XE_GPU_REGISTER(0x40C1, kFloat, SHADER_CONSTANT_048_Y)
XE_GPU_REGISTER(0x40C2, kFloat, SHADER_CONSTANT_048_Z)
XE_GPU_REGISTER(0x40C3, kFloat, SHADER_CONSTANT_048_W)
XE_GPU_REGISTER(0x40C4, kFloat, SHADER_CONSTANT_049_X)
XE_GPU_REGISTER(0x40C5, kFloat, SHADER_CONSTANT_049_Y)
XE_GPU_REGISTER(0x40C6, kFloat, SHADER_CONSTANT_049_Z)
XE_GPU_REGISTER(0x40C7, kFloat, SHADER_CONSTANT_049_W)
XE_GPU_REGISTER(0x40C8, kFloat, SHADER_CONSTANT_050_X)
XE_GPU_REGISTER(0x40C9, kFloat, SHADER_CONSTANT_050_Y)
XE_GPU_REGISTER(0x40CA, kFloat, SHADER_CONSTANT_050_Z)
XE_GPU_REGISTER(0x40CB, kFloat, SHADER_CONSTANT_050_W)
XE_GPU_REGISTER(0x40CC, kFloat, SHADER_CONSTANT_051_X)
XE_GPU_REGISTER(0x40CD, kFloat, SHADER_CONSTANT_051_Y)
XE_GPU_REGISTER(0x40CE, kFloat, SHADER_CONSTANT_051_Z)
XE_GPU_REGISTER(0x40CF, kFloat, SHADER_CONSTANT_051_W)
XE_GPU_REGISTER(0x40D0, kFloat, SHADER_CONSTANT_052_X)
XE_GPU_REGISTER(0x40D1, kFloat, SHADER_CONSTANT_052_Y)
XE_GPU_REGISTER(0x40D2, kFloat, SHADER_CONSTANT_052_Z)
XE_GPU_REGISTER(0x40D3, kFloat, SHADER_CONSTANT_052_W)
XE_GPU_REGISTER(0x40D4, kFloat, SHADER_CONSTANT_053_X)
XE_GPU_REGISTER(0x40D5, kFloat, SHADER_CONSTANT_053_Y)
XE_GPU_REGISTER(0x40D6, kFloat, SHADER_CONSTANT_053_Z)
XE_GPU_REGISTER(0x40D7, kFloat, SHADER_CONSTANT_053_W)
XE_GPU_REGISTER(0x40D8, kFloat, SHADER_CONSTANT_054_X)
XE_GPU_REGISTER(0x40D9, kFloat, SHADER_CONSTANT_054_Y)
XE_GPU_REGISTER(0x40DA, kFloat, SHADER_CONSTANT_054_Z)
XE_GPU_REGISTER(0x40DB, kFloat, SHADER_CONSTANT_054_W)
XE_GPU_REGISTER(0x40DC, kFloat, SHADER_CONSTANT_055_X)
XE_GPU_REGISTER(0x40DD, kFloat, SHADER_CONSTANT_055_Y)
XE_GPU_REGISTER(0x40DE, kFloat, SHADER_CONSTANT_055_Z)
XE_GPU_REGISTER(0x40DF, kFloat, SHADER_CONSTANT_055_W)
XE_GPU_REGISTER(0x40E0, kFloat, SHADER_CONSTANT_056_X)
XE_GPU_REGISTER(0x40E1, kFloat, SHADER_CONSTANT_056_Y)
XE_GPU_REGISTER(0x40E2, kFloat, SHADER_CONSTANT_056_Z)
XE_GPU_REGISTER(0x40E3, kFloat, SHADER_CONSTANT_056_W)
XE_GPU_REGISTER(0x40E4, kFloat, SHADER_CONSTANT_057_X)
XE_GPU_REGISTER(0x40E5, kFloat, SHADER_CONSTANT_057_Y)
XE_GPU_REGISTER(0x40E6, kFloat, SHADER_CONSTANT_057_Z)
XE_GPU_REGISTER(0x40E7, kFloat, SHADER_CONSTANT_057_W)
XE_GPU_REGISTER(0x40E8, kFloat, SHADER_CONSTANT_058_X)
XE_GPU_REGISTER(0x40E9, kFloat, SHADER_CONSTANT_058_Y)
XE_GPU_REGISTER(0x40EA, kFloat, SHADER_CONSTANT_058_Z)
XE_GPU_REGISTER(0x40EB, kFloat, SHADER_CONSTANT_058_W)
XE_GPU_REGISTER(0x40EC, kFloat, SHADER_CONSTANT_059_X)
XE_GPU_REGISTER(0x40ED, kFloat, SHADER_CONSTANT_059_Y)
XE_GPU_REGISTER(0x40EE, kFloat, SHADER_CONSTANT_059_Z)
XE_GPU_REGISTER(0x40EF, kFloat, SHADER_CONSTANT_059_W)
XE_GPU_REGISTER(0x40F0, kFloat, SHADER_CONSTANT_060_X)
XE_GPU_REGISTER(0x40F1, kFloat, SHADER_CONSTANT_060_Y)
XE_GPU_REGISTER(0x40F2, kFloat, SHADER_CONSTANT_060_Z)
XE_GPU_REGISTER(0x40F3, kFloat, SHADER_CONSTANT_060_W)
XE_GPU_REGISTER(0x40F4, kFloat, SHADER_CONSTANT_061_X)
XE_GPU_REGISTER(0x40F5, kFloat, SHADER_CONSTANT_061_Y)
XE_GPU_REGISTER(0x40F6, kFloat, SHADER_CONSTANT_061_Z)
XE_GPU_REGISTER(0x40F7, kFloat, SHADER_CONSTANT_061_W)
XE_GPU_REGISTER(0x40F8, kFloat, SHADER_CONSTANT_062_X)
XE_GPU_REGISTER(0x40F9, kFloat, SHADER_CONSTANT_062_Y)
XE_GPU_REGISTER(0x40FA, kFloat, SHADER_CONSTANT_062_Z)
XE_GPU_REGISTER(0x40FB, kFloat, SHADER_CONSTANT_062_W)
XE_GPU_REGISTER(0x40FC, kFloat, SHADER_CONSTANT_063_X)
XE_GPU_REGISTER(0x40FD, kFloat, SHADER_CONSTANT_063_Y)
XE_GPU_REGISTER(0x40FE, kFloat, SHADER_CONSTANT_063_Z)
XE_GPU_REGISTER(0x40FF, kFloat, SHADER_CONSTANT_063_W)
XE_GPU_REGISTER(0x4100, kFloat, SHADER_CONSTANT_064_X)
XE_GPU_REGISTER(0x4101, kFloat, SHADER_CONSTANT_064_Y)
XE_GPU_REGISTER(0x4102, kFloat, SHADER_CONSTANT_064_Z)
XE_GPU_REGISTER(0x4103, kFloat, SHADER_CONSTANT_064_W)
XE_GPU_REGISTER(0x4104, kFloat, SHADER_CONSTANT_065_X)
XE_GPU_REGISTER(0x4105, kFloat, SHADER_CONSTANT_065_Y)
XE_GPU_REGISTER(0x4106, kFloat, SHADER_CONSTANT_065_Z)
XE_GPU_REGISTER(0x4107, kFloat, SHADER_CONSTANT_065_W)
XE_GPU_REGISTER(0x4108, kFloat, SHADER_CONSTANT_066_X)
XE_GPU_REGISTER(0x4109, kFloat, SHADER_CONSTANT_066_Y)
XE_GPU_REGISTER(0x410A, kFloat, SHADER_CONSTANT_066_Z)
XE_GPU_REGISTER(0x410B, kFloat, SHADER_CONSTANT_066_W)
XE_GPU_REGISTER(0x410C, kFloat, SHADER_CONSTANT_067_X)
XE_GPU_REGISTER(0x410D, kFloat, SHADER_CONSTANT_067_Y)
XE_GPU_REGISTER(0x410E, kFloat, SHADER_CONSTANT_067_Z)
XE_GPU_REGISTER(0x410F, kFloat, SHADER_CONSTANT_067_W)
XE_GPU_REGISTER(0x4110, kFloat, SHADER_CONSTANT_068_X)
XE_GPU_REGISTER(0x4111, kFloat, SHADER_CONSTANT_068_Y)
XE_GPU_REGISTER(0x4112, kFloat, SHADER_CONSTANT_068_Z)
XE_GPU_REGISTER(0x4113, kFloat, SHADER_CONSTANT_068_W)
XE_GPU_REGISTER(0x4114, kFloat, SHADER_CONSTANT_069_X)
XE_GPU_REGISTER(0x4115, kFloat, SHADER_CONSTANT_069_Y)
XE_GPU_REGISTER(0x4116, kFloat, SHADER_CONSTANT_069_Z)
XE_GPU_REGISTER(0x4117, kFloat, SHADER_CONSTANT_069_W)
XE_GPU_REGISTER(0x4118, kFloat, SHADER_CONSTANT_070_X)
XE_GPU_REGISTER(0x4119, kFloat, SHADER_CONSTANT_070_Y)
XE_GPU_REGISTER(0x411A, kFloat, SHADER_CONSTANT_070_Z)
XE_GPU_REGISTER(0x411B, kFloat, SHADER_CONSTANT_070_W)
XE_GPU_REGISTER(0x411C, kFloat, SHADER_CONSTANT_071_X)
XE_GPU_REGISTER(0x411D, kFloat, SHADER_CONSTANT_071_Y)
XE_GPU_REGISTER(0x411E, kFloat, SHADER_CONSTANT_071_Z)
XE_GPU_REGISTER(0x411F, kFloat, SHADER_CONSTANT_071_W)
XE_GPU_REGISTER(0x4120, kFloat, SHADER_CONSTANT_072_X)
XE_GPU_REGISTER(0x4121, kFloat, SHADER_CONSTANT_072_Y)
XE_GPU_REGISTER(0x4122, kFloat, SHADER_CONSTANT_072_Z)
XE_GPU_REGISTER(0x4123, kFloat, SHADER_CONSTANT_072_W)
XE_GPU_REGISTER(0x4124, kFloat, SHADER_CONSTANT_073_X)
XE_GPU_REGISTER(0x4125, kFloat, SHADER_CONSTANT_073_Y)
XE_GPU_REGISTER(0x4126, kFloat, SHADER_CONSTANT_073_Z)
XE_GPU_REGISTER(0x4127, kFloat, SHADER_CONSTANT_073_W)
XE_GPU_REGISTER(0x4128, kFloat, SHADER_CONSTANT_074_X)
XE_GPU_REGISTER(0x4129, kFloat, SHADER_CONSTANT_074_Y)
XE_GPU_REGISTER(0x412A, kFloat, SHADER_CONSTANT_074_Z)
XE_GPU_REGISTER(0x412B, kFloat, SHADER_CONSTANT_074_W)
XE_GPU_REGISTER(0x412C, kFloat, SHADER_CONSTANT_075_X)
XE_GPU_REGISTER(0x412D, kFloat, SHADER_CONSTANT_075_Y)
XE_GPU_REGISTER(0x412E, kFloat, SHADER_CONSTANT_075_Z)
XE_GPU_REGISTER(0x412F, kFloat, SHADER_CONSTANT_075_W)
XE_GPU_REGISTER(0x4130, kFloat, SHADER_CONSTANT_076_X)
XE_GPU_REGISTER(0x4131, kFloat, SHADER_CONSTANT_076_Y)
XE_GPU_REGISTER(0x4132, kFloat, SHADER_CONSTANT_076_Z)
XE_GPU_REGISTER(0x4133, kFloat, SHADER_CONSTANT_076_W)
XE_GPU_REGISTER(0x4134, kFloat, SHADER_CONSTANT_077_X)
XE_GPU_REGISTER(0x4135, kFloat, SHADER_CONSTANT_077_Y)
XE_GPU_REGISTER(0x4136, kFloat, SHADER_CONSTANT_077_Z)
XE_GPU_REGISTER(0x4137, kFloat, SHADER_CONSTANT_077_W)
XE_GPU_REGISTER(0x4138, kFloat, SHADER_CONSTANT_078_X)
XE_GPU_REGISTER(0x4139, kFloat, SHADER_CONSTANT_078_Y)
XE_GPU_REGISTER(0x413A, kFloat, SHADER_CONSTANT_078_Z)
XE_GPU_REGISTER(0x413B, kFloat, SHADER_CONSTANT_078_W)
XE_GPU_REGISTER(0x413C, kFloat, SHADER_CONSTANT_079_X)
XE_GPU_REGISTER(0x413D, kFloat, SHADER_CONSTANT_079_Y)
XE_GPU_REGISTER(0x413E, kFloat, SHADER_CONSTANT_079_Z)
XE_GPU_REGISTER(0x413F, kFloat, SHADER_CONSTANT_079_W)
XE_GPU_REGISTER(0x4140, kFloat, SHADER_CONSTANT_080_X)
XE_GPU_REGISTER(0x4141, kFloat, SHADER_CONSTANT_080_Y)
XE_GPU_REGISTER(0x4142, kFloat, SHADER_CONSTANT_080_Z)
XE_GPU_REGISTER(0x4143, kFloat, SHADER_CONSTANT_080_W)
XE_GPU_REGISTER(0x4144, kFloat, SHADER_CONSTANT_081_X)
XE_GPU_REGISTER(0x4145, kFloat, SHADER_CONSTANT_081_Y)
XE_GPU_REGISTER(0x4146, kFloat, SHADER_CONSTANT_081_Z)
XE_GPU_REGISTER(0x4147, kFloat, SHADER_CONSTANT_081_W)
XE_GPU_REGISTER(0x4148, kFloat, SHADER_CONSTANT_082_X)
XE_GPU_REGISTER(0x4149, kFloat, SHADER_CONSTANT_082_Y)
XE_GPU_REGISTER(0x414A, kFloat, SHADER_CONSTANT_082_Z)
XE_GPU_REGISTER(0x414B, kFloat, SHADER_CONSTANT_082_W)
XE_GPU_REGISTER(0x414C, kFloat, SHADER_CONSTANT_083_X)
XE_GPU_REGISTER(0x414D, kFloat, SHADER_CONSTANT_083_Y)
XE_GPU_REGISTER(0x414E, kFloat, SHADER_CONSTANT_083_Z)
XE_GPU_REGISTER(0x414F, kFloat, SHADER_CONSTANT_083_W)
XE_GPU_REGISTER(0x4150, kFloat, SHADER_CONSTANT_084_X)
XE_GPU_REGISTER(0x4151, kFloat, SHADER_CONSTANT_084_Y)
XE_GPU_REGISTER(0x4152, kFloat, SHADER_CONSTANT_084_Z)
XE_GPU_REGISTER(0x4153, kFloat, SHADER_CONSTANT_084_W)
XE_GPU_REGISTER(0x4154, kFloat, SHADER_CONSTANT_085_X)
XE_GPU_REGISTER(0x4155, kFloat, SHADER_CONSTANT_085_Y)
XE_GPU_REGISTER(0x4156, kFloat, SHADER_CONSTANT_085_Z)
XE_GPU_REGISTER(0x4157, kFloat, SHADER_CONSTANT_085_W)
XE_GPU_REGISTER(0x4158, kFloat, SHADER_CONSTANT_086_X)
XE_GPU_REGISTER(0x4159, kFloat, SHADER_CONSTANT_086_Y)
XE_GPU_REGISTER(0x415A, kFloat, SHADER_CONSTANT_086_Z)
XE_GPU_REGISTER(0x415B, kFloat, SHADER_CONSTANT_086_W)
XE_GPU_REGISTER(0x415C, kFloat, SHADER_CONSTANT_087_X)
XE_GPU_REGISTER(0x415D, kFloat, SHADER_CONSTANT_087_Y)
XE_GPU_REGISTER(0x415E, kFloat, SHADER_CONSTANT_087_Z)
XE_GPU_REGISTER(0x415F, kFloat, SHADER_CONSTANT_087_W)
XE_GPU_REGISTER(0x4160, kFloat, SHADER_CONSTANT_088_X)
XE_GPU_REGISTER(0x4161, kFloat, SHADER_CONSTANT_088_Y)
XE_GPU_REGISTER(0x4162, kFloat, SHADER_CONSTANT_088_Z)
XE_GPU_REGISTER(0x4163, kFloat, SHADER_CONSTANT_088_W)
XE_GPU_REGISTER(0x4164, kFloat, SHADER_CONSTANT_089_X)
XE_GPU_REGISTER(0x4165, kFloat, SHADER_CONSTANT_089_Y)
XE_GPU_REGISTER(0x4166, kFloat, SHADER_CONSTANT_089_Z)
XE_GPU_REGISTER(0x4167, kFloat, SHADER_CONSTANT_089_W)
XE_GPU_REGISTER(0x4168, kFloat, SHADER_CONSTANT_090_X)
XE_GPU_REGISTER(0x4169, kFloat, SHADER_CONSTANT_090_Y)
XE_GPU_REGISTER(0x416A, kFloat, SHADER_CONSTANT_090_Z)
XE_GPU_REGISTER(0x416B, kFloat, SHADER_CONSTANT_090_W)
XE_GPU_REGISTER(0x416C, kFloat, SHADER_CONSTANT_091_X)
XE_GPU_REGISTER(0x416D, kFloat, SHADER_CONSTANT_091_Y)
XE_GPU_REGISTER(0x416E, kFloat, SHADER_CONSTANT_091_Z)
XE_GPU_REGISTER(0x416F, kFloat, SHADER_CONSTANT_091_W)
XE_GPU_REGISTER(0x4170, kFloat, SHADER_CONSTANT_092_X)
XE_GPU_REGISTER(0x4171, kFloat, SHADER_CONSTANT_092_Y)
XE_GPU_REGISTER(0x4172, kFloat, SHADER_CONSTANT_092_Z)
XE_GPU_REGISTER(0x4173, kFloat, SHADER_CONSTANT_092_W)
XE_GPU_REGISTER(0x4174, kFloat, SHADER_CONSTANT_093_X)
XE_GPU_REGISTER(0x4175, kFloat, SHADER_CONSTANT_093_Y)
XE_GPU_REGISTER(0x4176, kFloat, SHADER_CONSTANT_093_Z)
XE_GPU_REGISTER(0x4177, kFloat, SHADER_CONSTANT_093_W)
XE_GPU_REGISTER(0x4178, kFloat, SHADER_CONSTANT_094_X)
XE_GPU_REGISTER(0x4179, kFloat, SHADER_CONSTANT_094_Y)
XE_GPU_REGISTER(0x417A, kFloat, SHADER_CONSTANT_094_Z)
XE_GPU_REGISTER(0x417B, kFloat, SHADER_CONSTANT_094_W)
XE_GPU_REGISTER(0x417C, kFloat, SHADER_CONSTANT_095_X)
XE_GPU_REGISTER(0x417D, kFloat, SHADER_CONSTANT_095_Y)
XE_GPU_REGISTER(0x417E, kFloat, SHADER_CONSTANT_095_Z)
XE_GPU_REGISTER(0x417F, kFloat, SHADER_CONSTANT_095_W)
XE_GPU_REGISTER(0x4180, kFloat, SHADER_CONSTANT_096_X)
XE_GPU_REGISTER(0x4181, kFloat, SHADER_CONSTANT_096_Y)
XE_GPU_REGISTER(0x4182, kFloat, SHADER_CONSTANT_096_Z)
XE_GPU_REGISTER(0x4183, kFloat, SHADER_CONSTANT_096_W)
XE_GPU_REGISTER(0x4184, kFloat, SHADER_CONSTANT_097_X)
XE_GPU_REGISTER(0x4185, kFloat, SHADER_CONSTANT_097_Y)
XE_GPU_REGISTER(0x4186, kFloat, SHADER_CONSTANT_097_Z)
XE_GPU_REGISTER(0x4187, kFloat, SHADER_CONSTANT_097_W)
XE_GPU_REGISTER(0x4188, kFloat, SHADER_CONSTANT_098_X)
XE_GPU_REGISTER(0x4189, kFloat, SHADER_CONSTANT_098_Y)
XE_GPU_REGISTER(0x418A, kFloat, SHADER_CONSTANT_098_Z)
XE_GPU_REGISTER(0x418B, kFloat, SHADER_CONSTANT_098_W)
XE_GPU_REGISTER(0x418C, kFloat, SHADER_CONSTANT_099_X)
XE_GPU_REGISTER(0x418D, kFloat, SHADER_CONSTANT_099_Y)
XE_GPU_REGISTER(0x418E, kFloat, SHADER_CONSTANT_099_Z)
XE_GPU_REGISTER(0x418F, kFloat, SHADER_CONSTANT_099_W)
XE_GPU_REGISTER(0x4190, kFloat, SHADER_CONSTANT_100_X)
XE_GPU_REGISTER(0x4191, kFloat, SHADER_CONSTANT_100_Y)
XE_GPU_REGISTER(0x4192, kFloat, SHADER_CONSTANT_100_Z)
XE_GPU_REGISTER(0x4193, kFloat, SHADER_CONSTANT_100_W)
XE_GPU_REGISTER(0x4194, kFloat, SHADER_CONSTANT_101_X)
XE_GPU_REGISTER(0x4195, kFloat, SHADER_CONSTANT_101_Y)
XE_GPU_REGISTER(0x4196, kFloat, SHADER_CONSTANT_101_Z)
XE_GPU_REGISTER(0x4197, kFloat, SHADER_CONSTANT_101_W)
XE_GPU_REGISTER(0x4198, kFloat, SHADER_CONSTANT_102_X)
XE_GPU_REGISTER(0x4199, kFloat, SHADER_CONSTANT_102_Y)
XE_GPU_REGISTER(0x419A, kFloat, SHADER_CONSTANT_102_Z)
XE_GPU_REGISTER(0x419B, kFloat, SHADER_CONSTANT_102_W)
XE_GPU_REGISTER(0x419C, kFloat, SHADER_CONSTANT_103_X)
XE_GPU_REGISTER(0x419D, kFloat, SHADER_CONSTANT_103_Y)
XE_GPU_REGISTER(0x419E, kFloat, SHADER_CONSTANT_103_Z)
XE_GPU_REGISTER(0x419F, kFloat, SHADER_CONSTANT_103_W)
XE_GPU_REGISTER(0x41A0, kFloat, SHADER_CONSTANT_104_X)
XE_GPU_REGISTER(0x41A1, kFloat, SHADER_CONSTANT_104_Y)
XE_GPU_REGISTER(0x41A2, kFloat, SHADER_CONSTANT_104_Z)
XE_GPU_REGISTER(0x41A3, kFloat, SHADER_CONSTANT_104_W)
XE_GPU_REGISTER(0x41A4, kFloat, SHADER_CONSTANT_105_X)
XE_GPU_REGISTER(0x41A5, kFloat, SHADER_CONSTANT_105_Y)
XE_GPU_REGISTER(0x41A6, kFloat, SHADER_CONSTANT_105_Z)
XE_GPU_REGISTER(0x41A7, kFloat, SHADER_CONSTANT_105_W)
XE_GPU_REGISTER(0x41A8, kFloat, SHADER_CONSTANT_106_X)
XE_GPU_REGISTER(0x41A9, kFloat, SHADER_CONSTANT_106_Y)
XE_GPU_REGISTER(0x41AA, kFloat, SHADER_CONSTANT_106_Z)
XE_GPU_REGISTER(0x41AB, kFloat, SHADER_CONSTANT_106_W)
XE_GPU_REGISTER(0x41AC, kFloat, SHADER_CONSTANT_107_X)
XE_GPU_REGISTER(0x41AD, kFloat, SHADER_CONSTANT_107_Y)
XE_GPU_REGISTER(0x41AE, kFloat, SHADER_CONSTANT_107_Z)
XE_GPU_REGISTER(0x41AF, kFloat, SHADER_CONSTANT_107_W)
XE_GPU_REGISTER(0x41B0, kFloat, SHADER_CONSTANT_108_X)
XE_GPU_REGISTER(0x41B1, kFloat, SHADER_CONSTANT_108_Y)
XE_GPU_REGISTER(0x41B2, kFloat, SHADER_CONSTANT_108_Z)
XE_GPU_REGISTER(0x41B3, kFloat, SHADER_CONSTANT_108_W)
XE_GPU_REGISTER(0x41B4, kFloat, SHADER_CONSTANT_109_X)
XE_GPU_REGISTER(0x41B5, kFloat, SHADER_CONSTANT_109_Y)
XE_GPU_REGISTER(0x41B6, kFloat, SHADER_CONSTANT_109_Z)
XE_GPU_REGISTER(0x41B7, kFloat, SHADER_CONSTANT_109_W)
XE_GPU_REGISTER(0x41B8, kFloat, SHADER_CONSTANT_110_X)
XE_GPU_REGISTER(0x41B9, kFloat, SHADER_CONSTANT_110_Y)
XE_GPU_REGISTER(0x41BA, kFloat, SHADER_CONSTANT_110_Z)
XE_GPU_REGISTER(0x41BB, kFloat, SHADER_CONSTANT_110_W)
XE_GPU_REGISTER(0x41BC, kFloat, SHADER_CONSTANT_111_X)
XE_GPU_REGISTER(0x41BD, kFloat, SHADER_CONSTANT_111_Y)
XE_GPU_REGISTER(0x41BE, kFloat, SHADER_CONSTANT_111_Z)
XE_GPU_REGISTER(0x41BF, kFloat, SHADER_CONSTANT_111_W)
XE_GPU_REGISTER(0x41C0, kFloat, SHADER_CONSTANT_112_X)
XE_GPU_REGISTER(0x41C1, kFloat, SHADER_CONSTANT_112_Y)
XE_GPU_REGISTER(0x41C2, kFloat, SHADER_CONSTANT_112_Z)
XE_GPU_REGISTER(0x41C3, kFloat, SHADER_CONSTANT_112_W)
XE_GPU_REGISTER(0x41C4, kFloat, SHADER_CONSTANT_113_X)
XE_GPU_REGISTER(0x41C5, kFloat, SHADER_CONSTANT_113_Y)
XE_GPU_REGISTER(0x41C6, kFloat, SHADER_CONSTANT_113_Z)
XE_GPU_REGISTER(0x41C7, kFloat, SHADER_CONSTANT_113_W)
XE_GPU_REGISTER(0x41C8, kFloat, SHADER_CONSTANT_114_X)
XE_GPU_REGISTER(0x41C9, kFloat, SHADER_CONSTANT_114_Y)
XE_GPU_REGISTER(0x41CA, kFloat, SHADER_CONSTANT_114_Z)
XE_GPU_REGISTER(0x41CB, kFloat, SHADER_CONSTANT_114_W)
XE_GPU_REGISTER(0x41CC, kFloat, SHADER_CONSTANT_115_X)
XE_GPU_REGISTER(0x41CD, kFloat, SHADER_CONSTANT_115_Y)
XE_GPU_REGISTER(0x41CE, kFloat, SHADER_CONSTANT_115_Z)
XE_GPU_REGISTER(0x41CF, kFloat, SHADER_CONSTANT_115_W)
XE_GPU_REGISTER(0x41D0, kFloat, SHADER_CONSTANT_116_X)
XE_GPU_REGISTER(0x41D1, kFloat, SHADER_CONSTANT_116_Y)
XE_GPU_REGISTER(0x41D2, kFloat, SHADER_CONSTANT_116_Z)
XE_GPU_REGISTER(0x41D3, kFloat, SHADER_CONSTANT_116_W)
XE_GPU_REGISTER(0x41D4, kFloat, SHADER_CONSTANT_117_X)
XE_GPU_REGISTER(0x41D5, kFloat, SHADER_CONSTANT_117_Y)
XE_GPU_REGISTER(0x41D6, kFloat, SHADER_CONSTANT_117_Z)
XE_GPU_REGISTER(0x41D7, kFloat, SHADER_CONSTANT_117_W)
XE_GPU_REGISTER(0x41D8, kFloat, SHADER_CONSTANT_118_X)
XE_GPU_REGISTER(0x41D9, kFloat, SHADER_CONSTANT_118_Y)
XE_GPU_REGISTER(0x41DA, kFloat, SHADER_CONSTANT_118_Z)
XE_GPU_REGISTER(0x41DB, kFloat, SHADER_CONSTANT_118_W)
XE_GPU_REGISTER(0x41DC, kFloat, SHADER_CONSTANT_119_X)
XE_GPU_REGISTER(0x41DD, kFloat, SHADER_CONSTANT_119_Y)
XE_GPU_REGISTER(0x41DE, kFloat, SHADER_CONSTANT_119_Z)
XE_GPU_REGISTER(0x41DF, kFloat, SHADER_CONSTANT_119_W)
XE_GPU_REGISTER(0x41E0, kFloat, SHADER_CONSTANT_120_X)
XE_GPU_REGISTER(0x41E1, kFloat, SHADER_CONSTANT_120_Y)
XE_GPU_REGISTER(0x41E2, kFloat, SHADER_CONSTANT_120_Z)
XE_GPU_REGISTER(0x41E3, kFloat, SHADER_CONSTANT_120_W)
XE_GPU_REGISTER(0x41E4, kFloat, SHADER_CONSTANT_121_X)
XE_GPU_REGISTER(0x41E5, kFloat, SHADER_CONSTANT_121_Y)
XE_GPU_REGISTER(0x41E6, kFloat, SHADER_CONSTANT_121_Z)
XE_GPU_REGISTER(0x41E7, kFloat, SHADER_CONSTANT_121_W)
XE_GPU_REGISTER(0x41E8, kFloat, SHADER_CONSTANT_122_X)
XE_GPU_REGISTER(0x41E9, kFloat, SHADER_CONSTANT_122_Y)
XE_GPU_REGISTER(0x41EA, kFloat, SHADER_CONSTANT_122_Z)
XE_GPU_REGISTER(0x41EB, kFloat, SHADER_CONSTANT_122_W)
XE_GPU_REGISTER(0x41EC, kFloat, SHADER_CONSTANT_123_X)
XE_GPU_REGISTER(0x41ED, kFloat, SHADER_CONSTANT_123_Y)
XE_GPU_REGISTER(0x41EE, kFloat, SHADER_CONSTANT_123_Z)
XE_GPU_REGISTER(0x41EF, kFloat, SHADER_CONSTANT_123_W)
XE_GPU_REGISTER(0x41F0, kFloat, SHADER_CONSTANT_124_X)
XE_GPU_REGISTER(0x41F1, kFloat, SHADER_CONSTANT_124_Y)
XE_GPU_REGISTER(0x41F2, kFloat, SHADER_CONSTANT_124_Z)
XE_GPU_REGISTER(0x41F3, kFloat, SHADER_CONSTANT_124_W)
XE_GPU_REGISTER(0x41F4, kFloat, SHADER_CONSTANT_125_X)
XE_GPU_REGISTER(0x41F5, kFloat, SHADER_CONSTANT_125_Y)
XE_GPU_REGISTER(0x41F6, kFloat, SHADER_CONSTANT_125_Z)
XE_GPU_REGISTER(0x41F7, kFloat, SHADER_CONSTANT_125_W)
XE_GPU_REGISTER(0x41F8, kFloat, SHADER_CONSTANT_126_X)
XE_GPU_REGISTER(0x41F9, kFloat, SHADER_CONSTANT_126_Y)
XE_GPU_REGISTER(0x41FA, kFloat, SHADER_CONSTANT_126_Z)
XE_GPU_REGISTER(0x41FB, kFloat, SHADER_CONSTANT_126_W)
XE_GPU_REGISTER(0x41FC, kFloat, SHADER_CONSTANT_127_X)
XE_GPU_REGISTER(0x41FD, kFloat, SHADER_CONSTANT_127_Y)
XE_GPU_REGISTER(0x41FE, kFloat, SHADER_CONSTANT_127_Z)
XE_GPU_REGISTER(0x41FF, kFloat, SHADER_CONSTANT_127_W)
XE_GPU_REGISTER(0x4200, kFloat, SHADER_CONSTANT_128_X)
XE_GPU_REGISTER(0x4201, kFloat, SHADER_CONSTANT_128_Y)
XE_GPU_REGISTER(0x4202, kFloat, SHADER_CONSTANT_128_Z)
XE_GPU_REGISTER(0x4203, kFloat, SHADER_CONSTANT_128_W)
XE_GPU_REGISTER(0x4204, kFloat, SHADER_CONSTANT_129_X)
XE_GPU_REGISTER(0x4205, kFloat, SHADER_CONSTANT_129_Y)
XE_GPU_REGISTER(0x4206, kFloat, SHADER_CONSTANT_129_Z)
XE_GPU_REGISTER(0x4207, kFloat, SHADER_CONSTANT_129_W)
XE_GPU_REGISTER(0x4208, kFloat, SHADER_CONSTANT_130_X)
XE_GPU_REGISTER(0x4209, kFloat, SHADER_CONSTANT_130_Y)
XE_GPU_REGISTER(0x420A, kFloat, SHADER_CONSTANT_130_Z)
XE_GPU_REGISTER(0x420B, kFloat, SHADER_CONSTANT_130_W)
XE_GPU_REGISTER(0x420C, kFloat, SHADER_CONSTANT_131_X)
XE_GPU_REGISTER(0x420D, kFloat, SHADER_CONSTANT_131_Y)
XE_GPU_REGISTER(0x420E, kFloat, SHADER_CONSTANT_131_Z)
XE_GPU_REGISTER(0x420F, kFloat, SHADER_CONSTANT_131_W)
XE_GPU_REGISTER(0x4210, kFloat, SHADER_CONSTANT_132_X)
XE_GPU_REGISTER(0x4211, kFloat, SHADER_CONSTANT_132_Y)
XE_GPU_REGISTER(0x4212, kFloat, SHADER_CONSTANT_132_Z)
XE_GPU_REGISTER(0x4213, kFloat, SHADER_CONSTANT_132_W)
XE_GPU_REGISTER(0x4214, kFloat, SHADER_CONSTANT_133_X)
XE_GPU_REGISTER(0x4215, kFloat, SHADER_CONSTANT_133_Y)
XE_GPU_REGISTER(0x4216, kFloat, SHADER_CONSTANT_133_Z)
XE_GPU_REGISTER(0x4217, kFloat, SHADER_CONSTANT_133_W)
XE_GPU_REGISTER(0x4218, kFloat, SHADER_CONSTANT_134_X)
XE_GPU_REGISTER(0x4219, kFloat, SHADER_CONSTANT_134_Y)
XE_GPU_REGISTER(0x421A, kFloat, SHADER_CONSTANT_134_Z)
XE_GPU_REGISTER(0x421B, kFloat, SHADER_CONSTANT_134_W)
XE_GPU_REGISTER(0x421C, kFloat, SHADER_CONSTANT_135_X)
XE_GPU_REGISTER(0x421D, kFloat, SHADER_CONSTANT_135_Y)
XE_GPU_REGISTER(0x421E, kFloat, SHADER_CONSTANT_135_Z)
XE_GPU_REGISTER(0x421F, kFloat, SHADER_CONSTANT_135_W)
XE_GPU_REGISTER(0x4220, kFloat, SHADER_CONSTANT_136_X)
XE_GPU_REGISTER(0x4221, kFloat, SHADER_CONSTANT_136_Y)
XE_GPU_REGISTER(0x4222, kFloat, SHADER_CONSTANT_136_Z)
XE_GPU_REGISTER(0x4223, kFloat, SHADER_CONSTANT_136_W)
XE_GPU_REGISTER(0x4224, kFloat, SHADER_CONSTANT_137_X)
XE_GPU_REGISTER(0x4225, kFloat, SHADER_CONSTANT_137_Y)
XE_GPU_REGISTER(0x4226, kFloat, SHADER_CONSTANT_137_Z)
XE_GPU_REGISTER(0x4227, kFloat, SHADER_CONSTANT_137_W)
XE_GPU_REGISTER(0x4228, kFloat, SHADER_CONSTANT_138_X)
XE_GPU_REGISTER(0x4229, kFloat, SHADER_CONSTANT_138_Y)
XE_GPU_REGISTER(0x422A, kFloat, SHADER_CONSTANT_138_Z)
XE_GPU_REGISTER(0x422B, kFloat, SHADER_CONSTANT_138_W)
XE_GPU_REGISTER(0x422C, kFloat, SHADER_CONSTANT_139_X)
XE_GPU_REGISTER(0x422D, kFloat, SHADER_CONSTANT_139_Y)
XE_GPU_REGISTER(0x422E, kFloat, SHADER_CONSTANT_139_Z)
XE_GPU_REGISTER(0x422F, kFloat, SHADER_CONSTANT_139_W)
XE_GPU_REGISTER(0x4230, kFloat, SHADER_CONSTANT_140_X)
XE_GPU_REGISTER(0x4231, kFloat, SHADER_CONSTANT_140_Y)
XE_GPU_REGISTER(0x4232, kFloat, SHADER_CONSTANT_140_Z)
XE_GPU_REGISTER(0x4233, kFloat, SHADER_CONSTANT_140_W)
XE_GPU_REGISTER(0x4234, kFloat, SHADER_CONSTANT_141_X)
XE_GPU_REGISTER(0x4235, kFloat, SHADER_CONSTANT_141_Y)
XE_GPU_REGISTER(0x4236, kFloat, SHADER_CONSTANT_141_Z)
XE_GPU_REGISTER(0x4237, kFloat, SHADER_CONSTANT_141_W)
XE_GPU_REGISTER(0x4238, kFloat, SHADER_CONSTANT_142_X)
XE_GPU_REGISTER(0x4239, kFloat, SHADER_CONSTANT_142_Y)
XE_GPU_REGISTER(0x423A, kFloat, SHADER_CONSTANT_142_Z)
XE_GPU_REGISTER(0x423B, kFloat, SHADER_CONSTANT_142_W)
XE_GPU_REGISTER(0x423C, kFloat, SHADER_CONSTANT_143_X)
XE_GPU_REGISTER(0x423D, kFloat, SHADER_CONSTANT_143_Y)
XE_GPU_REGISTER(0x423E, kFloat, SHADER_CONSTANT_143_Z)
XE_GPU_REGISTER(0x423F, kFloat, SHADER_CONSTANT_143_W)
XE_GPU_REGISTER(0x4240, kFloat, SHADER_CONSTANT_144_X)
XE_GPU_REGISTER(0x4241, kFloat, SHADER_CONSTANT_144_Y)
XE_GPU_REGISTER(0x4242, kFloat, SHADER_CONSTANT_144_Z)
XE_GPU_REGISTER(0x4243, kFloat, SHADER_CONSTANT_144_W)
XE_GPU_REGISTER(0x4244, kFloat, SHADER_CONSTANT_145_X)
XE_GPU_REGISTER(0x4245, kFloat, SHADER_CONSTANT_145_Y)
XE_GPU_REGISTER(0x4246, kFloat, SHADER_CONSTANT_145_Z)
XE_GPU_REGISTER(0x4247, kFloat, SHADER_CONSTANT_145_W)
XE_GPU_REGISTER(0x4248, kFloat, SHADER_CONSTANT_146_X)
XE_GPU_REGISTER(0x4249, kFloat, SHADER_CONSTANT_146_Y)
XE_GPU_REGISTER(0x424A, kFloat, SHADER_CONSTANT_146_Z)
XE_GPU_REGISTER(0x424B, kFloat, SHADER_CONSTANT_146_W)
XE_GPU_REGISTER(0x424C, kFloat, SHADER_CONSTANT_147_X)
XE_GPU_REGISTER(0x424D, kFloat, SHADER_CONSTANT_147_Y)
XE_GPU_REGISTER(0x424E, kFloat, SHADER_CONSTANT_147_Z)
XE_GPU_REGISTER(0x424F, kFloat, SHADER_CONSTANT_147_W)
XE_GPU_REGISTER(0x4250, kFloat, SHADER_CONSTANT_148_X)
XE_GPU_REGISTER(0x4251, kFloat, SHADER_CONSTANT_148_Y)
XE_GPU_REGISTER(0x4252, kFloat, SHADER_CONSTANT_148_Z)
XE_GPU_REGISTER(0x4253, kFloat, SHADER_CONSTANT_148_W)
XE_GPU_REGISTER(0x4254, kFloat, SHADER_CONSTANT_149_X)
XE_GPU_REGISTER(0x4255, kFloat, SHADER_CONSTANT_149_Y)
XE_GPU_REGISTER(0x4256, kFloat, SHADER_CONSTANT_149_Z)
XE_GPU_REGISTER(0x4257, kFloat, SHADER_CONSTANT_149_W)
XE_GPU_REGISTER(0x4258, kFloat, SHADER_CONSTANT_150_X)
XE_GPU_REGISTER(0x4259, kFloat, SHADER_CONSTANT_150_Y)
XE_GPU_REGISTER(0x425A, kFloat, SHADER_CONSTANT_150_Z)
XE_GPU_REGISTER(0x425B, kFloat, SHADER_CONSTANT_150_W)
XE_GPU_REGISTER(0x425C, kFloat, SHADER_CONSTANT_151_X)
XE_GPU_REGISTER(0x425D, kFloat, SHADER_CONSTANT_151_Y)
XE_GPU_REGISTER(0x425E, kFloat, SHADER_CONSTANT_151_Z)
XE_GPU_REGISTER(0x425F, kFloat, SHADER_CONSTANT_151_W)
XE_GPU_REGISTER(0x4260, kFloat, SHADER_CONSTANT_152_X)
XE_GPU_REGISTER(0x4261, kFloat, SHADER_CONSTANT_152_Y)
XE_GPU_REGISTER(0x4262, kFloat, SHADER_CONSTANT_152_Z)
XE_GPU_REGISTER(0x4263, kFloat, SHADER_CONSTANT_152_W)
XE_GPU_REGISTER(0x4264, kFloat, SHADER_CONSTANT_153_X)
XE_GPU_REGISTER(0x4265, kFloat, SHADER_CONSTANT_153_Y)
XE_GPU_REGISTER(0x4266, kFloat, SHADER_CONSTANT_153_Z)
XE_GPU_REGISTER(0x4267, kFloat, SHADER_CONSTANT_153_W)
XE_GPU_REGISTER(0x4268, kFloat, SHADER_CONSTANT_154_X)
XE_GPU_REGISTER(0x4269, kFloat, SHADER_CONSTANT_154_Y)
XE_GPU_REGISTER(0x426A, kFloat, SHADER_CONSTANT_154_Z)
XE_GPU_REGISTER(0x426B, kFloat, SHADER_CONSTANT_154_W)
XE_GPU_REGISTER(0x426C, kFloat, SHADER_CONSTANT_155_X)
XE_GPU_REGISTER(0x426D, kFloat, SHADER_CONSTANT_155_Y)
XE_GPU_REGISTER(0x426E, kFloat, SHADER_CONSTANT_155_Z)
XE_GPU_REGISTER(0x426F, kFloat, SHADER_CONSTANT_155_W)
XE_GPU_REGISTER(0x4270, kFloat, SHADER_CONSTANT_156_X)
XE_GPU_REGISTER(0x4271, kFloat, SHADER_CONSTANT_156_Y)
XE_GPU_REGISTER(0x4272, kFloat, SHADER_CONSTANT_156_Z)
XE_GPU_REGISTER(0x4273, kFloat, SHADER_CONSTANT_156_W)
XE_GPU_REGISTER(0x4274, kFloat, SHADER_CONSTANT_157_X)
XE_GPU_REGISTER(0x4275, kFloat, SHADER_CONSTANT_157_Y)
XE_GPU_REGISTER(0x4276, kFloat, SHADER_CONSTANT_157_Z)
XE_GPU_REGISTER(0x4277, kFloat, SHADER_CONSTANT_157_W)
XE_GPU_REGISTER(0x4278, kFloat, SHADER_CONSTANT_158_X)
XE_GPU_REGISTER(0x4279, kFloat, SHADER_CONSTANT_158_Y)
XE_GPU_REGISTER(0x427A, kFloat, SHADER_CONSTANT_158_Z)
XE_GPU_REGISTER(0x427B, kFloat, SHADER_CONSTANT_158_W)
XE_GPU_REGISTER(0x427C, kFloat, SHADER_CONSTANT_159_X)
XE_GPU_REGISTER(0x427D, kFloat, SHADER_CONSTANT_159_Y)
XE_GPU_REGISTER(0x427E, kFloat, SHADER_CONSTANT_159_Z)
XE_GPU_REGISTER(0x427F, kFloat, SHADER_CONSTANT_159_W)
XE_GPU_REGISTER(0x4280, kFloat, SHADER_CONSTANT_160_X)
XE_GPU_REGISTER(0x4281, kFloat, SHADER_CONSTANT_160_Y)
XE_GPU_REGISTER(0x4282, kFloat, SHADER_CONSTANT_160_Z)
XE_GPU_REGISTER(0x4283, kFloat, SHADER_CONSTANT_160_W)
XE_GPU_REGISTER(0x4284, kFloat, SHADER_CONSTANT_161_X)
XE_GPU_REGISTER(0x4285, kFloat, SHADER_CONSTANT_161_Y)
XE_GPU_REGISTER(0x4286, kFloat, SHADER_CONSTANT_161_Z)
XE_GPU_REGISTER(0x4287, kFloat, SHADER_CONSTANT_161_W)
XE_GPU_REGISTER(0x4288, kFloat, SHADER_CONSTANT_162_X)
XE_GPU_REGISTER(0x4289, kFloat, SHADER_CONSTANT_162_Y)
XE_GPU_REGISTER(0x428A, kFloat, SHADER_CONSTANT_162_Z)
XE_GPU_REGISTER(0x428B, kFloat, SHADER_CONSTANT_162_W)
XE_GPU_REGISTER(0x428C, kFloat, SHADER_CONSTANT_163_X)
XE_GPU_REGISTER(0x428D, kFloat, SHADER_CONSTANT_163_Y)
XE_GPU_REGISTER(0x428E, kFloat, SHADER_CONSTANT_163_Z)
XE_GPU_REGISTER(0x428F, kFloat, SHADER_CONSTANT_163_W)
XE_GPU_REGISTER(0x4290, kFloat, SHADER_CONSTANT_164_X)
XE_GPU_REGISTER(0x4291, kFloat, SHADER_CONSTANT_164_Y)
XE_GPU_REGISTER(0x4292, kFloat, SHADER_CONSTANT_164_Z)
XE_GPU_REGISTER(0x4293, kFloat, SHADER_CONSTANT_164_W)
XE_GPU_REGISTER(0x4294, kFloat, SHADER_CONSTANT_165_X)
XE_GPU_REGISTER(0x4295, kFloat, SHADER_CONSTANT_165_Y)
XE_GPU_REGISTER(0x4296, kFloat, SHADER_CONSTANT_165_Z)
XE_GPU_REGISTER(0x4297, kFloat, SHADER_CONSTANT_165_W)
XE_GPU_REGISTER(0x4298, kFloat, SHADER_CONSTANT_166_X)
XE_GPU_REGISTER(0x4299, kFloat, SHADER_CONSTANT_166_Y)
XE_GPU_REGISTER(0x429A, kFloat, SHADER_CONSTANT_166_Z)
XE_GPU_REGISTER(0x429B, kFloat, SHADER_CONSTANT_166_W)
XE_GPU_REGISTER(0x429C, kFloat, SHADER_CONSTANT_167_X)
XE_GPU_REGISTER(0x429D, kFloat, SHADER_CONSTANT_167_Y)
XE_GPU_REGISTER(0x429E, kFloat, SHADER_CONSTANT_167_Z)
XE_GPU_REGISTER(0x429F, kFloat, SHADER_CONSTANT_167_W)
XE_GPU_REGISTER(0x42A0, kFloat, SHADER_CONSTANT_168_X)
XE_GPU_REGISTER(0x42A1, kFloat, SHADER_CONSTANT_168_Y)
XE_GPU_REGISTER(0x42A2, kFloat, SHADER_CONSTANT_168_Z)
XE_GPU_REGISTER(0x42A3, kFloat, SHADER_CONSTANT_168_W)
XE_GPU_REGISTER(0x42A4, kFloat, SHADER_CONSTANT_169_X)
XE_GPU_REGISTER(0x42A5, kFloat, SHADER_CONSTANT_169_Y)
XE_GPU_REGISTER(0x42A6, kFloat, SHADER_CONSTANT_169_Z)
XE_GPU_REGISTER(0x42A7, kFloat, SHADER_CONSTANT_169_W)
XE_GPU_REGISTER(0x42A8, kFloat, SHADER_CONSTANT_170_X)
XE_GPU_REGISTER(0x42A9, kFloat, SHADER_CONSTANT_170_Y)
XE_GPU_REGISTER(0x42AA, kFloat, SHADER_CONSTANT_170_Z)
XE_GPU_REGISTER(0x42AB, kFloat, SHADER_CONSTANT_170_W)
XE_GPU_REGISTER(0x42AC, kFloat, SHADER_CONSTANT_171_X)
XE_GPU_REGISTER(0x42AD, kFloat, SHADER_CONSTANT_171_Y)
XE_GPU_REGISTER(0x42AE, kFloat, SHADER_CONSTANT_171_Z)
XE_GPU_REGISTER(0x42AF, kFloat, SHADER_CONSTANT_171_W)
XE_GPU_REGISTER(0x42B0, kFloat, SHADER_CONSTANT_172_X)
XE_GPU_REGISTER(0x42B1, kFloat, SHADER_CONSTANT_172_Y)
XE_GPU_REGISTER(0x42B2, kFloat, SHADER_CONSTANT_172_Z)
XE_GPU_REGISTER(0x42B3, kFloat, SHADER_CONSTANT_172_W)
XE_GPU_REGISTER(0x42B4, kFloat, SHADER_CONSTANT_173_X)
XE_GPU_REGISTER(0x42B5, kFloat, SHADER_CONSTANT_173_Y)
XE_GPU_REGISTER(0x42B6, kFloat, SHADER_CONSTANT_173_Z)
XE_GPU_REGISTER(0x42B7, kFloat, SHADER_CONSTANT_173_W)
XE_GPU_REGISTER(0x42B8, kFloat, SHADER_CONSTANT_174_X)
XE_GPU_REGISTER(0x42B9, kFloat, SHADER_CONSTANT_174_Y)
XE_GPU_REGISTER(0x42BA, kFloat, SHADER_CONSTANT_174_Z)
XE_GPU_REGISTER(0x42BB, kFloat, SHADER_CONSTANT_174_W)
XE_GPU_REGISTER(0x42BC, kFloat, SHADER_CONSTANT_175_X)
XE_GPU_REGISTER(0x42BD, kFloat, SHADER_CONSTANT_175_Y)
XE_GPU_REGISTER(0x42BE, kFloat, SHADER_CONSTANT_175_Z)
XE_GPU_REGISTER(0x42BF, kFloat, SHADER_CONSTANT_175_W)
XE_GPU_REGISTER(0x42C0, kFloat, SHADER_CONSTANT_176_X)
XE_GPU_REGISTER(0x42C1, kFloat, SHADER_CONSTANT_176_Y)
XE_GPU_REGISTER(0x42C2, kFloat, SHADER_CONSTANT_176_Z)
XE_GPU_REGISTER(0x42C3, kFloat, SHADER_CONSTANT_176_W)
XE_GPU_REGISTER(0x42C4, kFloat, SHADER_CONSTANT_177_X)
XE_GPU_REGISTER(0x42C5, kFloat, SHADER_CONSTANT_177_Y)
XE_GPU_REGISTER(0x42C6, kFloat, SHADER_CONSTANT_177_Z)
XE_GPU_REGISTER(0x42C7, kFloat, SHADER_CONSTANT_177_W)
XE_GPU_REGISTER(0x42C8, kFloat, SHADER_CONSTANT_178_X)
XE_GPU_REGISTER(0x42C9, kFloat, SHADER_CONSTANT_178_Y)
XE_GPU_REGISTER(0x42CA, kFloat, SHADER_CONSTANT_178_Z)
XE_GPU_REGISTER(0x42CB, kFloat, SHADER_CONSTANT_178_W)
XE_GPU_REGISTER(0x42CC, kFloat, SHADER_CONSTANT_179_X)
XE_GPU_REGISTER(0x42CD, kFloat, SHADER_CONSTANT_179_Y)
XE_GPU_REGISTER(0x42CE, kFloat, SHADER_CONSTANT_179_Z)
XE_GPU_REGISTER(0x42CF, kFloat, SHADER_CONSTANT_179_W)
XE_GPU_REGISTER(0x42D0, kFloat, SHADER_CONSTANT_180_X)
XE_GPU_REGISTER(0x42D1, kFloat, SHADER_CONSTANT_180_Y)
XE_GPU_REGISTER(0x42D2, kFloat, SHADER_CONSTANT_180_Z)
XE_GPU_REGISTER(0x42D3, kFloat, SHADER_CONSTANT_180_W)
XE_GPU_REGISTER(0x42D4, kFloat, SHADER_CONSTANT_181_X)
XE_GPU_REGISTER(0x42D5, kFloat, SHADER_CONSTANT_181_Y)
XE_GPU_REGISTER(0x42D6, kFloat, SHADER_CONSTANT_181_Z)
XE_GPU_REGISTER(0x42D7, kFloat, SHADER_CONSTANT_181_W)
XE_GPU_REGISTER(0x42D8, kFloat, SHADER_CONSTANT_182_X)
XE_GPU_REGISTER(0x42D9, kFloat, SHADER_CONSTANT_182_Y)
XE_GPU_REGISTER(0x42DA, kFloat, SHADER_CONSTANT_182_Z)
XE_GPU_REGISTER(0x42DB, kFloat, SHADER_CONSTANT_182_W)
XE_GPU_REGISTER(0x42DC, kFloat, SHADER_CONSTANT_183_X)
XE_GPU_REGISTER(0x42DD, kFloat, SHADER_CONSTANT_183_Y)
XE_GPU_REGISTER(0x42DE, kFloat, SHADER_CONSTANT_183_Z)
XE_GPU_REGISTER(0x42DF, kFloat, SHADER_CONSTANT_183_W)
XE_GPU_REGISTER(0x42E0, kFloat, SHADER_CONSTANT_184_X)
XE_GPU_REGISTER(0x42E1, kFloat, SHADER_CONSTANT_184_Y)
XE_GPU_REGISTER(0x42E2, kFloat, SHADER_CONSTANT_184_Z)
XE_GPU_REGISTER(0x42E3, kFloat, SHADER_CONSTANT_184_W)
XE_GPU_REGISTER(0x42E4, kFloat, SHADER_CONSTANT_185_X)
XE_GPU_REGISTER(0x42E5, kFloat, SHADER_CONSTANT_185_Y)
XE_GPU_REGISTER(0x42E6, kFloat, SHADER_CONSTANT_185_Z)
XE_GPU_REGISTER(0x42E7, kFloat, SHADER_CONSTANT_185_W)
XE_GPU_REGISTER(0x42E8, kFloat, SHADER_CONSTANT_186_X)
XE_GPU_REGISTER(0x42E9, kFloat, SHADER_CONSTANT_186_Y)
XE_GPU_REGISTER(0x42EA, kFloat, SHADER_CONSTANT_186_Z)
XE_GPU_REGISTER(0x42EB, kFloat, SHADER_CONSTANT_186_W)
XE_GPU_REGISTER(0x42EC, kFloat, SHADER_CONSTANT_187_X)
XE_GPU_REGISTER(0x42ED, kFloat, SHADER_CONSTANT_187_Y)
XE_GPU_REGISTER(0x42EE, kFloat, SHADER_CONSTANT_187_Z)
XE_GPU_REGISTER(0x42EF, kFloat, SHADER_CONSTANT_187_W)
XE_GPU_REGISTER(0x42F0, kFloat, SHADER_CONSTANT_188_X)
XE_GPU_REGISTER(0x42F1, kFloat, SHADER_CONSTANT_188_Y)
XE_GPU_REGISTER(0x42F2, kFloat, SHADER_CONSTANT_188_Z)
XE_GPU_REGISTER(0x42F3, kFloat, SHADER_CONSTANT_188_W)
XE_GPU_REGISTER(0x42F4, kFloat, SHADER_CONSTANT_189_X)
XE_GPU_REGISTER(0x42F5, kFloat, SHADER_CONSTANT_189_Y)
XE_GPU_REGISTER(0x42F6, kFloat, SHADER_CONSTANT_189_Z)
XE_GPU_REGISTER(0x42F7, kFloat, SHADER_CONSTANT_189_W)
XE_GPU_REGISTER(0x42F8, kFloat, SHADER_CONSTANT_190_X)
XE_GPU_REGISTER(0x42F9, kFloat, SHADER_CONSTANT_190_Y)
XE_GPU_REGISTER(0x42FA, kFloat, SHADER_CONSTANT_190_Z)
XE_GPU_REGISTER(0x42FB, kFloat, SHADER_CONSTANT_190_W)
XE_GPU_REGISTER(0x42FC, kFloat, SHADER_CONSTANT_191_X)
XE_GPU_REGISTER(0x42FD, kFloat, SHADER_CONSTANT_191_Y)
XE_GPU_REGISTER(0x42FE, kFloat, SHADER_CONSTANT_191_Z)
XE_GPU_REGISTER(0x42FF, kFloat, SHADER_CONSTANT_191_W)
XE_GPU_REGISTER(0x4300, kFloat, SHADER_CONSTANT_192_X)
XE_GPU_REGISTER(0x4301, kFloat, SHADER_CONSTANT_192_Y)
XE_GPU_REGISTER(0x4302, kFloat, SHADER_CONSTANT_192_Z)
XE_GPU_REGISTER(0x4303, kFloat, SHADER_CONSTANT_192_W)
XE_GPU_REGISTER(0x4304, kFloat, SHADER_CONSTANT_193_X)
XE_GPU_REGISTER(0x4305, kFloat, SHADER_CONSTANT_193_Y)
XE_GPU_REGISTER(0x4306, kFloat, SHADER_CONSTANT_193_Z)
XE_GPU_REGISTER(0x4307, kFloat, SHADER_CONSTANT_193_W)
XE_GPU_REGISTER(0x4308, kFloat, SHADER_CONSTANT_194_X)
XE_GPU_REGISTER(0x4309, kFloat, SHADER_CONSTANT_194_Y)
XE_GPU_REGISTER(0x430A, kFloat, SHADER_CONSTANT_194_Z)
XE_GPU_REGISTER(0x430B, kFloat, SHADER_CONSTANT_194_W)
XE_GPU_REGISTER(0x430C, kFloat, SHADER_CONSTANT_195_X)
XE_GPU_REGISTER(0x430D, kFloat, SHADER_CONSTANT_195_Y)
XE_GPU_REGISTER(0x430E, kFloat, SHADER_CONSTANT_195_Z)
XE_GPU_REGISTER(0x430F, kFloat, SHADER_CONSTANT_195_W)
XE_GPU_REGISTER(0x4310, kFloat, SHADER_CONSTANT_196_X)
XE_GPU_REGISTER(0x4311, kFloat, SHADER_CONSTANT_196_Y)
XE_GPU_REGISTER(0x4312, kFloat, SHADER_CONSTANT_196_Z)
XE_GPU_REGISTER(0x4313, kFloat, SHADER_CONSTANT_196_W)
XE_GPU_REGISTER(0x4314, kFloat, SHADER_CONSTANT_197_X)
XE_GPU_REGISTER(0x4315, kFloat, SHADER_CONSTANT_197_Y)
XE_GPU_REGISTER(0x4316, kFloat, SHADER_CONSTANT_197_Z)
XE_GPU_REGISTER(0x4317, kFloat, SHADER_CONSTANT_197_W)
XE_GPU_REGISTER(0x4318, kFloat, SHADER_CONSTANT_198_X)
XE_GPU_REGISTER(0x4319, kFloat, SHADER_CONSTANT_198_Y)
XE_GPU_REGISTER(0x431A, kFloat, SHADER_CONSTANT_198_Z)
XE_GPU_REGISTER(0x431B, kFloat, SHADER_CONSTANT_198_W)
XE_GPU_REGISTER(0x431C, kFloat, SHADER_CONSTANT_199_X)
XE_GPU_REGISTER(0x431D, kFloat, SHADER_CONSTANT_199_Y)
XE_GPU_REGISTER(0x431E, kFloat, SHADER_CONSTANT_199_Z)
XE_GPU_REGISTER(0x431F, kFloat, SHADER_CONSTANT_199_W)
XE_GPU_REGISTER(0x4320, kFloat, SHADER_CONSTANT_200_X)
XE_GPU_REGISTER(0x4321, kFloat, SHADER_CONSTANT_200_Y)
XE_GPU_REGISTER(0x4322, kFloat, SHADER_CONSTANT_200_Z)
XE_GPU_REGISTER(0x4323, kFloat, SHADER_CONSTANT_200_W)
XE_GPU_REGISTER(0x4324, kFloat, SHADER_CONSTANT_201_X)
XE_GPU_REGISTER(0x4325, kFloat, SHADER_CONSTANT_201_Y)
XE_GPU_REGISTER(0x4326, kFloat, SHADER_CONSTANT_201_Z)
XE_GPU_REGISTER(0x4327, kFloat, SHADER_CONSTANT_201_W)
XE_GPU_REGISTER(0x4328, kFloat, SHADER_CONSTANT_202_X)
XE_GPU_REGISTER(0x4329, kFloat, SHADER_CONSTANT_202_Y)
XE_GPU_REGISTER(0x432A, kFloat, SHADER_CONSTANT_202_Z)
XE_GPU_REGISTER(0x432B, kFloat, SHADER_CONSTANT_202_W)
XE_GPU_REGISTER(0x432C, kFloat, SHADER_CONSTANT_203_X)
XE_GPU_REGISTER(0x432D, kFloat, SHADER_CONSTANT_203_Y)
XE_GPU_REGISTER(0x432E, kFloat, SHADER_CONSTANT_203_Z)
XE_GPU_REGISTER(0x432F, kFloat, SHADER_CONSTANT_203_W)
XE_GPU_REGISTER(0x4330, kFloat, SHADER_CONSTANT_204_X)
XE_GPU_REGISTER(0x4331, kFloat, SHADER_CONSTANT_204_Y)
XE_GPU_REGISTER(0x4332, kFloat, SHADER_CONSTANT_204_Z)
XE_GPU_REGISTER(0x4333, kFloat, SHADER_CONSTANT_204_W)
XE_GPU_REGISTER(0x4334, kFloat, SHADER_CONSTANT_205_X)
XE_GPU_REGISTER(0x4335, kFloat, SHADER_CONSTANT_205_Y)
XE_GPU_REGISTER(0x4336, kFloat, SHADER_CONSTANT_205_Z)
XE_GPU_REGISTER(0x4337, kFloat, SHADER_CONSTANT_205_W)
XE_GPU_REGISTER(0x4338, kFloat, SHADER_CONSTANT_206_X)
XE_GPU_REGISTER(0x4339, kFloat, SHADER_CONSTANT_206_Y)
XE_GPU_REGISTER(0x433A, kFloat, SHADER_CONSTANT_206_Z)
XE_GPU_REGISTER(0x433B, kFloat, SHADER_CONSTANT_206_W)
XE_GPU_REGISTER(0x433C, kFloat, SHADER_CONSTANT_207_X)
XE_GPU_REGISTER(0x433D, kFloat, SHADER_CONSTANT_207_Y)
XE_GPU_REGISTER(0x433E, kFloat, SHADER_CONSTANT_207_Z)
XE_GPU_REGISTER(0x433F, kFloat, SHADER_CONSTANT_207_W)
XE_GPU_REGISTER(0x4340, kFloat, SHADER_CONSTANT_208_X)
XE_GPU_REGISTER(0x4341, kFloat, SHADER_CONSTANT_208_Y)
XE_GPU_REGISTER(0x4342, kFloat, SHADER_CONSTANT_208_Z)
XE_GPU_REGISTER(0x4343, kFloat, SHADER_CONSTANT_208_W)
XE_GPU_REGISTER(0x4344, kFloat, SHADER_CONSTANT_209_X)
XE_GPU_REGISTER(0x4345, kFloat, SHADER_CONSTANT_209_Y)
XE_GPU_REGISTER(0x4346, kFloat, SHADER_CONSTANT_209_Z)
XE_GPU_REGISTER(0x4347, kFloat, SHADER_CONSTANT_209_W)
XE_GPU_REGISTER(0x4348, kFloat, SHADER_CONSTANT_210_X)
XE_GPU_REGISTER(0x4349, kFloat, SHADER_CONSTANT_210_Y)
XE_GPU_REGISTER(0x434A, kFloat, SHADER_CONSTANT_210_Z)
XE_GPU_REGISTER(0x434B, kFloat, SHADER_CONSTANT_210_W)
XE_GPU_REGISTER(0x434C, kFloat, SHADER_CONSTANT_211_X)
XE_GPU_REGISTER(0x434D, kFloat, SHADER_CONSTANT_211_Y)
XE_GPU_REGISTER(0x434E, kFloat, SHADER_CONSTANT_211_Z)
XE_GPU_REGISTER(0x434F, kFloat, SHADER_CONSTANT_211_W)
XE_GPU_REGISTER(0x4350, kFloat, SHADER_CONSTANT_212_X)
XE_GPU_REGISTER(0x4351, kFloat, SHADER_CONSTANT_212_Y)
XE_GPU_REGISTER(0x4352, kFloat, SHADER_CONSTANT_212_Z)
XE_GPU_REGISTER(0x4353, kFloat, SHADER_CONSTANT_212_W)
XE_GPU_REGISTER(0x4354, kFloat, SHADER_CONSTANT_213_X)
XE_GPU_REGISTER(0x4355, kFloat, SHADER_CONSTANT_213_Y)
XE_GPU_REGISTER(0x4356, kFloat, SHADER_CONSTANT_213_Z)
XE_GPU_REGISTER(0x4357, kFloat, SHADER_CONSTANT_213_W)
XE_GPU_REGISTER(0x4358, kFloat, SHADER_CONSTANT_214_X)
XE_GPU_REGISTER(0x4359, kFloat, SHADER_CONSTANT_214_Y)
XE_GPU_REGISTER(0x435A, kFloat, SHADER_CONSTANT_214_Z)
XE_GPU_REGISTER(0x435B, kFloat, SHADER_CONSTANT_214_W)
XE_GPU_REGISTER(0x435C, kFloat, SHADER_CONSTANT_215_X)
XE_GPU_REGISTER(0x435D, kFloat, SHADER_CONSTANT_215_Y)
XE_GPU_REGISTER(0x435E, kFloat, SHADER_CONSTANT_215_Z)
XE_GPU_REGISTER(0x435F, kFloat, SHADER_CONSTANT_215_W)
XE_GPU_REGISTER(0x4360, kFloat, SHADER_CONSTANT_216_X)
XE_GPU_REGISTER(0x4361, kFloat, SHADER_CONSTANT_216_Y)
XE_GPU_REGISTER(0x4362, kFloat, SHADER_CONSTANT_216_Z)
XE_GPU_REGISTER(0x4363, kFloat, SHADER_CONSTANT_216_W)
XE_GPU_REGISTER(0x4364, kFloat, SHADER_CONSTANT_217_X)
XE_GPU_REGISTER(0x4365, kFloat, SHADER_CONSTANT_217_Y)
XE_GPU_REGISTER(0x4366, kFloat, SHADER_CONSTANT_217_Z)
XE_GPU_REGISTER(0x4367, kFloat, SHADER_CONSTANT_217_W)
XE_GPU_REGISTER(0x4368, kFloat, SHADER_CONSTANT_218_X)
XE_GPU_REGISTER(0x4369, kFloat, SHADER_CONSTANT_218_Y)
XE_GPU_REGISTER(0x436A, kFloat, SHADER_CONSTANT_218_Z)
XE_GPU_REGISTER(0x436B, kFloat, SHADER_CONSTANT_218_W)
XE_GPU_REGISTER(0x436C, kFloat, SHADER_CONSTANT_219_X)
XE_GPU_REGISTER(0x436D, kFloat, SHADER_CONSTANT_219_Y)
XE_GPU_REGISTER(0x436E, kFloat, SHADER_CONSTANT_219_Z)
XE_GPU_REGISTER(0x436F, kFloat, SHADER_CONSTANT_219_W)
XE_GPU_REGISTER(0x4370, kFloat, SHADER_CONSTANT_220_X)
XE_GPU_REGISTER(0x4371, kFloat, SHADER_CONSTANT_220_Y)
XE_GPU_REGISTER(0x4372, kFloat, SHADER_CONSTANT_220_Z)
XE_GPU_REGISTER(0x4373, kFloat, SHADER_CONSTANT_220_W)
XE_GPU_REGISTER(0x4374, kFloat, SHADER_CONSTANT_221_X)
XE_GPU_REGISTER(0x4375, kFloat, SHADER_CONSTANT_221_Y)
XE_GPU_REGISTER(0x4376, kFloat, SHADER_CONSTANT_221_Z)
XE_GPU_REGISTER(0x4377, kFloat, SHADER_CONSTANT_221_W)
XE_GPU_REGISTER(0x4378, kFloat, SHADER_CONSTANT_222_X)
XE_GPU_REGISTER(0x4379, kFloat, SHADER_CONSTANT_222_Y)
XE_GPU_REGISTER(0x437A, kFloat, SHADER_CONSTANT_222_Z)
XE_GPU_REGISTER(0x437B, kFloat, SHADER_CONSTANT_222_W)
XE_GPU_REGISTER(0x437C, kFloat, SHADER_CONSTANT_223_X)
XE_GPU_REGISTER(0x437D, kFloat, SHADER_CONSTANT_223_Y)
XE_GPU_REGISTER(0x437E, kFloat, SHADER_CONSTANT_223_Z)
XE_GPU_REGISTER(0x437F, kFloat, SHADER_CONSTANT_223_W)
XE_GPU_REGISTER(0x4380, kFloat, SHADER_CONSTANT_224_X)
XE_GPU_REGISTER(0x4381, kFloat, SHADER_CONSTANT_224_Y)
XE_GPU_REGISTER(0x4382, kFloat, SHADER_CONSTANT_224_Z)
XE_GPU_REGISTER(0x4383, kFloat, SHADER_CONSTANT_224_W)
XE_GPU_REGISTER(0x4384, kFloat, SHADER_CONSTANT_225_X)
XE_GPU_REGISTER(0x4385, kFloat, SHADER_CONSTANT_225_Y)
XE_GPU_REGISTER(0x4386, kFloat, SHADER_CONSTANT_225_Z)
XE_GPU_REGISTER(0x4387, kFloat, SHADER_CONSTANT_225_W)
XE_GPU_REGISTER(0x4388, kFloat, SHADER_CONSTANT_226_X)
XE_GPU_REGISTER(0x4389, kFloat, SHADER_CONSTANT_226_Y)
XE_GPU_REGISTER(0x438A, kFloat, SHADER_CONSTANT_226_Z)
XE_GPU_REGISTER(0x438B, kFloat, SHADER_CONSTANT_226_W)
XE_GPU_REGISTER(0x438C, kFloat, SHADER_CONSTANT_227_X)
XE_GPU_REGISTER(0x438D, kFloat, SHADER_CONSTANT_227_Y)
XE_GPU_REGISTER(0x438E, kFloat, SHADER_CONSTANT_227_Z)
XE_GPU_REGISTER(0x438F, kFloat, SHADER_CONSTANT_227_W)
XE_GPU_REGISTER(0x4390, kFloat, SHADER_CONSTANT_228_X)
XE_GPU_REGISTER(0x4391, kFloat, SHADER_CONSTANT_228_Y)
XE_GPU_REGISTER(0x4392, kFloat, SHADER_CONSTANT_228_Z)
XE_GPU_REGISTER(0x4393, kFloat, SHADER_CONSTANT_228_W)
XE_GPU_REGISTER(0x4394, kFloat, SHADER_CONSTANT_229_X)
XE_GPU_REGISTER(0x4395, kFloat, SHADER_CONSTANT_229_Y)
XE_GPU_REGISTER(0x4396, kFloat, SHADER_CONSTANT_229_Z)
XE_GPU_REGISTER(0x4397, kFloat, SHADER_CONSTANT_229_W)
XE_GPU_REGISTER(0x4398, kFloat, SHADER_CONSTANT_230_X)
XE_GPU_REGISTER(0x4399, kFloat, SHADER_CONSTANT_230_Y)
XE_GPU_REGISTER(0x439A, kFloat, SHADER_CONSTANT_230_Z)
XE_GPU_REGISTER(0x439B, kFloat, SHADER_CONSTANT_230_W)
XE_GPU_REGISTER(0x439C, kFloat, SHADER_CONSTANT_231_X)
XE_GPU_REGISTER(0x439D, kFloat, SHADER_CONSTANT_231_Y)
XE_GPU_REGISTER(0x439E, kFloat, SHADER_CONSTANT_231_Z)
XE_GPU_REGISTER(0x439F, kFloat, SHADER_CONSTANT_231_W)
XE_GPU_REGISTER(0x43A0, kFloat, SHADER_CONSTANT_232_X)
XE_GPU_REGISTER(0x43A1, kFloat, SHADER_CONSTANT_232_Y)
XE_GPU_REGISTER(0x43A2, kFloat, SHADER_CONSTANT_232_Z)
XE_GPU_REGISTER(0x43A3, kFloat, SHADER_CONSTANT_232_W)
XE_GPU_REGISTER(0x43A4, kFloat, SHADER_CONSTANT_233_X)
XE_GPU_REGISTER(0x43A5, kFloat, SHADER_CONSTANT_233_Y)
XE_GPU_REGISTER(0x43A6, kFloat, SHADER_CONSTANT_233_Z)
XE_GPU_REGISTER(0x43A7, kFloat, SHADER_CONSTANT_233_W)
XE_GPU_REGISTER(0x43A8, kFloat, SHADER_CONSTANT_234_X)
XE_GPU_REGISTER(0x43A9, kFloat, SHADER_CONSTANT_234_Y)
XE_GPU_REGISTER(0x43AA, kFloat, SHADER_CONSTANT_234_Z)
XE_GPU_REGISTER(0x43AB, kFloat, SHADER_CONSTANT_234_W)
XE_GPU_REGISTER(0x43AC, kFloat, SHADER_CONSTANT_235_X)
XE_GPU_REGISTER(0x43AD, kFloat, SHADER_CONSTANT_235_Y)
XE_GPU_REGISTER(0x43AE, kFloat, SHADER_CONSTANT_235_Z)
XE_GPU_REGISTER(0x43AF, kFloat, SHADER_CONSTANT_235_W)
XE_GPU_REGISTER(0x43B0, kFloat, SHADER_CONSTANT_236_X)
XE_GPU_REGISTER(0x43B1, kFloat, SHADER_CONSTANT_236_Y)
XE_GPU_REGISTER(0x43B2, kFloat, SHADER_CONSTANT_236_Z)
XE_GPU_REGISTER(0x43B3, kFloat, SHADER_CONSTANT_236_W)
XE_GPU_REGISTER(0x43B4, kFloat, SHADER_CONSTANT_237_X)
XE_GPU_REGISTER(0x43B5, kFloat, SHADER_CONSTANT_237_Y)
XE_GPU_REGISTER(0x43B6, kFloat, SHADER_CONSTANT_237_Z)
XE_GPU_REGISTER(0x43B7, kFloat, SHADER_CONSTANT_237_W)
XE_GPU_REGISTER(0x43B8, kFloat, SHADER_CONSTANT_238_X)
XE_GPU_REGISTER(0x43B9, kFloat, SHADER_CONSTANT_238_Y)
XE_GPU_REGISTER(0x43BA, kFloat, SHADER_CONSTANT_238_Z)
XE_GPU_REGISTER(0x43BB, kFloat, SHADER_CONSTANT_238_W)
XE_GPU_REGISTER(0x43BC, kFloat, SHADER_CONSTANT_239_X)
XE_GPU_REGISTER(0x43BD, kFloat, SHADER_CONSTANT_239_Y)
XE_GPU_REGISTER(0x43BE, kFloat, SHADER_CONSTANT_239_Z)
XE_GPU_REGISTER(0x43BF, kFloat, SHADER_CONSTANT_239_W)
XE_GPU_REGISTER(0x43C0, kFloat, SHADER_CONSTANT_240_X)
XE_GPU_REGISTER(0x43C1, kFloat, SHADER_CONSTANT_240_Y)
XE_GPU_REGISTER(0x43C2, kFloat, SHADER_CONSTANT_240_Z)
XE_GPU_REGISTER(0x43C3, kFloat, SHADER_CONSTANT_240_W)
XE_GPU_REGISTER(0x43C4, kFloat, SHADER_CONSTANT_241_X)
XE_GPU_REGISTER(0x43C5, kFloat, SHADER_CONSTANT_241_Y)
XE_GPU_REGISTER(0x43C6, kFloat, SHADER_CONSTANT_241_Z)
XE_GPU_REGISTER(0x43C7, kFloat, SHADER_CONSTANT_241_W)
XE_GPU_REGISTER(0x43C8, kFloat, SHADER_CONSTANT_242_X)
XE_GPU_REGISTER(0x43C9, kFloat, SHADER_CONSTANT_242_Y)
XE_GPU_REGISTER(0x43CA, kFloat, SHADER_CONSTANT_242_Z)
XE_GPU_REGISTER(0x43CB, kFloat, SHADER_CONSTANT_242_W)
XE_GPU_REGISTER(0x43CC, kFloat, SHADER_CONSTANT_243_X)
XE_GPU_REGISTER(0x43CD, kFloat, SHADER_CONSTANT_243_Y)
XE_GPU_REGISTER(0x43CE, kFloat, SHADER_CONSTANT_243_Z)
XE_GPU_REGISTER(0x43CF, kFloat, SHADER_CONSTANT_243_W)
XE_GPU_REGISTER(0x43D0, kFloat, SHADER_CONSTANT_244_X)
XE_GPU_REGISTER(0x43D1, kFloat, SHADER_CONSTANT_244_Y)
XE_GPU_REGISTER(0x43D2, kFloat, SHADER_CONSTANT_244_Z)
XE_GPU_REGISTER(0x43D3, kFloat, SHADER_CONSTANT_244_W)
XE_GPU_REGISTER(0x43D4, kFloat, SHADER_CONSTANT_245_X)
XE_GPU_REGISTER(0x43D5, kFloat, SHADER_CONSTANT_245_Y)
XE_GPU_REGISTER(0x43D6, kFloat, SHADER_CONSTANT_245_Z)
XE_GPU_REGISTER(0x43D7, kFloat, SHADER_CONSTANT_245_W)
XE_GPU_REGISTER(0x43D8, kFloat, SHADER_CONSTANT_246_X)
XE_GPU_REGISTER(0x43D9, kFloat, SHADER_CONSTANT_246_Y)
XE_GPU_REGISTER(0x43DA, kFloat, SHADER_CONSTANT_246_Z)
XE_GPU_REGISTER(0x43DB, kFloat, SHADER_CONSTANT_246_W)
XE_GPU_REGISTER(0x43DC, kFloat, SHADER_CONSTANT_247_X)
XE_GPU_REGISTER(0x43DD, kFloat, SHADER_CONSTANT_247_Y)
XE_GPU_REGISTER(0x43DE, kFloat, SHADER_CONSTANT_247_Z)
XE_GPU_REGISTER(0x43DF, kFloat, SHADER_CONSTANT_247_W)
XE_GPU_REGISTER(0x43E0, kFloat, SHADER_CONSTANT_248_X)
XE_GPU_REGISTER(0x43E1, kFloat, SHADER_CONSTANT_248_Y)
XE_GPU_REGISTER(0x43E2, kFloat, SHADER_CONSTANT_248_Z)
XE_GPU_REGISTER(0x43E3, kFloat, SHADER_CONSTANT_248_W)
XE_GPU_REGISTER(0x43E4, kFloat, SHADER_CONSTANT_249_X)
XE_GPU_REGISTER(0x43E5, kFloat, SHADER_CONSTANT_249_Y)
XE_GPU_REGISTER(0x43E6, kFloat, SHADER_CONSTANT_249_Z)
XE_GPU_REGISTER(0x43E7, kFloat, SHADER_CONSTANT_249_W)
XE_GPU_REGISTER(0x43E8, kFloat, SHADER_CONSTANT_250_X)
XE_GPU_REGISTER(0x43E9, kFloat, SHADER_CONSTANT_250_Y)
XE_GPU_REGISTER(0x43EA, kFloat, SHADER_CONSTANT_250_Z)
XE_GPU_REGISTER(0x43EB, kFloat, SHADER_CONSTANT_250_W)
XE_GPU_REGISTER(0x43EC, kFloat, SHADER_CONSTANT_251_X)
XE_GPU_REGISTER(0x43ED, kFloat, SHADER_CONSTANT_251_Y)
XE_GPU_REGISTER(0x43EE, kFloat, SHADER_CONSTANT_251_Z)
XE_GPU_REGISTER(0x43EF, kFloat, SHADER_CONSTANT_251_W)
XE_GPU_REGISTER(0x43F0, kFloat, SHADER_CONSTANT_252_X)
XE_GPU_REGISTER(0x43F1, kFloat, SHADER_CONSTANT_252_Y)
XE_GPU_REGISTER(0x43F2, kFloat, SHADER_CONSTANT_252_Z)
XE_GPU_REGISTER(0x43F3, kFloat, SHADER_CONSTANT_252_W)
XE_GPU_REGISTER(0x43F4, kFloat, SHADER_CONSTANT_253_X)
XE_GPU_REGISTER(0x43F5, kFloat, SHADER_CONSTANT_253_Y)
XE_GPU_REGISTER(0x43F6, kFloat, SHADER_CONSTANT_253_Z)
XE_GPU_REGISTER(0x43F7, kFloat, SHADER_CONSTANT_253_W)
XE_GPU_REGISTER(0x43F8, kFloat, SHADER_CONSTANT_254_X)
XE_GPU_REGISTER(0x43F9, kFloat, SHADER_CONSTANT_254_Y)
XE_GPU_REGISTER(0x43FA, kFloat, SHADER_CONSTANT_254_Z)
XE_GPU_REGISTER(0x43FB, kFloat, SHADER_CONSTANT_254_W)
XE_GPU_REGISTER(0x43FC, kFloat, SHADER_CONSTANT_255_X)
XE_GPU_REGISTER(0x43FD, kFloat, SHADER_CONSTANT_255_Y)
XE_GPU_REGISTER(0x43FE, kFloat, SHADER_CONSTANT_255_Z)
XE_GPU_REGISTER(0x43FF, kFloat, SHADER_CONSTANT_255_W)
XE_GPU_REGISTER(0x4400, kFloat, SHADER_CONSTANT_256_X)
XE_GPU_REGISTER(0x4401, kFloat, SHADER_CONSTANT_256_Y)
XE_GPU_REGISTER(0x4402, kFloat, SHADER_CONSTANT_256_Z)
XE_GPU_REGISTER(0x4403, kFloat, SHADER_CONSTANT_256_W)
XE_GPU_REGISTER(0x4404, kFloat, SHADER_CONSTANT_257_X)
XE_GPU_REGISTER(0x4405, kFloat, SHADER_CONSTANT_257_Y)
XE_GPU_REGISTER(0x4406, kFloat, SHADER_CONSTANT_257_Z)
XE_GPU_REGISTER(0x4407, kFloat, SHADER_CONSTANT_257_W)
XE_GPU_REGISTER(0x4408, kFloat, SHADER_CONSTANT_258_X)
XE_GPU_REGISTER(0x4409, kFloat, SHADER_CONSTANT_258_Y)
XE_GPU_REGISTER(0x440A, kFloat, SHADER_CONSTANT_258_Z)
XE_GPU_REGISTER(0x440B, kFloat, SHADER_CONSTANT_258_W)
XE_GPU_REGISTER(0x440C, kFloat, SHADER_CONSTANT_259_X)
XE_GPU_REGISTER(0x440D, kFloat, SHADER_CONSTANT_259_Y)
XE_GPU_REGISTER(0x440E, kFloat, SHADER_CONSTANT_259_Z)
XE_GPU_REGISTER(0x440F, kFloat, SHADER_CONSTANT_259_W)
XE_GPU_REGISTER(0x4410, kFloat, SHADER_CONSTANT_260_X)
XE_GPU_REGISTER(0x4411, kFloat, SHADER_CONSTANT_260_Y)
XE_GPU_REGISTER(0x4412, kFloat, SHADER_CONSTANT_260_Z)
XE_GPU_REGISTER(0x4413, kFloat, SHADER_CONSTANT_260_W)
XE_GPU_REGISTER(0x4414, kFloat, SHADER_CONSTANT_261_X)
XE_GPU_REGISTER(0x4415, kFloat, SHADER_CONSTANT_261_Y)
XE_GPU_REGISTER(0x4416, kFloat, SHADER_CONSTANT_261_Z)
XE_GPU_REGISTER(0x4417, kFloat, SHADER_CONSTANT_261_W)
XE_GPU_REGISTER(0x4418, kFloat, SHADER_CONSTANT_262_X)
XE_GPU_REGISTER(0x4419, kFloat, SHADER_CONSTANT_262_Y)
XE_GPU_REGISTER(0x441A, kFloat, SHADER_CONSTANT_262_Z)
XE_GPU_REGISTER(0x441B, kFloat, SHADER_CONSTANT_262_W)
XE_GPU_REGISTER(0x441C, kFloat, SHADER_CONSTANT_263_X)
XE_GPU_REGISTER(0x441D, kFloat, SHADER_CONSTANT_263_Y)
XE_GPU_REGISTER(0x441E, kFloat, SHADER_CONSTANT_263_Z)
XE_GPU_REGISTER(0x441F, kFloat, SHADER_CONSTANT_263_W)
XE_GPU_REGISTER(0x4420, kFloat, SHADER_CONSTANT_264_X)
XE_GPU_REGISTER(0x4421, kFloat, SHADER_CONSTANT_264_Y)
XE_GPU_REGISTER(0x4422, kFloat, SHADER_CONSTANT_264_Z)
XE_GPU_REGISTER(0x4423, kFloat, SHADER_CONSTANT_264_W)
XE_GPU_REGISTER(0x4424, kFloat, SHADER_CONSTANT_265_X)
XE_GPU_REGISTER(0x4425, kFloat, SHADER_CONSTANT_265_Y)
XE_GPU_REGISTER(0x4426, kFloat, SHADER_CONSTANT_265_Z)
XE_GPU_REGISTER(0x4427, kFloat, SHADER_CONSTANT_265_W)
XE_GPU_REGISTER(0x4428, kFloat, SHADER_CONSTANT_266_X)
XE_GPU_REGISTER(0x4429, kFloat, SHADER_CONSTANT_266_Y)
XE_GPU_REGISTER(0x442A, kFloat, SHADER_CONSTANT_266_Z)
XE_GPU_REGISTER(0x442B, kFloat, SHADER_CONSTANT_266_W)
XE_GPU_REGISTER(0x442C, kFloat, SHADER_CONSTANT_267_X)
XE_GPU_REGISTER(0x442D, kFloat, SHADER_CONSTANT_267_Y)
XE_GPU_REGISTER(0x442E, kFloat, SHADER_CONSTANT_267_Z)
XE_GPU_REGISTER(0x442F, kFloat, SHADER_CONSTANT_267_W)
XE_GPU_REGISTER(0x4430, kFloat, SHADER_CONSTANT_268_X)
XE_GPU_REGISTER(0x4431, kFloat, SHADER_CONSTANT_268_Y)
XE_GPU_REGISTER(0x4432, kFloat, SHADER_CONSTANT_268_Z)
XE_GPU_REGISTER(0x4433, kFloat, SHADER_CONSTANT_268_W)
XE_GPU_REGISTER(0x4434, kFloat, SHADER_CONSTANT_269_X)
XE_GPU_REGISTER(0x4435, kFloat, SHADER_CONSTANT_269_Y)
XE_GPU_REGISTER(0x4436, kFloat, SHADER_CONSTANT_269_Z)
XE_GPU_REGISTER(0x4437, kFloat, SHADER_CONSTANT_269_W)
XE_GPU_REGISTER(0x4438, kFloat, SHADER_CONSTANT_270_X)
XE_GPU_REGISTER(0x4439, kFloat, SHADER_CONSTANT_270_Y)
XE_GPU_REGISTER(0x443A, kFloat, SHADER_CONSTANT_270_Z)
XE_GPU_REGISTER(0x443B, kFloat, SHADER_CONSTANT_270_W)
XE_GPU_REGISTER(0x443C, kFloat, SHADER_CONSTANT_271_X)
XE_GPU_REGISTER(0x443D, kFloat, SHADER_CONSTANT_271_Y)
XE_GPU_REGISTER(0x443E, kFloat, SHADER_CONSTANT_271_Z)
XE_GPU_REGISTER(0x443F, kFloat, SHADER_CONSTANT_271_W)
XE_GPU_REGISTER(0x4440, kFloat, SHADER_CONSTANT_272_X)
XE_GPU_REGISTER(0x4441, kFloat, SHADER_CONSTANT_272_Y)
XE_GPU_REGISTER(0x4442, kFloat, SHADER_CONSTANT_272_Z)
XE_GPU_REGISTER(0x4443, kFloat, SHADER_CONSTANT_272_W)
XE_GPU_REGISTER(0x4444, kFloat, SHADER_CONSTANT_273_X)
XE_GPU_REGISTER(0x4445, kFloat, SHADER_CONSTANT_273_Y)
XE_GPU_REGISTER(0x4446, kFloat, SHADER_CONSTANT_273_Z)
XE_GPU_REGISTER(0x4447, kFloat, SHADER_CONSTANT_273_W)
XE_GPU_REGISTER(0x4448, kFloat, SHADER_CONSTANT_274_X)
XE_GPU_REGISTER(0x4449, kFloat, SHADER_CONSTANT_274_Y)
XE_GPU_REGISTER(0x444A, kFloat, SHADER_CONSTANT_274_Z)
XE_GPU_REGISTER(0x444B, kFloat, SHADER_CONSTANT_274_W)
XE_GPU_REGISTER(0x444C, kFloat, SHADER_CONSTANT_275_X)
XE_GPU_REGISTER(0x444D, kFloat, SHADER_CONSTANT_275_Y)
XE_GPU_REGISTER(0x444E, kFloat, SHADER_CONSTANT_275_Z)
XE_GPU_REGISTER(0x444F, kFloat, SHADER_CONSTANT_275_W)
XE_GPU_REGISTER(0x4450, kFloat, SHADER_CONSTANT_276_X)
XE_GPU_REGISTER(0x4451, kFloat, SHADER_CONSTANT_276_Y)
XE_GPU_REGISTER(0x4452, kFloat, SHADER_CONSTANT_276_Z)
XE_GPU_REGISTER(0x4453, kFloat, SHADER_CONSTANT_276_W)
XE_GPU_REGISTER(0x4454, kFloat, SHADER_CONSTANT_277_X)
XE_GPU_REGISTER(0x4455, kFloat, SHADER_CONSTANT_277_Y)
XE_GPU_REGISTER(0x4456, kFloat, SHADER_CONSTANT_277_Z)
XE_GPU_REGISTER(0x4457, kFloat, SHADER_CONSTANT_277_W)
XE_GPU_REGISTER(0x4458, kFloat, SHADER_CONSTANT_278_X)
XE_GPU_REGISTER(0x4459, kFloat, SHADER_CONSTANT_278_Y)
XE_GPU_REGISTER(0x445A, kFloat, SHADER_CONSTANT_278_Z)
XE_GPU_REGISTER(0x445B, kFloat, SHADER_CONSTANT_278_W)
XE_GPU_REGISTER(0x445C, kFloat, SHADER_CONSTANT_279_X)
XE_GPU_REGISTER(0x445D, kFloat, SHADER_CONSTANT_279_Y)
XE_GPU_REGISTER(0x445E, kFloat, SHADER_CONSTANT_279_Z)
XE_GPU_REGISTER(0x445F, kFloat, SHADER_CONSTANT_279_W)
XE_GPU_REGISTER(0x4460, kFloat, SHADER_CONSTANT_280_X)
XE_GPU_REGISTER(0x4461, kFloat, SHADER_CONSTANT_280_Y)
XE_GPU_REGISTER(0x4462, kFloat, SHADER_CONSTANT_280_Z)
XE_GPU_REGISTER(0x4463, kFloat, SHADER_CONSTANT_280_W)
XE_GPU_REGISTER(0x4464, kFloat, SHADER_CONSTANT_281_X)
XE_GPU_REGISTER(0x4465, kFloat, SHADER_CONSTANT_281_Y)
XE_GPU_REGISTER(0x4466, kFloat, SHADER_CONSTANT_281_Z)
XE_GPU_REGISTER(0x4467, kFloat, SHADER_CONSTANT_281_W)
XE_GPU_REGISTER(0x4468, kFloat, SHADER_CONSTANT_282_X)
XE_GPU_REGISTER(0x4469, kFloat, SHADER_CONSTANT_282_Y)
XE_GPU_REGISTER(0x446A, kFloat, SHADER_CONSTANT_282_Z)
XE_GPU_REGISTER(0x446B, kFloat, SHADER_CONSTANT_282_W)
XE_GPU_REGISTER(0x446C, kFloat, SHADER_CONSTANT_283_X)
XE_GPU_REGISTER(0x446D, kFloat, SHADER_CONSTANT_283_Y)
XE_GPU_REGISTER(0x446E, kFloat, SHADER_CONSTANT_283_Z)
XE_GPU_REGISTER(0x446F, kFloat, SHADER_CONSTANT_283_W)
XE_GPU_REGISTER(0x4470, kFloat, SHADER_CONSTANT_284_X)
XE_GPU_REGISTER(0x4471, kFloat, SHADER_CONSTANT_284_Y)
XE_GPU_REGISTER(0x4472, kFloat, SHADER_CONSTANT_284_Z)
XE_GPU_REGISTER(0x4473, kFloat, SHADER_CONSTANT_284_W)
XE_GPU_REGISTER(0x4474, kFloat, SHADER_CONSTANT_285_X)
XE_GPU_REGISTER(0x4475, kFloat, SHADER_CONSTANT_285_Y)
XE_GPU_REGISTER(0x4476, kFloat, SHADER_CONSTANT_285_Z)
XE_GPU_REGISTER(0x4477, kFloat, SHADER_CONSTANT_285_W)
XE_GPU_REGISTER(0x4478, kFloat, SHADER_CONSTANT_286_X)
XE_GPU_REGISTER(0x4479, kFloat, SHADER_CONSTANT_286_Y)
XE_GPU_REGISTER(0x447A, kFloat, SHADER_CONSTANT_286_Z)
XE_GPU_REGISTER(0x447B, kFloat, SHADER_CONSTANT_286_W)
XE_GPU_REGISTER(0x447C, kFloat, SHADER_CONSTANT_287_X)
XE_GPU_REGISTER(0x447D, kFloat, SHADER_CONSTANT_287_Y)
XE_GPU_REGISTER(0x447E, kFloat, SHADER_CONSTANT_287_Z)
XE_GPU_REGISTER(0x447F, kFloat, SHADER_CONSTANT_287_W)
XE_GPU_REGISTER(0x4480, kFloat, SHADER_CONSTANT_288_X)
XE_GPU_REGISTER(0x4481, kFloat, SHADER_CONSTANT_288_Y)
XE_GPU_REGISTER(0x4482, kFloat, SHADER_CONSTANT_288_Z)
XE_GPU_REGISTER(0x4483, kFloat, SHADER_CONSTANT_288_W)
XE_GPU_REGISTER(0x4484, kFloat, SHADER_CONSTANT_289_X)
XE_GPU_REGISTER(0x4485, kFloat, SHADER_CONSTANT_289_Y)
XE_GPU_REGISTER(0x4486, kFloat, SHADER_CONSTANT_289_Z)
XE_GPU_REGISTER(0x4487, kFloat, SHADER_CONSTANT_289_W)
XE_GPU_REGISTER(0x4488, kFloat, SHADER_CONSTANT_290_X)
XE_GPU_REGISTER(0x4489, kFloat, SHADER_CONSTANT_290_Y)
XE_GPU_REGISTER(0x448A, kFloat, SHADER_CONSTANT_290_Z)
XE_GPU_REGISTER(0x448B, kFloat, SHADER_CONSTANT_290_W)
XE_GPU_REGISTER(0x448C, kFloat, SHADER_CONSTANT_291_X)
XE_GPU_REGISTER(0x448D, kFloat, SHADER_CONSTANT_291_Y)
XE_GPU_REGISTER(0x448E, kFloat, SHADER_CONSTANT_291_Z)
XE_GPU_REGISTER(0x448F, kFloat, SHADER_CONSTANT_291_W)
XE_GPU_REGISTER(0x4490, kFloat, SHADER_CONSTANT_292_X)
XE_GPU_REGISTER(0x4491, kFloat, SHADER_CONSTANT_292_Y)
XE_GPU_REGISTER(0x4492, kFloat, SHADER_CONSTANT_292_Z)
XE_GPU_REGISTER(0x4493, kFloat, SHADER_CONSTANT_292_W)
XE_GPU_REGISTER(0x4494, kFloat, SHADER_CONSTANT_293_X)
XE_GPU_REGISTER(0x4495, kFloat, SHADER_CONSTANT_293_Y)
XE_GPU_REGISTER(0x4496, kFloat, SHADER_CONSTANT_293_Z)
XE_GPU_REGISTER(0x4497, kFloat, SHADER_CONSTANT_293_W)
XE_GPU_REGISTER(0x4498, kFloat, SHADER_CONSTANT_294_X)
XE_GPU_REGISTER(0x4499, kFloat, SHADER_CONSTANT_294_Y)
XE_GPU_REGISTER(0x449A, kFloat, SHADER_CONSTANT_294_Z)
XE_GPU_REGISTER(0x449B, kFloat, SHADER_CONSTANT_294_W)
XE_GPU_REGISTER(0x449C, kFloat, SHADER_CONSTANT_295_X)
XE_GPU_REGISTER(0x449D, kFloat, SHADER_CONSTANT_295_Y)
XE_GPU_REGISTER(0x449E, kFloat, SHADER_CONSTANT_295_Z)
XE_GPU_REGISTER(0x449F, kFloat, SHADER_CONSTANT_295_W)
XE_GPU_REGISTER(0x44A0, kFloat, SHADER_CONSTANT_296_X)
XE_GPU_REGISTER(0x44A1, kFloat, SHADER_CONSTANT_296_Y)
XE_GPU_REGISTER(0x44A2, kFloat, SHADER_CONSTANT_296_Z)
XE_GPU_REGISTER(0x44A3, kFloat, SHADER_CONSTANT_296_W)
XE_GPU_REGISTER(0x44A4, kFloat, SHADER_CONSTANT_297_X)
XE_GPU_REGISTER(0x44A5, kFloat, SHADER_CONSTANT_297_Y)
XE_GPU_REGISTER(0x44A6, kFloat, SHADER_CONSTANT_297_Z)
XE_GPU_REGISTER(0x44A7, kFloat, SHADER_CONSTANT_297_W)
XE_GPU_REGISTER(0x44A8, kFloat, SHADER_CONSTANT_298_X)
XE_GPU_REGISTER(0x44A9, kFloat, SHADER_CONSTANT_298_Y)
XE_GPU_REGISTER(0x44AA, kFloat, SHADER_CONSTANT_298_Z)
XE_GPU_REGISTER(0x44AB, kFloat, SHADER_CONSTANT_298_W)
XE_GPU_REGISTER(0x44AC, kFloat, SHADER_CONSTANT_299_X)
XE_GPU_REGISTER(0x44AD, kFloat, SHADER_CONSTANT_299_Y)
XE_GPU_REGISTER(0x44AE, kFloat, SHADER_CONSTANT_299_Z)
XE_GPU_REGISTER(0x44AF, kFloat, SHADER_CONSTANT_299_W)
XE_GPU_REGISTER(0x44B0, kFloat, SHADER_CONSTANT_300_X)
XE_GPU_REGISTER(0x44B1, kFloat, SHADER_CONSTANT_300_Y)
XE_GPU_REGISTER(0x44B2, kFloat, SHADER_CONSTANT_300_Z)
XE_GPU_REGISTER(0x44B3, kFloat, SHADER_CONSTANT_300_W)
XE_GPU_REGISTER(0x44B4, kFloat, SHADER_CONSTANT_301_X)
XE_GPU_REGISTER(0x44B5, kFloat, SHADER_CONSTANT_301_Y)
XE_GPU_REGISTER(0x44B6, kFloat, SHADER_CONSTANT_301_Z)
XE_GPU_REGISTER(0x44B7, kFloat, SHADER_CONSTANT_301_W)
XE_GPU_REGISTER(0x44B8, kFloat, SHADER_CONSTANT_302_X)
XE_GPU_REGISTER(0x44B9, kFloat, SHADER_CONSTANT_302_Y)
XE_GPU_REGISTER(0x44BA, kFloat, SHADER_CONSTANT_302_Z)
XE_GPU_REGISTER(0x44BB, kFloat, SHADER_CONSTANT_302_W)
XE_GPU_REGISTER(0x44BC, kFloat, SHADER_CONSTANT_303_X)
XE_GPU_REGISTER(0x44BD, kFloat, SHADER_CONSTANT_303_Y)
XE_GPU_REGISTER(0x44BE, kFloat, SHADER_CONSTANT_303_Z)
XE_GPU_REGISTER(0x44BF, kFloat, SHADER_CONSTANT_303_W)
XE_GPU_REGISTER(0x44C0, kFloat, SHADER_CONSTANT_304_X)
XE_GPU_REGISTER(0x44C1, kFloat, SHADER_CONSTANT_304_Y)
XE_GPU_REGISTER(0x44C2, kFloat, SHADER_CONSTANT_304_Z)
XE_GPU_REGISTER(0x44C3, kFloat, SHADER_CONSTANT_304_W)
XE_GPU_REGISTER(0x44C4, kFloat, SHADER_CONSTANT_305_X)
XE_GPU_REGISTER(0x44C5, kFloat, SHADER_CONSTANT_305_Y)
XE_GPU_REGISTER(0x44C6, kFloat, SHADER_CONSTANT_305_Z)
XE_GPU_REGISTER(0x44C7, kFloat, SHADER_CONSTANT_305_W)
XE_GPU_REGISTER(0x44C8, kFloat, SHADER_CONSTANT_306_X)
XE_GPU_REGISTER(0x44C9, kFloat, SHADER_CONSTANT_306_Y)
XE_GPU_REGISTER(0x44CA, kFloat, SHADER_CONSTANT_306_Z)
XE_GPU_REGISTER(0x44CB, kFloat, SHADER_CONSTANT_306_W)
XE_GPU_REGISTER(0x44CC, kFloat, SHADER_CONSTANT_307_X)
XE_GPU_REGISTER(0x44CD, kFloat, SHADER_CONSTANT_307_Y)
XE_GPU_REGISTER(0x44CE, kFloat, SHADER_CONSTANT_307_Z)
XE_GPU_REGISTER(0x44CF, kFloat, SHADER_CONSTANT_307_W)
XE_GPU_REGISTER(0x44D0, kFloat, SHADER_CONSTANT_308_X)
XE_GPU_REGISTER(0x44D1, kFloat, SHADER_CONSTANT_308_Y)
XE_GPU_REGISTER(0x44D2, kFloat, SHADER_CONSTANT_308_Z)
XE_GPU_REGISTER(0x44D3, kFloat, SHADER_CONSTANT_308_W)
XE_GPU_REGISTER(0x44D4, kFloat, SHADER_CONSTANT_309_X)
XE_GPU_REGISTER(0x44D5, kFloat, SHADER_CONSTANT_309_Y)
XE_GPU_REGISTER(0x44D6, kFloat, SHADER_CONSTANT_309_Z)
XE_GPU_REGISTER(0x44D7, kFloat, SHADER_CONSTANT_309_W)
XE_GPU_REGISTER(0x44D8, kFloat, SHADER_CONSTANT_310_X)
XE_GPU_REGISTER(0x44D9, kFloat, SHADER_CONSTANT_310_Y)
XE_GPU_REGISTER(0x44DA, kFloat, SHADER_CONSTANT_310_Z)
XE_GPU_REGISTER(0x44DB, kFloat, SHADER_CONSTANT_310_W)
XE_GPU_REGISTER(0x44DC, kFloat, SHADER_CONSTANT_311_X)
XE_GPU_REGISTER(0x44DD, kFloat, SHADER_CONSTANT_311_Y)
XE_GPU_REGISTER(0x44DE, kFloat, SHADER_CONSTANT_311_Z)
XE_GPU_REGISTER(0x44DF, kFloat, SHADER_CONSTANT_311_W)
XE_GPU_REGISTER(0x44E0, kFloat, SHADER_CONSTANT_312_X)
XE_GPU_REGISTER(0x44E1, kFloat, SHADER_CONSTANT_312_Y)
XE_GPU_REGISTER(0x44E2, kFloat, SHADER_CONSTANT_312_Z)
XE_GPU_REGISTER(0x44E3, kFloat, SHADER_CONSTANT_312_W)
XE_GPU_REGISTER(0x44E4, kFloat, SHADER_CONSTANT_313_X)
XE_GPU_REGISTER(0x44E5, kFloat, SHADER_CONSTANT_313_Y)
XE_GPU_REGISTER(0x44E6, kFloat, SHADER_CONSTANT_313_Z)
XE_GPU_REGISTER(0x44E7, kFloat, SHADER_CONSTANT_313_W)
XE_GPU_REGISTER(0x44E8, kFloat, SHADER_CONSTANT_314_X)
XE_GPU_REGISTER(0x44E9, kFloat, SHADER_CONSTANT_314_Y)
XE_GPU_REGISTER(0x44EA, kFloat, SHADER_CONSTANT_314_Z)
XE_GPU_REGISTER(0x44EB, kFloat, SHADER_CONSTANT_314_W)
XE_GPU_REGISTER(0x44EC, kFloat, SHADER_CONSTANT_315_X)
XE_GPU_REGISTER(0x44ED, kFloat, SHADER_CONSTANT_315_Y)
XE_GPU_REGISTER(0x44EE, kFloat, SHADER_CONSTANT_315_Z)
XE_GPU_REGISTER(0x44EF, kFloat, SHADER_CONSTANT_315_W)
XE_GPU_REGISTER(0x44F0, kFloat, SHADER_CONSTANT_316_X)
XE_GPU_REGISTER(0x44F1, kFloat, SHADER_CONSTANT_316_Y)
XE_GPU_REGISTER(0x44F2, kFloat, SHADER_CONSTANT_316_Z)
XE_GPU_REGISTER(0x44F3, kFloat, SHADER_CONSTANT_316_W)
XE_GPU_REGISTER(0x44F4, kFloat, SHADER_CONSTANT_317_X)
XE_GPU_REGISTER(0x44F5, kFloat, SHADER_CONSTANT_317_Y)
XE_GPU_REGISTER(0x44F6, kFloat, SHADER_CONSTANT_317_Z)
XE_GPU_REGISTER(0x44F7, kFloat, SHADER_CONSTANT_317_W)
XE_GPU_REGISTER(0x44F8, kFloat, SHADER_CONSTANT_318_X)
XE_GPU_REGISTER(0x44F9, kFloat, SHADER_CONSTANT_318_Y)
XE_GPU_REGISTER(0x44FA, kFloat, SHADER_CONSTANT_318_Z)
XE_GPU_REGISTER(0x44FB, kFloat, SHADER_CONSTANT_318_W)
XE_GPU_REGISTER(0x44FC, kFloat, SHADER_CONSTANT_319_X)
XE_GPU_REGISTER(0x44FD, kFloat, SHADER_CONSTANT_319_Y)
XE_GPU_REGISTER(0x44FE, kFloat, SHADER_CONSTANT_319_Z)
XE_GPU_REGISTER(0x44FF, kFloat, SHADER_CONSTANT_319_W)
XE_GPU_REGISTER(0x4500, kFloat, SHADER_CONSTANT_320_X)
XE_GPU_REGISTER(0x4501, kFloat, SHADER_CONSTANT_320_Y)
XE_GPU_REGISTER(0x4502, kFloat, SHADER_CONSTANT_320_Z)
XE_GPU_REGISTER(0x4503, kFloat, SHADER_CONSTANT_320_W)
XE_GPU_REGISTER(0x4504, kFloat, SHADER_CONSTANT_321_X)
XE_GPU_REGISTER(0x4505, kFloat, SHADER_CONSTANT_321_Y)
XE_GPU_REGISTER(0x4506, kFloat, SHADER_CONSTANT_321_Z)
XE_GPU_REGISTER(0x4507, kFloat, SHADER_CONSTANT_321_W)
XE_GPU_REGISTER(0x4508, kFloat, SHADER_CONSTANT_322_X)
XE_GPU_REGISTER(0x4509, kFloat, SHADER_CONSTANT_322_Y)
XE_GPU_REGISTER(0x450A, kFloat, SHADER_CONSTANT_322_Z)
XE_GPU_REGISTER(0x450B, kFloat, SHADER_CONSTANT_322_W)
XE_GPU_REGISTER(0x450C, kFloat, SHADER_CONSTANT_323_X)
XE_GPU_REGISTER(0x450D, kFloat, SHADER_CONSTANT_323_Y)
XE_GPU_REGISTER(0x450E, kFloat, SHADER_CONSTANT_323_Z)
XE_GPU_REGISTER(0x450F, kFloat, SHADER_CONSTANT_323_W)
XE_GPU_REGISTER(0x4510, kFloat, SHADER_CONSTANT_324_X)
XE_GPU_REGISTER(0x4511, kFloat, SHADER_CONSTANT_324_Y)
XE_GPU_REGISTER(0x4512, kFloat, SHADER_CONSTANT_324_Z)
XE_GPU_REGISTER(0x4513, kFloat, SHADER_CONSTANT_324_W)
XE_GPU_REGISTER(0x4514, kFloat, SHADER_CONSTANT_325_X)
XE_GPU_REGISTER(0x4515, kFloat, SHADER_CONSTANT_325_Y)
XE_GPU_REGISTER(0x4516, kFloat, SHADER_CONSTANT_325_Z)
XE_GPU_REGISTER(0x4517, kFloat, SHADER_CONSTANT_325_W)
XE_GPU_REGISTER(0x4518, kFloat, SHADER_CONSTANT_326_X)
XE_GPU_REGISTER(0x4519, kFloat, SHADER_CONSTANT_326_Y)
XE_GPU_REGISTER(0x451A, kFloat, SHADER_CONSTANT_326_Z)
XE_GPU_REGISTER(0x451B, kFloat, SHADER_CONSTANT_326_W)
XE_GPU_REGISTER(0x451C, kFloat, SHADER_CONSTANT_327_X)
XE_GPU_REGISTER(0x451D, kFloat, SHADER_CONSTANT_327_Y)
XE_GPU_REGISTER(0x451E, kFloat, SHADER_CONSTANT_327_Z)
XE_GPU_REGISTER(0x451F, kFloat, SHADER_CONSTANT_327_W)
XE_GPU_REGISTER(0x4520, kFloat, SHADER_CONSTANT_328_X)
XE_GPU_REGISTER(0x4521, kFloat, SHADER_CONSTANT_328_Y)
XE_GPU_REGISTER(0x4522, kFloat, SHADER_CONSTANT_328_Z)
XE_GPU_REGISTER(0x4523, kFloat, SHADER_CONSTANT_328_W)
XE_GPU_REGISTER(0x4524, kFloat, SHADER_CONSTANT_329_X)
XE_GPU_REGISTER(0x4525, kFloat, SHADER_CONSTANT_329_Y)
XE_GPU_REGISTER(0x4526, kFloat, SHADER_CONSTANT_329_Z)
XE_GPU_REGISTER(0x4527, kFloat, SHADER_CONSTANT_329_W)
XE_GPU_REGISTER(0x4528, kFloat, SHADER_CONSTANT_330_X)
XE_GPU_REGISTER(0x4529, kFloat, SHADER_CONSTANT_330_Y)
XE_GPU_REGISTER(0x452A, kFloat, SHADER_CONSTANT_330_Z)
XE_GPU_REGISTER(0x452B, kFloat, SHADER_CONSTANT_330_W)
XE_GPU_REGISTER(0x452C, kFloat, SHADER_CONSTANT_331_X)
XE_GPU_REGISTER(0x452D, kFloat, SHADER_CONSTANT_331_Y)
XE_GPU_REGISTER(0x452E, kFloat, SHADER_CONSTANT_331_Z)
XE_GPU_REGISTER(0x452F, kFloat, SHADER_CONSTANT_331_W)
XE_GPU_REGISTER(0x4530, kFloat, SHADER_CONSTANT_332_X)
XE_GPU_REGISTER(0x4531, kFloat, SHADER_CONSTANT_332_Y)
XE_GPU_REGISTER(0x4532, kFloat, SHADER_CONSTANT_332_Z)
XE_GPU_REGISTER(0x4533, kFloat, SHADER_CONSTANT_332_W)
XE_GPU_REGISTER(0x4534, kFloat, SHADER_CONSTANT_333_X)
XE_GPU_REGISTER(0x4535, kFloat, SHADER_CONSTANT_333_Y)
XE_GPU_REGISTER(0x4536, kFloat, SHADER_CONSTANT_333_Z)
XE_GPU_REGISTER(0x4537, kFloat, SHADER_CONSTANT_333_W)
XE_GPU_REGISTER(0x4538, kFloat, SHADER_CONSTANT_334_X)
XE_GPU_REGISTER(0x4539, kFloat, SHADER_CONSTANT_334_Y)
XE_GPU_REGISTER(0x453A, kFloat, SHADER_CONSTANT_334_Z)
XE_GPU_REGISTER(0x453B, kFloat, SHADER_CONSTANT_334_W)
XE_GPU_REGISTER(0x453C, kFloat, SHADER_CONSTANT_335_X)
XE_GPU_REGISTER(0x453D, kFloat, SHADER_CONSTANT_335_Y)
XE_GPU_REGISTER(0x453E, kFloat, SHADER_CONSTANT_335_Z)
XE_GPU_REGISTER(0x453F, kFloat, SHADER_CONSTANT_335_W)
XE_GPU_REGISTER(0x4540, kFloat, SHADER_CONSTANT_336_X)
XE_GPU_REGISTER(0x4541, kFloat, SHADER_CONSTANT_336_Y)
XE_GPU_REGISTER(0x4542, kFloat, SHADER_CONSTANT_336_Z)
XE_GPU_REGISTER(0x4543, kFloat, SHADER_CONSTANT_336_W)
XE_GPU_REGISTER(0x4544, kFloat, SHADER_CONSTANT_337_X)
XE_GPU_REGISTER(0x4545, kFloat, SHADER_CONSTANT_337_Y)
XE_GPU_REGISTER(0x4546, kFloat, SHADER_CONSTANT_337_Z)
XE_GPU_REGISTER(0x4547, kFloat, SHADER_CONSTANT_337_W)
XE_GPU_REGISTER(0x4548, kFloat, SHADER_CONSTANT_338_X)
XE_GPU_REGISTER(0x4549, kFloat, SHADER_CONSTANT_338_Y)
XE_GPU_REGISTER(0x454A, kFloat, SHADER_CONSTANT_338_Z)
XE_GPU_REGISTER(0x454B, kFloat, SHADER_CONSTANT_338_W)
XE_GPU_REGISTER(0x454C, kFloat, SHADER_CONSTANT_339_X)
XE_GPU_REGISTER(0x454D, kFloat, SHADER_CONSTANT_339_Y)
XE_GPU_REGISTER(0x454E, kFloat, SHADER_CONSTANT_339_Z)
XE_GPU_REGISTER(0x454F, kFloat, SHADER_CONSTANT_339_W)
XE_GPU_REGISTER(0x4550, kFloat, SHADER_CONSTANT_340_X)
XE_GPU_REGISTER(0x4551, kFloat, SHADER_CONSTANT_340_Y)
XE_GPU_REGISTER(0x4552, kFloat, SHADER_CONSTANT_340_Z)
XE_GPU_REGISTER(0x4553, kFloat, SHADER_CONSTANT_340_W)
XE_GPU_REGISTER(0x4554, kFloat, SHADER_CONSTANT_341_X)
XE_GPU_REGISTER(0x4555, kFloat, SHADER_CONSTANT_341_Y)
XE_GPU_REGISTER(0x4556, kFloat, SHADER_CONSTANT_341_Z)
XE_GPU_REGISTER(0x4557, kFloat, SHADER_CONSTANT_341_W)
XE_GPU_REGISTER(0x4558, kFloat, SHADER_CONSTANT_342_X)
XE_GPU_REGISTER(0x4559, kFloat, SHADER_CONSTANT_342_Y)
XE_GPU_REGISTER(0x455A, kFloat, SHADER_CONSTANT_342_Z)
XE_GPU_REGISTER(0x455B, kFloat, SHADER_CONSTANT_342_W)
XE_GPU_REGISTER(0x455C, kFloat, SHADER_CONSTANT_343_X)
XE_GPU_REGISTER(0x455D, kFloat, SHADER_CONSTANT_343_Y)
XE_GPU_REGISTER(0x455E, kFloat, SHADER_CONSTANT_343_Z)
XE_GPU_REGISTER(0x455F, kFloat, SHADER_CONSTANT_343_W)
XE_GPU_REGISTER(0x4560, kFloat, SHADER_CONSTANT_344_X)
XE_GPU_REGISTER(0x4561, kFloat, SHADER_CONSTANT_344_Y)
XE_GPU_REGISTER(0x4562, kFloat, SHADER_CONSTANT_344_Z)
XE_GPU_REGISTER(0x4563, kFloat, SHADER_CONSTANT_344_W)
XE_GPU_REGISTER(0x4564, kFloat, SHADER_CONSTANT_345_X)
XE_GPU_REGISTER(0x4565, kFloat, SHADER_CONSTANT_345_Y)
XE_GPU_REGISTER(0x4566, kFloat, SHADER_CONSTANT_345_Z)
XE_GPU_REGISTER(0x4567, kFloat, SHADER_CONSTANT_345_W)
XE_GPU_REGISTER(0x4568, kFloat, SHADER_CONSTANT_346_X)
XE_GPU_REGISTER(0x4569, kFloat, SHADER_CONSTANT_346_Y)
XE_GPU_REGISTER(0x456A, kFloat, SHADER_CONSTANT_346_Z)
XE_GPU_REGISTER(0x456B, kFloat, SHADER_CONSTANT_346_W)
XE_GPU_REGISTER(0x456C, kFloat, SHADER_CONSTANT_347_X)
XE_GPU_REGISTER(0x456D, kFloat, SHADER_CONSTANT_347_Y)
XE_GPU_REGISTER(0x456E, kFloat, SHADER_CONSTANT_347_Z)
XE_GPU_REGISTER(0x456F, kFloat, SHADER_CONSTANT_347_W)
XE_GPU_REGISTER(0x4570, kFloat, SHADER_CONSTANT_348_X)
XE_GPU_REGISTER(0x4571, kFloat, SHADER_CONSTANT_348_Y)
XE_GPU_REGISTER(0x4572, kFloat, SHADER_CONSTANT_348_Z)
XE_GPU_REGISTER(0x4573, kFloat, SHADER_CONSTANT_348_W)
XE_GPU_REGISTER(0x4574, kFloat, SHADER_CONSTANT_349_X)
XE_GPU_REGISTER(0x4575, kFloat, SHADER_CONSTANT_349_Y)
XE_GPU_REGISTER(0x4576, kFloat, SHADER_CONSTANT_349_Z)
XE_GPU_REGISTER(0x4577, kFloat, SHADER_CONSTANT_349_W)
XE_GPU_REGISTER(0x4578, kFloat, SHADER_CONSTANT_350_X)
XE_GPU_REGISTER(0x4579, kFloat, SHADER_CONSTANT_350_Y)
XE_GPU_REGISTER(0x457A, kFloat, SHADER_CONSTANT_350_Z)
XE_GPU_REGISTER(0x457B, kFloat, SHADER_CONSTANT_350_W)
XE_GPU_REGISTER(0x457C, kFloat, SHADER_CONSTANT_351_X)
XE_GPU_REGISTER(0x457D, kFloat, SHADER_CONSTANT_351_Y)
XE_GPU_REGISTER(0x457E, kFloat, SHADER_CONSTANT_351_Z)
XE_GPU_REGISTER(0x457F, kFloat, SHADER_CONSTANT_351_W)
XE_GPU_REGISTER(0x4580, kFloat, SHADER_CONSTANT_352_X)
XE_GPU_REGISTER(0x4581, kFloat, SHADER_CONSTANT_352_Y)
XE_GPU_REGISTER(0x4582, kFloat, SHADER_CONSTANT_352_Z)
XE_GPU_REGISTER(0x4583, kFloat, SHADER_CONSTANT_352_W)
XE_GPU_REGISTER(0x4584, kFloat, SHADER_CONSTANT_353_X)
XE_GPU_REGISTER(0x4585, kFloat, SHADER_CONSTANT_353_Y)
XE_GPU_REGISTER(0x4586, kFloat, SHADER_CONSTANT_353_Z)
XE_GPU_REGISTER(0x4587, kFloat, SHADER_CONSTANT_353_W)
XE_GPU_REGISTER(0x4588, kFloat, SHADER_CONSTANT_354_X)
XE_GPU_REGISTER(0x4589, kFloat, SHADER_CONSTANT_354_Y)
XE_GPU_REGISTER(0x458A, kFloat, SHADER_CONSTANT_354_Z)
XE_GPU_REGISTER(0x458B, kFloat, SHADER_CONSTANT_354_W)
XE_GPU_REGISTER(0x458C, kFloat, SHADER_CONSTANT_355_X)
XE_GPU_REGISTER(0x458D, kFloat, SHADER_CONSTANT_355_Y)
XE_GPU_REGISTER(0x458E, kFloat, SHADER_CONSTANT_355_Z)
XE_GPU_REGISTER(0x458F, kFloat, SHADER_CONSTANT_355_W)
XE_GPU_REGISTER(0x4590, kFloat, SHADER_CONSTANT_356_X)
XE_GPU_REGISTER(0x4591, kFloat, SHADER_CONSTANT_356_Y)
XE_GPU_REGISTER(0x4592, kFloat, SHADER_CONSTANT_356_Z)
XE_GPU_REGISTER(0x4593, kFloat, SHADER_CONSTANT_356_W)
XE_GPU_REGISTER(0x4594, kFloat, SHADER_CONSTANT_357_X)
XE_GPU_REGISTER(0x4595, kFloat, SHADER_CONSTANT_357_Y)
XE_GPU_REGISTER(0x4596, kFloat, SHADER_CONSTANT_357_Z)
XE_GPU_REGISTER(0x4597, kFloat, SHADER_CONSTANT_357_W)
XE_GPU_REGISTER(0x4598, kFloat, SHADER_CONSTANT_358_X)
XE_GPU_REGISTER(0x4599, kFloat, SHADER_CONSTANT_358_Y)
XE_GPU_REGISTER(0x459A, kFloat, SHADER_CONSTANT_358_Z)
XE_GPU_REGISTER(0x459B, kFloat, SHADER_CONSTANT_358_W)
XE_GPU_REGISTER(0x459C, kFloat, SHADER_CONSTANT_359_X)
XE_GPU_REGISTER(0x459D, kFloat, SHADER_CONSTANT_359_Y)
XE_GPU_REGISTER(0x459E, kFloat, SHADER_CONSTANT_359_Z)
XE_GPU_REGISTER(0x459F, kFloat, SHADER_CONSTANT_359_W)
XE_GPU_REGISTER(0x45A0, kFloat, SHADER_CONSTANT_360_X)
XE_GPU_REGISTER(0x45A1, kFloat, SHADER_CONSTANT_360_Y)
XE_GPU_REGISTER(0x45A2, kFloat, SHADER_CONSTANT_360_Z)
XE_GPU_REGISTER(0x45A3, kFloat, SHADER_CONSTANT_360_W)
XE_GPU_REGISTER(0x45A4, kFloat, SHADER_CONSTANT_361_X)
XE_GPU_REGISTER(0x45A5, kFloat, SHADER_CONSTANT_361_Y)
XE_GPU_REGISTER(0x45A6, kFloat, SHADER_CONSTANT_361_Z)
XE_GPU_REGISTER(0x45A7, kFloat, SHADER_CONSTANT_361_W)
XE_GPU_REGISTER(0x45A8, kFloat, SHADER_CONSTANT_362_X)
XE_GPU_REGISTER(0x45A9, kFloat, SHADER_CONSTANT_362_Y)
XE_GPU_REGISTER(0x45AA, kFloat, SHADER_CONSTANT_362_Z)
XE_GPU_REGISTER(0x45AB, kFloat, SHADER_CONSTANT_362_W)
XE_GPU_REGISTER(0x45AC, kFloat, SHADER_CONSTANT_363_X)
XE_GPU_REGISTER(0x45AD, kFloat, SHADER_CONSTANT_363_Y)
XE_GPU_REGISTER(0x45AE, kFloat, SHADER_CONSTANT_363_Z)
XE_GPU_REGISTER(0x45AF, kFloat, SHADER_CONSTANT_363_W)
XE_GPU_REGISTER(0x45B0, kFloat, SHADER_CONSTANT_364_X)
XE_GPU_REGISTER(0x45B1, kFloat, SHADER_CONSTANT_364_Y)
XE_GPU_REGISTER(0x45B2, kFloat, SHADER_CONSTANT_364_Z)
XE_GPU_REGISTER(0x45B3, kFloat, SHADER_CONSTANT_364_W)
XE_GPU_REGISTER(0x45B4, kFloat, SHADER_CONSTANT_365_X)
XE_GPU_REGISTER(0x45B5, kFloat, SHADER_CONSTANT_365_Y)
XE_GPU_REGISTER(0x45B6, kFloat, SHADER_CONSTANT_365_Z)
XE_GPU_REGISTER(0x45B7, kFloat, SHADER_CONSTANT_365_W)
XE_GPU_REGISTER(0x45B8, kFloat, SHADER_CONSTANT_366_X)
XE_GPU_REGISTER(0x45B9, kFloat, SHADER_CONSTANT_366_Y)
XE_GPU_REGISTER(0x45BA, kFloat, SHADER_CONSTANT_366_Z)
XE_GPU_REGISTER(0x45BB, kFloat, SHADER_CONSTANT_366_W)
XE_GPU_REGISTER(0x45BC, kFloat, SHADER_CONSTANT_367_X)
XE_GPU_REGISTER(0x45BD, kFloat, SHADER_CONSTANT_367_Y)
XE_GPU_REGISTER(0x45BE, kFloat, SHADER_CONSTANT_367_Z)
XE_GPU_REGISTER(0x45BF, kFloat, SHADER_CONSTANT_367_W)
XE_GPU_REGISTER(0x45C0, kFloat, SHADER_CONSTANT_368_X)
XE_GPU_REGISTER(0x45C1, kFloat, SHADER_CONSTANT_368_Y)
XE_GPU_REGISTER(0x45C2, kFloat, SHADER_CONSTANT_368_Z)
XE_GPU_REGISTER(0x45C3, kFloat, SHADER_CONSTANT_368_W)
XE_GPU_REGISTER(0x45C4, kFloat, SHADER_CONSTANT_369_X)
XE_GPU_REGISTER(0x45C5, kFloat, SHADER_CONSTANT_369_Y)
XE_GPU_REGISTER(0x45C6, kFloat, SHADER_CONSTANT_369_Z)
XE_GPU_REGISTER(0x45C7, kFloat, SHADER_CONSTANT_369_W)
XE_GPU_REGISTER(0x45C8, kFloat, SHADER_CONSTANT_370_X)
XE_GPU_REGISTER(0x45C9, kFloat, SHADER_CONSTANT_370_Y)
XE_GPU_REGISTER(0x45CA, kFloat, SHADER_CONSTANT_370_Z)
XE_GPU_REGISTER(0x45CB, kFloat, SHADER_CONSTANT_370_W)
XE_GPU_REGISTER(0x45CC, kFloat, SHADER_CONSTANT_371_X)
XE_GPU_REGISTER(0x45CD, kFloat, SHADER_CONSTANT_371_Y)
XE_GPU_REGISTER(0x45CE, kFloat, SHADER_CONSTANT_371_Z)
XE_GPU_REGISTER(0x45CF, kFloat, SHADER_CONSTANT_371_W)
XE_GPU_REGISTER(0x45D0, kFloat, SHADER_CONSTANT_372_X)
XE_GPU_REGISTER(0x45D1, kFloat, SHADER_CONSTANT_372_Y)
XE_GPU_REGISTER(0x45D2, kFloat, SHADER_CONSTANT_372_Z)
XE_GPU_REGISTER(0x45D3, kFloat, SHADER_CONSTANT_372_W)
XE_GPU_REGISTER(0x45D4, kFloat, SHADER_CONSTANT_373_X)
XE_GPU_REGISTER(0x45D5, kFloat, SHADER_CONSTANT_373_Y)
XE_GPU_REGISTER(0x45D6, kFloat, SHADER_CONSTANT_373_Z)
XE_GPU_REGISTER(0x45D7, kFloat, SHADER_CONSTANT_373_W)
XE_GPU_REGISTER(0x45D8, kFloat, SHADER_CONSTANT_374_X)
XE_GPU_REGISTER(0x45D9, kFloat, SHADER_CONSTANT_374_Y)
XE_GPU_REGISTER(0x45DA, kFloat, SHADER_CONSTANT_374_Z)
XE_GPU_REGISTER(0x45DB, kFloat, SHADER_CONSTANT_374_W)
XE_GPU_REGISTER(0x45DC, kFloat, SHADER_CONSTANT_375_X)
XE_GPU_REGISTER(0x45DD, kFloat, SHADER_CONSTANT_375_Y)
XE_GPU_REGISTER(0x45DE, kFloat, SHADER_CONSTANT_375_Z)
XE_GPU_REGISTER(0x45DF, kFloat, SHADER_CONSTANT_375_W)
XE_GPU_REGISTER(0x45E0, kFloat, SHADER_CONSTANT_376_X)
XE_GPU_REGISTER(0x45E1, kFloat, SHADER_CONSTANT_376_Y)
XE_GPU_REGISTER(0x45E2, kFloat, SHADER_CONSTANT_376_Z)
XE_GPU_REGISTER(0x45E3, kFloat, SHADER_CONSTANT_376_W)
XE_GPU_REGISTER(0x45E4, kFloat, SHADER_CONSTANT_377_X)
XE_GPU_REGISTER(0x45E5, kFloat, SHADER_CONSTANT_377_Y)
XE_GPU_REGISTER(0x45E6, kFloat, SHADER_CONSTANT_377_Z)
XE_GPU_REGISTER(0x45E7, kFloat, SHADER_CONSTANT_377_W)
XE_GPU_REGISTER(0x45E8, kFloat, SHADER_CONSTANT_378_X)
XE_GPU_REGISTER(0x45E9, kFloat, SHADER_CONSTANT_378_Y)
XE_GPU_REGISTER(0x45EA, kFloat, SHADER_CONSTANT_378_Z)
XE_GPU_REGISTER(0x45EB, kFloat, SHADER_CONSTANT_378_W)
XE_GPU_REGISTER(0x45EC, kFloat, SHADER_CONSTANT_379_X)
XE_GPU_REGISTER(0x45ED, kFloat, SHADER_CONSTANT_379_Y)
XE_GPU_REGISTER(0x45EE, kFloat, SHADER_CONSTANT_379_Z)
XE_GPU_REGISTER(0x45EF, kFloat, SHADER_CONSTANT_379_W)
XE_GPU_REGISTER(0x45F0, kFloat, SHADER_CONSTANT_380_X)
XE_GPU_REGISTER(0x45F1, kFloat, SHADER_CONSTANT_380_Y)
XE_GPU_REGISTER(0x45F2, kFloat, SHADER_CONSTANT_380_Z)
XE_GPU_REGISTER(0x45F3, kFloat, SHADER_CONSTANT_380_W)
XE_GPU_REGISTER(0x45F4, kFloat, SHADER_CONSTANT_381_X)
XE_GPU_REGISTER(0x45F5, kFloat, SHADER_CONSTANT_381_Y)
XE_GPU_REGISTER(0x45F6, kFloat, SHADER_CONSTANT_381_Z)
XE_GPU_REGISTER(0x45F7, kFloat, SHADER_CONSTANT_381_W)
XE_GPU_REGISTER(0x45F8, kFloat, SHADER_CONSTANT_382_X)
XE_GPU_REGISTER(0x45F9, kFloat, SHADER_CONSTANT_382_Y)
XE_GPU_REGISTER(0x45FA, kFloat, SHADER_CONSTANT_382_Z)
XE_GPU_REGISTER(0x45FB, kFloat, SHADER_CONSTANT_382_W)
XE_GPU_REGISTER(0x45FC, kFloat, SHADER_CONSTANT_383_X)
XE_GPU_REGISTER(0x45FD, kFloat, SHADER_CONSTANT_383_Y)
XE_GPU_REGISTER(0x45FE, kFloat, SHADER_CONSTANT_383_Z)
XE_GPU_REGISTER(0x45FF, kFloat, SHADER_CONSTANT_383_W)
XE_GPU_REGISTER(0x4600, kFloat, SHADER_CONSTANT_384_X)
XE_GPU_REGISTER(0x4601, kFloat, SHADER_CONSTANT_384_Y)
XE_GPU_REGISTER(0x4602, kFloat, SHADER_CONSTANT_384_Z)
XE_GPU_REGISTER(0x4603, kFloat, SHADER_CONSTANT_384_W)
XE_GPU_REGISTER(0x4604, kFloat, SHADER_CONSTANT_385_X)
XE_GPU_REGISTER(0x4605, kFloat, SHADER_CONSTANT_385_Y)
XE_GPU_REGISTER(0x4606, kFloat, SHADER_CONSTANT_385_Z)
XE_GPU_REGISTER(0x4607, kFloat, SHADER_CONSTANT_385_W)
XE_GPU_REGISTER(0x4608, kFloat, SHADER_CONSTANT_386_X)
XE_GPU_REGISTER(0x4609, kFloat, SHADER_CONSTANT_386_Y)
XE_GPU_REGISTER(0x460A, kFloat, SHADER_CONSTANT_386_Z)
XE_GPU_REGISTER(0x460B, kFloat, SHADER_CONSTANT_386_W)
XE_GPU_REGISTER(0x460C, kFloat, SHADER_CONSTANT_387_X)
XE_GPU_REGISTER(0x460D, kFloat, SHADER_CONSTANT_387_Y)
XE_GPU_REGISTER(0x460E, kFloat, SHADER_CONSTANT_387_Z)
XE_GPU_REGISTER(0x460F, kFloat, SHADER_CONSTANT_387_W)
XE_GPU_REGISTER(0x4610, kFloat, SHADER_CONSTANT_388_X)
XE_GPU_REGISTER(0x4611, kFloat, SHADER_CONSTANT_388_Y)
XE_GPU_REGISTER(0x4612, kFloat, SHADER_CONSTANT_388_Z)
XE_GPU_REGISTER(0x4613, kFloat, SHADER_CONSTANT_388_W)
XE_GPU_REGISTER(0x4614, kFloat, SHADER_CONSTANT_389_X)
XE_GPU_REGISTER(0x4615, kFloat, SHADER_CONSTANT_389_Y)
XE_GPU_REGISTER(0x4616, kFloat, SHADER_CONSTANT_389_Z)
XE_GPU_REGISTER(0x4617, kFloat, SHADER_CONSTANT_389_W)
XE_GPU_REGISTER(0x4618, kFloat, SHADER_CONSTANT_390_X)
XE_GPU_REGISTER(0x4619, kFloat, SHADER_CONSTANT_390_Y)
XE_GPU_REGISTER(0x461A, kFloat, SHADER_CONSTANT_390_Z)
XE_GPU_REGISTER(0x461B, kFloat, SHADER_CONSTANT_390_W)
XE_GPU_REGISTER(0x461C, kFloat, SHADER_CONSTANT_391_X)
XE_GPU_REGISTER(0x461D, kFloat, SHADER_CONSTANT_391_Y)
XE_GPU_REGISTER(0x461E, kFloat, SHADER_CONSTANT_391_Z)
XE_GPU_REGISTER(0x461F, kFloat, SHADER_CONSTANT_391_W)
XE_GPU_REGISTER(0x4620, kFloat, SHADER_CONSTANT_392_X)
XE_GPU_REGISTER(0x4621, kFloat, SHADER_CONSTANT_392_Y)
XE_GPU_REGISTER(0x4622, kFloat, SHADER_CONSTANT_392_Z)
XE_GPU_REGISTER(0x4623, kFloat, SHADER_CONSTANT_392_W)
XE_GPU_REGISTER(0x4624, kFloat, SHADER_CONSTANT_393_X)
XE_GPU_REGISTER(0x4625, kFloat, SHADER_CONSTANT_393_Y)
XE_GPU_REGISTER(0x4626, kFloat, SHADER_CONSTANT_393_Z)
XE_GPU_REGISTER(0x4627, kFloat, SHADER_CONSTANT_393_W)
XE_GPU_REGISTER(0x4628, kFloat, SHADER_CONSTANT_394_X)
XE_GPU_REGISTER(0x4629, kFloat, SHADER_CONSTANT_394_Y)
XE_GPU_REGISTER(0x462A, kFloat, SHADER_CONSTANT_394_Z)
XE_GPU_REGISTER(0x462B, kFloat, SHADER_CONSTANT_394_W)
XE_GPU_REGISTER(0x462C, kFloat, SHADER_CONSTANT_395_X)
XE_GPU_REGISTER(0x462D, kFloat, SHADER_CONSTANT_395_Y)
XE_GPU_REGISTER(0x462E, kFloat, SHADER_CONSTANT_395_Z)
XE_GPU_REGISTER(0x462F, kFloat, SHADER_CONSTANT_395_W)
XE_GPU_REGISTER(0x4630, kFloat, SHADER_CONSTANT_396_X)
XE_GPU_REGISTER(0x4631, kFloat, SHADER_CONSTANT_396_Y)
XE_GPU_REGISTER(0x4632, kFloat, SHADER_CONSTANT_396_Z)
XE_GPU_REGISTER(0x4633, kFloat, SHADER_CONSTANT_396_W)
XE_GPU_REGISTER(0x4634, kFloat, SHADER_CONSTANT_397_X)
XE_GPU_REGISTER(0x4635, kFloat, SHADER_CONSTANT_397_Y)
XE_GPU_REGISTER(0x4636, kFloat, SHADER_CONSTANT_397_Z)
XE_GPU_REGISTER(0x4637, kFloat, SHADER_CONSTANT_397_W)
XE_GPU_REGISTER(0x4638, kFloat, SHADER_CONSTANT_398_X)
XE_GPU_REGISTER(0x4639, kFloat, SHADER_CONSTANT_398_Y)
XE_GPU_REGISTER(0x463A, kFloat, SHADER_CONSTANT_398_Z)
XE_GPU_REGISTER(0x463B, kFloat, SHADER_CONSTANT_398_W)
XE_GPU_REGISTER(0x463C, kFloat, SHADER_CONSTANT_399_X)
XE_GPU_REGISTER(0x463D, kFloat, SHADER_CONSTANT_399_Y)
XE_GPU_REGISTER(0x463E, kFloat, SHADER_CONSTANT_399_Z)
XE_GPU_REGISTER(0x463F, kFloat, SHADER_CONSTANT_399_W)
XE_GPU_REGISTER(0x4640, kFloat, SHADER_CONSTANT_400_X)
XE_GPU_REGISTER(0x4641, kFloat, SHADER_CONSTANT_400_Y)
XE_GPU_REGISTER(0x4642, kFloat, SHADER_CONSTANT_400_Z)
XE_GPU_REGISTER(0x4643, kFloat, SHADER_CONSTANT_400_W)
XE_GPU_REGISTER(0x4644, kFloat, SHADER_CONSTANT_401_X)
XE_GPU_REGISTER(0x4645, kFloat, SHADER_CONSTANT_401_Y)
XE_GPU_REGISTER(0x4646, kFloat, SHADER_CONSTANT_401_Z)
XE_GPU_REGISTER(0x4647, kFloat, SHADER_CONSTANT_401_W)
XE_GPU_REGISTER(0x4648, kFloat, SHADER_CONSTANT_402_X)
XE_GPU_REGISTER(0x4649, kFloat, SHADER_CONSTANT_402_Y)
XE_GPU_REGISTER(0x464A, kFloat, SHADER_CONSTANT_402_Z)
XE_GPU_REGISTER(0x464B, kFloat, SHADER_CONSTANT_402_W)
XE_GPU_REGISTER(0x464C, kFloat, SHADER_CONSTANT_403_X)
XE_GPU_REGISTER(0x464D, kFloat, SHADER_CONSTANT_403_Y)
XE_GPU_REGISTER(0x464E, kFloat, SHADER_CONSTANT_403_Z)
XE_GPU_REGISTER(0x464F, kFloat, SHADER_CONSTANT_403_W)
XE_GPU_REGISTER(0x4650, kFloat, SHADER_CONSTANT_404_X)
XE_GPU_REGISTER(0x4651, kFloat, SHADER_CONSTANT_404_Y)
XE_GPU_REGISTER(0x4652, kFloat, SHADER_CONSTANT_404_Z)
XE_GPU_REGISTER(0x4653, kFloat, SHADER_CONSTANT_404_W)
XE_GPU_REGISTER(0x4654, kFloat, SHADER_CONSTANT_405_X)
XE_GPU_REGISTER(0x4655, kFloat, SHADER_CONSTANT_405_Y)
XE_GPU_REGISTER(0x4656, kFloat, SHADER_CONSTANT_405_Z)
XE_GPU_REGISTER(0x4657, kFloat, SHADER_CONSTANT_405_W)
XE_GPU_REGISTER(0x4658, kFloat, SHADER_CONSTANT_406_X)
XE_GPU_REGISTER(0x4659, kFloat, SHADER_CONSTANT_406_Y)
XE_GPU_REGISTER(0x465A, kFloat, SHADER_CONSTANT_406_Z)
XE_GPU_REGISTER(0x465B, kFloat, SHADER_CONSTANT_406_W)
XE_GPU_REGISTER(0x465C, kFloat, SHADER_CONSTANT_407_X)
XE_GPU_REGISTER(0x465D, kFloat, SHADER_CONSTANT_407_Y)
XE_GPU_REGISTER(0x465E, kFloat, SHADER_CONSTANT_407_Z)
XE_GPU_REGISTER(0x465F, kFloat, SHADER_CONSTANT_407_W)
XE_GPU_REGISTER(0x4660, kFloat, SHADER_CONSTANT_408_X)
XE_GPU_REGISTER(0x4661, kFloat, SHADER_CONSTANT_408_Y)
XE_GPU_REGISTER(0x4662, kFloat, SHADER_CONSTANT_408_Z)
XE_GPU_REGISTER(0x4663, kFloat, SHADER_CONSTANT_408_W)
XE_GPU_REGISTER(0x4664, kFloat, SHADER_CONSTANT_409_X)
XE_GPU_REGISTER(0x4665, kFloat, SHADER_CONSTANT_409_Y)
XE_GPU_REGISTER(0x4666, kFloat, SHADER_CONSTANT_409_Z)
XE_GPU_REGISTER(0x4667, kFloat, SHADER_CONSTANT_409_W)
XE_GPU_REGISTER(0x4668, kFloat, SHADER_CONSTANT_410_X)
XE_GPU_REGISTER(0x4669, kFloat, SHADER_CONSTANT_410_Y)
XE_GPU_REGISTER(0x466A, kFloat, SHADER_CONSTANT_410_Z)
XE_GPU_REGISTER(0x466B, kFloat, SHADER_CONSTANT_410_W)
XE_GPU_REGISTER(0x466C, kFloat, SHADER_CONSTANT_411_X)
XE_GPU_REGISTER(0x466D, kFloat, SHADER_CONSTANT_411_Y)
XE_GPU_REGISTER(0x466E, kFloat, SHADER_CONSTANT_411_Z)
XE_GPU_REGISTER(0x466F, kFloat, SHADER_CONSTANT_411_W)
XE_GPU_REGISTER(0x4670, kFloat, SHADER_CONSTANT_412_X)
XE_GPU_REGISTER(0x4671, kFloat, SHADER_CONSTANT_412_Y)
XE_GPU_REGISTER(0x4672, kFloat, SHADER_CONSTANT_412_Z)
XE_GPU_REGISTER(0x4673, kFloat, SHADER_CONSTANT_412_W)
XE_GPU_REGISTER(0x4674, kFloat, SHADER_CONSTANT_413_X)
XE_GPU_REGISTER(0x4675, kFloat, SHADER_CONSTANT_413_Y)
XE_GPU_REGISTER(0x4676, kFloat, SHADER_CONSTANT_413_Z)
XE_GPU_REGISTER(0x4677, kFloat, SHADER_CONSTANT_413_W)
XE_GPU_REGISTER(0x4678, kFloat, SHADER_CONSTANT_414_X)
XE_GPU_REGISTER(0x4679, kFloat, SHADER_CONSTANT_414_Y)
XE_GPU_REGISTER(0x467A, kFloat, SHADER_CONSTANT_414_Z)
XE_GPU_REGISTER(0x467B, kFloat, SHADER_CONSTANT_414_W)
XE_GPU_REGISTER(0x467C, kFloat, SHADER_CONSTANT_415_X)
XE_GPU_REGISTER(0x467D, kFloat, SHADER_CONSTANT_415_Y)
XE_GPU_REGISTER(0x467E, kFloat, SHADER_CONSTANT_415_Z)
XE_GPU_REGISTER(0x467F, kFloat, SHADER_CONSTANT_415_W)
XE_GPU_REGISTER(0x4680, kFloat, SHADER_CONSTANT_416_X)
XE_GPU_REGISTER(0x4681, kFloat, SHADER_CONSTANT_416_Y)
XE_GPU_REGISTER(0x4682, kFloat, SHADER_CONSTANT_416_Z)
XE_GPU_REGISTER(0x4683, kFloat, SHADER_CONSTANT_416_W)
XE_GPU_REGISTER(0x4684, kFloat, SHADER_CONSTANT_417_X)
XE_GPU_REGISTER(0x4685, kFloat, SHADER_CONSTANT_417_Y)
XE_GPU_REGISTER(0x4686, kFloat, SHADER_CONSTANT_417_Z)
XE_GPU_REGISTER(0x4687, kFloat, SHADER_CONSTANT_417_W)
XE_GPU_REGISTER(0x4688, kFloat, SHADER_CONSTANT_418_X)
XE_GPU_REGISTER(0x4689, kFloat, SHADER_CONSTANT_418_Y)
XE_GPU_REGISTER(0x468A, kFloat, SHADER_CONSTANT_418_Z)
XE_GPU_REGISTER(0x468B, kFloat, SHADER_CONSTANT_418_W)
XE_GPU_REGISTER(0x468C, kFloat, SHADER_CONSTANT_419_X)
XE_GPU_REGISTER(0x468D, kFloat, SHADER_CONSTANT_419_Y)
XE_GPU_REGISTER(0x468E, kFloat, SHADER_CONSTANT_419_Z)
XE_GPU_REGISTER(0x468F, kFloat, SHADER_CONSTANT_419_W)
XE_GPU_REGISTER(0x4690, kFloat, SHADER_CONSTANT_420_X)
XE_GPU_REGISTER(0x4691, kFloat, SHADER_CONSTANT_420_Y)
XE_GPU_REGISTER(0x4692, kFloat, SHADER_CONSTANT_420_Z)
XE_GPU_REGISTER(0x4693, kFloat, SHADER_CONSTANT_420_W)
XE_GPU_REGISTER(0x4694, kFloat, SHADER_CONSTANT_421_X)
XE_GPU_REGISTER(0x4695, kFloat, SHADER_CONSTANT_421_Y)
XE_GPU_REGISTER(0x4696, kFloat, SHADER_CONSTANT_421_Z)
XE_GPU_REGISTER(0x4697, kFloat, SHADER_CONSTANT_421_W)
XE_GPU_REGISTER(0x4698, kFloat, SHADER_CONSTANT_422_X)
XE_GPU_REGISTER(0x4699, kFloat, SHADER_CONSTANT_422_Y)
XE_GPU_REGISTER(0x469A, kFloat, SHADER_CONSTANT_422_Z)
XE_GPU_REGISTER(0x469B, kFloat, SHADER_CONSTANT_422_W)
XE_GPU_REGISTER(0x469C, kFloat, SHADER_CONSTANT_423_X)
XE_GPU_REGISTER(0x469D, kFloat, SHADER_CONSTANT_423_Y)
XE_GPU_REGISTER(0x469E, kFloat, SHADER_CONSTANT_423_Z)
XE_GPU_REGISTER(0x469F, kFloat, SHADER_CONSTANT_423_W)
XE_GPU_REGISTER(0x46A0, kFloat, SHADER_CONSTANT_424_X)
XE_GPU_REGISTER(0x46A1, kFloat, SHADER_CONSTANT_424_Y)
XE_GPU_REGISTER(0x46A2, kFloat, SHADER_CONSTANT_424_Z)
XE_GPU_REGISTER(0x46A3, kFloat, SHADER_CONSTANT_424_W)
XE_GPU_REGISTER(0x46A4, kFloat, SHADER_CONSTANT_425_X)
XE_GPU_REGISTER(0x46A5, kFloat, SHADER_CONSTANT_425_Y)
XE_GPU_REGISTER(0x46A6, kFloat, SHADER_CONSTANT_425_Z)
XE_GPU_REGISTER(0x46A7, kFloat, SHADER_CONSTANT_425_W)
XE_GPU_REGISTER(0x46A8, kFloat, SHADER_CONSTANT_426_X)
XE_GPU_REGISTER(0x46A9, kFloat, SHADER_CONSTANT_426_Y)
XE_GPU_REGISTER(0x46AA, kFloat, SHADER_CONSTANT_426_Z)
XE_GPU_REGISTER(0x46AB, kFloat, SHADER_CONSTANT_426_W)
XE_GPU_REGISTER(0x46AC, kFloat, SHADER_CONSTANT_427_X)
XE_GPU_REGISTER(0x46AD, kFloat, SHADER_CONSTANT_427_Y)
XE_GPU_REGISTER(0x46AE, kFloat, SHADER_CONSTANT_427_Z)
XE_GPU_REGISTER(0x46AF, kFloat, SHADER_CONSTANT_427_W)
XE_GPU_REGISTER(0x46B0, kFloat, SHADER_CONSTANT_428_X)
XE_GPU_REGISTER(0x46B1, kFloat, SHADER_CONSTANT_428_Y)
XE_GPU_REGISTER(0x46B2, kFloat, SHADER_CONSTANT_428_Z)
XE_GPU_REGISTER(0x46B3, kFloat, SHADER_CONSTANT_428_W)
XE_GPU_REGISTER(0x46B4, kFloat, SHADER_CONSTANT_429_X)
XE_GPU_REGISTER(0x46B5, kFloat, SHADER_CONSTANT_429_Y)
XE_GPU_REGISTER(0x46B6, kFloat, SHADER_CONSTANT_429_Z)
XE_GPU_REGISTER(0x46B7, kFloat, SHADER_CONSTANT_429_W)
XE_GPU_REGISTER(0x46B8, kFloat, SHADER_CONSTANT_430_X)
XE_GPU_REGISTER(0x46B9, kFloat, SHADER_CONSTANT_430_Y)
XE_GPU_REGISTER(0x46BA, kFloat, SHADER_CONSTANT_430_Z)
XE_GPU_REGISTER(0x46BB, kFloat, SHADER_CONSTANT_430_W)
XE_GPU_REGISTER(0x46BC, kFloat, SHADER_CONSTANT_431_X)
XE_GPU_REGISTER(0x46BD, kFloat, SHADER_CONSTANT_431_Y)
XE_GPU_REGISTER(0x46BE, kFloat, SHADER_CONSTANT_431_Z)
XE_GPU_REGISTER(0x46BF, kFloat, SHADER_CONSTANT_431_W)
XE_GPU_REGISTER(0x46C0, kFloat, SHADER_CONSTANT_432_X)
XE_GPU_REGISTER(0x46C1, kFloat, SHADER_CONSTANT_432_Y)
XE_GPU_REGISTER(0x46C2, kFloat, SHADER_CONSTANT_432_Z)
XE_GPU_REGISTER(0x46C3, kFloat, SHADER_CONSTANT_432_W)
XE_GPU_REGISTER(0x46C4, kFloat, SHADER_CONSTANT_433_X)
XE_GPU_REGISTER(0x46C5, kFloat, SHADER_CONSTANT_433_Y)
XE_GPU_REGISTER(0x46C6, kFloat, SHADER_CONSTANT_433_Z)
XE_GPU_REGISTER(0x46C7, kFloat, SHADER_CONSTANT_433_W)
XE_GPU_REGISTER(0x46C8, kFloat, SHADER_CONSTANT_434_X)
XE_GPU_REGISTER(0x46C9, kFloat, SHADER_CONSTANT_434_Y)
XE_GPU_REGISTER(0x46CA, kFloat, SHADER_CONSTANT_434_Z)
XE_GPU_REGISTER(0x46CB, kFloat, SHADER_CONSTANT_434_W)
XE_GPU_REGISTER(0x46CC, kFloat, SHADER_CONSTANT_435_X)
XE_GPU_REGISTER(0x46CD, kFloat, SHADER_CONSTANT_435_Y)
XE_GPU_REGISTER(0x46CE, kFloat, SHADER_CONSTANT_435_Z)
XE_GPU_REGISTER(0x46CF, kFloat, SHADER_CONSTANT_435_W)
XE_GPU_REGISTER(0x46D0, kFloat, SHADER_CONSTANT_436_X)
XE_GPU_REGISTER(0x46D1, kFloat, SHADER_CONSTANT_436_Y)
XE_GPU_REGISTER(0x46D2, kFloat, SHADER_CONSTANT_436_Z)
XE_GPU_REGISTER(0x46D3, kFloat, SHADER_CONSTANT_436_W)
XE_GPU_REGISTER(0x46D4, kFloat, SHADER_CONSTANT_437_X)
XE_GPU_REGISTER(0x46D5, kFloat, SHADER_CONSTANT_437_Y)
XE_GPU_REGISTER(0x46D6, kFloat, SHADER_CONSTANT_437_Z)
XE_GPU_REGISTER(0x46D7, kFloat, SHADER_CONSTANT_437_W)
XE_GPU_REGISTER(0x46D8, kFloat, SHADER_CONSTANT_438_X)
XE_GPU_REGISTER(0x46D9, kFloat, SHADER_CONSTANT_438_Y)
XE_GPU_REGISTER(0x46DA, kFloat, SHADER_CONSTANT_438_Z)
XE_GPU_REGISTER(0x46DB, kFloat, SHADER_CONSTANT_438_W)
XE_GPU_REGISTER(0x46DC, kFloat, SHADER_CONSTANT_439_X)
XE_GPU_REGISTER(0x46DD, kFloat, SHADER_CONSTANT_439_Y)
XE_GPU_REGISTER(0x46DE, kFloat, SHADER_CONSTANT_439_Z)
XE_GPU_REGISTER(0x46DF, kFloat, SHADER_CONSTANT_439_W)
XE_GPU_REGISTER(0x46E0, kFloat, SHADER_CONSTANT_440_X)
XE_GPU_REGISTER(0x46E1, kFloat, SHADER_CONSTANT_440_Y)
XE_GPU_REGISTER(0x46E2, kFloat, SHADER_CONSTANT_440_Z)
XE_GPU_REGISTER(0x46E3, kFloat, SHADER_CONSTANT_440_W)
XE_GPU_REGISTER(0x46E4, kFloat, SHADER_CONSTANT_441_X)
XE_GPU_REGISTER(0x46E5, kFloat, SHADER_CONSTANT_441_Y)
XE_GPU_REGISTER(0x46E6, kFloat, SHADER_CONSTANT_441_Z)
XE_GPU_REGISTER(0x46E7, kFloat, SHADER_CONSTANT_441_W)
XE_GPU_REGISTER(0x46E8, kFloat, SHADER_CONSTANT_442_X)
XE_GPU_REGISTER(0x46E9, kFloat, SHADER_CONSTANT_442_Y)
XE_GPU_REGISTER(0x46EA, kFloat, SHADER_CONSTANT_442_Z)
XE_GPU_REGISTER(0x46EB, kFloat, SHADER_CONSTANT_442_W)
XE_GPU_REGISTER(0x46EC, kFloat, SHADER_CONSTANT_443_X)
XE_GPU_REGISTER(0x46ED, kFloat, SHADER_CONSTANT_443_Y)
XE_GPU_REGISTER(0x46EE, kFloat, SHADER_CONSTANT_443_Z)
XE_GPU_REGISTER(0x46EF, kFloat, SHADER_CONSTANT_443_W)
XE_GPU_REGISTER(0x46F0, kFloat, SHADER_CONSTANT_444_X)
XE_GPU_REGISTER(0x46F1, kFloat, SHADER_CONSTANT_444_Y)
XE_GPU_REGISTER(0x46F2, kFloat, SHADER_CONSTANT_444_Z)
XE_GPU_REGISTER(0x46F3, kFloat, SHADER_CONSTANT_444_W)
XE_GPU_REGISTER(0x46F4, kFloat, SHADER_CONSTANT_445_X)
XE_GPU_REGISTER(0x46F5, kFloat, SHADER_CONSTANT_445_Y)
XE_GPU_REGISTER(0x46F6, kFloat, SHADER_CONSTANT_445_Z)
XE_GPU_REGISTER(0x46F7, kFloat, SHADER_CONSTANT_445_W)
XE_GPU_REGISTER(0x46F8, kFloat, SHADER_CONSTANT_446_X)
XE_GPU_REGISTER(0x46F9, kFloat, SHADER_CONSTANT_446_Y)
XE_GPU_REGISTER(0x46FA, kFloat, SHADER_CONSTANT_446_Z)
XE_GPU_REGISTER(0x46FB, kFloat, SHADER_CONSTANT_446_W)
XE_GPU_REGISTER(0x46FC, kFloat, SHADER_CONSTANT_447_X)
XE_GPU_REGISTER(0x46FD, kFloat, SHADER_CONSTANT_447_Y)
XE_GPU_REGISTER(0x46FE, kFloat, SHADER_CONSTANT_447_Z)
XE_GPU_REGISTER(0x46FF, kFloat, SHADER_CONSTANT_447_W)
XE_GPU_REGISTER(0x4700, kFloat, SHADER_CONSTANT_448_X)
XE_GPU_REGISTER(0x4701, kFloat, SHADER_CONSTANT_448_Y)
XE_GPU_REGISTER(0x4702, kFloat, SHADER_CONSTANT_448_Z)
XE_GPU_REGISTER(0x4703, kFloat, SHADER_CONSTANT_448_W)
XE_GPU_REGISTER(0x4704, kFloat, SHADER_CONSTANT_449_X)
XE_GPU_REGISTER(0x4705, kFloat, SHADER_CONSTANT_449_Y)
XE_GPU_REGISTER(0x4706, kFloat, SHADER_CONSTANT_449_Z)
XE_GPU_REGISTER(0x4707, kFloat, SHADER_CONSTANT_449_W)
XE_GPU_REGISTER(0x4708, kFloat, SHADER_CONSTANT_450_X)
XE_GPU_REGISTER(0x4709, kFloat, SHADER_CONSTANT_450_Y)
XE_GPU_REGISTER(0x470A, kFloat, SHADER_CONSTANT_450_Z)
XE_GPU_REGISTER(0x470B, kFloat, SHADER_CONSTANT_450_W)
XE_GPU_REGISTER(0x470C, kFloat, SHADER_CONSTANT_451_X)
XE_GPU_REGISTER(0x470D, kFloat, SHADER_CONSTANT_451_Y)
XE_GPU_REGISTER(0x470E, kFloat, SHADER_CONSTANT_451_Z)
XE_GPU_REGISTER(0x470F, kFloat, SHADER_CONSTANT_451_W)
XE_GPU_REGISTER(0x4710, kFloat, SHADER_CONSTANT_452_X)
XE_GPU_REGISTER(0x4711, kFloat, SHADER_CONSTANT_452_Y)
XE_GPU_REGISTER(0x4712, kFloat, SHADER_CONSTANT_452_Z)
XE_GPU_REGISTER(0x4713, kFloat, SHADER_CONSTANT_452_W)
XE_GPU_REGISTER(0x4714, kFloat, SHADER_CONSTANT_453_X)
XE_GPU_REGISTER(0x4715, kFloat, SHADER_CONSTANT_453_Y)
XE_GPU_REGISTER(0x4716, kFloat, SHADER_CONSTANT_453_Z)
XE_GPU_REGISTER(0x4717, kFloat, SHADER_CONSTANT_453_W)
XE_GPU_REGISTER(0x4718, kFloat, SHADER_CONSTANT_454_X)
XE_GPU_REGISTER(0x4719, kFloat, SHADER_CONSTANT_454_Y)
XE_GPU_REGISTER(0x471A, kFloat, SHADER_CONSTANT_454_Z)
XE_GPU_REGISTER(0x471B, kFloat, SHADER_CONSTANT_454_W)
XE_GPU_REGISTER(0x471C, kFloat, SHADER_CONSTANT_455_X)
XE_GPU_REGISTER(0x471D, kFloat, SHADER_CONSTANT_455_Y)
XE_GPU_REGISTER(0x471E, kFloat, SHADER_CONSTANT_455_Z)
XE_GPU_REGISTER(0x471F, kFloat, SHADER_CONSTANT_455_W)
XE_GPU_REGISTER(0x4720, kFloat, SHADER_CONSTANT_456_X)
XE_GPU_REGISTER(0x4721, kFloat, SHADER_CONSTANT_456_Y)
XE_GPU_REGISTER(0x4722, kFloat, SHADER_CONSTANT_456_Z)
XE_GPU_REGISTER(0x4723, kFloat, SHADER_CONSTANT_456_W)
XE_GPU_REGISTER(0x4724, kFloat, SHADER_CONSTANT_457_X)
XE_GPU_REGISTER(0x4725, kFloat, SHADER_CONSTANT_457_Y)
XE_GPU_REGISTER(0x4726, kFloat, SHADER_CONSTANT_457_Z)
XE_GPU_REGISTER(0x4727, kFloat, SHADER_CONSTANT_457_W)
XE_GPU_REGISTER(0x4728, kFloat, SHADER_CONSTANT_458_X)
XE_GPU_REGISTER(0x4729, kFloat, SHADER_CONSTANT_458_Y)
XE_GPU_REGISTER(0x472A, kFloat, SHADER_CONSTANT_458_Z)
XE_GPU_REGISTER(0x472B, kFloat, SHADER_CONSTANT_458_W)
XE_GPU_REGISTER(0x472C, kFloat, SHADER_CONSTANT_459_X)
XE_GPU_REGISTER(0x472D, kFloat, SHADER_CONSTANT_459_Y)
XE_GPU_REGISTER(0x472E, kFloat, SHADER_CONSTANT_459_Z)
XE_GPU_REGISTER(0x472F, kFloat, SHADER_CONSTANT_459_W)
XE_GPU_REGISTER(0x4730, kFloat, SHADER_CONSTANT_460_X)
XE_GPU_REGISTER(0x4731, kFloat, SHADER_CONSTANT_460_Y)
XE_GPU_REGISTER(0x4732, kFloat, SHADER_CONSTANT_460_Z)
XE_GPU_REGISTER(0x4733, kFloat, SHADER_CONSTANT_460_W)
XE_GPU_REGISTER(0x4734, kFloat, SHADER_CONSTANT_461_X)
XE_GPU_REGISTER(0x4735, kFloat, SHADER_CONSTANT_461_Y)
XE_GPU_REGISTER(0x4736, kFloat, SHADER_CONSTANT_461_Z)
XE_GPU_REGISTER(0x4737, kFloat, SHADER_CONSTANT_461_W)
XE_GPU_REGISTER(0x4738, kFloat, SHADER_CONSTANT_462_X)
XE_GPU_REGISTER(0x4739, kFloat, SHADER_CONSTANT_462_Y)
XE_GPU_REGISTER(0x473A, kFloat, SHADER_CONSTANT_462_Z)
XE_GPU_REGISTER(0x473B, kFloat, SHADER_CONSTANT_462_W)
XE_GPU_REGISTER(0x473C, kFloat, SHADER_CONSTANT_463_X)
XE_GPU_REGISTER(0x473D, kFloat, SHADER_CONSTANT_463_Y)
XE_GPU_REGISTER(0x473E, kFloat, SHADER_CONSTANT_463_Z)
XE_GPU_REGISTER(0x473F, kFloat, SHADER_CONSTANT_463_W)
XE_GPU_REGISTER(0x4740, kFloat, SHADER_CONSTANT_464_X)
XE_GPU_REGISTER(0x4741, kFloat, SHADER_CONSTANT_464_Y)
XE_GPU_REGISTER(0x4742, kFloat, SHADER_CONSTANT_464_Z)
XE_GPU_REGISTER(0x4743, kFloat, SHADER_CONSTANT_464_W)
XE_GPU_REGISTER(0x4744, kFloat, SHADER_CONSTANT_465_X)
XE_GPU_REGISTER(0x4745, kFloat, SHADER_CONSTANT_465_Y)
XE_GPU_REGISTER(0x4746, kFloat, SHADER_CONSTANT_465_Z)
XE_GPU_REGISTER(0x4747, kFloat, SHADER_CONSTANT_465_W)
XE_GPU_REGISTER(0x4748, kFloat, SHADER_CONSTANT_466_X)
XE_GPU_REGISTER(0x4749, kFloat, SHADER_CONSTANT_466_Y)
XE_GPU_REGISTER(0x474A, kFloat, SHADER_CONSTANT_466_Z)
XE_GPU_REGISTER(0x474B, kFloat, SHADER_CONSTANT_466_W)
XE_GPU_REGISTER(0x474C, kFloat, SHADER_CONSTANT_467_X)
XE_GPU_REGISTER(0x474D, kFloat, SHADER_CONSTANT_467_Y)
XE_GPU_REGISTER(0x474E, kFloat, SHADER_CONSTANT_467_Z)
XE_GPU_REGISTER(0x474F, kFloat, SHADER_CONSTANT_467_W)
XE_GPU_REGISTER(0x4750, kFloat, SHADER_CONSTANT_468_X)
XE_GPU_REGISTER(0x4751, kFloat, SHADER_CONSTANT_468_Y)
XE_GPU_REGISTER(0x4752, kFloat, SHADER_CONSTANT_468_Z)
XE_GPU_REGISTER(0x4753, kFloat, SHADER_CONSTANT_468_W)
XE_GPU_REGISTER(0x4754, kFloat, SHADER_CONSTANT_469_X)
XE_GPU_REGISTER(0x4755, kFloat, SHADER_CONSTANT_469_Y)
XE_GPU_REGISTER(0x4756, kFloat, SHADER_CONSTANT_469_Z)
XE_GPU_REGISTER(0x4757, kFloat, SHADER_CONSTANT_469_W)
XE_GPU_REGISTER(0x4758, kFloat, SHADER_CONSTANT_470_X)
XE_GPU_REGISTER(0x4759, kFloat, SHADER_CONSTANT_470_Y)
XE_GPU_REGISTER(0x475A, kFloat, SHADER_CONSTANT_470_Z)
XE_GPU_REGISTER(0x475B, kFloat, SHADER_CONSTANT_470_W)
XE_GPU_REGISTER(0x475C, kFloat, SHADER_CONSTANT_471_X)
XE_GPU_REGISTER(0x475D, kFloat, SHADER_CONSTANT_471_Y)
XE_GPU_REGISTER(0x475E, kFloat, SHADER_CONSTANT_471_Z)
XE_GPU_REGISTER(0x475F, kFloat, SHADER_CONSTANT_471_W)
XE_GPU_REGISTER(0x4760, kFloat, SHADER_CONSTANT_472_X)
XE_GPU_REGISTER(0x4761, kFloat, SHADER_CONSTANT_472_Y)
XE_GPU_REGISTER(0x4762, kFloat, SHADER_CONSTANT_472_Z)
XE_GPU_REGISTER(0x4763, kFloat, SHADER_CONSTANT_472_W)
XE_GPU_REGISTER(0x4764, kFloat, SHADER_CONSTANT_473_X)
XE_GPU_REGISTER(0x4765, kFloat, SHADER_CONSTANT_473_Y)
XE_GPU_REGISTER(0x4766, kFloat, SHADER_CONSTANT_473_Z)
XE_GPU_REGISTER(0x4767, kFloat, SHADER_CONSTANT_473_W)
XE_GPU_REGISTER(0x4768, kFloat, SHADER_CONSTANT_474_X)
XE_GPU_REGISTER(0x4769, kFloat, SHADER_CONSTANT_474_Y)
XE_GPU_REGISTER(0x476A, kFloat, SHADER_CONSTANT_474_Z)
XE_GPU_REGISTER(0x476B, kFloat, SHADER_CONSTANT_474_W)
XE_GPU_REGISTER(0x476C, kFloat, SHADER_CONSTANT_475_X)
XE_GPU_REGISTER(0x476D, kFloat, SHADER_CONSTANT_475_Y)
XE_GPU_REGISTER(0x476E, kFloat, SHADER_CONSTANT_475_Z)
XE_GPU_REGISTER(0x476F, kFloat, SHADER_CONSTANT_475_W)
XE_GPU_REGISTER(0x4770, kFloat, SHADER_CONSTANT_476_X)
XE_GPU_REGISTER(0x4771, kFloat, SHADER_CONSTANT_476_Y)
XE_GPU_REGISTER(0x4772, kFloat, SHADER_CONSTANT_476_Z)
XE_GPU_REGISTER(0x4773, kFloat, SHADER_CONSTANT_476_W)
XE_GPU_REGISTER(0x4774, kFloat, SHADER_CONSTANT_477_X)
XE_GPU_REGISTER(0x4775, kFloat, SHADER_CONSTANT_477_Y)
XE_GPU_REGISTER(0x4776, kFloat, SHADER_CONSTANT_477_Z)
XE_GPU_REGISTER(0x4777, kFloat, SHADER_CONSTANT_477_W)
XE_GPU_REGISTER(0x4778, kFloat, SHADER_CONSTANT_478_X)
XE_GPU_REGISTER(0x4779, kFloat, SHADER_CONSTANT_478_Y)
XE_GPU_REGISTER(0x477A, kFloat, SHADER_CONSTANT_478_Z)
XE_GPU_REGISTER(0x477B, kFloat, SHADER_CONSTANT_478_W)
XE_GPU_REGISTER(0x477C, kFloat, SHADER_CONSTANT_479_X)
XE_GPU_REGISTER(0x477D, kFloat, SHADER_CONSTANT_479_Y)
XE_GPU_REGISTER(0x477E, kFloat, SHADER_CONSTANT_479_Z)
XE_GPU_REGISTER(0x477F, kFloat, SHADER_CONSTANT_479_W)
XE_GPU_REGISTER(0x4780, kFloat, SHADER_CONSTANT_480_X)
XE_GPU_REGISTER(0x4781, kFloat, SHADER_CONSTANT_480_Y)
XE_GPU_REGISTER(0x4782, kFloat, SHADER_CONSTANT_480_Z)
XE_GPU_REGISTER(0x4783, kFloat, SHADER_CONSTANT_480_W)
XE_GPU_REGISTER(0x4784, kFloat, SHADER_CONSTANT_481_X)
XE_GPU_REGISTER(0x4785, kFloat, SHADER_CONSTANT_481_Y)
XE_GPU_REGISTER(0x4786, kFloat, SHADER_CONSTANT_481_Z)
XE_GPU_REGISTER(0x4787, kFloat, SHADER_CONSTANT_481_W)
XE_GPU_REGISTER(0x4788, kFloat, SHADER_CONSTANT_482_X)
XE_GPU_REGISTER(0x4789, kFloat, SHADER_CONSTANT_482_Y)
XE_GPU_REGISTER(0x478A, kFloat, SHADER_CONSTANT_482_Z)
XE_GPU_REGISTER(0x478B, kFloat, SHADER_CONSTANT_482_W)
XE_GPU_REGISTER(0x478C, kFloat, SHADER_CONSTANT_483_X)
XE_GPU_REGISTER(0x478D, kFloat, SHADER_CONSTANT_483_Y)
XE_GPU_REGISTER(0x478E, kFloat, SHADER_CONSTANT_483_Z)
XE_GPU_REGISTER(0x478F, kFloat, SHADER_CONSTANT_483_W)
XE_GPU_REGISTER(0x4790, kFloat, SHADER_CONSTANT_484_X)
XE_GPU_REGISTER(0x4791, kFloat, SHADER_CONSTANT_484_Y)
XE_GPU_REGISTER(0x4792, kFloat, SHADER_CONSTANT_484_Z)
XE_GPU_REGISTER(0x4793, kFloat, SHADER_CONSTANT_484_W)
XE_GPU_REGISTER(0x4794, kFloat, SHADER_CONSTANT_485_X)
XE_GPU_REGISTER(0x4795, kFloat, SHADER_CONSTANT_485_Y)
XE_GPU_REGISTER(0x4796, kFloat, SHADER_CONSTANT_485_Z)
XE_GPU_REGISTER(0x4797, kFloat, SHADER_CONSTANT_485_W)
XE_GPU_REGISTER(0x4798, kFloat, SHADER_CONSTANT_486_X)
XE_GPU_REGISTER(0x4799, kFloat, SHADER_CONSTANT_486_Y)
XE_GPU_REGISTER(0x479A, kFloat, SHADER_CONSTANT_486_Z)
XE_GPU_REGISTER(0x479B, kFloat, SHADER_CONSTANT_486_W)
XE_GPU_REGISTER(0x479C, kFloat, SHADER_CONSTANT_487_X)
XE_GPU_REGISTER(0x479D, kFloat, SHADER_CONSTANT_487_Y)
XE_GPU_REGISTER(0x479E, kFloat, SHADER_CONSTANT_487_Z)
XE_GPU_REGISTER(0x479F, kFloat, SHADER_CONSTANT_487_W)
XE_GPU_REGISTER(0x47A0, kFloat, SHADER_CONSTANT_488_X)
XE_GPU_REGISTER(0x47A1, kFloat, SHADER_CONSTANT_488_Y)
XE_GPU_REGISTER(0x47A2, kFloat, SHADER_CONSTANT_488_Z)
XE_GPU_REGISTER(0x47A3, kFloat, SHADER_CONSTANT_488_W)
XE_GPU_REGISTER(0x47A4, kFloat, SHADER_CONSTANT_489_X)
XE_GPU_REGISTER(0x47A5, kFloat, SHADER_CONSTANT_489_Y)
XE_GPU_REGISTER(0x47A6, kFloat, SHADER_CONSTANT_489_Z)
XE_GPU_REGISTER(0x47A7, kFloat, SHADER_CONSTANT_489_W)
XE_GPU_REGISTER(0x47A8, kFloat, SHADER_CONSTANT_490_X)
XE_GPU_REGISTER(0x47A9, kFloat, SHADER_CONSTANT_490_Y)
XE_GPU_REGISTER(0x47AA, kFloat, SHADER_CONSTANT_490_Z)
XE_GPU_REGISTER(0x47AB, kFloat, SHADER_CONSTANT_490_W)
XE_GPU_REGISTER(0x47AC, kFloat, SHADER_CONSTANT_491_X)
XE_GPU_REGISTER(0x47AD, kFloat, SHADER_CONSTANT_491_Y)
XE_GPU_REGISTER(0x47AE, kFloat, SHADER_CONSTANT_491_Z)
XE_GPU_REGISTER(0x47AF, kFloat, SHADER_CONSTANT_491_W)
XE_GPU_REGISTER(0x47B0, kFloat, SHADER_CONSTANT_492_X)
XE_GPU_REGISTER(0x47B1, kFloat, SHADER_CONSTANT_492_Y)
XE_GPU_REGISTER(0x47B2, kFloat, SHADER_CONSTANT_492_Z)
XE_GPU_REGISTER(0x47B3, kFloat, SHADER_CONSTANT_492_W)
XE_GPU_REGISTER(0x47B4, kFloat, SHADER_CONSTANT_493_X)
XE_GPU_REGISTER(0x47B5, kFloat, SHADER_CONSTANT_493_Y)
XE_GPU_REGISTER(0x47B6, kFloat, SHADER_CONSTANT_493_Z)
XE_GPU_REGISTER(0x47B7, kFloat, SHADER_CONSTANT_493_W)
XE_GPU_REGISTER(0x47B8, kFloat, SHADER_CONSTANT_494_X)
XE_GPU_REGISTER(0x47B9, kFloat, SHADER_CONSTANT_494_Y)
XE_GPU_REGISTER(0x47BA, kFloat, SHADER_CONSTANT_494_Z)
XE_GPU_REGISTER(0x47BB, kFloat, SHADER_CONSTANT_494_W)
XE_GPU_REGISTER(0x47BC, kFloat, SHADER_CONSTANT_495_X)
XE_GPU_REGISTER(0x47BD, kFloat, SHADER_CONSTANT_495_Y)
XE_GPU_REGISTER(0x47BE, kFloat, SHADER_CONSTANT_495_Z)
XE_GPU_REGISTER(0x47BF, kFloat, SHADER_CONSTANT_495_W)
XE_GPU_REGISTER(0x47C0, kFloat, SHADER_CONSTANT_496_X)
XE_GPU_REGISTER(0x47C1, kFloat, SHADER_CONSTANT_496_Y)
XE_GPU_REGISTER(0x47C2, kFloat, SHADER_CONSTANT_496_Z)
XE_GPU_REGISTER(0x47C3, kFloat, SHADER_CONSTANT_496_W)
XE_GPU_REGISTER(0x47C4, kFloat, SHADER_CONSTANT_497_X)
XE_GPU_REGISTER(0x47C5, kFloat, SHADER_CONSTANT_497_Y)
XE_GPU_REGISTER(0x47C6, kFloat, SHADER_CONSTANT_497_Z)
XE_GPU_REGISTER(0x47C7, kFloat, SHADER_CONSTANT_497_W)
XE_GPU_REGISTER(0x47C8, kFloat, SHADER_CONSTANT_498_X)
XE_GPU_REGISTER(0x47C9, kFloat, SHADER_CONSTANT_498_Y)
XE_GPU_REGISTER(0x47CA, kFloat, SHADER_CONSTANT_498_Z)
XE_GPU_REGISTER(0x47CB, kFloat, SHADER_CONSTANT_498_W)
XE_GPU_REGISTER(0x47CC, kFloat, SHADER_CONSTANT_499_X)
XE_GPU_REGISTER(0x47CD, kFloat, SHADER_CONSTANT_499_Y)
XE_GPU_REGISTER(0x47CE, kFloat, SHADER_CONSTANT_499_Z)
XE_GPU_REGISTER(0x47CF, kFloat, SHADER_CONSTANT_499_W)
XE_GPU_REGISTER(0x47D0, kFloat, SHADER_CONSTANT_500_X)
XE_GPU_REGISTER(0x47D1, kFloat, SHADER_CONSTANT_500_Y)
XE_GPU_REGISTER(0x47D2, kFloat, SHADER_CONSTANT_500_Z)
XE_GPU_REGISTER(0x47D3, kFloat, SHADER_CONSTANT_500_W)
XE_GPU_REGISTER(0x47D4, kFloat, SHADER_CONSTANT_501_X)
XE_GPU_REGISTER(0x47D5, kFloat, SHADER_CONSTANT_501_Y)
XE_GPU_REGISTER(0x47D6, kFloat, SHADER_CONSTANT_501_Z)
XE_GPU_REGISTER(0x47D7, kFloat, SHADER_CONSTANT_501_W)
XE_GPU_REGISTER(0x47D8, kFloat, SHADER_CONSTANT_502_X)
XE_GPU_REGISTER(0x47D9, kFloat, SHADER_CONSTANT_502_Y)
XE_GPU_REGISTER(0x47DA, kFloat, SHADER_CONSTANT_502_Z)
XE_GPU_REGISTER(0x47DB, kFloat, SHADER_CONSTANT_502_W)
XE_GPU_REGISTER(0x47DC, kFloat, SHADER_CONSTANT_503_X)
XE_GPU_REGISTER(0x47DD, kFloat, SHADER_CONSTANT_503_Y)
XE_GPU_REGISTER(0x47DE, kFloat, SHADER_CONSTANT_503_Z)
XE_GPU_REGISTER(0x47DF, kFloat, SHADER_CONSTANT_503_W)
XE_GPU_REGISTER(0x47E0, kFloat, SHADER_CONSTANT_504_X)
XE_GPU_REGISTER(0x47E1, kFloat, SHADER_CONSTANT_504_Y)
XE_GPU_REGISTER(0x47E2, kFloat, SHADER_CONSTANT_504_Z)
XE_GPU_REGISTER(0x47E3, kFloat, SHADER_CONSTANT_504_W)
XE_GPU_REGISTER(0x47E4, kFloat, SHADER_CONSTANT_505_X)
XE_GPU_REGISTER(0x47E5, kFloat, SHADER_CONSTANT_505_Y)
XE_GPU_REGISTER(0x47E6, kFloat, SHADER_CONSTANT_505_Z)
XE_GPU_REGISTER(0x47E7, kFloat, SHADER_CONSTANT_505_W)
XE_GPU_REGISTER(0x47E8, kFloat, SHADER_CONSTANT_506_X)
XE_GPU_REGISTER(0x47E9, kFloat, SHADER_CONSTANT_506_Y)
XE_GPU_REGISTER(0x47EA, kFloat, SHADER_CONSTANT_506_Z)
XE_GPU_REGISTER(0x47EB, kFloat, SHADER_CONSTANT_506_W)
XE_GPU_REGISTER(0x47EC, kFloat, SHADER_CONSTANT_507_X)
XE_GPU_REGISTER(0x47ED, kFloat, SHADER_CONSTANT_507_Y)
XE_GPU_REGISTER(0x47EE, kFloat, SHADER_CONSTANT_507_Z)
XE_GPU_REGISTER(0x47EF, kFloat, SHADER_CONSTANT_507_W)
XE_GPU_REGISTER(0x47F0, kFloat, SHADER_CONSTANT_508_X)
XE_GPU_REGISTER(0x47F1, kFloat, SHADER_CONSTANT_508_Y)
XE_GPU_REGISTER(0x47F2, kFloat, SHADER_CONSTANT_508_Z)
XE_GPU_REGISTER(0x47F3, kFloat, SHADER_CONSTANT_508_W)
XE_GPU_REGISTER(0x47F4, kFloat, SHADER_CONSTANT_509_X)
XE_GPU_REGISTER(0x47F5, kFloat, SHADER_CONSTANT_509_Y)
XE_GPU_REGISTER(0x47F6, kFloat, SHADER_CONSTANT_509_Z)
XE_GPU_REGISTER(0x47F7, kFloat, SHADER_CONSTANT_509_W)
XE_GPU_REGISTER(0x47F8, kFloat, SHADER_CONSTANT_510_X)
XE_GPU_REGISTER(0x47F9, kFloat, SHADER_CONSTANT_510_Y)
XE_GPU_REGISTER(0x47FA, kFloat, SHADER_CONSTANT_510_Z)
XE_GPU_REGISTER(0x47FB, kFloat, SHADER_CONSTANT_510_W)
XE_GPU_REGISTER(0x47FC, kFloat, SHADER_CONSTANT_511_X)
XE_GPU_REGISTER(0x47FD, kFloat, SHADER_CONSTANT_511_Y)
XE_GPU_REGISTER(0x47FE, kFloat, SHADER_CONSTANT_511_Z)
XE_GPU_REGISTER(0x47FF, kFloat, SHADER_CONSTANT_511_W)

XE_GPU_REGISTER(0x4800, kDword, SHADER_CONSTANT_FETCH_00_0)
XE_GPU_REGISTER(0x4801, kDword, SHADER_CONSTANT_FETCH_00_1)
XE_GPU_REGISTER(0x4802, kDword, SHADER_CONSTANT_FETCH_00_2)
XE_GPU_REGISTER(0x4803, kDword, SHADER_CONSTANT_FETCH_00_3)
XE_GPU_REGISTER(0x4804, kDword, SHADER_CONSTANT_FETCH_00_4)
XE_GPU_REGISTER(0x4805, kDword, SHADER_CONSTANT_FETCH_00_5)
XE_GPU_REGISTER(0x4806, kDword, SHADER_CONSTANT_FETCH_01_0)
XE_GPU_REGISTER(0x4807, kDword, SHADER_CONSTANT_FETCH_01_1)
XE_GPU_REGISTER(0x4808, kDword, SHADER_CONSTANT_FETCH_01_2)
XE_GPU_REGISTER(0x4809, kDword, SHADER_CONSTANT_FETCH_01_3)
XE_GPU_REGISTER(0x480A, kDword, SHADER_CONSTANT_FETCH_01_4)
XE_GPU_REGISTER(0x480B, kDword, SHADER_CONSTANT_FETCH_01_5)
XE_GPU_REGISTER(0x480C, kDword, SHADER_CONSTANT_FETCH_02_0)
XE_GPU_REGISTER(0x480D, kDword, SHADER_CONSTANT_FETCH_02_1)
XE_GPU_REGISTER(0x480E, kDword, SHADER_CONSTANT_FETCH_02_2)
XE_GPU_REGISTER(0x480F, kDword, SHADER_CONSTANT_FETCH_02_3)
XE_GPU_REGISTER(0x4810, kDword, SHADER_CONSTANT_FETCH_02_4)
XE_GPU_REGISTER(0x4811, kDword, SHADER_CONSTANT_FETCH_02_5)
XE_GPU_REGISTER(0x4812, kDword, SHADER_CONSTANT_FETCH_03_0)
XE_GPU_REGISTER(0x4813, kDword, SHADER_CONSTANT_FETCH_03_1)
XE_GPU_REGISTER(0x4814, kDword, SHADER_CONSTANT_FETCH_03_2)
XE_GPU_REGISTER(0x4815, kDword, SHADER_CONSTANT_FETCH_03_3)
XE_GPU_REGISTER(0x4816, kDword, SHADER_CONSTANT_FETCH_03_4)
XE_GPU_REGISTER(0x4817, kDword, SHADER_CONSTANT_FETCH_03_5)
XE_GPU_REGISTER(0x4818, kDword, SHADER_CONSTANT_FETCH_04_0)
XE_GPU_REGISTER(0x4819, kDword, SHADER_CONSTANT_FETCH_04_1)
XE_GPU_REGISTER(0x481A, kDword, SHADER_CONSTANT_FETCH_04_2)
XE_GPU_REGISTER(0x481B, kDword, SHADER_CONSTANT_FETCH_04_3)
XE_GPU_REGISTER(0x481C, kDword, SHADER_CONSTANT_FETCH_04_4)
XE_GPU_REGISTER(0x481D, kDword, SHADER_CONSTANT_FETCH_04_5)
XE_GPU_REGISTER(0x481E, kDword, SHADER_CONSTANT_FETCH_05_0)
XE_GPU_REGISTER(0x481F, kDword, SHADER_CONSTANT_FETCH_05_1)
XE_GPU_REGISTER(0x4820, kDword, SHADER_CONSTANT_FETCH_05_2)
XE_GPU_REGISTER(0x4821, kDword, SHADER_CONSTANT_FETCH_05_3)
XE_GPU_REGISTER(0x4822, kDword, SHADER_CONSTANT_FETCH_05_4)
XE_GPU_REGISTER(0x4823, kDword, SHADER_CONSTANT_FETCH_05_5)
XE_GPU_REGISTER(0x4824, kDword, SHADER_CONSTANT_FETCH_06_0)
XE_GPU_REGISTER(0x4825, kDword, SHADER_CONSTANT_FETCH_06_1)
XE_GPU_REGISTER(0x4826, kDword, SHADER_CONSTANT_FETCH_06_2)
XE_GPU_REGISTER(0x4827, kDword, SHADER_CONSTANT_FETCH_06_3)
XE_GPU_REGISTER(0x4828, kDword, SHADER_CONSTANT_FETCH_06_4)
XE_GPU_REGISTER(0x4829, kDword, SHADER_CONSTANT_FETCH_06_5)
XE_GPU_REGISTER(0x482A, kDword, SHADER_CONSTANT_FETCH_07_0)
XE_GPU_REGISTER(0x482B, kDword, SHADER_CONSTANT_FETCH_07_1)
XE_GPU_REGISTER(0x482C, kDword, SHADER_CONSTANT_FETCH_07_2)
XE_GPU_REGISTER(0x482D, kDword, SHADER_CONSTANT_FETCH_07_3)
XE_GPU_REGISTER(0x482E, kDword, SHADER_CONSTANT_FETCH_07_4)
XE_GPU_REGISTER(0x482F, kDword, SHADER_CONSTANT_FETCH_07_5)
XE_GPU_REGISTER(0x4830, kDword, SHADER_CONSTANT_FETCH_08_0)
XE_GPU_REGISTER(0x4831, kDword, SHADER_CONSTANT_FETCH_08_1)
XE_GPU_REGISTER(0x4832, kDword, SHADER_CONSTANT_FETCH_08_2)
XE_GPU_REGISTER(0x4833, kDword, SHADER_CONSTANT_FETCH_08_3)
XE_GPU_REGISTER(0x4834, kDword, SHADER_CONSTANT_FETCH_08_4)
XE_GPU_REGISTER(0x4835, kDword, SHADER_CONSTANT_FETCH_08_5)
XE_GPU_REGISTER(0x4836, kDword, SHADER_CONSTANT_FETCH_09_0)
XE_GPU_REGISTER(0x4837, kDword, SHADER_CONSTANT_FETCH_09_1)
XE_GPU_REGISTER(0x4838, kDword, SHADER_CONSTANT_FETCH_09_2)
XE_GPU_REGISTER(0x4839, kDword, SHADER_CONSTANT_FETCH_09_3)
XE_GPU_REGISTER(0x483A, kDword, SHADER_CONSTANT_FETCH_09_4)
XE_GPU_REGISTER(0x483B, kDword, SHADER_CONSTANT_FETCH_09_5)
XE_GPU_REGISTER(0x483C, kDword, SHADER_CONSTANT_FETCH_10_0)
XE_GPU_REGISTER(0x483D, kDword, SHADER_CONSTANT_FETCH_10_1)
XE_GPU_REGISTER(0x483E, kDword, SHADER_CONSTANT_FETCH_10_2)
XE_GPU_REGISTER(0x483F, kDword, SHADER_CONSTANT_FETCH_10_3)
XE_GPU_REGISTER(0x4840, kDword, SHADER_CONSTANT_FETCH_10_4)
XE_GPU_REGISTER(0x4841, kDword, SHADER_CONSTANT_FETCH_10_5)
XE_GPU_REGISTER(0x4842, kDword, SHADER_CONSTANT_FETCH_11_0)
XE_GPU_REGISTER(0x4843, kDword, SHADER_CONSTANT_FETCH_11_1)
XE_GPU_REGISTER(0x4844, kDword, SHADER_CONSTANT_FETCH_11_2)
XE_GPU_REGISTER(0x4845, kDword, SHADER_CONSTANT_FETCH_11_3)
XE_GPU_REGISTER(0x4846, kDword, SHADER_CONSTANT_FETCH_11_4)
XE_GPU_REGISTER(0x4847, kDword, SHADER_CONSTANT_FETCH_11_5)
XE_GPU_REGISTER(0x4848, kDword, SHADER_CONSTANT_FETCH_12_0)
XE_GPU_REGISTER(0x4849, kDword, SHADER_CONSTANT_FETCH_12_1)
XE_GPU_REGISTER(0x484A, kDword, SHADER_CONSTANT_FETCH_12_2)
XE_GPU_REGISTER(0x484B, kDword, SHADER_CONSTANT_FETCH_12_3)
XE_GPU_REGISTER(0x484C, kDword, SHADER_CONSTANT_FETCH_12_4)
XE_GPU_REGISTER(0x484D, kDword, SHADER_CONSTANT_FETCH_12_5)
XE_GPU_REGISTER(0x484E, kDword, SHADER_CONSTANT_FETCH_13_0)
XE_GPU_REGISTER(0x484F, kDword, SHADER_CONSTANT_FETCH_13_1)
XE_GPU_REGISTER(0x4850, kDword, SHADER_CONSTANT_FETCH_13_2)
XE_GPU_REGISTER(0x4851, kDword, SHADER_CONSTANT_FETCH_13_3)
XE_GPU_REGISTER(0x4852, kDword, SHADER_CONSTANT_FETCH_13_4)
XE_GPU_REGISTER(0x4853, kDword, SHADER_CONSTANT_FETCH_13_5)
XE_GPU_REGISTER(0x4854, kDword, SHADER_CONSTANT_FETCH_14_0)
XE_GPU_REGISTER(0x4855, kDword, SHADER_CONSTANT_FETCH_14_1)
XE_GPU_REGISTER(0x4856, kDword, SHADER_CONSTANT_FETCH_14_2)
XE_GPU_REGISTER(0x4857, kDword, SHADER_CONSTANT_FETCH_14_3)
XE_GPU_REGISTER(0x4858, kDword, SHADER_CONSTANT_FETCH_14_4)
XE_GPU_REGISTER(0x4859, kDword, SHADER_CONSTANT_FETCH_14_5)
XE_GPU_REGISTER(0x485A, kDword, SHADER_CONSTANT_FETCH_15_0)
XE_GPU_REGISTER(0x485B, kDword, SHADER_CONSTANT_FETCH_15_1)
XE_GPU_REGISTER(0x485C, kDword, SHADER_CONSTANT_FETCH_15_2)
XE_GPU_REGISTER(0x485D, kDword, SHADER_CONSTANT_FETCH_15_3)
XE_GPU_REGISTER(0x485E, kDword, SHADER_CONSTANT_FETCH_15_4)
XE_GPU_REGISTER(0x485F, kDword, SHADER_CONSTANT_FETCH_15_5)
XE_GPU_REGISTER(0x4860, kDword, SHADER_CONSTANT_FETCH_16_0)
XE_GPU_REGISTER(0x4861, kDword, SHADER_CONSTANT_FETCH_16_1)
XE_GPU_REGISTER(0x4862, kDword, SHADER_CONSTANT_FETCH_16_2)
XE_GPU_REGISTER(0x4863, kDword, SHADER_CONSTANT_FETCH_16_3)
XE_GPU_REGISTER(0x4864, kDword, SHADER_CONSTANT_FETCH_16_4)
XE_GPU_REGISTER(0x4865, kDword, SHADER_CONSTANT_FETCH_16_5)
XE_GPU_REGISTER(0x4866, kDword, SHADER_CONSTANT_FETCH_17_0)
XE_GPU_REGISTER(0x4867, kDword, SHADER_CONSTANT_FETCH_17_1)
XE_GPU_REGISTER(0x4868, kDword, SHADER_CONSTANT_FETCH_17_2)
XE_GPU_REGISTER(0x4869, kDword, SHADER_CONSTANT_FETCH_17_3)
XE_GPU_REGISTER(0x486A, kDword, SHADER_CONSTANT_FETCH_17_4)
XE_GPU_REGISTER(0x486B, kDword, SHADER_CONSTANT_FETCH_17_5)
XE_GPU_REGISTER(0x486C, kDword, SHADER_CONSTANT_FETCH_18_0)
XE_GPU_REGISTER(0x486D, kDword, SHADER_CONSTANT_FETCH_18_1)
XE_GPU_REGISTER(0x486E, kDword, SHADER_CONSTANT_FETCH_18_2)
XE_GPU_REGISTER(0x486F, kDword, SHADER_CONSTANT_FETCH_18_3)
XE_GPU_REGISTER(0x4870, kDword, SHADER_CONSTANT_FETCH_18_4)
XE_GPU_REGISTER(0x4871, kDword, SHADER_CONSTANT_FETCH_18_5)
XE_GPU_REGISTER(0x4872, kDword, SHADER_CONSTANT_FETCH_19_0)
XE_GPU_REGISTER(0x4873, kDword, SHADER_CONSTANT_FETCH_19_1)
XE_GPU_REGISTER(0x4874, kDword, SHADER_CONSTANT_FETCH_19_2)
XE_GPU_REGISTER(0x4875, kDword, SHADER_CONSTANT_FETCH_19_3)
XE_GPU_REGISTER(0x4876, kDword, SHADER_CONSTANT_FETCH_19_4)
XE_GPU_REGISTER(0x4877, kDword, SHADER_CONSTANT_FETCH_19_5)
XE_GPU_REGISTER(0x4878, kDword, SHADER_CONSTANT_FETCH_20_0)
XE_GPU_REGISTER(0x4879, kDword, SHADER_CONSTANT_FETCH_20_1)
XE_GPU_REGISTER(0x487A, kDword, SHADER_CONSTANT_FETCH_20_2)
XE_GPU_REGISTER(0x487B, kDword, SHADER_CONSTANT_FETCH_20_3)
XE_GPU_REGISTER(0x487C, kDword, SHADER_CONSTANT_FETCH_20_4)
XE_GPU_REGISTER(0x487D, kDword, SHADER_CONSTANT_FETCH_20_5)
XE_GPU_REGISTER(0x487E, kDword, SHADER_CONSTANT_FETCH_21_0)
XE_GPU_REGISTER(0x487F, kDword, SHADER_CONSTANT_FETCH_21_1)
XE_GPU_REGISTER(0x4880, kDword, SHADER_CONSTANT_FETCH_21_2)
XE_GPU_REGISTER(0x4881, kDword, SHADER_CONSTANT_FETCH_21_3)
XE_GPU_REGISTER(0x4882, kDword, SHADER_CONSTANT_FETCH_21_4)
XE_GPU_REGISTER(0x4883, kDword, SHADER_CONSTANT_FETCH_21_5)
XE_GPU_REGISTER(0x4884, kDword, SHADER_CONSTANT_FETCH_22_0)
XE_GPU_REGISTER(0x4885, kDword, SHADER_CONSTANT_FETCH_22_1)
XE_GPU_REGISTER(0x4886, kDword, SHADER_CONSTANT_FETCH_22_2)
XE_GPU_REGISTER(0x4887, kDword, SHADER_CONSTANT_FETCH_22_3)
XE_GPU_REGISTER(0x4888, kDword, SHADER_CONSTANT_FETCH_22_4)
XE_GPU_REGISTER(0x4889, kDword, SHADER_CONSTANT_FETCH_22_5)
XE_GPU_REGISTER(0x488A, kDword, SHADER_CONSTANT_FETCH_23_0)
XE_GPU_REGISTER(0x488B, kDword, SHADER_CONSTANT_FETCH_23_1)
XE_GPU_REGISTER(0x488C, kDword, SHADER_CONSTANT_FETCH_23_2)
XE_GPU_REGISTER(0x488D, kDword, SHADER_CONSTANT_FETCH_23_3)
XE_GPU_REGISTER(0x488E, kDword, SHADER_CONSTANT_FETCH_23_4)
XE_GPU_REGISTER(0x488F, kDword, SHADER_CONSTANT_FETCH_23_5)
XE_GPU_REGISTER(0x4890, kDword, SHADER_CONSTANT_FETCH_24_0)
XE_GPU_REGISTER(0x4891, kDword, SHADER_CONSTANT_FETCH_24_1)
XE_GPU_REGISTER(0x4892, kDword, SHADER_CONSTANT_FETCH_24_2)
XE_GPU_REGISTER(0x4893, kDword, SHADER_CONSTANT_FETCH_24_3)
XE_GPU_REGISTER(0x4894, kDword, SHADER_CONSTANT_FETCH_24_4)
XE_GPU_REGISTER(0x4895, kDword, SHADER_CONSTANT_FETCH_24_5)
XE_GPU_REGISTER(0x4896, kDword, SHADER_CONSTANT_FETCH_25_0)
XE_GPU_REGISTER(0x4897, kDword, SHADER_CONSTANT_FETCH_25_1)
XE_GPU_REGISTER(0x4898, kDword, SHADER_CONSTANT_FETCH_25_2)
XE_GPU_REGISTER(0x4899, kDword, SHADER_CONSTANT_FETCH_25_3)
XE_GPU_REGISTER(0x489A, kDword, SHADER_CONSTANT_FETCH_25_4)
XE_GPU_REGISTER(0x489B, kDword, SHADER_CONSTANT_FETCH_25_5)
XE_GPU_REGISTER(0x489C, kDword, SHADER_CONSTANT_FETCH_26_0)
XE_GPU_REGISTER(0x489D, kDword, SHADER_CONSTANT_FETCH_26_1)
XE_GPU_REGISTER(0x489E, kDword, SHADER_CONSTANT_FETCH_26_2)
XE_GPU_REGISTER(0x489F, kDword, SHADER_CONSTANT_FETCH_26_3)
XE_GPU_REGISTER(0x48A0, kDword, SHADER_CONSTANT_FETCH_26_4)
XE_GPU_REGISTER(0x48A1, kDword, SHADER_CONSTANT_FETCH_26_5)
XE_GPU_REGISTER(0x48A2, kDword, SHADER_CONSTANT_FETCH_27_0)
XE_GPU_REGISTER(0x48A3, kDword, SHADER_CONSTANT_FETCH_27_1)
XE_GPU_REGISTER(0x48A4, kDword, SHADER_CONSTANT_FETCH_27_2)
XE_GPU_REGISTER(0x48A5, kDword, SHADER_CONSTANT_FETCH_27_3)
XE_GPU_REGISTER(0x48A6, kDword, SHADER_CONSTANT_FETCH_27_4)
XE_GPU_REGISTER(0x48A7, kDword, SHADER_CONSTANT_FETCH_27_5)
XE_GPU_REGISTER(0x48A8, kDword, SHADER_CONSTANT_FETCH_28_0)
XE_GPU_REGISTER(0x48A9, kDword, SHADER_CONSTANT_FETCH_28_1)
XE_GPU_REGISTER(0x48AA, kDword, SHADER_CONSTANT_FETCH_28_2)
XE_GPU_REGISTER(0x48AB, kDword, SHADER_CONSTANT_FETCH_28_3)
XE_GPU_REGISTER(0x48AC, kDword, SHADER_CONSTANT_FETCH_28_4)
XE_GPU_REGISTER(0x48AD, kDword, SHADER_CONSTANT_FETCH_28_5)
XE_GPU_REGISTER(0x48AE, kDword, SHADER_CONSTANT_FETCH_29_0)
XE_GPU_REGISTER(0x48AF, kDword, SHADER_CONSTANT_FETCH_29_1)
XE_GPU_REGISTER(0x48B0, kDword, SHADER_CONSTANT_FETCH_29_2)
XE_GPU_REGISTER(0x48B1, kDword, SHADER_CONSTANT_FETCH_29_3)
XE_GPU_REGISTER(0x48B2, kDword, SHADER_CONSTANT_FETCH_29_4)
XE_GPU_REGISTER(0x48B3, kDword, SHADER_CONSTANT_FETCH_29_5)
XE_GPU_REGISTER(0x48B4, kDword, SHADER_CONSTANT_FETCH_30_0)
XE_GPU_REGISTER(0x48B5, kDword, SHADER_CONSTANT_FETCH_30_1)
XE_GPU_REGISTER(0x48B6, kDword, SHADER_CONSTANT_FETCH_30_2)
XE_GPU_REGISTER(0x48B7, kDword, SHADER_CONSTANT_FETCH_30_3)
XE_GPU_REGISTER(0x48B8, kDword, SHADER_CONSTANT_FETCH_30_4)
XE_GPU_REGISTER(0x48B9, kDword, SHADER_CONSTANT_FETCH_30_5)
XE_GPU_REGISTER(0x48BA, kDword, SHADER_CONSTANT_FETCH_31_0)
XE_GPU_REGISTER(0x48BB, kDword, SHADER_CONSTANT_FETCH_31_1)
XE_GPU_REGISTER(0x48BC, kDword, SHADER_CONSTANT_FETCH_31_2)
XE_GPU_REGISTER(0x48BD, kDword, SHADER_CONSTANT_FETCH_31_3)
XE_GPU_REGISTER(0x48BE, kDword, SHADER_CONSTANT_FETCH_31_4)
XE_GPU_REGISTER(0x48BF, kDword, SHADER_CONSTANT_FETCH_31_5)

XE_GPU_REGISTER(0x4900, kDword, SHADER_CONSTANT_BOOL_000_031)
XE_GPU_REGISTER(0x4901, kDword, SHADER_CONSTANT_BOOL_032_063)
XE_GPU_REGISTER(0x4902, kDword, SHADER_CONSTANT_BOOL_064_095)
XE_GPU_REGISTER(0x4903, kDword, SHADER_CONSTANT_BOOL_096_127)
XE_GPU_REGISTER(0x4904, kDword, SHADER_CONSTANT_BOOL_128_159)
XE_GPU_REGISTER(0x4905, kDword, SHADER_CONSTANT_BOOL_160_191)
XE_GPU_REGISTER(0x4906, kDword, SHADER_CONSTANT_BOOL_192_223)
XE_GPU_REGISTER(0x4907, kDword, SHADER_CONSTANT_BOOL_224_255)

XE_GPU_REGISTER(0x4908, kDword, SHADER_CONSTANT_LOOP_00)
XE_GPU_REGISTER(0x4909, kDword, SHADER_CONSTANT_LOOP_01)
XE_GPU_REGISTER(0x490A, kDword, SHADER_CONSTANT_LOOP_02)
XE_GPU_REGISTER(0x490B, kDword, SHADER_CONSTANT_LOOP_03)
XE_GPU_REGISTER(0x490C, kDword, SHADER_CONSTANT_LOOP_04)
XE_GPU_REGISTER(0x490D, kDword, SHADER_CONSTANT_LOOP_05)
XE_GPU_REGISTER(0x490E, kDword, SHADER_CONSTANT_LOOP_06)
XE_GPU_REGISTER(0x490F, kDword, SHADER_CONSTANT_LOOP_07)
XE_GPU_REGISTER(0x4910, kDword, SHADER_CONSTANT_LOOP_08)
XE_GPU_REGISTER(0x4911, kDword, SHADER_CONSTANT_LOOP_09)
XE_GPU_REGISTER(0x4912, kDword, SHADER_CONSTANT_LOOP_10)
XE_GPU_REGISTER(0x4913, kDword, SHADER_CONSTANT_LOOP_11)
XE_GPU_REGISTER(0x4914, kDword, SHADER_CONSTANT_LOOP_12)
XE_GPU_REGISTER(0x4915, kDword, SHADER_CONSTANT_LOOP_13)
XE_GPU_REGISTER(0x4916, kDword, SHADER_CONSTANT_LOOP_14)
XE_GPU_REGISTER(0x4917, kDword, SHADER_CONSTANT_LOOP_15)
XE_GPU_REGISTER(0x4918, kDword, SHADER_CONSTANT_LOOP_16)
XE_GPU_REGISTER(0x4919, kDword, SHADER_CONSTANT_LOOP_17)
XE_GPU_REGISTER(0x491A, kDword, SHADER_CONSTANT_LOOP_18)
XE_GPU_REGISTER(0x491B, kDword, SHADER_CONSTANT_LOOP_19)
XE_GPU_REGISTER(0x491C, kDword, SHADER_CONSTANT_LOOP_20)
XE_GPU_REGISTER(0x491D, kDword, SHADER_CONSTANT_LOOP_21)
XE_GPU_REGISTER(0x491E, kDword, SHADER_CONSTANT_LOOP_22)
XE_GPU_REGISTER(0x491F, kDword, SHADER_CONSTANT_LOOP_23)
XE_GPU_REGISTER(0x4920, kDword, SHADER_CONSTANT_LOOP_24)
XE_GPU_REGISTER(0x4921, kDword, SHADER_CONSTANT_LOOP_25)
XE_GPU_REGISTER(0x4922, kDword, SHADER_CONSTANT_LOOP_26)
XE_GPU_REGISTER(0x4923, kDword, SHADER_CONSTANT_LOOP_27)
XE_GPU_REGISTER(0x4924, kDword, SHADER_CONSTANT_LOOP_28)
XE_GPU_REGISTER(0x4925, kDword, SHADER_CONSTANT_LOOP_29)
XE_GPU_REGISTER(0x4926, kDword, SHADER_CONSTANT_LOOP_30)
XE_GPU_REGISTER(0x4927, kDword, SHADER_CONSTANT_LOOP_31)

XE_GPU_REGISTER(0x5000, kDword, SHADER_CONSTANT_FLUSH_FETCH_0)
XE_GPU_REGISTER(0x5001, kDword, SHADER_CONSTANT_FLUSH_FETCH_1)
XE_GPU_REGISTER(0x5002, kDword, SHADER_CONSTANT_FLUSH_FETCH_2)

// Ignored because I have no clue what these are.
// XE_GPU_REGISTER(0x8D00, kDword, UNKNOWN_8D00)
// XE_GPU_REGISTER(0x8D01, kDword, UNKNOWN_8D01)
// XE_GPU_REGISTER(0x8D02, kDword, UNKNOWN_8D02)
// XE_GPU_REGISTER(0x8D03, kDword, UNKNOWN_8D03)
// XE_GPU_REGISTER(0x8D04, kDword, UNKNOWN_8D04)
// XE_GPU_REGISTER(0x8D05, kDword, UNKNOWN_8D05)
// XE_GPU_REGISTER(0x8D06, kDword, UNKNOWN_8D06)
// XE_GPU_REGISTER(0x8D07, kDword, UNKNOWN_8D07)
