/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2024 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package blues;

import java.util.HashMap;

public class Cache {

    public static final int ID_ClassData = 0;
    public static final int ID_DiscFile = 1;
    public static final int ID_MAX = 128;

    static HashMap<String,Object>[] caches = new HashMap[ID_MAX];

    public static synchronized void put(int id, String key, Object value) {
        if (null==caches[id]) {
            caches[id] = new HashMap<String,Object>();
        }
        caches[id].put(key, value);
    }

    public static synchronized Object get(int id, String key) {
        if (null==caches[id]) {
            return null;
        }
        return caches[id].get(key);
    }

    public static synchronized void remove(int id, String key) {
        if (null==caches[id]) return;
        caches[id].remove(key);
    }

    public static synchronized void clear() {
        for (int i=0;i<ID_MAX;i++) {
            if (null!=caches[i]) {
                caches[i].clear();
            }
            caches[i] = null;
        }
    }

}
