/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2024 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package blues;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;

public class ClassMap implements Externalizable {

    public HashMap<String, ClassInfo> classes;

    public ClassMap() {
        classes = new HashMap<String, ClassInfo>();
    }

    public ClassMap(int capacity) {
        if (capacity != 0) {
            classes = new HashMap<String, ClassInfo>((capacity * 120) / 100, 1);
        }
    }

    public void addEntry(ClassInfo entry) {
        classes.put(entry.name, entry);
    }

    public ClassInfo findEntry(String className) {
        return classes.get(className.replace('.', '/'));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(classes.size());
        out.flush();
        Iterator<Entry<String, ClassInfo>> it = classes.entrySet().iterator();
        while (it.hasNext()) {
            it.next().getValue().writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int count = in.readInt();
        classes = new HashMap<String, ClassInfo>((count * 120) / 100, 1);
        for (int i = 0; i < count; i++) {
            ClassInfo info = new ClassInfo(null, 0);
            info.readExternal(in);
            addEntry(info);
        }
    }

    public ClassInfo getSuper(ClassInfo info) {
    	if (info.superInfo!=null) return info.superInfo;
    	if (info.superName==null) return null;
    	info.superInfo = classes.get(info.superName);
    	return info.superInfo;
    }

}
