/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2024 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package blues;

import java.io.ByteArrayOutputStream;

public class LogOutputStream extends ByteArrayOutputStream {
    private int source;

    public LogOutputStream(int asource) {
        super(2048);
        source = asource;
    }

    public synchronized void write(int b) {
        super.write(b);
        checkFlush(1);
    }

    public synchronized void write(byte b[], int off, int len) {
        super.write(b, off, len);
        checkFlush(len);
    }

    private void checkFlush(int tailCount) {
        String line = null;
        synchronized (this) {
            int index = -1;
            if (tailCount > count) {
                tailCount = count;
            }
            for (int i = 0; i < tailCount; i++) {
                if (buf[count - (i+1)] == '\n') {
                    index = (count - i);
                    break;
                }
            }
            if (index > 0) {
                line = new String(buf, 0, index - 1);
                int rest = count - index;
                if (rest != 0) {
                    System.arraycopy(buf, index, buf, 0, rest);
                    count = rest;
                }
            }
        }
        if (line != null) {
            Log.log(source, line);
        }
    }
}
