/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2024 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package control;

public class Gate {

    static boolean callBeforeEnabledAny = false;
    static boolean callStaticBeforeEnabledAny = false;
    static boolean callAfterEnabledAny = false;
    static boolean callStaticAfterEnabledAny = false;
    static boolean throwEnabledAny = false;
    static boolean catchEnabledAny = false;

    static Freak allFreaks[];
    static boolean[] callStaticBeforeEnabled;
    static boolean[] callStaticAfterEnabled;
    static boolean[] callBeforeEnabled;
    static boolean[] callAfterEnabled;
    static boolean[] throwEnabled;
    static boolean[] catchEnabled;

    public static synchronized Freak[] freaks() {
        return allFreaks;
    }

    public static void reportThrow(Throwable x) {
        Freak[] freaks = freaks();
        if (throwEnabledAny) {
            for (int i = 0; i < freaks.length; i++) {
                if (throwEnabled[i] && (freaks[i]!=null)) {
                    freaks[i].reportThrow(x);
                }
            }
        }
    }

    public static void reportCatch(Throwable x) {
        if (catchEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (catchEnabled[i] && (freaks[i]!=null)) {
                    freaks[i].reportCatch(x);
                }
            }
        }
    }

    public static Object[] callBefore(Object object, Object[] pile, String owner, String name, String desc, long hash) {
        if (callBeforeEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callBeforeEnabled[i] && (freaks[i]!=null)) {
                    freaks[i].callBefore(object, pile, owner, name, desc, hash);
                }
            }
        }
        return pile;
    }

    public static Object callBefore(Object object, Object pile, String owner, String name, String desc, long hash) {
        if (callBeforeEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callBeforeEnabled[i] && (freaks[i]!=null)) {
                    pile=freaks[i].callBefore(object, pile, owner, name, desc, hash);
                }
            }
        }
        return pile;
    }

    public static long[] callBefore(Object object, long[] pile, String owner, String name, String desc, long hash) {
        if (callBeforeEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callBeforeEnabled[i] && (freaks[i]!=null)) {
                    freaks[i].callBefore(object, pile, owner, name, desc, hash);
                }
            }
        }
        return pile;
    }

    public static int callBefore(Object object, int pile, String owner, String name, String desc, long hash) {
        if (callBeforeEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callBeforeEnabled[i] && (freaks[i]!=null)) {
                    pile = freaks[i].callBefore(object, pile, owner, name, desc, hash);
                }
            }
        }
        return pile;
    }

    public static long callBefore(Object object, long pile, String owner, String name, String desc, long hash) {
        if (callBeforeEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callBeforeEnabled[i] && (freaks[i]!=null)) {
                    pile = freaks[i].callBefore(object, pile, owner, name, desc, hash);
                }
            }
        }
        return pile;
    }

    public static void callBefore(Object object, String owner, String name, String desc, long hash) {
        if (callBeforeEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callBeforeEnabled[i] && (freaks[i]!=null)) {
                    freaks[i].callBefore(object, owner, name, desc, hash);
                }
            }
        }
    }

    public static char callAfter(Object object, char value, String owner, String name, String desc, long hash) {
        if (callAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callAfter(object, value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static byte callAfter(Object object, byte value, String owner, String name, String desc, long hash) {
        if (callAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callAfter(object, value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static boolean callAfter(Object object, boolean value, String owner, String name, String desc, long hash) {
        if (callAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callAfter(object, value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static short callAfter(Object object, short value, String owner, String name, String desc, long hash) {
        if (callAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callAfter(object, value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static int callAfter(Object object, int value, String owner, String name, String desc, long hash) {
        if (callAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callAfter(object, value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static long callAfter(Object object, long value, String owner, String name, String desc, long hash) {
        if (callAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callAfter(object, value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static float callAfter(Object object, float value, String owner, String name, String desc, long hash) {
        if (callAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callAfter(object, value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static double callAfter(Object object, double value, String owner, String name, String desc, long hash) {
        if (callAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callAfter(object, value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static Object callAfter(Object object, Object value, String owner, String name, String desc, long hash) {
        if (callAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callAfter(object, value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static void callAfter(Object object, String owner, String name, String desc, long hash) {
        if (callAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callAfterEnabled[i] && (freaks[i]!=null)) {
                    freaks[i].callAfter(object, owner, name, desc, hash);
                }
            }
        }
    }

    public static Object[] callStaticBefore(Object[] pile, String owner, String name, String desc, long hash) {
        if (callStaticBeforeEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callStaticBeforeEnabled[i] && (freaks[i]!=null)) {
                    freaks[i].callStaticBefore(pile, owner, name, desc, hash);
                }
            }
        }
        return pile;
    }

    public static Object callStaticBefore(Object pile, String owner, String name, String desc, long hash) {
        if (callStaticBeforeEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callStaticBeforeEnabled[i] && (freaks[i]!=null)) {
                    pile = freaks[i].callStaticBefore(pile, owner, name, desc, hash);
                }
            }
        }
        return pile;
    }

    public static long[] callStaticBefore(long[] pile, String owner, String name, String desc, long hash) {
        if (callStaticBeforeEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callStaticBeforeEnabled[i] && (freaks[i]!=null)) {
                    freaks[i].callStaticBefore(pile, owner, name, desc, hash);
                }
            }
        }
        return pile;
    }

    public static int callStaticBefore(int pile, String owner, String name, String desc, long hash) {
        if (callStaticBeforeEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callStaticBeforeEnabled[i] && (freaks[i]!=null)) {
                    pile = freaks[i].callStaticBefore(pile, owner, name, desc, hash);
                }
            }
        }
        return pile;
    }

    public static long callStaticBefore(long pile, String owner, String name, String desc, long hash) {
        if (callStaticBeforeEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callStaticBeforeEnabled[i] && (freaks[i]!=null)) {
                    pile = freaks[i].callStaticBefore(pile, owner, name, desc, hash);
                }
            }
        }
        return pile;
    }

    public static void callStaticBefore(String owner, String name, String desc, long hash) {
        if (callStaticBeforeEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callStaticBeforeEnabled[i] && (freaks[i]!=null)) {
                    freaks[i].callStaticBefore(owner, name, desc, hash);
                }
            }
        }
    }

    public static char callStaticAfter(char value, String owner, String name, String desc, long hash) {
        if (callStaticAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callStaticAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callStaticAfter(value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static byte callStaticAfter(byte value, String owner, String name, String desc, long hash) {
        if (callStaticAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callStaticAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callStaticAfter(value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static boolean callStaticAfter(boolean value, String owner, String name, String desc, long hash) {
        if (callStaticAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callStaticAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callStaticAfter(value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static short callStaticAfter(short value, String owner, String name, String desc, long hash) {
        if (callStaticAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callStaticAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callStaticAfter(value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static int callStaticAfter(int value, String owner, String name, String desc, long hash) {
        if (callStaticAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callStaticAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callStaticAfter(value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static long callStaticAfter(long value, String owner, String name, String desc, long hash) {
        if (callStaticAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callStaticAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callStaticAfter(value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static float callStaticAfter(float value, String owner, String name, String desc, long hash) {
        if (callStaticAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callStaticAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callStaticAfter(value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static double callStaticAfter(double value, String owner, String name, String desc, long hash) {
        if (callStaticAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callStaticAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callStaticAfter(value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static Object callStaticAfter(Object value, String owner, String name, String desc, long hash) {
        if (callStaticAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callStaticAfterEnabled[i] && (freaks[i]!=null)) {
                    value = freaks[i].callStaticAfter(value, owner, name, desc, hash);
                }
            }
        }
        return value;
    }

    public static void callStaticAfter(String owner, String name, String desc, long hash) {
        if (callStaticAfterEnabledAny) {
            Freak[] freaks = freaks();
            for (int i = 0; i < freaks.length; i++) {
                if (callStaticAfterEnabled[i] && (freaks[i]!=null)) {
                    freaks[i].callStaticAfter(owner, name, desc, hash);
                }
            }
        }
    }

}
