/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2024 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package control;

public abstract class LazyFreak implements Freak {

    @Override
    public void callBefore(Object object, Object[] pile, String owner, String name, String desc, long hash) {
    }

    @Override
    public Object callBefore(Object object, Object pile, String owner, String name, String desc, long hash) {
        return pile;
    }

    @Override
    public void callBefore(Object object, long[] pile, String owner, String name, String desc, long hash) {
    }

    @Override
    public int callBefore(Object object, int pile, String owner, String name, String desc, long hash) {
        return pile;
    }

    @Override
    public long callBefore(Object object, long pile, String owner, String name, String desc, long hash) {
        return pile;
    }

    @Override
    public void callBefore(Object object, String owner, String name, String desc, long hash) {
    }

    @Override
    public char callAfter(Object object, char value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public byte callAfter(Object object, byte value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public boolean callAfter(Object object, boolean value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public short callAfter(Object object, short value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public int callAfter(Object object, int value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public long callAfter(Object object, long value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public float callAfter(Object object, float value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public double callAfter(Object object, double value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public Object callAfter(Object object, Object value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public void callAfter(Object object, String owner, String name, String desc, long hash) {
    }

    @Override
    public void callStaticBefore(Object[] pile, String owner, String name, String desc, long hash) {
    }

    @Override
    public Object callStaticBefore(Object pile, String owner, String name, String desc, long hash) {
        return pile;
    }

    @Override
    public void callStaticBefore(long[] pile, String owner, String name, String desc, long hash) {
    }

    @Override
    public int callStaticBefore(int pile, String owner, String name, String desc, long hash) {
        return pile;
    }

    @Override
    public long callStaticBefore(long pile, String owner, String name, String desc, long hash) {
        return pile;
    }

    @Override
    public void callStaticBefore(String owner, String name, String desc, long hash) {
    }

    @Override
    public char callStaticAfter(char value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public byte callStaticAfter(byte value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public boolean callStaticAfter(boolean value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public short callStaticAfter(short value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public int callStaticAfter(int value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public long callStaticAfter(long value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public float callStaticAfter(float value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public double callStaticAfter(double value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public Object callStaticAfter(Object value, String owner, String name, String desc, long hash) {
        return value;
    }

    @Override
    public void callStaticAfter(String owner, String name, String desc, long hash) {
    }

    @Override
    public void reportThrow(Throwable x) {
    }

    @Override
    public void reportCatch(Throwable x) {
    }

}
