// This file is autogenerated. Do not edit it!
//
// See docs/ragel.md for details.

#![allow(
    dead_code,
    non_upper_case_globals,
    unused_assignments,
    unused_parens,
    while_true,
    clippy::assign_op_pattern,
    clippy::collapsible_if,
    clippy::comparison_chain,
    clippy::double_parens,
    clippy::unnecessary_cast,
    clippy::single_match,
    clippy::never_loop
)]

use crate::buffer::Buffer;
use crate::complex::machine_cursor::MachineCursor;
use crate::complex::universal::category;
use crate::GlyphInfo;
use core::cell::Cell;

static _use_syllable_machine_trans_keys: [u8; 126] = [
    1, 1, 1, 1, 0, 37, 5, 34, 5, 34, 1, 1, 10, 34, 11, 34, 12, 33, 13, 33, 14, 33, 31, 32, 32, 32,
    12, 34, 12, 34, 12, 34, 1, 1, 12, 34, 11, 34, 11, 34, 11, 34, 10, 34, 10, 34, 10, 34, 5, 34, 1,
    34, 7, 7, 3, 3, 5, 34, 27, 28, 28, 28, 5, 34, 10, 34, 11, 34, 12, 33, 13, 33, 14, 33, 31, 32,
    32, 32, 12, 34, 12, 34, 12, 34, 12, 34, 11, 34, 11, 34, 11, 34, 10, 34, 10, 34, 10, 34, 5, 34,
    1, 34, 1, 1, 3, 3, 7, 7, 1, 34, 5, 34, 27, 28, 28, 28, 1, 4, 36, 38, 35, 38, 35, 37, 0, 0,
];
static _use_syllable_machine_char_class: [i8; 55] = [
    0, 1, 2, 2, 3, 4, 2, 2, 2, 2, 2, 5, 6, 7, 2, 2, 2, 2, 8, 9, 2, 2, 10, 11, 12, 13, 14, 15, 16,
    17, 18, 19, 20, 21, 22, 23, 2, 24, 25, 26, 2, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
    0, 0,
];
static _use_syllable_machine_index_offsets: [i16; 64] = [
    0, 1, 2, 40, 70, 100, 101, 126, 150, 172, 193, 213, 215, 216, 239, 262, 285, 286, 309, 333,
    357, 381, 406, 431, 456, 486, 520, 521, 522, 552, 554, 555, 585, 610, 634, 656, 677, 697, 699,
    700, 723, 746, 769, 792, 816, 840, 864, 889, 914, 939, 969, 1003, 1004, 1005, 1006, 1040, 1070,
    1072, 1073, 1077, 1080, 1084, 0, 0,
];
static _use_syllable_machine_indices: [i8; 1089] = [
    1, 2, 4, 5, 6, 7, 8, 1, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 13, 20, 21, 22, 23, 24, 25,
    26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 9, 36, 6, 37, 39, 40, 38, 38, 38, 41, 42, 43, 44, 45,
    46, 47, 41, 48, 5, 49, 50, 51, 52, 53, 54, 55, 38, 38, 38, 56, 57, 58, 59, 40, 39, 40, 38, 38,
    38, 41, 42, 43, 44, 45, 46, 47, 41, 48, 49, 49, 50, 51, 52, 53, 54, 55, 38, 38, 38, 56, 57, 58,
    59, 40, 39, 41, 42, 43, 44, 45, 38, 38, 38, 38, 38, 38, 50, 51, 52, 53, 54, 55, 38, 38, 38, 42,
    57, 58, 59, 61, 42, 43, 44, 45, 38, 38, 38, 38, 38, 38, 38, 38, 38, 53, 54, 55, 38, 38, 38, 38,
    57, 58, 59, 61, 43, 44, 45, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 57,
    58, 59, 44, 45, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 57, 58, 59, 45,
    38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 57, 58, 59, 57, 58, 58, 43, 44,
    45, 38, 38, 38, 38, 38, 38, 38, 38, 38, 53, 54, 55, 38, 38, 38, 38, 57, 58, 59, 61, 43, 44, 45,
    38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 54, 55, 38, 38, 38, 38, 57, 58, 59, 61, 43, 44, 45, 38,
    38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 55, 38, 38, 38, 38, 57, 58, 59, 61, 63, 43, 44, 45, 38,
    38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 57, 58, 59, 61, 42, 43, 44, 45, 38,
    38, 38, 38, 38, 38, 50, 51, 52, 53, 54, 55, 38, 38, 38, 42, 57, 58, 59, 61, 42, 43, 44, 45, 38,
    38, 38, 38, 38, 38, 38, 51, 52, 53, 54, 55, 38, 38, 38, 42, 57, 58, 59, 61, 42, 43, 44, 45, 38,
    38, 38, 38, 38, 38, 38, 38, 52, 53, 54, 55, 38, 38, 38, 42, 57, 58, 59, 61, 41, 42, 43, 44, 45,
    38, 47, 41, 38, 38, 38, 50, 51, 52, 53, 54, 55, 38, 38, 38, 42, 57, 58, 59, 61, 41, 42, 43, 44,
    45, 38, 38, 41, 38, 38, 38, 50, 51, 52, 53, 54, 55, 38, 38, 38, 42, 57, 58, 59, 61, 41, 42, 43,
    44, 45, 46, 47, 41, 38, 38, 38, 50, 51, 52, 53, 54, 55, 38, 38, 38, 42, 57, 58, 59, 61, 39, 40,
    38, 38, 38, 41, 42, 43, 44, 45, 46, 47, 41, 48, 38, 49, 50, 51, 52, 53, 54, 55, 38, 38, 38, 56,
    57, 58, 59, 40, 39, 60, 60, 60, 60, 60, 60, 60, 60, 60, 42, 43, 44, 45, 60, 60, 60, 60, 60, 60,
    60, 60, 60, 53, 54, 55, 60, 60, 60, 60, 57, 58, 59, 61, 65, 7, 39, 40, 38, 38, 38, 41, 42, 43,
    44, 45, 46, 47, 41, 48, 5, 49, 50, 51, 52, 53, 54, 55, 12, 67, 38, 56, 57, 58, 59, 40, 12, 67,
    67, 1, 70, 69, 69, 69, 13, 14, 15, 16, 17, 18, 19, 13, 20, 22, 22, 23, 24, 25, 26, 27, 28, 69,
    69, 69, 32, 33, 34, 35, 70, 13, 14, 15, 16, 17, 69, 69, 69, 69, 69, 69, 23, 24, 25, 26, 27, 28,
    69, 69, 69, 14, 33, 34, 35, 71, 14, 15, 16, 17, 69, 69, 69, 69, 69, 69, 69, 69, 69, 26, 27, 28,
    69, 69, 69, 69, 33, 34, 35, 71, 15, 16, 17, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,
    69, 69, 69, 33, 34, 35, 16, 17, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,
    33, 34, 35, 17, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 33, 34, 35, 33,
    34, 34, 15, 16, 17, 69, 69, 69, 69, 69, 69, 69, 69, 69, 26, 27, 28, 69, 69, 69, 69, 33, 34, 35,
    71, 15, 16, 17, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 27, 28, 69, 69, 69, 69, 33, 34, 35, 71,
    15, 16, 17, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 28, 69, 69, 69, 69, 33, 34, 35, 71, 15,
    16, 17, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 33, 34, 35, 71, 14, 15,
    16, 17, 69, 69, 69, 69, 69, 69, 23, 24, 25, 26, 27, 28, 69, 69, 69, 14, 33, 34, 35, 71, 14, 15,
    16, 17, 69, 69, 69, 69, 69, 69, 69, 24, 25, 26, 27, 28, 69, 69, 69, 14, 33, 34, 35, 71, 14, 15,
    16, 17, 69, 69, 69, 69, 69, 69, 69, 69, 25, 26, 27, 28, 69, 69, 69, 14, 33, 34, 35, 71, 13, 14,
    15, 16, 17, 69, 19, 13, 69, 69, 69, 23, 24, 25, 26, 27, 28, 69, 69, 69, 14, 33, 34, 35, 71, 13,
    14, 15, 16, 17, 69, 69, 13, 69, 69, 69, 23, 24, 25, 26, 27, 28, 69, 69, 69, 14, 33, 34, 35, 71,
    13, 14, 15, 16, 17, 18, 19, 13, 69, 69, 69, 23, 24, 25, 26, 27, 28, 69, 69, 69, 14, 33, 34, 35,
    71, 1, 70, 69, 69, 69, 13, 14, 15, 16, 17, 18, 19, 13, 20, 69, 22, 23, 24, 25, 26, 27, 28, 69,
    69, 69, 32, 33, 34, 35, 70, 1, 69, 69, 69, 69, 69, 69, 69, 69, 69, 14, 15, 16, 17, 69, 69, 69,
    69, 69, 69, 69, 69, 69, 26, 27, 28, 69, 69, 69, 69, 33, 34, 35, 71, 1, 73, 10, 5, 69, 69, 5, 1,
    70, 10, 69, 69, 13, 14, 15, 16, 17, 18, 19, 13, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 69,
    32, 33, 34, 35, 70, 1, 70, 69, 69, 69, 13, 14, 15, 16, 17, 18, 19, 13, 20, 21, 22, 23, 24, 25,
    26, 27, 28, 69, 69, 69, 32, 33, 34, 35, 70, 29, 30, 30, 5, 72, 72, 5, 75, 74, 36, 36, 75, 74,
    75, 36, 74, 37, 0, 0,
];
static _use_syllable_machine_index_defaults: [i8; 64] = [
    0, 0, 6, 38, 38, 60, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 62, 38, 38, 38, 38, 38, 38, 38,
    38, 60, 64, 66, 38, 68, 68, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69,
    69, 69, 69, 72, 69, 69, 69, 69, 69, 69, 72, 74, 74, 74, 0, 0,
];
static _use_syllable_machine_cond_targs: [i8; 78] = [
    2, 31, 42, 2, 2, 3, 2, 26, 28, 51, 52, 54, 29, 32, 33, 34, 35, 36, 46, 47, 48, 55, 49, 43, 44,
    45, 39, 40, 41, 56, 57, 58, 50, 37, 38, 2, 59, 61, 2, 4, 5, 6, 7, 8, 9, 10, 21, 22, 23, 24, 18,
    19, 20, 13, 14, 15, 25, 11, 12, 2, 2, 16, 2, 17, 2, 27, 2, 30, 2, 2, 0, 1, 2, 53, 2, 60, 0, 0,
];
static _use_syllable_machine_cond_actions: [i8; 78] = [
    1, 2, 2, 0, 5, 0, 6, 0, 0, 0, 0, 2, 0, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0,
    2, 0, 0, 7, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 10, 0, 11,
    0, 12, 0, 13, 0, 14, 15, 0, 0, 16, 0, 17, 0, 0, 0,
];
static _use_syllable_machine_to_state_actions: [i8; 64] = [
    0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
];
static _use_syllable_machine_from_state_actions: [i8; 64] = [
    0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
];
static _use_syllable_machine_eof_trans: [i8; 64] = [
    1, 1, 4, 39, 39, 61, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 63, 39, 39, 39, 39, 39, 39, 39,
    39, 61, 65, 67, 39, 69, 69, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
    70, 70, 70, 73, 70, 70, 70, 70, 70, 70, 73, 75, 75, 75, 0, 0,
];
static use_syllable_machine_start: i32 = 2;
static use_syllable_machine_first_final: i32 = 2;
static use_syllable_machine_error: i32 = -1;
static use_syllable_machine_en_main: i32 = 2;
#[derive(Clone, Copy)]
pub enum SyllableType {
    IndependentCluster,
    ViramaTerminatedCluster,
    SakotTerminatedCluster,
    StandardCluster,
    NumberJoinerTerminatedCluster,
    NumeralCluster,
    SymbolCluster,
    HieroglyphCluster,
    BrokenCluster,
    NonCluster,
}

pub fn find_syllables(buffer: &mut Buffer) {
    let mut cs = 0;
    let infos = Cell::as_slice_of_cells(Cell::from_mut(&mut buffer.info));
    let p0 = MachineCursor::new(infos, included);
    let mut p = p0;
    let mut ts = p0;
    let mut te = p0;
    let pe = p.end();
    let eof = p.end();
    let mut syllable_serial = 1u8;

    // Please manually replace assignments of 0 to p, ts, and te
    // to use p0 instead

    macro_rules! found_syllable {
        ($kind:expr) => {{
            found_syllable(ts.index(), te.index(), &mut syllable_serial, $kind, infos);
        }};
    }

    {
        cs = (use_syllable_machine_start) as i32;
        ts = p0;
        te = p0;
    }

    {
        let mut _trans = 0;
        let mut _keys: i32 = 0;
        let mut _inds: i32 = 0;
        let mut _ic = 0;
        '_resume: while (p != pe || p == eof) {
            '_again: while (true) {
                match (_use_syllable_machine_from_state_actions[(cs) as usize]) {
                    4 => {
                        ts = p;
                    }

                    _ => {}
                }
                if (p == eof) {
                    {
                        if (_use_syllable_machine_eof_trans[(cs) as usize] > 0) {
                            {
                                _trans =
                                    (_use_syllable_machine_eof_trans[(cs) as usize]) as u32 - 1;
                            }
                        }
                    }
                } else {
                    {
                        _keys = (cs << 1) as i32;
                        _inds = (_use_syllable_machine_index_offsets[(cs) as usize]) as i32;
                        if ((infos[p.index()].get().use_category() as u8) <= 52) {
                            {
                                _ic = (_use_syllable_machine_char_class[((infos[p.index()]
                                    .get()
                                    .use_category()
                                    as u8)
                                    as i32
                                    - 0)
                                    as usize]) as i32;
                                if (_ic
                                    <= (_use_syllable_machine_trans_keys[(_keys + 1) as usize])
                                        as i32
                                    && _ic
                                        >= (_use_syllable_machine_trans_keys[(_keys) as usize])
                                            as i32)
                                {
                                    _trans = (_use_syllable_machine_indices[(_inds
                                        + (_ic
                                            - (_use_syllable_machine_trans_keys[(_keys) as usize])
                                                as i32)
                                            as i32)
                                        as usize])
                                        as u32;
                                } else {
                                    _trans = (_use_syllable_machine_index_defaults[(cs) as usize])
                                        as u32;
                                }
                            }
                        } else {
                            {
                                _trans =
                                    (_use_syllable_machine_index_defaults[(cs) as usize]) as u32;
                            }
                        }
                    }
                }
                cs = (_use_syllable_machine_cond_targs[(_trans) as usize]) as i32;
                if (_use_syllable_machine_cond_actions[(_trans) as usize] != 0) {
                    {
                        match (_use_syllable_machine_cond_actions[(_trans) as usize]) {
                            2 => {
                                te = p + 1;
                            }
                            5 => {
                                te = p + 1;
                                {
                                    found_syllable!(SyllableType::IndependentCluster);
                                }
                            }
                            9 => {
                                te = p + 1;
                                {
                                    found_syllable!(SyllableType::StandardCluster);
                                }
                            }
                            7 => {
                                te = p + 1;
                                {
                                    found_syllable!(SyllableType::BrokenCluster);
                                }
                            }
                            6 => {
                                te = p + 1;
                                {
                                    found_syllable!(SyllableType::NonCluster);
                                }
                            }
                            10 => {
                                te = p;
                                p = p - 1;
                                {
                                    found_syllable!(SyllableType::ViramaTerminatedCluster);
                                }
                            }
                            11 => {
                                te = p;
                                p = p - 1;
                                {
                                    found_syllable!(SyllableType::SakotTerminatedCluster);
                                }
                            }
                            8 => {
                                te = p;
                                p = p - 1;
                                {
                                    found_syllable!(SyllableType::StandardCluster);
                                }
                            }
                            13 => {
                                te = p;
                                p = p - 1;
                                {
                                    found_syllable!(SyllableType::NumberJoinerTerminatedCluster);
                                }
                            }
                            12 => {
                                te = p;
                                p = p - 1;
                                {
                                    found_syllable!(SyllableType::NumeralCluster);
                                }
                            }
                            14 => {
                                te = p;
                                p = p - 1;
                                {
                                    found_syllable!(SyllableType::SymbolCluster);
                                }
                            }
                            17 => {
                                te = p;
                                p = p - 1;
                                {
                                    found_syllable!(SyllableType::HieroglyphCluster);
                                }
                            }
                            15 => {
                                te = p;
                                p = p - 1;
                                {
                                    found_syllable!(SyllableType::BrokenCluster);
                                }
                            }
                            16 => {
                                te = p;
                                p = p - 1;
                                {
                                    found_syllable!(SyllableType::NonCluster);
                                }
                            }
                            1 => {
                                p = (te) - 1;
                                {
                                    found_syllable!(SyllableType::BrokenCluster);
                                }
                            }

                            _ => {}
                        }
                    }
                }
                break '_again;
            }
            if (p == eof) {
                {
                    if (cs >= 2) {
                        break '_resume;
                    }
                }
            } else {
                {
                    match (_use_syllable_machine_to_state_actions[(cs) as usize]) {
                        3 => {
                            ts = p0;
                        }

                        _ => {}
                    }
                    p += 1;
                    continue '_resume;
                }
            }
            break '_resume;
        }
    }
}

#[inline]
fn found_syllable(
    start: usize,
    end: usize,
    syllable_serial: &mut u8,
    kind: SyllableType,
    buffer: &[Cell<GlyphInfo>],
) {
    for i in start..end {
        let mut glyph = buffer[i].get();
        glyph.set_syllable((*syllable_serial << 4) | kind as u8);
        buffer[i].set(glyph);
    }

    *syllable_serial += 1;

    if *syllable_serial == 16 {
        *syllable_serial = 1;
    }
}

fn not_standard_default_ignorable(i: &GlyphInfo) -> bool {
    !(matches!(i.use_category(), category::O | category::RSV) && i.is_default_ignorable())
}

fn included(infos: &[Cell<GlyphInfo>], i: usize) -> bool {
    let glyph = infos[i].get();
    if !not_standard_default_ignorable(&glyph) {
        return false;
    }
    if glyph.use_category() == category::ZWNJ {
        for glyph2 in &infos[i + 1..] {
            if not_standard_default_ignorable(&glyph2.get()) {
                return !glyph2.get().is_unicode_mark();
            }
        }
    }
    true
}
