// vim: set tabstop=4 shiftwidth=4 expandtab:
/*
Gwenview: an image viewer
Copyright 2024 Ivailo Monev <xakepa10@gmail.com>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

*/

// Local
#include "colorframe.h"

// Katie
#include <QPainter>

namespace Gwenview
{

class ColorFramePrivate
{
public:
    QColor color;
};

ColorFrame::ColorFrame(QWidget* parent)
    : QFrame(parent),
    d(new ColorFramePrivate())
{
}

ColorFrame::~ColorFrame()
{
    delete d;
}

void ColorFrame::setColor(const QColor &color)
{
    d->color = color;
    update();
}

void ColorFrame::paintEvent(QPaintEvent *event)
{
    QFrame::paintEvent(event);
    QPainter painter(this);
    QRectF framerect = QFrame::frameRect();
    const int framewidth = QFrame::frameWidth();
    painter.fillRect(framerect.adjusted(framewidth, framewidth, -framewidth, -framewidth), d->color);
    painter.end();
}

} // namespace
