/*
 *   Copyright 2008 Aaron Seigo <aseigo@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef DESKTOPCORONA_H
#define DESKTOPCORONA_H

#include <Plasma/Corona>

#include <QTimer>
#include <QMenu>
#include <QAction>

#include "desktoptracker.h"

namespace Plasma
{
    class Applet;
} // namespace Plasma

/**
 * @short A Corona with desktop-y considerations
 */
class DesktopCorona : public Plasma::Corona
{
    Q_OBJECT

public:
    explicit DesktopCorona(QObject * parent = 0);
    ~DesktopCorona();

    /**
     * Loads the default (system wide) layout for this user
     **/
    void loadDefaultLayout();

    /**
     * Ensures we have the necessary containments for the given screen
     */
    void checkScreen(int screen);

    int numScreens() const;
    QRect screenGeometry(int id) const;
    QRegion availableScreenRegion(int id) const;
    int screenId(const QPoint &pos) const;

public Q_SLOTS:
    QRect availableScreenRect(int id) const;
    void addPanel();
    void addPanel(QAction *action);
    void addPanel(const QString &plugin);
    void populateAddPanelsMenu();

protected Q_SLOTS:
    void screenAdded(const DesktopTracker::Screen &screen);
    void saveDefaultSetup();
    void updateImmutability(Plasma::ImmutabilityType immutability);
    void checkAddPanelAction(const QStringList &sycocaChanges = QStringList());

private:
    void init();

    QAction *m_addPanelAction;
    QMenu *m_addPanelsMenu;
    QTimer *m_delayedUpdateTimer;
};

#endif


