/*
    This file is part of the KDE libraries
    Copyright (C) 2024 Ivailo Monev <xakepa10@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2, as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "kapplication_adaptor.h"
#include "kapplication.h"

KApplicationAdaptor::KApplicationAdaptor(QObject *parent)
    : QDBusAbstractAdaptor(parent)
{
}

QStringList KApplicationAdaptor::restartCommand() const
{
    QStringList result;
    result.append(QCoreApplication::applicationFilePath());
    result.append("--session");
    result.append(QString::fromLatin1("%1_%2").arg(QCoreApplication::applicationName()).arg(QCoreApplication::applicationPid()));
    return result;
}

void KApplicationAdaptor::updateUserTimestamp(int time)
{
    if (kapp) {
        kapp->updateUserTimestamp(time);
    }
}

void KApplicationAdaptor::saveSession()
{
    if (kapp) {
        if (kapp->saveSession()) {
            emit sessionSaved();
        } else {
            emit sessionSaveCanceled();
        }
        return;
    }
    emit sessionSaved();
}

void KApplicationAdaptor::reparseConfiguration()
{
    if (kapp) {
        kapp->reparseConfiguration();
    }
}

void KApplicationAdaptor::quit()
{
    if (kapp) {
        kapp->quit();
    }
}

#include "moc_kapplication_adaptor.cpp"
