/*  This file is part of the KDE libraries
    Copyright (C) 2022 Ivailo Monev <xakepa10@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2, as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "kfilemetadata_freetype.h"
#include "kpluginfactory.h"
#include "kdebug.h"

#include <QFile>

#include <ft2build.h>
#include FT_FREETYPE_H
#include FT_TYPE1_TABLES_H

KFileMetaDataFreetypePlugin::KFileMetaDataFreetypePlugin(QObject* parent, const QVariantList &args)
    : KFileMetaDataPlugin(parent)
{
    Q_UNUSED(args);
}

KFileMetaDataFreetypePlugin::~KFileMetaDataFreetypePlugin()
{
}

QList<KFileMetaInfoItem> KFileMetaDataFreetypePlugin::metaData(const QString &path)
{
    QList<KFileMetaInfoItem> result;
    const QByteArray pathbytes = QFile::encodeName(path);
    FT_Library ftlibrary;
    FT_Init_FreeType(&ftlibrary);
    if (!ftlibrary) {
        kWarning() << "Could not initialize";
        return result;
    }
    FT_Face ftface;
    if (FT_New_Face(ftlibrary, pathbytes.constData(), 0, &ftface) != 0) {
        kWarning() << "Could not open" << pathbytes;
        FT_Done_FreeType(ftlibrary);
        return result;
    }
    const QString ftfamily = QString::fromUtf8(ftface->family_name);
    if (!ftfamily.isEmpty()) {
        result.append(
            KFileMetaInfoItem(
                QString::fromLatin1("http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#fontFamily"),
                ftfamily
            )
        );
    }
    PS_FontInfoRec ftfontinfo;
    if (FT_Get_PS_Font_Info(ftface, &ftfontinfo) == 0) {
        const QString ftnotice = QString::fromUtf8(ftfontinfo.notice);
        if (!ftnotice.isEmpty()) {
            result.append(
                KFileMetaInfoItem(
                    QString::fromLatin1("http://www.semanticdesktop.org/ontologies/2007/01/19/nie#copyright"),
                    ftnotice
                )
            );
        }
    }
    FT_Done_Face(ftface);
    FT_Done_FreeType(ftlibrary);
    return result;
}

K_PLUGIN_FACTORY(KFileMetaDataFreetypePluginFactory, registerPlugin<KFileMetaDataFreetypePlugin>();)
K_EXPORT_PLUGIN(KFileMetaDataFreetypePluginFactory("kfilemetadata_freetype"))

#include "moc_kfilemetadata_freetype.cpp"
