/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Copyright (C) 2016 Ivailo Monev
**
** This file is part of the QtCore module of the Katie Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
**
** GNU Lesser General Public License Usage
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QCONFIG_H
#define QCONFIG_H

// Build specs
#define QT_VERSION_MAJOR 4
#define QT_VERSION_MINOR 14
#define QT_VERSION_MICRO 0
#define QT_VERSION_STR "4.14.0"
#define QT_VERSION_HEX_STR "0x041400"
#define QT_VERSION 0x041400

#define QT_KATIE
#define QT_POINTER_SIZE 8

// The operating system, must be one of Q_OS_x
#define Q_OS_LINUX

// The architechture, must be one of QT_ARCH_x
#define QT_ARCH_X86_64

// Host endianness
#define Q_BIG_ENDIAN 4321
#define Q_LITTLE_ENDIAN 1234
#define Q_BYTE_ORDER Q_LITTLE_ENDIAN

// Not supported, used to bootstrap
/* #undef QT_NO_QOBJECT */
/* #undef QT_NO_THREAD */
/* #undef QT_NO_PROCESS */
/* #undef QT_NO_DATASTREAM */
/* #undef QT_NO_TEXTSTREAM */
/* #undef QT_NO_REGEXP */
/* #undef QT_NO_REGEXP_ANCHOR_ALT */
/* #undef QT_NO_REGEXP_BACKREF */
/* #undef QT_NO_REGEXP_CAPTURE */
/* #undef QT_NO_REGEXP_CCLASS */
/* #undef QT_NO_REGEXP_ESCAPE */
/* #undef QT_NO_REGEXP_INTERVAL */
/* #undef QT_NO_REGEXP_LOOKAHEAD */
/* #undef QT_NO_REGEXP_OPTIM */
/* #undef QT_NO_REGEXP_WILDCARD */
/* #undef QT_NO_STANDARDPATHS */
/* #undef QT_NO_SETTINGS */
/* #undef QT_NO_TEXTCODEC */

// Compiler and host dependant
/* #undef QT_NO_EXCEPTIONS */
/* #undef QT_NO_FPU */

// External packages dependant
/* #undef QT_NO_CUPS */
#define QT_NO_EXECINFO
/* #undef QT_NO_FONTCONFIG */
/* #undef QT_NO_TRANSLATION */
/* #undef QT_NO_XCURSOR */
/* #undef QT_NO_XFIXES */
/* #undef QT_NO_XINERAMA */
/* #undef QT_NO_XRANDR */
/* #undef QT_NO_XRENDER */
/* #undef QT_NO_XSHAPE */
/* #undef QT_NO_XSYNC */
/* #undef QT_NO_XPM */

// Broken, do not set until further notice
/* #undef QT_NO_ACTION */
/* #undef QT_NO_ANIMATION */
/* #undef QT_NO_BUTTONGROUP */
/* #undef QT_NO_CLIPBOARD */
/* #undef QT_NO_DRAGANDDROP */
/* #undef QT_NO_COLORDIALOG */
/* #undef QT_NO_COMBOBOX */
/* #undef QT_NO_COMPLETER */
/* #undef QT_NO_CONTEXTMENU */
/* #undef QT_NO_CSSPARSER */
/* #undef QT_NO_DATESTRING */
/* #undef QT_NO_DEBUG_STREAM */
/* #undef QT_NO_DIRMODEL */
/* #undef QT_NO_DOCKWIDGET */
/* #undef QT_NO_DOM */
/* #undef QT_NO_FILEICONPROVIDER */
/* #undef QT_NO_FILESYSTEMMODEL */
/* #undef QT_NO_FONTCOMBOBOX */
/* #undef QT_NO_GRAPHICSVIEW */
/* #undef QT_NO_GROUPBOX */
/* #undef QT_NO_ICON */
/* #undef QT_NO_INPUTDIALOG */
/* #undef QT_NO_ITEMVIEWS */
/* #undef QT_NO_LINEEDIT */
/* #undef QT_NO_LISTVIEW */
/* #undef QT_NO_LISTWIDGET */
/* #undef QT_NO_MAINWINDOW */
/* #undef QT_NO_MATRIX4X4 */
/* #undef QT_NO_VECTOR3D */
/* #undef QT_NO_MENU */
/* #undef QT_NO_MENUBAR */
/* #undef QT_NO_MESSAGEBOX */
/* #undef QT_NO_PROGRESSBAR */
/* #undef QT_NO_PROPERTIES */
/* #undef QT_NO_PROXYMODEL */
/* #undef QT_NO_RESIZEHANDLER */
/* #undef QT_NO_RUBBERBAND */
/* #undef QT_NO_SCROLLAREA */
/* #undef QT_NO_SCROLLBAR */
/* #undef QT_NO_SHORTCUT */
/* #undef QT_NO_SLIDER */
/* #undef QT_NO_SORTFILTERPROXYMODEL */
/* #undef QT_NO_SPINBOX */
/* #undef QT_NO_SPLITTER */
/* #undef QT_NO_STACKEDWIDGET */
/* #undef QT_NO_STANDARDITEMMODEL */
/* #undef QT_NO_STATUSBAR */
/* #undef QT_NO_STATUSTIP */
/* #undef QT_NO_TABBAR */
/* #undef QT_NO_TABWIDGET */
/* #undef QT_NO_TABLEVIEW */
/* #undef QT_NO_TABLEWIDGET */
/* #undef QT_NO_TEXTCONTROL */
/* #undef QT_NO_TEXTEDIT */
/* #undef QT_NO_TEXTHTMLPARSER */
/* #undef QT_NO_TEXTDATE */
/* #undef QT_NO_TOOLBAR */
/* #undef QT_NO_TOOLBOX */
/* #undef QT_NO_TOOLBUTTON */
/* #undef QT_NO_TOOLTIP */
/* #undef QT_NO_TREEVIEW */
/* #undef QT_NO_TREEWIDGET */
/* #undef QT_NO_UNDOCOMMAND */
/* #undef QT_NO_UNDOSTACK */
/* #undef QT_NO_VALIDATOR */
/* #undef QT_NO_VECTOR4D */
/* #undef QT_NO_XMLSTREAM */
/* #undef QT_NO_XMLSTREAMREADER */
/* #undef QT_NO_XMLSTREAMWRITER */

// Misc
/* #undef QT_NO_BACKINGSTORE */
/* #undef QT_NO_CALENDARWIDGET */
/* #undef QT_NO_COLORNAMES */
/* #undef QT_NO_COLUMNVIEW */
/* #undef QT_NO_CURSOR */
/* #undef QT_NO_DATETIMEEDIT */
#define QT_NO_DEBUG
/* #undef QT_NO_DIAL */
/* #undef QT_NO_DIALOGBUTTONBOX */
/* #undef QT_NO_EFFECTS */
/* #undef QT_NO_FILEDIALOG */
/* #undef QT_NO_FILESYSTEMITERATOR */
/* #undef QT_NO_FILESYSTEMWATCHER */
/* #undef QT_NO_FONTDIALOG */
/* #undef QT_NO_FORMLAYOUT */
/* #undef QT_NO_FRAME */
/* #undef QT_NO_FSCOMPLETER */
/* #undef QT_NO_IDENTITYPROXYMODEL */
/* #undef QT_NO_IMAGE_HEURISTIC_MASK */
/* #undef QT_NO_IPV6 */
/* #undef QT_NO_LCDNUMBER */
/* #undef QT_NO_LIBRARY */
/* #undef QT_NO_LOCALSERVER */
/* #undef QT_NO_LOCALSOCKET */
/* #undef QT_NO_MOVIE */
/* #undef QT_NO_NETWORKINTERFACE */
/* #undef QT_NO_PLUGIN_CHECK */
/* #undef QT_NO_PRINTDIALOG */
/* #undef QT_NO_PRINTER */
/* #undef QT_NO_PRINTPREVIEWDIALOG */
/* #undef QT_NO_PRINTPREVIEWWIDGET */
/* #undef QT_NO_PROGRESSDIALOG */
/* #undef QT_NO_SIGNALMAPPER */
/* #undef QT_NO_SIZEGRIP */
/* #undef QT_NO_SPLASHSCREEN */
/* #undef QT_NO_STRINGLISTMODEL */
/* #undef QT_NO_STYLE_CLEANLOOKS */
/* #undef QT_NO_STYLE_PROXY */
/* #undef QT_NO_STYLE_WINDOWS */
/* #undef QT_NO_SYNTAXHIGHLIGHTER */
/* #undef QT_NO_TEMPORARYFILE */
/* #undef QT_NO_TEXTBROWSER */
/* #undef QT_NO_UDPSOCKET */
/* #undef QT_NO_UNDOGROUP */
/* #undef QT_NO_UNDOVIEW */
/* #undef QT_NO_USING_NAMESPACE */
/* #undef QT_NO_VECTOR2D */
/* #undef QT_NO_WHATSTHIS */
/* #undef QT_NO_WHEELEVENT */
/* #undef QT_NO_WIZARD */

// Debugging

// Animation
#if !defined(QT_NO_ANIMATION) && defined(QT_NO_PROPERTIES)
#  define QT_NO_ANIMATION
#endif

// QButtonGroup
#if !defined(QT_NO_BUTTONGROUP) && defined(QT_NO_GROUPBOX)
#  define QT_NO_BUTTONGROUP
#endif

// QDate/QTime/QDateTime
#if !defined(QT_NO_DATESTRING) && defined(QT_NO_TEXTDATE)
#  define QT_NO_DATESTRING
#endif

// QDial
#if !defined(QT_NO_DIAL) && defined(QT_NO_SLIDER)
#  define QT_NO_DIAL
#endif

// QMenu
#if !defined(QT_NO_MENU) && defined(QT_NO_ACTION)
#  define QT_NO_MENU
#endif

// QProgressDialog
#if !defined(QT_NO_PROGRESSDIALOG) && defined(QT_NO_PROGRESSBAR)
#  define QT_NO_PROGRESSDIALOG
#endif

// QScrollBar
#if !defined(QT_NO_SCROLLBAR) && defined(QT_NO_SLIDER)
#  define QT_NO_SCROLLBAR
#endif

// QSplitter
#if !defined(QT_NO_SPLITTER) && defined(QT_NO_RUBBERBAND)
#  define QT_NO_SPLITTER
#endif

// QToolButton
#if !defined(QT_NO_TOOLBUTTON) && defined(QT_NO_ACTION)
#  define QT_NO_TOOLBUTTON
#endif

// QUndoStack
#if !defined(QT_NO_UNDOSTACK) && defined(QT_NO_UNDOCOMMAND)
#  define QT_NO_UNDOSTACK
#endif

// QWizard
#if !defined(QT_NO_WIZARD) && defined(QT_NO_PROPERTIES)
#  define QT_NO_WIZARD
#endif

// QXmlStreamReader
#if !defined(QT_NO_XMLSTREAMREADER) && defined(QT_NO_XMLSTREAM)
#  define QT_NO_XMLSTREAMREADER
#endif

// QXmlStreamWriter
#if !defined(QT_NO_XMLSTREAMWRITER) && defined(QT_NO_XMLSTREAM)
#  define QT_NO_XMLSTREAMWRITER
#endif

// Context menu
#if !defined(QT_NO_CONTEXTMENU) && defined(QT_NO_MENU)
#  define QT_NO_CONTEXTMENU
#endif

// QScrollArea
#if !defined(QT_NO_SCROLLAREA) && defined(QT_NO_SCROLLBAR)
#  define QT_NO_SCROLLAREA
#endif

// QTabBar
#if !defined(QT_NO_TABBAR) && defined(QT_NO_TOOLBUTTON)
#  define QT_NO_TABBAR
#endif

// QUndoGroup
#if !defined(QT_NO_UNDOGROUP) && defined(QT_NO_UNDOSTACK)
#  define QT_NO_UNDOGROUP
#endif

// QWhatsThis
#if !defined(QT_NO_WHATSTHIS) && defined(QT_NO_TOOLBUTTON)
#  define QT_NO_WHATSTHIS
#endif

// Drag and drop
#if !defined(QT_NO_DRAGANDDROP) && defined(QT_NO_CLIPBOARD)
#  define QT_NO_DRAGANDDROP
#endif

// QGraphicsView
#if !defined(QT_NO_GRAPHICSVIEW) && (defined(QT_NO_SCROLLAREA) || defined(QT_NO_MATRIX4X4) || defined(QT_NO_VECTOR3D))
#  define QT_NO_GRAPHICSVIEW
#endif

// QPrinter
#if !defined(QT_NO_PRINTER) && defined(QT_NO_TEMPORARYFILE)
#  define QT_NO_PRINTER
#endif

// QSpinBox
#if !defined(QT_NO_SPINBOX) && (defined(QT_NO_SPINWIDGET) || defined(QT_NO_LINEEDIT) || defined(QT_NO_VALIDATOR))
#  define QT_NO_SPINBOX
#endif

// QCleanLooksStyle
#if !defined(QT_NO_STYLE_CLEANLOOKS) && defined(QT_NO_STYLE_WINDOWS)
#  define QT_NO_STYLE_CLEANLOOKS
#endif

// QColorDialog
#if !defined(QT_NO_COLORDIALOG) && defined(QT_NO_SPINBOX)
#  define QT_NO_COLORDIALOG
#endif

// The Model/View Framework
#if !defined(QT_NO_ITEMVIEWS) && (defined(QT_NO_RUBBERBAND) || defined(QT_NO_SCROLLAREA))
#  define QT_NO_ITEMVIEWS
#endif

// QMenuBar
#if !defined(QT_NO_MENUBAR) && (defined(QT_NO_MENU) || defined(QT_NO_TOOLBUTTON))
#  define QT_NO_MENUBAR
#endif

// QTabWidget
#if !defined(QT_NO_TABWIDGET) && (defined(QT_NO_TABBAR) || defined(QT_NO_STACKEDWIDGET))
#  define QT_NO_TABWIDGET
#endif

// QTextEdit
#if !defined(QT_NO_TEXTEDIT) && (defined(QT_NO_SCROLLAREA) || defined(QT_NO_PROPERTIES))
#  define QT_NO_TEXTEDIT
#endif

// QListView
#if !defined(QT_NO_LISTVIEW) && defined(QT_NO_ITEMVIEWS)
#  define QT_NO_LISTVIEW
#endif

// QMainWindow
#if !defined(QT_NO_MAINWINDOW) && (defined(QT_NO_MENU) || defined(QT_NO_RESIZEHANDLER) || defined(QT_NO_TOOLBUTTON))
#  define QT_NO_MAINWINDOW
#endif

// QAbstractProxyModel
#if !defined(QT_NO_PROXYMODEL) && defined(QT_NO_ITEMVIEWS)
#  define QT_NO_PROXYMODEL
#endif

// QIdentityProxyModel
#if !defined(QT_NO_IDENTITYPROXYMODEL) && defined(QT_NO_PROXYMODEL)
#  define QT_NO_IDENTITYPROXYMODEL
#endif

// QStandardItemModel
#if !defined(QT_NO_STANDARDITEMMODEL) && defined(QT_NO_ITEMVIEWS)
#  define QT_NO_STANDARDITEMMODEL
#endif

// QStringListModel
#if !defined(QT_NO_STRINGLISTMODEL) && defined(QT_NO_ITEMVIEWS)
#  define QT_NO_STRINGLISTMODEL
#endif

// QSyntaxHighlighter
#if !defined(QT_NO_SYNTAXHIGHLIGHTER) && defined(QT_NO_TEXTEDIT)
#  define QT_NO_SYNTAXHIGHLIGHTER
#endif

// QTableView
#if !defined(QT_NO_TABLEVIEW) && defined(QT_NO_ITEMVIEWS)
#  define QT_NO_TABLEVIEW
#endif

// QTextBrowser
#if !defined(QT_NO_TEXTBROWSER) && defined(QT_NO_TEXTEDIT)
#  define QT_NO_TEXTBROWSER
#endif

// QToolBox
#if !defined(QT_NO_TOOLBOX) && (defined(QT_NO_TOOLBUTTON) || defined(QT_NO_SCROLLAREA))
#  define QT_NO_TOOLBOX
#endif

// QTreeView
#if !defined(QT_NO_TREEVIEW) && defined(QT_NO_ITEMVIEWS)
#  define QT_NO_TREEVIEW
#endif

// QColumnView
#if !defined(QT_NO_COLUMNVIEW) && defined(QT_NO_LISTVIEW)
#  define QT_NO_COLUMNVIEW
#endif

// QCompleter
#if !defined(QT_NO_COMPLETER) && defined(QT_NO_PROXYMODEL)
#  define QT_NO_COMPLETER
#endif

// QListWidget
#if !defined(QT_NO_LISTWIDGET) && defined(QT_NO_LISTVIEW)
#  define QT_NO_LISTWIDGET
#endif

// QSortFilterProxyModel
#if !defined(QT_NO_SORTFILTERPROXYMODEL) && defined(QT_NO_PROXYMODEL)
#  define QT_NO_SORTFILTERPROXYMODEL
#endif

// QTableWidget
#if !defined(QT_NO_TABLEWIDGET) && defined(QT_NO_TABLEVIEW)
#  define QT_NO_TABLEWIDGET
#endif

// QToolBar
#if !defined(QT_NO_TOOLBAR) && defined(QT_NO_MAINWINDOW)
#  define QT_NO_TOOLBAR
#endif

// QTreeWidget
#if !defined(QT_NO_TREEWIDGET) && defined(QT_NO_TREEVIEW)
#  define QT_NO_TREEWIDGET
#endif

// QDirModel
#if !defined(QT_NO_DIRMODEL) && (defined(QT_NO_ITEMVIEWS) || defined(QT_NO_FILESYSTEMMODEL))
#  define QT_NO_DIRMODEL
#endif

// QDockwidget
#if !defined(QT_NO_DOCKWIDGET) && (defined(QT_NO_RUBBERBAND) || defined(QT_NO_MAINWINDOW))
#  define QT_NO_DOCKWIDGET
#endif

// QUndoView
#if !defined(QT_NO_UNDOVIEW) && (defined(QT_NO_UNDOSTACK) || defined(QT_NO_LISTVIEW))
#  define QT_NO_UNDOVIEW
#endif

// QCompleter
#if !defined(QT_NO_FSCOMPLETER) && (defined(QT_NO_FILESYSTEMMODEL) || defined(QT_NO_COMPLETER))
#  define QT_NO_FSCOMPLETER
#endif

// QComboBox
#if !defined(QT_NO_COMBOBOX) && (defined(QT_NO_LINEEDIT) || defined(QT_NO_STANDARDITEMMODEL) || defined(QT_NO_LISTVIEW))
#  define QT_NO_COMBOBOX
#endif

// QPrintPreviewWidget
#if !defined(QT_NO_PRINTPREVIEWWIDGET) && (defined(QT_NO_GRAPHICSVIEW) || defined(QT_NO_PRINTER) || defined(QT_NO_MAINWINDOW))
#  define QT_NO_PRINTPREVIEWWIDGET
#endif

// QCalendarWidget
#if !defined(QT_NO_CALENDARWIDGET) && (defined(QT_NO_TABLEVIEW) || defined(QT_NO_MENU) || defined(QT_NO_TEXTDATE) || defined(QT_NO_SPINBOX) || defined(QT_NO_TOOLBUTTON))
#  define QT_NO_CALENDARWIDGET
#endif

// QDateTimeEdit
#if !defined(QT_NO_DATETIMEEDIT) && (defined(QT_NO_CALENDARWIDGET) || defined(QT_NO_DATESTRING))
#  define QT_NO_DATETIMEEDIT
#endif

// QInputDialog
#if !defined(QT_NO_INPUTDIALOG) && (defined(QT_NO_COMBOBOX) || defined(QT_NO_SPINBOX) || defined(QT_NO_STACKEDWIDGET))
#  define QT_NO_INPUTDIALOG
#endif

// QFontComboBox
#if !defined(QT_NO_FONTCOMBOBOX) && (defined(QT_NO_COMBOBOX) || defined(QT_NO_STRINGLISTMODEL))
#  define QT_NO_FONTCOMBOBOX
#endif

// QFontDialog
#if !defined(QT_NO_FONTDIALOG) && (defined(QT_NO_STRINGLISTMODEL) || defined(QT_NO_COMBOBOX) || defined(QT_NO_VALIDATOR) || defined(QT_NO_GROUPBOX))
#  define QT_NO_FONTDIALOG
#endif

// QPrintDialog
#if !defined(QT_NO_PRINTDIALOG) && (defined(QT_NO_PRINTER) || defined(QT_NO_COMBOBOX) || defined(QT_NO_BUTTONGROUP) || defined(QT_NO_SPINBOX) || defined(QT_NO_TREEVIEW) || defined(QT_NO_TABWIDGET))
#  define QT_NO_PRINTDIALOG
#endif

// QFileDialog
#if !defined(QT_NO_FILEDIALOG) && (defined(QT_NO_DIRMODEL) || defined(QT_NO_TREEVIEW) || defined(QT_NO_COMBOBOX) || defined(QT_NO_TOOLBUTTON) || defined(QT_NO_BUTTONGROUP) || defined(QT_NO_TOOLTIP) || defined(QT_NO_SPLITTER) || defined(QT_NO_STACKEDWIDGET) || defined(QT_NO_PROXYMODEL))
#  define QT_NO_FILEDIALOG
#endif

// QPrintPreviewDialog
#if !defined(QT_NO_PRINTPREVIEWDIALOG) && (defined(QT_NO_PRINTPREVIEWWIDGET) || defined(QT_NO_PRINTDIALOG) || defined(QT_NO_TOOLBAR))
#  define QT_NO_PRINTPREVIEWDIALOG
#endif

// QLocalServer
#if !defined(QT_NO_LOCALSERVER) && defined(QT_NO_LOCALSOCKET)
#  define QT_NO_LOCALSERVER
#endif

// Always off when building Katie, may be defined by application
// QT_NO_DYNAMIC_CAST
// QT_NO_URL_CAST_FROM_STRING
// QT_NO_CAST_FROM_ASCII
// QT_NO_CAST_FROM_BYTEARRAY
// QT_NO_CAST_TO_ASCII
// QT_NO_KEYWORDS
// QT_NO_TEMPLATE_TEMPLATE_PARAMETERS
// QT_NO_QOBJECT_CHECK

#endif
