/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Copyright (C) 2016 Ivailo Monev
**
** This file is part of the QtCore module of the Katie Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
**
** GNU Lesser General Public License Usage
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qplatformdefs.h"
#include "qfilesystemiterator_p.h"

#ifndef QT_NO_FILESYSTEMITERATOR

#include <stdlib.h>

QT_BEGIN_NAMESPACE

QFileSystemIterator::QFileSystemIterator(const QFileSystemEntry &entry)
    : nativePath(entry.nativeFilePath())
    , dir(nullptr)
{
    dir = QT_OPENDIR(nativePath.constData());

    if (dir && !nativePath.endsWith('/')) {
        nativePath.append('/');
    }
}

QFileSystemIterator::~QFileSystemIterator()
{
    if (dir) {
        QT_CLOSEDIR(dir);
    }
}

bool QFileSystemIterator::advance(QFileSystemEntry &fileEntry, QFileSystemMetaData &metaData)
{
    if (!dir) {
        return false;
    }

    const QT_DIRENT *dirEntry = QT_READDIR(dir);
    if (dirEntry) {
        fileEntry = QFileSystemEntry(nativePath + QByteArray(dirEntry->d_name), QFileSystemEntry::FromNativePath());
        metaData.fillFromDirEnt(dirEntry, fileEntry.nativeFilePath());
        return true;
    }

    return false;
}

QT_END_NAMESPACE

#endif // QT_NO_FILESYSTEMITERATOR
