/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Copyright (C) 2016 Ivailo Monev
**
** This file is part of the QtGui module of the Katie Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
**
** GNU Lesser General Public License Usage
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QPRINTERINFO_P_H
#define QPRINTERINFO_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Katie API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include "QtCore/qglobal.h"

#ifndef QT_NO_PRINTER

#include "QtCore/qlist.h"

QT_BEGIN_NAMESPACE

class QPrinterInfoPrivate
{
public:
    QPrinterInfoPrivate(const QString& name = QString()) :
        name(name), isDefault(false)
#if !defined(QT_NO_CUPS)
        , cupsPrinterIndex(0), hasPaperSizes(false)
#endif
    {}
    ~QPrinterInfoPrivate()
    {}

    static QPrinterInfoPrivate shared_null;

    QString name;
    bool isDefault;

#if !defined(QT_NO_CUPS)
    int cupsPrinterIndex;
    mutable bool hasPaperSizes;
    mutable QList<QPrinter::PaperSize> paperSizes;
#endif
};


class QPrinterInfoPrivateDeleter
{
public:
    static inline void cleanup(QPrinterInfoPrivate *d)
    {
        if (d != &QPrinterInfoPrivate::shared_null)
            delete d;
    }
};

QT_END_NAMESPACE

#endif // QT_NO_PRINTER

#endif // QPRINTERINFO_P_H
