/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Copyright (C) 2016 Ivailo Monev
**
** This file is part of the tools applications of the Katie Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
**
** GNU Lesser General Public License Usage
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "cppwriteincludes.h"
#include "driver.h"
#include "ui4.h"
#include "uic.h"

#include <QtCore/QDebug>
#include <QtCore/QFileInfo>
#include <QtCore/QTextStream>

#include <stdio.h>

QT_BEGIN_NAMESPACE

#define DEBUG_WRITE_INCLUDES 0
#define WARN_HEADER_GENERATOR 0

namespace CPP {

// generated by genmap.py
static const struct ClassTblData {
    const QLatin1String klass;
    const QLatin1String header;
} ClassTbl[] = {
    { QLatin1String("QAbstractAnimation"), QLatin1String("QtGui/qabstractanimation.h") },
    { QLatin1String("QAbstractButton"), QLatin1String("QtGui/qabstractbutton.h") },
    { QLatin1String("QAbstractEventDispatcher"), QLatin1String("QtCore/qabstracteventdispatcher.h") },
    { QLatin1String("QAbstractFormBuilder"), QLatin1String("QtUiTools/abstractformbuilder.h") },
    { QLatin1String("QAbstractGraphicsShapeItem"), QLatin1String("QtGui/qgraphicsitem.h") },
    { QLatin1String("QAbstractItemDelegate"), QLatin1String("QtGui/qabstractitemdelegate.h") },
    { QLatin1String("QAbstractItemModel"), QLatin1String("QtCore/qabstractitemmodel.h") },
    { QLatin1String("QAbstractItemView"), QLatin1String("QtGui/qabstractitemview.h") },
    { QLatin1String("QAbstractListModel"), QLatin1String("QtCore/qabstractitemmodel.h") },
    { QLatin1String("QAbstractPageSetupDialog"), QLatin1String("QtGui/qabstractpagesetupdialog.h") },
    { QLatin1String("QAbstractPrintDialog"), QLatin1String("QtGui/qabstractprintdialog.h") },
    { QLatin1String("QAbstractProxyModel"), QLatin1String("QtGui/qabstractproxymodel.h") },
    { QLatin1String("QAbstractScrollArea"), QLatin1String("QtGui/qabstractscrollarea.h") },
    { QLatin1String("QAbstractSlider"), QLatin1String("QtGui/qabstractslider.h") },
    { QLatin1String("QAbstractSocket"), QLatin1String("QtNetwork/qabstractsocket.h") },
    { QLatin1String("QAbstractSpinBox"), QLatin1String("QtGui/qabstractspinbox.h") },
    { QLatin1String("QAbstractTableModel"), QLatin1String("QtCore/qabstractitemmodel.h") },
    { QLatin1String("QAbstractTextDocumentLayout"), QLatin1String("QtGui/qabstracttextdocumentlayout.h") },
    { QLatin1String("QAbstractUndoItem"), QLatin1String("QtGui/qtextdocument.h") },
    { QLatin1String("QAction"), QLatin1String("QtGui/qaction.h") },
    { QLatin1String("QActionEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QActionGroup"), QLatin1String("QtGui/qactiongroup.h") },
    { QLatin1String("QAnimationGroup"), QLatin1String("QtGui/qanimationgroup.h") },
    { QLatin1String("QApplication"), QLatin1String("QtGui/qapplication.h") },
    { QLatin1String("QAtomicInt"), QLatin1String("QtCore/qatomic.h") },
    { QLatin1String("QAtomicPointer"), QLatin1String("QtCore/qatomic.h") },
    { QLatin1String("QBasicTimer"), QLatin1String("QtCore/qbasictimer.h") },
    { QLatin1String("QBenchmarkIterationController"), QLatin1String("QtTest/qbenchmark.h") },
    { QLatin1String("QBitArray"), QLatin1String("QtCore/qbitarray.h") },
    { QLatin1String("QBitRef"), QLatin1String("QtCore/qbitarray.h") },
    { QLatin1String("QBitmap"), QLatin1String("QtGui/qbitmap.h") },
    { QLatin1String("QBoxLayout"), QLatin1String("QtGui/qboxlayout.h") },
    { QLatin1String("QBrush"), QLatin1String("QtGui/qbrush.h") },
    { QLatin1String("QBuffer"), QLatin1String("QtCore/qbuffer.h") },
    { QLatin1String("QButtonGroup"), QLatin1String("QtGui/qbuttongroup.h") },
    { QLatin1String("QByteArray"), QLatin1String("QtCore/qbytearray.h") },
    { QLatin1String("QByteArrayMatcher"), QLatin1String("QtCore/qbytearraymatcher.h") },
    { QLatin1String("QByteRef"), QLatin1String("QtCore/qbytearray.h") },
    { QLatin1String("QCache"), QLatin1String("QtCore/qcache.h") },
    { QLatin1String("QCalendarWidget"), QLatin1String("QtGui/qcalendarwidget.h") },
    { QLatin1String("QChar"), QLatin1String("QtCore/qchar.h") },
    { QLatin1String("QCharRef"), QLatin1String("QtCore/qstring.h") },
    { QLatin1String("QCheckBox"), QLatin1String("QtGui/qcheckbox.h") },
    { QLatin1String("QChildEvent"), QLatin1String("QtCore/qcoreevent.h") },
    { QLatin1String("QCleanlooksStyle"), QLatin1String("QtGui/qcleanlooksstyle.h") },
    { QLatin1String("QClipboard"), QLatin1String("QtGui/qclipboard.h") },
    { QLatin1String("QCloseEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QColor"), QLatin1String("QtGui/qcolor.h") },
    { QLatin1String("QColorDialog"), QLatin1String("QtGui/qcolordialog.h") },
    { QLatin1String("QColumnView"), QLatin1String("QtGui/qcolumnview.h") },
    { QLatin1String("QComboBox"), QLatin1String("QtGui/qcombobox.h") },
    { QLatin1String("QCommandLinkButton"), QLatin1String("QtGui/qcommandlinkbutton.h") },
    { QLatin1String("QCommonStyle"), QLatin1String("QtGui/qcommonstyle.h") },
    { QLatin1String("QCompleter"), QLatin1String("QtGui/qcompleter.h") },
    { QLatin1String("QContextMenuEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QCoreApplication"), QLatin1String("QtCore/qcoreapplication.h") },
    { QLatin1String("QCryptographicHash"), QLatin1String("QtNetwork/qcryptographichash.h") },
    { QLatin1String("QCursor"), QLatin1String("QtGui/qcursor.h") },
    { QLatin1String("QCustomWidget"), QLatin1String("QtUiTools/customwidget.h") },
    { QLatin1String("QCustomWidgetPlugin"), QLatin1String("QtUiTools/customwidget.h") },
    { QLatin1String("QDBusAbstractAdaptor"), QLatin1String("QtDBus/qdbusabstractadaptor.h") },
    { QLatin1String("QDBusAbstractInterface"), QLatin1String("QtDBus/qdbusabstractinterface.h") },
    { QLatin1String("QDBusAbstractInterfaceBase"), QLatin1String("QtDBus/qdbusabstractinterface.h") },
    { QLatin1String("QDBusArgument"), QLatin1String("QtDBus/qdbusargument.h") },
    { QLatin1String("QDBusConnection"), QLatin1String("QtDBus/qdbusconnection.h") },
    { QLatin1String("QDBusConnectionInterface"), QLatin1String("QtDBus/qdbusconnectioninterface.h") },
    { QLatin1String("QDBusContext"), QLatin1String("QtDBus/qdbuscontext.h") },
    { QLatin1String("QDBusError"), QLatin1String("QtDBus/qdbuserror.h") },
    { QLatin1String("QDBusInterface"), QLatin1String("QtDBus/qdbusinterface.h") },
    { QLatin1String("QDBusMessage"), QLatin1String("QtDBus/qdbusmessage.h") },
    { QLatin1String("QDBusMetaType"), QLatin1String("QtDBus/qdbusmetatype.h") },
    { QLatin1String("QDBusObjectPath"), QLatin1String("QtDBus/qdbusextratypes.h") },
    { QLatin1String("QDBusPendingCall"), QLatin1String("QtDBus/qdbuspendingcall.h") },
    { QLatin1String("QDBusPendingCallWatcher"), QLatin1String("QtDBus/qdbuspendingcall.h") },
    { QLatin1String("QDBusPendingReplyData"), QLatin1String("QtDBus/qdbuspendingreply.h") },
    { QLatin1String("QDBusReply"), QLatin1String("QtDBus/qdbusreply.h") },
    { QLatin1String("QDBusServer"), QLatin1String("QtDBus/qdbusserver.h") },
    { QLatin1String("QDBusServiceWatcher"), QLatin1String("QtDBus/qdbusservicewatcher.h") },
    { QLatin1String("QDBusSignature"), QLatin1String("QtDBus/qdbusextratypes.h") },
    { QLatin1String("QDBusUnixFileDescriptor"), QLatin1String("QtDBus/qdbusunixfiledescriptor.h") },
    { QLatin1String("QDBusVariant"), QLatin1String("QtDBus/qdbusextratypes.h") },
    { QLatin1String("QDataStream"), QLatin1String("QtCore/qdatastream.h") },
    { QLatin1String("QDate"), QLatin1String("QtCore/qdatetime.h") },
    { QLatin1String("QDateEdit"), QLatin1String("QtGui/qdatetimeedit.h") },
    { QLatin1String("QDateTime"), QLatin1String("QtCore/qdatetime.h") },
    { QLatin1String("QDateTimeEdit"), QLatin1String("QtGui/qdatetimeedit.h") },
    { QLatin1String("QDebug"), QLatin1String("QtCore/qdebug.h") },
    { QLatin1String("QDesktopWidget"), QLatin1String("QtGui/qdesktopwidget.h") },
    { QLatin1String("QDial"), QLatin1String("QtGui/qdial.h") },
    { QLatin1String("QDialog"), QLatin1String("QtGui/qdialog.h") },
    { QLatin1String("QDialogButtonBox"), QLatin1String("QtGui/qdialogbuttonbox.h") },
    { QLatin1String("QDir"), QLatin1String("QtCore/qdir.h") },
    { QLatin1String("QDirIterator"), QLatin1String("QtCore/qdiriterator.h") },
    { QLatin1String("QDirModel"), QLatin1String("QtGui/qdirmodel.h") },
    { QLatin1String("QDockWidget"), QLatin1String("QtGui/qdockwidget.h") },
    { QLatin1String("QDomAttr"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDomCDATASection"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDomCharacterData"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDomComment"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDomDocument"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDomDocumentFragment"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDomDocumentType"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDomElement"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDomEntity"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDomEntityReference"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDomImplementation"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDomNamedNodeMap"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDomNode"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDomNodeList"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDomNotation"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDomProcessingInstruction"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDomText"), QLatin1String("QtXml/qdom.h") },
    { QLatin1String("QDoubleSpinBox"), QLatin1String("QtGui/qspinbox.h") },
    { QLatin1String("QDoubleValidator"), QLatin1String("QtGui/qvalidator.h") },
    { QLatin1String("QDrag"), QLatin1String("QtGui/qdrag.h") },
    { QLatin1String("QDragEnterEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QDragLeaveEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QDragMoveEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QDropEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QDynamicPropertyChangeEvent"), QLatin1String("QtCore/qcoreevent.h") },
    { QLatin1String("QEasingCurve"), QLatin1String("QtCore/qeasingcurve.h") },
    { QLatin1String("QElapsedTimer"), QLatin1String("QtCore/qelapsedtimer.h") },
    { QLatin1String("QEvent"), QLatin1String("QtCore/qcoreevent.h") },
    { QLatin1String("QEventLoop"), QLatin1String("QtCore/qeventloop.h") },
    { QLatin1String("QFile"), QLatin1String("QtCore/qfile.h") },
    { QLatin1String("QFileDialog"), QLatin1String("QtGui/qfiledialog.h") },
    { QLatin1String("QFileIconProvider"), QLatin1String("QtGui/qfileiconprovider.h") },
    { QLatin1String("QFileInfo"), QLatin1String("QtCore/qfileinfo.h") },
    { QLatin1String("QFileSystemModel"), QLatin1String("QtGui/qfilesystemmodel.h") },
    { QLatin1String("QFileSystemWatcher"), QLatin1String("QtCore/qfilesystemwatcher.h") },
    { QLatin1String("QFlag"), QLatin1String("QtCore/qglobal.h") },
    { QLatin1String("QFocusEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QFocusFrame"), QLatin1String("QtGui/qfocusframe.h") },
    { QLatin1String("QFont"), QLatin1String("QtGui/qfont.h") },
    { QLatin1String("QFontComboBox"), QLatin1String("QtGui/qfontcombobox.h") },
    { QLatin1String("QFontDatabase"), QLatin1String("QtGui/qfontdatabase.h") },
    { QLatin1String("QFontDialog"), QLatin1String("QtGui/qfontdialog.h") },
    { QLatin1String("QFontMetrics"), QLatin1String("QtGui/qfontmetrics.h") },
    { QLatin1String("QFontMetricsF"), QLatin1String("QtGui/qfontmetrics.h") },
    { QLatin1String("QFormBuilder"), QLatin1String("QtUiTools/formbuilder.h") },
    { QLatin1String("QFormLayout"), QLatin1String("QtGui/qformlayout.h") },
    { QLatin1String("QFrame"), QLatin1String("QtGui/qframe.h") },
    { QLatin1String("QGenericArgument"), QLatin1String("QtCore/qobjectdefs.h") },
    { QLatin1String("QGenericReturnArgument"), QLatin1String("QtCore/qobjectdefs.h") },
    { QLatin1String("QGradient"), QLatin1String("QtGui/qbrush.h") },
    { QLatin1String("QGraphicsAnchor"), QLatin1String("QtGui/qgraphicsanchorlayout.h") },
    { QLatin1String("QGraphicsAnchorLayout"), QLatin1String("QtGui/qgraphicsanchorlayout.h") },
    { QLatin1String("QGraphicsEllipseItem"), QLatin1String("QtGui/qgraphicsitem.h") },
    { QLatin1String("QGraphicsGridLayout"), QLatin1String("QtGui/qgraphicsgridlayout.h") },
    { QLatin1String("QGraphicsItem"), QLatin1String("QtGui/qgraphicsitem.h") },
    { QLatin1String("QGraphicsItemAnimation"), QLatin1String("QtGui/qgraphicsitemanimation.h") },
    { QLatin1String("QGraphicsItemGroup"), QLatin1String("QtGui/qgraphicsitem.h") },
    { QLatin1String("QGraphicsLayout"), QLatin1String("QtGui/qgraphicslayout.h") },
    { QLatin1String("QGraphicsLayoutItem"), QLatin1String("QtGui/qgraphicslayoutitem.h") },
    { QLatin1String("QGraphicsLineItem"), QLatin1String("QtGui/qgraphicsitem.h") },
    { QLatin1String("QGraphicsLinearLayout"), QLatin1String("QtGui/qgraphicslinearlayout.h") },
    { QLatin1String("QGraphicsObject"), QLatin1String("QtGui/qgraphicsitem.h") },
    { QLatin1String("QGraphicsPathItem"), QLatin1String("QtGui/qgraphicsitem.h") },
    { QLatin1String("QGraphicsPixmapItem"), QLatin1String("QtGui/qgraphicsitem.h") },
    { QLatin1String("QGraphicsPolygonItem"), QLatin1String("QtGui/qgraphicsitem.h") },
    { QLatin1String("QGraphicsProxyWidget"), QLatin1String("QtGui/qgraphicsproxywidget.h") },
    { QLatin1String("QGraphicsRectItem"), QLatin1String("QtGui/qgraphicsitem.h") },
    { QLatin1String("QGraphicsScene"), QLatin1String("QtGui/qgraphicsscene.h") },
    { QLatin1String("QGraphicsSceneContextMenuEvent"), QLatin1String("QtGui/qgraphicssceneevent.h") },
    { QLatin1String("QGraphicsSceneDragDropEvent"), QLatin1String("QtGui/qgraphicssceneevent.h") },
    { QLatin1String("QGraphicsSceneEvent"), QLatin1String("QtGui/qgraphicssceneevent.h") },
    { QLatin1String("QGraphicsSceneHelpEvent"), QLatin1String("QtGui/qgraphicssceneevent.h") },
    { QLatin1String("QGraphicsSceneHoverEvent"), QLatin1String("QtGui/qgraphicssceneevent.h") },
    { QLatin1String("QGraphicsSceneMouseEvent"), QLatin1String("QtGui/qgraphicssceneevent.h") },
    { QLatin1String("QGraphicsSceneMoveEvent"), QLatin1String("QtGui/qgraphicssceneevent.h") },
    { QLatin1String("QGraphicsSceneResizeEvent"), QLatin1String("QtGui/qgraphicssceneevent.h") },
    { QLatin1String("QGraphicsSceneWheelEvent"), QLatin1String("QtGui/qgraphicssceneevent.h") },
    { QLatin1String("QGraphicsSimpleTextItem"), QLatin1String("QtGui/qgraphicsitem.h") },
    { QLatin1String("QGraphicsTextItem"), QLatin1String("QtGui/qgraphicsitem.h") },
    { QLatin1String("QGraphicsView"), QLatin1String("QtGui/qgraphicsview.h") },
    { QLatin1String("QGraphicsWidget"), QLatin1String("QtGui/qgraphicswidget.h") },
    { QLatin1String("QGridLayout"), QLatin1String("QtGui/qgridlayout.h") },
    { QLatin1String("QGroupBox"), QLatin1String("QtGui/qgroupbox.h") },
    { QLatin1String("QGuiPlatformPlugin"), QLatin1String("QtGui/qguiplatformplugin.h") },
    { QLatin1String("QHBoxLayout"), QLatin1String("QtGui/qboxlayout.h") },
    { QLatin1String("QHash"), QLatin1String("QtCore/qhash.h") },
    { QLatin1String("QHashData"), QLatin1String("QtCore/qhash.h") },
    { QLatin1String("QHeaderView"), QLatin1String("QtGui/qheaderview.h") },
    { QLatin1String("QHelpEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QHideEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QHostAddress"), QLatin1String("QtNetwork/qhostaddress.h") },
    { QLatin1String("QHostInfo"), QLatin1String("QtNetwork/qhostinfo.h") },
    { QLatin1String("QHoverEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QIODevice"), QLatin1String("QtCore/qiodevice.h") },
    { QLatin1String("QIcon"), QLatin1String("QtGui/qicon.h") },
    { QLatin1String("QIconEngine"), QLatin1String("QtGui/qiconengine.h") },
    { QLatin1String("QIdentityProxyModel"), QLatin1String("QtGui/qidentityproxymodel.h") },
    { QLatin1String("QImage"), QLatin1String("QtGui/qimage.h") },
    { QLatin1String("QImageIOHandler"), QLatin1String("QtGui/qimageiohandler.h") },
    { QLatin1String("QImageIOPlugin"), QLatin1String("QtGui/qimageiohandler.h") },
    { QLatin1String("QImageReader"), QLatin1String("QtGui/qimagereader.h") },
    { QLatin1String("QImageWriter"), QLatin1String("QtGui/qimagewriter.h") },
    { QLatin1String("QIncompatibleFlag"), QLatin1String("QtCore/qglobal.h") },
    { QLatin1String("QInputDialog"), QLatin1String("QtGui/qinputdialog.h") },
    { QLatin1String("QInputEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QIntValidator"), QLatin1String("QtGui/qvalidator.h") },
    { QLatin1String("QInternal"), QLatin1String("QtCore/qnamespace.h") },
    { QLatin1String("QItemDelegate"), QLatin1String("QtGui/qitemdelegate.h") },
    { QLatin1String("QItemEditorFactory"), QLatin1String("QtGui/qitemeditorfactory.h") },
    { QLatin1String("QItemSelection"), QLatin1String("QtGui/qitemselectionmodel.h") },
    { QLatin1String("QItemSelectionModel"), QLatin1String("QtGui/qitemselectionmodel.h") },
    { QLatin1String("QItemSelectionRange"), QLatin1String("QtGui/qitemselectionmodel.h") },
    { QLatin1String("QJsonDocument"), QLatin1String("QtCore/qjsondocument.h") },
    { QLatin1String("QKeyEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QKeySequence"), QLatin1String("QtGui/qkeysequence.h") },
    { QLatin1String("QLCDNumber"), QLatin1String("QtGui/qlcdnumber.h") },
    { QLatin1String("QLabel"), QLatin1String("QtGui/qlabel.h") },
    { QLatin1String("QLatin1String"), QLatin1String("QtCore/qstring.h") },
    { QLatin1String("QLayout"), QLatin1String("QtGui/qlayout.h") },
    { QLatin1String("QLayoutItem"), QLatin1String("QtGui/qlayoutitem.h") },
    { QLatin1String("QLibrary"), QLatin1String("QtCore/qlibrary.h") },
    { QLatin1String("QLibraryInfo"), QLatin1String("QtCore/qlibraryinfo.h") },
    { QLatin1String("QLine"), QLatin1String("QtCore/qline.h") },
    { QLatin1String("QLineEdit"), QLatin1String("QtGui/qlineedit.h") },
    { QLatin1String("QLineF"), QLatin1String("QtCore/qline.h") },
    { QLatin1String("QLinearGradient"), QLatin1String("QtGui/qbrush.h") },
    { QLatin1String("QList"), QLatin1String("QtCore/qlist.h") },
    { QLatin1String("QListData"), QLatin1String("QtCore/qlist.h") },
    { QLatin1String("QListView"), QLatin1String("QtGui/qlistview.h") },
    { QLatin1String("QListWidget"), QLatin1String("QtGui/qlistwidget.h") },
    { QLatin1String("QListWidgetItem"), QLatin1String("QtGui/qlistwidget.h") },
    { QLatin1String("QLocalServer"), QLatin1String("QtNetwork/qlocalserver.h") },
    { QLatin1String("QLocalSocket"), QLatin1String("QtNetwork/qlocalsocket.h") },
    { QLatin1String("QLocale"), QLatin1String("QtCore/qlocale.h") },
    { QLatin1String("QMainWindow"), QLatin1String("QtGui/qmainwindow.h") },
    { QLatin1String("QMap"), QLatin1String("QtCore/qmap.h") },
    { QLatin1String("QMapData"), QLatin1String("QtCore/qmap.h") },
    { QLatin1String("QMatrix"), QLatin1String("QtGui/qmatrix.h") },
    { QLatin1String("QMatrix4x4"), QLatin1String("QtGui/qmatrix4x4.h") },
    { QLatin1String("QMenu"), QLatin1String("QtGui/qmenu.h") },
    { QLatin1String("QMenuBar"), QLatin1String("QtGui/qmenubar.h") },
    { QLatin1String("QMessageBox"), QLatin1String("QtGui/qmessagebox.h") },
    { QLatin1String("QMetaClassInfo"), QLatin1String("QtCore/qmetaobject.h") },
    { QLatin1String("QMetaEnum"), QLatin1String("QtCore/qmetaobject.h") },
    { QLatin1String("QMetaMethod"), QLatin1String("QtCore/qmetaobject.h") },
    { QLatin1String("QMetaObject"), QLatin1String("QtCore/qobjectdefs.h") },
    { QLatin1String("QMetaProperty"), QLatin1String("QtCore/qmetaobject.h") },
    { QLatin1String("QMetaType"), QLatin1String("QtCore/qmetatype.h") },
    { QLatin1String("QMimeData"), QLatin1String("QtCore/qmimedata.h") },
    { QLatin1String("QModelIndex"), QLatin1String("QtCore/qabstractitemmodel.h") },
    { QLatin1String("QMouseEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QMoveEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QMovie"), QLatin1String("QtGui/qmovie.h") },
    { QLatin1String("QMultiHash"), QLatin1String("QtCore/qhash.h") },
    { QLatin1String("QMutex"), QLatin1String("QtCore/qmutex.h") },
    { QLatin1String("QMutexLocker"), QLatin1String("QtCore/qmutex.h") },
    { QLatin1String("QNetworkAddressEntry"), QLatin1String("QtNetwork/qnetworkinterface.h") },
    { QLatin1String("QNetworkInterface"), QLatin1String("QtNetwork/qnetworkinterface.h") },
    { QLatin1String("QObject"), QLatin1String("QtCore/qobject.h") },
    { QLatin1String("QObjectCleanupHandler"), QLatin1String("QtCore/qobjectcleanuphandler.h") },
    { QLatin1String("QPageSetupDialog"), QLatin1String("QtGui/qpagesetupdialog.h") },
    { QLatin1String("QPaintDevice"), QLatin1String("QtGui/qpaintdevice.h") },
    { QLatin1String("QPaintEngine"), QLatin1String("QtGui/qpaintengine.h") },
    { QLatin1String("QPaintEngineState"), QLatin1String("QtGui/qpaintengine.h") },
    { QLatin1String("QPaintEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QPainter"), QLatin1String("QtGui/qpainter.h") },
    { QLatin1String("QPainterPath"), QLatin1String("QtGui/qpainterpath.h") },
    { QLatin1String("QPainterPathStroker"), QLatin1String("QtGui/qpainterpath.h") },
    { QLatin1String("QPair"), QLatin1String("QtCore/qpair.h") },
    { QLatin1String("QPalette"), QLatin1String("QtGui/qpalette.h") },
    { QLatin1String("QParallelAnimationGroup"), QLatin1String("QtGui/qparallelanimationgroup.h") },
    { QLatin1String("QPauseAnimation"), QLatin1String("QtGui/qpauseanimation.h") },
    { QLatin1String("QPen"), QLatin1String("QtGui/qpen.h") },
    { QLatin1String("QPersistentModelIndex"), QLatin1String("QtCore/qabstractitemmodel.h") },
    { QLatin1String("QPixmap"), QLatin1String("QtGui/qpixmap.h") },
    { QLatin1String("QPixmapCache"), QLatin1String("QtGui/qpixmapcache.h") },
    { QLatin1String("QPlainTextDocumentLayout"), QLatin1String("QtGui/qplaintextedit.h") },
    { QLatin1String("QPlainTextEdit"), QLatin1String("QtGui/qplaintextedit.h") },
    { QLatin1String("QPluginLoader"), QLatin1String("QtCore/qpluginloader.h") },
    { QLatin1String("QPoint"), QLatin1String("QtCore/qpoint.h") },
    { QLatin1String("QPointF"), QLatin1String("QtCore/qpoint.h") },
    { QLatin1String("QPointer"), QLatin1String("QtCore/qpointer.h") },
    { QLatin1String("QPolygon"), QLatin1String("QtGui/qpolygon.h") },
    { QLatin1String("QPolygonF"), QLatin1String("QtGui/qpolygon.h") },
    { QLatin1String("QPrintDialog"), QLatin1String("QtGui/qprintdialog.h") },
    { QLatin1String("QPrintEngine"), QLatin1String("QtGui/qprintengine.h") },
    { QLatin1String("QPrintPreviewDialog"), QLatin1String("QtGui/qprintpreviewdialog.h") },
    { QLatin1String("QPrintPreviewWidget"), QLatin1String("QtGui/qprintpreviewwidget.h") },
    { QLatin1String("QPrinter"), QLatin1String("QtGui/qprinter.h") },
    { QLatin1String("QPrinterInfo"), QLatin1String("QtGui/qprinterinfo.h") },
    { QLatin1String("QProcess"), QLatin1String("QtCore/qprocess.h") },
    { QLatin1String("QProcessEnvironment"), QLatin1String("QtCore/qprocess.h") },
    { QLatin1String("QProgressBar"), QLatin1String("QtGui/qprogressbar.h") },
    { QLatin1String("QProgressDialog"), QLatin1String("QtGui/qprogressdialog.h") },
    { QLatin1String("QPropertyAnimation"), QLatin1String("QtGui/qpropertyanimation.h") },
    { QLatin1String("QProxyModel"), QLatin1String("QtGui/qproxymodel.h") },
    { QLatin1String("QProxyStyle"), QLatin1String("QtGui/qproxystyle.h") },
    { QLatin1String("QPushButton"), QLatin1String("QtGui/qpushbutton.h") },
    { QLatin1String("QRadialGradient"), QLatin1String("QtGui/qbrush.h") },
    { QLatin1String("QRadioButton"), QLatin1String("QtGui/qradiobutton.h") },
    { QLatin1String("QRect"), QLatin1String("QtCore/qrect.h") },
    { QLatin1String("QRectF"), QLatin1String("QtCore/qrect.h") },
    { QLatin1String("QRegExp"), QLatin1String("QtCore/qregexp.h") },
    { QLatin1String("QRegExpValidator"), QLatin1String("QtGui/qvalidator.h") },
    { QLatin1String("QRegion"), QLatin1String("QtGui/qregion.h") },
    { QLatin1String("QResizeEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QRubberBand"), QLatin1String("QtGui/qrubberband.h") },
    { QLatin1String("QScopedValueRollback"), QLatin1String("QtCore/qscopedvaluerollback.h") },
    { QLatin1String("QScrollArea"), QLatin1String("QtGui/qscrollarea.h") },
    { QLatin1String("QScrollBar"), QLatin1String("QtGui/qscrollbar.h") },
    { QLatin1String("QSemaphore"), QLatin1String("QtCore/qsemaphore.h") },
    { QLatin1String("QSequentialAnimationGroup"), QLatin1String("QtGui/qsequentialanimationgroup.h") },
    { QLatin1String("QSet"), QLatin1String("QtCore/qset.h") },
    { QLatin1String("QSettings"), QLatin1String("QtCore/qsettings.h") },
    { QLatin1String("QSharedData"), QLatin1String("QtCore/qshareddata.h") },
    { QLatin1String("QSharedPointer"), QLatin1String("QtCore/qsharedpointer.h") },
    { QLatin1String("QShortcut"), QLatin1String("QtGui/qshortcut.h") },
    { QLatin1String("QShortcutEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QShowEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QSignalMapper"), QLatin1String("QtCore/qsignalmapper.h") },
    { QLatin1String("QSignalSpy"), QLatin1String("QtTest/qsignalspy.h") },
    { QLatin1String("QSize"), QLatin1String("QtCore/qsize.h") },
    { QLatin1String("QSizeF"), QLatin1String("QtCore/qsize.h") },
    { QLatin1String("QSizeGrip"), QLatin1String("QtGui/qsizegrip.h") },
    { QLatin1String("QSizePolicy"), QLatin1String("QtGui/qsizepolicy.h") },
    { QLatin1String("QSlider"), QLatin1String("QtGui/qslider.h") },
    { QLatin1String("QSocketNotifier"), QLatin1String("QtCore/qsocketnotifier.h") },
    { QLatin1String("QSortFilterProxyModel"), QLatin1String("QtGui/qsortfilterproxymodel.h") },
    { QLatin1String("QSpacerItem"), QLatin1String("QtGui/qlayoutitem.h") },
    { QLatin1String("QSpinBox"), QLatin1String("QtGui/qspinbox.h") },
    { QLatin1String("QSplashScreen"), QLatin1String("QtGui/qsplashscreen.h") },
    { QLatin1String("QSplitter"), QLatin1String("QtGui/qsplitter.h") },
    { QLatin1String("QSplitterHandle"), QLatin1String("QtGui/qsplitter.h") },
    { QLatin1String("QStack"), QLatin1String("QtCore/qstack.h") },
    { QLatin1String("QStackedLayout"), QLatin1String("QtGui/qstackedlayout.h") },
    { QLatin1String("QStackedWidget"), QLatin1String("QtGui/qstackedwidget.h") },
    { QLatin1String("QStandardItem"), QLatin1String("QtGui/qstandarditemmodel.h") },
    { QLatin1String("QStandardItemModel"), QLatin1String("QtGui/qstandarditemmodel.h") },
    { QLatin1String("QStandardPaths"), QLatin1String("QtCore/qstandardpaths.h") },
    { QLatin1String("QStatusBar"), QLatin1String("QtGui/qstatusbar.h") },
    { QLatin1String("QStatusTipEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QString"), QLatin1String("QtCore/qstring.h") },
    { QLatin1String("QStringList"), QLatin1String("QtCore/qstringlist.h") },
    { QLatin1String("QStringListModel"), QLatin1String("QtGui/qstringlistmodel.h") },
    { QLatin1String("QStringMatcher"), QLatin1String("QtCore/qstringmatcher.h") },
    { QLatin1String("QStringRef"), QLatin1String("QtCore/qstring.h") },
    { QLatin1String("QStyle"), QLatin1String("QtGui/qstyle.h") },
    { QLatin1String("QStyleFactory"), QLatin1String("QtGui/qstylefactory.h") },
    { QLatin1String("QStyleHintReturn"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleHintReturnMask"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleHintReturnVariant"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOption"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionButton"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionComboBox"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionComplex"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionDockWidget"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionFocusRect"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionFrame"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionGraphicsItem"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionGroupBox"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionHeader"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionMenuItem"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionProgressBar"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionRubberBand"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionSizeGrip"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionSlider"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionSpinBox"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionTab"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionTabBarBase"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionTabWidgetFrame"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionTitleBar"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionToolBar"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionToolBox"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionToolButton"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStyleOptionViewItem"), QLatin1String("QtGui/qstyleoption.h") },
    { QLatin1String("QStylePainter"), QLatin1String("QtGui/qstylepainter.h") },
    { QLatin1String("QStylePlugin"), QLatin1String("QtGui/qstyleplugin.h") },
    { QLatin1String("QStyledItemDelegate"), QLatin1String("QtGui/qstyleditemdelegate.h") },
    { QLatin1String("QSvgRenderer"), QLatin1String("QtSvg/qsvgrenderer.h") },
    { QLatin1String("QSyntaxHighlighter"), QLatin1String("QtGui/qsyntaxhighlighter.h") },
    { QLatin1String("QTabBar"), QLatin1String("QtGui/qtabbar.h") },
    { QLatin1String("QTabWidget"), QLatin1String("QtGui/qtabwidget.h") },
    { QLatin1String("QTableView"), QLatin1String("QtGui/qtableview.h") },
    { QLatin1String("QTableWidget"), QLatin1String("QtGui/qtablewidget.h") },
    { QLatin1String("QTableWidgetItem"), QLatin1String("QtGui/qtablewidget.h") },
    { QLatin1String("QTableWidgetSelectionRange"), QLatin1String("QtGui/qtablewidget.h") },
    { QLatin1String("QTcpServer"), QLatin1String("QtNetwork/qtcpserver.h") },
    { QLatin1String("QTcpSocket"), QLatin1String("QtNetwork/qtcpsocket.h") },
    { QLatin1String("QTemporaryFile"), QLatin1String("QtCore/qtemporaryfile.h") },
    { QLatin1String("QTestBasicStreamer"), QLatin1String("QtTest/qtestbasicstreamer.h") },
    { QLatin1String("QTestCoreElement"), QLatin1String("QtTest/qtestcoreelement.h") },
    { QLatin1String("QTestCoreList"), QLatin1String("QtTest/qtestcorelist.h") },
    { QLatin1String("QTestData"), QLatin1String("QtTest/qtestdata.h") },
    { QLatin1String("QTestDelayEvent"), QLatin1String("QtTest/qtestevent.h") },
    { QLatin1String("QTestElement"), QLatin1String("QtTest/qtestelement.h") },
    { QLatin1String("QTestElementAttribute"), QLatin1String("QtTest/qtestelementattribute.h") },
    { QLatin1String("QTestEvent"), QLatin1String("QtTest/qtestevent.h") },
    { QLatin1String("QTestEventList"), QLatin1String("QtTest/qtestevent.h") },
    { QLatin1String("QTestEventLoop"), QLatin1String("QtTest/qtesteventloop.h") },
    { QLatin1String("QTestFileLogger"), QLatin1String("QtTest/qtestfilelogger.h") },
    { QLatin1String("QTestKeyClicksEvent"), QLatin1String("QtTest/qtestevent.h") },
    { QLatin1String("QTestKeyEvent"), QLatin1String("QtTest/qtestevent.h") },
    { QLatin1String("QTestMouseEvent"), QLatin1String("QtTest/qtestevent.h") },
    { QLatin1String("QTestXmlStreamer"), QLatin1String("QtTest/qtestxmlstreamer.h") },
    { QLatin1String("QTextBlock"), QLatin1String("QtGui/qtextobject.h") },
    { QLatin1String("QTextBlockFormat"), QLatin1String("QtGui/qtextformat.h") },
    { QLatin1String("QTextBlockGroup"), QLatin1String("QtGui/qtextobject.h") },
    { QLatin1String("QTextBlockUserData"), QLatin1String("QtGui/qtextobject.h") },
    { QLatin1String("QTextBrowser"), QLatin1String("QtGui/qtextbrowser.h") },
    { QLatin1String("QTextCharFormat"), QLatin1String("QtGui/qtextformat.h") },
    { QLatin1String("QTextCodec"), QLatin1String("QtCore/qtextcodec.h") },
    { QLatin1String("QTextConverter"), QLatin1String("QtCore/qtextcodec.h") },
    { QLatin1String("QTextCursor"), QLatin1String("QtGui/qtextcursor.h") },
    { QLatin1String("QTextDocument"), QLatin1String("QtGui/qtextdocument.h") },
    { QLatin1String("QTextDocumentFragment"), QLatin1String("QtGui/qtextdocumentfragment.h") },
    { QLatin1String("QTextDocumentWriter"), QLatin1String("QtGui/qtextdocumentwriter.h") },
    { QLatin1String("QTextEdit"), QLatin1String("QtGui/qtextedit.h") },
    { QLatin1String("QTextFormat"), QLatin1String("QtGui/qtextformat.h") },
    { QLatin1String("QTextFragment"), QLatin1String("QtGui/qtextobject.h") },
    { QLatin1String("QTextFrame"), QLatin1String("QtGui/qtextobject.h") },
    { QLatin1String("QTextFrameFormat"), QLatin1String("QtGui/qtextformat.h") },
    { QLatin1String("QTextFrameLayoutData"), QLatin1String("QtGui/qtextobject.h") },
    { QLatin1String("QTextImageFormat"), QLatin1String("QtGui/qtextformat.h") },
    { QLatin1String("QTextInlineObject"), QLatin1String("QtGui/qtextlayout.h") },
    { QLatin1String("QTextItem"), QLatin1String("QtGui/qpaintengine.h") },
    { QLatin1String("QTextLayout"), QLatin1String("QtGui/qtextlayout.h") },
    { QLatin1String("QTextLength"), QLatin1String("QtGui/qtextformat.h") },
    { QLatin1String("QTextLine"), QLatin1String("QtGui/qtextlayout.h") },
    { QLatin1String("QTextList"), QLatin1String("QtGui/qtextlist.h") },
    { QLatin1String("QTextListFormat"), QLatin1String("QtGui/qtextformat.h") },
    { QLatin1String("QTextObject"), QLatin1String("QtGui/qtextobject.h") },
    { QLatin1String("QTextObjectInterface"), QLatin1String("QtGui/qabstracttextdocumentlayout.h") },
    { QLatin1String("QTextOption"), QLatin1String("QtGui/qtextoption.h") },
    { QLatin1String("QTextStream"), QLatin1String("QtCore/qtextstream.h") },
    { QLatin1String("QTextTable"), QLatin1String("QtGui/qtexttable.h") },
    { QLatin1String("QTextTableCell"), QLatin1String("QtGui/qtexttable.h") },
    { QLatin1String("QTextTableCellFormat"), QLatin1String("QtGui/qtextformat.h") },
    { QLatin1String("QTextTableFormat"), QLatin1String("QtGui/qtextformat.h") },
    { QLatin1String("QThread"), QLatin1String("QtCore/qthread.h") },
    { QLatin1String("QTime"), QLatin1String("QtCore/qdatetime.h") },
    { QLatin1String("QTimeEdit"), QLatin1String("QtGui/qdatetimeedit.h") },
    { QLatin1String("QTimeLine"), QLatin1String("QtCore/qtimeline.h") },
    { QLatin1String("QTimer"), QLatin1String("QtCore/qtimer.h") },
    { QLatin1String("QTimerEvent"), QLatin1String("QtCore/qcoreevent.h") },
    { QLatin1String("QToolBar"), QLatin1String("QtGui/qtoolbar.h") },
    { QLatin1String("QToolBox"), QLatin1String("QtGui/qtoolbox.h") },
    { QLatin1String("QToolButton"), QLatin1String("QtGui/qtoolbutton.h") },
    { QLatin1String("QToolTip"), QLatin1String("QtGui/qtooltip.h") },
    { QLatin1String("QTransform"), QLatin1String("QtGui/qtransform.h") },
    { QLatin1String("QTranslator"), QLatin1String("QtCore/qtranslator.h") },
    { QLatin1String("QTreeView"), QLatin1String("QtGui/qtreeview.h") },
    { QLatin1String("QTreeWidget"), QLatin1String("QtGui/qtreewidget.h") },
    { QLatin1String("QTreeWidgetItem"), QLatin1String("QtGui/qtreewidget.h") },
    { QLatin1String("QTreeWidgetItemIterator"), QLatin1String("QtGui/qtreewidgetitemiterator.h") },
    { QLatin1String("QUdpSocket"), QLatin1String("QtNetwork/qudpsocket.h") },
    { QLatin1String("QUiLoader"), QLatin1String("QtUiTools/quiloader.h") },
    { QLatin1String("QUndoCommand"), QLatin1String("QtGui/qundostack.h") },
    { QLatin1String("QUndoGroup"), QLatin1String("QtGui/qundogroup.h") },
    { QLatin1String("QUndoStack"), QLatin1String("QtGui/qundostack.h") },
    { QLatin1String("QUndoView"), QLatin1String("QtGui/qundoview.h") },
    { QLatin1String("QUrl"), QLatin1String("QtCore/qurl.h") },
    { QLatin1String("QVBoxLayout"), QLatin1String("QtGui/qboxlayout.h") },
    { QLatin1String("QValidator"), QLatin1String("QtGui/qvalidator.h") },
    { QLatin1String("QVariant"), QLatin1String("QtCore/qvariant.h") },
    { QLatin1String("QVariantAnimation"), QLatin1String("QtGui/qvariantanimation.h") },
    { QLatin1String("QVector"), QLatin1String("QtCore/qvector.h") },
    { QLatin1String("QVector2D"), QLatin1String("QtGui/qvector2d.h") },
    { QLatin1String("QVector3D"), QLatin1String("QtGui/qvector3d.h") },
    { QLatin1String("QVector4D"), QLatin1String("QtGui/qvector4d.h") },
    { QLatin1String("QVectorData"), QLatin1String("QtCore/qvector.h") },
    { QLatin1String("QWaitCondition"), QLatin1String("QtCore/qwaitcondition.h") },
    { QLatin1String("QWeakPointer"), QLatin1String("QtCore/qsharedpointer.h") },
    { QLatin1String("QWhatsThis"), QLatin1String("QtGui/qwhatsthis.h") },
    { QLatin1String("QWhatsThisClickedEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QWheelEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QWidget"), QLatin1String("QtGui/qwidget.h") },
    { QLatin1String("QWidgetAction"), QLatin1String("QtGui/qwidgetaction.h") },
    { QLatin1String("QWidgetItem"), QLatin1String("QtGui/qlayoutitem.h") },
    { QLatin1String("QWindowStateChangeEvent"), QLatin1String("QtGui/qevent.h") },
    { QLatin1String("QWindowsStyle"), QLatin1String("QtGui/qwindowsstyle.h") },
    { QLatin1String("QWizard"), QLatin1String("QtGui/qwizard.h") },
    { QLatin1String("QWizardPage"), QLatin1String("QtGui/qwizard.h") },
    { QLatin1String("QX11Info"), QLatin1String("QtGui/qx11info_x11.h") },
    { QLatin1String("QXmlAttributes"), QLatin1String("QtXml/qxml.h") },
    { QLatin1String("QXmlContentHandler"), QLatin1String("QtXml/qxml.h") },
    { QLatin1String("QXmlDTDHandler"), QLatin1String("QtXml/qxml.h") },
    { QLatin1String("QXmlDeclHandler"), QLatin1String("QtXml/qxml.h") },
    { QLatin1String("QXmlDefaultHandler"), QLatin1String("QtXml/qxml.h") },
    { QLatin1String("QXmlEntityResolver"), QLatin1String("QtXml/qxml.h") },
    { QLatin1String("QXmlErrorHandler"), QLatin1String("QtXml/qxml.h") },
    { QLatin1String("QXmlInputSource"), QLatin1String("QtXml/qxml.h") },
    { QLatin1String("QXmlLexicalHandler"), QLatin1String("QtXml/qxml.h") },
    { QLatin1String("QXmlLocator"), QLatin1String("QtXml/qxml.h") },
    { QLatin1String("QXmlNamespaceSupport"), QLatin1String("QtXml/qxml.h") },
    { QLatin1String("QXmlParseException"), QLatin1String("QtXml/qxml.h") },
    { QLatin1String("QXmlReader"), QLatin1String("QtXml/qxml.h") },
    { QLatin1String("QXmlSimpleReader"), QLatin1String("QtXml/qxml.h") },
    { QLatin1String("QXmlStreamAttribute"), QLatin1String("QtXml/qxmlstream.h") },
    { QLatin1String("QXmlStreamAttributes"), QLatin1String("QtXml/qxmlstream.h") },
    { QLatin1String("QXmlStreamEntityDeclaration"), QLatin1String("QtXml/qxmlstream.h") },
    { QLatin1String("QXmlStreamEntityResolver"), QLatin1String("QtXml/qxmlstream.h") },
    { QLatin1String("QXmlStreamNamespaceDeclaration"), QLatin1String("QtXml/qxmlstream.h") },
    { QLatin1String("QXmlStreamNotationDeclaration"), QLatin1String("QtXml/qxmlstream.h") },
    { QLatin1String("QXmlStreamReader"), QLatin1String("QtXml/qxmlstream.h") },
    { QLatin1String("QXmlStreamWriter"), QLatin1String("QtXml/qxmlstream.h") },
};
static const qint16 ClassTblSize = sizeof(ClassTbl) / sizeof(ClassTblData);

WriteIncludes::WriteIncludes(Uic *uic)
    : m_uic(uic), m_output(uic->output()), m_laidOut(false)
{
}

void WriteIncludes::acceptUI(DomUI *node)
{
    m_laidOut = false;
    m_localIncludes.clear();
    m_globalIncludes.clear();
    m_knownClasses.clear();
    m_includeBaseNames.clear();

    if (node->elementIncludes())
        acceptIncludes(node->elementIncludes());

    if (node->elementCustomWidgets())
        TreeWalker::acceptCustomWidgets(node->elementCustomWidgets());

    add(QLatin1String("QApplication"));
    add(QLatin1String("QVariant"));
    add(QLatin1String("QAction"));

    add(QLatin1String("QButtonGroup")); // ### only if it is really necessary
    add(QLatin1String("QHeaderView"));

    TreeWalker::acceptUI(node);

    writeHeaders(m_globalIncludes, true);
    writeHeaders(m_localIncludes, false);

    m_output << QLatin1Char('\n');
}

void WriteIncludes::acceptWidget(DomWidget *node)
{
#if DEBUG_WRITE_INCLUDES
    fprintf(stderr, "%s '%s'\n", Q_FUNC_INFO, qPrintable(node->attributeClass()));
#endif

    add(node->attributeClass());
    TreeWalker::acceptWidget(node);
}

void WriteIncludes::acceptLayout(DomLayout *node)
{
    add(node->attributeClass());
    m_laidOut = true;
    TreeWalker::acceptLayout(node);
}

void WriteIncludes::acceptSpacer(DomSpacer *node)
{
    add(QLatin1String("QSpacerItem"));
    TreeWalker::acceptSpacer(node);
}

void WriteIncludes::acceptProperty(DomProperty *node)
{
    if (node->kind() == DomProperty::Date)
        add(QLatin1String("QDate"));
    if (node->kind() == DomProperty::Locale)
        add(QLatin1String("QLocale"));
    TreeWalker::acceptProperty(node);
}

void WriteIncludes::insertIncludeForClass(const QString &className, QString header, bool global)
{
#if DEBUG_WRITE_INCLUDES
    fprintf(stderr, "%s %s '%s' %d\n", Q_FUNC_INFO, qPrintable(className), qPrintable(header), global);
#endif

    do {
        if (!header.isEmpty())
            break;

        // Known class
        bool isknown = false;
        for (qint16 i = 0; i < ClassTblSize; i++) {
            if (ClassTbl[i].klass == className) {
                header = ClassTbl[i].header;
                global =  true;
                isknown = true;
                break;
            }
        }
        if (isknown) {
            break;
        }

        // Quick check by class name to detect includehints provided for custom widgets.
        // Remove namespaces
        QString lowerClassName = className.toLower();
        static const QString namespaceSeparator = QLatin1String("::");
        const int namespaceIndex = lowerClassName.lastIndexOf(namespaceSeparator);
        if (namespaceIndex != -1)
            lowerClassName.remove(0, namespaceIndex + namespaceSeparator.size());
        if (m_includeBaseNames.contains(lowerClassName)) {
            header.clear();
            break;
        }

        // Last resort: Create default header
        if (!m_uic->option().implicitIncludes)
            break;
        header = lowerClassName + QLatin1String(".h");
#if WARN_HEADER_GENERATOR
        qWarning("%s: Warning: generated header '%s' for class '%s'.",
                 qPrintable(m_uic->option().messagePrefix()),
                 qPrintable(header), qPrintable(className));
#endif

        global = true;
    } while (false);

    if (!header.isEmpty())
        insertInclude(header, global);
}

void WriteIncludes::add(const QString &className, bool determineHeader, const QString &header, bool global)
{
#if DEBUG_WRITE_INCLUDES
    fprintf(stderr, "%s %s '%s' %d\n", Q_FUNC_INFO, qPrintable(className), qPrintable(header), global);
#endif

    if (className.isEmpty() || m_knownClasses.contains(className))
        return;

    m_knownClasses.insert(className);

    if (!m_laidOut && m_uic->customWidgetsInfo()->extends(className, QLatin1String("QToolBox")))
        add(QLatin1String("QLayout")); // spacing property of QToolBox)

    if (className == QLatin1String("Line")) { // ### hmm, deprecate me!
        add(QLatin1String("QFrame"));
        return;
    }

    if (determineHeader)
        insertIncludeForClass(className, header, global);
}

void WriteIncludes::acceptCustomWidget(DomCustomWidget *node)
{
    const QString className = node->elementClass();
    if (className.isEmpty())
        return;

    if (!node->elementHeader() || node->elementHeader()->text().isEmpty()) {
        add(className, false); // no header specified
    } else {
        // custom header unless it is a built-in qt class
        QString header;
        bool global = false;
        bool isknown = false;
        for (qint16 i = 0; i < ClassTblSize; i++) {
            if (ClassTbl[i].klass == className) {
                isknown = true;
                break;
            }
        }
        if (!isknown) {
            global = node->elementHeader()->attributeLocation().toLower() == QLatin1String("global");
            header = node->elementHeader()->text();
        }
        add(className, true, header, global);
    }
}

void WriteIncludes::acceptCustomWidgets(DomCustomWidgets *node)
{
    Q_UNUSED(node);
}

void WriteIncludes::acceptInclude(DomInclude *node)
{
    bool global = true;
    if (node->hasAttributeLocation())
        global = node->attributeLocation() == QLatin1String("global");
    insertInclude(node->text(), global);
}

void WriteIncludes::insertInclude(const QString &header, bool global)
{
#if DEBUG_WRITE_INCLUDES
    fprintf(stderr, "%s %s %d\n", Q_FUNC_INFO, qPrintable(header), global);
#endif

    OrderedSet &includes = global ?  m_globalIncludes : m_localIncludes;
    if (includes.contains(header))
        return;
    // Insert. Also remember base name for quick check of suspicious custom plugins
    includes.insert(header, false);
    const QString lowerBaseName = QFileInfo(header).completeBaseName ().toLower();
    m_includeBaseNames.insert(lowerBaseName);
}

void WriteIncludes::writeHeaders(const OrderedSet &headers, bool global)
{
    const QChar openingQuote = global ? QLatin1Char('<') : QLatin1Char('"');
    const QChar closingQuote = global ? QLatin1Char('>') : QLatin1Char('"');

    // Check for the old headers 'qslider.h' and replace by 'QtGui/QSlider'
    foreach (const QString &header, headers.keys()) {
        if (!header.trimmed().isEmpty()) {
            m_output << "#include " << openingQuote << header << closingQuote << QLatin1Char('\n');
        }
    }
}

} // namespace CPP

QT_END_NAMESPACE
