// Proprocessed version of ffx_a.h from FSR package
// For original source, see 3rdParty/GPUOpen/Include/ffx_fsr1.h
// Modifications are required to meet MSVC's strict limitations on string length. No single string literal (concatenated or otherwise) can exceed 64K
// * Removed CPU section as we do not need it
// * Stripped all comment-only lines, the original source is still readable for this purpose
// * Stripped all unnecessary whitespace

R"--RPCS3--(
#if defined(A_GPU)&&defined(FSR_EASU_F)
AF4 FsrEasuRF(AF2 p);
AF4 FsrEasuGF(AF2 p);
AF4 FsrEasuBF(AF2 p);
void FsrEasuTapF(
inout AF3 aC, // Accumulated color, with negative lobe.
inout AF1 aW, // Accumulated weight.
AF2 off, // Pixel offset from resolve position to tap.
AF2 dir, // Gradient direction.
AF2 len, // Length.
AF1 lob, // Negative lobe strength.
AF1 clp, // Clipping point.
AF3 c){ // Tap color.
AF2 v;
v.x=(off.x*( dir.x))+(off.y*dir.y);
v.y=(off.x*(-dir.y))+(off.y*dir.x);
v*=len;
AF1 d2=v.x*v.x+v.y*v.y;
d2=min(d2,clp);
AF1 wB=AF1_(2.0/5.0)*d2+AF1_(-1.0);
AF1 wA=lob*d2+AF1_(-1.0);
wB*=wB;
wA*=wA;
wB=AF1_(25.0/16.0)*wB+AF1_(-(25.0/16.0-1.0));
AF1 w=wB*wA;
aC+=c*w;aW+=w;}
void FsrEasuSetF(
inout AF2 dir,
inout AF1 len,
AF2 pp,
AP1 biS,AP1 biT,AP1 biU,AP1 biV,
AF1 lA,AF1 lB,AF1 lC,AF1 lD,AF1 lE){
AF1 w = AF1_(0.0);
if(biS)w=(AF1_(1.0)-pp.x)*(AF1_(1.0)-pp.y);
if(biT)w=           pp.x *(AF1_(1.0)-pp.y);
if(biU)w=(AF1_(1.0)-pp.x)*           pp.y ;
if(biV)w=           pp.x *           pp.y ;
AF1 dc=lD-lC;
AF1 cb=lC-lB;
AF1 lenX=max(abs(dc),abs(cb));
lenX=APrxLoRcpF1(lenX);
AF1 dirX=lD-lB;
dir.x+=dirX*w;
lenX=ASatF1(abs(dirX)*lenX);
lenX*=lenX;
len+=lenX*w;
AF1 ec=lE-lC;
AF1 ca=lC-lA;
AF1 lenY=max(abs(ec),abs(ca));
lenY=APrxLoRcpF1(lenY);
AF1 dirY=lE-lA;
dir.y+=dirY*w;
lenY=ASatF1(abs(dirY)*lenY);
lenY*=lenY;
len+=lenY*w;}
void FsrEasuF(
out AF3 pix,
AU2 ip, // Integer pixel position in output.
AU4 con0, // Constants generated by FsrEasuCon().
AU4 con1,
AU4 con2,
AU4 con3){
AF2 pp=AF2(ip)*AF2_AU2(con0.xy)+AF2_AU2(con0.zw);
AF2 fp=floor(pp);
pp-=fp;
AF2 p0=fp*AF2_AU2(con1.xy)+AF2_AU2(con1.zw);
AF2 p1=p0+AF2_AU2(con2.xy);
AF2 p2=p0+AF2_AU2(con2.zw);
AF2 p3=p0+AF2_AU2(con3.xy);
AF4 bczzR=FsrEasuRF(p0);
AF4 bczzG=FsrEasuGF(p0);
AF4 bczzB=FsrEasuBF(p0);
AF4 ijfeR=FsrEasuRF(p1);
AF4 ijfeG=FsrEasuGF(p1);
AF4 ijfeB=FsrEasuBF(p1);
AF4 klhgR=FsrEasuRF(p2);
AF4 klhgG=FsrEasuGF(p2);
AF4 klhgB=FsrEasuBF(p2);
AF4 zzonR=FsrEasuRF(p3);
AF4 zzonG=FsrEasuGF(p3);
AF4 zzonB=FsrEasuBF(p3);
AF4 bczzL=bczzB*AF4_(0.5)+(bczzR*AF4_(0.5)+bczzG);
AF4 ijfeL=ijfeB*AF4_(0.5)+(ijfeR*AF4_(0.5)+ijfeG);
AF4 klhgL=klhgB*AF4_(0.5)+(klhgR*AF4_(0.5)+klhgG);
AF4 zzonL=zzonB*AF4_(0.5)+(zzonR*AF4_(0.5)+zzonG);
AF1 bL=bczzL.x;
AF1 cL=bczzL.y;
AF1 iL=ijfeL.x;
AF1 jL=ijfeL.y;
AF1 fL=ijfeL.z;
AF1 eL=ijfeL.w;
AF1 kL=klhgL.x;
AF1 lL=klhgL.y;
AF1 hL=klhgL.z;
AF1 gL=klhgL.w;
AF1 oL=zzonL.z;
AF1 nL=zzonL.w;
AF2 dir=AF2_(0.0);
AF1 len=AF1_(0.0);
FsrEasuSetF(dir,len,pp,true, false,false,false,bL,eL,fL,gL,jL);
FsrEasuSetF(dir,len,pp,false,true ,false,false,cL,fL,gL,hL,kL);
FsrEasuSetF(dir,len,pp,false,false,true ,false,fL,iL,jL,kL,nL);
FsrEasuSetF(dir,len,pp,false,false,false,true ,gL,jL,kL,lL,oL);
AF2 dir2=dir*dir;
AF1 dirR=dir2.x+dir2.y;
AP1 zro=dirR<AF1_(1.0/32768.0);
dirR=APrxLoRsqF1(dirR);
dirR=zro?AF1_(1.0):dirR;
dir.x=zro?AF1_(1.0):dir.x;
dir*=AF2_(dirR);
len=len*AF1_(0.5);
len*=len;
AF1 stretch=(dir.x*dir.x+dir.y*dir.y)*APrxLoRcpF1(max(abs(dir.x),abs(dir.y)));
AF2 len2=AF2(AF1_(1.0)+(stretch-AF1_(1.0))*len,AF1_(1.0)+AF1_(-0.5)*len);
AF1 lob=AF1_(0.5)+AF1_((1.0/4.0-0.04)-0.5)*len;
AF1 clp=APrxLoRcpF1(lob);
AF3 min4=min(AMin3F3(AF3(ijfeR.z,ijfeG.z,ijfeB.z),AF3(klhgR.w,klhgG.w,klhgB.w),AF3(ijfeR.y,ijfeG.y,ijfeB.y)),
AF3(klhgR.x,klhgG.x,klhgB.x));
AF3 max4=max(AMax3F3(AF3(ijfeR.z,ijfeG.z,ijfeB.z),AF3(klhgR.w,klhgG.w,klhgB.w),AF3(ijfeR.y,ijfeG.y,ijfeB.y)),
AF3(klhgR.x,klhgG.x,klhgB.x));
AF3 aC=AF3_(0.0);
AF1 aW=AF1_(0.0);
FsrEasuTapF(aC,aW,AF2( 0.0,-1.0)-pp,dir,len2,lob,clp,AF3(bczzR.x,bczzG.x,bczzB.x)); // b
FsrEasuTapF(aC,aW,AF2( 1.0,-1.0)-pp,dir,len2,lob,clp,AF3(bczzR.y,bczzG.y,bczzB.y)); // c
FsrEasuTapF(aC,aW,AF2(-1.0, 1.0)-pp,dir,len2,lob,clp,AF3(ijfeR.x,ijfeG.x,ijfeB.x)); // i
FsrEasuTapF(aC,aW,AF2( 0.0, 1.0)-pp,dir,len2,lob,clp,AF3(ijfeR.y,ijfeG.y,ijfeB.y)); // j
FsrEasuTapF(aC,aW,AF2( 0.0, 0.0)-pp,dir,len2,lob,clp,AF3(ijfeR.z,ijfeG.z,ijfeB.z)); // f
FsrEasuTapF(aC,aW,AF2(-1.0, 0.0)-pp,dir,len2,lob,clp,AF3(ijfeR.w,ijfeG.w,ijfeB.w)); // e
FsrEasuTapF(aC,aW,AF2( 1.0, 1.0)-pp,dir,len2,lob,clp,AF3(klhgR.x,klhgG.x,klhgB.x)); // k
FsrEasuTapF(aC,aW,AF2( 2.0, 1.0)-pp,dir,len2,lob,clp,AF3(klhgR.y,klhgG.y,klhgB.y)); // l
FsrEasuTapF(aC,aW,AF2( 2.0, 0.0)-pp,dir,len2,lob,clp,AF3(klhgR.z,klhgG.z,klhgB.z)); // h
FsrEasuTapF(aC,aW,AF2( 1.0, 0.0)-pp,dir,len2,lob,clp,AF3(klhgR.w,klhgG.w,klhgB.w)); // g
FsrEasuTapF(aC,aW,AF2( 1.0, 2.0)-pp,dir,len2,lob,clp,AF3(zzonR.z,zzonG.z,zzonB.z)); // o
FsrEasuTapF(aC,aW,AF2( 0.0, 2.0)-pp,dir,len2,lob,clp,AF3(zzonR.w,zzonG.w,zzonB.w)); // n
pix=min(max4,max(min4,aC*AF3_(ARcpF1(aW))));}
#endif
#if defined(A_GPU)&&defined(A_HALF)&&defined(FSR_EASU_H)
AH4 FsrEasuRH(AF2 p);
AH4 FsrEasuGH(AF2 p);
AH4 FsrEasuBH(AF2 p);
void FsrEasuTapH(
inout AH2 aCR,inout AH2 aCG,inout AH2 aCB,
inout AH2 aW,
AH2 offX,AH2 offY,
AH2 dir,
AH2 len,
AH1 lob,
AH1 clp,
AH2 cR,AH2 cG,AH2 cB){
AH2 vX,vY;
vX=offX*  dir.xx +offY*dir.yy;
vY=offX*(-dir.yy)+offY*dir.xx;
vX*=len.x;vY*=len.y;
AH2 d2=vX*vX+vY*vY;
d2=min(d2,AH2_(clp));
AH2 wB=AH2_(2.0/5.0)*d2+AH2_(-1.0);
AH2 wA=AH2_(lob)*d2+AH2_(-1.0);
wB*=wB;
wA*=wA;
wB=AH2_(25.0/16.0)*wB+AH2_(-(25.0/16.0-1.0));
AH2 w=wB*wA;
aCR+=cR*w;aCG+=cG*w;aCB+=cB*w;aW+=w;}
void FsrEasuSetH(
inout AH2 dirPX,inout AH2 dirPY,
inout AH2 lenP,
AH2 pp,
AP1 biST,AP1 biUV,
AH2 lA,AH2 lB,AH2 lC,AH2 lD,AH2 lE){
AH2 w = AH2_(0.0);
if(biST)w=(AH2(1.0,0.0)+AH2(-pp.x,pp.x))*AH2_(AH1_(1.0)-pp.y);
if(biUV)w=(AH2(1.0,0.0)+AH2(-pp.x,pp.x))*AH2_(          pp.y);
AH2 dc=lD-lC;
AH2 cb=lC-lB;
AH2 lenX=max(abs(dc),abs(cb));
lenX=ARcpH2(lenX);
AH2 dirX=lD-lB;
dirPX+=dirX*w;
lenX=ASatH2(abs(dirX)*lenX);
lenX*=lenX;
lenP+=lenX*w;
AH2 ec=lE-lC;
AH2 ca=lC-lA;
AH2 lenY=max(abs(ec),abs(ca));
lenY=ARcpH2(lenY);
AH2 dirY=lE-lA;
dirPY+=dirY*w;
lenY=ASatH2(abs(dirY)*lenY);
lenY*=lenY;
lenP+=lenY*w;}
void FsrEasuH(
out AH3 pix,
AU2 ip,
AU4 con0,
AU4 con1,
AU4 con2,
AU4 con3){
AF2 pp=AF2(ip)*AF2_AU2(con0.xy)+AF2_AU2(con0.zw);
AF2 fp=floor(pp);
pp-=fp;
AH2 ppp=AH2(pp);
AF2 p0=fp*AF2_AU2(con1.xy)+AF2_AU2(con1.zw);
AF2 p1=p0+AF2_AU2(con2.xy);
AF2 p2=p0+AF2_AU2(con2.zw);
AF2 p3=p0+AF2_AU2(con3.xy);
AH4 bczzR=FsrEasuRH(p0);
AH4 bczzG=FsrEasuGH(p0);
AH4 bczzB=FsrEasuBH(p0);
AH4 ijfeR=FsrEasuRH(p1);
AH4 ijfeG=FsrEasuGH(p1);
AH4 ijfeB=FsrEasuBH(p1);
AH4 klhgR=FsrEasuRH(p2);
AH4 klhgG=FsrEasuGH(p2);
AH4 klhgB=FsrEasuBH(p2);
AH4 zzonR=FsrEasuRH(p3);
AH4 zzonG=FsrEasuGH(p3);
AH4 zzonB=FsrEasuBH(p3);
AH4 bczzL=bczzB*AH4_(0.5)+(bczzR*AH4_(0.5)+bczzG);
AH4 ijfeL=ijfeB*AH4_(0.5)+(ijfeR*AH4_(0.5)+ijfeG);
AH4 klhgL=klhgB*AH4_(0.5)+(klhgR*AH4_(0.5)+klhgG);
AH4 zzonL=zzonB*AH4_(0.5)+(zzonR*AH4_(0.5)+zzonG);
AH1 bL=bczzL.x;
AH1 cL=bczzL.y;
AH1 iL=ijfeL.x;
AH1 jL=ijfeL.y;
AH1 fL=ijfeL.z;
AH1 eL=ijfeL.w;
AH1 kL=klhgL.x;
AH1 lL=klhgL.y;
AH1 hL=klhgL.z;
AH1 gL=klhgL.w;
AH1 oL=zzonL.z;
AH1 nL=zzonL.w;
AH2 dirPX=AH2_(0.0);
AH2 dirPY=AH2_(0.0);
AH2 lenP=AH2_(0.0);
FsrEasuSetH(dirPX,dirPY,lenP,ppp,true, false,AH2(bL,cL),AH2(eL,fL),AH2(fL,gL),AH2(gL,hL),AH2(jL,kL));
FsrEasuSetH(dirPX,dirPY,lenP,ppp,false,true ,AH2(fL,gL),AH2(iL,jL),AH2(jL,kL),AH2(kL,lL),AH2(nL,oL));
AH2 dir=AH2(dirPX.r+dirPX.g,dirPY.r+dirPY.g);
AH1 len=lenP.r+lenP.g;
AH2 dir2=dir*dir;
AH1 dirR=dir2.x+dir2.y;
AP1 zro=dirR<AH1_(1.0/32768.0);
dirR=APrxLoRsqH1(dirR);
dirR=zro?AH1_(1.0):dirR;
dir.x=zro?AH1_(1.0):dir.x;
dir*=AH2_(dirR);
len=len*AH1_(0.5);
len*=len;
AH1 stretch=(dir.x*dir.x+dir.y*dir.y)*APrxLoRcpH1(max(abs(dir.x),abs(dir.y)));
AH2 len2=AH2(AH1_(1.0)+(stretch-AH1_(1.0))*len,AH1_(1.0)+AH1_(-0.5)*len);
AH1 lob=AH1_(0.5)+AH1_((1.0/4.0-0.04)-0.5)*len;
AH1 clp=APrxLoRcpH1(lob);
AH2 bothR=max(max(AH2(-ijfeR.z,ijfeR.z),AH2(-klhgR.w,klhgR.w)),max(AH2(-ijfeR.y,ijfeR.y),AH2(-klhgR.x,klhgR.x)));
AH2 bothG=max(max(AH2(-ijfeG.z,ijfeG.z),AH2(-klhgG.w,klhgG.w)),max(AH2(-ijfeG.y,ijfeG.y),AH2(-klhgG.x,klhgG.x)));
AH2 bothB=max(max(AH2(-ijfeB.z,ijfeB.z),AH2(-klhgB.w,klhgB.w)),max(AH2(-ijfeB.y,ijfeB.y),AH2(-klhgB.x,klhgB.x)));
AH2 pR=AH2_(0.0);
AH2 pG=AH2_(0.0);
AH2 pB=AH2_(0.0);
AH2 pW=AH2_(0.0);
FsrEasuTapH(pR,pG,pB,pW,AH2( 0.0, 1.0)-ppp.xx,AH2(-1.0,-1.0)-ppp.yy,dir,len2,lob,clp,bczzR.xy,bczzG.xy,bczzB.xy);
FsrEasuTapH(pR,pG,pB,pW,AH2(-1.0, 0.0)-ppp.xx,AH2( 1.0, 1.0)-ppp.yy,dir,len2,lob,clp,ijfeR.xy,ijfeG.xy,ijfeB.xy);
FsrEasuTapH(pR,pG,pB,pW,AH2( 0.0,-1.0)-ppp.xx,AH2( 0.0, 0.0)-ppp.yy,dir,len2,lob,clp,ijfeR.zw,ijfeG.zw,ijfeB.zw);
FsrEasuTapH(pR,pG,pB,pW,AH2( 1.0, 2.0)-ppp.xx,AH2( 1.0, 1.0)-ppp.yy,dir,len2,lob,clp,klhgR.xy,klhgG.xy,klhgB.xy);
FsrEasuTapH(pR,pG,pB,pW,AH2( 2.0, 1.0)-ppp.xx,AH2( 0.0, 0.0)-ppp.yy,dir,len2,lob,clp,klhgR.zw,klhgG.zw,klhgB.zw);
FsrEasuTapH(pR,pG,pB,pW,AH2( 1.0, 0.0)-ppp.xx,AH2( 2.0, 2.0)-ppp.yy,dir,len2,lob,clp,zzonR.zw,zzonG.zw,zzonB.zw);
AH3 aC=AH3(pR.x+pR.y,pG.x+pG.y,pB.x+pB.y);
AH1 aW=pW.x+pW.y;
pix=min(AH3(bothR.y,bothG.y,bothB.y),max(-AH3(bothR.x,bothG.x,bothB.x),aC*AH3_(ARcpH1(aW))));}
#endif
#define FSR_RCAS_LIMIT (0.25-(1.0/16.0))
A_STATIC void FsrRcasCon(
outAU4 con,
AF1 sharpness){
sharpness=AExp2F1(-sharpness);
varAF2(hSharp)=initAF2(sharpness,sharpness);
con[0]=AU1_AF1(sharpness);
con[1]=AU1_AH2_AF2(hSharp);
con[2]=0;
con[3]=0;}
#if defined(A_GPU)&&defined(FSR_RCAS_F)
AF4 FsrRcasLoadF(ASU2 p);
void FsrRcasInputF(inout AF1 r,inout AF1 g,inout AF1 b);
void FsrRcasF(
out AF1 pixR, // Output values, non-vector so port between RcasFilter() and RcasFilterH() is easy.
out AF1 pixG,
out AF1 pixB,
#ifdef FSR_RCAS_PASSTHROUGH_ALPHA
out AF1 pixA,
#endif
AU2 ip, // Integer pixel position in output.
AU4 con){ // Constant generated by RcasSetup().
ASU2 sp=ASU2(ip);
AF3 b=FsrRcasLoadF(sp+ASU2( 0,-1)).rgb;
AF3 d=FsrRcasLoadF(sp+ASU2(-1, 0)).rgb;
#ifdef FSR_RCAS_PASSTHROUGH_ALPHA
AF4 ee=FsrRcasLoadF(sp);
AF3 e=ee.rgb;pixA=ee.a;
#else
AF3 e=FsrRcasLoadF(sp).rgb;
#endif
)--RPCS3--"
R"--RPCS3--(
AF3 f=FsrRcasLoadF(sp+ASU2( 1, 0)).rgb;
AF3 h=FsrRcasLoadF(sp+ASU2( 0, 1)).rgb;
AF1 bR=b.r;
AF1 bG=b.g;
AF1 bB=b.b;
AF1 dR=d.r;
AF1 dG=d.g;
AF1 dB=d.b;
AF1 eR=e.r;
AF1 eG=e.g;
AF1 eB=e.b;
AF1 fR=f.r;
AF1 fG=f.g;
AF1 fB=f.b;
AF1 hR=h.r;
AF1 hG=h.g;
AF1 hB=h.b;
FsrRcasInputF(bR,bG,bB);
FsrRcasInputF(dR,dG,dB);
FsrRcasInputF(eR,eG,eB);
FsrRcasInputF(fR,fG,fB);
FsrRcasInputF(hR,hG,hB);
AF1 bL=bB*AF1_(0.5)+(bR*AF1_(0.5)+bG);
AF1 dL=dB*AF1_(0.5)+(dR*AF1_(0.5)+dG);
AF1 eL=eB*AF1_(0.5)+(eR*AF1_(0.5)+eG);
AF1 fL=fB*AF1_(0.5)+(fR*AF1_(0.5)+fG);
AF1 hL=hB*AF1_(0.5)+(hR*AF1_(0.5)+hG);
AF1 nz=AF1_(0.25)*bL+AF1_(0.25)*dL+AF1_(0.25)*fL+AF1_(0.25)*hL-eL;
nz=ASatF1(abs(nz)*APrxMedRcpF1(AMax3F1(AMax3F1(bL,dL,eL),fL,hL)-AMin3F1(AMin3F1(bL,dL,eL),fL,hL)));
nz=AF1_(-0.5)*nz+AF1_(1.0);
AF1 mn4R=min(AMin3F1(bR,dR,fR),hR);
AF1 mn4G=min(AMin3F1(bG,dG,fG),hG);
AF1 mn4B=min(AMin3F1(bB,dB,fB),hB);
AF1 mx4R=max(AMax3F1(bR,dR,fR),hR);
AF1 mx4G=max(AMax3F1(bG,dG,fG),hG);
AF1 mx4B=max(AMax3F1(bB,dB,fB),hB);
AF2 peakC=AF2(1.0,-1.0*4.0);
AF1 hitMinR=mn4R*ARcpF1(AF1_(4.0)*mx4R);
AF1 hitMinG=mn4G*ARcpF1(AF1_(4.0)*mx4G);
AF1 hitMinB=mn4B*ARcpF1(AF1_(4.0)*mx4B);
AF1 hitMaxR=(peakC.x-mx4R)*ARcpF1(AF1_(4.0)*mn4R+peakC.y);
AF1 hitMaxG=(peakC.x-mx4G)*ARcpF1(AF1_(4.0)*mn4G+peakC.y);
AF1 hitMaxB=(peakC.x-mx4B)*ARcpF1(AF1_(4.0)*mn4B+peakC.y);
AF1 lobeR=max(-hitMinR,hitMaxR);
AF1 lobeG=max(-hitMinG,hitMaxG);
AF1 lobeB=max(-hitMinB,hitMaxB);
AF1 lobe=max(AF1_(-FSR_RCAS_LIMIT),min(AMax3F1(lobeR,lobeG,lobeB),AF1_(0.0)))*AF1_AU1(con.x);
#ifdef FSR_RCAS_DENOISE
lobe*=nz;
#endif
AF1 rcpL=APrxMedRcpF1(AF1_(4.0)*lobe+AF1_(1.0));
pixR=(lobe*bR+lobe*dR+lobe*hR+lobe*fR+eR)*rcpL;
pixG=(lobe*bG+lobe*dG+lobe*hG+lobe*fG+eG)*rcpL;
pixB=(lobe*bB+lobe*dB+lobe*hB+lobe*fB+eB)*rcpL;
return;}
#endif
#if defined(A_GPU)&&defined(A_HALF)&&defined(FSR_RCAS_H)
AH4 FsrRcasLoadH(ASW2 p);
void FsrRcasInputH(inout AH1 r,inout AH1 g,inout AH1 b);
void FsrRcasH(
out AH1 pixR, // Output values, non-vector so port between RcasFilter() and RcasFilterH() is easy.
out AH1 pixG,
out AH1 pixB,
#ifdef FSR_RCAS_PASSTHROUGH_ALPHA
out AH1 pixA,
#endif
AU2 ip, // Integer pixel position in output.
AU4 con){ // Constant generated by RcasSetup().
ASW2 sp=ASW2(ip);
AH3 b=FsrRcasLoadH(sp+ASW2( 0,-1)).rgb;
AH3 d=FsrRcasLoadH(sp+ASW2(-1, 0)).rgb;
#ifdef FSR_RCAS_PASSTHROUGH_ALPHA
AH4 ee=FsrRcasLoadH(sp);
AH3 e=ee.rgb;pixA=ee.a;
#else
AH3 e=FsrRcasLoadH(sp).rgb;
#endif
AH3 f=FsrRcasLoadH(sp+ASW2( 1, 0)).rgb;
AH3 h=FsrRcasLoadH(sp+ASW2( 0, 1)).rgb;
AH1 bR=b.r;
AH1 bG=b.g;
AH1 bB=b.b;
AH1 dR=d.r;
AH1 dG=d.g;
AH1 dB=d.b;
AH1 eR=e.r;
AH1 eG=e.g;
AH1 eB=e.b;
AH1 fR=f.r;
AH1 fG=f.g;
AH1 fB=f.b;
AH1 hR=h.r;
AH1 hG=h.g;
AH1 hB=h.b;
FsrRcasInputH(bR,bG,bB);
FsrRcasInputH(dR,dG,dB);
FsrRcasInputH(eR,eG,eB);
FsrRcasInputH(fR,fG,fB);
FsrRcasInputH(hR,hG,hB);
AH1 bL=bB*AH1_(0.5)+(bR*AH1_(0.5)+bG);
AH1 dL=dB*AH1_(0.5)+(dR*AH1_(0.5)+dG);
AH1 eL=eB*AH1_(0.5)+(eR*AH1_(0.5)+eG);
AH1 fL=fB*AH1_(0.5)+(fR*AH1_(0.5)+fG);
AH1 hL=hB*AH1_(0.5)+(hR*AH1_(0.5)+hG);
AH1 nz=AH1_(0.25)*bL+AH1_(0.25)*dL+AH1_(0.25)*fL+AH1_(0.25)*hL-eL;
nz=ASatH1(abs(nz)*APrxMedRcpH1(AMax3H1(AMax3H1(bL,dL,eL),fL,hL)-AMin3H1(AMin3H1(bL,dL,eL),fL,hL)));
nz=AH1_(-0.5)*nz+AH1_(1.0);
AH1 mn4R=min(AMin3H1(bR,dR,fR),hR);
AH1 mn4G=min(AMin3H1(bG,dG,fG),hG);
AH1 mn4B=min(AMin3H1(bB,dB,fB),hB);
AH1 mx4R=max(AMax3H1(bR,dR,fR),hR);
AH1 mx4G=max(AMax3H1(bG,dG,fG),hG);
AH1 mx4B=max(AMax3H1(bB,dB,fB),hB);
AH2 peakC=AH2(1.0,-1.0*4.0);
AH1 hitMinR=mn4R*ARcpH1(AH1_(4.0)*mx4R);
AH1 hitMinG=mn4G*ARcpH1(AH1_(4.0)*mx4G);
AH1 hitMinB=mn4B*ARcpH1(AH1_(4.0)*mx4B);
AH1 hitMaxR=(peakC.x-mx4R)*ARcpH1(AH1_(4.0)*mn4R+peakC.y);
AH1 hitMaxG=(peakC.x-mx4G)*ARcpH1(AH1_(4.0)*mn4G+peakC.y);
AH1 hitMaxB=(peakC.x-mx4B)*ARcpH1(AH1_(4.0)*mn4B+peakC.y);
AH1 lobeR=max(-hitMinR,hitMaxR);
AH1 lobeG=max(-hitMinG,hitMaxG);
AH1 lobeB=max(-hitMinB,hitMaxB);
AH1 lobe=max(AH1_(-FSR_RCAS_LIMIT),min(AMax3H1(lobeR,lobeG,lobeB),AH1_(0.0)))*AH2_AU1(con.y).x;
#ifdef FSR_RCAS_DENOISE
lobe*=nz;
#endif
AH1 rcpL=APrxMedRcpH1(AH1_(4.0)*lobe+AH1_(1.0));
pixR=(lobe*bR+lobe*dR+lobe*hR+lobe*fR+eR)*rcpL;
pixG=(lobe*bG+lobe*dG+lobe*hG+lobe*fG+eG)*rcpL;
pixB=(lobe*bB+lobe*dB+lobe*hB+lobe*fB+eB)*rcpL;}
#endif
#if defined(A_GPU)&&defined(A_HALF)&&defined(FSR_RCAS_HX2)
AH4 FsrRcasLoadHx2(ASW2 p);
void FsrRcasInputHx2(inout AH2 r,inout AH2 g,inout AH2 b);
void FsrRcasDepackHx2(out AH4 pix0,out AH4 pix1,AH2 pixR,AH2 pixG,AH2 pixB){
#ifdef A_HLSL
pix0.a=pix1.a=0.0;
#endif
pix0.rgb=AH3(pixR.x,pixG.x,pixB.x);
pix1.rgb=AH3(pixR.y,pixG.y,pixB.y);}
void FsrRcasHx2(
out AH2 pixR,
out AH2 pixG,
out AH2 pixB,
#ifdef FSR_RCAS_PASSTHROUGH_ALPHA
out AH2 pixA,
#endif
AU2 ip, // Integer pixel position in output.
AU4 con){ // Constant generated by RcasSetup().
ASW2 sp0=ASW2(ip);
AH3 b0=FsrRcasLoadHx2(sp0+ASW2( 0,-1)).rgb;
AH3 d0=FsrRcasLoadHx2(sp0+ASW2(-1, 0)).rgb;
#ifdef FSR_RCAS_PASSTHROUGH_ALPHA
AH4 ee0=FsrRcasLoadHx2(sp0);
AH3 e0=ee0.rgb;pixA.r=ee0.a;
#else
AH3 e0=FsrRcasLoadHx2(sp0).rgb;
#endif
AH3 f0=FsrRcasLoadHx2(sp0+ASW2( 1, 0)).rgb;
AH3 h0=FsrRcasLoadHx2(sp0+ASW2( 0, 1)).rgb;
ASW2 sp1=sp0+ASW2(8,0);
AH3 b1=FsrRcasLoadHx2(sp1+ASW2( 0,-1)).rgb;
AH3 d1=FsrRcasLoadHx2(sp1+ASW2(-1, 0)).rgb;
#ifdef FSR_RCAS_PASSTHROUGH_ALPHA
AH4 ee1=FsrRcasLoadHx2(sp1);
AH3 e1=ee1.rgb;pixA.g=ee1.a;
#else
AH3 e1=FsrRcasLoadHx2(sp1).rgb;
#endif
AH3 f1=FsrRcasLoadHx2(sp1+ASW2( 1, 0)).rgb;
AH3 h1=FsrRcasLoadHx2(sp1+ASW2( 0, 1)).rgb;
AH2 bR=AH2(b0.r,b1.r);
AH2 bG=AH2(b0.g,b1.g);
AH2 bB=AH2(b0.b,b1.b);
AH2 dR=AH2(d0.r,d1.r);
AH2 dG=AH2(d0.g,d1.g);
AH2 dB=AH2(d0.b,d1.b);
AH2 eR=AH2(e0.r,e1.r);
AH2 eG=AH2(e0.g,e1.g);
AH2 eB=AH2(e0.b,e1.b);
AH2 fR=AH2(f0.r,f1.r);
AH2 fG=AH2(f0.g,f1.g);
AH2 fB=AH2(f0.b,f1.b);
AH2 hR=AH2(h0.r,h1.r);
AH2 hG=AH2(h0.g,h1.g);
AH2 hB=AH2(h0.b,h1.b);
FsrRcasInputHx2(bR,bG,bB);
FsrRcasInputHx2(dR,dG,dB);
FsrRcasInputHx2(eR,eG,eB);
FsrRcasInputHx2(fR,fG,fB);
FsrRcasInputHx2(hR,hG,hB);
AH2 bL=bB*AH2_(0.5)+(bR*AH2_(0.5)+bG);
AH2 dL=dB*AH2_(0.5)+(dR*AH2_(0.5)+dG);
AH2 eL=eB*AH2_(0.5)+(eR*AH2_(0.5)+eG);
AH2 fL=fB*AH2_(0.5)+(fR*AH2_(0.5)+fG);
AH2 hL=hB*AH2_(0.5)+(hR*AH2_(0.5)+hG);
AH2 nz=AH2_(0.25)*bL+AH2_(0.25)*dL+AH2_(0.25)*fL+AH2_(0.25)*hL-eL;
nz=ASatH2(abs(nz)*APrxMedRcpH2(AMax3H2(AMax3H2(bL,dL,eL),fL,hL)-AMin3H2(AMin3H2(bL,dL,eL),fL,hL)));
nz=AH2_(-0.5)*nz+AH2_(1.0);
AH2 mn4R=min(AMin3H2(bR,dR,fR),hR);
AH2 mn4G=min(AMin3H2(bG,dG,fG),hG);
AH2 mn4B=min(AMin3H2(bB,dB,fB),hB);
AH2 mx4R=max(AMax3H2(bR,dR,fR),hR);
AH2 mx4G=max(AMax3H2(bG,dG,fG),hG);
AH2 mx4B=max(AMax3H2(bB,dB,fB),hB);
AH2 peakC=AH2(1.0,-1.0*4.0);
AH2 hitMinR=mn4R*ARcpH2(AH2_(4.0)*mx4R);
AH2 hitMinG=mn4G*ARcpH2(AH2_(4.0)*mx4G);
AH2 hitMinB=mn4B*ARcpH2(AH2_(4.0)*mx4B);
AH2 hitMaxR=(peakC.x-mx4R)*ARcpH2(AH2_(4.0)*mn4R+peakC.y);
AH2 hitMaxG=(peakC.x-mx4G)*ARcpH2(AH2_(4.0)*mn4G+peakC.y);
AH2 hitMaxB=(peakC.x-mx4B)*ARcpH2(AH2_(4.0)*mn4B+peakC.y);
AH2 lobeR=max(-hitMinR,hitMaxR);
AH2 lobeG=max(-hitMinG,hitMaxG);
AH2 lobeB=max(-hitMinB,hitMaxB);
AH2 lobe=max(AH2_(-FSR_RCAS_LIMIT),min(AMax3H2(lobeR,lobeG,lobeB),AH2_(0.0)))*AH2_(AH2_AU1(con.y).x);
#ifdef FSR_RCAS_DENOISE
lobe*=nz;
#endif
AH2 rcpL=APrxMedRcpH2(AH2_(4.0)*lobe+AH2_(1.0));
pixR=(lobe*bR+lobe*dR+lobe*hR+lobe*fR+eR)*rcpL;
pixG=(lobe*bG+lobe*dG+lobe*hG+lobe*fG+eG)*rcpL;
pixB=(lobe*bB+lobe*dB+lobe*hB+lobe*fB+eB)*rcpL;}
#endif
#if defined(A_GPU)
void FsrLfgaF(inout AF3 c,AF3 t,AF1 a){c+=(t*AF3_(a))*min(AF3_(1.0)-c,c);}
#endif
#if defined(A_GPU)&&defined(A_HALF)
void FsrLfgaH(inout AH3 c,AH3 t,AH1 a){c+=(t*AH3_(a))*min(AH3_(1.0)-c,c);}
void FsrLfgaHx2(inout AH2 cR,inout AH2 cG,inout AH2 cB,AH2 tR,AH2 tG,AH2 tB,AH1 a){
cR+=(tR*AH2_(a))*min(AH2_(1.0)-cR,cR);cG+=(tG*AH2_(a))*min(AH2_(1.0)-cG,cG);cB+=(tB*AH2_(a))*min(AH2_(1.0)-cB,cB);}
#endif
#if defined(A_GPU)
void FsrSrtmF(inout AF3 c){c*=AF3_(ARcpF1(AMax3F1(c.r,c.g,c.b)+AF1_(1.0)));}
void FsrSrtmInvF(inout AF3 c){c*=AF3_(ARcpF1(max(AF1_(1.0/32768.0),AF1_(1.0)-AMax3F1(c.r,c.g,c.b))));}
#endif
#if defined(A_GPU)&&defined(A_HALF)
void FsrSrtmH(inout AH3 c){c*=AH3_(ARcpH1(AMax3H1(c.r,c.g,c.b)+AH1_(1.0)));}
void FsrSrtmInvH(inout AH3 c){c*=AH3_(ARcpH1(max(AH1_(1.0/32768.0),AH1_(1.0)-AMax3H1(c.r,c.g,c.b))));}
void FsrSrtmHx2(inout AH2 cR,inout AH2 cG,inout AH2 cB){
AH2 rcp=ARcpH2(AMax3H2(cR,cG,cB)+AH2_(1.0));cR*=rcp;cG*=rcp;cB*=rcp;}
void FsrSrtmInvHx2(inout AH2 cR,inout AH2 cG,inout AH2 cB){
AH2 rcp=ARcpH2(max(AH2_(1.0/32768.0),AH2_(1.0)-AMax3H2(cR,cG,cB)));cR*=rcp;cG*=rcp;cB*=rcp;}
#endif
#if defined(A_GPU)
AF1 FsrTepdDitF(AU2 p,AU1 f){
AF1 x=AF1_(p.x+f);
AF1 y=AF1_(p.y);
AF1 a=AF1_((1.0+sqrt(5.0))/2.0);
AF1 b=AF1_(1.0/3.69);
x=x*a+(y*b);
return AFractF1(x);}
void FsrTepdC8F(inout AF3 c,AF1 dit){
AF3 n=sqrt(c);
n=floor(n*AF3_(255.0))*AF3_(1.0/255.0);
AF3 a=n*n;
AF3 b=n+AF3_(1.0/255.0);b=b*b;
AF3 r=(c-b)*APrxMedRcpF3(a-b);
c=ASatF3(n+AGtZeroF3(AF3_(dit)-r)*AF3_(1.0/255.0));}
void FsrTepdC10F(inout AF3 c,AF1 dit){
AF3 n=sqrt(c);
n=floor(n*AF3_(1023.0))*AF3_(1.0/1023.0);
AF3 a=n*n;
AF3 b=n+AF3_(1.0/1023.0);b=b*b;
AF3 r=(c-b)*APrxMedRcpF3(a-b);
c=ASatF3(n+AGtZeroF3(AF3_(dit)-r)*AF3_(1.0/1023.0));}
#endif
#if defined(A_GPU)&&defined(A_HALF)
AH1 FsrTepdDitH(AU2 p,AU1 f){
AF1 x=AF1_(p.x+f);
AF1 y=AF1_(p.y);
AF1 a=AF1_((1.0+sqrt(5.0))/2.0);
AF1 b=AF1_(1.0/3.69);
x=x*a+(y*b);
return AH1(AFractF1(x));}
void FsrTepdC8H(inout AH3 c,AH1 dit){
AH3 n=sqrt(c);
n=floor(n*AH3_(255.0))*AH3_(1.0/255.0);
AH3 a=n*n;
AH3 b=n+AH3_(1.0/255.0);b=b*b;
AH3 r=(c-b)*APrxMedRcpH3(a-b);
c=ASatH3(n+AGtZeroH3(AH3_(dit)-r)*AH3_(1.0/255.0));}
void FsrTepdC10H(inout AH3 c,AH1 dit){
AH3 n=sqrt(c);
n=floor(n*AH3_(1023.0))*AH3_(1.0/1023.0);
AH3 a=n*n;
AH3 b=n+AH3_(1.0/1023.0);b=b*b;
AH3 r=(c-b)*APrxMedRcpH3(a-b);
c=ASatH3(n+AGtZeroH3(AH3_(dit)-r)*AH3_(1.0/1023.0));}
AH2 FsrTepdDitHx2(AU2 p,AU1 f){
AF2 x;
x.x=AF1_(p.x+f);
x.y=x.x+AF1_(8.0);
AF1 y=AF1_(p.y);
AF1 a=AF1_((1.0+sqrt(5.0))/2.0);
AF1 b=AF1_(1.0/3.69);
x=x*AF2_(a)+AF2_(y*b);
return AH2(AFractF2(x));}
void FsrTepdC8Hx2(inout AH2 cR,inout AH2 cG,inout AH2 cB,AH2 dit){
AH2 nR=sqrt(cR);
AH2 nG=sqrt(cG);
AH2 nB=sqrt(cB);
nR=floor(nR*AH2_(255.0))*AH2_(1.0/255.0);
nG=floor(nG*AH2_(255.0))*AH2_(1.0/255.0);
nB=floor(nB*AH2_(255.0))*AH2_(1.0/255.0);
AH2 aR=nR*nR;
AH2 aG=nG*nG;
AH2 aB=nB*nB;
AH2 bR=nR+AH2_(1.0/255.0);bR=bR*bR;
AH2 bG=nG+AH2_(1.0/255.0);bG=bG*bG;
AH2 bB=nB+AH2_(1.0/255.0);bB=bB*bB;
AH2 rR=(cR-bR)*APrxMedRcpH2(aR-bR);
AH2 rG=(cG-bG)*APrxMedRcpH2(aG-bG);
AH2 rB=(cB-bB)*APrxMedRcpH2(aB-bB);
cR=ASatH2(nR+AGtZeroH2(dit-rR)*AH2_(1.0/255.0));
cG=ASatH2(nG+AGtZeroH2(dit-rG)*AH2_(1.0/255.0));
cB=ASatH2(nB+AGtZeroH2(dit-rB)*AH2_(1.0/255.0));}
void FsrTepdC10Hx2(inout AH2 cR,inout AH2 cG,inout AH2 cB,AH2 dit){
AH2 nR=sqrt(cR);
AH2 nG=sqrt(cG);
AH2 nB=sqrt(cB);
nR=floor(nR*AH2_(1023.0))*AH2_(1.0/1023.0);
nG=floor(nG*AH2_(1023.0))*AH2_(1.0/1023.0);
nB=floor(nB*AH2_(1023.0))*AH2_(1.0/1023.0);
AH2 aR=nR*nR;
AH2 aG=nG*nG;
AH2 aB=nB*nB;
AH2 bR=nR+AH2_(1.0/1023.0);bR=bR*bR;
AH2 bG=nG+AH2_(1.0/1023.0);bG=bG*bG;
AH2 bB=nB+AH2_(1.0/1023.0);bB=bB*bB;
AH2 rR=(cR-bR)*APrxMedRcpH2(aR-bR);
AH2 rG=(cG-bG)*APrxMedRcpH2(aG-bG);
AH2 rB=(cB-bB)*APrxMedRcpH2(aB-bB);
cR=ASatH2(nR+AGtZeroH2(dit-rR)*AH2_(1.0/1023.0));
cG=ASatH2(nG+AGtZeroH2(dit-rG)*AH2_(1.0/1023.0));
cB=ASatH2(nB+AGtZeroH2(dit-rB)*AH2_(1.0/1023.0));}
#endif
)--RPCS3--"
