/**
 ******************************************************************************
 * Xenia : Xbox 360 Emulator Research Project                                 *
 ******************************************************************************
 * Copyright 2021 Ben Vanik. All rights reserved.                             *
 * Released under the BSD license - see LICENSE in the root for more details. *
 ******************************************************************************
 */

// This is a partial file designed to be included by other files when
// constructing various tables.

// clang-format off

XE_EXPORT(xam,      0x00000001, NetDll_WSAStartup,                                          kFunction),
XE_EXPORT(xam,      0x00000002, NetDll_WSACleanup,                                          kFunction),
XE_EXPORT(xam,      0x00000003, NetDll_socket,                                              kFunction),
XE_EXPORT(xam,      0x00000004, NetDll_closesocket,                                         kFunction),
XE_EXPORT(xam,      0x00000005, NetDll_shutdown,                                            kFunction),
XE_EXPORT(xam,      0x00000006, NetDll_ioctlsocket,                                         kFunction),
XE_EXPORT(xam,      0x00000007, NetDll_setsockopt,                                          kFunction),
XE_EXPORT(xam,      0x00000008, NetDll_getsockopt,                                          kFunction),
XE_EXPORT(xam,      0x00000009, NetDll_getsockname,                                         kFunction),
XE_EXPORT(xam,      0x0000000A, NetDll_getpeername,                                         kFunction),
XE_EXPORT(xam,      0x0000000B, NetDll_bind,                                                kFunction),
XE_EXPORT(xam,      0x0000000C, NetDll_connect,                                             kFunction),
XE_EXPORT(xam,      0x0000000D, NetDll_listen,                                              kFunction),
XE_EXPORT(xam,      0x0000000E, NetDll_accept,                                              kFunction),
XE_EXPORT(xam,      0x0000000F, NetDll_select,                                              kFunction),
XE_EXPORT(xam,      0x00000010, NetDll_WSAGetOverlappedResult,                              kFunction),
XE_EXPORT(xam,      0x00000011, NetDll_WSACancelOverlappedIO,                               kFunction),
XE_EXPORT(xam,      0x00000012, NetDll_recv,                                                kFunction),
XE_EXPORT(xam,      0x00000013, NetDll_WSARecv,                                             kFunction),
XE_EXPORT(xam,      0x00000014, NetDll_recvfrom,                                            kFunction),
XE_EXPORT(xam,      0x00000015, NetDll_WSARecvFrom,                                         kFunction),
XE_EXPORT(xam,      0x00000016, NetDll_send,                                                kFunction),
XE_EXPORT(xam,      0x00000017, NetDll_WSASend,                                             kFunction),
XE_EXPORT(xam,      0x00000018, NetDll_sendto,                                              kFunction),
XE_EXPORT(xam,      0x00000019, NetDll_WSASendTo,                                           kFunction),
XE_EXPORT(xam,      0x0000001A, NetDll_inet_addr,                                           kFunction),
XE_EXPORT(xam,      0x0000001B, NetDll_WSAGetLastError,                                     kFunction),
XE_EXPORT(xam,      0x0000001C, NetDll_WSASetLastError,                                     kFunction),
XE_EXPORT(xam,      0x0000001D, NetDll_WSACreateEvent,                                      kFunction),
XE_EXPORT(xam,      0x0000001E, NetDll_WSACloseEvent,                                       kFunction),
XE_EXPORT(xam,      0x0000001F, NetDll_WSASetEvent,                                         kFunction),
XE_EXPORT(xam,      0x00000020, NetDll_WSAResetEvent,                                       kFunction),
XE_EXPORT(xam,      0x00000021, NetDll_WSAWaitForMultipleEvents,                            kFunction),
XE_EXPORT(xam,      0x00000022, NetDll___WSAFDIsSet,                                        kFunction),
XE_EXPORT(xam,      0x00000023, NetDll_WSAEventSelect,                                      kFunction),
XE_EXPORT(xam,      0x00000024, NetDll_WSAStartupEx,                                        kFunction),
XE_EXPORT(xam,      0x00000033, NetDll_XNetStartup,                                         kFunction),
XE_EXPORT(xam,      0x00000034, NetDll_XNetCleanup,                                         kFunction),
XE_EXPORT(xam,      0x00000035, NetDll_XNetRandom,                                          kFunction),
XE_EXPORT(xam,      0x00000036, NetDll_XNetCreateKey,                                       kFunction),
XE_EXPORT(xam,      0x00000037, NetDll_XNetRegisterKey,                                     kFunction),
XE_EXPORT(xam,      0x00000038, NetDll_XNetUnregisterKey,                                   kFunction),
XE_EXPORT(xam,      0x00000039, NetDll_XNetXnAddrToInAddr,                                  kFunction),
XE_EXPORT(xam,      0x0000003A, NetDll_XNetServerToInAddr,                                  kFunction),
XE_EXPORT(xam,      0x0000003B, NetDll_XNetTsAddrToInAddr,                                  kFunction),
XE_EXPORT(xam,      0x0000003C, NetDll_XNetInAddrToXnAddr,                                  kFunction),
XE_EXPORT(xam,      0x0000003D, NetDll_XNetInAddrToServer,                                  kFunction),
XE_EXPORT(xam,      0x0000003E, NetDll_XNetInAddrToString,                                  kFunction),
XE_EXPORT(xam,      0x0000003F, NetDll_XNetUnregisterInAddr,                                kFunction),
XE_EXPORT(xam,      0x00000040, NetDll_XNetXnAddrToMachineId,                               kFunction),
XE_EXPORT(xam,      0x00000041, NetDll_XNetConnect,                                         kFunction),
XE_EXPORT(xam,      0x00000042, NetDll_XNetGetConnectStatus,                                kFunction),
XE_EXPORT(xam,      0x00000043, NetDll_XNetDnsLookup,                                       kFunction),
XE_EXPORT(xam,      0x00000044, NetDll_XNetDnsRelease,                                      kFunction),
XE_EXPORT(xam,      0x00000045, NetDll_XNetQosListen,                                       kFunction),
XE_EXPORT(xam,      0x00000046, NetDll_XNetQosLookup,                                       kFunction),
XE_EXPORT(xam,      0x00000047, NetDll_XNetQosServiceLookup,                                kFunction),
XE_EXPORT(xam,      0x00000048, NetDll_XNetQosRelease,                                      kFunction),
XE_EXPORT(xam,      0x00000049, NetDll_XNetGetTitleXnAddr,                                  kFunction),
XE_EXPORT(xam,      0x0000004A, NetDll_XNetGetDebugXnAddr,                                  kFunction),
XE_EXPORT(xam,      0x0000004B, NetDll_XNetGetEthernetLinkStatus,                           kFunction),
XE_EXPORT(xam,      0x0000004C, NetDll_XNetGetBroadcastVersionStatus,                       kFunction),
XE_EXPORT(xam,      0x0000004D, NetDll_XNetQosGetListenStats,                               kFunction),
XE_EXPORT(xam,      0x0000004E, NetDll_XNetGetOpt,                                          kFunction),
XE_EXPORT(xam,      0x0000004F, NetDll_XNetSetOpt,                                          kFunction),
XE_EXPORT(xam,      0x00000050, NetDll_XNetStartupEx,                                       kFunction),
XE_EXPORT(xam,      0x00000051, NetDll_XNetReplaceKey,                                      kFunction),
XE_EXPORT(xam,      0x00000052, NetDll_XNetGetXnAddrPlatform,                               kFunction),
XE_EXPORT(xam,      0x00000053, NetDll_XNetGetSystemLinkPort,                               kFunction),
XE_EXPORT(xam,      0x00000054, NetDll_XNetSetSystemLinkPort,                               kFunction),
XE_EXPORT(xam,      0x00000055, NetDll_XNetDnsReverseLookup,                                kFunction),
XE_EXPORT(xam,      0x00000056, NetDll_XNetDnsReverseRelease,                               kFunction),
XE_EXPORT(xam,      0x00000065, NetDll_XnpLoadConfigParams,                                 kFunction),
XE_EXPORT(xam,      0x00000066, NetDll_XnpSaveConfigParams,                                 kFunction),
XE_EXPORT(xam,      0x00000067, NetDll_XnpConfigUPnP,                                       kFunction),
XE_EXPORT(xam,      0x00000068, NetDll_XnpConfig,                                           kFunction),
XE_EXPORT(xam,      0x00000069, NetDll_XnpGetConfigStatus,                                  kFunction),
XE_EXPORT(xam,      0x0000006A, NetDll_XnpLoadMachineAccount,                               kFunction),
XE_EXPORT(xam,      0x0000006B, NetDll_XnpSaveMachineAccount,                               kFunction),
XE_EXPORT(xam,      0x0000006C, NetDll_XnpCapture,                                          kFunction),
XE_EXPORT(xam,      0x0000006D, NetDll_XnpEthernetInterceptSetCallbacks,                    kFunction),
XE_EXPORT(xam,      0x0000006E, NetDll_XnpEthernetInterceptXmit,                            kFunction),
XE_EXPORT(xam,      0x0000006F, NetDll_XnpEthernetInterceptRecv,                            kFunction),
XE_EXPORT(xam,      0x00000070, NetDll_XnpLogonGetStatus,                                   kFunction),
XE_EXPORT(xam,      0x00000071, NetDll_XnpLogonGetQFlags,                                   kFunction),
XE_EXPORT(xam,      0x00000072, NetDll_XnpLogonSetQFlags,                                   kFunction),
XE_EXPORT(xam,      0x00000073, NetDll_XnpLogonSetQEvent,                                   kFunction),
XE_EXPORT(xam,      0x00000074, NetDll_XnpLogonClearQEvent,                                 kFunction),
XE_EXPORT(xam,      0x00000075, NetDll_XnpLogonGetQVals,                                    kFunction),
XE_EXPORT(xam,      0x00000076, NetDll_XnpLogonSetQVals,                                    kFunction),
XE_EXPORT(xam,      0x00000077, NetDll_XnpLogonSetPState,                                   kFunction),
XE_EXPORT(xam,      0x00000078, NetDll_XnpGetVlanXboxName,                                  kFunction),
XE_EXPORT(xam,      0x00000079, NetDll_XnpSetVlanXboxName,                                  kFunction),
XE_EXPORT(xam,      0x0000007A, NetDll_XnpGetActiveSocketList,                              kFunction),
XE_EXPORT(xam,      0x0000007B, NetDll_XnpNoteSystemTime,                                   kFunction),
XE_EXPORT(xam,      0x0000007C, NetDll_XnpRegisterKeyForCallerType,                         kFunction),
XE_EXPORT(xam,      0x0000007D, NetDll_XnpUnregisterKeyForCallerType,                       kFunction),
XE_EXPORT(xam,      0x0000007E, NetDll_XnpLogonGetChallenge,                                kFunction),
XE_EXPORT(xam,      0x0000007F, NetDll_XnpLogonClearChallenge,                              kFunction),
XE_EXPORT(xam,      0x00000080, NetDll_XnpLogonSetChallengeResponse,                        kFunction),
XE_EXPORT(xam,      0x00000081, NetDll_XnpGetSecAssocList,                                  kFunction),
XE_EXPORT(xam,      0x00000082, NetDll_XnpGetKeyList,                                       kFunction),
XE_EXPORT(xam,      0x00000083, NetDll_XnpGetQosLookupList,                                 kFunction),
XE_EXPORT(xam,      0x00000084, NetDll_XnpPersistTitleState,                                kFunction),
XE_EXPORT(xam,      0x00000085, NetDll_XnpReplaceKeyForCallerType,                          kFunction),
XE_EXPORT(xam,      0x00000086, NetDll_XnpEthernetInterceptSetExtendedReceiveCallback,      kFunction),
XE_EXPORT(xam,      0x00000087, NetDll_XnpQosHistoryLoad,                                   kFunction),
XE_EXPORT(xam,      0x00000088, NetDll_XnpQosHistorySaveMeasurements,                       kFunction),
XE_EXPORT(xam,      0x00000089, NetDll_XnpQosHistoryGetEntries,                             kFunction),
XE_EXPORT(xam,      0x0000008A, NetDll_XnpQosHistoryGetAggregateMeasurement,                kFunction),
XE_EXPORT(xam,      0x0000008B, NetDll_XnpToolSetCallbacks,                                 kFunction),
XE_EXPORT(xam,      0x0000008C, NetDll_XnpToolIpProxyInject,                                kFunction),
XE_EXPORT(xam,      0x0000008D, NetDll_XnpUpdateConfigParams,                               kFunction),
XE_EXPORT(xam,      0x0000008E, NetDll_XnpEthernetInterceptXmitAsIp,                        kFunction),
XE_EXPORT(xam,      0x0000008F, NetDll_XnpConfigUPnPPortAndExternalAddr,                    kFunction),
XE_EXPORT(xam,      0x00000097, NetDll_XmlDownloadStart,                                    kFunction),
XE_EXPORT(xam,      0x00000098, NetDll_XmlDownloadContinue,                                 kFunction),
XE_EXPORT(xam,      0x00000099, NetDll_XmlDownloadStop,                                     kFunction),
XE_EXPORT(xam,      0x0000009A, NetDll_XmlDownloadGetParseTime,                             kFunction),
XE_EXPORT(xam,      0x0000009B, NetDll_XmlDownloadGetReceivedDataSize,                      kFunction),
XE_EXPORT(xam,      0x000000C6, XnpGetXwppMemoryLogSnapshot,                                kFunction),
XE_EXPORT(xam,      0x000000C7, XnpGetXwppRuntimeFilter,                                    kFunction),
XE_EXPORT(xam,      0x000000C9, NetDll_XHttpStartup,                                        kFunction),
XE_EXPORT(xam,      0x000000CA, NetDll_XHttpShutdown,                                       kFunction),
XE_EXPORT(xam,      0x000000CB, NetDll_XHttpOpen,                                           kFunction),
XE_EXPORT(xam,      0x000000CC, NetDll_XHttpCloseHandle,                                    kFunction),
XE_EXPORT(xam,      0x000000CD, NetDll_XHttpConnect,                                        kFunction),
XE_EXPORT(xam,      0x000000CE, NetDll_XHttpSetStatusCallback,                              kFunction),
XE_EXPORT(xam,      0x000000CF, NetDll_XHttpOpenRequest,                                    kFunction),
XE_EXPORT(xam,      0x000000D0, NetDll_XHttpOpenRequestUsingMemory,                         kFunction),
XE_EXPORT(xam,      0x000000D1, NetDll_XHttpSendRequest,                                    kFunction),
XE_EXPORT(xam,      0x000000D2, NetDll_XHttpReceiveResponse,                                kFunction),
XE_EXPORT(xam,      0x000000D3, NetDll_XHttpQueryHeaders,                                   kFunction),
XE_EXPORT(xam,      0x000000D4, NetDll_XHttpReadData,                                       kFunction),
XE_EXPORT(xam,      0x000000D5, NetDll_XHttpWriteData,                                      kFunction),
XE_EXPORT(xam,      0x000000D6, NetDll_XHttpQueryOption,                                    kFunction),
XE_EXPORT(xam,      0x000000D7, NetDll_XHttpSetOption,                                      kFunction),
XE_EXPORT(xam,      0x000000D8, NetDll_XHttpDoWork,                                         kFunction),
XE_EXPORT(xam,      0x000000D9, NetDll_XHttpSetCredentials,                                 kFunction),
XE_EXPORT(xam,      0x000000DA, NetDll_XHttpQueryAuthSchemes,                               kFunction),
XE_EXPORT(xam,      0x000000DB, NetDll_XHttpCrackUrlW,                                      kFunction),
XE_EXPORT(xam,      0x000000DC, NetDll_XHttpCrackUrl,                                       kFunction),
XE_EXPORT(xam,      0x000000DD, NetDll_XHttpCreateUrl,                                      kFunction),
XE_EXPORT(xam,      0x000000DE, NetDll_XHttpCreateUrlW,                                     kFunction),
XE_EXPORT(xam,      0x000000DF, NetDll_XHttpResetPerfCounters,                              kFunction),
XE_EXPORT(xam,      0x000000E0, NetDll_XHttpGetPerfCounters,                                kFunction),
XE_EXPORT(xam,      0x000000FB, NetDll_UpnpStartup,                                         kFunction),
XE_EXPORT(xam,      0x000000FC, NetDll_UpnpCleanup,                                         kFunction),
XE_EXPORT(xam,      0x000000FD, NetDll_UpnpSearchCreate,                                    kFunction),
XE_EXPORT(xam,      0x000000FE, NetDll_UpnpSearchGetDevices,                                kFunction),
XE_EXPORT(xam,      0x000000FF, NetDll_UpnpDescribeCreate,                                  kFunction),
XE_EXPORT(xam,      0x00000100, NetDll_UpnpDescribeGetResults,                              kFunction),
XE_EXPORT(xam,      0x00000101, NetDll_UpnpActionCalculateWorkBufferSize,                   kFunction),
XE_EXPORT(xam,      0x00000102, NetDll_UpnpActionCreate,                                    kFunction),
XE_EXPORT(xam,      0x00000103, NetDll_UpnpActionGetResults,                                kFunction),
XE_EXPORT(xam,      0x00000104, NetDll_UpnpEventCreate,                                     kFunction),
XE_EXPORT(xam,      0x00000105, NetDll_UpnpEventGetCurrentState,                            kFunction),
XE_EXPORT(xam,      0x00000106, NetDll_UpnpEventUnsubscribe,                                kFunction),
XE_EXPORT(xam,      0x00000107, NetDll_UpnpDoWork,                                          kFunction),
XE_EXPORT(xam,      0x00000108, NetDll_UpnpCloseHandle,                                     kFunction),
XE_EXPORT(xam,      0x0000012D, XNetLogonGetLoggedOnUsers,                                  kFunction),
XE_EXPORT(xam,      0x0000012E, XNetLogonGetNatType,                                        kFunction),
XE_EXPORT(xam,      0x0000012F, XNetLogonTaskStart,                                         kFunction),
XE_EXPORT(xam,      0x00000130, XNetLogonTaskClose,                                         kFunction),
XE_EXPORT(xam,      0x00000131, XNetLogonTaskContinue,                                      kFunction),
XE_EXPORT(xam,      0x00000132, XNetLogonGetServiceInfo,                                    kFunction),
XE_EXPORT(xam,      0x00000133, XNetLogonGetUserPrivileges,                                 kFunction),
XE_EXPORT(xam,      0x00000134, XNetLogonSetConsoleCertificate,                             kFunction),
XE_EXPORT(xam,      0x00000135, XNetLogonGetMachineID,                                      kFunction),
XE_EXPORT(xam,      0x00000136, XNetLogonGetTitleID,                                        kFunction),
XE_EXPORT(xam,      0x00000137, XNetLogonGetTitleVersion,                                   kFunction),
XE_EXPORT(xam,      0x00000138, XNetLogonGetServiceNetworkID,                               kFunction),
XE_EXPORT(xam,      0x00000139, XNetLogonGetDnsString,                                      kFunction),
XE_EXPORT(xam,      0x0000013A, XNetLogonSetTitleID,                                        kFunction),
XE_EXPORT(xam,      0x0000013B, XNetLogonGetExtendedStatus,                                 kFunction),
XE_EXPORT(xam,      0x0000013C, XNetLogonClearTicketCaches,                                 kFunction),
XE_EXPORT(xam,      0x0000013D, XNetLogonInitOverrideInfo,                                  kFunction),
XE_EXPORT(xam,      0x0000013E, XNetLogonGetLastUPnPStatus,                                 kFunction),
XE_EXPORT(xam,      0x0000013F, XNetLogonGetFlowToken,                                      kFunction),
XE_EXPORT(xam,      0x00000140, XNetLogonGetTicketOpt,                                      kFunction),
XE_EXPORT(xam,      0x00000141, XNetLogonSetTicketOpt,                                      kFunction),
XE_EXPORT(xam,      0x00000142, XNetLogonGetState,                                          kFunction),
XE_EXPORT(xam,      0x00000190, XamInputGetCapabilities,                                    kFunction),
XE_EXPORT(xam,      0x00000191, XamInputGetState,                                           kFunction),
XE_EXPORT(xam,      0x00000192, XamInputSetState,                                           kFunction),
XE_EXPORT(xam,      0x00000193, XamInputGetKeystroke,                                       kFunction),
XE_EXPORT(xam,      0x00000194, XamInputEnableAutobind,                                     kFunction),
XE_EXPORT(xam,      0x00000195, XamInputRawState,                                           kFunction),
XE_EXPORT(xam,      0x00000196, XamEnableSystemAppInput,                                    kFunction),
XE_EXPORT(xam,      0x00000197, XamInputGetDeviceStats,                                     kFunction),
XE_EXPORT(xam,      0x00000198, XamInputGetKeystrokeEx,                                     kFunction),
XE_EXPORT(xam,      0x00000199, XamInputGetKeystrokeHud,                                    kFunction),
XE_EXPORT(xam,      0x0000019A, XamInputSetLayoutKeyboard,                                  kFunction),
XE_EXPORT(xam,      0x0000019B, XamInputToggleKeyLocks,                                     kFunction),
XE_EXPORT(xam,      0x0000019C, XamInputResetLayoutKeyboard,                                kFunction),
XE_EXPORT(xam,      0x0000019D, XamInputGetKeystrokeHudEx,                                  kFunction),
XE_EXPORT(xam,      0x0000019E, XamInputSetKeyboardTranslationHud,                          kFunction),
XE_EXPORT(xam,      0x0000019F, XamSetInactivityTime,                                       kFunction),
XE_EXPORT(xam,      0x000001A0, XamEnableInactivityProcessing,                              kFunction),
XE_EXPORT(xam,      0x000001A1, XamResetInactivity,                                         kFunction),
XE_EXPORT(xam,      0x000001A2, XamSetInactivityTimeFromConfig,                             kFunction),
XE_EXPORT(xam,      0x000001A3, XamLoaderGetMediaInfo,                                      kFunction),
XE_EXPORT(xam,      0x000001A4, XamLoaderLaunchTitle,                                       kFunction),
XE_EXPORT(xam,      0x000001A5, XamLoaderLaunchTitleEx,                                     kFunction),
XE_EXPORT(xam,      0x000001A6, XamLoaderSetLaunchData,                                     kFunction),
XE_EXPORT(xam,      0x000001A7, XamLoaderGetLaunchDataSize,                                 kFunction),
XE_EXPORT(xam,      0x000001A8, XamLoaderGetLaunchData,                                     kFunction),
XE_EXPORT(xam,      0x000001A9, XamLoaderTerminateTitle,                                    kFunction),
XE_EXPORT(xam,      0x000001AA, XamLoaderGetDvdTrayState,                                   kFunction),
XE_EXPORT(xam,      0x000001AB, XamLoaderGetGameInfo,                                       kFunction),
XE_EXPORT(xam,      0x000001AC, XamLoaderLaunchTitleOnDvd,                                  kFunction),
XE_EXPORT(xam,      0x000001AD, XamLoaderSetSpindleSpeed,                                   kFunction),
XE_EXPORT(xam,      0x000001AE, XamTaskCreateQueue,                                         kFunction),
XE_EXPORT(xam,      0x000001AF, XamTaskSchedule,                                            kFunction),
XE_EXPORT(xam,      0x000001B0, XamTaskReschedule,                                          kFunction),
XE_EXPORT(xam,      0x000001B1, XamTaskCloseHandle,                                         kFunction),
XE_EXPORT(xam,      0x000001B2, XamTaskCancel,                                              kFunction),
XE_EXPORT(xam,      0x000001B3, XamTaskShouldExit,                                          kFunction),
XE_EXPORT(xam,      0x000001B4, XamTaskWaitOnCompletion,                                    kFunction),
XE_EXPORT(xam,      0x000001B5, XamTaskModify,                                              kFunction),
XE_EXPORT(xam,      0x000001B6, XamTaskGetCurrentTask,                                      kFunction),
XE_EXPORT(xam,      0x000001B7, XamTaskGetAttributes,                                       kFunction),
XE_EXPORT(xam,      0x000001B8, XamExecutingOnBehalfOfTitle,                                kFunction),
XE_EXPORT(xam,      0x000001B9, XamInputSendStayAliveRequest,                               kFunction),
XE_EXPORT(xam,      0x000001BA, XamInputGetUserVibrationLevel,                              kFunction),
XE_EXPORT(xam,      0x000001BB, XamIsSystemTitleId,                                         kFunction),
XE_EXPORT(xam,      0x000001BC, XamLoaderIsTitleTerminatePending,                           kFunction),
XE_EXPORT(xam,      0x000001BD, XamInputSetTextMessengerIndicator,                          kFunction),
XE_EXPORT(xam,      0x000001BE, XamLoaderGetPriorTitleId,                                   kFunction),
XE_EXPORT(xam,      0x000001BF, XamIsXbox1TitleId,                                          kFunction),
XE_EXPORT(xam,      0x000001C0, XamInputSetKeyLocks,                                        kFunction),
XE_EXPORT(xam,      0x000001C1, XamInputGetKeyLocks,                                        kFunction),
XE_EXPORT(xam,      0x000001C2, XamTaskGetStatus,                                           kFunction),
XE_EXPORT(xam,      0x000001C3, XamGetRootObj,                                              kFunction),
XE_EXPORT(xam,      0x000001C4, XamDevAuthSetFault,                                         kFunction),
XE_EXPORT(xam,      0x000001C5, XamGetDefaultSystemImage,                                   kFunction),
XE_EXPORT(xam,      0x000001C6, XamGetWCNConfigFile,                                        kFunction),
XE_EXPORT(xam,      0x000001C7, XamSetPowerMode,                                            kFunction),
XE_EXPORT(xam,      0x000001C8, XamExecuteChallenge,                                        kFunction),
XE_EXPORT(xam,      0x000001C9, XamGetDefaultImage,                                         kFunction),
XE_EXPORT(xam,      0x000001CA, XamMuteSound,                                               kFunction),
XE_EXPORT(xam,      0x000001CB, XamGetOnlineSchema,                                         kFunction),
XE_EXPORT(xam,      0x000001CC, XamSetDashContext,                                          kFunction),
XE_EXPORT(xam,      0x000001CD, XamGetDashContext,                                          kFunction),
XE_EXPORT(xam,      0x000001CE, XamIsCurrentTitleDash,                                      kFunction),
XE_EXPORT(xam,      0x000001CF, XamGetCurrentTitleId,                                       kFunction),
XE_EXPORT(xam,      0x000001D0, XamSetCurrentTitleDash,                                     kFunction),
XE_EXPORT(xam,      0x000001D1, XamAllocHeapFreeSpace,                                      kFunction),
XE_EXPORT(xam,      0x000001D2, XamSetDashContextEx,                                        kFunction),
XE_EXPORT(xam,      0x000001D3, XamGetDashContextEx,                                        kFunction),
XE_EXPORT(xam,      0x000001D4, XamSetHudContext,                                           kFunction),
XE_EXPORT(xam,      0x000001D5, XamGetHudContext,                                           kFunction),
XE_EXPORT(xam,      0x000001D6, XCustomGetBannerImage,                                      kFunction),
XE_EXPORT(xam,      0x000001D7, Refresh,                                                    kFunction),
XE_EXPORT(xam,      0x000001D8, XCustomSetAction,                                           kFunction),
XE_EXPORT(xam,      0x000001D9, XCustomGetLastActionPress,                                  kFunction),
XE_EXPORT(xam,      0x000001DA, XCustomSetDynamicActions,                                   kFunction),
XE_EXPORT(xam,      0x000001DB, XCustomBroadcastActionEvent,                                kFunction),
XE_EXPORT(xam,      0x000001DC, XCustomGetLastActionPressEx,                                kFunction),
XE_EXPORT(xam,      0x000001DD, XCustomRegisterDynamicActions,                              kFunction),
XE_EXPORT(xam,      0x000001DE, XCustomUnregisterDynamicActions,                            kFunction),
XE_EXPORT(xam,      0x000001DF, XCustomGetCurrentGamercard,                                 kFunction),
XE_EXPORT(xam,      0x000001E0, XamDbgPrint,                                                kFunction),
XE_EXPORT(xam,      0x000001E1, XamDbgSetOutputLevel,                                       kFunction),
XE_EXPORT(xam,      0x000001E2, XamDbgSetBreakLevel,                                        kFunction),
XE_EXPORT(xam,      0x000001E3, XamLoaderGetMediaInfoEx,                                    kFunction),
XE_EXPORT(xam,      0x000001E4, XamLoaderSetGameInfo,                                       kFunction),
XE_EXPORT(xam,      0x000001E5, XamFormatMessage,                                           kFunction),
XE_EXPORT(xam,      0x000001E6, XamUniSortCmpString,                                        kFunction),
XE_EXPORT(xam,      0x000001E7, XamFormatTimeString,                                        kFunction),
XE_EXPORT(xam,      0x000001E8, XamFormatDateString,                                        kFunction),
XE_EXPORT(xam,      0x000001E9, XamGetLocaleDateFormat,                                     kFunction),
XE_EXPORT(xam,      0x000001EA, XamAlloc,                                                   kFunction),
XE_EXPORT(xam,      0x000001EB, XamAllocEx,                                                 kFunction),
XE_EXPORT(xam,      0x000001EC, XamFree,                                                    kFunction),
XE_EXPORT(xam,      0x000001ED, XamAllocSize,                                               kFunction),
XE_EXPORT(xam,      0x000001EE, XamAllocMountIPTVHeap,                                      kFunction),
XE_EXPORT(xam,      0x000001EF, XamAllocUnmountIPTVHeap,                                    kFunction),
XE_EXPORT(xam,      0x000001F0, XamAllocFreeIPTVHeap,                                       kFunction),
XE_EXPORT(xam,      0x000001F1, XamDeviceRemap,                                             kFunction),
XE_EXPORT(xam,      0x000001F2, XamLoaderGetClearCache,                                     kFunction),
XE_EXPORT(xam,      0x000001F3, XamLoaderSetClearCache,                                     kFunction),
XE_EXPORT(xam,      0x000001F4, XMsgInProcessCall,                                          kFunction),
XE_EXPORT(xam,      0x000001F5, XMsgCompleteIORequest,                                      kFunction),
XE_EXPORT(xam,      0x000001F6, XMsgSystemProcessCall,                                      kFunction),
XE_EXPORT(xam,      0x000001F7, XMsgStartIORequest,                                         kFunction),
XE_EXPORT(xam,      0x000001F8, XMsgCancelIORequest,                                        kFunction),
XE_EXPORT(xam,      0x000001F9, XMsgAcquireAsyncMessageFromOverlapped,                      kFunction),
XE_EXPORT(xam,      0x000001FA, XMsgReleaseAsyncMessageToOverlapped,                        kFunction),
XE_EXPORT(xam,      0x000001FB, XamGetOverlappedResult,                                     kFunction),
XE_EXPORT(xam,      0x000001FC, XMsgStartIORequestEx,                                       kFunction),
XE_EXPORT(xam,      0x000001FD, XamAppAllocateInterappWorkspace,                            kFunction),
XE_EXPORT(xam,      0x000001FE, XamAppGetInterappWorkspace,                                 kFunction),
XE_EXPORT(xam,      0x000001FF, XamAppFreeInterappWorkspace,                                kFunction),
XE_EXPORT(xam,      0x00000200, XamFeatureEnabled,                                          kFunction),
XE_EXPORT(xam,      0x00000201, XamFeatureEnforceImageBudget,                               kFunction),
XE_EXPORT(xam,      0x00000202, XamFeatureSetMask,                                          kFunction),
XE_EXPORT(xam,      0x00000203, XamFeatureEnableDisable,                                    kFunction),
XE_EXPORT(xam,      0x00000204, XuiControlSetItemAssociation,                               kFunction),
XE_EXPORT(xam,      0x00000205, XamGetTitleGlobalStorageValue,                              kFunction),
XE_EXPORT(xam,      0x00000206, XamSetTitleGlobalStorageValue,                              kFunction),
XE_EXPORT(xam,      0x00000207, XamUserValidateAvatarManifest,                              kFunction),
XE_EXPORT(xam,      0x00000208, XamUserGetDeviceContext,                                    kFunction),
XE_EXPORT(xam,      0x00000209, XamUserLookupDevice,                                        kFunction),
XE_EXPORT(xam,      0x0000020A, XamUserGetXUID,                                             kFunction),
XE_EXPORT(xam,      0x0000020B, XamUserLogon,                                               kFunction),
XE_EXPORT(xam,      0x0000020C, XamUserGetGamerTag,                                         kFunction),
XE_EXPORT(xam,      0x0000020D, XamUserGetUserIndexMask,                                    kFunction),
XE_EXPORT(xam,      0x0000020E, XamUserGetName,                                             kFunction),
XE_EXPORT(xam,      0x0000020F, XamLookupCommonStringByIndex,                               kFunction),
XE_EXPORT(xam,      0x00000210, XamUserGetSigninState,                                      kFunction),
XE_EXPORT(xam,      0x00000211, XamUserGetIndexFromXUID,                                    kFunction),
XE_EXPORT(xam,      0x00000212, XamUserCheckPrivilege,                                      kFunction),
XE_EXPORT(xam,      0x00000213, XamUserAreUsersFriends,                                     kFunction),
XE_EXPORT(xam,      0x00000214, XamSetUserPresetPresenceState,                              kFunction),
XE_EXPORT(xam,      0x00000215, XamGetUserPresetPresenceState,                              kFunction),
XE_EXPORT(xam,      0x00000216, XamUserGetUserFlagsFromXUID,                                kFunction),
XE_EXPORT(xam,      0x00000217, XamUserGetMembershipTierFromXUID,                           kFunction),
XE_EXPORT(xam,      0x00000218, XamUserGetOnlineCountryFromXUID,                            kFunction),
XE_EXPORT(xam,      0x00000219, XamUserReadProfileSettings,                                 kFunction),
XE_EXPORT(xam,      0x0000021A, XamUserWriteProfileSettings,                                kFunction),
XE_EXPORT(xam,      0x0000021B, XamUserGetMembershipTier,                                   kFunction),
XE_EXPORT(xam,      0x0000021C, XamUserGetUserFlags,                                        kFunction),
XE_EXPORT(xam,      0x0000021D, XamUserGetRequestedUserIndexMask,                           kFunction),
XE_EXPORT(xam,      0x0000021E, XamUserIsGuest,                                             kFunction),
XE_EXPORT(xam,      0x0000021F, XamUserProfileSync,                                         kFunction),
XE_EXPORT(xam,      0x00000220, XamUserFlushLogonQueue,                                     kFunction),
XE_EXPORT(xam,      0x00000221, XamUserIsOnlineEnabled,                                     kFunction),
XE_EXPORT(xam,      0x00000222, XamUserGetCachedUserFlags,                                  kFunction),
XE_EXPORT(xam,      0x00000223, XamAreMixedAccountsSignedIn,                                kFunction),
XE_EXPORT(xam,      0x00000224, XamUserLogonEx,                                             kFunction),
XE_EXPORT(xam,      0x00000225, XamSetUserShowMessengerFriends,                             kFunction),
XE_EXPORT(xam,      0x00000226, XamGetUserShowMessengerFriends,                             kFunction),
XE_EXPORT(xam,      0x00000227, XamUserGetSigninInfo,                                       kFunction),
XE_EXPORT(xam,      0x00000228, XamUserIsPartial,                                           kFunction),
XE_EXPORT(xam,      0x00000229, XamUserGetOnlineLanguageFromXUID,                           kFunction),
XE_EXPORT(xam,      0x0000022A, XamUserReadProfileSettingsEx,                               kFunction),
XE_EXPORT(xam,      0x0000022B, XamSystemUpdaterLogon,                                      kFunction),
XE_EXPORT(xam,      0x0000022C, XamUserGetUsersMissingAvatars,                              kFunction),
XE_EXPORT(xam,      0x0000022D, XamIsChildAccountSignedIn,                                  kFunction),
XE_EXPORT(xam,      0x0000022E, XamUserPrefetchProfileSettings,                             kFunction),
XE_EXPORT(xam,      0x0000022F, XamUserInvalidateProfileSetting,                            kFunction),
XE_EXPORT(xam,      0x00000230, XamProfileCreate,                                           kFunction),
XE_EXPORT(xam,      0x00000231, XamProfileCreateEnumerator,                                 kFunction),
XE_EXPORT(xam,      0x00000232, XamProfileEnumerate,                                        kFunction),
XE_EXPORT(xam,      0x00000233, XamProfileDelete,                                           kFunction),
XE_EXPORT(xam,      0x00000234, XamProfileGetCreationStatus,                                kFunction),
XE_EXPORT(xam,      0x00000235, XamProfileFindAccount,                                      kFunction),
XE_EXPORT(xam,      0x00000236, XamProfileRenameAccount,                                    kFunction),
XE_EXPORT(xam,      0x00000237, XamProfileOpen,                                             kFunction),
XE_EXPORT(xam,      0x00000238, XamProfileClose,                                            kFunction),
XE_EXPORT(xam,      0x00000239, XamProfileSaveAccountInfo,                                  kFunction),
XE_EXPORT(xam,      0x0000023A, XamProfileLoadAccountInfo,                                  kFunction),
XE_EXPORT(xam,      0x0000023B, XamProfileRecoverTitle,                                     kFunction),
XE_EXPORT(xam,      0x0000023C, XamProfileSaveWindowsLiveCredentials,                       kFunction),
XE_EXPORT(xam,      0x0000023D, XamProfileLoadWindowsLiveCredentials,                       kFunction),
XE_EXPORT(xam,      0x0000023E, XamProfileIsSaveWindowsLiveCredsEnabled,                    kFunction),
XE_EXPORT(xam,      0x0000023F, XamProfileSetSaveWindowsLiveCredsEnabled,                   kFunction),
XE_EXPORT(xam,      0x00000240, XamSetProfileReadTestHook,                                  kFunction),
XE_EXPORT(xam,      0x00000241, XamProfileGetLastSync,                                      kFunction),
XE_EXPORT(xam,      0x00000242, XamAccountRecoveryRecoverTitle,                             kFunction),
XE_EXPORT(xam,      0x00000243, XamProfileControlPec,                                       kFunction),
XE_EXPORT(xam,      0x00000244, XamAppLoad,                                                 kFunction),
XE_EXPORT(xam,      0x00000245, XamAppUnloadSelf,                                           kFunction),
XE_EXPORT(xam,      0x00000246, XamAppUnloadStack,                                          kFunction),
XE_EXPORT(xam,      0x00000247, XamSendMessageToLoadedApps,                                 kFunction),
XE_EXPORT(xam,      0x00000248, XamAppRequestLoad,                                          kFunction),
XE_EXPORT(xam,      0x00000249, XamAppUnrequestLoad,                                        kFunction),
XE_EXPORT(xam,      0x0000024A, XamNavigate,                                                kFunction),
XE_EXPORT(xam,      0x0000024B, XamRegisterSysApp,                                          kFunction),
XE_EXPORT(xam,      0x0000024C, XamUnregisterSysApp,                                        kFunction),
XE_EXPORT(xam,      0x0000024D, XamAppReinitialize,                                         kFunction),
XE_EXPORT(xam,      0x0000024E, XamCreateEnumeratorHandle,                                  kFunction),
XE_EXPORT(xam,      0x0000024F, XamGetPrivateEnumStructureFromHandle,                       kFunction),
XE_EXPORT(xam,      0x00000250, XamEnumerate,                                               kFunction),
XE_EXPORT(xam,      0x00000251, XamLoadSysApp,                                              kFunction),
XE_EXPORT(xam,      0x00000252, XamUnloadSysApp,                                            kFunction),
XE_EXPORT(xam,      0x00000253, XamReloadSysApp,                                            kFunction),
XE_EXPORT(xam,      0x00000254, XamAppLoadPass2SysApps,                                     kFunction),
XE_EXPORT(xam,      0x00000255, XamProfileGetLiveLegalLocale,                               kFunction),
XE_EXPORT(xam,      0x00000256, XamUserIsParentalControlled,                                kFunction),
XE_EXPORT(xam,      0x00000257, XamContentLaunchImageFromFileInternal,                      kFunction),
XE_EXPORT(xam,      0x00000258, XamContentCreate,                                           kFunction),
XE_EXPORT(xam,      0x00000259, XamContentCreateEx,                                         kFunction),
XE_EXPORT(xam,      0x0000025A, XamContentClose,                                            kFunction),
XE_EXPORT(xam,      0x0000025B, XamContentDelete,                                           kFunction),
XE_EXPORT(xam,      0x0000025C, XamContentCreateEnumerator,                                 kFunction),
XE_EXPORT(xam,      0x0000025D, XamContentCreateDeviceEnumerator,                           kFunction),
XE_EXPORT(xam,      0x0000025E, XamContentGetDeviceData,                                    kFunction),
XE_EXPORT(xam,      0x0000025F, XamContentGetDeviceName,                                    kFunction),
XE_EXPORT(xam,      0x00000260, XamContentSetThumbnail,                                     kFunction),
XE_EXPORT(xam,      0x00000261, XamContentGetThumbnail,                                     kFunction),
XE_EXPORT(xam,      0x00000262, XamContentGetCreator,                                       kFunction),
XE_EXPORT(xam,      0x00000263, XamContentLaunchImage,                                      kFunction),
XE_EXPORT(xam,      0x00000264, XamContentGetAttributes,                                    kFunction),
XE_EXPORT(xam,      0x00000265, XamContentGetDeviceState,                                   kFunction),
XE_EXPORT(xam,      0x00000266, XamContentGetLicenseMask,                                   kFunction),
XE_EXPORT(xam,      0x00000267, XamContentFlush,                                            kFunction),
XE_EXPORT(xam,      0x00000268, XamContentResolve,                                          kFunction),
XE_EXPORT(xam,      0x00000269, XamContentOpenFile,                                         kFunction),
XE_EXPORT(xam,      0x0000026A, XamContentInstall,                                          kFunction),
XE_EXPORT(xam,      0x0000026B, XamContentLockUnlockPackageHeaders,                         kFunction),
XE_EXPORT(xam,      0x0000026C, XamContentCopyInternal,                                     kFunction),
XE_EXPORT(xam,      0x0000026D, XamContentMoveInternal,                                     kFunction),
XE_EXPORT(xam,      0x0000026E, XamContentGetMetaDataInternal,                              kFunction),
XE_EXPORT(xam,      0x0000026F, XamContentCreateEnumeratorInternal,                         kFunction),
XE_EXPORT(xam,      0x00000270, XamContentDeleteInternal,                                   kFunction),
XE_EXPORT(xam,      0x00000271, XamContentCreateInternal,                                   kFunction),
XE_EXPORT(xam,      0x00000272, XamContentSetThumbnailInternal,                             kFunction),
XE_EXPORT(xam,      0x00000273, XamContentLaunchImageInternal,                              kFunction),
XE_EXPORT(xam,      0x00000274, XamContentWritePackageHeader,                               kFunction),
XE_EXPORT(xam,      0x00000275, XamContentDismountAndClosePackage,                          kFunction),
XE_EXPORT(xam,      0x00000276, XamContentResolveInternal,                                  kFunction),
XE_EXPORT(xam,      0x00000277, XamContentGetAttributesInternal,                            kFunction),
XE_EXPORT(xam,      0x00000278, XamContentOpenFileInternal,                                 kFunction),
XE_EXPORT(xam,      0x00000279, XamContentAggregateCreateEnumerator,                        kFunction),
XE_EXPORT(xam,      0x0000027A, XamContentCreateAndMountPackage,                            kFunction),
XE_EXPORT(xam,      0x0000027B, XamContentOpenPackageFile,                                  kFunction),
XE_EXPORT(xam,      0x0000027C, XamContentMountPackage,                                     kFunction),
XE_EXPORT(xam,      0x0000027D, XamContentFlushPackage,                                     kFunction),
XE_EXPORT(xam,      0x0000027E, XamContentClosePackageFile,                                 kFunction),
XE_EXPORT(xam,      0x0000027F, XamContentDuplicateFileHandle,                              kFunction),
XE_EXPORT(xam,      0x00000280, XamGetExecutionId,                                          kFunction),
XE_EXPORT(xam,      0x00000281, XamGetGameRatings,                                          kFunction),
XE_EXPORT(xam,      0x00000282, XamGetSystemVersion,                                        kFunction),
XE_EXPORT(xam,      0x00000283, XamContentGetLocalizedString,                               kFunction),
XE_EXPORT(xam,      0x00000284, XamContentGetDefaultDevice,                                 kFunction),
XE_EXPORT(xam,      0x00000285, XamContentInstallInternal,                                  kFunction),
XE_EXPORT(xam,      0x00000286, XamContentSetMediaMetaDataInternal,                         kFunction),
XE_EXPORT(xam,      0x00000287, XamContentGetDeviceSerialNumber,                            kFunction),
XE_EXPORT(xam,      0x00000288, XamContentGetMountedPackageByRootName,                      kFunction),
XE_EXPORT(xam,      0x00000289, XamContentRegisterChangeCallback,                           kFunction),
XE_EXPORT(xam,      0x0000028A, XamNotifyCreateListener,                                    kFunction),
XE_EXPORT(xam,      0x0000028B, XNotifyGetNext,                                             kFunction),
XE_EXPORT(xam,      0x0000028C, XNotifyPositionUI,                                          kFunction),
XE_EXPORT(xam,      0x0000028D, XNotifyDelayUI,                                             kFunction),
XE_EXPORT(xam,      0x0000028E, XNotifyBroadcast,                                           kFunction),
XE_EXPORT(xam,      0x0000028F, XNotifyRegisterArea,                                        kFunction),
XE_EXPORT(xam,      0x00000290, XNotifyQueueUI,                                             kFunction),
XE_EXPORT(xam,      0x00000291, XamNotifyCreateListenerInternal,                            kFunction),
XE_EXPORT(xam,      0x00000292, XNotifyUISetOptions,                                        kFunction),
XE_EXPORT(xam,      0x00000293, XNotifyUIGetOptions,                                        kFunction),
XE_EXPORT(xam,      0x00000294, XamContentLaunchImageInternalEx,                            kFunction),
XE_EXPORT(xam,      0x00000295, XamShutdown,                                                kFunction),
XE_EXPORT(xam,      0x00000296, XamAllocDevkitHeapAvailable,                                kFunction),
XE_EXPORT(xam,      0x00000297, XamNotifyCreateListenerRangeInternal,                       kFunction),
XE_EXPORT(xam,      0x00000298, XNotifyQueueUIEx,                                           kFunction),
XE_EXPORT(xam,      0x00000299, XamAppRequestLoadEx,                                        kFunction),
XE_EXPORT(xam,      0x0000029A, XuiPNGTextureLoader,                                        kFunction),
XE_EXPORT(xam,      0x0000029B, XuiRenderGetXuiDevice,                                      kFunction),
XE_EXPORT(xam,      0x0000029C, XuiDefault_False,                                           kFunction),
XE_EXPORT(xam,      0x0000029D, XamUserGetReportingInfo,                                    kFunction),
XE_EXPORT(xam,      0x0000029E, XamUpdateStart,                                             kFunction),
XE_EXPORT(xam,      0x0000029F, XamUpdateGetProgress,                                       kFunction),
XE_EXPORT(xam,      0x000002A0, XamUpdateGetExtenderInstance,                               kFunction),
XE_EXPORT(xam,      0x000002A1, XamUpdateFinish,                                            kFunction),
XE_EXPORT(xam,      0x000002A2, XamUpdateAttachExtenderInstance,                            kFunction),
XE_EXPORT(xam,      0x000002A3, XamUpdateAllocateExtenderBuffer,                            kFunction),
XE_EXPORT(xam,      0x000002A4, XamRestartTitleLoadAfterUpdate,                             kFunction),
XE_EXPORT(xam,      0x000002A5, XamUIThreadDisableFontPatching,                             kFunction),
XE_EXPORT(xam,      0x000002A6, XamUpdateGetBaseSystemVersion,                              kFunction),
XE_EXPORT(xam,      0x000002A7, XamUpdateGetCurrentSystemVersion,                           kFunction),
XE_EXPORT(xam,      0x000002A8, XamUIThreadEnableFontPatching,                              kFunction),
XE_EXPORT(xam,      0x000002A9, XamTerminateTitleForUpdate,                                 kFunction),
XE_EXPORT(xam,      0x000002AA, XamSystemUpdateInstallLocal,                                kFunction),
XE_EXPORT(xam,      0x000002AB, XamUpdateChainPass3FromPass2,                               kFunction),
XE_EXPORT(xam,      0x000002AD, XamInputGetCapabilitiesEx,                                  kFunction),
XE_EXPORT(xam,      0x000002AE, XamUserIsUnsafeProgrammingAllowed,                          kFunction),
XE_EXPORT(xam,      0x000002AF, XamDevAuthSetFaultEx,                                       kFunction),
XE_EXPORT(xam,      0x000002B0, XamUpdateGetData,                                           kFunction),
XE_EXPORT(xam,      0x000002B1, XamCacheIntegrityCheck,                                     kFunction),
XE_EXPORT(xam,      0x000002B2, XamCacheStoreFile,                                          kFunction),
XE_EXPORT(xam,      0x000002B3, XamCacheFetchFile,                                          kFunction),
XE_EXPORT(xam,      0x000002B4, XamCacheOpenFile,                                           kFunction),
XE_EXPORT(xam,      0x000002B5, XamCacheCloseFile,                                          kFunction),
XE_EXPORT(xam,      0x000002B6, XamGetCachedTitleName,                                      kFunction),
XE_EXPORT(xam,      0x000002B7, XamCacheReset,                                              kFunction),
XE_EXPORT(xam,      0x000002B8, XamGetCachedGamerTag,                                       kFunction),
XE_EXPORT(xam,      0x000002B9, XamGetCachedGamerTagW,                                      kFunction),
XE_EXPORT(xam,      0x000002BA, XamCacheDeleteFile,                                         kFunction),
XE_EXPORT(xam,      0x000002BB, XamCacheRenameFile,                                         kFunction),
XE_EXPORT(xam,      0x000002BC, XamShowSigninUI,                                            kFunction),
XE_EXPORT(xam,      0x000002BD, XamShowSigninUIEx,                                          kFunction),
XE_EXPORT(xam,      0x000002BE, XamShowSigninUIp,                                           kFunction),
XE_EXPORT(xam,      0x000002BF, XamShowFriendsUI,                                           kFunction),
XE_EXPORT(xam,      0x000002C0, XamShowMessagesUI,                                          kFunction),
XE_EXPORT(xam,      0x000002C1, XamShowKeyboardUI,                                          kFunction),
XE_EXPORT(xam,      0x000002C2, XamShowQuickChatUI,                                         kFunction),
XE_EXPORT(xam,      0x000002C3, XamShowVoiceMailUI,                                         kFunction),
XE_EXPORT(xam,      0x000002C4, XamShowGamerCardUI,                                         kFunction),
XE_EXPORT(xam,      0x000002C5, XamShowAchievementsUI,                                      kFunction),
XE_EXPORT(xam,      0x000002C6, XamShowPlayerReviewUI,                                      kFunction),
XE_EXPORT(xam,      0x000002C7, XamShowMarketplaceUI,                                       kFunction),
XE_EXPORT(xam,      0x000002C8, XamShowPlayersUI,                                           kFunction),
XE_EXPORT(xam,      0x000002C9, XamShowUpdaterUI,                                           kFunction),
XE_EXPORT(xam,      0x000002CA, XamShowMessageBoxUI,                                        kFunction),
XE_EXPORT(xam,      0x000002CB, XamShowDeviceSelectorUI,                                    kFunction),
XE_EXPORT(xam,      0x000002CC, XamShowMessageComposeUI,                                    kFunction),
XE_EXPORT(xam,      0x000002CD, XamShowGameInviteUI,                                        kFunction),
XE_EXPORT(xam,      0x000002CE, XamShowFriendRequestUI,                                     kFunction),
XE_EXPORT(xam,      0x000002CF, XamShowCreateProfileUI,                                     kFunction),
XE_EXPORT(xam,      0x000002D0, XamShowGamesUI,                                             kFunction),
XE_EXPORT(xam,      0x000002D1, XamShowLiveSignupUI,                                        kFunction),
XE_EXPORT(xam,      0x000002D2, XamShowFriendsUIp,                                          kFunction),
XE_EXPORT(xam,      0x000002D3, XamShowComplaintUI,                                         kFunction),
XE_EXPORT(xam,      0x000002D4, XamShowReputationUI,                                        kFunction),
XE_EXPORT(xam,      0x000002D5, XamShowGamerCardUIForXUID,                                  kFunction),
XE_EXPORT(xam,      0x000002D6, XamShowForcedNameChangeUI,                                  kFunction),
XE_EXPORT(xam,      0x000002D7, XamShowLiveUpsellUI,                                        kFunction),
XE_EXPORT(xam,      0x000002D8, XamShowPasscodeVerifyUI,                                    kFunction),
XE_EXPORT(xam,      0x000002D9, XamShowDirtyDiscErrorUI,                                    kFunction),
XE_EXPORT(xam,      0x000002DA, XamShowSignupCreditCardUI,                                  kFunction),
XE_EXPORT(xam,      0x000002DB, XamShowPrivateChatInviteUI,                                 kFunction),
XE_EXPORT(xam,      0x000002DC, XamShowMessageBoxUIEx,                                      kFunction),
XE_EXPORT(xam,      0x000002DD, XamShowRecentMessageUI,                                     kFunction),
XE_EXPORT(xam,      0x000002DE, XamShowRecentMessageUIEx,                                   kFunction),
XE_EXPORT(xam,      0x000002DF, XamShowMessagesUIEx,                                        kFunction),
XE_EXPORT(xam,      0x000002E0, XamShowAchievementDetailsUI,                                kFunction),
XE_EXPORT(xam,      0x000002E1, XamShowPersonalizationUI,                                   kFunction),
XE_EXPORT(xam,      0x000002E2, XamShowChangeGamerTileUI,                                   kFunction),
XE_EXPORT(xam,      0x000002E3, XamShowVoiceSettingsUI,                                     kFunction),
XE_EXPORT(xam,      0x000002E4, XamShowVideoChatInviteUI,                                   kFunction),
XE_EXPORT(xam,      0x000002E5, XamShowCustomMessageComposeUI,                              kFunction),
XE_EXPORT(xam,      0x000002E6, XamShowCustomPlayerListUI,                                  kFunction),
XE_EXPORT(xam,      0x000002E7, XamShowMarketplaceDownloadItemsUI,                          kFunction),
XE_EXPORT(xam,      0x000002E8, XamShowMarketplaceUIEx,                                     kFunction),
XE_EXPORT(xam,      0x000002E9, XamShowMessageBox,                                          kFunction),
XE_EXPORT(xam,      0x000002EA, XamIsSysUiInvokedByXenonButton,                             kFunction),
XE_EXPORT(xam,      0x000002EB, XamIsSysUiInvokedByTitle,                                   kFunction),
XE_EXPORT(xam,      0x000002EC, XamIsUIActive,                                              kFunction),
XE_EXPORT(xam,      0x000002ED, XamSysUiDisableAutoClose,                                   kFunction),
XE_EXPORT(xam,      0x000002EE, XamUserCreateAchievementEnumerator,                         kFunction),
XE_EXPORT(xam,      0x000002EF, XamReadTile,                                                kFunction),
XE_EXPORT(xam,      0x000002F0, XamWriteGamerTile,                                          kFunction),
XE_EXPORT(xam,      0x000002F1, XamWriteTile,                                               kFunction),
XE_EXPORT(xam,      0x000002F2, XamReadImage,                                               kFunction),
XE_EXPORT(xam,      0x000002F3, XamUserCreateTitlesPlayedEnumerator,                        kFunction),
XE_EXPORT(xam,      0x000002F4, XamDecompressPNGToTexture,                                  kFunction),
XE_EXPORT(xam,      0x000002F5, XamReadTileToTexture,                                       kFunction),
XE_EXPORT(xam,      0x000002F6, XamReadString,                                              kFunction),
XE_EXPORT(xam,      0x000002F7, XamUserCreateStatsEnumerator,                               kFunction),
XE_EXPORT(xam,      0x000002F8, XamPrepareGamerTiles,                                       kFunction),
XE_EXPORT(xam,      0x000002F9, XamClearTitle,                                              kFunction),
XE_EXPORT(xam,      0x000002FA, XamReadStrings,                                             kFunction),
XE_EXPORT(xam,      0x000002FB, XamWriteGamerTileEx,                                        kFunction),
XE_EXPORT(xam,      0x000002FC, XamReadTileEx,                                              kFunction),
XE_EXPORT(xam,      0x000002FD, XamReadTileToTextureEx,                                     kFunction),
XE_EXPORT(xam,      0x000002FE, XamShowMessengerUI,                                         kFunction),
XE_EXPORT(xam,      0x000002FF, XamShowKeyboardUIMessenger,                                 kFunction),
XE_EXPORT(xam,      0x00000300, XamShowLiveUpsellUIEx,                                      kFunction),
XE_EXPORT(xam,      0x00000301, XamShowJoinSessionInProgressUI,                             kFunction),
XE_EXPORT(xam,      0x00000302, XamShowGraduateUserUI,                                      kFunction),
XE_EXPORT(xam,      0x00000303, XamShowGamerCardUIForXUIDp,                                 kFunction),
XE_EXPORT(xam,      0x00000304, XamShowGuideUI,                                             kFunction),
XE_EXPORT(xam,      0x00000305, XamShowPartyUI,                                             kFunction),
XE_EXPORT(xam,      0x00000306, XamShowPartyInviteUI,                                       kFunction),
XE_EXPORT(xam,      0x00000307, XamUserAddRecentPlayer,                                     kFunction),
XE_EXPORT(xam,      0x00000308, XamUserUpdateRecentPlayer,                                  kFunction),
XE_EXPORT(xam,      0x00000309, XamUserCreatePlayerEnumerator,                              kFunction),
XE_EXPORT(xam,      0x0000030A, XamParseGamerTileKey,                                       kFunction),
XE_EXPORT(xam,      0x0000030B, XamShowCommunitySessionsUI,                                 kFunction),
XE_EXPORT(xam,      0x0000030C, XamVoiceCreate,                                             kFunction),
XE_EXPORT(xam,      0x0000030D, XamVoiceHeadsetPresent,                                     kFunction),
XE_EXPORT(xam,      0x0000030E, XamVoiceSubmitPacket,                                       kFunction),
XE_EXPORT(xam,      0x0000030F, XamVoiceClose,                                              kFunction),
XE_EXPORT(xam,      0x00000310, XamVoiceGetBatteryStatus,                                   kFunction),
XE_EXPORT(xam,      0x00000311, Refresh_,                                                   kFunction),
XE_EXPORT(xam,      0x00000312, Refresh_0,                                                  kFunction),
XE_EXPORT(xam,      0x00000313, XamShowJoinSessionByIdInProgressUI,                         kFunction),
XE_EXPORT(xam,      0x00000314, XamShowPartyJoinInProgressUI,                               kFunction),
XE_EXPORT(xam,      0x00000315, XamBuildSharedSystemResourceLocator,                        kFunction),
XE_EXPORT(xam,      0x00000316, XamSessionCreateHandle,                                     kFunction),
XE_EXPORT(xam,      0x00000317, XamSessionRefObjByHandle,                                   kFunction),
XE_EXPORT(xam,      0x00000318, XamVoiceGetMicArrayStatus,                                  kFunction),
XE_EXPORT(xam,      0x00000319, XamVoiceSetAudioCaptureRoutine,                             kFunction),
XE_EXPORT(xam,      0x0000031A, XamVoiceGetDirectionalData,                                 kFunction),
XE_EXPORT(xam,      0x0000031B, XamBuildResourceLocator,                                    kFunction),
XE_EXPORT(xam,      0x0000031C, XamBuildLegacySystemResourceLocator,                        kFunction),
XE_EXPORT(xam,      0x0000031D, XamBuildGamercardResourceLocator,                           kFunction),
XE_EXPORT(xam,      0x0000031E, XamBuildDynamicResourceLocator,                             kFunction),
XE_EXPORT(xam,      0x0000031F, XamBuildXamResourceLocator,                                 kFunction),
XE_EXPORT(xam,      0x00000320, XuiAnimRun,                                                 kFunction),
XE_EXPORT(xam,      0x00000321, XuiApplyLocale,                                             kFunction),
XE_EXPORT(xam,      0x00000322, XuiBubbleMessage,                                           kFunction),
XE_EXPORT(xam,      0x00000323, XuiControlIsBackButton,                                     kFunction),
XE_EXPORT(xam,      0x00000324, XuiControlIsNavButton,                                      kFunction),
XE_EXPORT(xam,      0x00000325, XuiCreateObject,                                            kFunction),
XE_EXPORT(xam,      0x00000326, XuiDestroyObject,                                           kFunction),
XE_EXPORT(xam,      0x00000327, XuiDynamicCast,                                             kFunction),
XE_EXPORT(xam,      0x00000328, XuiElementAddChild,                                         kFunction),
XE_EXPORT(xam,      0x00000329, XuiElementFindNamedFrame,                                   kFunction),
XE_EXPORT(xam,      0x0000032A, XuiElementGetChildById,                                     kFunction),
XE_EXPORT(xam,      0x0000032B, XuiElementGetFirstChild,                                    kFunction),
XE_EXPORT(xam,      0x0000032C, XuiElementGetFocus,                                         kFunction),
XE_EXPORT(xam,      0x0000032D, XuiElementGetFocusUser,                                     kFunction),
XE_EXPORT(xam,      0x0000032E, XuiElementGetId,                                            kFunction),
XE_EXPORT(xam,      0x0000032F, XuiElementGetLastChild,                                     kFunction),
XE_EXPORT(xam,      0x00000330, XuiElementGetNext,                                          kFunction),
XE_EXPORT(xam,      0x00000331, XuiElementGetParent,                                        kFunction),
XE_EXPORT(xam,      0x00000332, XuiElementGetUserFocus,                                     kFunction),
XE_EXPORT(xam,      0x00000333, XuiElementInitFocus,                                        kFunction),
XE_EXPORT(xam,      0x00000334, XuiElementInitUserFocus,                                    kFunction),
XE_EXPORT(xam,      0x00000335, XuiElementPlayTimeline,                                     kFunction),
XE_EXPORT(xam,      0x00000336, XuiElementSetBounds,                                        kFunction),
XE_EXPORT(xam,      0x00000337, XuiElementSetFocus,                                         kFunction),
XE_EXPORT(xam,      0x00000338, XuiElementSetUserFocus,                                     kFunction),
XE_EXPORT(xam,      0x00000339, XuiElementTreeGetFocus,                                     kFunction),
XE_EXPORT(xam,      0x0000033A, XuiFindClass,                                               kFunction),
XE_EXPORT(xam,      0x0000033B, XuiFreeStringTable,                                         kFunction),
XE_EXPORT(xam,      0x0000033C, XuiGetBaseObject,                                           kFunction),
XE_EXPORT(xam,      0x0000033D, XuiGetClass,                                                kFunction),
XE_EXPORT(xam,      0x0000033E, XuiGetObjectClass,                                          kFunction),
XE_EXPORT(xam,      0x0000033F, XuiGetOuter,                                                kFunction),
XE_EXPORT(xam,      0x00000340, XuiInit,                                                    kFunction),
XE_EXPORT(xam,      0x00000341, XuiLoadFromBinary,                                          kFunction),
XE_EXPORT(xam,      0x00000342, XuiLoadStringTableFromFile,                                 kFunction),
XE_EXPORT(xam,      0x00000343, XuiVisualGetBasePath,                                       kFunction),
XE_EXPORT(xam,      0x00000344, XuiLookupStringTable,                                       kFunction),
XE_EXPORT(xam,      0x00000345, XuiNavButtonGetPressPath,                                   kFunction),
XE_EXPORT(xam,      0x00000346, XuiObjectFromHandle,                                        kFunction),
XE_EXPORT(xam,      0x00000347, XuiObjectGetProperty,                                       kFunction),
XE_EXPORT(xam,      0x00000348, XuiObjectGetPropertyId,                                     kFunction),
XE_EXPORT(xam,      0x00000349, XuiProcessInput,                                            kFunction),
XE_EXPORT(xam,      0x0000034A, XuiRegisterClass,                                           kFunction),
XE_EXPORT(xam,      0x0000034B, XuiRenderBegin,                                             kFunction),
XE_EXPORT(xam,      0x0000034C, XuiRenderCreateDC,                                          kFunction),
XE_EXPORT(xam,      0x0000034D, XuiRenderDCDeviceChanged,                                   kFunction),
XE_EXPORT(xam,      0x0000034E, XuiRenderDestroyDC,                                         kFunction),
XE_EXPORT(xam,      0x0000034F, XuiRenderEnd,                                               kFunction),
XE_EXPORT(xam,      0x00000350, XuiRenderGetBackBufferSize,                                 kFunction),
XE_EXPORT(xam,      0x00000351, XuiRenderInit,                                              kFunction),
XE_EXPORT(xam,      0x00000352, XuiRenderInitShared,                                        kFunction),
XE_EXPORT(xam,      0x00000353, XuiRenderPresent,                                           kFunction),
XE_EXPORT(xam,      0x00000354, XuiRenderSetViewTransform,                                  kFunction),
XE_EXPORT(xam,      0x00000355, XuiRenderUninit,                                            kFunction),
XE_EXPORT(xam,      0x00000356, XamShowNuiGuideUI,                                          kFunction),
XE_EXPORT(xam,      0x00000357, XuiSceneCreate,                                             kFunction),
XE_EXPORT(xam,      0x00000358, XuiSceneNavigateBack,                                       kFunction),
XE_EXPORT(xam,      0x00000359, XuiSceneNavigateFirst,                                      kFunction),
XE_EXPORT(xam,      0x0000035A, XuiSceneNavigateForward,                                    kFunction),
XE_EXPORT(xam,      0x0000035B, XuiScenePlayBackFromTransition,                             kFunction),
XE_EXPORT(xam,      0x0000035C, XuiScenePlayBackToTransition,                               kFunction),
XE_EXPORT(xam,      0x0000035D, XuiScenePlayFromTransition,                                 kFunction),
XE_EXPORT(xam,      0x0000035E, XuiScenePlayToTransition,                                   kFunction),
XE_EXPORT(xam,      0x0000035F, XuiSendMessage,                                             kFunction),
XE_EXPORT(xam,      0x00000360, XuiSetLocale,                                               kFunction),
XE_EXPORT(xam,      0x00000361, XuiUninit,                                                  kFunction),
XE_EXPORT(xam,      0x00000362, XuiUnregisterClass,                                         kFunction),
XE_EXPORT(xam,      0x00000363, XuiTextElementSetText,                                      kFunction),
XE_EXPORT(xam,      0x00000364, XuiSetTimer,                                                kFunction),
XE_EXPORT(xam,      0x00000365, XuiTimersRun,                                               kFunction),
XE_EXPORT(xam,      0x00000366, XuiTextElementGetText,                                      kFunction),
XE_EXPORT(xam,      0x00000367, XuiVisualSetBasePath,                                       kFunction),
XE_EXPORT(xam,      0x00000368, XuiHandleIsValid,                                           kFunction),
XE_EXPORT(xam,      0x00000369, XuiAlloc,                                                   kFunction),
XE_EXPORT(xam,      0x0000036A, XuiFree,                                                    kFunction),
XE_EXPORT(xam,      0x0000036B, XuiDefault_True,                                            kFunction),
XE_EXPORT(xam,      0x0000036C, XuiDefault_EmptyString,                                     kFunction),
XE_EXPORT(xam,      0x0000036D, XuiDefault_IntegerZero,                                     kFunction),
XE_EXPORT(xam,      0x0000036E, XuiCopyString,                                              kFunction),
XE_EXPORT(xam,      0x0000036F, XuiRealloc,                                                 kFunction),
XE_EXPORT(xam,      0x00000370, XuiControlPlayOptionalVisual,                               kFunction),
XE_EXPORT(xam,      0x00000371, XuiKillTimer,                                               kFunction),
XE_EXPORT(xam,      0x00000372, XuiElementEnableInput,                                      kFunction),
XE_EXPORT(xam,      0x00000373, XuiElementInputEnabled,                                     kFunction),
XE_EXPORT(xam,      0x00000374, XuiIsInstanceOf,                                            kFunction),
XE_EXPORT(xam,      0x00000375, XuiResourceComposeLocator,                                  kFunction),
XE_EXPORT(xam,      0x00000376, XuiResourceLocatorIsAbsolute,                               kFunction),
XE_EXPORT(xam,      0x00000377, XuiBroadcastMessage,                                        kFunction),
XE_EXPORT(xam,      0x00000378, XuiElementDisallowRecursiveTimelineControl,                 kFunction),
XE_EXPORT(xam,      0x00000379, XUIElementPropVal_Construct,                                kFunction),
XE_EXPORT(xam,      0x0000037A, XUIElementPropVal_Destruct,                                 kFunction),
XE_EXPORT(xam,      0x0000037B, XUIElementPropVal_SetString,                                kFunction),
XE_EXPORT(xam,      0x0000037C, XuiObjectSetProperty,                                       kFunction),
XE_EXPORT(xam,      0x0000037D, XuiElementGetOpacity,                                       kFunction),
XE_EXPORT(xam,      0x0000037E, XuiElementSetOpacity,                                       kFunction),
XE_EXPORT(xam,      0x0000037F, XuiEditSetTextLimit,                                        kFunction),
XE_EXPORT(xam,      0x00000380, XuiEditGetTextLimit,                                        kFunction),
XE_EXPORT(xam,      0x00000381, XuiSliderSetValue,                                          kFunction),
XE_EXPORT(xam,      0x00000382, XuiSliderGetValue,                                          kFunction),
XE_EXPORT(xam,      0x00000383, XuiSliderSetRange,                                          kFunction),
XE_EXPORT(xam,      0x00000384, XuiElementUnlink,                                           kFunction),
XE_EXPORT(xam,      0x00000385, XuiElementInsertChild,                                      kFunction),
XE_EXPORT(xam,      0x00000386, XuiSceneNavigateBackToFirst,                                kFunction),
XE_EXPORT(xam,      0x00000387, XuiProgressBarSetRange,                                     kFunction),
XE_EXPORT(xam,      0x00000388, XuiProgressBarSetValue,                                     kFunction),
XE_EXPORT(xam,      0x00000389, XuiProgressBarGetValue,                                     kFunction),
XE_EXPORT(xam,      0x0000038A, XuiControlAttachVisual,                                     kFunction),
XE_EXPORT(xam,      0x0000038B, XuiCreateTextureBrush,                                      kFunction),
XE_EXPORT(xam,      0x0000038C, XuiDestroyBrush,                                            kFunction),
XE_EXPORT(xam,      0x0000038D, XUIElementPropVal_SetColorFromUint,                         kFunction),
XE_EXPORT(xam,      0x0000038E, XuiFigureSetFill,                                           kFunction),
XE_EXPORT(xam,      0x0000038F, XuiSliderGetRange,                                          kFunction),
XE_EXPORT(xam,      0x00000390, XuiFigureSetTexture,                                        kFunction),
XE_EXPORT(xam,      0x00000391, XuiControlGetItemAssociation,                               kFunction),
XE_EXPORT(xam,      0x00000392, XuiResourceLoadAll,                                         kFunction),
XE_EXPORT(xam,      0x00000393, XuiImageElementSetImagePath,                                kFunction),
XE_EXPORT(xam,      0x00000394, XuiImageElementGetImagePath,                                kFunction),
XE_EXPORT(xam,      0x00000395, XuiControlGetVisual,                                        kFunction),
XE_EXPORT(xam,      0x00000396, XuiControlGetNavigation,                                    kFunction),
XE_EXPORT(xam,      0x00000397, XuiLookupStringTableByIndex,                                kFunction),
XE_EXPORT(xam,      0x00000398, XUIElementPropVal_SetBool,                                  kFunction),
XE_EXPORT(xam,      0x00000399, XuiElementHasFocus,                                         kFunction),
XE_EXPORT(xam,      0x0000039A, XUIElementPropVal_SetUint,                                  kFunction),
XE_EXPORT(xam,      0x0000039B, XUIElementPropVal_Clear,                                    kFunction),
XE_EXPORT(xam,      0x0000039C, XuiEditSetTextFormatInfo,                                   kFunction),
XE_EXPORT(xam,      0x0000039D, XuiCreateSolidBrush,                                        kFunction),
XE_EXPORT(xam,      0x0000039E, XuiSceneInterruptTransitions,                               kFunction),
XE_EXPORT(xam,      0x0000039F, XuiResourceOpen,                                            kFunction),
XE_EXPORT(xam,      0x000003A0, XuiResourceRead,                                            kFunction),
XE_EXPORT(xam,      0x000003A1, XuiResourceClose,                                           kFunction),
XE_EXPORT(xam,      0x000003A2, XuiVisualCreateInstance,                                    kFunction),
XE_EXPORT(xam,      0x000003A3, XuiElementGetTimeline,                                      kFunction),
XE_EXPORT(xam,      0x000003A4, GetCodecVersion,                                            kFunction),
XE_EXPORT(xam,      0x000003A5, XuiElementIsDescendant,                                     kFunction),
XE_EXPORT(xam,      0x000003A6, XuiSetMessageFilter,                                        kFunction),
XE_EXPORT(xam,      0x000003A7, XuiAttachTextureBrush,                                      kFunction),
XE_EXPORT(xam,      0x000003A8, XuiElementBeginRender,                                      kFunction),
XE_EXPORT(xam,      0x000003A9, XuiElementEndRender,                                        kFunction),
XE_EXPORT(xam,      0x000003AA, XuiDrawShape,                                               kFunction),
XE_EXPORT(xam,      0x000003AB, XuiSelectBrushEx,                                           kFunction),
XE_EXPORT(xam,      0x000003AC, XuiFigureGetShape,                                          kFunction),
XE_EXPORT(xam,      0x000003AD, XuiFillRect,                                                kFunction),
XE_EXPORT(xam,      0x000003AE, XuiVec2TransformCoord,                                      kFunction),
XE_EXPORT(xam,      0x000003AF, XuiMatrixMultiply,                                          kFunction),
XE_EXPORT(xam,      0x000003B0, XuiElementGetXForm,                                         kFunction),
XE_EXPORT(xam,      0x000003B1, XuiElementSetPosition,                                      kFunction),
XE_EXPORT(xam,      0x000003B2, XuiSelectBrush,                                             kFunction),
XE_EXPORT(xam,      0x000003B3, XuiElementRenderChildren,                                   kFunction),
XE_EXPORT(xam,      0x000003B4, XuiFreeUnusedTextures,                                      kFunction),
XE_EXPORT(xam,      0x000003B5, XuiListEnableItemOverride,                                  kFunction),
XE_EXPORT(xam,      0x000003B6, XuiListGetDefaultItemSize,                                  kFunction),
XE_EXPORT(xam,      0x000003B7, XuiResourceSeek,                                            kFunction),
XE_EXPORT(xam,      0x000003B8, XuiElementDiscardResources,                                 kFunction),
XE_EXPORT(xam,      0x000003B9, XuiTabSceneGoto,                                            kFunction),
XE_EXPORT(xam,      0x000003BA, XuiTabSceneGetCurrentTab,                                   kFunction),
XE_EXPORT(xam,      0x000003BB, XamShowWhatsOnUI,                                           kFunction),
XE_EXPORT(xam,      0x000003BC, XamShowEditProfileUI,                                       kFunction),
XE_EXPORT(xam,      0x000003BD, XamShowStorePickerUI,                                       kFunction),
XE_EXPORT(xam,      0x000003BE, XamShowTermsOfUseUI,                                        kFunction),
XE_EXPORT(xam,      0x000003BF, XamShowJoinPartyUI,                                         kFunction),
XE_EXPORT(xam,      0x000003C0, XamShowWordRegisterUI,                                      kFunction),
XE_EXPORT(xam,      0x000003C1, XamOverrideHudOpenType,                                     kFunction),
XE_EXPORT(xam,      0x000003C2, XamShowAchievementsUIEx,                                    kFunction),
XE_EXPORT(xam,      0x000003C3, XamUserGetUserTenure,                                       kFunction),
XE_EXPORT(xam,      0x000003C4, XamUserGetSubscriptionType,                                 kFunction),
XE_EXPORT(xam,      0x000003C5, XamShowGameVoiceChannelUI,                                  kFunction),
XE_EXPORT(xam,      0x000003C6, XamShowAvatarAwardsUI,                                      kFunction),
XE_EXPORT(xam,      0x000003C7, XamShowAvatarAwardGamesUI,                                  kFunction),
XE_EXPORT(xam,      0x000003C8, XamShowVideoRichPresenceUI,                                 kFunction),
XE_EXPORT(xam,      0x000003C9, XamHudGetUserIndex,                                         kFunction),
XE_EXPORT(xam,      0x000003CA, XGetAudioFlags,                                             kFunction),
XE_EXPORT(xam,      0x000003CB, XGetAVPack,                                                 kFunction),
XE_EXPORT(xam,      0x000003CC, XGetGameRegion,                                             kFunction),
XE_EXPORT(xam,      0x000003CD, XGetLanguage,                                               kFunction),
XE_EXPORT(xam,      0x000003CE, XapipGetLocale,                                             kFunction),
XE_EXPORT(xam,      0x000003CF, XGetVideoFlags,                                             kFunction),
XE_EXPORT(xam,      0x000003D0, XGetVideoStandard,                                          kFunction),
XE_EXPORT(xam,      0x000003D1, XGetVideoMode,                                              kFunction),
XE_EXPORT(xam,      0x000003D2, XamGetLanguage,                                             kFunction),
XE_EXPORT(xam,      0x000003D3, XUITimeline_Run,                                            kFunction),
XE_EXPORT(xam,      0x000003D4, XamSetAutomation,                                           kFunction),
XE_EXPORT(xam,      0x000003D5, XAutomationpBindController,                                 kFunction),
XE_EXPORT(xam,      0x000003D6, XAutomationpUnbindController,                               kFunction),
XE_EXPORT(xam,      0x000003D7, XAutomationpInputXenonButton,                               kFunction),
XE_EXPORT(xam,      0x000003D8, XAutomationpInputPress,                                     kFunction),
XE_EXPORT(xam,      0x000003D9, XAutomationpInputSetState,                                  kFunction),
XE_EXPORT(xam,      0x000003DA, XamEnableOverdraw,                                          kFunction),
XE_EXPORT(xam,      0x000003DB, g_XuiAutomation,                                            kVariable),
XE_EXPORT(xam,      0x000003DC, XamVoiceGetMicArrayAudio,                                   kFunction),
XE_EXPORT(xam,      0x000003DD, XampSystemInput,                                            kFunction),
XE_EXPORT(xam,      0x000003DE, XamInputControl,                                            kFunction),
XE_EXPORT(xam,      0x000003DF, XuiElementGetPosition,                                      kFunction),
XE_EXPORT(xam,      0x000003E0, XamIsMessageBoxActive,                                      kFunction),
XE_EXPORT(xam,      0x000003E1, XamIsBackgroundSceneInTransition,                           kFunction),
XE_EXPORT(xam,      0x000003E2, XuiElementTreeHasFocus,                                     kFunction),
XE_EXPORT(xam,      0x000003E3, XuiFigureClose,                                             kFunction),
XE_EXPORT(xam,      0x000003E4, GamerCardStartup,                                           kFunction),
XE_EXPORT(xam,      0x000003E5, GamerCardCleanup,                                           kFunction),
XE_EXPORT(xam,      0x000003E6, GamerCardRegisterControls,                                  kFunction),
XE_EXPORT(xam,      0x000003E7, GamerCardUnregisterControls,                                kFunction),
XE_EXPORT(xam,      0x000003E8, RtlFindFirstFile,                                           kFunction),
XE_EXPORT(xam,      0x000003E9, RtlFindNextFile,                                            kFunction),
XE_EXPORT(xam,      0x000003EA, RtlGetModuleFileName,                                       kFunction),
XE_EXPORT(xam,      0x000003EB, RtlOutputDebugString,                                       kFunction),
XE_EXPORT(xam,      0x000003EC, RtlRemoveDirectory,                                         kFunction),
XE_EXPORT(xam,      0x000003ED, RtlSleep,                                                   kFunction),
XE_EXPORT(xam,      0x000003EE, RtlGetLastError,                                            kFunction),
XE_EXPORT(xam,      0x000003EF, RtlSetLastError,                                            kFunction),
XE_EXPORT(xam,      0x000003F0, RtlSetLastNTError,                                          kFunction),
XE_EXPORT(xam,      0x000003F1, RtlDebugPrint,                                              kFunction),
XE_EXPORT(xam,      0x000003F2, RtlDebugError,                                              kFunction),
XE_EXPORT(xam,      0x000003F3, XDebugWarning,                                              kFunction),
XE_EXPORT(xam,      0x000003F4, RtlDebugTrace,                                              kFunction),
XE_EXPORT(xam,      0x000003F5, RtlDebugEntry,                                              kFunction),
XE_EXPORT(xam,      0x000003F6, RtlDebugExit,                                               kFunction),
XE_EXPORT(xam,      0x000003F7, RtlGetAttributesOnHeapAlloc,                                kFunction),
XE_EXPORT(xam,      0x000003F8, RtlSetAttributesOnHeapAlloc,                                kFunction),
XE_EXPORT(xam,      0x000003F9, XuiFigureSetShape,                                          kFunction),
XE_EXPORT(xam,      0x000003FA, RtlCreateHeap,                                              kFunction),
XE_EXPORT(xam,      0x000003FB, RtlDestroyHeap,                                             kFunction),
XE_EXPORT(xam,      0x000003FC, RtlAllocateHeap,                                            kFunction),
XE_EXPORT(xam,      0x000003FD, RtlAllocateHeapSlowly,                                      kFunction),
XE_EXPORT(xam,      0x000003FE, RtlReAllocateHeap,                                          kFunction),
XE_EXPORT(xam,      0x000003FF, RtlFreeHeap,                                                kFunction),
XE_EXPORT(xam,      0x00000400, RtlFreeHeapSlowly,                                          kFunction),
XE_EXPORT(xam,      0x00000401, RtlSizeHeap,                                                kFunction),
XE_EXPORT(xam,      0x00000402, RtlZeroHeap,                                                kFunction),
XE_EXPORT(xam,      0x00000403, RtlDebugWalkHeap,                                           kFunction),
XE_EXPORT(xam,      0x00000404, RtlWalkHeap,                                                kFunction),
XE_EXPORT(xam,      0x00000405, RtlLockHeap,                                                kFunction),
XE_EXPORT(xam,      0x00000406, RtlUnlockHeap,                                              kFunction),
XE_EXPORT(xam,      0x00000407, RtlValidateHeap,                                            kFunction),
XE_EXPORT(xam,      0x00000408, RtlDebugCompactHeap,                                        kFunction),
XE_EXPORT(xam,      0x00000409, RtlCompactHeap,                                             kFunction),
XE_EXPORT(xam,      0x0000040A, XamAppSetTestOption,                                        kFunction),
XE_EXPORT(xam,      0x0000040B, XamAppReportError,                                          kFunction),
XE_EXPORT(xam,      0x0000040C, XamIsNuiUIActive,                                           kFunction),
XE_EXPORT(xam,      0x0000040D, XamVerifyPasscode,                                          kFunction),
XE_EXPORT(xam,      0x0000040E, OutputDebugStringA,                                         kFunction),
XE_EXPORT(xam,      0x0000040F, DebugBreak,                                                 kFunction),
XE_EXPORT(xam,      0x00000410, GetCurrentThreadId,                                         kFunction),
XE_EXPORT(xam,      0x00000411, XDebugError,                                                kFunction),
XE_EXPORT(xam,      0x00000412, XDebugWarning_,                                             kFunction),
XE_EXPORT(xam,      0x00000413, RtlDebugSetLevel,                                           kFunction),
XE_EXPORT(xam,      0x00000414, CloseHandle,                                                kFunction),
XE_EXPORT(xam,      0x00000415, GetTickCount,                                               kFunction),
XE_EXPORT(xam,      0x00000416, GetLastError,                                               kFunction),
XE_EXPORT(xam,      0x00000417, SetFilePointer,                                             kFunction),
XE_EXPORT(xam,      0x00000418, SetFilePointerEx,                                           kFunction),
XE_EXPORT(xam,      0x00000419, SetLastError,                                               kFunction),
XE_EXPORT(xam,      0x0000041A, MultiByteToWideChar,                                        kFunction),
XE_EXPORT(xam,      0x0000041B, WideCharToMultiByte,                                        kFunction),
XE_EXPORT(xam,      0x0000041C, ReadFile,                                                   kFunction),
XE_EXPORT(xam,      0x0000041D, FlushFileBuffers,                                           kFunction),
XE_EXPORT(xam,      0x0000041E, WriteFile,                                                  kFunction),
XE_EXPORT(xam,      0x0000041F, OutputDebugStringW,                                         kFunction),
XE_EXPORT(xam,      0x00000420, SetEvent,                                                   kFunction),
XE_EXPORT(xam,      0x00000421, XapiFormatTimeOut,                                          kFunction),
XE_EXPORT(xam,      0x00000422, CreateMutexA,                                               kFunction),
XE_EXPORT(xam,      0x00000423, OpenMutexA,                                                 kFunction),
XE_EXPORT(xam,      0x00000424, ReleaseMutex,                                               kFunction),
XE_EXPORT(xam,      0x00000425, WaitForSingleObject,                                        kFunction),
XE_EXPORT(xam,      0x00000426, WaitForSingleObjectEx,                                      kFunction),
XE_EXPORT(xam,      0x00000427, GetFileSize,                                                kFunction),
XE_EXPORT(xam,      0x00000428, GetFileSizeEx,                                              kFunction),
XE_EXPORT(xam,      0x00000429, XapiDirectoryInformationToFindData,                         kFunction),
XE_EXPORT(xam,      0x0000042A, XapiFormatObjectAttributes,                                 kFunction),
XE_EXPORT(xam,      0x0000042B, ResetEvent,                                                 kFunction),
XE_EXPORT(xam,      0x0000042C, wsprintfA,                                                  kFunction),
XE_EXPORT(xam,      0x0000042D, wsprintfW,                                                  kFunction),
XE_EXPORT(xam,      0x0000042E, GetOverlappedResult,                                        kFunction),
XE_EXPORT(xam,      0x0000042F, QueryPerformanceCounter,                                    kFunction),
XE_EXPORT(xam,      0x00000430, QueryPerformanceFrequency,                                  kFunction),
XE_EXPORT(xam,      0x00000431, LocalAlloc,                                                 kFunction),
XE_EXPORT(xam,      0x00000432, LocalFree,                                                  kFunction),
XE_EXPORT(xam,      0x00000433, RaiseException,                                             kFunction),
XE_EXPORT(xam,      0x00000434, RtlUniform,                                                 kFunction),
XE_EXPORT(xam,      0x00000435, RtlRandom,                                                  kFunction),
XE_EXPORT(xam,      0x00000436, Sleep,                                                      kFunction),
XE_EXPORT(xam,      0x00000437, SleepEx,                                                    kFunction),
XE_EXPORT(xam,      0x00000438, XMemSet,                                                    kFunction),
XE_EXPORT(xam,      0x00000439, XRegisterThreadNotifyRoutine,                               kFunction),
XE_EXPORT(xam,      0x0000043A, XGetOverlappedExtendedError,                                kFunction),
XE_EXPORT(xam,      0x0000043B, XGetOverlappedResult,                                       kFunction),
XE_EXPORT(xam,      0x0000043C, CreateThread,                                               kFunction),
XE_EXPORT(xam,      0x0000043D, ResumeThread,                                               kFunction),
XE_EXPORT(xam,      0x0000043E, ExitThread,                                                 kFunction),
XE_EXPORT(xam,      0x0000043F, GetTimeZoneInformation,                                     kFunction),
XE_EXPORT(xam,      0x00000440, GetSystemTimeAsFileTime,                                    kFunction),
XE_EXPORT(xam,      0x00000441, SystemTimeToFileTime,                                       kFunction),
XE_EXPORT(xam,      0x00000442, FileTimeToSystemTime,                                       kFunction),
XE_EXPORT(xam,      0x00000443, GetSystemTime,                                              kFunction),
XE_EXPORT(xam,      0x00000444, GetLocalTime,                                               kFunction),
XE_EXPORT(xam,      0x00000445, CreateDirectoryA,                                           kFunction),
XE_EXPORT(xam,      0x00000446, CreateEventA,                                               kFunction),
XE_EXPORT(xam,      0x00000447, CreateFileA,                                                kFunction),
XE_EXPORT(xam,      0x00000448, DeleteFileA,                                                kFunction),
XE_EXPORT(xam,      0x00000449, FindFirstFileA,                                             kFunction),
XE_EXPORT(xam,      0x0000044A, FindNextFileA,                                              kFunction),
XE_EXPORT(xam,      0x0000044B, GetFileAttributesA,                                         kFunction),
XE_EXPORT(xam,      0x0000044C, XamLoaderGetCurrentTitleD3DVersion,                         kFunction),
XE_EXPORT(xam,      0x0000044D, GetFileAttributesExA,                                       kFunction),
XE_EXPORT(xam,      0x0000044E, GetModuleHandleA,                                           kFunction),
XE_EXPORT(xam,      0x0000044F, GetDiskFreeSpaceExA,                                        kFunction),
XE_EXPORT(xam,      0x00000450, CopyFileA,                                                  kFunction),
XE_EXPORT(xam,      0x00000451, SetEndOfFile,                                               kFunction),
XE_EXPORT(xam,      0x00000452, XamFamilyAddParentalExemptionToList,                        kFunction),
XE_EXPORT(xam,      0x00000453, XamFamilyIsParentalValidationRequired,                      kFunction),
XE_EXPORT(xam,      0x00000454, PIXBeginCapture,                                            kFunction),
XE_EXPORT(xam,      0x00000455, PIXEndCapture,                                              kFunction),
XE_EXPORT(xam,      0x00000456, PIXAddCounter,                                              kFunction),
XE_EXPORT(xam,      0x00000457, PIXGetGPUSlot,                                              kFunction),
XE_EXPORT(xam,      0x00000458, SetWaitableTimer,                                           kFunction),
XE_EXPORT(xam,      0x00000459, CancelWaitableTimer,                                        kFunction),
XE_EXPORT(xam,      0x0000045A, CreateWaitableTimerA,                                       kFunction),
XE_EXPORT(xam,      0x0000045B, DuplicateHandle,                                            kFunction),
XE_EXPORT(xam,      0x0000045C, XapipCreateThread,                                          kFunction),
XE_EXPORT(xam,      0x0000045D, lstrcpyA,                                                   kFunction),
XE_EXPORT(xam,      0x0000045E, lstrcpyW,                                                   kFunction),
XE_EXPORT(xam,      0x0000045F, lstrcpynA,                                                  kFunction),
XE_EXPORT(xam,      0x00000460, lstrcpynW,                                                  kFunction),
XE_EXPORT(xam,      0x00000461, lstrcatA,                                                   kFunction),
XE_EXPORT(xam,      0x00000462, lstrcatW,                                                   kFunction),
XE_EXPORT(xam,      0x00000463, lstrlenA,                                                   kFunction),
XE_EXPORT(xam,      0x00000464, lstrlenW,                                                   kFunction),
XE_EXPORT(xam,      0x00000465, IsBadReadPtr,                                               kFunction),
XE_EXPORT(xam,      0x00000466, IsBadWritePtr,                                              kFunction),
XE_EXPORT(xam,      0x00000467, FileTimeToLocalFileTime,                                    kFunction),
XE_EXPORT(xam,      0x00000468, XMemCpy,                                                    kFunction),
XE_EXPORT(xam,      0x00000469, XMemCpyStreaming,                                           kFunction),
XE_EXPORT(xam,      0x0000046A, XamHudSetUserIndex,                                         kFunction),
XE_EXPORT(xam,      0x0000046B, XamShowNuiTroubleshooterUI,                                 kFunction),
XE_EXPORT(xam,      0x0000046C, XamTestShowNuiTroubleshooterUI,                             kFunction),
XE_EXPORT(xam,      0x0000046D, XamShowPasscodeVerifyUIEx,                                  kFunction),
XE_EXPORT(xam,      0x0000046E, XamShowNuiAchievementsUI,                                   kFunction),
XE_EXPORT(xam,      0x0000046F, XamShowNuiCommunitySessionsUI,                              kFunction),
XE_EXPORT(xam,      0x00000470, XamShowNuiDeviceSelectorUI,                                 kFunction),
XE_EXPORT(xam,      0x00000471, XamShowNuiDirtyDiscErrorUI,                                 kFunction),
XE_EXPORT(xam,      0x00000472, XamShowNuiFriendsUI,                                        kFunction),
XE_EXPORT(xam,      0x00000473, XamShowNuiGameInviteUI,                                     kFunction),
XE_EXPORT(xam,      0x00000474, XamShowNuiGamerCardUIForXUID,                               kFunction),
XE_EXPORT(xam,      0x00000475, XamShowNuiMarketplaceDownloadItemsUI,                       kFunction),
XE_EXPORT(xam,      0x00000476, XamShowNuiMarketplaceUI,                                    kFunction),
XE_EXPORT(xam,      0x00000477, XamShowNuiMessageBoxUI,                                     kFunction),
XE_EXPORT(xam,      0x00000478, XamShowNuiPartyUI,                                          kFunction),
XE_EXPORT(xam,      0x00000479, XamShowNuiFriendRequestUI,                                  kFunction),
XE_EXPORT(xam,      0x0000047A, XamShowNuiSigninUI,                                         kFunction),
XE_EXPORT(xam,      0x0000047B, XamShowNuiControllerRequiredUI,                             kFunction),
XE_EXPORT(xam,      0x0000047C, XamShowNuiGamesUI,                                          kFunction),
XE_EXPORT(xam,      0x0000047D, XamShowNuiHardwareRequiredUI,                               kFunction),
XE_EXPORT(xam,      0x0000047E, XamCacheStoreFileByString,                                  kFunction),
XE_EXPORT(xam,      0x0000047F, XamCacheFetchFileByString,                                  kFunction),
XE_EXPORT(xam,      0x00000480, XamCacheDeleteFileByString,                                 kFunction),
XE_EXPORT(xam,      0x00000481, XamGetCachedTitleNameEx,                                    kFunction),
XE_EXPORT(xam,      0x00000482, XamXlfsInitializeUploadQueue,                               kFunction),
XE_EXPORT(xam,      0x00000483, XamXlfsUninitializeUploadQueue,                             kFunction),
XE_EXPORT(xam,      0x00000484, XamXlfsMountUploadQueueInstance,                            kFunction),
XE_EXPORT(xam,      0x00000485, XamXlfsUnmountUploadQueueInstance,                          kFunction),
XE_EXPORT(xam,      0x00000486, XamVoiceRecordUserPrivileges,                               kFunction),
XE_EXPORT(xam,      0x00000487, XamXlfsInitializeUploadQueueWithTestHooks,                  kFunction),
XE_EXPORT(xam,      0x00000488, XamXlfsNotifyContentDeletion,                               kFunction),
XE_EXPORT(xam,      0x00000489, XMemAlloc,                                                  kFunction),
XE_EXPORT(xam,      0x0000048A, XMemFree,                                                   kFunction),
XE_EXPORT(xam,      0x0000048B, XMemSize,                                                   kFunction),
XE_EXPORT(xam,      0x0000048C, XamVoiceSetMicArrayIdleUsers,                               kFunction),
XE_EXPORT(xam,      0x0000048D, XamVoiceMuteMicArray,                                       kFunction),
XE_EXPORT(xam,      0x0000048E, XamVoiceGetMicArrayUnderrunStatus,                          kFunction),
XE_EXPORT(xam,      0x0000048F, XuiSceneEnableTransitionDependency,                         kFunction),
XE_EXPORT(xam,      0x00000490, XamVoiceGetMicArrayAudioEx,                                 kFunction),
XE_EXPORT(xam,      0x00000491, XamVoiceDisableMicArray,                                    kFunction),
XE_EXPORT(xam,      0x00000492, XamUserGetDeviceId,                                         kFunction),
XE_EXPORT(xam,      0x00000493, XamUpdateEtxLogUpdateTaskStart,                             kFunction),
XE_EXPORT(xam,      0x00000494, XamUpdateEtxLogUpdateTaskSuccess,                           kFunction),
XE_EXPORT(xam,      0x00000495, XamUpdateEtxLogUpdateTaskFailure,                           kFunction),
XE_EXPORT(xam,      0x00000496, XamEtxFlushLogs,                                            kFunction),
XE_EXPORT(xam,      0x00000497, XamVoiceIsActiveProcess,                                    kFunction),
XE_EXPORT(xam,      0x00000498, XamInactivityGetInactivityInterruptTime,                    kFunction),
XE_EXPORT(xam,      0x00000499, XamInactivitySetInactivityInterruptTime,                    kFunction),
XE_EXPORT(xam,      0x0000049A, XamInactivityGetLastActivityTime,                           kFunction),
XE_EXPORT(xam,      0x0000049B, XamInactivitySetDetectionTaskPeriod,                        kFunction),
XE_EXPORT(xam,      0x0000049C, XamInactivityEnablePowerDown,                               kFunction),
XE_EXPORT(xam,      0x0000049D, XamUpdateGetChainMarker,                                    kFunction),
XE_EXPORT(xam,      0x0000049E, XGetVideoCapabilities,                                      kFunction),
XE_EXPORT(xam,      0x0000049F, XMsgProcessRequest,                                         kFunction),
XE_EXPORT(xam,      0x000004A0, XGetDisplaySize,                                            kFunction),
XE_EXPORT(xam,      0x000004A1, XamInputNonControllerGetRaw,                                kFunction),
XE_EXPORT(xam,      0x000004A2, XamInputNonControllerSetRaw,                                kFunction),
XE_EXPORT(xam,      0x000004A3, XamVoiceSetMicArrayBeamAngle,                               kFunction),
XE_EXPORT(xam,      0x000004A4, XamUserGetAge,                                              kFunction),
XE_EXPORT(xam,      0x000004A5, XamUserGetAgeGroup,                                         kFunction),
XE_EXPORT(xam,      0x000004A6, XamVoiceGetMicArrayFilenameDesc,                            kFunction),
XE_EXPORT(xam,      0x000004A7, XamLoaderGetState,                                          kFunction),
XE_EXPORT(xam,      0x000004A8, XamTaskQueryProperty,                                       kFunction),
XE_EXPORT(xam,      0x000004A9, XamGetLocale,                                               kFunction),
XE_EXPORT(xam,      0x000004AA, XamQueryTimeZoneInformation,                                kFunction),
XE_EXPORT(xam,      0x000004AB, XamSetTimeZoneInformation,                                  kFunction),
XE_EXPORT(xam,      0x000004AC, XamLaunchURI,                                               kFunction),
XE_EXPORT(xam,      0x000004AF, XamShowNuiMessagesUI,                                       kFunction),
XE_EXPORT(xam,      0x000004B0, XMPRegisterCodec,                                           kFunction),
XE_EXPORT(xam,      0x000004B1, XamNavigateBack,                                            kFunction),
XE_EXPORT(xam,      0x000004B2, XamPushBackURI,                                             kFunction),
XE_EXPORT(xam,      0x000004B3, XamUserOverrideDeviceBindings,                              kFunction),
XE_EXPORT(xam,      0x000004B4, XamUserOverrideBindingCallbacks,                            kFunction),
XE_EXPORT(xam,      0x000004B5, XamUserOverrideUserInfo,                                    kFunction),
XE_EXPORT(xam,      0x000004B6, XamUserContentRestrictionGetFlags,                          kFunction),
XE_EXPORT(xam,      0x000004B7, XamUserContentRestrictionGetRating,                         kFunction),
XE_EXPORT(xam,      0x000004B8, XamUserContentRestrictionCheckAccess,                       kFunction),
XE_EXPORT(xam,      0x000004B9, XamShowFitnessBodyProfileUI,                                kFunction),
XE_EXPORT(xam,      0x000004BA, XamFitnessAddBodyProfileRecord,                             kFunction),
XE_EXPORT(xam,      0x000004BB, XamFamilyGetMembers,                                        kFunction),
XE_EXPORT(xam,      0x000004BC, XampXAuthStartup,                                           kFunction),
XE_EXPORT(xam,      0x000004BD, XampXAuthShutdown,                                          kFunction),
XE_EXPORT(xam,      0x000004BE, XamGetToken,                                                kFunction),
XE_EXPORT(xam,      0x000004BF, XamFreeToken,                                               kFunction),
XE_EXPORT(xam,      0x000004C0, XamGetAppliesTo,                                            kFunction),
XE_EXPORT(xam,      0x000004C1, XamFitnessClearBodyProfileRecords,                          kFunction),
XE_EXPORT(xam,      0x000004C2, XamFitnessGetCurrentBodyProfileRecord,                      kFunction),
XE_EXPORT(xam,      0x000004C3, XamFitnessGetAllBodyProfileRecords,                         kFunction),
XE_EXPORT(xam,      0x000004C4, XamFitnessGetAllTitleSummaries,                             kFunction),
XE_EXPORT(xam,      0x000004C5, XamFitnessGetOverallSummary,                                kFunction),
XE_EXPORT(xam,      0x000004C6, XamFitnessAddFitnessEvent,                                  kFunction),
XE_EXPORT(xam,      0x000004C7, XamLrcGetInput,                                             kFunction),
XE_EXPORT(xam,      0x000004C8, XamLrcGetInputWithSeek,                                     kFunction),
XE_EXPORT(xam,      0x000004C9, XamLrcSetMediaState,                                        kFunction),
XE_EXPORT(xam,      0x000004CA, XamPixSetDirtyCounters,                                     kFunction),
XE_EXPORT(xam,      0x000004CB, XamFitnessCreateFitnessEventEnumerator,                     kFunction),
XE_EXPORT(xam,      0x000004CC, XamFitnessInitialize,                                       kFunction),
XE_EXPORT(xam,      0x000004CD, XamRequestToken,                                            kFunction),
XE_EXPORT(xam,      0x000004CE, XamResolveURI,                                              kFunction),
XE_EXPORT(xam,      0x000004CF, XamContentGetOnlineCreator,                                 kFunction),
XE_EXPORT(xam,      0x000004D0, XamShowBrandedKeyboardUI,                                   kFunction),
XE_EXPORT(xam,      0x000004D1, XamBackgroundDownloadNetworkStorageEnable,                  kFunction),
XE_EXPORT(xam,      0x000004D2, XamBackgroundDownloadNetworkStorageIsEnabled,               kFunction),
XE_EXPORT(xam,      0x000004D3, XamShowNuiJoinSessionInProgressUI,                          kFunction),
XE_EXPORT(xam,      0x000004D4, XamBase64Decode,                                            kFunction),
XE_EXPORT(xam,      0x000004D5, XamCertDecode,                                              kFunction),
XE_EXPORT(xam,      0x000004D6, XamCertDecodeRsaPublicKey,                                  kFunction),
XE_EXPORT(xam,      0x000004D7, XamCertValidateStruct,                                      kFunction),
XE_EXPORT(xam,      0x000004D8, XamFitnessConvertByteMetToFloatMet,                         kFunction),
XE_EXPORT(xam,      0x000004D9, XamXgiBlobTrackerSetMockInfo,                               kFunction),
XE_EXPORT(xam,      0x000004DA, XamFitnessMsgTimeToSystemTime,                              kFunction),
XE_EXPORT(xam,      0x000004DB, XamFitnessSystemTimeToMsgTime,                              kFunction),
XE_EXPORT(xam,      0x000004DC, XamShowFitnessWarnAboutPrivacyUI,                           kFunction),
XE_EXPORT(xam,      0x000004DD, XamShowFitnessWarnAboutTimeUI,                              kFunction),
XE_EXPORT(xam,      0x000004DE, XamFitnessUnInitialize,                                     kFunction),
XE_EXPORT(xam,      0x000004DF, XamBackgroundDownloadNetworkStorageOnContentChange,         kFunction),
XE_EXPORT(xam,      0x000004E0, XamLiveBaseConfigureInMemoryMockResponse,                   kFunction),
XE_EXPORT(xam,      0x000004E1, InjectConnectionServerNotification,                         kFunction),
XE_EXPORT(xam,      0x000004E2, XamFitnessConvertFloatMetToByteMet,                         kFunction),
XE_EXPORT(xam,      0x000004E3, XamGetGamerTileKeyFromGamertag,                             kFunction),
XE_EXPORT(xam,      0x000004E4, XamBackgroundDownloadNetworkStorageRegisterChangeCallback,  kFunction),
XE_EXPORT(xam,      0x000004E5, XamFindOrCreateInternalPassportAccount,                     kFunction),
XE_EXPORT(xam,      0x000004E6, XOnlinepFriendsRequest,                                     kFunction),
XE_EXPORT(xam,      0x000004E7, XOnlinepFriendsAcceptRequest,                               kFunction),
XE_EXPORT(xam,      0x000004E8, XOnlinepFriendsRejectRequest,                               kFunction),
XE_EXPORT(xam,      0x000004E9, XOnlinepFriendsRemove,                                      kFunction),
XE_EXPORT(xam,      0x000004EA, XFriendsCreateEnumerator,                                   kFunction),
XE_EXPORT(xam,      0x000004EB, XamBackgroundDownloadNetworkStorageIsRunning,               kFunction),
XE_EXPORT(xam,      0x000004EC, XamCertGetSerialNumber,                                     kFunction),
XE_EXPORT(xam,      0x000004ED, XamShowOptionsUI,                                           kFunction),
XE_EXPORT(xam,      0x000004EE, XampXAuthGetTitleBuffer,                                    kFunction),
XE_EXPORT(xam,      0x000004EF, XamGetSTSTokenCache,                                        kFunction),
XE_EXPORT(xam,      0x000004F0, XamUserGetOnlineXUIDFromOfflineXUID,                        kFunction),
XE_EXPORT(xam,      0x000004F1, XamIsUserUsingMetricSystem,                                 kFunction),
XE_EXPORT(xam,      0x000004F2, XamShowNuiVideoRichPresenceUI,                              kFunction),
XE_EXPORT(xam,      0x000004F3, XamAppAllocateInterappWorkspaceEx,                          kFunction),
XE_EXPORT(xam,      0x000004F4, XampKioskSetTestMock,                                       kFunction),
XE_EXPORT(xam,      0x000004F5, XamNetworkStatusGetInformation,                             kFunction),
XE_EXPORT(xam,      0x000004F6, XamNetworkStatusAddAddress,                                 kFunction),
XE_EXPORT(xam,      0x000004F7, XamUserReadUserPreference,                                  kFunction),
XE_EXPORT(xam,      0x000004F8, XamUserWriteUserPreference,                                 kFunction),
XE_EXPORT(xam,      0x000004F9, XamShowFitnessClearUI,                                      kFunction),
XE_EXPORT(xam,      0x000004FA, XamFitnessClearAll,                                         kFunction),
XE_EXPORT(xam,      0x000004FB, XamFitnessGetPrivacySettings,                               kFunction),
XE_EXPORT(xam,      0x000004FC, XamWaitForNSAL,                                             kFunction),
XE_EXPORT(xam,      0x000004FD, XamMarkInternalAccountTrustedOnConsole,                     kFunction),
XE_EXPORT(xam,      0x000004FE, XamBackgroundDownloadNetworkStorageGetProgress,             kFunction),
XE_EXPORT(xam,      0x000004FF, XamCopyFile,                                                kFunction),
XE_EXPORT(xam,      0x00000500, XamMoveFile,                                                kFunction),
XE_EXPORT(xam,      0x00000501, XamDeleteFile,                                              kFunction),
XE_EXPORT(xam,      0x00000502, XamUserOverrideGlobalState,                                 kFunction),
XE_EXPORT(xam,      0x00000503, XamGetAdaptersCollection,                                   kFunction),
XE_EXPORT(xam,      0x00000504, XampKioskIsSimulationMode,                                  kFunction),
XE_EXPORT(xam,      0x00000505, XamIsUIThread,                                              kFunction),
XE_EXPORT(xam,      0x00000506, XamInputSendXenonButtonPress,                               kFunction),
XE_EXPORT(xam,      0x00000507, XamDebugGetURISchemeCount,                                  kFunction),
XE_EXPORT(xam,      0x00000508, XamDebugGetURISchemeInfo,                                   kFunction),
XE_EXPORT(xam,      0x00000509, XamGetOnlineCountryFromLocale,                              kFunction),
XE_EXPORT(xam,      0x0000050A, XTestOnlineIsConnectedToLive,                               kFunction),
XE_EXPORT(xam,      0x0000050B, XamGetConsoleFriendlyName,                                  kFunction),
XE_EXPORT(xam,      0x0000050C, XamSetConsoleFriendlyName,                                  kFunction),
XE_EXPORT(xam,      0x0000050D, XamGetCountry,                                              kFunction),
XE_EXPORT(xam,      0x0000050E, XamPackageManagerGetFilePathW,                              kFunction),
XE_EXPORT(xam,      0x0000050F, XamGetCurrentDemand,                                        kFunction),
XE_EXPORT(xam,      0x00000510, XamCompleteDemand,                                          kFunction),
XE_EXPORT(xam,      0x00000511, XamDemand,                                                  kFunction),
XE_EXPORT(xam,      0x00000512, XamFormatSystemDateString,                                  kFunction),
XE_EXPORT(xam,      0x00000513, XamDebugGetBackURI,                                         kFunction),
XE_EXPORT(xam,      0x00000514, XamIsCurrentTitleIptv,                                      kFunction),
XE_EXPORT(xam,      0x00000515, XamIsIptvEnabled,                                           kFunction),
XE_EXPORT(xam,      0x00000516, XamIsDvrRecording,                                          kFunction),
XE_EXPORT(xam,      0x00000517, XamIptvUninstall,                                           kFunction),
XE_EXPORT(xam,      0x00000518, XamGetDvrStorage,                                           kFunction),
XE_EXPORT(xam,      0x00000519, XamSetDvrStorage,                                           kFunction),
XE_EXPORT(xam,      0x0000051A, XamIptvGetServiceName,                                      kFunction),
XE_EXPORT(xam,      0x0000051B, XamNuiHudGetEngagedEnrollmentIndex,                         kFunction),
XE_EXPORT(xam,      0x0000051C, XamProfileSetCachedWindowsLiveEmail,                        kFunction),
XE_EXPORT(xam,      0x0000051D, XamProfileGetCachedWindowsLiveEmail,                        kFunction),
XE_EXPORT(xam,      0x0000051E, XamUserResetSubscriptionType,                               kFunction),
XE_EXPORT(xam,      0x0000051F, XamLrcSetTitlePort,                                         kFunction),
XE_EXPORT(xam,      0x00000520, XamLrcVerifyClientId,                                       kFunction),
XE_EXPORT(xam,      0x00000521, XamLrcEncryptDecryptTitleMessage,                           kFunction),
XE_EXPORT(xam,      0x00000522, XamFitnessGetSyncStatus,                                    kFunction),
XE_EXPORT(xam,      0x00000523, XamFitnessInitializeForOneUser,                             kFunction),
XE_EXPORT(xam,      0x00000524, XamFitnessGetSuggestedPrivacySettings,                      kFunction),
XE_EXPORT(xam,      0x00000525, XampFitnessLetFireAndForgetsCatchUpInternal,                kFunction),
XE_EXPORT(xam,      0x00000526, XamInputGetFailedConnectionOrBind,                          kFunction),
XE_EXPORT(xam,      0x00000527, XuiSceneIsInTransition,                                     kFunction),
XE_EXPORT(xam,      0x00000528, XamIsOnPrivateNetwork,                                      kFunction),
XE_EXPORT(xam,      0x00000529, XamInputSetMinMaxAuthDelay,                                 kFunction),
XE_EXPORT(xam,      0x0000052A, XamInputNonControllerGetRawEx,                              kFunction),
XE_EXPORT(xam,      0x0000052B, XamInputNonControllerSetRawEx,                              kFunction),
XE_EXPORT(xam,      0x0000052C, XamMarketplaceAcquireFreeContent,                           kFunction),
XE_EXPORT(xam,      0x0000052D, XamGetClosedCaptioningState,                                kFunction),
XE_EXPORT(xam,      0x0000052E, XamGetClosedCaptioningSettings,                             kFunction),
XE_EXPORT(xam,      0x0000052F, XamSetClosedCaptioningState,                                kFunction),
XE_EXPORT(xam,      0x00000530, XamLoaderGetLogonTitle,                                     kFunction),
XE_EXPORT(xam,      0x00000531, XamBeginDemand,                                             kFunction),
XE_EXPORT(xam,      0x00000532, XamGetErrorStringFromWebService,                            kFunction),
XE_EXPORT(xam,      0x00000533, XamGetModernPresenceWorkspaceSize,                          kFunction),
XE_EXPORT(xam,      0x00000534, XamGetModernPresence,                                       kFunction),
XE_EXPORT(xam,      0x00000535, XamGetSingleModernPresence,                                 kFunction),
XE_EXPORT(xam,      0x00000536, XamGetModernPresenceImageUrl,                               kFunction),
XE_EXPORT(xam,      0x00000537, XGetSSLCertBypassEnabled,                                   kFunction),
XE_EXPORT(xam,      0x00000538, XamIsNetworkCaptivePortal,                                  kFunction),
XE_EXPORT(xam,      0x00000539, XamShowAndWaitForMessageBoxEx,                              kFunction),
XE_EXPORT(xam,      0x0000053B, XamGetCurrencyFormat,                                       kFunction),
XE_EXPORT(xam,      0x0000053C, XamFormatCurrency,                                          kFunction),
XE_EXPORT(xam,      0x0000053D, XamReportTLSConnect,                                        kFunction),
XE_EXPORT(xam,      0x0000053E, XamGetXSTSTokenExpiryPeriodMS,                              kFunction),
XE_EXPORT(xam,      0x0000053F, XamGetUserBalance,                                          kFunction),
XE_EXPORT(xam,      0x00000540, XamIsGuideDisabled,                                         kFunction),
XE_EXPORT(xam,      0x00000541, XampCallXAccountTransitionStoredValuePointsToCurrency,      kFunction),
XE_EXPORT(xam,      0x00000542, XampSetMockCallXAccountTransitionStoredValuePointsToCurrency, kFunction),
XE_EXPORT(xam,      0x00000543, XamShowCsvTransitionUI,                                     kFunction),
XE_EXPORT(xam,      0x00000544, XamAskUserForCSVDrainagePermission,                         kFunction),
XE_EXPORT(xam,      0x00000545, XamIsCSVDrainageSupported,                                  kFunction),
XE_EXPORT(xam,      0x0000056C, XamGetTLSConfig,                                            kFunction),
XE_EXPORT(xam,      0x00000577, XamGetServiceEndpoint,                                      kFunction),
XE_EXPORT(xam,      0x00000578, XamReminderGetItems,                                        kFunction),
XE_EXPORT(xam,      0x00000579, XamReminderClearItems,                                      kFunction),
XE_EXPORT(xam,      0x0000057A, XamReminderItemAdd,                                         kFunction),
XE_EXPORT(xam,      0x0000057B, XamReminderItemRemove,                                      kFunction),
XE_EXPORT(xam,      0x0000057C, XamReminderGetNextItem,                                     kFunction),
XE_EXPORT(xam,      0x0000057D, XamReminderGetModifiedTime,                                 kFunction),
XE_EXPORT(xam,      0x0000057E, XamReminderClearCache,                                      kFunction),
XE_EXPORT(xam,      0x0000057F, XamLrcKeyboardGetInput,                                     kFunction),
XE_EXPORT(xam,      0x00000580, XamLrcKeyboardGetRequiredBufferSize,                        kFunction),
XE_EXPORT(xam,      0x00000581, XamLrcKeyboardRegister,                                     kFunction),
XE_EXPORT(xam,      0x00000582, XamLrcKeyboardUnregister,                                   kFunction),
XE_EXPORT(xam,      0x00000583, XamLrcKeyboardUpdateText,                                   kFunction),
XE_EXPORT(xam,      0x00000584, XamValidateCountry,                                         kFunction),
XE_EXPORT(xam,      0x00000585, XamGetOnlineCountryString,                                  kFunction),
XE_EXPORT(xam,      0x00000586, XamGetCountryString,                                        kFunction),
XE_EXPORT(xam,      0x00000587, XamGetLanguageString,                                       kFunction),
XE_EXPORT(xam,      0x00000588, XamGetLanguageLocaleString,                                 kFunction),
XE_EXPORT(xam,      0x00000589, XamGetOnlineLanguageAndCountryString,                       kFunction),
XE_EXPORT(xam,      0x0000058A, XamGetLanguageLocaleFallbackString,                         kFunction),
XE_EXPORT(xam,      0x0000058B, XamGetOnlineLanguageAndCountry,                             kFunction),
XE_EXPORT(xam,      0x0000058C, XamGetLanguageTypeface,                                     kFunction),
XE_EXPORT(xam,      0x0000058D, XamGetLanguageTypefacePatch,                                kFunction),
XE_EXPORT(xam,      0x0000058E, XamGetLocaleString,                                         kFunction),
XE_EXPORT(xam,      0x0000058F, XamGetLocaleFromOnlineCountry,                              kFunction),
XE_EXPORT(xam,      0x00000590, XamOfflineTimerSetData,                                     kFunction),
XE_EXPORT(xam,      0x00000591, XamOfflineTimerResume,                                      kFunction),
XE_EXPORT(xam,      0x00000592, XamOfflineTimerSuspend,                                     kFunction),
XE_EXPORT(xam,      0x00000593, XamOfflineTimerIsRunning,                                   kFunction),
XE_EXPORT(xam,      0x00000594, XamOfflineTimerIsEnabled,                                   kFunction),
XE_EXPORT(xam,      0x00000595, XamOfflineTimerGetTimeRemaining,                            kFunction),
XE_EXPORT(xam,      0x00000596, XamOfflineTimerGetContractData,                             kFunction),
XE_EXPORT(xam,      0x00000597, XamOfflineTimerInitialize,                                  kFunction),
XE_EXPORT(xam,      0x00000598, XamOfflineTimerGetData,                                     kFunction),
XE_EXPORT(xam,      0x00000599, XamPlayToRegister,                                          kFunction),
XE_EXPORT(xam,      0x0000059A, XamPlayToReportPlaybackState,                               kFunction),
XE_EXPORT(xam,      0x0000059B, XamPlayToUnregister,                                        kFunction),
XE_EXPORT(xam,      0x0000059C, XamShowTFAUI,                                               kFunction),
XE_EXPORT(xam,      0x0000059D, OnReconnect,                                                kFunction),
XE_EXPORT(xam,      0x0000059E, XamGetOnlineCountryFeatures,                                kFunction),
XE_EXPORT(xam,      0x0000059F, XamLogLocalizationEtx,                                      kFunction),
XE_EXPORT(xam,      0x000005A0, XampXAuthIsLocalSocketAllowed,                              kFunction),
XE_EXPORT(xam,      0x000005A1, XamPlayToGetRequest,                                        kFunction),
XE_EXPORT(xam,      0x000005A2, XamPlayToCancelGetRequest,                                  kFunction),
XE_EXPORT(xam,      0x000005A3, XamPlayToCompleteRequest,                                   kFunction),
XE_EXPORT(xam,      0x000005A4, XamFitnessGetTitleSummaries,                                kFunction),
XE_EXPORT(xam,      0x000005A5, XamFitnessGetTitleSummary,                                  kFunction),
XE_EXPORT(xam,      0x000005A6, XamOfflineTimerShutdown,                                    kFunction),
XE_EXPORT(xam,      0x000005A7, XamFitnessContainsFitnessData,                              kFunction),
XE_EXPORT(xam,      0x000005A8, XamGetLanguageFromOnlineLanguage,                           kFunction),
XE_EXPORT(xam,      0x000005A9, XamGetOnlineLanguageString,                                 kFunction),
XE_EXPORT(xam,      0x000005AA, XamGetCountryFromOnlineCountry,                             kFunction),
XE_EXPORT(xam,      0x000005D7, XamGetLocaleEx,                                             kFunction),
XE_EXPORT(xam,      0x000005D8, XamOfflineTimerForceQuery,                                  kFunction),
XE_EXPORT(xam,      0x000005D9, XamShowCreateProfileUIEx,                                   kFunction),
XE_EXPORT(xam,      0x000005DA, XTLGetLanguageV2,                                           kFunction),
XE_EXPORT(xam,      0x000005DB, XTLGetLocaleV1,                                             kFunction),
XE_EXPORT(xam,      0x000005DC, XamAvatarInitialize,                                        kFunction),
XE_EXPORT(xam,      0x000005DD, XamAvatarShutdown,                                          kFunction),
XE_EXPORT(xam,      0x000005DE, XamAvatarGetManifestLocalUser,                              kFunction),
XE_EXPORT(xam,      0x000005DF, XamAvatarGetManifestsByXuid,                                kFunction),
XE_EXPORT(xam,      0x000005E0, XamAvatarGetAssetsResultSize,                               kFunction),
XE_EXPORT(xam,      0x000005E1, XamAvatarGetAssets,                                         kFunction),
XE_EXPORT(xam,      0x000005E2, XamAvatarGenerateMipMaps,                                   kFunction),
XE_EXPORT(xam,      0x000005E3, XamAvatarSetCustomAsset,                                    kFunction),
XE_EXPORT(xam,      0x000005E4, XamAvatarSetManifest,                                       kFunction),
XE_EXPORT(xam,      0x000005E5, EnumerateMediaObjects,                                      kFunction),
XE_EXPORT(xam,      0x000005E6, EnumerateMediaObjects_,                                     kFunction),
XE_EXPORT(xam,      0x000005E7, XamAvatarLoadAnimation,                                     kFunction),
XE_EXPORT(xam,      0x000005E8, XamAvatarBeginEnumAssets,                                   kFunction),
XE_EXPORT(xam,      0x000005E9, XamAvatarEndEnumAssets,                                     kFunction),
XE_EXPORT(xam,      0x000005EA, XamAvatarEnumAssets,                                        kFunction),
XE_EXPORT(xam,      0x000005EB, XamAvatarGetMetadataRandom,                                 kFunction),
XE_EXPORT(xam,      0x000005EC, EnumerateMediaObjects_0,                                    kFunction),
XE_EXPORT(xam,      0x000005ED, EnumerateMediaObjects_1,                                    kFunction),
XE_EXPORT(xam,      0x000005EE, XamAvatarGetMetadataSignedOutProfileCount,                  kFunction),
XE_EXPORT(xam,      0x000005EF, XamAvatarGetMetadataSignedOutProfile,                       kFunction),
XE_EXPORT(xam,      0x000005F0, EnumerateMediaObjects_2,                                    kFunction),
XE_EXPORT(xam,      0x000005F1, XamAvatarManifestGetBodyType,                               kFunction),
XE_EXPORT(xam,      0x000005F2, XamAvatarGetInstrumentation,                                kFunction),
XE_EXPORT(xam,      0x000005F3, XamAvatarGetAssetIcon,                                      kFunction),
XE_EXPORT(xam,      0x000005F4, XamAvatarWearNow,                                           kFunction),
XE_EXPORT(xam,      0x000005F5, XamAvatarGetAssetBinary,                                    kFunction),
XE_EXPORT(xam,      0x000005F6, XamAvatarReinstallAwardedAsset,                             kFunction),
XE_EXPORT(xam,      0x000005F7, XamAvatarGetInstalledAssetPackageDescription,               kFunction),
XE_EXPORT(xam,      0x000005F8, XamAvatarSetMocks,                                          kFunction),
XE_EXPORT(xam,      0x000005F9, XamLrcKeyboardValidateTextChange,                           kFunction),
XE_EXPORT(xam,      0x000005FA, XamLrcKeyboardApplyTextChange,                              kFunction),
XE_EXPORT(xam,      0x000005FB, XamLrcLogSessionSummary,                                    kFunction),
XE_EXPORT(xam,      0x000005FC, XamLrcLogError,                                             kFunction),
XE_EXPORT(xam,      0x0000060E, XamContentMountInstalledGame,                               kFunction),
XE_EXPORT(xam,      0x0000060F, XamContentIsGameInstalledToHDD,                             kFunction),
XE_EXPORT(xam,      0x00000610, XamContentQueryLicenseInternal,                             kFunction),
XE_EXPORT(xam,      0x00000611, XamContentGetDeviceVolumePath,                              kFunction),
XE_EXPORT(xam,      0x00000612, XamContentDeviceCheckUpdates,                               kFunction),
XE_EXPORT(xam,      0x00000613, XamContentGetHeaderInternal,                                kFunction),
XE_EXPORT(xam,      0x00000614, XamNetworkStorageGetNetworkDevice,                          kFunction),
XE_EXPORT(xam,      0x00000615, XamNetworkStorageDeviceHasCacheFile,                        kFunction),
XE_EXPORT(xam,      0x00000616, XamNetworkStorageCreateCacheOnDevice,                       kFunction),
XE_EXPORT(xam,      0x00000617, XamNetworkStorageDeleteCacheOnDevice,                       kFunction),
XE_EXPORT(xam,      0x00000618, XamNetworkStorageGetStatus,                                 kFunction),
XE_EXPORT(xam,      0x00000619, XamNetworkStorageIsSupportedContentType,                    kFunction),
XE_EXPORT(xam,      0x0000061A, XamNetworkStorageSetTestMock,                               kFunction),
XE_EXPORT(xam,      0x0000061B, XamNetworkStorageGetLastSyncTime,                           kFunction),
XE_EXPORT(xam,      0x0000061C, XamShowNetworkStorageSyncUI,                                kFunction),
XE_EXPORT(xam,      0x0000061D, XamUserIsLogonPreviewModeEnabled,                           kFunction),
XE_EXPORT(xam,      0x0000061E, XamUserLockLogonPreviewMode,                                kFunction),
XE_EXPORT(xam,      0x0000061F, XamUserUnlockLogonPreviewMode,                              kFunction),
XE_EXPORT(xam,      0x00000620, XamNetworkStorageIsUserInSync,                              kFunction),
XE_EXPORT(xam,      0x00000621, XamNetworkStorageSetUserInSync,                             kFunction),
XE_EXPORT(xam,      0x00000622, XamNetworkStorageOnSigninChanged,                           kFunction),
XE_EXPORT(xam,      0x00000623, XamNetworkStorageSignInTestMock,                            kFunction),
XE_EXPORT(xam,      0x00000624, XamShowFofUI,                                               kFunction),
XE_EXPORT(xam,      0x00000625, CompareFileTime,                                            kFunction),
XE_EXPORT(xam,      0x00000626, SetFileTime,                                                kFunction),
XE_EXPORT(xam,      0x00000627, XamNetworkStorageGetTitleProperties,                        kFunction),
XE_EXPORT(xam,      0x00000628, XamNetworkStorageLockFile,                                  kFunction),
XE_EXPORT(xam,      0x00000629, XamNetworkStorageUserHasPrivilege,                          kFunction),
XE_EXPORT(xam,      0x0000062A, XamNetworkStorageIsTitleExempt,                             kFunction),
XE_EXPORT(xam,      0x0000062B, XamContentExistsOnDeviceInternal,                           kFunction),
XE_EXPORT(xam,      0x0000062C, XamNetworkStorageGetBackingDevice,                          kFunction),
XE_EXPORT(xam,      0x0000062D, XamNetworkStorageIsEnabledInLiveHive,                       kFunction),
XE_EXPORT(xam,      0x0000062E, XamNetworkStorageIsCheckingSyncStates,                      kFunction),
XE_EXPORT(xam,      0x0000062F, XamNetworkStorageUserNeedsToSync,                           kFunction),
XE_EXPORT(xam,      0x00000630, XamNetworkStorageGetUserNetworkSyncTime,                    kFunction),
XE_EXPORT(xam,      0x00000631, XamNetworkStorageGetUserProperties,                         kFunction),
XE_EXPORT(xam,      0x00000632, XamNetworkStorageAppLauncherLaunchIfRunning,                kFunction),
XE_EXPORT(xam,      0x00000633, XamNetworkStorageSetTitleProperties,                        kFunction),
XE_EXPORT(xam,      0x00000634, XamNetworkStorageGetUserLastError,                          kFunction),
XE_EXPORT(xam,      0x00000635, XamNetworkStorageCheckOutTitle,                             kFunction),
XE_EXPORT(xam,      0x00000636, XamNetworkStorageShouldHideFromTitle,                       kFunction),
XE_EXPORT(xam,      0x00000637, XamNetworkStorageOnUserSyncChange,                          kFunction),
XE_EXPORT(xam,      0x00000638, XamNetworkStorageHasUserEnabledStorage,                     kFunction),
XE_EXPORT(xam,      0x00000639, XamContentGetLocalizedDeviceData,                           kFunction),
XE_EXPORT(xam,      0x00000640, XamPackageManagerFindPackageContainingIndexedXEX,           kFunction),
XE_EXPORT(xam,      0x00000641, XamPackageManagerReinitialize,                              kFunction),
XE_EXPORT(xam,      0x00000642, XamPackageManagerGetAuthoritativeManifestVersion,           kFunction),
XE_EXPORT(xam,      0x00000643, XamGetCurrentSystemOnlineManifestRevision,                  kFunction),
XE_EXPORT(xam,      0x00000644, XamPackageManagerDeleteExtendedPartition,                   kFunction),
XE_EXPORT(xam,      0x00000645, XamPackageManagerHasExtendedPartition,                      kFunction),
XE_EXPORT(xam,      0x00000646, XamPackageManagerGetExperienceMode,                         kFunction),
XE_EXPORT(xam,      0x00000647, XamPackageManagerGetFeatureRequiresUpdateStrings,           kFunction),
XE_EXPORT(xam,      0x00000648, XamPackageManagerGetFileSize,                               kFunction),
XE_EXPORT(xam,      0x00000649, XampDemandUpdateGetAttributes,                              kFunction),
XE_EXPORT(xam,      0x0000064A, XampDemandUpdateGetExtendedAttributes,                      kFunction),
XE_EXPORT(xam,      0x0000064B, XampDemandUpdateGetInstance,                                kFunction),
XE_EXPORT(xam,      0x0000064C, XampDemandUpdateSetRefreshTestFlags,                        kFunction),
XE_EXPORT(xam,      0x0000064D, XampDemandUpdateIsRefreshTestFlagSet,                       kFunction),
XE_EXPORT(xam,      0x0000064E, XampDemandUpdateGetManifestLocalPath,                       kFunction),
XE_EXPORT(xam,      0x0000064F, XampDemandUpdateRefreshManifest,                            kFunction),
XE_EXPORT(xam,      0x00000650, XdfInitialize,                                              kFunction),
XE_EXPORT(xam,      0x00000651, XdfShutdown,                                                kFunction),
XE_EXPORT(xam,      0x00000652, XdfGetExpectedDownloadSize,                                 kFunction),
XE_EXPORT(xam,      0x00000653, XdfGetItem,                                                 kFunction),
XE_EXPORT(xam,      0x00000654, XdfCacheItem,                                               kFunction),
XE_EXPORT(xam,      0x00000655, XdfLoadXexFromCache,                                        kFunction),
XE_EXPORT(xam,      0x00000656, XdfLoadXex,                                                 kFunction),
XE_EXPORT(xam,      0x00000657, XdfCancelRequest,                                           kFunction),
XE_EXPORT(xam,      0x00000658, XdfResumeDelayedItem,                                       kFunction),
XE_EXPORT(xam,      0x00000659, XdfLaunchNewImageFromCache,                                 kFunction),
XE_EXPORT(xam,      0x0000065A, XampDemandUpdateRefreshManifestDuringLogon,                 kFunction),
XE_EXPORT(xam,      0x0000065B, XampDemandUpdateCheckOnlineManifestChanged,                 kFunction),
XE_EXPORT(xam,      0x0000065C, XampDemandUpdateRunCacheCleaner,                            kFunction),
XE_EXPORT(xam,      0x00000685, XamUpdateGetTitleUpdateSizeThreshold,                       kFunction),
XE_EXPORT(xam,      0x00000686, XamXStudioRequest,                                          kFunction),
XE_EXPORT(xam,      0x00000687, XamNotifyDelayUIInternal,                                   kFunction),
XE_EXPORT(xam,      0x000006A4, XamShowAvatarMiniCreatorUI,                                 kFunction),
XE_EXPORT(xam,      0x000006A5, XamShowGoldUpgradeUI,                                       kFunction),
XE_EXPORT(xam,      0x000006A6, XamResumeUpdaterUI,                                         kFunction),
XE_EXPORT(xam,      0x000006A7, XamShowDirectAcquireUI,                                     kFunction),
XE_EXPORT(xam,      0x000006A8, XamShowPaymentOptionsUI,                                    kFunction),
XE_EXPORT(xam,      0x000006A9, XamShowMultiplayerUpgradeUI,                                kFunction),
XE_EXPORT(xam,      0x00000708, XamGetLiveHiveValueA,                                       kFunction),
XE_EXPORT(xam,      0x00000709, XamGetLiveHiveValueW,                                       kFunction),
XE_EXPORT(xam,      0x0000070A, XamGetLiveHiveValueDuringLogonAttemptA,                     kFunction),
XE_EXPORT(xam,      0x0000070B, XamSetUserPresetWindowsLiveCreds,                           kFunction),
XE_EXPORT(xam,      0x0000070C, XamQueryLiveHiveA,                                          kFunction),
XE_EXPORT(xam,      0x0000070D, XamQueryLiveHiveW,                                          kFunction),
XE_EXPORT(xam,      0x0000070E, XamGetLiveHiveValueDuringLogonAttemptExA,                   kFunction),
XE_EXPORT(xam,      0x0000070F, XamGetUserPresetWindowsLiveCreds,                           kFunction),
XE_EXPORT(xam,      0x00000710, XamGetUserNeedTFA,                                          kFunction),
XE_EXPORT(xam,      0x00000711, XamSetUserNeedTFA,                                          kFunction),
XE_EXPORT(xam,      0x00000712, XamGetUserInMemoryWindowsLiveCreds,                         kFunction),
XE_EXPORT(xam,      0x0000076C, XamDownloadMarketplaceStoresList,                           kFunction),
XE_EXPORT(xam,      0x0000076D, XamGetStoreFront,                                           kFunction),
XE_EXPORT(xam,      0x0000076E, XamSetStagingMode,                                          kFunction),
XE_EXPORT(xam,      0x0000076F, XamGetStagingMode,                                          kFunction),
XE_EXPORT(xam,      0x00000770, XamAppGetSessionId,                                         kFunction),
XE_EXPORT(xam,      0x00000771, XamAccountRecoveryRecoverAllProfileData,                    kFunction),
XE_EXPORT(xam,      0x00000772, XamAccountRecoveryGetProgress,                              kFunction),
XE_EXPORT(xam,      0x000007D0, XamDoesOmniNeedConfiguration,                               kFunction),
XE_EXPORT(xam,      0x000007D1, XamFirstRunExperienceShouldRun,                             kFunction),
XE_EXPORT(xam,      0x000007D2, GetProcessHeap,                                             kFunction),
XE_EXPORT(xam,      0x000007D3, UnhandledExceptionFilter,                                   kFunction),
XE_EXPORT(xam,      0x000007D4, SetUnhandledExceptionFilter,                                kFunction),
XE_EXPORT(xam,      0x000007D5, XamIsOptionalMediaUpdateInstalled,                          kFunction),
XE_EXPORT(xam,      0x000007D6, XamShowOptionalMediaUpdateRequiredUI,                       kFunction),
XE_EXPORT(xam,      0x000007D7, XamShowOptionalMediaUpdateRequiredUIEx,                     kFunction),
XE_EXPORT(xam,      0x000007D8, XamShowFirstRunWelcomeUI,                                   kFunction),
XE_EXPORT(xam,      0x000007D9, XamTaskCreateQueueEx,                                       kFunction),
XE_EXPORT(xam,      0x000007DA, XamSetDashBackstackData,                                    kFunction),
XE_EXPORT(xam,      0x000007DB, XamLaunchAvatarEditor,                                      kFunction),
XE_EXPORT(xam,      0x000007DC, XamGetDashBackstackData,                                    kFunction),
XE_EXPORT(xam,      0x000007DD, XamGetDashBackstackNodesCount,                              kFunction),
XE_EXPORT(xam,      0x000007DE, XamSetLastActiveUserData,                                   kFunction),
XE_EXPORT(xam,      0x000007DF, XamGetLastActiveUserData,                                   kFunction),
XE_EXPORT(xam,      0x000007E0, XamSetActiveDashAppInfo,                                    kFunction),
XE_EXPORT(xam,      0x000007E1, XamGetActiveDashAppInfo,                                    kFunction),
XE_EXPORT(xam,      0x000007E2, XamLoaderRegisterLaunchRequestCallback,                     kFunction),
XE_EXPORT(xam,      0x000007E3, XamLoadExtraAVCodecs2,                                      kFunction),
XE_EXPORT(xam,      0x000007E4, XamUnloadExtraAVCodecs2,                                    kFunction),
XE_EXPORT(xam,      0x00000802, XamUserCreateAvatarAssetEnumerator,                         kFunction),
XE_EXPORT(xam,      0x00000803, XamInitializeGameTileCache,                                 kFunction),
XE_EXPORT(xam,      0x00000804, XamDestroyGameTileCache,                                    kFunction),
XE_EXPORT(xam,      0x00000805, XamReadGameTileImage,                                       kFunction),
XE_EXPORT(xam,      0x00000806, XamShouldThrottleAccountInfoCall,                           kFunction),
XE_EXPORT(xam,      0x00000807, XuiClassDerivesFrom,                                        kFunction),
XE_EXPORT(xam,      0x00000808, XuiFreeVisuals,                                             kFunction),
XE_EXPORT(xam,      0x00000809, XuiGetBaseClass,                                            kFunction),
XE_EXPORT(xam,      0x0000080A, XuiLoadVisualFromBinary,                                    kFunction),
XE_EXPORT(xam,      0x0000080B, XuiResourceGetBuffer,                                       kFunction),
XE_EXPORT(xam,      0x0000080C, XuiResourceGetTotalSize,                                    kFunction),
XE_EXPORT(xam,      0x0000080D, XuiElementGetUserData,                                      kFunction),
XE_EXPORT(xam,      0x0000080E, XuiElementSetUserData,                                      kFunction),
XE_EXPORT(xam,      0x0000080F, XuiTabSceneGetCount,                                        kFunction),
XE_EXPORT(xam,      0x00000810, XuiSliderGetStep,                                           kFunction),
XE_EXPORT(xam,      0x00000811, XuiSliderSetStep,                                           kFunction),
XE_EXPORT(xam,      0x00000812, XuiProgressBarGetRange,                                     kFunction),
XE_EXPORT(xam,      0x00000813, XuiElementSetHittable,                                      kFunction),
XE_EXPORT(xam,      0x00000814, XuiElementPlayNamedFrames,                                  kFunction),
XE_EXPORT(xam,      0x00000815, XuiElementGetPivot,                                         kFunction),
XE_EXPORT(xam,      0x00000816, XuiElementGetPrev,                                          kFunction),
XE_EXPORT(xam,      0x00000817, XuiElementGetScale,                                         kFunction),
XE_EXPORT(xam,      0x00000818, XuiElementSetPivot,                                         kFunction),
XE_EXPORT(xam,      0x00000819, XuiElementSetRotation,                                      kFunction),
XE_EXPORT(xam,      0x0000081A, XuiElementSetScale,                                         kFunction),
XE_EXPORT(xam,      0x0000081B, XuiControlWantsUnfocusedInput,                              kFunction),
XE_EXPORT(xam,      0x0000081C, XuiResourceOpenNoLoc,                                       kFunction),
XE_EXPORT(xam,      0x0000081D, XuiResourceReleasePackage,                                  kFunction),
XE_EXPORT(xam,      0x0000081E, XuiResourceGetPackageEntryInfo,                             kFunction),
XE_EXPORT(xam,      0x0000081F, XuiResourceGetPackageEntryCount,                            kFunction),
XE_EXPORT(xam,      0x00000820, XuiResourceOpenPackage,                                     kFunction),
XE_EXPORT(xam,      0x00000821, XamCodeCoverageFileOpen,                                    kFunction),
XE_EXPORT(xam,      0x00000822, XamCodeCoverageFileClose,                                   kFunction),
XE_EXPORT(xam,      0x00000823, XamCodeCoverageFileLseek,                                   kFunction),
XE_EXPORT(xam,      0x00000824, XamCodeCoverageFileRead,                                    kFunction),
XE_EXPORT(xam,      0x00000825, XamCodeCoverageFileWrite,                                   kFunction),
XE_EXPORT(xam,      0x00000826, Refresh_1,                                                  kFunction),
XE_EXPORT(xam,      0x00000827, XampHeapGetInfo,                                            kFunction),
XE_EXPORT(xam,      0x00000828, XampHeapGetCount,                                           kFunction),
XE_EXPORT(xam,      0x00000829, XamShowPamUI,                                               kFunction),
XE_EXPORT(xam,      0x0000082A, XuiElementLayoutTree,                                       kFunction),
XE_EXPORT(xam,      0x0000082B, XamRegisterScreenSaverCallback,                             kFunction),
XE_EXPORT(xam,      0x0000082C, XUIElementPropVal_SetInt,                                   kFunction),
XE_EXPORT(xam,      0x0000082D, XUIElementPropVal_SetFloat,                                 kFunction),
XE_EXPORT(xam,      0x0000082E, XuiObjectGetPropertyDef,                                    kFunction),
XE_EXPORT(xam,      0x0000082F, XuiRenderGetDevice,                                         kFunction),
XE_EXPORT(xam,      0x00000830, XuiRenderRestoreState,                                      kFunction),
XE_EXPORT(xam,      0x00000831, XuiElementGetFullXForm,                                     kFunction),
XE_EXPORT(xam,      0x00000832, XuiRenderGetViewTransform,                                  kFunction),
XE_EXPORT(xam,      0x00000833, XuiRenderGetColorSpace,                                     kFunction),
XE_EXPORT(xam,      0x00000834, XamPngEncode,                                               kFunction),
XE_EXPORT(xam,      0x00000835, XamPngDecode,                                               kFunction),
XE_EXPORT(xam,      0x00000836, XamPngEncodeEx,                                             kFunction),
XE_EXPORT(xam,      0x00000837, XuiTextElementMeasureText,                                  kFunction),
XE_EXPORT(xam,      0x00000838, XamLoaderShouldConfirmReboot,                               kFunction),
XE_EXPORT(xam,      0x00000839, XamLoaderRebootToDash,                                      kFunction),
XE_EXPORT(xam,      0x0000083A, XamNuiHudGetEngagedTrackingID,                              kFunction),
XE_EXPORT(xam,      0x0000083B, XamLoaderLaunchTitleForReason,                              kFunction),
XE_EXPORT(xam,      0x0000083C, XamNuiHudSetEngagedTrackingID,                              kFunction),
XE_EXPORT(xam,      0x0000083D, XuiBrushGetTexture,                                         kFunction),
XE_EXPORT(xam,      0x0000083E, XamSetupTexture,                                            kFunction),
XE_EXPORT(xam,      0x0000083F, XuiElementGetDescendantById,                                kFunction),
XE_EXPORT(xam,      0x00000840, XamLoaderIsKinectUIPreferredForLogonTitle,                  kFunction),
XE_EXPORT(xam,      0x00000841, XamSetupCameraPreviewStuff,                                 kFunction),
XE_EXPORT(xam,      0x00000842, XamReleaseCameraPreviewStuff,                               kFunction),
XE_EXPORT(xam,      0x00000843, XamRenderCameraPreviewStuff,                                kFunction),
XE_EXPORT(xam,      0x00000848, XamAccountRecoveryGetSetTitleSyncTime,                      kFunction),
XE_EXPORT(xam,      0x00000849, XamReadBiometricData,                                       kFunction),
XE_EXPORT(xam,      0x0000084A, XamWriteBiometricData,                                      kFunction),
XE_EXPORT(xam,      0x0000084B, XamD3DResourceDescriptorCreate,                             kFunction),
XE_EXPORT(xam,      0x0000084C, XamD3DResourceDescriptorAddRef,                             kFunction),
XE_EXPORT(xam,      0x0000084D, XamD3DResourceDescriptorRelease,                            kFunction),
XE_EXPORT(xam,      0x0000084E, XamD3DResourceAddRef,                                       kFunction),
XE_EXPORT(xam,      0x0000084F, XamD3DResourceSet,                                          kFunction),
XE_EXPORT(xam,      0x00000850, XamD3DResourceIsBusy,                                       kFunction),
XE_EXPORT(xam,      0x00000851, XamD3DResourceRelease,                                      kFunction),
XE_EXPORT(xam,      0x00000852, ControlPackGetCursorPosition,                               kFunction),
XE_EXPORT(xam,      0x00000853, ControlPackShouldShowCursor,                                kFunction),
XE_EXPORT(xam,      0x00000858, XamFlushAgraTemperatureReport,                              kFunction),
XE_EXPORT(xam,      0x00000859, XamNatalDeviceAudioCalibrate,                               kFunction),
XE_EXPORT(xam,      0x0000085A, XamNuiIdentityGetEnrollmentInfo,                            kFunction),
XE_EXPORT(xam,      0x0000085B, XamNuiIdentityUnenroll,                                     kFunction),
XE_EXPORT(xam,      0x0000085C, XamNuiIdentityGetColorTexture,                              kFunction),
XE_EXPORT(xam,      0x0000085D, XamReportKinectSettingsChangedEvent,                        kFunction),
XE_EXPORT(xam,      0x0000085E, XamNuiEnableChatMic,                                        kFunction),
XE_EXPORT(xam,      0x0000085F, XamNuiIsChatMicEnabled,                                     kFunction),
XE_EXPORT(xam,      0x00000860, XamNuiGetDepthCalibration,                                  kFunction),
XE_EXPORT(xam,      0x00000861, XamNuiStoreDepthCalibration,                                kFunction),
XE_EXPORT(xam,      0x00000862, XamUserNuiIsBiometricEnabled,                               kFunction),
XE_EXPORT(xam,      0x00000863, XamUserNuiEnableBiometric,                                  kFunction),
XE_EXPORT(xam,      0x00000864, XamNuiCameraSetFlags,                                       kFunction),
XE_EXPORT(xam,      0x00000865, XamNuiCameraRememberFloor,                                  kFunction),
XE_EXPORT(xam,      0x00000866, XamUserNuiGetUserIndexForBind,                              kFunction),
XE_EXPORT(xam,      0x00000867, XamUserNuiGetUserIndexForSignin,                            kFunction),
XE_EXPORT(xam,      0x00000868, XamUserNuiBind,                                             kFunction),
XE_EXPORT(xam,      0x00000869, XamUserNuiGetUserIndex,                                     kFunction),
XE_EXPORT(xam,      0x0000086A, XamUserNuiGetEnrollmentIndex,                               kFunction),
XE_EXPORT(xam,      0x0000086B, XamUserNuiUnbind,                                           kFunction),
XE_EXPORT(xam,      0x0000086C, XamNuiIdentityGetQualityFlagsMessage,                       kFunction),
XE_EXPORT(xam,      0x0000086D, XamNuiCameraTiltSetCallback,                                kFunction),
XE_EXPORT(xam,      0x0000086E, XamNuiHudIsEnabled,                                         kFunction),
XE_EXPORT(xam,      0x0000086F, XamNuiCameraGetTiltControllerType,                          kFunction),
XE_EXPORT(xam,      0x00000870, XamNuiCameraTiltGetStatus,                                  kFunction),
XE_EXPORT(xam,      0x00000871, XamNuiIdentityGetQualityFlags,                              kFunction),
XE_EXPORT(xam,      0x00000872, XamNuiIdentityEnrollForSignIn,                              kFunction),
XE_EXPORT(xam,      0x00000873, XamNuiIdentityGetSessionId,                                 kFunction),
XE_EXPORT(xam,      0x00000874, XamNuiIdentityIdentifyWithBiometric,                        kFunction),
XE_EXPORT(xam,      0x00000875, ControlPackGetHandleManager,                                kFunction),
XE_EXPORT(xam,      0x00000876, XamEnableNuiAutomation,                                     kFunction),
XE_EXPORT(xam,      0x00000877, XamNuiGetSystemGestureControl,                              kFunction),
XE_EXPORT(xam,      0x00000878, XamGetPasscodeKeyFromVirtualKey,                            kFunction),
XE_EXPORT(xam,      0x00000879, XamEnableNatalPlayback,                                     kFunction),
XE_EXPORT(xam,      0x0000087A, XamIsNuiAutomationEnabled,                                  kFunction),
XE_EXPORT(xam,      0x0000087B, XamIsNatalPlaybackEnabled,                                  kFunction),
XE_EXPORT(xam,      0x0000087C, XamNuiHudInterpretFrame,                                    kFunction),
XE_EXPORT(xam,      0x0000087D, XamNuiHudEnableInputFilter,                                 kFunction),
XE_EXPORT(xam,      0x0000087E, ControlpackNuiCursorSetTrackingId,                          kFunction),
XE_EXPORT(xam,      0x0000087F, XamNuiHudGetInitializeFlags,                                kFunction),
XE_EXPORT(xam,      0x00000880, XamNuiCameraElevationSetAngle,                              kFunction),
XE_EXPORT(xam,      0x00000881, XamNuiCameraElevationGetAngle,                              kFunction),
XE_EXPORT(xam,      0x00000882, XamNuiCameraElevationAutoTilt,                              kFunction),
XE_EXPORT(xam,      0x00000883, XamNuiCameraElevationStopMovement,                          kFunction),
XE_EXPORT(xam,      0x00000884, XamNuiCameraElevationSetCallback,                           kFunction),
XE_EXPORT(xam,      0x00000885, XamNuiGetDeviceStatus,                                      kFunction),
XE_EXPORT(xam,      0x00000886, XamNuiNatalCameraUpdateStarting,                            kFunction),
XE_EXPORT(xam,      0x00000887, XamNuiNatalCameraUpdateComplete,                            kFunction),
XE_EXPORT(xam,      0x00000888, XamNuiHudGetVersions,                                       kFunction),
XE_EXPORT(xam,      0x00000889, XamGetHUDElementByPath,                                     kFunction),
XE_EXPORT(xam,      0x0000088A, XamGetHUDElementByAutoId,                                   kFunction),
XE_EXPORT(xam,      0x0000088B, XuiElementGetScreenPositionCenter,                          kFunction),
XE_EXPORT(xam,      0x0000088C, XamNuiCameraElevationReverseAutoTilt,                       kFunction),
XE_EXPORT(xam,      0x0000088D, ControlPackSimpleCursorGetRayFromScreenPosition,            kFunction),
XE_EXPORT(xam,      0x0000088E, ControlPackSideNavControlGetNuiHandle,                      kFunction),
XE_EXPORT(xam,      0x0000088F, XamFindHUDElementByXuiId,                                   kFunction),
XE_EXPORT(xam,      0x00000890, XamNuiIsDeviceReady,                                        kFunction),
XE_EXPORT(xam,      0x00000891, XamNuiSetForceDeviceOff,                                    kFunction),
XE_EXPORT(xam,      0x00000892, XamNuiPlayerEngagementUpdate,                               kFunction),
XE_EXPORT(xam,      0x00000893, XamNuiSkeletonGetBestSkeletonIndex,                         kFunction),
XE_EXPORT(xam,      0x00000894, XamNuiSkeletonScoreUpdate,                                  kFunction),
XE_EXPORT(xam,      0x00000895, XamNuiCameraTiltReportStatus,                               kFunction),
XE_EXPORT(xam,      0x00000896, XamNuiCameraAdjustTilt,                                     kFunction),
XE_EXPORT(xam,      0x00000897, XamNuiIdentityAbort,                                        kFunction),
XE_EXPORT(xam,      0x00000898, D3DDevice_CreateVertexShader,                               kFunction),
XE_EXPORT(xam,      0x00000899, D3DDevice_CreatePixelShader,                                kFunction),
XE_EXPORT(xam,      0x0000089A, D3DDevice_CreateTexture,                                    kFunction),
XE_EXPORT(xam,      0x0000089B, D3DDevice_CreateVertexBuffer,                               kFunction),
XE_EXPORT(xam,      0x0000089C, D3DDevice_CreateIndexBuffer,                                kFunction),
XE_EXPORT(xam,      0x0000089D, D3DDevice_CreateVertexDeclaration,                          kFunction),
XE_EXPORT(xam,      0x0000089E, D3DVertexBuffer_Unlock,                                     kFunction),
XE_EXPORT(xam,      0x0000089F, D3DVertexBuffer_Lock,                                       kFunction),
XE_EXPORT(xam,      0x000008A0, D3DIndexBuffer_Unlock,                                      kFunction),
XE_EXPORT(xam,      0x000008A1, D3DIndexBuffer_Lock,                                        kFunction),
XE_EXPORT(xam,      0x000008A2, D3DTexture_UnlockRect,                                      kFunction),
XE_EXPORT(xam,      0x000008A3, D3DTexture_LockRect,                                        kFunction),
XE_EXPORT(xam,      0x000008A4, D3DDevice_Clear,                                            kFunction),
XE_EXPORT(xam,      0x000008A5, D3DDevice_SetViewport,                                      kFunction),
XE_EXPORT(xam,      0x000008A6, D3DDevice_GetViewport,                                      kFunction),
XE_EXPORT(xam,      0x000008A7, D3DVertexShader_Release,                                    kFunction),
XE_EXPORT(xam,      0x000008A8, D3DPixelShader_Release,                                     kFunction),
XE_EXPORT(xam,      0x000008A9, D3DVertexDeclaration_Release,                               kFunction),
XE_EXPORT(xam,      0x000008AA, D3DResource_Release,                                        kFunction),
XE_EXPORT(xam,      0x000008AB, D3DDevice_Release,                                          kFunction),
XE_EXPORT(xam,      0x000008AC, D3DDevice_SetVertexShader,                                  kFunction),
XE_EXPORT(xam,      0x000008AD, D3DDevice_SetPixelShader,                                   kFunction),
XE_EXPORT(xam,      0x000008AE, D3DDevice_SetTexture,                                       kFunction),
XE_EXPORT(xam,      0x000008AF, D3DDevice_SetVertexDeclaration,                             kFunction),
XE_EXPORT(xam,      0x000008B0, D3DDevice_SetIndices,                                       kFunction),
XE_EXPORT(xam,      0x000008B1, D3DDevice_SetStreamSource,                                  kFunction),
XE_EXPORT(xam,      0x000008B2, D3DDevice_DrawVertices,                                     kFunction),
XE_EXPORT(xam,      0x000008B3, D3DDevice_DrawVerticesUP,                                   kFunction),
XE_EXPORT(xam,      0x000008B4, D3DDevice_DrawIndexedVertices,                              kFunction),
XE_EXPORT(xam,      0x000008B5, D3DDevice_DrawIndexedVerticesUP,                            kFunction),
XE_EXPORT(xam,      0x000008B6, D3DDevice_SetVertexShaderConstantF_ParameterCheck,          kFunction),
XE_EXPORT(xam,      0x000008B7, D3DDevice_SetPixelShaderConstantF_ParameterCheck,           kFunction),
XE_EXPORT(xam,      0x000008B8, D3DDevice_SetSamplerState_ParameterCheck,                   kFunction),
XE_EXPORT(xam,      0x000008B9, D3DDevice_SetRenderState_ParameterCheck,                    kFunction),
XE_EXPORT(xam,      0x000008BA, D3DDevice_GetRenderState_ParameterCheck,                    kFunction),
XE_EXPORT(xam,      0x000008BB, D3DDevice_SetVertexShaderConstantFN,                        kFunction),
XE_EXPORT(xam,      0x000008BC, D3DDevice_SetPixelShaderConstantFN,                         kFunction),
XE_EXPORT(xam,      0x000008BD, D3DDevice_GetRenderState_ZEnable,                           kFunction),
XE_EXPORT(xam,      0x000008BE, D3DDevice_GetRenderState_CullMode,                          kFunction),
XE_EXPORT(xam,      0x000008BF, D3DDevice_GetRenderState_AlphaBlendEnable,                  kFunction),
XE_EXPORT(xam,      0x000008C0, D3DDevice_GetRenderState_SrcBlendAlpha,                     kFunction),
XE_EXPORT(xam,      0x000008C1, D3DDevice_GetRenderState_DestBlendAlpha,                    kFunction),
XE_EXPORT(xam,      0x000008C2, D3DDevice_GetRenderState_BlendOp,                           kFunction),
XE_EXPORT(xam,      0x000008C3, D3DDevice_GetRenderState_ViewportEnable,                    kFunction),
XE_EXPORT(xam,      0x000008C4, D3DDevice_SetRenderState_ZEnable,                           kFunction),
XE_EXPORT(xam,      0x000008C5, D3DDevice_SetRenderState_CullMode,                          kFunction),
XE_EXPORT(xam,      0x000008C6, D3DDevice_SetRenderState_AlphaBlendEnable,                  kFunction),
XE_EXPORT(xam,      0x000008C7, D3DDevice_SetRenderState_SrcBlendAlpha,                     kFunction),
XE_EXPORT(xam,      0x000008C8, D3DDevice_SetRenderState_DestBlendAlpha,                    kFunction),
XE_EXPORT(xam,      0x000008C9, D3DDevice_SetRenderState_BlendOp,                           kFunction),
XE_EXPORT(xam,      0x000008CA, D3DDevice_SetRenderState_ViewportEnable,                    kFunction),
XE_EXPORT(xam,      0x000008CB, D3DDevice_SetSamplerState_MagFilter,                        kFunction),
XE_EXPORT(xam,      0x000008CC, D3DDevice_SetSamplerState_MinFilter,                        kFunction),
XE_EXPORT(xam,      0x000008CD, D3DDevice_SetSamplerState_AddressU,                         kFunction),
XE_EXPORT(xam,      0x000008CE, D3DDevice_SetSamplerState_AddressV,                         kFunction),
XE_EXPORT(xam,      0x000008CF, XGSetTextureHeader,                                         kFunction),
XE_EXPORT(xam,      0x000008D0, XGGetTextureDesc,                                           kFunction),
XE_EXPORT(xam,      0x000008D1, XGOffsetResourceAddress,                                    kFunction),
XE_EXPORT(xam,      0x000008D2, D3DResource_AddRef,                                         kFunction),
XE_EXPORT(xam,      0x000008D3, D3DVertexShader_AddRef,                                     kFunction),
XE_EXPORT(xam,      0x000008D4, D3DPixelShader_AddRef,                                      kFunction),
XE_EXPORT(xam,      0x000008D5, D3DVertexDeclaration_AddRef,                                kFunction),
XE_EXPORT(xam,      0x000008D6, XGSetTextureHeaderEx,                                       kFunction),
XE_EXPORT(xam,      0x000008D7, D3DDevice_GetRenderTarget,                                  kFunction),
XE_EXPORT(xam,      0x000008D8, D3DDevice_SetRenderTarget,                                  kFunction),
XE_EXPORT(xam,      0x000008D9, D3DDevice_GetDepthStencilSurface,                           kFunction),
XE_EXPORT(xam,      0x000008DA, D3DDevice_SetDepthStencilSurface,                           kFunction),
XE_EXPORT(xam,      0x000008DB, D3DDevice_Resolve,                                          kFunction),
XE_EXPORT(xam,      0x000008DC, D3DDevice_SetPixelShaderConstantB,                          kFunction),
XE_EXPORT(xam,      0x000008DD, XamNuiGetDeviceSerialNumber,                                kFunction),
XE_EXPORT(xam,      0x000008DE, XamNuiGetLoadedDepthCalibration,                            kFunction),
XE_EXPORT(xam,      0x000008DF, XamNuiGetTrueColorInfo,                                     kFunction),
XE_EXPORT(xam,      0x000008E0, XamNuiGetCameraIntrinsics,                                  kFunction),
XE_EXPORT(xam,      0x000008E1, XamNuiGetFanRate,                                           kFunction),
XE_EXPORT(xam,      0x000008E2, XamNuiGetSupportString,                                     kFunction),
XE_EXPORT(xam,      0x000008E3, XamKinectGetHardwareType,                                   kFunction),
XE_EXPORT(xam,      0x000008FC, XamXtwManagerGetVariableCount,                              kFunction),
XE_EXPORT(xam,      0x000008FD, XamXtwManagerGetId,                                         kFunction),
XE_EXPORT(xam,      0x000008FE, XamXtwManagerGetValue,                                      kFunction),
XE_EXPORT(xam,      0x000008FF, XamXtwManagerSetValue,                                      kFunction),
XE_EXPORT(xam,      0x00000900, XamXtwManagerIncrement,                                     kFunction),
XE_EXPORT(xam,      0x00000901, XamXtwManagerDecrement,                                     kFunction),
XE_EXPORT(xam,      0x00000902, XamXtwManagerResetValue,                                    kFunction),
XE_EXPORT(xam,      0x00000903, XamXtwManagerResetAll,                                      kFunction),
XE_EXPORT(xam,      0x00000904, XamXtwManagerGetDataFilePath,                               kFunction),
XE_EXPORT(xam,      0x00000905, XamXtwManagerDeleteDataFile,                                kFunction),
XE_EXPORT(xam,      0x00000906, XamXtwManagerSave,                                          kFunction),
XE_EXPORT(xam,      0x00000907, XamXtwManagerLoad,                                          kFunction),
XE_EXPORT(xam,      0x00000908, XamGetXTweakManager,                                        kFunction),
XE_EXPORT(xam,      0x000009BB, XamMediaVerificationCreate,                                 kFunction),
XE_EXPORT(xam,      0x000009BC, XamMediaVerificationClose,                                  kFunction),
XE_EXPORT(xam,      0x000009BD, XamMediaVerificationVerify,                                 kFunction),
XE_EXPORT(xam,      0x000009BE, XamMediaVerificationFailedBlocks,                           kFunction),
XE_EXPORT(xam,      0x000009BF, XamMediaVerificationInject,                                 kFunction),
XE_EXPORT(xam,      0x000009C0, XamShowBadDiscErrorUI,                                      kFunction),
XE_EXPORT(xam,      0x000009C4, XamBackgroundDownloadSetMode,                               kFunction),
XE_EXPORT(xam,      0x000009C5, XamBackgroundDownloadIsEnabled,                             kFunction),
XE_EXPORT(xam,      0x000009C6, XamBackgroundDownloadGetActiveItem,                         kFunction),
XE_EXPORT(xam,      0x000009C7, XamBackgroundDownloadGetItems,                              kFunction),
XE_EXPORT(xam,      0x000009C8, XamBackgroundDownloadClearItems,                            kFunction),
XE_EXPORT(xam,      0x000009C9, XamBackgroundDownloadItemAdd,                               kFunction),
XE_EXPORT(xam,      0x000009CA, XamBackgroundDownloadItemRemove,                            kFunction),
XE_EXPORT(xam,      0x000009CB, XamBackgroundDownloadItemMakeFirst,                         kFunction),
XE_EXPORT(xam,      0x000009CC, XamBackgroundDownloadSetForegroundPriority,                 kFunction),
XE_EXPORT(xam,      0x000009CD, XamBackgroundDownloadGetForegroundPriority,                 kFunction),
XE_EXPORT(xam,      0x000009CE, XamBackgroundDownloadItemToContentData,                     kFunction),
XE_EXPORT(xam,      0x000009CF, XamBackgroundDownloadItemGetStatus,                         kFunction),
XE_EXPORT(xam,      0x000009D0, XamBackgroundDownloadHistoryGetItem,                        kFunction),
XE_EXPORT(xam,      0x000009D1, XamBackgroundDownloadItemGetHistoryStatus,                  kFunction),
XE_EXPORT(xam,      0x000009D2, XamBackgroundDownloadItemSetHistoryStatus,                  kFunction),
XE_EXPORT(xam,      0x000009D3, XamBackgroundDownloadItemGetStatusAsync,                    kFunction),
XE_EXPORT(xam,      0x000009D4, XamBackgroundDownloadItemGetStatusEx,                       kFunction),
XE_EXPORT(xam,      0x000009D5, XamBackgroundDownloadItemGetHistoryStatusEx,                kFunction),
XE_EXPORT(xam,      0x000009D6, XamBackgroundDownloadBindItems,                             kFunction),
XE_EXPORT(xam,      0x000009D7, XamBackgroundDownloadSetPollingActive,                      kFunction),
XE_EXPORT(xam,      0x000009D8, XamBackgroundDownloadGetPollingActive,                      kFunction),
XE_EXPORT(xam,      0x000009D9, XamBackgroundDownloadGetMode,                               kFunction),
XE_EXPORT(xam,      0x000009DA, XamBackgroundDownloadGetUnexpectedChangeCount,              kFunction),
XE_EXPORT(xam,      0x000009DB, XamBackgroundDownloadIsItemForThisConsole,                  kFunction),
XE_EXPORT(xam,      0x000009DC, XamBackgroundDownloadSelectDevice,                          kFunction),
XE_EXPORT(xam,      0x000009DD, XamBackgroundDownloadItemModify,                            kFunction),
XE_EXPORT(xam,      0x000009DE, XamBackgroundDownloadCacheLegacyMappingInfo,                kFunction),
XE_EXPORT(xam,      0x000009DF, XamBackgroundDownloadGetLegacyMappingInfo,                  kFunction),
XE_EXPORT(xam,      0x000009E0, XamBackgroundDownloadGetLegacyId,                           kFunction),
XE_EXPORT(xam,      0x000009E1, XamBackgroundDownloadDoFail,                                kFunction),
XE_EXPORT(xam,      0x000009E2, XamDownloadSingleItem,                                      kFunction),
XE_EXPORT(xam,      0x000009E3, XamDownloadInSingleItemMode,                                kFunction),
XE_EXPORT(xam,      0x00000A28, XamSwapDisc,                                                kFunction),
XE_EXPORT(xam,      0x00000A29, XamSwapDiscPatchAddress,                                    kVariable),
XE_EXPORT(xam,      0x00000A2A, XamSwapCancel,                                              kFunction),
XE_EXPORT(xam,      0x00000A2B, XamContentSetAttributes,                                    kFunction),
XE_EXPORT(xam,      0x00000A32, XamRamDriveCreate,                                          kFunction),
XE_EXPORT(xam,      0x00000A33, XamRamDriveDestroy,                                         kFunction),
XE_EXPORT(xam,      0x00000A5A, XamPlayTimerGetData,                                        kFunction),
XE_EXPORT(xam,      0x00000A5B, XamPlayTimerSetData,                                        kFunction),
XE_EXPORT(xam,      0x00000A5C, XamPlayTimerResume,                                         kFunction),
XE_EXPORT(xam,      0x00000A5D, XamPlayTimerSuspend,                                        kFunction),
XE_EXPORT(xam,      0x00000A5E, XamPlayTimerIsRunning,                                      kFunction),
XE_EXPORT(xam,      0x00000A5F, XamPlayTimerIsEnabled,                                      kFunction),
XE_EXPORT(xam,      0x00000A60, XamPlayTimerGetNextResetDate,                               kFunction),
XE_EXPORT(xam,      0x00000A61, XamPlayTimerFormatDurationString,                           kFunction),
XE_EXPORT(xam,      0x00000A62, XamPlayTimerGetTimeRemaining,                               kFunction),
XE_EXPORT(xam,      0x00000A63, XamPlayTimerUpdateTimeRemaining,                            kFunction),
XE_EXPORT(xam,      0x00000A64, XamPlayTimerForceNotification,                              kFunction),
XE_EXPORT(xam,      0x00000A65, XamPlayTimerRefreshResetDate,                               kFunction),
XE_EXPORT(xam,      0x00000A66, XuiResourceOpenAndVerifyNoLoc,                              kFunction),
XE_EXPORT(xam,      0x00000A6E, UpnpAVServerSearchInitialize,                               kFunction),
XE_EXPORT(xam,      0x00000A6F, UpnpAVServerSearchDestroy,                                  kFunction),
XE_EXPORT(xam,      0x00000A70, UpnpAVServerSearchStart,                                    kFunction),
XE_EXPORT(xam,      0x00000A71, Destroy,                                                    kFunction),
XE_EXPORT(xam,      0x00000A72, UpnpAVServerSearchDoWork,                                   kFunction),
XE_EXPORT(xam,      0x00000A73, UpnpAVServerSearchGetNextServer,                            kFunction),
XE_EXPORT(xam,      0x00000A8C, XCustomBroadcastGamercardEvent,                             kFunction),
XE_EXPORT(xam,      0x00000A8D, XamCustomGetCurrentActions,                                 kFunction),
XE_EXPORT(xam,      0x00000AA0, XamInstrumentationLogEvent,                                 kFunction),
XE_EXPORT(xam,      0x00000AA1, XamRegisterSMCNotification,                                 kFunction),
XE_EXPORT(xam,      0x00000AA8, XamIsScreenSaverActive,                                     kFunction),
XE_EXPORT(xam,      0x00000AAA, XamInstrumentationLogEventEx,                               kFunction),
XE_EXPORT(xam,      0x00000AAB, XamInstrumentationGetSourceConfig,                          kFunction),
XE_EXPORT(xam,      0x00000AAC, XamInstrumentationDebugConfig,                              kFunction),
XE_EXPORT(xam,      0x00000ADC, CurlCreateCacheEntry,                                       kFunction),
XE_EXPORT(xam,      0x00000ADD, CurlOpenCacheEntry,                                         kFunction),
XE_EXPORT(xam,      0x00000ADE, CurlSetCacheEntryExpireTime,                                kFunction),
XE_EXPORT(xam,      0x00000ADF, CurlReadCacheEntryHeaders,                                  kFunction),
XE_EXPORT(xam,      0x00000AE0, CurlReadCacheEntryContent,                                  kFunction),
XE_EXPORT(xam,      0x00000AE1, CurlWriteCacheEntryContent,                                 kFunction),
XE_EXPORT(xam,      0x00000AE2, CurlCloseCacheEntry,                                        kFunction),
XE_EXPORT(xam,      0x00000AE3, CurlEnumerateCacheEntry,                                    kFunction),
XE_EXPORT(xam,      0x00000AE5, CurlWipeBackingFiles,                                       kFunction),
XE_EXPORT(xam,      0x00000AE7, CurlOpenTitleBackingFile,                                   kFunction),
XE_EXPORT(xam,      0x00000AEA, XamUserIsPartialProfile,                                    kFunction),
XE_EXPORT(xam,      0x00000AEB, XamLocateTitle,                                             kFunction),
XE_EXPORT(xam,      0x00000AEC, XamProfileGetLocalTitleCount,                               kFunction),
XE_EXPORT(xam,      0x00000AED, XamContentRemoveCacheDevice,                                kFunction),
XE_EXPORT(xam,      0x00000AEE, XamContentAddCacheDevice,                                   kFunction),
XE_EXPORT(xam,      0x00000AF0, XamSetSecurityViolationDetected,                            kFunction),
XE_EXPORT(xam,      0x00000AF1, XamIsSecurityViolationDetected,                             kFunction),
XE_EXPORT(xam,      0x00000AF2, XamIsAnySecurityViolationDetected,                          kFunction),
XE_EXPORT(xam,      0x00000AF3, XamGetSecurityViolationsDetected,                           kFunction),
XE_EXPORT(xam,      0x00000AF4, XamActivateCounterMeasure,                                  kFunction),
XE_EXPORT(xam,      0x00000AF5, XamDeactivateCounterMeasure,                                kFunction),
XE_EXPORT(xam,      0x00000AF6, XamIsCounterMeasureActivated,                               kFunction),
XE_EXPORT(xam,      0x00000AF7, XamGetActiveCounterMeasures,                                kFunction),
XE_EXPORT(xam,      0x00000AF8, XamPmdIdentify,                                             kFunction),
XE_EXPORT(xam,      0x00000AF9, XamPmdSendCommand,                                          kFunction),
XE_EXPORT(xam,      0x00000AFA, XamPmdReadReport,                                           kFunction),
XE_EXPORT(xam,      0x00000AFC, XamPartyCreate,                                             kFunction),
XE_EXPORT(xam,      0x00000AFD, XamPartyLeave,                                              kFunction),
XE_EXPORT(xam,      0x00000AFE, XamPartySendInviteDeprecated,                               kFunction),
XE_EXPORT(xam,      0x00000AFF, XamPartyGetUserList,                                        kFunction),
XE_EXPORT(xam,      0x00000B00, XamPartySendGameInvites,                                    kFunction),
XE_EXPORT(xam,      0x00000B01, XamPartyJoin,                                               kFunction),
XE_EXPORT(xam,      0x00000B02, XamPartyKickUser,                                           kFunction),
XE_EXPORT(xam,      0x00000B03, XamPartyAddLocalUsers,                                      kFunction),
XE_EXPORT(xam,      0x00000B04, XamConvertEmoticons,                                        kFunction),
XE_EXPORT(xam,      0x00000B05, XamGetLocaleTimeFormat,                                     kFunction),
XE_EXPORT(xam,      0x00000B06, XamPartyRemoveLocalUsers,                                   kFunction),
XE_EXPORT(xam,      0x00000B07, XamPartyGetUserListInternal,                                kFunction),
XE_EXPORT(xam,      0x00000B08, XamPartySetJoinable,                                        kFunction),
XE_EXPORT(xam,      0x00000B09, XamPartyGetJoinable,                                        kFunction),
XE_EXPORT(xam,      0x00000B0A, XamPartyGetInfo,                                            kFunction),
XE_EXPORT(xam,      0x00000B0B, XamPartySetCustomData,                                      kFunction),
XE_EXPORT(xam,      0x00000B0C, XamPartySetConnectivityGraph,                               kFunction),
XE_EXPORT(xam,      0x00000B0D, XamPartyGetRoutingTable,                                    kFunction),
XE_EXPORT(xam,      0x00000B0E, XamPartyAutomationInprocCall,                               kFunction),
XE_EXPORT(xam,      0x00000B0F, XamPartyGetState,                                           kFunction),
XE_EXPORT(xam,      0x00000B10, XamPartyGetBandwidth,                                       kFunction),
XE_EXPORT(xam,      0x00000B11, XamPartyGetNetworkCounters,                                 kFunction),
XE_EXPORT(xam,      0x00000B12, XamShowQuickLaunchUI,                                       kFunction),
XE_EXPORT(xam,      0x00000B13, XamPartyIsCoordinator,                                      kFunction),
XE_EXPORT(xam,      0x00000B14, XamPartyGetFormation,                                       kFunction),
XE_EXPORT(xam,      0x00000B15, XamPartySendInvite,                                         kFunction),
XE_EXPORT(xam,      0x00000B16, XamPartySetTestDelay,                                       kFunction),
XE_EXPORT(xam,      0x00000B17, XamPartyOverrideNatType,                                    kFunction),
XE_EXPORT(xam,      0x00000B18, XamPartyGetAccessLevel,                                     kFunction),
XE_EXPORT(xam,      0x00000B19, XamPartySetTestFlags,                                       kFunction),
XE_EXPORT(xam,      0x00000B1A, XamIsSystemExperienceTitleId,                               kFunction),
XE_EXPORT(xam,      0x00000B1B, XamPartyJoinEx,                                             kFunction),
XE_EXPORT(xam,      0x00000B1C, XamPartyGetInfoEx,                                          kFunction),
XE_EXPORT(xam,      0x00000B20, XamIsCurrentTitleDatacenterClient,                          kFunction),
XE_EXPORT(xam,      0x00000B22, XamTaskSetCancelSubTasks,                                   kFunction),
XE_EXPORT(xam,      0x00000B23, XamTaskGetCompletionStatus,                                 kFunction),
XE_EXPORT(xam,      0x00000B24, XamTaskCancelWaitAndCloseWaitTask,                          kFunction),
XE_EXPORT(xam,      0x00000B27, XamDataCenterLog,                                           kFunction),
XE_EXPORT(xam,      0x00000B28, XamDataCenterGetDhcpOptionResponseHostnameAndPort,          kFunction),
XE_EXPORT(xam,      0x00000B29, XamDataCenterLogEvent,                                      kFunction),
XE_EXPORT(xam,      0x00000B2A, XamDataCenterShowForceSignInMessage,                        kFunction),
XE_EXPORT(xam,      0x00000B2C, XamWebInstrumentationCreateReport,                          kFunction),
XE_EXPORT(xam,      0x00000B2D, XamWebInstrumentationSetUserVar,                            kFunction),
XE_EXPORT(xam,      0x00000B2E, XamWebInstrumentationSetUserVarNoEscape,                    kFunction),
XE_EXPORT(xam,      0x00000B2F, XamWebInstrumentationGetURL,                                kFunction),
XE_EXPORT(xam,      0x00000B30, XamWebInstrumentationSendReport,                            kFunction),
XE_EXPORT(xam,      0x00000B31, XamWebInstrumentationDestroyReport,                         kFunction),
XE_EXPORT(xam,      0x00000B32, XamWebInstrumentationCreateSampledReport,                   kFunction),
XE_EXPORT(xam,      0x00000B33, XampSetSamplingRandomValue,                                 kFunction),
XE_EXPORT(xam,      0x00000B34, XampWebInstrumentationSetProfileCounts,                     kFunction),
XE_EXPORT(xam,      0x00000B35, XamWebInstrumentationGetURLEx,                              kFunction),
XE_EXPORT(xam,      0x00000B36, XampSetOmnitureCallbackFunction,                            kFunction),
XE_EXPORT(xam,      0x00000B37, XamShowQuickChatUIp,                                        kFunction),
XE_EXPORT(xam,      0x00000B38, XamShowSocialPostUI,                                        kFunction),
XE_EXPORT(xam,      0x00000B39, XamShowBeaconsUI,                                           kFunction),
XE_EXPORT(xam,      0x00000B3A, XamShowMarketplacePurchaseOrderUI,                          kFunction),
XE_EXPORT(xam,      0x00000B3B, XamShowMarketplaceGetOrderReceipts,                         kFunction),
XE_EXPORT(xam,      0x00000B3C, XamShowGenericOnlineAppUI,                                  kFunction),
XE_EXPORT(xam,      0x00000B3D, XamUserAllowedToPostToSocialNetwork,                        kFunction),
XE_EXPORT(xam,      0x00000B3E, XamShowMarketplacePurchaseOrderUIEx,                        kFunction),
XE_EXPORT(xam,      0x00000B3F, DebugXamShowMessageBoxUI_Wait,                              kFunction),
XE_EXPORT(xam,      0x00000B43, XamSetCountry,                                              kFunction),
XE_EXPORT(xam,      0x00000B44, XamIsCurrentTitleDatacenterDash,                            kFunction),
XE_EXPORT(xam,      0x00000B45, XamLoaderRebootToServerDash,                                kFunction),
XE_EXPORT(xam,      0x00000B46, XamIsDataCenterMode,                                        kFunction),
XE_EXPORT(xam,      0x00000B48, XamUserGetXUIDForTFA,                                       kFunction),
XE_EXPORT(xam,      0x00000B4A, XamVerifyXSignerSignature,                                  kFunction),
