/**
 ******************************************************************************
 * Xenia : Xbox 360 Emulator Research Project                                 *
 ******************************************************************************
 * Copyright 2021 Ben Vanik. All rights reserved.                             *
 * Released under the BSD license - see LICENSE in the root for more details. *
 ******************************************************************************
 */

// This is a partial file designed to be included by other files when
// constructing various tables.

// clang-format off

XE_EXPORT(xbdm,     0x00000001, DmAllocatePool,                                             kFunction),
XE_EXPORT(xbdm,     0x00000002, DmAllocatePoolWithTag,                                      kFunction),
XE_EXPORT(xbdm,     0x00000003, DmCloseCounters,                                            kFunction),
XE_EXPORT(xbdm,     0x00000004, DmCloseLoadedModules,                                       kFunction),
XE_EXPORT(xbdm,     0x00000005, DmCloseModuleSections_,                                     kFunction),
XE_EXPORT(xbdm,     0x00000006, DmCloseNotificationSession,                                 kFunction),
XE_EXPORT(xbdm,     0x00000007, DmClosePerformanceCounter,                                  kFunction),
XE_EXPORT(xbdm,     0x00000008, DmContinueThread,                                           kFunction),
XE_EXPORT(xbdm,     0x00000009, DmFreePool,                                                 kFunction),
XE_EXPORT(xbdm,     0x0000000A, DmGetMemory,                                                kFunction),
XE_EXPORT(xbdm,     0x0000000B, DmGetModuleLongName,                                        kFunction),
XE_EXPORT(xbdm,     0x0000000C, DmGetProcAddress,                                           kFunction),
XE_EXPORT(xbdm,     0x0000000D, DmGetThreadContext,                                         kFunction),
XE_EXPORT(xbdm,     0x0000000F, DmGetThreadList,                                            kFunction),
XE_EXPORT(xbdm,     0x00000010, DmGetXbeInfo,                                               kFunction),
XE_EXPORT(xbdm,     0x00000011, DmGetXboxName,                                              kFunction),
XE_EXPORT(xbdm,     0x00000013, DmGo,                                                       kFunction),
XE_EXPORT(xbdm,     0x00000014, DmHaltThread,                                               kFunction),
XE_EXPORT(xbdm,     0x00000015, DmIsDebuggerPresent,                                        kFunction),
XE_EXPORT(xbdm,     0x00000016, DmIsThreadStopped,                                          kFunction),
XE_EXPORT(xbdm,     0x00000017, DmLoadExtension,                                            kFunction),
XE_EXPORT(xbdm,     0x00000018, DmNotify,                                                   kFunction),
XE_EXPORT(xbdm,     0x00000019, DmOpenNotificationSession,                                  kFunction),
XE_EXPORT(xbdm,     0x0000001A, DmOpenPerformanceCounter,                                   kFunction),
XE_EXPORT(xbdm,     0x0000001B, DmQueryPerformanceCounterHandle,                            kFunction),
XE_EXPORT(xbdm,     0x0000001C, DmReboot,                                                   kFunction),
XE_EXPORT(xbdm,     0x0000001E, DmRegisterCommandProcessor,                                 kFunction),
XE_EXPORT(xbdm,     0x00000020, DmRegisterNotificationProcessor,                            kFunction),
XE_EXPORT(xbdm,     0x00000021, DmRegisterPerformanceCounter,                               kFunction),
XE_EXPORT(xbdm,     0x00000022, DmRemoveBreakpoint,                                         kFunction),
XE_EXPORT(xbdm,     0x00000023, DmResumeThread,                                             kFunction),
XE_EXPORT(xbdm,     0x00000024, DmSendNotificationString,                                   kFunction),
XE_EXPORT(xbdm,     0x00000025, DmSetBreakpoint,                                            kFunction),
XE_EXPORT(xbdm,     0x00000026, DmSetDataBreakpoint,                                        kFunction),
XE_EXPORT(xbdm,     0x00000027, DmSetInitialBreakpoint,                                     kFunction),
XE_EXPORT(xbdm,     0x00000028, DmSetMemory,                                                kFunction),
XE_EXPORT(xbdm,     0x00000029, DmSetThreadContext,                                         kFunction),
XE_EXPORT(xbdm,     0x0000002A, DmSetTitle,                                                 kFunction),
XE_EXPORT(xbdm,     0x0000002B, DmSetXboxName,                                              kFunction),
XE_EXPORT(xbdm,     0x0000002D, DmStop,                                                     kFunction),
XE_EXPORT(xbdm,     0x0000002E, DmStopOn,                                                   kFunction),
XE_EXPORT(xbdm,     0x00000030, DmSuspendThread,                                            kFunction),
XE_EXPORT(xbdm,     0x00000031, DmThreadUserData,                                           kFunction),
XE_EXPORT(xbdm,     0x00000032, DmUnloadExtension,                                          kFunction),
XE_EXPORT(xbdm,     0x00000033, DmWalkLoadedModules,                                        kFunction),
XE_EXPORT(xbdm,     0x00000034, DmWalkModuleSections,                                       kFunction),
XE_EXPORT(xbdm,     0x00000035, DmWalkPerformanceCounters,                                  kFunction),
XE_EXPORT(xbdm,     0x00000037, DmCloseCounters_0,                                          kFunction),
XE_EXPORT(xbdm,     0x00000038, DmIsBreakpoint,                                             kFunction),
XE_EXPORT(xbdm,     0x00000039, DmCloseCounters_1,                                          kFunction),
XE_EXPORT(xbdm,     0x0000003A, DmSetUserAccess,                                            kFunction),
XE_EXPORT(xbdm,     0x0000003B, DmGetUserAccess,                                            kFunction),
XE_EXPORT(xbdm,     0x0000003C, DmWalkUserList,                                             kFunction),
XE_EXPORT(xbdm,     0x0000003D, DmAddUser,                                                  kFunction),
XE_EXPORT(xbdm,     0x0000003E, DmEnableSecurity,                                           kFunction),
XE_EXPORT(xbdm,     0x0000003F, DmIsSecurityEnabled,                                        kFunction),
XE_EXPORT(xbdm,     0x00000040, DmRemoveUser,                                               kFunction),
XE_EXPORT(xbdm,     0x00000041, __CAP_Start_Profiling,                                      kFunction),
XE_EXPORT(xbdm,     0x00000042, __CAP_End_Profiling,                                        kFunction),
XE_EXPORT(xbdm,     0x00000046, __CAP_Enter_Function,                                       kFunction),
XE_EXPORT(xbdm,     0x00000047, __CAP_Exit_Function,                                        kFunction),
XE_EXPORT(xbdm,     0x00000048, DmRegisterCommandProcessorEx,                               kFunction),
XE_EXPORT(xbdm,     0x00000049, DmStartProfiling,                                           kFunction),
XE_EXPORT(xbdm,     0x0000004A, DmStopProfiling,                                            kFunction),
XE_EXPORT(xbdm,     0x0000004B, DmQueryMemoryStatistics,                                    kFunction),
XE_EXPORT(xbdm,     0x0000004C, DmEnableStackTrace,                                         kFunction),
XE_EXPORT(xbdm,     0x0000004D, DmQueryAllocationTypeName,                                  kFunction),
XE_EXPORT(xbdm,     0x0000004E, DmRegisterAllocationType,                                   kFunction),
XE_EXPORT(xbdm,     0x0000004F, DmInsertAllocationEntry,                                    kFunction),
XE_EXPORT(xbdm,     0x00000050, DmRemoveAllocationEntry,                                    kFunction),
XE_EXPORT(xbdm,     0x00000051, DmSetTitleEx,                                               kFunction),
XE_EXPORT(xbdm,     0x00000052, DmCaptureStackBackTrace,                                    kFunction),
XE_EXPORT(xbdm,     0x00000053, DmCrashDump,                                                kFunction),
XE_EXPORT(xbdm,     0x00000054, DmIsFastCAPEnabled,                                         kFunction),
XE_EXPORT(xbdm,     0x00000055, DmGetFileAccessCount,                                       kFunction),
XE_EXPORT(xbdm,     0x00000058, DmGetUtilityDriveInfo,                                      kFunction),
XE_EXPORT(xbdm,     0x00000059, DmGetThreadInfoEx,                                          kFunction),
XE_EXPORT(xbdm,     0x0000005A, DmSetProfilingOptions,                                      kFunction),
XE_EXPORT(xbdm,     0x0000005B, DmQuerySystemSettings,                                      kFunction),
XE_EXPORT(xbdm,     0x0000005C, DmSaveSystemSettings,                                       kFunction),
XE_EXPORT(xbdm,     0x0000006A, DmpGetPgoModuleHandleForBaseAddress,                        kFunction),
XE_EXPORT(xbdm,     0x0000006B, DmpOnPgoModuleLoad,                                         kFunction),
XE_EXPORT(xbdm,     0x0000006C, DmPgoStartDataCollection,                                   kFunction),
XE_EXPORT(xbdm,     0x0000006D, DmPgoStopDataCollection,                                    kFunction),
XE_EXPORT(xbdm,     0x0000006E, DmPgoSaveSnapshot,                                          kFunction),
XE_EXPORT(xbdm,     0x0000006F, IrtClientAbort,                                             kFunction),
XE_EXPORT(xbdm,     0x00000070, IrtPogoInit,                                                kFunction),
XE_EXPORT(xbdm,     0x00000071, IrtSetStaticInfo,                                           kFunction),
XE_EXPORT(xbdm,     0x00000072, IrtAutoSweepW,                                              kFunction),
XE_EXPORT(xbdm,     0x00000073, IrtAutoSweepA,                                              kFunction),
XE_EXPORT(xbdm,     0x00000075, DmGetDumpMode,                                              kFunction),
XE_EXPORT(xbdm,     0x00000076, DmSetDumpMode,                                              kFunction),
XE_EXPORT(xbdm,     0x00000077, DmGetDumpSettings,                                          kFunction),
XE_EXPORT(xbdm,     0x00000078, DmSetDumpSettings,                                          kFunction),
XE_EXPORT(xbdm,     0x00000079, DmGetEventDeferFlags,                                       kFunction),
XE_EXPORT(xbdm,     0x0000007A, DmSetEventDeferFlags,                                       kFunction),
XE_EXPORT(xbdm,     0x0000007B, DmWalkCommittedMemory,                                      kFunction),
XE_EXPORT(xbdm,     0x0000007C, DmCloseCounters_2,                                          kFunction),
XE_EXPORT(xbdm,     0x0000007D, DmRebootEx,                                                 kFunction),
XE_EXPORT(xbdm,     0x00000082, DmMountFdfxVolume,                                          kFunction),
XE_EXPORT(xbdm,     0x00000083, DmCapGetFileHeader,                                         kFunction),
XE_EXPORT(xbdm,     0x00000084, DmCapFreeFileHeader,                                        kFunction),
XE_EXPORT(xbdm,     0x00000085, DmTraceStartRecording,                                      kFunction),
XE_EXPORT(xbdm,     0x00000086, DmTraceStartRecordingFunction,                              kFunction),
XE_EXPORT(xbdm,     0x00000087, DmTraceSetBufferSize,                                       kFunction),
XE_EXPORT(xbdm,     0x00000088, DmTraceStopRecording,                                       kFunction),
XE_EXPORT(xbdm,     0x00000089, DmTraceSaveBuffer,                                          kFunction),
XE_EXPORT(xbdm,     0x0000008C, DmGetConsoleType,                                           kFunction),
XE_EXPORT(xbdm,     0x0000008D, DmMapDevkitDrive,                                           kFunction),
XE_EXPORT(xbdm,     0x0000008E, DmWalkLoadedModulesEx,                                      kFunction),
XE_EXPORT(xbdm,     0x0000008F, DmGetXexHeaderField,                                        kFunction),
XE_EXPORT(xbdm,     0x00000090, DmGetMouseChanges,                                          kFunction),
XE_EXPORT(xbdm,     0x00000091, DmFindPdbSignature,                                         kFunction),
XE_EXPORT(xbdm,     0x00000092, DmGetProfilingStatus,                                       kFunction),
XE_EXPORT(xbdm,     0x00000093, DmOpticalDiscLogStart,                                      kFunction),
XE_EXPORT(xbdm,     0x00000094, DmOpticalDiscLogStop,                                       kFunction),
XE_EXPORT(xbdm,     0x00000095, DmStartSamplingProfiler,                                    kFunction),
XE_EXPORT(xbdm,     0x00000096, DmStopSamplingProfiler,                                     kFunction),
XE_EXPORT(xbdm,     0x00000097, DmGetSamplingProfilerInfo,                                  kFunction),
XE_EXPORT(xbdm,     0x00000098, DmStartFileEventCapture,                                    kFunction),
XE_EXPORT(xbdm,     0x00000099, DmStopFileEventCapture,                                     kFunction),
XE_EXPORT(xbdm,     0x0000009A, DmSetFileEventMarker,                                       kFunction),
XE_EXPORT(xbdm,     0x0000009B, DmMarkPseudoCreateBegin,                                    kFunction),
XE_EXPORT(xbdm,     0x0000009C, DmMarkPseudoCreateEnd,                                      kFunction),
XE_EXPORT(xbdm,     0x0000009D, DmMarkPseudoEventBegin,                                     kFunction),
XE_EXPORT(xbdm,     0x0000009E, DmMarkPseudoEventEnd,                                       kFunction),
XE_EXPORT(xbdm,     0x0000009F, DmMarkFileEventWorkerThreadBegin,                           kFunction),
XE_EXPORT(xbdm,     0x000000A0, DmMarkFileEventWorkerThreadEnd,                             kFunction),
XE_EXPORT(xbdm,     0x000000A1, DmGetSystemInfo,                                            kFunction),
XE_EXPORT(xbdm,     0x000000A2, DmAbortProfiling,                                           kFunction),
XE_EXPORT(xbdm,     0x000000A3, DmNetCaptureStart,                                          kFunction),
XE_EXPORT(xbdm,     0x000000A4, DmNetCaptureStop,                                           kFunction),
XE_EXPORT(xbdm,     0x000000A5, DmQueryTitleMemoryStatistics,                               kFunction),
XE_EXPORT(xbdm,     0x000000A6, DmAutomationGetInputProcess,                                kFunction),
XE_EXPORT(xbdm,     0x000000A7, DmAutomationBindController,                                 kFunction),
XE_EXPORT(xbdm,     0x000000A8, DmAutomationUnbindController,                               kFunction),
XE_EXPORT(xbdm,     0x000000A9, DmAutomationConnectController,                              kFunction),
XE_EXPORT(xbdm,     0x000000AA, DmAutomationDisconnectController,                           kFunction),
XE_EXPORT(xbdm,     0x000000AB, DmAutomationSetGamepadState,                                kFunction),
XE_EXPORT(xbdm,     0x000000AC, DmAutomationQueueGamepadState,                              kFunction),
XE_EXPORT(xbdm,     0x000000AD, DmAutomationClearGamepadQueue,                              kFunction),
XE_EXPORT(xbdm,     0x000000AE, DmAutomationQueryGamepadQueue,                              kFunction),
XE_EXPORT(xbdm,     0x000000AF, DmAutomationGetUserDefaultProfile,                          kFunction),
XE_EXPORT(xbdm,     0x000000B0, DmAutomationSetUserDefaultProfile,                          kFunction),
XE_EXPORT(xbdm,     0x000000B1, DmTraceIsRecording,                                         kFunction),
XE_EXPORT(xbdm,     0x000000B2, DmLoadDebuggerExtension,                                    kFunction),
XE_EXPORT(xbdm,     0x000000B3, DmUnloadDebuggerExtension,                                  kFunction),
XE_EXPORT(xbdm,     0x000000B4, DmCreateSystemThread,                                       kFunction),
XE_EXPORT(xbdm,     0x000000B5, PEPLELookup,                                                kFunction),
XE_EXPORT(xbdm,     0x000000B6, PEPLELookupCompact,                                         kFunction),
XE_EXPORT(xbdm,     0x000000B7, PVPLELookup,                                                kFunction),
XE_EXPORT(xbdm,     0x000000B8, PVPLELookupCompact,                                         kFunction),
XE_EXPORT(xbdm,     0x000000B9, PVPLELookupCompactMDS,                                      kFunction),
XE_EXPORT(xbdm,     0x000000BA, PVPLEFilteredLookup,                                        kFunction),
XE_EXPORT(xbdm,     0x000000BB, PVPLEFilteredLookupCompact,                                 kFunction),
XE_EXPORT(xbdm,     0x000000BC, PVPLEFilteredLookupCompactMDS,                              kFunction),
XE_EXPORT(xbdm,     0x000000BD, PVPLETemplatedLookup,                                       kFunction),
XE_EXPORT(xbdm,     0x000000BE, PVPLETemplatedLookupCompact,                                kFunction),
XE_EXPORT(xbdm,     0x000000BF, PVPLETemplatedLookupCompactMDS,                             kFunction),
XE_EXPORT(xbdm,     0x000000C0, DmpPgoCounterOverflow,                                      kFunction),
XE_EXPORT(xbdm,     0x000000C1, UpdateMDSProbeState,                                        kFunction),
XE_EXPORT(xbdm,     0x000000C2, DmGetHttpRegistration,                                      kFunction),
XE_EXPORT(xbdm,     0x000000C3, DmTraceSetIOThread,                                         kFunction),
XE_EXPORT(xbdm,     0x000000C4, DmPMCInstallAndStart,                                       kFunction),
XE_EXPORT(xbdm,     0x000000C5, DmPMCStopAndReport,                                         kFunction),
XE_EXPORT(xbdm,     0x000000C6, DmPMCInstallSetup,                                          kFunction),
XE_EXPORT(xbdm,     0x000000C7, DmPMCUnInstallSetup,                                        kFunction),
XE_EXPORT(xbdm,     0x000000C8, DmPMCResetCounters,                                         kFunction),
XE_EXPORT(xbdm,     0x000000C9, DmPMCSetTriggerProcessor,                                   kFunction),
XE_EXPORT(xbdm,     0x000000CA, DmPMCStart,                                                 kFunction),
XE_EXPORT(xbdm,     0x000000CB, DmPMCStop,                                                  kFunction),
XE_EXPORT(xbdm,     0x000000CC, DmPMCGetCounter,                                            kFunction),
XE_EXPORT(xbdm,     0x000000CD, DmPMCGetCounters,                                           kFunction),
XE_EXPORT(xbdm,     0x000000CE, DmPMCGetCounterName,                                        kFunction),
XE_EXPORT(xbdm,     0x000000CF, DmPMCDumpCounters,                                          kFunction),
XE_EXPORT(xbdm,     0x000000D0, DmPMCDumpCountersVerbose,                                   kFunction),
XE_EXPORT(xbdm,     0x000000D1, DmPMCGetCounterCostEstimate,                                kFunction),
XE_EXPORT(xbdm,     0x000000D2, DmPMCGetCounterSource,                                      kFunction),
XE_EXPORT(xbdm,     0x000000D3, DmPMCComputeFrequency,                                      kFunction),
XE_EXPORT(xbdm,     0x000000D4, DmGetAdditionalTitleMemorySetting,                          kFunction),
XE_EXPORT(xbdm,     0x000000D5, DmGetDebugMemorySize,                                       kFunction),
XE_EXPORT(xbdm,     0x000000D6, DmGetConsoleDebugMemoryStatus,                              kFunction),
XE_EXPORT(xbdm,     0x000000D7, DmNetSimSetLinkStatusHidden,                                kFunction),
XE_EXPORT(xbdm,     0x000000D8, DmNetSimInsertQueue,                                        kFunction),
XE_EXPORT(xbdm,     0x000000D9, DmNetSimRemoveQueue,                                        kFunction),
XE_EXPORT(xbdm,     0x000000DA, DmNetSimRemoveAllQueues,                                    kFunction),
XE_EXPORT(xbdm,     0x000000DB, DmNetSimModifyQueueSettings,                                kFunction),
XE_EXPORT(xbdm,     0x000000DC, DmGetConsoleFeatures,                                       kFunction),
XE_EXPORT(xbdm,     0x000000DD, DmNetSimGetQueueStats,                                      kFunction),
XE_EXPORT(xbdm,     0x000000DE, DmNetSimGetQueueSettings,                                   kFunction),
XE_EXPORT(xbdm,     0x000000DF, DmNetSimGetNumQueues,                                       kFunction),
XE_EXPORT(xbdm,     0x000000E0, DmNetSimInsertIpv4Redirect,                                 kFunction),
XE_EXPORT(xbdm,     0x000000E1, DmNetSimRemoveIpv4Redirect,                                 kFunction),
XE_EXPORT(xbdm,     0x000000E2, DmNetSimGetNumIpv4Redirects,                                kFunction),
XE_EXPORT(xbdm,     0x0000012C, XLFAllocate,                                                kFunction),
XE_EXPORT(xbdm,     0x0000012D, XLFFree,                                                    kFunction),
XE_EXPORT(xbdm,     0x0000012E, XLFQueueAdd,                                                kFunction),
XE_EXPORT(xbdm,     0x0000012F, XLFQueueAllocated,                                          kFunction),
XE_EXPORT(xbdm,     0x00000130, XLFQueueCreate,                                             kFunction),
XE_EXPORT(xbdm,     0x00000131, XLFQueueDestroy,                                            kFunction),
XE_EXPORT(xbdm,     0x00000132, XLFQueueGetEntryCount,                                      kFunction),
XE_EXPORT(xbdm,     0x00000133, XLFQueueIsEmpty,                                            kFunction),
XE_EXPORT(xbdm,     0x00000134, XLFQueueRemove,                                             kFunction),
XE_EXPORT(xbdm,     0x00000135, XLFQueueUnsafeDump,                                         kFunction),
XE_EXPORT(xbdm,     0x00000136, XLFStackAllocated,                                          kFunction),
XE_EXPORT(xbdm,     0x00000137, XLFStackCreate,                                             kFunction),
XE_EXPORT(xbdm,     0x00000138, XLFStackDestroy,                                            kFunction),
XE_EXPORT(xbdm,     0x00000139, XLFStackGetEntryCount,                                      kFunction),
XE_EXPORT(xbdm,     0x0000013A, XLFStackIsEmpty,                                            kFunction),
XE_EXPORT(xbdm,     0x0000013B, XLFStackPop,                                                kFunction),
XE_EXPORT(xbdm,     0x0000013C, XLFStackPush,                                               kFunction),
XE_EXPORT(xbdm,     0x0000013D, XLFStackUnsafeDump,                                         kFunction),
XE_EXPORT(xbdm,     0x00000140, XLFPriorityQueueAdd,                                        kFunction),
XE_EXPORT(xbdm,     0x00000141, XLFPriorityQueueAllocated,                                  kFunction),
XE_EXPORT(xbdm,     0x00000142, XLFPriorityQueueCreate,                                     kFunction),
XE_EXPORT(xbdm,     0x00000143, XLFPriorityQueueDestroy,                                    kFunction),
XE_EXPORT(xbdm,     0x00000144, XLFPriorityQueueGetEntryCount,                              kFunction),
XE_EXPORT(xbdm,     0x00000145, XLFPriorityQueueIsEmpty,                                    kFunction),
XE_EXPORT(xbdm,     0x00000146, XLFPriorityQueueRemoveFirst,                                kFunction),
XE_EXPORT(xbdm,     0x00000147, XLFPriorityQueueRemove,                                     kFunction),
XE_EXPORT(xbdm,     0x00000148, XLFPriorityQueueUnsafeDump,                                 kFunction),
XE_EXPORT(xbdm,     0x0000014A, XLFHashTableAdd,                                            kFunction),
XE_EXPORT(xbdm,     0x0000014B, XLFHashTableAllocated,                                      kFunction),
XE_EXPORT(xbdm,     0x0000014C, XLFHashTableCreate,                                         kFunction),
XE_EXPORT(xbdm,     0x0000014D, XLFHashTableDestroy,                                        kFunction),
XE_EXPORT(xbdm,     0x0000014E, XLFHashTableGetEntryCount,                                  kFunction),
XE_EXPORT(xbdm,     0x0000014F, XLFHashTableIsEmpty,                                        kFunction),
XE_EXPORT(xbdm,     0x00000150, XLFHashTableRemoveFirst,                                    kFunction),
XE_EXPORT(xbdm,     0x00000151, XLFHashTableRemove,                                         kFunction),
XE_EXPORT(xbdm,     0x00000152, XLFHashTableUnsafeDump,                                     kFunction),
XE_EXPORT(xbdm,     0x00000154, XLFPoolAcquireLock,                                         kFunction),
XE_EXPORT(xbdm,     0x00000155, XLFPoolAllocated,                                           kFunction),
XE_EXPORT(xbdm,     0x00000156, XLFPoolCreate,                                              kFunction),
XE_EXPORT(xbdm,     0x00000157, XLFPoolCreateLock,                                          kFunction),
XE_EXPORT(xbdm,     0x00000158, XLFPoolDestroy,                                             kFunction),
XE_EXPORT(xbdm,     0x00000159, XLFPoolDestroyLock,                                         kFunction),
XE_EXPORT(xbdm,     0x0000015A, XLFPoolIncreaseEvents,                                      kFunction),
XE_EXPORT(xbdm,     0x0000015B, XLFPoolIncreaseLocks,                                       kFunction),
XE_EXPORT(xbdm,     0x0000015C, XLFPoolInitializeLock,                                      kFunction),
XE_EXPORT(xbdm,     0x0000015D, XLFPoolNumberOfEvents,                                      kFunction),
XE_EXPORT(xbdm,     0x0000015E, XLFPoolNumberOfLocks,                                       kFunction),
XE_EXPORT(xbdm,     0x0000015F, XLFPoolReleaseLock,                                         kFunction),
XE_EXPORT(xbdm,     0x00000163, XLFStartLog,                                                kFunction),
XE_EXPORT(xbdm,     0x00000164, XLFStartUserLog,                                            kFunction),
XE_EXPORT(xbdm,     0x00000165, XLFInitializeLog,                                           kFunction),
XE_EXPORT(xbdm,     0x00000166, XLFInitializeUserLog,                                       kFunction),
XE_EXPORT(xbdm,     0x00000168, XLFEndLog,                                                  kFunction),
XE_EXPORT(xbdm,     0x00000169, XLFLogPrint,                                                kFunction),
XE_EXPORT(xbdm,     0x0000016A, XLFLogPrintV,                                               kFunction),
XE_EXPORT(xbdm,     0x0000016B, XLFLogBuffer,                                               kFunction),
XE_EXPORT(xbdm,     0x0000016C, XLFLogMessageStats,                                         kFunction),
XE_EXPORT(xbdm,     0x00000172, XLockFreeGetErrorHandler,                                   kFunction),
XE_EXPORT(xbdm,     0x00000173, XLockFreeSetErrorHandler,                                   kFunction),
XE_EXPORT(xbdm,     0x00000174, DmExecuteThreadRPC,                                         kFunction),
XE_EXPORT(xbdm,     0x00000175, DmGetDebuggerConnection,                                    kFunction),
