/**
 ******************************************************************************
 * Xenia : Xbox 360 Emulator Research Project                                 *
 ******************************************************************************
 * Copyright 2021 Ben Vanik. All rights reserved.                             *
 * Released under the BSD license - see LICENSE in the root for more details. *
 ******************************************************************************
 */

// This is a partial file designed to be included by other files when
// constructing various tables.

// clang-format off

XE_EXPORT(xboxkrnl, 0x00000001, DbgBreakPoint,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000002, DbgBreakPointWithStatus,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000003, DbgPrint,                                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000004, DbgPrompt,                                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000005, DumpGetRawDumpInfo,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000006, DumpWriteDump,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000007, ExAcquireReadWriteLockExclusive,                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000008, ExAcquireReadWriteLockShared,                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000009, ExAllocatePool,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x0000000A, ExAllocatePoolWithTag,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x0000000B, ExAllocatePoolTypeWithTag,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x0000000C, ExConsoleGameRegion,                                        kVariable),
XE_EXPORT(xboxkrnl, 0x0000000D, ExCreateThread,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x0000000E, ExEventObjectType,                                          kVariable),
XE_EXPORT(xboxkrnl, 0x0000000F, ExFreePool,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000010, ExGetXConfigSetting,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000011, ExInitializeReadWriteLock,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000012, ExMutantObjectType,                                         kVariable),
XE_EXPORT(xboxkrnl, 0x00000013, ExQueryPoolBlockSize,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000014, ExRegisterThreadNotification,                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000015, ExRegisterTitleTerminateNotification,                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000016, ExReleaseReadWriteLock,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000017, ExSemaphoreObjectType,                                      kVariable),
XE_EXPORT(xboxkrnl, 0x00000018, ExSetXConfigSetting,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000019, ExTerminateThread,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x0000001A, ExTerminateTitleProcess,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x0000001B, ExThreadObjectType,                                         kVariable),
XE_EXPORT(xboxkrnl, 0x0000001C, ExTimerObjectType,                                          kVariable),
XE_EXPORT(xboxkrnl, 0x0000001D, MmDoubleMapMemory,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x0000001E, MmUnmapMemory,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000001F, XeKeysGetConsoleCertificate,                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000020, FscGetCacheElementCount,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000021, FscSetCacheElementCount,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000022, HalGetCurrentAVPack,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000023, HalGpioControl,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000024, HalOpenCloseODDTray,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000025, HalReadWritePCISpace,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000026, HalRegisterPowerDownNotification,                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000027, HalRegisterSMCNotification,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000028, HalReturnToFirmware,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000029, HalSendSMCMessage,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x0000002A, HalSetAudioEnable,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x0000002B, InterlockedFlushSList,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x0000002C, InterlockedPopEntrySList,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x0000002D, InterlockedPushEntrySList,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x0000002E, IoAcquireDeviceObjectLock,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x0000002F, IoAllocateIrp,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000030, IoBuildAsynchronousFsdRequest,                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000031, IoBuildDeviceIoControlRequest,                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000032, IoBuildSynchronousFsdRequest,                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000033, IoCallDriver,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000034, IoCheckShareAccess,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000035, IoCompleteRequest,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000036, IoCompletionObjectType,                                     kVariable),
XE_EXPORT(xboxkrnl, 0x00000037, IoCreateDevice,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000038, IoCreateFile,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000039, IoDeleteDevice,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x0000003A, IoDeviceObjectType,                                         kVariable),
XE_EXPORT(xboxkrnl, 0x0000003B, IoDismountVolume,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000003C, IoDismountVolumeByFileHandle,                               kFunction),
XE_EXPORT(xboxkrnl, 0x0000003D, IoDismountVolumeByName,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000003E, IoFileObjectType,                                           kVariable),
XE_EXPORT(xboxkrnl, 0x0000003F, IoFreeIrp,                                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000040, IoInitializeIrp,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000041, IoInvalidDeviceRequest,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000042, ExSetBetaFeaturesEnabled,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000043, IoQueueThreadIrp,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000044, IoReleaseDeviceObjectLock,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000045, IoRemoveShareAccess,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000046, IoSetIoCompletion,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000047, IoSetShareAccess,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000048, IoStartNextPacket,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000049, IoStartNextPacketByKey,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000004A, IoStartPacket,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000004B, IoSynchronousDeviceIoControlRequest,                        kFunction),
XE_EXPORT(xboxkrnl, 0x0000004C, IoSynchronousFsdRequest,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x0000004D, KeAcquireSpinLockAtRaisedIrql,                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000004E, KeAlertResumeThread,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x0000004F, KeAlertThread,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000050, KeBlowFuses,                                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000051, KeBoostPriorityThread,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000052, KeBugCheck,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000053, KeBugCheckEx,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000054, KeCancelTimer,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000055, KeConnectInterrupt,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000056, KeContextFromKframes,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000057, KeContextToKframes,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000058, KeCreateUserMode,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000059, KeDebugMonitorData,                                         kVariable),
XE_EXPORT(xboxkrnl, 0x0000005A, KeDelayExecutionThread,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000005B, KeDeleteUserMode,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000005C, KeDisconnectInterrupt,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x0000005D, KeEnableFpuExceptions,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x0000005E, KeEnablePPUPerformanceMonitor,                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000005F, KeEnterCriticalRegion,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000060, KeEnterUserMode,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000061, KeFlushCacheRange,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000062, KeFlushCurrentEntireTb,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000063, KeFlushEntireTb,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000064, KeFlushUserModeCurrentTb,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000065, KeFlushUserModeTb,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000066, KeGetCurrentProcessType,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000067, KeGetPMWRegister,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000068, KeGetPRVRegister,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000069, KeGetSocRegister,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000006A, KeGetSpecialPurposeRegister,                                kFunction),
XE_EXPORT(xboxkrnl, 0x0000006B, KeLockL2,                                                   kFunction),
XE_EXPORT(xboxkrnl, 0x0000006C, KeUnlockL2,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x0000006D, KeInitializeApc,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x0000006E, KeInitializeDeviceQueue,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x0000006F, KeInitializeDpc,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000070, KeInitializeEvent,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000071, KeInitializeInterrupt,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000072, KeInitializeMutant,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000073, KeInitializeQueue,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000074, KeInitializeSemaphore,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000075, KeInitializeTimerEx,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000076, KeInsertByKeyDeviceQueue,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000077, KeInsertDeviceQueue,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000078, KeInsertHeadQueue,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000079, KeInsertQueue,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000007A, KeInsertQueueApc,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000007B, KeInsertQueueDpc,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000007C, KeIpiGenericCall,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000007D, KeLeaveCriticalRegion,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x0000007E, KeLeaveUserMode,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x0000007F, KePulseEvent,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000080, KeQueryBackgroundProcessors,                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000081, KeQueryBasePriorityThread,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000082, KeQueryInterruptTime,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000083, KeQueryPerformanceFrequency,                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000084, KeQuerySystemTime,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000085, KeRaiseIrqlToDpcLevel,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000086, KeRegisterDriverNotification,                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000087, KeReleaseMutant,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000088, KeReleaseSemaphore,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000089, KeReleaseSpinLockFromRaisedIrql,                            kFunction),
XE_EXPORT(xboxkrnl, 0x0000008A, KeRemoveByKeyDeviceQueue,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x0000008B, KeRemoveDeviceQueue,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x0000008C, KeRemoveEntryDeviceQueue,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x0000008D, KeRemoveQueue,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000008E, KeRemoveQueueDpc,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000008F, KeResetEvent,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000090, KeRestoreFloatingPointState,                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000091, KeRestoreVectorUnitState,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000092, KeResumeThread,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000093, KeRetireDpcList,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000094, KeRundownQueue,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000095, KeSaveFloatingPointState,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000096, KeSaveVectorUnitState,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000097, KeSetAffinityThread,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000098, KeSetBackgroundProcessors,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000099, KeSetBasePriorityThread,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x0000009A, KeSetCurrentProcessType,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x0000009B, KeSetCurrentStackPointers,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x0000009C, KeSetDisableBoostThread,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x0000009D, KeSetEvent,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x0000009E, KeSetEventBoostPriority,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x0000009F, KeSetPMWRegister,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000000A0, KeSetPowerMode,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x000000A1, KeSetPRVRegister,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000000A2, KeSetPriorityClassThread,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000000A3, KeSetPriorityThread,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x000000A4, KeSetSocRegister,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000000A5, KeSetSpecialPurposeRegister,                                kFunction),
XE_EXPORT(xboxkrnl, 0x000000A6, KeSetTimer,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x000000A7, KeSetTimerEx,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x000000A8, KeStallExecutionProcessor,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x000000A9, KeSuspendThread,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x000000AA, KeSweepDcacheRange,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x000000AB, KeSweepIcacheRange,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x000000AC, KeTestAlertThread,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x000000AD, KeTimeStampBundle,                                          kVariable),
XE_EXPORT(xboxkrnl, 0x000000AE, KeTryToAcquireSpinLockAtRaisedIrql,                         kFunction),
XE_EXPORT(xboxkrnl, 0x000000AF, KeWaitForMultipleObjects,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000000B0, KeWaitForSingleObject,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000000B1, KfAcquireSpinLock,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x000000B2, KfRaiseIrql,                                                kFunction),
XE_EXPORT(xboxkrnl, 0x000000B3, KfLowerIrql,                                                kFunction),
XE_EXPORT(xboxkrnl, 0x000000B4, KfReleaseSpinLock,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x000000B5, KiBugCheckData,                                             kVariable),
XE_EXPORT(xboxkrnl, 0x000000B6, LDICreateDecompression,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x000000B7, LDIDecompress,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x000000B8, LDIDestroyDecompression,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000000B9, MmAllocatePhysicalMemory,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000000BA, MmAllocatePhysicalMemoryEx,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x000000BB, MmCreateKernelStack,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x000000BC, MmDeleteKernelStack,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x000000BD, MmFreePhysicalMemory,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x000000BE, MmGetPhysicalAddress,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x000000BF, MmIsAddressValid,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000000C0, MmLockAndMapSegmentArray,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000000C1, MmLockUnlockBufferPages,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000000C2, MmMapIoSpace,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x000000C3, MmPersistPhysicalMemoryAllocation,                          kFunction),
XE_EXPORT(xboxkrnl, 0x000000C4, MmQueryAddressProtect,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000000C5, MmQueryAllocationSize,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000000C6, MmQueryStatistics,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x000000C7, MmSetAddressProtect,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x000000C8, MmSplitPhysicalMemoryAllocation,                            kFunction),
XE_EXPORT(xboxkrnl, 0x000000C9, MmUnlockAndUnmapSegmentArray,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000000CA, MmUnmapIoSpace,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x000000CB, Nls844UnicodeCaseTable,                                     kVariable),
XE_EXPORT(xboxkrnl, 0x000000CC, NtAllocateVirtualMemory,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000000CD, NtCancelTimer,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x000000CE, NtClearEvent,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x000000CF, NtClose,                                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000000D0, NtCreateDirectoryObject,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000000D1, NtCreateEvent,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x000000D2, NtCreateFile,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x000000D3, NtCreateIoCompletion,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x000000D4, NtCreateMutant,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x000000D5, NtCreateSemaphore,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x000000D6, NtCreateSymbolicLinkObject,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x000000D7, NtCreateTimer,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x000000D8, NtDeleteFile,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x000000D9, NtDeviceIoControlFile,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000000DA, NtDuplicateObject,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x000000DB, NtFlushBuffersFile,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x000000DC, NtFreeVirtualMemory,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x000000DD, NtMakeTemporaryObject,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000000DE, NtOpenDirectoryObject,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000000DF, NtOpenFile,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x000000E0, NtOpenSymbolicLinkObject,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000000E1, NtProtectVirtualMemory,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x000000E2, NtPulseEvent,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x000000E3, NtQueueApcThread,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000000E4, NtQueryDirectoryFile,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x000000E5, NtQueryDirectoryObject,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x000000E6, NtQueryEvent,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x000000E7, NtQueryFullAttributesFile,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x000000E8, NtQueryInformationFile,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x000000E9, NtQueryIoCompletion,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x000000EA, NtQueryMutant,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x000000EB, NtQuerySemaphore,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000000EC, NtQuerySymbolicLinkObject,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x000000ED, NtQueryTimer,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x000000EE, NtQueryVirtualMemory,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x000000EF, NtQueryVolumeInformationFile,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000000F0, NtReadFile,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x000000F1, NtReadFileScatter,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x000000F2, NtReleaseMutant,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x000000F3, NtReleaseSemaphore,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x000000F4, NtRemoveIoCompletion,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x000000F5, NtResumeThread,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x000000F6, NtSetEvent,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x000000F7, NtSetInformationFile,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x000000F8, NtSetIoCompletion,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x000000F9, NtSetSystemTime,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x000000FA, NtSetTimerEx,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x000000FB, NtSignalAndWaitForSingleObjectEx,                           kFunction),
XE_EXPORT(xboxkrnl, 0x000000FC, NtSuspendThread,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x000000FD, NtWaitForSingleObjectEx,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000000FE, NtWaitForMultipleObjectsEx,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x000000FF, NtWriteFile,                                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000100, NtWriteFileGather,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000101, NtYieldExecution,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000102, ObCreateObject,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000103, ObCreateSymbolicLink,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000104, ObDeleteSymbolicLink,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000105, ObDereferenceObject,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000106, ObDirectoryObjectType,                                      kVariable),
XE_EXPORT(xboxkrnl, 0x00000107, ObGetWaitableObject,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000108, ObInsertObject,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000109, ObIsTitleObject,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x0000010A, ObLookupAnyThreadByThreadId,                                kFunction),
XE_EXPORT(xboxkrnl, 0x0000010B, ObLookupThreadByThreadId,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x0000010C, ObMakeTemporaryObject,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x0000010D, ObOpenObjectByName,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x0000010E, ObOpenObjectByPointer,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x0000010F, ObReferenceObject,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000110, ObReferenceObjectByHandle,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000111, ObReferenceObjectByName,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000112, ObSymbolicLinkObjectType,                                   kVariable),
XE_EXPORT(xboxkrnl, 0x00000113, ObTranslateSymbolicLink,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000114, RtlAnsiStringToUnicodeString,                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000115, RtlAppendStringToString,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000116, RtlAppendUnicodeStringToString,                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000117, RtlAppendUnicodeToString,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000118, RtlAssert,                                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000119, RtlCaptureContext,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x0000011A, RtlCompareMemory,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000011B, RtlCompareMemoryUlong,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x0000011C, RtlCompareString,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000011D, RtlCompareStringN,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x0000011E, RtlCompareUnicodeString,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x0000011F, RtlCompareUnicodeStringN,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000120, RtlCompareUtf8ToUnicode,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000121, RtlCopyString,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000122, RtlCopyUnicodeString,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000123, RtlCreateUnicodeString,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000124, RtlDowncaseUnicodeChar,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000125, RtlEnterCriticalSection,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000126, RtlFillMemoryUlong,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000127, RtlFreeAnsiString,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000128, RtlFreeUnicodeString,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000129, RtlGetCallersAddress,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x0000012A, RtlGetStackLimits,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x0000012B, RtlImageXexHeaderField,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000012C, RtlInitAnsiString,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x0000012D, RtlInitUnicodeString,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x0000012E, RtlInitializeCriticalSection,                               kFunction),
XE_EXPORT(xboxkrnl, 0x0000012F, RtlInitializeCriticalSectionAndSpinCount,                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000130, RtlLeaveCriticalSection,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000131, RtlLookupFunctionEntry,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000132, RtlLowerChar,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000133, RtlMultiByteToUnicodeN,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000134, RtlMultiByteToUnicodeSize,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000135, RtlNtStatusToDosError,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000136, RtlRaiseException,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000137, RtlRaiseStatus,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000138, RtlRip,                                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000139, _scprintf,                                                  kFunction),
XE_EXPORT(xboxkrnl, 0x0000013A, _snprintf,                                                  kFunction),
XE_EXPORT(xboxkrnl, 0x0000013B, sprintf,                                                    kFunction),
XE_EXPORT(xboxkrnl, 0x0000013C, _scwprintf,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x0000013D, _snwprintf,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x0000013E, swprintf,                                                   kFunction),
XE_EXPORT(xboxkrnl, 0x0000013F, RtlTimeFieldsToTime,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000140, RtlTimeToTimeFields,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000141, RtlTryEnterCriticalSection,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000142, RtlUnicodeStringToAnsiString,                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000143, RtlUnicodeToMultiByteN,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000144, RtlUnicodeToMultiByteSize,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000145, RtlUnicodeToUtf8,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000146, RtlUnicodeToUtf8Size,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000147, RtlUnwind,                                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000148, RtlUnwind2,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000149, RtlUpcaseUnicodeChar,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x0000014A, RtlUpperChar,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x0000014B, RtlVirtualUnwind,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000014C, _vscprintf,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x0000014D, _vsnprintf,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x0000014E, vsprintf,                                                   kFunction),
XE_EXPORT(xboxkrnl, 0x0000014F, _vscwprintf,                                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000150, _vsnwprintf,                                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000151, vswprintf,                                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000152, KeTlsAlloc,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000153, KeTlsFree,                                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000154, KeTlsGetValue,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000155, KeTlsSetValue,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000156, XboxHardwareInfo,                                           kVariable),
XE_EXPORT(xboxkrnl, 0x00000157, XboxKrnlBaseVersion,                                        kVariable),
XE_EXPORT(xboxkrnl, 0x00000158, XboxKrnlVersion,                                            kVariable),
XE_EXPORT(xboxkrnl, 0x00000159, XeCryptAesKey,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000015A, XeCryptAesEcb,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000015B, XeCryptAesCbc,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000015C, XeCryptBnDwLeDhEqualBase,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x0000015D, XeCryptBnDwLeDhInvalBase,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x0000015E, XeCryptBnDwLeDhModExp,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x0000015F, XeCryptBnDw_Copy,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000160, XeCryptBnDw_SwapLeBe,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000161, XeCryptBnDw_Zero,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000162, XeCryptBnDwLePkcs1Format,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000163, XeCryptBnDwLePkcs1Verify,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000164, XeCryptBnQwBeSigCreate,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000165, XeCryptBnQwBeSigFormat,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000166, XeCryptBnQwBeSigVerify,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000167, XeCryptBnQwNeModExp,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000168, XeCryptBnQwNeModExpRoot,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000169, XeCryptBnQwNeModInv,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x0000016A, XeCryptBnQwNeModMul,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x0000016B, XeCryptBnQwNeRsaKeyGen,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000016C, XeCryptBnQwNeRsaPrvCrypt,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x0000016D, XeCryptBnQwNeRsaPubCrypt,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x0000016E, XeCryptBnQw_Copy,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000016F, XeCryptBnQw_SwapDwQw,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000170, XeCryptBnQw_SwapDwQwLeBe,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000171, XeCryptBnQw_SwapLeBe,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000172, XeCryptBnQw_Zero,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000173, XeCryptChainAndSumMac,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000174, XeCryptDesParity,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000175, XeCryptDesKey,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000176, XeCryptDesEcb,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000177, XeCryptDesCbc,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000178, XeCryptDes3Key,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000179, XeCryptDes3Ecb,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x0000017A, XeCryptDes3Cbc,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x0000017B, XeCryptHmacMd5Init,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x0000017C, XeCryptHmacMd5Update,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x0000017D, XeCryptHmacMd5Final,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x0000017E, XeCryptHmacMd5,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x0000017F, XeCryptHmacShaInit,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000180, XeCryptHmacShaUpdate,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000181, XeCryptHmacShaFinal,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000182, XeCryptHmacSha,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000183, XeCryptHmacShaVerify,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000184, XeCryptMd5Init,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000185, XeCryptMd5Update,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000186, XeCryptMd5Final,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000187, XeCryptMd5,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000188, XeCryptParveEcb,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000189, XeCryptParveCbcMac,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x0000018A, XeCryptRandom,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000018B, XeCryptRc4Key,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000018C, XeCryptRc4Ecb,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000018D, XeCryptRc4,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x0000018E, XeCryptRotSumSha,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000018F, XeCryptShaInit,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000190, XeCryptShaUpdate,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000191, XeCryptShaFinal,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000192, XeCryptSha,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000193, XexExecutableModuleHandle,                                  kVariable),
XE_EXPORT(xboxkrnl, 0x00000194, XexCheckExecutablePrivilege,                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000195, XexGetModuleHandle,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000196, XexGetModuleSection,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000197, XexGetProcedureAddress,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000198, XexLoadExecutable,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000199, XexLoadImage,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x0000019A, XexLoadImageFromMemory,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000019B, XexLoadImageHeaders,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x0000019C, XexPcToFileHeader,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x0000019D, KiApcNormalRoutineNop_,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000019E, XexRegisterPatchDescriptor,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x0000019F, XexSendDeferredNotifications,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000001A0, XexStartExecutable,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x000001A1, XexUnloadImage,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x000001A2, XexUnloadImageAndExitThread,                                kFunction),
XE_EXPORT(xboxkrnl, 0x000001A3, XexUnloadTitleModules,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000001A4, XexVerifyImageHeaders,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000001A5, __C_specific_handler,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x000001A6, DbgLoadImageSymbols,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x000001A7, DbgUnLoadImageSymbols,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000001A8, RtlImageDirectoryEntryToData,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000001A9, RtlImageNtHeader,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000001AA, ExDebugMonitorService,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000001AB, MmDbgReadCheck,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x000001AC, MmDbgReleaseAddress,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x000001AD, MmDbgWriteCheck,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x000001AE, ExLoadedCommandLine,                                        kVariable),
XE_EXPORT(xboxkrnl, 0x000001AF, ExLoadedImageName,                                          kVariable),
XE_EXPORT(xboxkrnl, 0x000001B0, VdBlockUntilGUIIdle,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x000001B1, VdCallGraphicsNotificationRoutines,                         kFunction),
XE_EXPORT(xboxkrnl, 0x000001B2, VdDisplayFatalError,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x000001B3, VdEnableClosedCaption,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000001B4, VdEnableDisableClockGating,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x000001B5, VdEnableDisablePowerSavingMode,                             kFunction),
XE_EXPORT(xboxkrnl, 0x000001B6, VdEnableRingBufferRPtrWriteBack,                            kFunction),
XE_EXPORT(xboxkrnl, 0x000001B7, VdGenerateGPUCSCCoefficients,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000001B8, VdGetClosedCaptionReadyStatus,                              kFunction),
XE_EXPORT(xboxkrnl, 0x000001B9, VdGetCurrentDisplayGamma,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000001BA, VdGetCurrentDisplayInformation,                             kFunction),
XE_EXPORT(xboxkrnl, 0x000001BB, VdGetDisplayModeOverride,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000001BC, VdGetGraphicsAsicID,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x000001BD, VdGetSystemCommandBuffer,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000001BE, VdGlobalDevice,                                             kVariable),
XE_EXPORT(xboxkrnl, 0x000001BF, VdGlobalXamDevice,                                          kVariable),
XE_EXPORT(xboxkrnl, 0x000001C0, VdGpuClockInMHz,                                            kVariable),
XE_EXPORT(xboxkrnl, 0x000001C1, VdHSIOCalibrationLock,                                      kVariable),
XE_EXPORT(xboxkrnl, 0x000001C2, VdInitializeEngines,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x000001C3, VdInitializeRingBuffer,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x000001C4, VdInitializeScaler,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x000001C5, VdInitializeScalerCommandBuffer,                            kFunction),
XE_EXPORT(xboxkrnl, 0x000001C6, VdIsHSIOTrainingSucceeded,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x000001C7, VdPersistDisplay,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000001C8, VdQuerySystemCommandBuffer,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x000001C9, VdQueryVideoFlags,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x000001CA, VdQueryVideoMode,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000001CB, VdReadDVERegisterUlong,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x000001CC, VdReadWriteHSIOCalibrationFlag,                             kFunction),
XE_EXPORT(xboxkrnl, 0x000001CD, VdRegisterGraphicsNotification,                             kFunction),
XE_EXPORT(xboxkrnl, 0x000001CE, VdRegisterXamGraphicsNotification,                          kFunction),
XE_EXPORT(xboxkrnl, 0x000001CF, VdSendClosedCaptionData,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000001D0, VdSetCGMSOption,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x000001D1, VdSetColorProfileAdjustment,                                kFunction),
XE_EXPORT(xboxkrnl, 0x000001D2, VdSetCscMatricesOverride,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000001D3, VdSetDisplayMode,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000001D4, VdSetDisplayModeOverride,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000001D5, VdSetGraphicsInterruptCallback,                             kFunction),
XE_EXPORT(xboxkrnl, 0x000001D6, VdSetHDCPOption,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x000001D7, VdSetMacrovisionOption,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x000001D8, VdSetSystemCommandBuffer,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000001D9, VdSetSystemCommandBufferGpuIdentifierAddress,               kFunction),
XE_EXPORT(xboxkrnl, 0x000001DA, VdSetWSSData,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x000001DB, VdSetWSSOption,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x000001DC, VdShutdownEngines,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x000001DD, VdTurnDisplayOff,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000001DE, VdTurnDisplayOn,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x000001DF, KiApcNormalRoutineNop,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000001E0, VdWriteDVERegisterUlong,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000001E1, XVoicedHeadsetPresent,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000001E2, XVoicedSubmitPacket,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x000001E3, XVoicedClose,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x000001E4, XVoicedActivate,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x000001E5, XInputdGetCapabilities,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x000001E6, XInputdReadState,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000001E7, XInputdWriteState,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x000001E8, XInputdNotify,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x000001E9, XInputdRawState,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x000001EA, HidGetCapabilities,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x000001EB, HidReadKeys,                                                kFunction),
XE_EXPORT(xboxkrnl, 0x000001EC, XInputdGetDeviceStats,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000001ED, XInputdResetDevice,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x000001EE, XInputdSetRingOfLight,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000001EF, XInputdSetRFPowerMode,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000001F0, XInputdSetRadioFrequency,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000001F1, HidGetLastInputTime,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x000001F2, XAudioRenderDriverInitialize,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000001F3, XAudioRegisterRenderDriverClient,                           kFunction),
XE_EXPORT(xboxkrnl, 0x000001F4, XAudioUnregisterRenderDriverClient,                         kFunction),
XE_EXPORT(xboxkrnl, 0x000001F5, XAudioSubmitRenderDriverFrame,                              kFunction),
XE_EXPORT(xboxkrnl, 0x000001F6, XAudioRenderDriverLock,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x000001F7, XAudioGetVoiceCategoryVolumeChangeMask,                     kFunction),
XE_EXPORT(xboxkrnl, 0x000001F8, XAudioGetVoiceCategoryVolume,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000001F9, XAudioSetVoiceCategoryVolume,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000001FA, XAudioBeginDigitalBypassMode,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000001FB, XAudioEndDigitalBypassMode,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x000001FC, XAudioSubmitDigitalPacket,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x000001FD, XAudioQueryDriverPerformance,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000001FE, XAudioGetRenderDriverThread,                                kFunction),
XE_EXPORT(xboxkrnl, 0x000001FF, XAudioGetSpeakerConfig,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000200, XAudioSetSpeakerConfig,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000201, NicSetUnicastAddress,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000202, NicAttach,                                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000203, NicDetach,                                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000204, NicXmit,                                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000205, NicUpdateMcastMembership,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000206, NicFlushXmitQueue,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000207, NicShutdown,                                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000208, NicGetLinkState,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000209, NicGetStats,                                                kFunction),
XE_EXPORT(xboxkrnl, 0x0000020A, NicGetOpt,                                                  kFunction),
XE_EXPORT(xboxkrnl, 0x0000020B, NicSetOpt,                                                  kFunction),
XE_EXPORT(xboxkrnl, 0x0000020C, DrvSetSysReqCallback,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x0000020D, DrvSetUserBindingCallback,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x0000020E, DrvSetContentStorageCallback,                               kFunction),
XE_EXPORT(xboxkrnl, 0x0000020F, DrvSetAutobind,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000210, DrvGetContentStorageNotification,                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000211, MtpdBeginTransaction,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000212, MtpdCancelTransaction,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000213, MtpdEndTransaction,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000214, MtpdGetCurrentDevices,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000215, MtpdReadData,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000216, MtpdReadEvent,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000217, MtpdResetDevice,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000218, MtpdSendData,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000219, MtpdVerifyProximity,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x0000021A, XUsbcamSetCaptureMode,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x0000021B, XUsbcamGetConfig,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000021C, XUsbcamSetConfig,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000021D, XUsbcamGetState,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x0000021E, XUsbcamReadFrame,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000021F, XUsbcamSnapshot,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000220, XUsbcamSetView,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000221, XUsbcamGetView,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000222, XUsbcamCreate,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000223, XUsbcamDestroy,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000224, XMACreateContext,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000225, XMAInitializeContext,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000226, XMAReleaseContext,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000227, XMAEnableContext,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000228, XMADisableContext,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000229, XMAGetOutputBufferWriteOffset,                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000022A, XMASetOutputBufferReadOffset,                               kFunction),
XE_EXPORT(xboxkrnl, 0x0000022B, XMAGetOutputBufferReadOffset,                               kFunction),
XE_EXPORT(xboxkrnl, 0x0000022C, XMASetOutputBufferValid,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x0000022D, XMAIsOutputBufferValid,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000022E, XMASetInputBuffer0Valid,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x0000022F, XMAIsInputBuffer0Valid,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000230, XMASetInputBuffer1Valid,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000231, XMAIsInputBuffer1Valid,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000232, XMASetInputBuffer0,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000233, XMASetInputBuffer1,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000234, XMAGetPacketMetadata,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000235, XMABlockWhileInUse,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000236, XMASetLoopData,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000237, XMASetInputBufferReadOffset,                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000238, XMAGetInputBufferReadOffset,                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000239, ExIsBetaFeatureEnabled,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000023A, XeKeysGetFactoryChallenge,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x0000023B, XeKeysSetFactoryResponse,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x0000023C, XeKeysInitializeFuses,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x0000023D, XeKeysSaveBootLoader,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x0000023E, XeKeysSaveKeyVault,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x0000023F, XeKeysGetStatus,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000240, XeKeysGeneratePrivateKey,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000241, XeKeysGetKeyProperties,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000242, XeKeysSetKey,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000243, XeKeysGenerateRandomKey,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000244, XeKeysGetKey,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000245, XeKeysGetDigest,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000246, XeKeysGetConsoleID,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000247, XeKeysGetConsoleType,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000248, XeKeysQwNeRsaPrvCrypt,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000249, XeKeysHmacSha,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000024A, XInputdPassThroughRFCommand,                                kFunction),
XE_EXPORT(xboxkrnl, 0x0000024B, XeKeysAesCbc,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x0000024C, XeKeysDes2Cbc,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000024D, XeKeysDesCbc,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x0000024E, XeKeysObscureKey,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000024F, XeKeysHmacShaUsingKey,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000250, XeKeysSaveBootLoaderEx,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000251, XeKeysAesCbcUsingKey,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000252, XeKeysDes2CbcUsingKey,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000253, XeKeysDesCbcUsingKey,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000254, XeKeysObfuscate,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000255, XeKeysUnObfuscate,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000256, XeKeysConsolePrivateKeySign,                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000257, XeKeysConsoleSignatureVerification,                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000258, XeKeysVerifyRSASignature,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000259, StfsCreateDevice,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000025A, StfsControlDevice,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x0000025B, VdSwap,                                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000025C, HalFsbInterruptCount,                                       kVariable),
XE_EXPORT(xboxkrnl, 0x0000025D, XeKeysSaveSystemUpdate,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000025E, XeKeysLockSystemUpdate,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000025F, XeKeysExecute,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000260, XeKeysGetVersions,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000261, XInputdPowerDownDevice,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000262, AniBlockOnAnimation,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000263, AniTerminateAnimation,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000264, XUsbcamReset,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000265, AniSetLogo,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000266, KeCertMonitorData,                                          kVariable),
XE_EXPORT(xboxkrnl, 0x00000267, HalIsExecutingPowerDownDpc,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000268, VdInitializeEDRAM,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000269, VdRetrainEDRAM,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x0000026A, VdRetrainEDRAMWorker,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x0000026B, VdHSIOTrainCount,                                           kVariable),
XE_EXPORT(xboxkrnl, 0x0000026C, HalGetPowerUpCause,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x0000026D, VdHSIOTrainingStatus,                                       kVariable),
XE_EXPORT(xboxkrnl, 0x0000026E, RgcBindInfo,                                                kVariable),
XE_EXPORT(xboxkrnl, 0x0000026F, VdReadEEDIDBlock,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000270, VdEnumerateVideoModes,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000271, VdEnableHDCP,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000272, VdRegisterHDCPNotification,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000273, HidReadMouseChanges,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000274, DumpSetCollectionFacility,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000275, XexTransformImageKey,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000276, XAudioOverrideSpeakerConfig,                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000277, XInputdReadTextKeystroke,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000278, DrvXenonButtonPressed,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000279, DrvBindToUser,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000027A, XexGetModuleImportVersions,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x0000027B, RtlComputeCrc32,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x0000027C, XeKeysSetRevocationList,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x0000027D, HalRegisterPowerDownCallback,                               kFunction),
XE_EXPORT(xboxkrnl, 0x0000027E, VdGetDisplayDiscoveryData,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x0000027F, XInputdSendStayAliveRequest,                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000280, XVoicedSendVPort,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000281, XVoicedGetBatteryStatus,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000282, XInputdFFGetDeviceInfo,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000283, XInputdFFSetEffect,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000284, XInputdFFUpdateEffect,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000285, XInputdFFEffectOperation,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000286, XInputdFFDeviceControl,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000287, XInputdFFSetDeviceGain,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000288, XInputdFFCancelIo,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000289, XInputdFFSetRumble,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x0000028A, NtAllocateEncryptedMemory,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x0000028B, NtFreeEncryptedMemory,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x0000028C, XeKeysExSaveKeyVault,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x0000028D, XeKeysExSetKey,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x0000028E, XeKeysExGetKey,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x0000028F, DrvSetDeviceConfigChangeCallback,                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000290, DrvDeviceConfigChange,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000291, HalRegisterHdDvdRomNotification,                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000292, XeKeysSecurityInitialize,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000293, XeKeysSecurityLoadSettings,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000294, XeKeysSecuritySaveSettings,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000295, XeKeysSecuritySetDetected,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000296, XeKeysSecurityGetDetected,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000297, XeKeysSecuritySetActivated,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000298, XeKeysSecurityGetActivated,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000299, XeKeysDvdAuthAP25InstallTable,                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000029A, XeKeysDvdAuthAP25GetTableVersion,                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000029B, XeKeysGetProtectedFlag,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000029C, XeKeysSetProtectedFlag,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000029D, KeEnablePFMInterrupt,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x0000029E, KeDisablePFMInterrupt,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x0000029F, KeSetProfilerISR,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000002A0, VdStartDisplayDiscovery,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000002A1, VdSetHDCPRevocationList,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000002A2, XeKeysGetUpdateSequence,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000002A3, XeKeysDvdAuthExActivate,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000002A4, KeGetImagePageTableEntry,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000002A5, HalRegisterBackgroundModeTransitionCallback,                kFunction),
XE_EXPORT(xboxkrnl, 0x000002A6, AniStartBootAnimation,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000002A7, HalClampUnclampOutputDACs,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x000002A8, HalPowerDownToBackgroundMode,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000002A9, HalNotifyAddRemoveBackgroundTask,                           kFunction),
XE_EXPORT(xboxkrnl, 0x000002AA, HalCallBackgroundModeNotificationRoutines,                  kFunction),
XE_EXPORT(xboxkrnl, 0x000002AB, HalFsbResetCount,                                           kVariable),
XE_EXPORT(xboxkrnl, 0x000002AC, HalGetMemoryInformation,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000002AD, XInputdGetLastTextInputTime,                                kFunction),
XE_EXPORT(xboxkrnl, 0x000002AE, VdEnableWMAProOverHDMI,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x000002AF, XeKeysRevokeSaveSettings,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000002B0, XInputdSetTextMessengerIndicator,                           kFunction),
XE_EXPORT(xboxkrnl, 0x000002B1, MicDeviceRequest,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000002B2, XeKeysGetMediaID,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000002B3, XeKeysLoadKeyVault,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x000002B4, KeGetVidInfo,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x000002B5, HalNotifyBackgroundModeTransitionComplete,                  kFunction),
XE_EXPORT(xboxkrnl, 0x000002B6, IoAcquireCancelSpinLock,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000002B7, IoReleaseCancelSpinLock,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000002B8, NtCancelIoFile,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x000002B9, NtCancelIoFileEx,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000002BA, HalFinalizePowerLossRecovery,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000002BB, HalSetPowerLossRecovery,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000002BC, ExReadModifyWriteXConfigSettingUlong,                       kFunction),
XE_EXPORT(xboxkrnl, 0x000002BD, HalRegisterXamPowerDownCallback,                            kFunction),
XE_EXPORT(xboxkrnl, 0x000002BE, ExCancelAlarm,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x000002BF, ExInitializeAlarm,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x000002C0, ExSetAlarm,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x000002C1, XexActivationGetNonce,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000002C2, XexActivationSetLicense,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000002C3, IptvSetBoundaryKey,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x000002C4, IptvSetSessionKey,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x000002C5, IptvVerifyOmac1Signature,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000002C6, IptvGetAesCtrTransform,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x000002C7, SataCdRomRecordReset,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x000002C8, XInputdSetTextDeviceKeyLocks,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000002C9, XInputdGetTextDeviceKeyLocks,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000002CA, XexActivationVerifyOwnership,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000002CB, XexDisableVerboseDbgPrint,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x000002CC, SvodCreateDevice,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000002CD, RtlCaptureStackBackTrace,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000002CE, XeKeysRevokeUpdateDynamic,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x000002CF, XexImportTraceEnable,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x000002D0, ExRegisterXConfigNotification,                              kFunction),
XE_EXPORT(xboxkrnl, 0x000002D1, XeKeysSecuritySetStat,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000002D2, VdQueryRealVideoMode,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x000002D3, XexSetExecutablePrivilege,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x000002D4, XAudioSuspendRenderDriverClients,                           kFunction),
XE_EXPORT(xboxkrnl, 0x000002D5, IptvGetSessionKeyHash,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000002D6, VdSetCGMSState,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x000002D7, VdSetSCMSState,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x000002D8, KeFlushMultipleTb,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x000002D9, VdGetOption,                                                kFunction),
XE_EXPORT(xboxkrnl, 0x000002DA, VdSetOption,                                                kFunction),
XE_EXPORT(xboxkrnl, 0x000002DB, UsbdBootEnumerationDoneEvent,                               kVariable),
XE_EXPORT(xboxkrnl, 0x000002DC, StfsDeviceErrorEvent,                                       kVariable),
XE_EXPORT(xboxkrnl, 0x000002DD, ExTryToAcquireReadWriteLockExclusive,                       kFunction),
XE_EXPORT(xboxkrnl, 0x000002DE, ExTryToAcquireReadWriteLockShared,                          kFunction),
XE_EXPORT(xboxkrnl, 0x000002DF, XexSetLastKdcTime,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x000002E0, XInputdControl,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x000002E1, RmcDeviceRequest,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000002E2, LDIResetDecompression,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000002E3, NicRegisterDevice,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x000002E4, UsbdAddDeviceComplete,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000002E5, UsbdCancelAsyncTransfer,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000002E6, UsbdGetDeviceSpeed,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x000002E7, UsbdGetDeviceTopology,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x000002E8, UsbdGetEndpointDescriptor,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x000002E9, UsbdIsDeviceAuthenticated,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x000002EA, UsbdOpenDefaultEndpoint,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000002EB, UsbdOpenEndpoint,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000002EC, UsbdQueueAsyncTransfer,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x000002ED, UsbdQueueCloseDefaultEndpoint,                              kFunction),
XE_EXPORT(xboxkrnl, 0x000002EE, UsbdQueueCloseEndpoint,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x000002EF, UsbdRemoveDeviceComplete,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000002F0, KeRemoveQueueApc,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x000002F1, UsbdDriverLoadRequiredEvent,                                kVariable),
XE_EXPORT(xboxkrnl, 0x000002F2, UsbdGetRequiredDrivers,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x000002F3, UsbdRegisterDriverObject,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000002F4, UsbdUnregisterDriverObject,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x000002F5, UsbdCallAndBlockOnDpcRoutine,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000002F6, UsbdResetDevice,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x000002F7, UsbdGetDeviceDescriptor,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000002F8, NomnilGetExtension,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x000002F9, NomnilStartCloseDevice,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x000002FA, WifiBeginAuthentication,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x000002FB, WifiCheckCounterMeasures,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x000002FC, WifiChooseAuthenCipherSetFromBSSID,                         kFunction),
XE_EXPORT(xboxkrnl, 0x000002FD, WifiCompleteAuthentication,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x000002FE, WifiGetAssociationIE,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x000002FF, WifiOnMICError,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000300, WifiPrepareAuthenticationContext,                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000301, WifiRecvEAPOLPacket,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000302, WifiDeduceNetworkType,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000303, NicUnregisterDevice,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000304, DumpXitThread,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000305, XInputdSetWifiChannel,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000306, NomnilSetLed,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000307, WifiCalculateRegulatoryDomain,                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000308, WifiSelectAdHocChannel,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000309, WifiChannelToFrequency,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000030A, MmGetPoolPagesType,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x0000030B, ExExpansionInstall,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x0000030C, ExExpansionCall,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x0000030D, PsCamDeviceRequest,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x0000030E, McaDeviceRequest,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000030F, DetroitDeviceRequest,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000310, XeCryptSha256Init,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000311, XeCryptSha256Update,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000312, XeCryptSha256Final,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000313, XeCryptSha256,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000314, XeCryptSha384Init,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000315, XeCryptSha384Update,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000316, XInputdGetDevicePid,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000317, HalGetNotedArgonErrors,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000318, XeCryptSha384Final,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000319, HalReadArgonEeprom,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x0000031A, HalWriteArgonEeprom,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x0000031B, XeKeysFcrtLoad,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x0000031C, XeKeysFcrtSave,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x0000031D, XeKeysFcrtSet,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000031E, XeCryptSha384,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000031F, XeCryptSha512Init,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000320, XAudioRegisterRenderDriverMECClient,                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000321, XAudioUnregisterRenderDriverMECClient,                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000322, XAudioCaptureRenderDriverFrame,                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000323, XeCryptSha512Update,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000324, XeCryptSha512Final,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000325, XeCryptSha512,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000326, XeCryptBnQwNeCompare,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000327, XVoicedGetDirectionalData,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000328, DrvSetMicArrayStartCallback,                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000329, DevAuthGetStatistics,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x0000032A, NullCableRequest,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000032B, XeKeysRevokeIsDeviceRevoked,                                kFunction),
XE_EXPORT(xboxkrnl, 0x0000032C, DumpUpdateDumpSettings,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000032D, EtxConsumerDisableEventType,                                kFunction),
XE_EXPORT(xboxkrnl, 0x0000032E, EtxConsumerEnableEventType,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x0000032F, EtxConsumerProcessLogs,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000330, EtxConsumerRegister,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000331, EtxConsumerUnregister,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000332, EtxProducerLog,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000333, EtxProducerLogV,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000334, EtxProducerRegister,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000335, EtxProducerUnregister,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000336, EtxConsumerFlushBuffers,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000337, EtxProducerLogXwpp,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000338, EtxProducerLogXwppV,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000339, UsbdEnableDisableRootHubPort,                               kFunction),
XE_EXPORT(xboxkrnl, 0x0000033A, EtxBufferRegister,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x0000033B, EtxBufferUnregister,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x0000033C, DumpRegisterDedicatedDataBlock,                             kFunction),
XE_EXPORT(xboxkrnl, 0x0000033D, XeKeysDvdAuthExSave,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x0000033E, XeKeysDvdAuthExInstall,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000033F, XexShimDisable,                                             kFunction),
XE_EXPORT(xboxkrnl, 0x00000340, XexShimEnable,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000341, XexShimEntryDisable,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000342, XexShimEntryEnable,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000343, XexShimEntryRegister,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000344, XexShimLock,                                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000345, XboxKrnlVersion4Digit,                                      kVariable),
XE_EXPORT(xboxkrnl, 0x00000346, XeKeysObfuscateEx,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000347, XeKeysUnObfuscateEx,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x00000348, XexTitleHash,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x00000349, XexTitleHashClose,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x0000034A, XexTitleHashContinue,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x0000034B, XexTitleHashOpen,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000034C, XAudioGetRenderDriverTic,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x0000034D, XAudioEnableDucker,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x0000034E, XAudioSetDuckerLevel,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x0000034F, XAudioIsDuckerEnabled,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000350, XAudioGetDuckerLevel,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000351, XAudioGetDuckerThreshold,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000352, XAudioSetDuckerThreshold,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000353, XAudioGetDuckerAttackTime,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000354, XAudioSetDuckerAttackTime,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000355, XAudioGetDuckerReleaseTime,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000356, XAudioSetDuckerReleaseTime,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000357, XAudioGetDuckerHoldTime,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000358, XAudioSetDuckerHoldTime,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x00000359, DevAuthShouldAlwaysEnforce,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x0000035A, XAudioGetUnderrunCount,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000035B, DrvSetAudioLatencyCallback,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x0000035C, XVoicedIsActiveProcess,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000035D, KeExecuteOnProtectedStack,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x0000035E, XeKeysVerifyPIRSSignature,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x0000035F, XeCryptAesCtr,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000360, XeCryptAesCbcMac,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000361, XeCryptAesDmMac,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000362, EmaExecute,                                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000363, XeKeysGetTruncatedSecondaryConsoleId,                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000364, ExFreeDebugPool,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000365, VdQueryVideoCapabilities,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000366, UsbdGetDeviceRootPortType,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000367, VdGet3dVideoFormat,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x00000368, VdGetWSS2Data,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000369, VdSet3dVideoFormat,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x0000036A, VdSetWSS2Data,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x0000036B, XexReserveCodeBuffer,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x0000036C, XexCommitCodeBuffer,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x0000036D, RtlSetVectoredExceptionHandler,                             kFunction),
XE_EXPORT(xboxkrnl, 0x0000036E, RtlClearVectoredExceptionHandler,                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000036F, XAudioSetProcessFrameCallback,                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000370, UsbdGetRootHubDeviceNode,                                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000371, UsbdGetPortDeviceNode,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x00000372, UsbdGetNatalHub,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x00000373, UsbdGetNatalHardwareVersion,                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000374, UsbdNatalHubRegisterNotificationCallback,                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000375, KeCallAndBlockOnDpcRoutine,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000376, KeCallAndWaitForDpcRoutine,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000377, TidDeviceRequest,                                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000378, DmPrintData,                                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000379, VdSetStudioRGBMode,                                         kFunction),
XE_EXPORT(xboxkrnl, 0x0000037A, UsbdTitleDriverResetAllUnrecognizedPorts,                   kFunction),
XE_EXPORT(xboxkrnl, 0x0000037B, UsbdTitleDriverSetUnrecognizedPort,                         kFunction),
XE_EXPORT(xboxkrnl, 0x0000037C, UsbdResetEndpoint,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x0000037D, UsbdSetTimer,                                               kFunction),
XE_EXPORT(xboxkrnl, 0x0000037E, UsbdCancelTimer,                                            kFunction),
XE_EXPORT(xboxkrnl, 0x0000037F, UsbdQueueIsochTransfer,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000380, KeSetPageRelocationCallback,                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000381, XexRegisterUsermodeModule,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000383, TitleDeviceAuthRequest,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x00000384, KeRegisterSwapNotification,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x00000385, XInputdGetFailedConnectionOrBind,                           kFunction),
XE_EXPORT(xboxkrnl, 0x00000386, XInputdSetFailedConnectionOrBindCallback,                   kFunction),
XE_EXPORT(xboxkrnl, 0x00000388, XInputdSetMinMaxAuthDelay,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x00000389, VgcHandler_SetHandlers,                                     kFunction),
XE_EXPORT(xboxkrnl, 0x0000038A, VvcHandlerCancelTransfers,                                  kFunction),
XE_EXPORT(xboxkrnl, 0x0000038B, VvcHandlerRetrieveVoiceExtension,                           kFunction),
XE_EXPORT(xboxkrnl, 0x0000038D, MmResetLowestAvailablePages,                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000394, VeSetHandlers,                                              kFunction),
XE_EXPORT(xboxkrnl, 0x00000395, HalConfigureVeDevice,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000396, XeCryptSha224Init,                                          kFunction),
XE_EXPORT(xboxkrnl, 0x00000397, XeCryptAesCreateKeySchedule,                                kFunction),
XE_EXPORT(xboxkrnl, 0x00000398, XeCryptAesEncryptOne,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x00000399, XeCryptAesDecryptOne,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x0000039A, XeCryptAesCbcEncrypt,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x0000039B, XeCryptAesCbcDecrypt,                                       kFunction),
XE_EXPORT(xboxkrnl, 0x0000039C, XeCryptAesGcmInitialize,                                    kFunction),
XE_EXPORT(xboxkrnl, 0x0000039D, XeCryptAesGcmUpdate,                                        kFunction),
XE_EXPORT(xboxkrnl, 0x0000039E, XeCryptAesGcmFinalize,                                      kFunction),
XE_EXPORT(xboxkrnl, 0x0000039F, XeCryptEccGetCurveParameters,                               kFunction),
XE_EXPORT(xboxkrnl, 0x000003A0, XeCryptEccEcdhGenerateKeypair,                              kFunction),
XE_EXPORT(xboxkrnl, 0x000003A1, XeCryptEccEcdhExponentiate,                                 kFunction),
XE_EXPORT(xboxkrnl, 0x000003A2, XeCryptEccEcdsaGenerateSignature,                           kFunction),
XE_EXPORT(xboxkrnl, 0x000003A3, XeCryptEccEcdsaVerifySignature,                             kFunction),
